_msgs.xml =
[
/* 0  */ "ERROR: No filename present.",
/* 1  */ "ERROR: Bad filename.",
/* 2  */ "ERROR: Multipart Boundary Error.",
/* 3  */ "ERROR: Must specify the filename when exporting to a file.",
/* 4  */ "ERROR: Failed to export XML configuration records.",
/* 5  */ "",
/* 6  */ "ERROR: Must specify the filename when importing from a file.",
/* 7  */ "ERROR: Failed to import XML configuration records.",
/* 8  */ "XML configuration records have been exported to the file {}.",
/* 9  */ "XML configuration records have been imported from the file {}.",
/* 10 */ "ERROR: No Content-Type Header.",
/* 11 */ "ERROR: No Multipart Boundary.",
/* 12 */ "ERROR: Request Timeout.",
/* 13 */ "ERROR: Initial Multipart Boundary Error.",
/* 14 */ "ERROR: Multipart Format Error.",
/* 15 */ "ERROR: No Content-Disposition Header.",
/* 16 */ "ERROR: Parts before selectfile exceed the allowed size.",
/* 17 */ "XML status records have been exported to the file {}.",
/* 18 */ "ERROR: No groups selected for exporting.",
/* 19 */ "ERROR: No groups selected for importing.",
];

function XmlLinesRender(xml)
{
var numSerialPorts = GetXmlData(xml, "numSerialPorts");
var d = document.getElementById('xmllines');
d.innerHTML = '';
var r = '';
{
var columns = 8;
r += "<table class=\"xmlFormGroupTable\">";
r += "<col span=\"" + columns + "\" width=\"120px\">";
var i;
var col = 0;
var twoCols = false;
r += "<tr>";
for(i = 0; i < columns; ++i)
{
r += "<td></td>";
}
r += "</tr>";
for(i = 0; i <= numSerialPorts; ++i)
{
var line = i < numSerialPorts ? i + 1 : 0;
var groupId = "lineselect" + line;
var group = (
line ?



"" + line
: "network"
);
var twoCols = (line == 0);



var nCols = (twoCols ? 2 : 1);
if(col + nCols > columns)
{
col = 0;
r += "</tr>";
}
if(col == 0)
{
r += "<tr>";
}
r += twoCols ? "<td colspan=\"2\">" : "<td>";
r += "<label>";
r += "<input ";
r += "name=\"" + groupId + "\" ";
r += "id=\"" + groupId + "\" ";
r += "type=\"checkbox\" ";
r += "value=\"" + encodeURIComponent(group) + "\" ";
r += "checked ";
r += "/> " + group;
r += "</label>";
r += "</td>";
col += (twoCols ? 2 : 1);
}
r += "</tr>";
r += "</table>";
}
d.innerHTML = r;
}

function XmlSetAllLines(x)
{
for(var i = 0; i <= 2; ++i)
{
var d = document.getElementById("lineselect" + i);
if(d != undefined)
{
d.checked = x;
}
}
}

function XmlSetAllGroups(x)
{
for(var i = 0; ; ++i)
{
var d = document.getElementById('xmlgroup' + i);
if(d == undefined)
{
break;
}
if(x)
{
d.checked = d.defaultChecked;
}
else
{
d.checked = false;
}
}
}

function XmlGroupsRenderCommon(xml, isExportXMLConfig)
{
var d = document.getElementById('xmlgroups');
d.innerHTML = '';
var r = '';
if(! xml || ! xml.hasChildNodes())
{
r += "No XML Groups are available.";
}
else
{
r += "<table class=\"xmlFormGroupTable\">";
var columns = 3;
var i;
for(i = 0; xml && i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
var groupId = node.nodeName.toLowerCase();
var group = node.firstChild.nodeValue;
var isConfigNetwork = (
group == "bridge" ||
(isExportXMLConfig && group.substring(0,7) == "bridge:") ||
group == "interface" ||
(isExportXMLConfig && group.substring(0,10) == "interface:")
);
r += i % columns == 0 ? "<tr>" : "";
r += "<td width=\"" + Math.floor(100 / columns) + "%\">";
r += "<label>";
r += "<input ";
r += "name=\"" + groupId + "\" ";
r += "id=\"" + "xmlgroup" + i + "\" ";
r += "type=\"checkbox\" ";
r += "value=\"" + encodeURIComponent(group) + "\" ";
r += isConfigNetwork ? "unchecked " : "checked ";
r += "/> " + replaceString(group,":", ": ");
r += "</label>";
r += "</td>";
r += i % columns == columns - 1 ? "</tr>" : "";
}
r += i % columns != 0 ? "</tr>" : "";
r += "</table>";
}
d.innerHTML = r;
}

function XmlGroupsRender(xml)
{
XmlGroupsRenderCommon(xml, false);
}

function XmlGroupsRenderForExportConfig(xml)
{
XmlGroupsRenderCommon(xml, true);
}

function UpdateImportDisplay()
{
var form = document.forms[0];
var externalxcr = false;
var filesystem = false;
var linetemplate = false;
for(var i = 0; i < form.importoption.length; ++i)
{
if(form.importoption[i].checked)
{
if(form.importoption[i].value == "externalxcr")
{
externalxcr = true;
}
if(form.importoption[i].value == "filesystem")
{
filesystem = true;
}
if(form.importoption[i].value == "linetemplate")
{
linetemplate = true;
}
}
}
document.getElementById('selectionbuttons').style.display = (
externalxcr || filesystem || linetemplate ? "none" : ""
);
document.getElementById('filesystemtable').style.display = (
filesystem || linetemplate ? "" : "none"
);
document.forms[1].style.display = externalxcr ? "" : "none";
document.getElementById('importfilter_Display').style.display = (
filesystem ? "" : "none"
);
document.getElementById('filesystemheading').innerHTML = (
filesystem ?
"<b>Import configuration from the filesystem:</b>" :
"<b>Import Line(s) from single line settings on the filesystem:</b>"
);
}

function XmlXcrExportPostProcedure()
{
FileSystemMonitor();
return ajax_XmlExportPost(
[true, ajaxGetFormValuesWithoutClearingThem('xmlform')]
);
}

function XmlXsrExportPostProcedure()
{
FileSystemMonitor();
return ajax_XSRExportPost(
[true, ajaxGetFormValuesWithoutClearingThem('xmlform')]
);
}
