function TunnelSocketsRender(xml, optOneBasedConnectInstance)
{
var r = "";
var haveConnection = false;
for(var i = 0; xml && xml.hasChildNodes() && i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
var socketType = "Accept";
if(optOneBasedConnectInstance > 0)
{
socketType = "Connect";
if(16 > 1)
{
socketType += (" " + optOneBasedConnectInstance);
}
}
if(node.nodeName.toLowerCase() == replaceString(socketType.toLowerCase(), " ", "_"))
{
haveConnection = true;
r += "<tr class=\"tunnelHeader\">";
r += "<td colspan=\"2\">";
r += socketType + " Counters ";
r += "[<a ";
r += "href=\"javascript:void(0)\" ";
r += "onclick=\" ";
r += "if (";
r += "confirm('Are you SURE you want to kill this connection?')";
r += ") ajax_TunnelStatsClean(";
r += "[false, document.getElementById('hiddenport').innerHTML, '";
r += replaceString(socketType.toLowerCase(), " ", "_");
r += "']";
r += ");";
r += "return false;";
r += " \" ";
r += ">Kill Connection";
if(16 > 1 && optOneBasedConnectInstance > 0)
{
r += "(s)";
}
r += "</a>]";
r += "</td>";
r += "</tr>";
r += "<tr><td colspan=\"2\"><b>" + GetXmlData(node, "conn") + "</b></td></tr>";
r += "<tr><td><b>Octets forwarded from Serial:</b></td><td>" + GetXmlData(node, "os") + "</td></tr>";
r += "<tr><td><b>Octets forwarded from Network:</b></td><td>" + GetXmlData(node, "on") + "</td></tr>";
r += "<tr><td><b>Uptime:</b></td><td>" + GetXmlData(node, "ut") + "</td></tr>";
if(optOneBasedConnectInstance > 0)
{
r += "<tr><td><b>DNS Address Changes:</b></td><td>" + GetXmlData(node, "cdns") + "</td></tr>";
r += "<tr><td><b>DNS Address Invalids:</b></td><td>" + GetXmlData(node, "idns") + "</td></tr>";
}
}
}
if(! haveConnection)
{
r += "<tr class=\"tunnelHeader\"><td colspan=\"2\">";
r += socketType + " Counters</td></tr>";
r += "<tr><td colspan=\"2\"><b>There is no active connection.</b></td></tr>";
}
return r;
}

function TunnelStatsRender(xml)
{
var d = document.getElementById('statstable');
var r = "<table class=\"basicTable tunnelStatsTable\">";
r += "<tr class=\"tunnelHeader\"><td colspan=\"2\">Aggregate Counters</td></tr>";
for(var i = 0; xml && xml.hasChildNodes() && i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "aggregate")
{
r += "<tr><td><b>Completed Accepts:</b></td><td>" + GetXmlData(node, "ca") + "</td></tr>";
r += "<tr><td><b>Completed Connects:</b></td><td>" + GetXmlData(node, "cc") + "</td></tr>";
r += "<tr><td><b>Disconnects:</b></td><td>" + GetXmlData(node, "d") + "</td></tr>";
r += "<tr><td><b>Dropped Accepts:</b></td><td>" + GetXmlData(node, "da") + "</td></tr>";
r += "<tr><td><b>Dropped Connects:</b></td><td>" + GetXmlData(node, "dc") + "</td></tr>";
r += "<tr><td><b>Octets forwarded from Serial:</b></td><td>" + GetXmlData(node, "os") + "</td></tr>";
r += "<tr><td><b>Octets forwarded from Network:</b></td><td>" + GetXmlData(node, "on") + "</td></tr>";
r += "<tr><td><b>Accept Connection Time:</b></td><td>" + GetXmlData(node, "at") + "</td></tr>";
for(var n = 0; n < 16; ++n)
{
r += "<tr>";
r += "<td><b>";
r += "Connect";
if(16 > 1)
{
r += " " + (n + 1);
}
r += " Connection Time:";
r += "</b></td>";
r += "<td>";
r += GetXmlData(node, "ct" + (16 > 1 ? (n + 1) : ""));
r += "</td>";
r += "</tr>";
}
r += "<tr><td><b>Connect DNS Address Changes:</b></td><td>" + GetXmlData(node, "cdns") + "</td></tr>";
r += "<tr><td><b>Connect DNS Address Invalids:</b></td><td>" + GetXmlData(node, "idns") + "</td></tr>";
}
}
for(var h = 0; h <= 16; ++h)
{
r += TunnelSocketsRender(xml, h);
}
r += "</table>";
d.innerHTML = r;
}

function NibbleToHex(n)
{
return "0123456789abcdef".charAt(n);
}

function CharToHex(c)
{
return NibbleToHex(c >> 4) + NibbleToHex(c & 0xf);
}

function TextToHex(t)
{
var result = "";
for(var i = 0; i < t.length; ++i)
{
result += CharToHex(t.charCodeAt(i));
}
return result;
}

function BuildTunnelAcceptHtml(xml)
{

var d = document.getElementById('tunnel_accept_select_credential');
d.options.length = 0;
d.options[0] = new Option("<Unlisted>", "", true);
for(var i = 0; xml && xml.hasChildNodes() && i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "ssl_credential")
{
var name = GetXmlData(node, "name");
d.options[d.options.length] = new Option(name, name);
}
}
SetFxDisplay(
"select_credential_Display",
d.options.length > 1 ? "" : "none",
true
);

}

function UpdateTunnelAcceptDisplay(initial, optElement)
{
var mode = GetDisplayValue("new_Tunnel_Accept.Accept_Mode");
SetFxDisplay(
"start_character_Display",
mode == "Start Character" ? "" : "none",
initial
);
SetFxDisplay(
"flush_start_character_Display",
mode == "Start Character" ? "" : "none",
initial
);
var prot = GetDisplayValue("new_Tunnel_Accept.Protocol");

SetFxDisplay(
"help_base_ssh_Display",
prot == "SSH" ? "" : "none",
initial
);


SetFxDisplay(
"help_base_ssl_Display",
prot == "SSL" ? "" : "none",
initial
);


SetFxDisplay(
"credentials_Display",
prot == "SSL" ? "" : "none",
initial
);
var credential = GetDisplayValue("new_Tunnel_Accept.Selected_Credential");
SetFxDisplay(
"credentials_selection_Display",
credential == "" ? "" : "none",
initial
);

SetFxDisplay(
"tcp_keep_alive_Display",
(
prot == "SSH" ||
prot == "SSL" ||
prot == "TCP" ||
prot == "TCP AES" ||
prot == "Telnet"
) ? "" : "none",
initial
);
SetFxDisplay(
"aes_encrypt_key_Display",
prot == "TCP AES" ? "" : "none",
initial
);
SetFxDisplay(
"aes_decrypt_key_Display",
prot == "TCP AES" ? "" : "none",
initial
);
{
var v = GetDisplayValue("new_Tunnel_Accept.AES_Encrypt_Key.Value");
SetDisplayValue(
"new_Tunnel_Accept.AES_Encrypt_Key",
GetDisplayValue("new_Tunnel_Accept.AES_Encrypt_Key.Mode") == "Text" ?
TextToHex(v) : v
);
}
{
var v = GetDisplayValue("new_Tunnel_Accept.AES_Decrypt_Key.Value");
SetDisplayValue(
"new_Tunnel_Accept.AES_Decrypt_Key",
GetDisplayValue("new_Tunnel_Accept.AES_Decrypt_Key.Mode") == "Text" ?
TextToHex(v) : v
);
}
var pwd = GetDisplayValue("new_Tunnel_Accept.Password.Password");
SetFxDisplay(
"prompt_for_password_Dislay",
pwd == "<None>" || pwd == "" ? "none" : "",
initial
);
Update(optElement);
}
function SetTunnelAcceptDisplay()
{
displayElementRootNames = new Array();
ShowId('help_base');
SetSubmit(false);
SetDisplaySelection('Tunnel_Accept.Accept_Mode');
SetDisplaySelection('Tunnel_Accept.Start_Character');
SetDisplaySelection('Tunnel_Accept.Flush_Start_Character');
SetDisplaySelection('Tunnel_Accept.Local_Port');
SetDisplaySelection('Tunnel_Accept.Protocol');
var credentialName = SetDisplaySelection('Tunnel_Accept.Credentials');
SetDisplayValue('new_Tunnel_Accept.Selected_Credential', credentialName);
SetDisplaySelection('Tunnel_Accept.TCP_Keep_Alive');
var aes_encrypt = SetDisplaySelection('Tunnel_Accept.AES_Encrypt_Key');
SetDisplayValue('new_Tunnel_Accept.AES_Encrypt_Key.Value', aes_encrypt);
SetDisplayValue('new_Tunnel_Accept.AES_Encrypt_Key.Mode', 'Hexadecimal');
var aes_decrypt = SetDisplaySelection('Tunnel_Accept.AES_Decrypt_Key');
SetDisplayValue('new_Tunnel_Accept.AES_Decrypt_Key.Value', aes_decrypt);
SetDisplayValue('new_Tunnel_Accept.AES_Decrypt_Key.Mode', 'Hexadecimal');
SetDisplaySelection('Tunnel_Accept.Flush_Serial');
SetDisplaySelection('Tunnel_Accept.Block_Serial');
SetDisplaySelection('Tunnel_Accept.Block_Network');
SetDisplaySelection('Tunnel_Accept.Password.Password');
SetDisplaySelection('Tunnel_Accept.Password.Prompt');
{
var s = document.forms[0].elements["new_Tunnel_Accept.Email_Connect"];
s.length = 0;
for(var i = 0; i <= 16; ++i)
{
var d = (i > 0) ? "Email " + i : "<None>";
var v = (i > 0) ? i : "<None>";
s.options[i] = new Option(d, v, false, false);
}
}
SetDisplaySelection('Tunnel_Accept.Email_Connect');
{
var s = document.forms[0].elements["new_Tunnel_Accept.Email_Disconnect"];
s.length = 0;
for(var i = 0; i <= 16; ++i)
{
var d = (i > 0) ? "Email " + i : "<None>";
var v = (i > 0) ? i : "<None>";
s.options[i] = new Option(d, v, false, false);
}
}
SetDisplaySelection('Tunnel_Accept.Email_Disconnect');
UpdateTunnelAcceptDisplay(true);
document.getElementById("tunaccform").style.display = "block";
}
var g_selectedHost = '';
function HostSummary(i)
{
var rc = "";
var address = GetDisplayValue('new_Tunnel_Connect.Host_' + i + '.Address');
var port = GetDisplayValue('new_Tunnel_Connect.Host_' + i + '.Port');
var protocol = GetDisplayValue(
'new_Tunnel_Connect.Host_' + i + '.Protocol'
);
var vip = GetDisplayValue('new_Tunnel_Connect.Host_' + i + '.VIP');
var vipName = GetDisplayValue('new_Tunnel_Connect.Host_' + i + '.VIP_Name');
if(vip == "Enabled")
{
rc += 'VIP ' + (vipName == '' ? '<None>' : vipName);
}
else
{
if(address == '')
{
if(protocol == 'UDP' || protocol == 'UDP AES')
{
address = '&lt;None&gt;';
}
else
{
return;
}
}
rc += address;
}
if(port == '' || port == '<None>')
{
port = '&lt;None&gt;';
}
rc += ':' + port + ', ' + protocol;
if(protocol == 'SSH')
{
rc += ', ' + GetDisplayValue(
'new_Tunnel_Connect.Host_' + i + '.SSH_Username'
);
}
if(protocol == 'SSL')
{
rc += ', ' + GetDisplayValue(
'new_Tunnel_Connect.Host_' + i + '.Credentials'
);
var validateCert = GetDisplayValue(
'new_Tunnel_Connect.Host_' + i + '.Validate_Certificate'
);
if(validateCert == 'Enabled')
{
rc += ', Validate Cert';
}
}
if(
protocol == "SSH" ||
protocol == "SSL" ||
protocol == 'TCP' ||
protocol == 'TCP AES' ||
protocol == 'Telnet'
)
{
var tcpKeepAlive = GetDisplayValue(
'new_Tunnel_Connect.Host_' + i + '.TCP_Keep_Alive'
);
var noTcpKeepAlive = (tcpKeepAlive == '' || tcpKeepAlive == '<None>');
rc += ', ' + (noTcpKeepAlive ? '&lt;None&gt;' : tcpKeepAlive + ' msec');
}
if(protocol == 'TCP AES' || protocol == 'UDP AES')
{
var aesEncryptKey = GetDisplayValue(
'new_Tunnel_Connect.Host_' + i + '.AES_Encrypt_Key'
);
var aesDecryptKey = GetDisplayValue(
'new_Tunnel_Connect.Host_' + i + '.AES_Decrypt_Key'
);
var encryptOkay = aesEncryptKey != '' && aesEncryptKey != '<None>';
var decryptOkay = aesDecryptKey != '' && aesDecryptKey != '<None>';
var isConfigured = encryptOkay && decryptOkay;
var isNone = ! encryptOkay && ! decryptOkay;
rc += ', ' + (
isConfigured ? '&lt;Configured&gt;' :
isNone ? '&lt;None&gt;' : '&lt;Partial&gt;'
);
}
return rc;
}
function UpdateTunnelConnectDisplay(initial, optElement)
{
var usesSsh = false;
var usesSsl = false;
var mode = GetDisplayValue("new_Tunnel_Connect.Connect_Mode");
SetFxDisplay(
"start_character_Display",
mode == "Start Character" ? "" : "none",
initial
);
SetFxDisplay(
"flush_start_character_Display",
mode == "Start Character" ? "" : "none",
initial
);
for(var i = 1; i <= 16; ++i)
{
var v = GetDisplayValue("new_Tunnel_Connect.Host_" + i + ".AES_Encrypt_Key.Value");
SetDisplayValue(
"new_Tunnel_Connect.Host_" + i + ".AES_Encrypt_Key",
GetDisplayValue("new_Tunnel_Connect.Host_" + i + ".AES_Encrypt_Key.Mode") == "Text" ?
TextToHex(v) : v
);
v = GetDisplayValue("new_Tunnel_Connect.Host_" + i + ".AES_Decrypt_Key.Value");
SetDisplayValue(
"new_Tunnel_Connect.Host_" + i + ".AES_Decrypt_Key",
GetDisplayValue("new_Tunnel_Connect.Host_" + i + ".AES_Decrypt_Key.Mode") == "Text" ?
TextToHex(v) : v
);
}
Update(optElement);
var promoteVisible = (fadeInOutSubmit.to == 0);
var numberOfDefinedHosts = 0;
var haveDisplayedEmptyHost = false;
for(var i = 1; i <= 16; ++i)
{
var summary = HostSummary(i);
document.getElementById(
'tunnelConnectHost_' + i + 'Summary'
).innerHTML = summary ? summary : '&lt;None&gt;';
var summaryId = 'tunnelConnectHost_' + i + 'Summary_Display';
var summaryIsVisible = IsFxDisplayVisible(summaryId);
var summaryWillBeVisible = (
(summary || ! haveDisplayedEmptyHost) && g_selectedHost != i
);
if(summaryWillBeVisible)
{
var summaryImmed = (initial || ! summaryIsVisible);
if(i > 1)
{
SetFxDisplay(
'host_' + i + 'SummaryPromoteButton_Display',
summary && promoteVisible ? '' : 'none',
summaryImmed
);
}
}
if(summaryIsVisible != summaryWillBeVisible)
{
SetFxDisplay(
summaryId,
summaryWillBeVisible ? "" : "none",
initial
);
}
if(summary)
{
++numberOfDefinedHosts;
if(summary.indexOf(', UDP') >= 0)
{
haveDisplayedEmptyHost = true;
}
}
else
{
haveDisplayedEmptyHost = true;
}
var prot = GetDisplayValue("new_Tunnel_Connect.Host_" + i + ".Protocol");
if(prot == "SSH")
{
usesSsh = true;
}
if(prot == "SSL")
{
usesSsl = true;
}
var detailId = 'host_' + i + 'detailed_Display';
var detailIsVisible = IsFxDisplayVisible(detailId);
var detailWillBeVisible = (g_selectedHost == i);
if(detailWillBeVisible)
{
var immed = (initial || ! detailIsVisible);
if(i > 1)
{
SetFxDisplay(
'host_' + i + 'AddressPromoteButton_Display',
summary && promoteVisible ? '' : 'none',
immed
);
}
var vip = GetDisplayValue("new_Tunnel_Connect.Host_" + i + ".VIP");
SetFxDisplay(
"host_" + i + "_vip_name_Display",
vip == "Enabled" ? "" : "none",
immed
);
SetFxDisplay(
"host_" + i + "_address_Display",
vip == "Enabled" ? "none" : "",
immed
);
var name = GetDisplayValue("new_Tunnel_Connect.Host_" + i + ".VIP_Selected_Name");
SetFxDisplay(
"host_" + i + "_vip_selection_Display",
name == "" ? "" : "none",
immed
);
SetFxDisplay(
"host_" + i + "_ssh_username_Display",
prot == "SSH" ? "" : "none",
immed
);
var name = GetDisplayValue("new_Tunnel_Connect.Host_" + i + ".SSH_Selected_Name");
SetFxDisplay(
"host_" + i + "_ssh_username_selection_Display",
name == "" ? "" : "none",
immed
);
SetFxDisplay(
"host_" + i + "_ssl_credentials_Display",
prot == "SSL" ? "" : "none",
immed
);
var name = GetDisplayValue("new_Tunnel_Connect.Host_" + i + ".SSL_Selected_Credential");
SetFxDisplay(
"host_" + i + "_ssl_credentials_selection_Display",
name == "" ? "" : "none",
immed
);
SetFxDisplay(
"host_" + i + "_ssl_validate_certificate_Display",
prot == "SSL" ? "" : "none",
immed
);
SetFxDisplay(
"host_" + i + "_tcp_keep_alive_Display",
(
prot == "SSH" ||
prot == "SSL" ||
prot == "TCP" ||
prot == "TCP AES" ||
prot == "Telnet"
) ? "" : "none",
immed
);
SetFxDisplay(
"host_" + i + "_aes_encrypt_key_Display",
(prot == "TCP AES" || prot == "UDP AES") ? "" : "none",
immed
);
SetFxDisplay(
"host_" + i + "_aes_decrypt_key_Display",
(prot == "TCP AES" || prot == "UDP AES") ? "" : "none",
immed
);
}
if(detailIsVisible != detailWillBeVisible)
{
SetFxDisplay(
detailId,
detailWillBeVisible ? "" : "none",
initial
);
}
}
SetFxDisplay("help_base_ssh_Display", usesSsh ? "" : "none", initial);
SetFxDisplay("help_base_ssl_Display", usesSsl ? "" : "none", initial);
SetFxDisplay("help_host_summary_up", numberOfDefinedHosts > 1 ? "" : "none", initial);
SetFxDisplay("help_host_address_up", numberOfDefinedHosts > 1 ? "" : "none", initial);
SetFxDisplay("host_mode_Display", numberOfDefinedHosts > 1 ? "" : "none", initial);
}
function BuildTunnelConnectHtml(xml)
{
var s = "";
for(var i = 0; xml && xml.hasChildNodes() && i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "network_interface")
{
var name = GetXmlData(node, "name");
s += '<option value="' + name + '">' + name + '</option>';
}
}
var ssh = "";
for(var i = 0; xml && xml.hasChildNodes() && i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "ssh_client_user")
{
var name = GetXmlData(node, "name");
ssh += '<option value="' + name + '">' + name + '</option>';
}
}
var ssl = "";
for(var i = 0; xml && xml.hasChildNodes() && i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "ssl_credential")
{
var name = GetXmlData(node, "name");
ssl += '<option value="' + name + '">' + name + '</option>';
}
}
var d = document.getElementById('tunnelConnectFormHtml');
d.innerHTML = '';
var r = '';
r += '<table class="basicTable">';
r += '<tr ';
r += 'onmouseover="ShowId(';
r += "'help_mode'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td width="30%"><b>Mode:</b></td>';
r += '<td>';
r += '<select ';
r += 'name="new_Tunnel_Connect.Connect_Mode"';
r += 'onchange="UpdateTunnelConnectDisplay(false);"';
r += '>';
r += '<option value="Disable">Disable</option>';
r += '<option value="Always">Always</option>';
r += '<option value="Any Character">Any Character</option>';
r += '<option value="Start Character">Start Character</option>';
r += '<option value="Modem Control Asserted">Modem Control Asserted</option>';
r += '<option value="Modem Emulation">Modem Emulation</option>';
r += '</select>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'id="start_character_Display"';
r += 'onmouseover="ShowId(';
r += "'help_start_character'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Start Character:</b></td>';
r += '<td>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Start_Character"';
r += 'type="text" size="10" maxlength="10" value=""';
r += 'onkeyup="Update();"';
r += 'onblur="Update();"';
r += 'onclick="Update();"';
r += '/>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'id="flush_start_character_Display"';
r += 'onmouseover="ShowId(';
r += "'help_flush_start_character'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Flush Start Character:</b></td>';
r += '<td>';
r += '<label>';
r += '<input ';
r += 'onclick="Update();"';
r += 'type="radio" value="Enabled"';
r += 'name="new_Tunnel_Connect.Flush_Start_Character"';
r += '/>Enabled';
r += '</label>';
r += '<label>';
r += '<input ';
r += 'onclick="Update();"';
r += 'type="radio" value="Disabled"';
r += 'name="new_Tunnel_Connect.Flush_Start_Character"';
r += '/>Disabled';
r += '</label>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'onmouseover="ShowId(';
r += "'help_local_port'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Local Port:</b></td>';
r += '<td>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Local_Port"';
r += 'type="text" size="10" maxlength="10" value=""';
r += 'onkeyup="Update();"';
r += 'onblur="Update();"';
r += 'onclick="Update(this);"';
r += '/>';
r += '</td>';
r += '</tr>';
for(var i = 1; i <= 16; ++i)
{
var host = ' ' + i;
r += '<tr id="tunnelConnectHost_' + i + 'Summary_Display"';
r += 'onmouseover="ShowId(';
r += "'help_host_summary'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td';
r += ' onclick="';
r += "g_selectedHost = '';";
r += 'UpdateTunnelConnectDisplay(false);';
r += '"';
r += '>';
r += '<b>Host' + host + ':</b>';
if(i > 1)
{
r += '&nbsp;&nbsp;&nbsp;&nbsp;';
r += '<img ';
r += 'id="host_' + i + 'SummaryPromoteButton_Display"';
r += 'src="/config/up.gif"';
r += 'onclick="';
r += "SetDisplayValue('confirms','');";
r += "confirmPostProcedure = 'TunnelConnectPromoteHostPostProcedure(" + i + ");';";
r += 'TunnelConnectPromoteHostPostProcedure(' + i + ');';
r += '"';
r += '/>';
}
r += '</td>';
r += '<td ';
r += 'onclick="';
r += "g_selectedHost = '" + i + "';";
r += 'UpdateTunnelConnectDisplay(false);';
r += '"';
r += 'id="tunnelConnectHost_' + i + 'Summary"';
r += '>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'id="host_' + i + 'detailed_Display"';
r += '><td colspan="2"><table>';
r += '<tr>';
r += '<td ';
r += 'width="10%"';
r += 'onclick="';
r += "g_selectedHost = '';";
r += 'UpdateTunnelConnectDisplay(false);';
r += '"';
r += '>';
r += '<b>Host' + host + '</b>';
if(i > 1)
{
r += '&nbsp;&nbsp;&nbsp;&nbsp;';
r += '<img ';
r += 'id="host_' + i + 'AddressPromoteButton_Display"';
r += 'src="/config/up.gif"';
r += 'onclick="';
r += "SetDisplayValue('confirms','');";
r += "confirmPostProcedure = 'TunnelConnectPromoteHostPostProcedure(" + i + ");';";
r += 'TunnelConnectPromoteHostPostProcedure(' + i + ');';
r += '"';
r += '/>';
}
r += '</td>';
r += '<td><table class="basicTable">';
r += '<tr ';
r += 'onmouseover="ShowId(';
r += "'help_vip'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>VIP:</b></td>';
r += '<td>';
r += '<label>';
r += '<input ';
r += 'onclick="UpdateTunnelConnectDisplay(false);"';
r += 'name="new_Tunnel_Connect.Host_' + i + '.VIP"';
r += 'type="radio" value="Enabled"';
r += '/>Enabled';
r += '</label>';
r += '<label>';
r += '<input ';
r += 'onclick="UpdateTunnelConnectDisplay(false);"';
r += 'name="new_Tunnel_Connect.Host_' + i + '.VIP"';
r += 'type="radio" value="Disabled"';
r += '/>Disabled';
r += '</label>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'id="host_' + i + '_vip_name_Display"';
r += 'onmouseover="ShowId(';
r += "'help_vip'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td width="30%">';
r += '<b>VIP Name:</b>';
r += '</td>';
r += '<td>';
r += '<table>';
if(s != "")
{
r += '<tr><td>';
r += '<select ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.VIP_Selected_Name"';
r += 'onchange="';
r += "SetDisplayValue('new_Tunnel_Connect.Host_" + i + ".VIP_Name', this.value);";
r += 'UpdateTunnelConnectDisplay(false);';
r += '"';
r += '>';
r += '<option selected="yes" value="">&lt;Unlisted&gt;</option>';
r += s;
r += '</select>';
r += '</td></tr>';
}
r += '<tr id="host_' + i + '_vip_selection_Display"><td>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.VIP_Name"';
r += 'type="text" size="32" maxlength="32" value=""';
r += 'onkeyup="UpdateTunnelConnectDisplay(false);"';
r += 'onblur="UpdateTunnelConnectDisplay(false);"';
r += 'onclick="UpdateTunnelConnectDisplay(false, this);"';
r += '/>';
r += '</td></tr>';
r += '</table>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'id="host_' + i + '_address_Display"';
r += 'onmouseover="ShowId(';
r += "'help_host_address'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td width="30%">';
r += '<b>Address:</b>';
r += '</td>';
r += '<td>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.Address"';
r += 'type="text" size="40" maxlength="50" value=""';
r += 'onkeyup="UpdateTunnelConnectDisplay(false);"';
r += 'onblur="UpdateTunnelConnectDisplay(false);"';
r += 'onclick="UpdateTunnelConnectDisplay(false, this);"';
r += '/>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'onmouseover="ShowId(';
r += "'help_host_port'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Port:</b></td>';
r += '<td>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.Port"';
r += 'type="text" size="8" maxlength="8" value=""';
r += 'onkeyup="UpdateTunnelConnectDisplay(false);"';
r += 'onblur="UpdateTunnelConnectDisplay(false);"';
r += 'onclick="UpdateTunnelConnectDisplay(false, this);"';
r += '/>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'onmouseover="ShowId(';
r += "'help_protocol'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Protocol:</b></td>';
r += '<td>';
r += '<select ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.Protocol"';
r += 'onchange="UpdateTunnelConnectDisplay(false);"';
r += '>';
r += '<option value="SSH">SSH</option>';
r += '<option value="SSL">SSL</option>';
r += '<option value="TCP">TCP</option>';
r += '<option value="TCP AES">TCP AES</option>';
r += '<option value="Telnet">Telnet</option>';
r += '<option value="UDP">UDP</option>';
r += '<option value="UDP AES">UDP AES</option>';
r += '</select>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'id="host_' + i + '_ssh_username_Display"';
r += 'onmouseover="ShowId(';
r += "'help_ssh_username'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>SSH Username:</b></td>';
r += '<td>';
r += '<table>';
if(ssh != "")
{
r += '<tr><td>';
r += '<select ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.SSH_Selected_Name"';
r += 'onchange="';
r += "SetDisplayValue('new_Tunnel_Connect.Host_" + i + ".SSH_Username', this.value);";
r += 'UpdateTunnelConnectDisplay(false);';
r += '"';
r += '>';
r += '<option selected="yes" value="">&lt;Unlisted&gt;</option>';
r += ssh;
r += '</select>';
r += '</td></tr>';
}
r += '<tr id="host_' + i + '_ssh_username_selection_Display"><td>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.SSH_Username"';
r += 'type="text" size="32" maxlength="32" value=""';
r += 'onkeyup="Update();"';
r += 'onblur="Update();"';
r += 'onclick="Update(this);"';
r += '/>';
r += '</td></tr>';
r += '</table>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'id="host_' + i + '_ssl_credentials_Display"';
r += 'onmouseover="ShowId(';
r += "'help_ssl_credentials'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Credentials:</b></td>';
r += '<td>';
r += '<table>';
if(ssl != "")
{
r += '<tr><td>';
r += '<select ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.SSL_Selected_Credential"';
r += 'onchange="';
r += "SetDisplayValue('new_Tunnel_Connect.Host_" + i + ".Credentials', this.value);";
r += 'UpdateTunnelConnectDisplay(false);';
r += '"';
r += '>';
r += '<option selected="yes" value="">&lt;Unlisted&gt;</option>';
r += ssl;
r += '</select>';
r += '</td></tr>';
}
r += '<tr id="host_' + i + '_ssl_credentials_selection_Display"><td>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.Credentials"';
r += 'type="text" size="30" maxlength="30" value=""';
r += 'onkeyup="Update();"';
r += 'onblur="Update();"';
r += 'onclick="Update();"';
r += '/>';
r += '</td></tr>';
r += '</table>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'id="host_' + i + '_ssl_validate_certificate_Display"';
r += 'onmouseover="ShowId(';
r += "'help_ssl_validate_certificate'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Validate Certificate:</b></td>';
r += '<td>';
r += '<label>';
r += '<input ';
r += 'onclick="UpdateTunnelConnectDisplay(false);"';
r += 'name="new_Tunnel_Connect.Host_' + i + '.Validate_Certificate"';
r += 'type="radio" value="Enabled"';
r += '/>Enabled';
r += '</label>';
r += '<label>';
r += '<input ';
r += 'onclick="UpdateTunnelConnectDisplay(false);"';
r += 'name="new_Tunnel_Connect.Host_' + i + '.Validate_Certificate"';
r += 'type="radio" value="Disabled"';
r += '/>Disabled';
r += '</label>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'id="host_' + i + '_tcp_keep_alive_Display"';
r += 'onmouseover="ShowId(';
r += "'help_keep_alive'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>TCP Keep Alive:</b></td>';
r += '<td>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.TCP_Keep_Alive"';
r += 'type="text" size="10" maxlength="10" value=""';
r += 'onkeyup="Update();"';
r += 'onblur="Update();"';
r += 'onclick="Update(this);"';
r += '/> milliseconds';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'id="host_' + i + '_aes_encrypt_key_Display"';
r += 'onmouseover="ShowId(';
r += "'help_aes'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>AES Encrypt Key:</b></td>';
r += '<td>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.AES_Encrypt_Key"';
r += 'type="hidden" size="40" maxlength="256" value=""';
r += '/>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.AES_Encrypt_Key.Value"';
r += 'type="text" size="40" maxlength="256" value=""';
r += 'onkeyup="UpdateTunnelConnectDisplay(false);"';
r += 'onblur="UpdateTunnelConnectDisplay(false);"';
r += 'onclick="UpdateTunnelConnectDisplay(false, this);"';
r += '/>';
r += '<br />';
r += '<label>';
r += '<input ';
r += 'onclick="UpdateTunnelConnectDisplay(false);"';
r += 'name="new_Tunnel_Connect.Host_' + i + '.AES_Encrypt_Key.Mode"';
r += 'type="radio" value="Text"';
r += '/>Text';
r += '</label>';
r += '<label>';
r += '<input ';
r += 'onclick="UpdateTunnelConnectDisplay(false);"';
r += 'name="new_Tunnel_Connect.Host_' + i + '.AES_Encrypt_Key.Mode"';
r += 'type="radio" value="Hexadecimal"';
r += '/>Hexadecimal';
r += '</label>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'id="host_' + i + '_aes_decrypt_key_Display"';
r += 'onmouseover="ShowId(';
r += "'help_aes'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>AES Decrypt Key:</b></td>';
r += '<td>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.AES_Decrypt_Key"';
r += 'type="hidden" size="40" maxlength="256" value=""';
r += '/>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Host_' + i + '.AES_Decrypt_Key.Value"';
r += 'type="text" size="40" maxlength="256" value=""';
r += 'onkeyup="UpdateTunnelConnectDisplay(false);"';
r += 'onblur="UpdateTunnelConnectDisplay(false);"';
r += 'onclick="UpdateTunnelConnectDisplay(false, this);"';
r += '/>';
r += '<br />';
r += '<label>';
r += '<input ';
r += 'onclick="UpdateTunnelConnectDisplay(false);"';
r += 'name="new_Tunnel_Connect.Host_' + i + '.AES_Decrypt_Key.Mode"';
r += 'type="radio" value="Text"';
r += '/>Text';
r += '</label>';
r += '<label>';
r += '<input ';
r += 'onclick="UpdateTunnelConnectDisplay(false);"';
r += 'name="new_Tunnel_Connect.Host_' + i + '.AES_Decrypt_Key.Mode"';
r += 'type="radio" value="Hexadecimal"';
r += '/>Hexadecimal';
r += '</label>';
r += '</td>';
r += '</tr>';
r += '</table></td></tr>';
r += '</table></td></tr>';
}
r += '<tr ';
r += 'id="host_mode_Display"';
r += 'onmouseover="ShowId(';
r += "'help_host_mode'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Host Mode:</b></td>';
r += '<td>';
r += '<label>';
r += '<input ';
r += 'onclick="Update();"';
r += 'name="new_Tunnel_Connect.Host_Mode"';
r += 'type="radio" value="Sequential"';
r += '/>Sequential';
r += '</label>';
r += '<label>';
r += '<input ';
r += 'onclick="Update();"';
r += 'name="new_Tunnel_Connect.Host_Mode"';
r += 'type="radio" value="Simultaneous"';
r += '/>Simultaneous';
r += '</label>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'onmouseover="ShowId(';
r += "'help_reconnect_time'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Reconnect Timer:</b></td>';
r += '<td>';
r += '<input ';
r += 'name="new_Tunnel_Connect.Reconnect_Time"';
r += 'type="text" size="10" maxlength="10" value=""';
r += 'onkeyup="Update();"';
r += 'onblur="Update();"';
r += 'onclick="Update(this);"';
r += '/> milliseconds';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'onmouseover="ShowId(';
r += "'help_flush_serial'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Flush Serial Data:</b></td>';
r += '<td>';
r += '<label>';
r += '<input ';
r += 'onclick="Update();"';
r += 'name="new_Tunnel_Connect.Flush_Serial"';
r += 'type="radio" value="Enabled"';
r += '/>Enabled';
r += '</label>';
r += '<label>';
r += '<input ';
r += 'onclick="Update();"';
r += 'name="new_Tunnel_Connect.Flush_Serial"';
r += 'type="radio" value="Disabled"';
r += '/>Disabled';
r += '</label>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'onmouseover="ShowId(';
r += "'help_block_serial'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Block Serial:</b></td>';
r += '<td>';
r += '<label>';
r += '<input ';
r += 'onclick="Update();"';
r += 'name="new_Tunnel_Connect.Block_Serial"';
r += 'type="radio" value="Enabled"';
r += '/>Enabled';
r += '</label>';
r += '<label>';
r += '<input ';
r += 'onclick="Update();"';
r += 'name="new_Tunnel_Connect.Block_Serial"';
r += 'type="radio" value="Disabled"';
r += '/>Disabled';
r += '</label>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'onmouseover="ShowId(';
r += "'help_block_network'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Block Network:</b></td>';
r += '<td>';
r += '<label>';
r += '<input ';
r += 'onclick="Update();"';
r += 'name="new_Tunnel_Connect.Block_Network"';
r += 'type="radio" value="Enabled"';
r += '/>Enabled';
r += '</label>';
r += '<label>';
r += '<input ';
r += 'onclick="Update();"';
r += 'name="new_Tunnel_Connect.Block_Network"';
r += 'type="radio" value="Disabled"';
r += '/>Disabled';
r += '</label>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'onmouseover="ShowId(';
r += "'help_email_connect'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Email on Connect:</b></td>';
r += '<td>';
r += '<select name="new_Tunnel_Connect.Email_Connect" onchange="Update();">';
r += '</select>';
r += '</td>';
r += '</tr>';
r += '<tr ';
r += 'onmouseover="ShowId(';
r += "'help_email_disconnect'";
r += ');"';
r += 'onmouseout="ShowId(';
r += "'help_base'";
r += ');"';
r += '>';
r += '<td><b>Email on Disconnect:</b></td>';
r += '<td>';
r += '<select name="new_Tunnel_Connect.Email_Disconnect" onchange="Update();">';
r += '</select>';
r += '</td>';
r += '</tr>';
r += '</table>';
d.innerHTML = r;
var d = document.getElementById('currentTunnelConnectHtml');
d.innerHTML = '';
var r = '';
for(var i = 1; i <= 16; ++i)
{
r += '<div id="current_Tunnel_Connect.Host_' + i + '.VIP"></div>';
r += '<div id="current_Tunnel_Connect.Host_' + i + '.VIP_Name"></div>';
r += '<div id="current_Tunnel_Connect.Host_' + i + '.Address"></div>';
r += '<div id="current_Tunnel_Connect.Host_' + i + '.Port"></div>';
r += '<div id="current_Tunnel_Connect.Host_' + i + '.Protocol"></div>';
r += '<div id="current_Tunnel_Connect.Host_' + i + '.SSH_Username"></div>';
r += '<div id="current_Tunnel_Connect.Host_' + i + '.Credentials"></div>';
r += '<div id="current_Tunnel_Connect.Host_' + i + '.Validate_Certificate"></div>';
r += '<div id="current_Tunnel_Connect.Host_' + i + '.TCP_Keep_Alive"></div>';
r += '<div id="current_Tunnel_Connect.Host_' + i + '.AES_Encrypt_Key"></div>';
r += '<div id="current_Tunnel_Connect.Host_' + i + '.AES_Decrypt_Key"></div>';
}
d.innerHTML = r;
}
function SetTunnelConnectDisplay(xml)
{
displayElementRootNames = new Array();
ShowId('help_base');
SetSubmit(false);
SetDisplaySelection('Tunnel_Connect.Connect_Mode');
SetDisplaySelection('Tunnel_Connect.Start_Character');
SetDisplaySelection('Tunnel_Connect.Flush_Start_Character');
SetDisplaySelection('Tunnel_Connect.Local_Port');
for(var i = 1; i <= 16; ++i)
{
SetDisplaySelection('Tunnel_Connect.Host_' + i + '.VIP');
var name = SetDisplaySelection('Tunnel_Connect.Host_' + i + '.VIP_Name');
SetDisplayValue('new_Tunnel_Connect.Host_' + i + '.VIP_Selected_Name', name);
SetDisplaySelection('Tunnel_Connect.Host_' + i + '.Address');
SetDisplaySelection('Tunnel_Connect.Host_' + i + '.Port');
SetDisplaySelection('Tunnel_Connect.Host_' + i + '.Protocol');
var sshName = SetDisplaySelection('Tunnel_Connect.Host_' + i + '.SSH_Username');
SetDisplayValue('new_Tunnel_Connect.Host_' + i + '.SSH_Selected_Name', sshName);
var credentialName = SetDisplaySelection('Tunnel_Connect.Host_' + i + '.Credentials');
SetDisplayValue('new_Tunnel_Connect.Host_' + i + '.SSL_Selected_Credential', credentialName);
SetDisplaySelection('Tunnel_Connect.Host_' + i + '.Validate_Certificate');
SetDisplaySelection('Tunnel_Connect.Host_' + i + '.TCP_Keep_Alive');
var aes_encrypt = SetDisplaySelection('Tunnel_Connect.Host_' + i + '.AES_Encrypt_Key');
SetDisplayValue('new_Tunnel_Connect.Host_' + i + '.AES_Encrypt_Key.Value', aes_encrypt);
SetDisplayValue('new_Tunnel_Connect.Host_' + i + '.AES_Encrypt_Key.Mode', 'Hexadecimal');
var aes_decrypt = SetDisplaySelection('Tunnel_Connect.Host_' + i + '.AES_Decrypt_Key');
SetDisplayValue('new_Tunnel_Connect.Host_' + i + '.AES_Decrypt_Key.Value', aes_decrypt);
SetDisplayValue('new_Tunnel_Connect.Host_' + i + '.AES_Decrypt_Key.Mode', 'Hexadecimal');
}
g_selectedHost = '';
SetDisplaySelection('Tunnel_Connect.Host_Mode');
SetDisplaySelection('Tunnel_Connect.Reconnect_Time');
SetDisplaySelection('Tunnel_Connect.Flush_Serial');
SetDisplaySelection('Tunnel_Connect.Block_Serial');
SetDisplaySelection('Tunnel_Connect.Block_Network');
{
var s = document.forms[0].elements["new_Tunnel_Connect.Email_Connect"];
s.length = 0;
for(var i = 0; i <= 16; ++i)
{
var d = (i > 0) ? "Email " + i : "<None>";
var v = (i > 0) ? i : "<None>";
s.options[i] = new Option(d, v, false, false);
}
}
SetDisplaySelection('Tunnel_Connect.Email_Connect');
{
var s = document.forms[0].elements["new_Tunnel_Connect.Email_Disconnect"];
s.length = 0;
for(var i = 0; i <= 16; ++i)
{
var d = (i > 0) ? "Email " + i : "<None>";
var v = (i > 0) ? i : "<None>";
s.options[i] = new Option(d, v, false, false);
}
}
SetDisplaySelection('Tunnel_Connect.Email_Disconnect');
UpdateTunnelConnectDisplay(true);
document.getElementById("tunconform").style.display = "block";
}
function SetTunnelModemDisplay(xml)
{
displayElementRootNames = new Array();
ShowId('help_base');
SetSubmit(false);
SetDisplaySelection('Tunnel_Modem.Echo_Pluses');
SetDisplaySelection('Tunnel_Modem.Echo_Commands');
SetDisplaySelection('Tunnel_Modem.Verbose_Response');
SetDisplaySelection('Tunnel_Modem.Response_Type');
SetDisplaySelection('Tunnel_Modem.Error_Unknown_Commands');
SetDisplaySelection('Tunnel_Modem.Connect_String');
SetDisplaySelection('Tunnel_Modem.Incoming_Connection');
SetDisplaySelection('Tunnel_Modem.Display_Remote_IP');
document.getElementById("tunmodform").style.display = "block";
}
function SetTunnelSerialDisplay(xml)
{
displayElementRootNames = new Array();
ShowId('help_base');
SetSubmit(false);
SetDisplaySelection('Tunnel_Serial.DTR');
document.getElementById("tunserform").style.display = "block";
}
function UpdateTunnelDisconnectModeDisplay(initial, optElement)
{
var sc = GetDisplayValue('new_Tunnel_Disconnect.Stop_Character');
SetFxDisplay(
"flush_stop_character_Display",
sc == "<None>" || sc == "" ? "none" : "",
initial
);
Update(optElement);
}
function SetTunnelDisconnectDisplay(xml)
{
displayElementRootNames = new Array();
ShowId('help_base');
SetSubmit(false);
SetDisplaySelection('Tunnel_Disconnect.Stop_Character');
SetDisplaySelection('Tunnel_Disconnect.Flush_Stop_Character');
SetDisplaySelection('Tunnel_Disconnect.Modem_Control');
SetDisplaySelection('Tunnel_Disconnect.Timeout');
SetDisplaySelection('Tunnel_Disconnect.Flush_Serial');
UpdateTunnelDisconnectModeDisplay(true);
document.getElementById("tundisform").style.display = "block";
}
function TunnelPackingModeChange(value)
{
SetFxDisplay("tunnel_packing_threshold_Display", value != "Disable" ? "" : "none");
SetFxDisplay("tunnel_packing_timeout_Display", value == "Timeout" ? "" : "none");
SetFxDisplay("tunnel_packing_send_char_Display", value == "Send Character" ? "" : "none");
SetFxDisplay("tunnel_packing_trail_char_Display", value == "Send Character" ? "" : "none");
Update();
}
function SetTunnelPackingDisplay(xml)
{
displayElementRootNames = new Array();
ShowId('help_base');
SetSubmit(false);
var m = SetDisplaySelection('Tunnel_Packing.Packing_Mode');
SetDisplaySelection('Tunnel_Packing.Timeout');
SetDisplaySelection('Tunnel_Packing.Threshold');
SetDisplaySelection('Tunnel_Packing.Send_Character');
SetDisplaySelection('Tunnel_Packing.Trailing_Character');
TunnelPackingModeChange(m);
document.getElementById("tunpackform").style.display = "block";
}
function TunnelRender(xml)
{
var numTunnelPorts = GetXmlData(xml, 'numTunnelPorts');
var port = GetXmlData(xml, 'port');
document.getElementById("hiddenport").innerHTML = port;
document.getElementById("tunnelport").innerHTML = Number(port) + 1;
var d = document.getElementById("tunnel_selection");
if(d)
{
var r = "";
r += '<table id="Nav1">';
r += "<tr>";
if(numTunnelPorts > 4)
{
r += "<td align='right'><b>Select Tunnel:</b></td>";
r += "<td align='left'>";
r += "<";
r += "select name='navSelect' ";
r += "id='navSelect' ";
r += "onchange=";
r += " \" ";
r += "var page = document.getElementById('hiddencurrenttunnelpage').innerHTML;";
r += "return ajax_AddToHistory(page, [true, '1='+this.value]);";
r += " \" ";
r += ">"
for(var i = 0; i < numTunnelPorts; ++i)
{
var sel = (port == i ? " SELECTED " : "");
r += "<option value='" + i + "' " + sel + ">Tunnel " + (i+1) +" </option>";
}
r += "</select>";
r += "</td>";
}
else
{
for(var i = 0; i < numTunnelPorts; ++i)
{
r += "<td id='tunnav" + (i+1) + "'>";
r += "<a ";
r += "href='javascript:void(0)'";
r += "onclick=\"";
r += "var page = document.getElementById('hiddencurrenttunnelpage').innerHTML;";
r += "return ajax_AddToHistory(page, [true, '1=" + i + "']);";
r += "\"";
r += ">";
r += "Tunnel " + (i+1);
r += "</a>";
r += "</td>";
}
}
r += "</tr>";
r += "</table>";
d.innerHTML = r;
HighlightElementInTable("Nav1", "tunnav" + (Number(port)+1));
}
}
function TunnelAcceptConfigPostProcedure()
{
FileSystemMonitor();
return ajax_TunnelAcceptPost(
[
true,
ajaxGetFormValuesWithoutClearingThem('tunaccform') +
'&1=' + document.getElementById('hiddenport').innerHTML
]
);
}
function TunnelConnectConfigPostProcedure()
{
FileSystemMonitor();
return ajax_TunnelConnectPost(
[
true,
ajaxGetFormValuesWithoutClearingThem('tunconform') +
'&1=' + document.getElementById('hiddenport').innerHTML
]
);
}
function TunnelConnectPromoteHostPostProcedure(i)
{
return ajax_TunnelConnectPromoteHost(
[
true,
'1=' + document.getElementById('hiddenport').innerHTML +
'&2=' + i +
'&confirms=' + GetDisplayValue('confirms')
]
);
}
