
function Mib2RowRender(xml, label, tag)
{
return "<tr><td><b>" + label + "</b></td><td>" + GetXmlData(xml, tag) + "</td></tr>";
}

function Mib2MultiRowRender(xml, label, tag)
{
var r = "<tr><td><b>" + label + "</b></td>";

for (i = 0; xml && i < xml.childNodes.length; i++)
{
r += "<td>" + GetXmlData(xml.childNodes[i], tag) + "</td>";
}

r += "</tr>";

return r;
}
function Mib2IfgRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>Interface Group</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2RowRender(xml, "ifNumber", "in");
r += "</table>";
}
d.innerHTML = r;
}
function Mib2IftRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>Interface Table</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2MultiRowRender(xml, "ifIndex", "ii");
r += Mib2MultiRowRender(xml, "ifDescr", "id");
r += Mib2MultiRowRender(xml, "ifType", "it");
r += Mib2MultiRowRender(xml, "ifMtu", "im");
r += Mib2MultiRowRender(xml, "ifSpeed", "is");
r += Mib2MultiRowRender(xml, "ifPhysAddress", "ip");
r += Mib2MultiRowRender(xml, "ifAdminStatus", "ia");
r += Mib2MultiRowRender(xml, "ifOperStatus", "io");
r += Mib2MultiRowRender(xml, "ifLastChange", "il");
r += Mib2MultiRowRender(xml, "ifInOctets", "iio");
r += Mib2MultiRowRender(xml, "ifInUcastPkts", "iiu");
r += Mib2MultiRowRender(xml, "ifInNUcastPkts", "iinu");
r += Mib2MultiRowRender(xml, "ifInDiscards", "iid");
r += Mib2MultiRowRender(xml, "ifInErrors", "iie");
r += Mib2MultiRowRender(xml, "ifInUnknownProtos", "iip");
r += Mib2MultiRowRender(xml, "ifOutOctets", "ioo");
r += Mib2MultiRowRender(xml, "ifOutUcastPkts", "iou");
r += Mib2MultiRowRender(xml, "ifOutNUcastPkts", "ionu");
r += Mib2MultiRowRender(xml, "ifOutDiscards", "iod");
r += Mib2MultiRowRender(xml, "ifOutErrors", "ioe");
r += Mib2MultiRowRender(xml, "ifOutQLen", "ioq");
r += Mib2MultiRowRender(xml, "ifName", "in");
r += Mib2MultiRowRender(xml, "ifInMulticastPkts", "iim");
r += Mib2MultiRowRender(xml, "ifInBroadcastPkts", "iib");
r += Mib2MultiRowRender(xml, "ifOutMulticastPkts", "iom");
r += Mib2MultiRowRender(xml, "ifOutBroadcastPkts", "iob");
r += Mib2MultiRowRender(xml, "ifLinkUpDownTrapEnable", "itr");
r += Mib2MultiRowRender(xml, "ifHighSpeed", "ih");
r += Mib2MultiRowRender(xml, "ifPromiscuousMode", "ipm");
r += Mib2MultiRowRender(xml, "ifConnectorPresent", "icp");
r += Mib2MultiRowRender(xml, "ifAlias", "ial");
r += Mib2MultiRowRender(xml, "ifCounterDiscontinuityTime", "icdt");
r += "</table>";
}
d.innerHTML = r;
}
function Mib2IpgRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>IP Group</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2RowRender(xml, "ipForwarding", "ipf");
r += Mib2RowRender(xml, "ipDefaultTTL", "ipt");
r += Mib2RowRender(xml, "ipInReceives", "ipir");
r += Mib2RowRender(xml, "ipInHdrErrors", "ipih");
r += Mib2RowRender(xml, "ipInAddrErrors", "ipia");
r += Mib2RowRender(xml, "ipForwDatagrams", "ipfd");
r += Mib2RowRender(xml, "ipInUnknownProtos", "ipup");
r += Mib2RowRender(xml, "ipInDiscards", "ipid");
r += Mib2RowRender(xml, "ipInDelivers", "ipidl");
r += Mib2RowRender(xml, "ipOutRequests", "ipor");
r += Mib2RowRender(xml, "ipOutDiscards", "ipod");
r += Mib2RowRender(xml, "ipOutNoRoutes", "ipnr");
r += Mib2RowRender(xml, "ipReasmTimeout", "iprt");
r += Mib2RowRender(xml, "ipReasmReqds", "iprr");
r += Mib2RowRender(xml, "ipReasmOKs", "ipro");
r += Mib2RowRender(xml, "ipReasmFails", "iprf");
r += Mib2RowRender(xml, "ipFragOKs", "ipfo");
r += Mib2RowRender(xml, "ipFragFails", "ipff");
r += Mib2RowRender(xml, "ipFragCreates", "ipfc");
r += Mib2RowRender(xml, "ipRoutingDiscards", "iprd");
r += "</table>";
}
d.innerHTML = r;
}
function Mib2IpatRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>IP Address Table</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2MultiRowRender(xml, "ipAdEntAddr", "ipa");
r += Mib2MultiRowRender(xml, "ipAdEntIfIndex", "ipii");
r += Mib2MultiRowRender(xml, "ipAdEntNetMask", "ipim");
r += Mib2MultiRowRender(xml, "ipAdEntBcastAddr", "ipba");
r += Mib2MultiRowRender(xml, "ipAdEntReasmMaxSize", "iprs");
r += "</table>";
}
d.innerHTML = r;
}
function Mib2IpmtRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>IP Net To Media Table</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2MultiRowRender(xml, "ipNetToMediaIfIndex", "ipif");
r += Mib2MultiRowRender(xml, "ipNetToMediaNetPhysAddress", "ippa");
r += Mib2MultiRowRender(xml, "ipNetToMediaNetAddress", "ipa");
r += Mib2MultiRowRender(xml, "ipNetToMediaType", "ipt");
r += "</table>";
}
d.innerHTML = r;
}
function Mib2IcmpgRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>ICMP Group</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2RowRender(xml, "icmpInMsgs", "iim");
r += Mib2RowRender(xml, "icmpInErrors", "iie");
r += Mib2RowRender(xml, "icmpInDestUnreachs", "iidu");
r += Mib2RowRender(xml, "icmpInTimeExcds", "iite");
r += Mib2RowRender(xml, "icmpInParmProbs", "iipp");
r += Mib2RowRender(xml, "icmpInSrcQuenchs", "iisq");
r += Mib2RowRender(xml, "icmpInRedirects", "iir");
r += Mib2RowRender(xml, "icmpInEchos", "iiec");
r += Mib2RowRender(xml, "icmpInEchoReps", "iiecr");
r += Mib2RowRender(xml, "icmpInTimestamps", "iits");
r += Mib2RowRender(xml, "icmpInTimestampReps", "iitsr");
r += Mib2RowRender(xml, "icmpInAddrMasks", "iiam");
r += Mib2RowRender(xml, "icmpInAddrMaskReps", "iiamr");
r += Mib2RowRender(xml, "icmpInDroppedStateOff", "iid");
r += Mib2RowRender(xml, "icmpOutMsgs", "iom");
r += Mib2RowRender(xml, "icmpOutErrors", "ioe");
r += Mib2RowRender(xml, "icmpOutDestUnreachs", "iodu");
r += Mib2RowRender(xml, "icmpOutTimeExcds", "iote");
r += Mib2RowRender(xml, "icmpOutParmProbs", "iopp");
r += Mib2RowRender(xml, "icmpOutSrcQuenchs", "iosq");
r += Mib2RowRender(xml, "icmpOutRedirects", "ior");
r += Mib2RowRender(xml, "icmpOutEchos", "ioec");
r += Mib2RowRender(xml, "icmpOutEchoReps", "ioecr");
r += Mib2RowRender(xml, "icmpOutTimestamps", "iots");
r += Mib2RowRender(xml, "icmpOutTimestampReps", "iotsr");
r += Mib2RowRender(xml, "icmpOutAddrMasks", "ioam");
r += Mib2RowRender(xml, "icmpOutAddrMaskReps", "ioamr");
r += Mib2RowRender(xml, "icmpOutDroppedStateOff", "iod");
r += "</table>";
}
d.innerHTML = r;
}
function Mib2IpfgRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>IP Forward Group</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2RowRender(xml, "ipCidrRouteNumber", "icrn");
r += "</table>";
}
d.innerHTML = r;
}
function Mib2IpftRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>IP Forward Table</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2MultiRowRender(xml, "ipCidrRouteDest", "icrd");
r += Mib2MultiRowRender(xml, "ipCidrRouteMask", "icrm");
r += Mib2MultiRowRender(xml, "ipCidrRouteTos", "icrtos");
r += Mib2MultiRowRender(xml, "ipCidrRouteNextHop", "icrn");
r += Mib2MultiRowRender(xml, "ipCidrRouteIfIndex", "icrif");
r += Mib2MultiRowRender(xml, "ipCidrRouteType", "icrt");
r += Mib2MultiRowRender(xml, "ipCidrRouteProto", "icrp");
r += Mib2MultiRowRender(xml, "ipCidrRouteAge", "icra");
r += Mib2MultiRowRender(xml, "ipCidrRouteInfo", "icri");
r += Mib2MultiRowRender(xml, "ipCidrRouteNextHopAS", "icrnas");
r += Mib2MultiRowRender(xml, "ipCidrRouteMetric1", "icrm1");
r += Mib2MultiRowRender(xml, "ipCidrRouteMetric2", "icrm2");
r += Mib2MultiRowRender(xml, "ipCidrRouteMetric3", "icrm3");
r += Mib2MultiRowRender(xml, "ipCidrRouteMetric4", "icrm4");
r += Mib2MultiRowRender(xml, "ipCidrRouteMetric5", "icrm5");
r += "</table>";
}
d.innerHTML = r;
}
function Mib2TcpgRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>TCP Group</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2RowRender(xml, "tcpRtoAlgorithm", "talg");
r += Mib2RowRender(xml, "tcpRtoMin", "trtomn");
r += Mib2RowRender(xml, "tcpRtoMax", "trtomx");
r += Mib2RowRender(xml, "tcpMaxConn", "tmaxc");
r += Mib2RowRender(xml, "tcpActiveOpens", "tao");
r += Mib2RowRender(xml, "tcpPassiveOpens", "tpo");
r += Mib2RowRender(xml, "tcpAttemptFails", "taf");
r += Mib2RowRender(xml, "tcpEstabResets", "ter");
r += Mib2RowRender(xml, "tcpCurrEstab", "tce");
r += Mib2RowRender(xml, "tcpInSegs", "tis");
r += Mib2RowRender(xml, "tcpOutSegs", "tos");
r += Mib2RowRender(xml, "tcpRetransSegs", "trs");
r += Mib2RowRender(xml, "tcpInErrs", "tie");
r += Mib2RowRender(xml, "tcpOutRsts", "tor");
r += Mib2RowRender(xml, "tcpInRsts", "tir");
r += "</table>";
}
d.innerHTML = r;
}
function Mib2TcptRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>TCP Connection Table</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2MultiRowRender(xml, "tcpConnState", "tcs");
r += Mib2MultiRowRender(xml, "tcpConnLocalAddress", "tcla");
r += Mib2MultiRowRender(xml, "tcpConnLocalPort", "tclp");
r += Mib2MultiRowRender(xml, "tcpConnRemAddress", "tcra");
r += Mib2MultiRowRender(xml, "tcpConnRemPort", "tcrp");
r += "</table>";
}
d.innerHTML = r;
}
function Mib2UdpgRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>UDP Group</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2RowRender(xml, "udpInDatagrams", "uid");
r += Mib2RowRender(xml, "udpNoPorts", "unp");
r += Mib2RowRender(xml, "udpInErrors", "uie");
r += Mib2RowRender(xml, "udpOutDatagrams", "uod");
r += "</table>";
}
d.innerHTML = r;
}
function Mib2UdptRender(xml)
{
var d = document.getElementById('mib2data');
var r = '<h2>UDP Table</h2>';
if (!xml || !xml.hasChildNodes())
{
r += "No MIB data is available.";
}
else
{
r += "<table class=\"basicTable\">";
r += Mib2MultiRowRender(xml, "udpLocalAddress", "ula");
r += Mib2MultiRowRender(xml, "udpLocalPort", "ulp");
r += "</table>";
}
d.innerHTML = r;
}
