
/*
* This file offers some very nice javascript effects for use within
* an AJAX based web application.  See http://moofx.mad4milk.net for
* demos and details on how to use this APIs.
*/

/*
Prototype JavaScript framework
(c) 2005 Sam Stephenson <sam@conio.net>
Prototype is freely distributable under the terms of an MIT-style license.
For details, see the Prototype web site: http://prototype.conio.net/
note: this is a stripped down version of prototype, to be used with moo.fx
by mad4milk (http://moofx.mad4milk.net).
*/

var Class = {
create: function() {
return function() {
this.initialize.apply(this, arguments);
}
}
}

Object.extend = function(destination, source) {
for (property in source) {
destination[property] = source[property];
}
return destination;
}

Function.prototype.bind = function(object) {
var __method = this;
return function() {
return __method.apply(object, arguments);
}
}

function $() {
var elements = new Array();

for (var i = 0; i < arguments.length; i++) {
var element = arguments[i];
if (typeof element == 'string')
element = document.getElementById(element);

if (arguments.length == 1)
return element;

elements.push(element);
}

return elements;
}

//-------------------------

document.getElementsByClassName = function(className) {
var children = document.getElementsByTagName('*') || document.all;
var elements = new Array();

for (var i = 0; i < children.length; i++) {
var child = children[i];
var classNames = child.className.split(' ');
for (var j = 0; j < classNames.length; j++) {
if (classNames[j] == className) {
elements.push(child);
break;
}
}
}

return elements;
}

//-------------------------

if (!window.Element) {
var Element = new Object();
}

Object.extend(Element, {
remove: function(element) {
element = $(element);
element.parentNode.removeChild(element);
},

hasClassName: function(element, className) {
element = $(element);
if (!element)
return;
var a = element.className.split(' ');
for (var i = 0; i < a.length; i++) {
if (a[i] == className)
return true;
}
return false;
},

addClassName: function(element, className) {
element = $(element);
Element.removeClassName(element, className);
element.className += ' ' + className;
},

removeClassName: function(element, className) {
element = $(element);
if (!element)
return;
var newClassName = '';
var a = element.className.split(' ');
for (var i = 0; i < a.length; i++) {
if (a[i] != className) {
if (i > 0)
newClassName += ' ';
newClassName += a[i];
}
}
element.className = newClassName;
},

// removes whitespace-only text node children
cleanWhitespace: function(element) {
element = $(element);
for (var i = 0; i < element.childNodes.length; i++) {
var node = element.childNodes[i];
if (node.nodeType == 3 && !/\S/.test(node.nodeValue))
Element.remove(node);
}
}
});

/*
moo.fx, simple effects library built with prototype.js (http://prototype.conio.net).
by Valerio Proietti (http://mad4milk.net) MIT-style LICENSE.
for more info (http://moofx.mad4milk.net).
10/24/2005
v(1.0.2)
*/

//base
var fx = new Object();
fx.Base = function(){};
fx.Base.prototype = {
setOptions: function(options) {
this.options = {
duration: 500,
onComplete: ''
}
Object.extend(this.options, options || {});
},

go: function() {
this.duration = this.options.duration;
this.startTime = (new Date).getTime();
this.timer = setInterval (this.step.bind(this), 13);
},

step: function() {
var time = (new Date).getTime();
var Tpos = (time - this.startTime) / (this.duration);
if (time >= this.duration+this.startTime) {
this.now = this.to;
clearInterval (this.timer);
this.timer = null;
if (this.options.onComplete){
setTimeout(this.options.onComplete.bind(this), 10);
}
}
else {
this.now = Tpos * (this.to - this.from) + this.from;
}
this.increase();
},

custom: function(from, to) {
if(this.timer != null){
clearInterval(this.timer);
this.timer = null;
}
this.from = from;
this.to = to;
this.go();
},

hide: function() {
this.now = 0;
this.to = 0;
this.increase();
},

show: function() {
this.now = 1;
this.to = 1;
this.increase();
},

clearTimer: function() {
if(this.timer != null){
clearInterval(this.timer);
}
this.timer = null;
}
}

//stretchers
fx.Layout = Class.create();
fx.Layout.prototype = Object.extend(new fx.Base(), {
initialize: function(el, options) {
this.el = $(el);
this.el.style.overflow = "hidden";
this.el.iniWidth = this.el.offsetWidth;
this.el.iniHeight = this.el.offsetHeight;
this.setOptions(options);
}
});

fx.Height = Class.create();
Object.extend(Object.extend(fx.Height.prototype, fx.Layout.prototype), {
increase: function() {
this.el.style.height = this.now + "px";
},

toggle: function() {
if (this.el.offsetHeight > 0) this.custom(this.el.offsetHeight, 0);
else this.custom(0, this.el.scrollHeight);
}
});

fx.Width = Class.create();
Object.extend(Object.extend(fx.Width.prototype, fx.Layout.prototype), {
increase: function() {
this.el.style.width = this.now + "px";
},

toggle: function(){
if (this.el.offsetWidth > 0) this.custom(this.el.offsetWidth, 0);
else this.custom(0, this.el.iniWidth);
}
});

//fader
fx.Opacity = Class.create();
fx.Opacity.prototype = Object.extend(new fx.Base(), {
initialize: function(el, options) {
this.el = $(el);
this.now = 1;
this.increase();
this.setOptions(options);
},

increase: function() {
if (this.now == 1) this.now = 0.9999;
if (this.el.length > 1){
if (this.now > 0 && this.el[0].style.display == "none"){
this.el[0].style.display = "";
}
if (this.now == 0) this.el[0].style.display = "none";
for(var i = 0; i < this.el.length; ++i){
if (this.el[i].style!=undefined){
if (window.ActiveXObject){
this.el[i].style.filter = "alpha(opacity=" + this.now*100 + ")";
}
this.el[i].style.opacity = this.now;
}
}
}else{
if (this.now > 0 && this.el.style.display == "none"){
this.el.style.display = "";
}
if (this.now == 0) this.el.style.display = "none";
if (window.ActiveXObject){
this.el.style.filter = "alpha(opacity=" + this.now*100 + ")";
}
this.el.style.opacity = this.now;
}
},

toggle: function() {
if (this.now > 0) this.custom(1, 0);
else this.custom(0, 1);
}
});

/*
moo.fx pack, effects extensions for moo.fx.
by Valerio Proietti (http://mad4milk.net) MIT-style LICENSE
for more info (http://moofx.mad4milk.net).
10/25/2005
v1.0
*/

//text size modify, works with ems only
fx.Text = Class.create();
Object.extend(Object.extend(fx.Text.prototype, fx.Layout.prototype), {
increase: function() {
this.el.style.fontSize = this.now + "em";
}
});

//composition effect, calls Width and Height alltogheter
fx.Resize = Class.create();
fx.Resize.prototype = {
initialize: function(el, options) {
this.h = new fx.Height(el, options);
options.onComplete = null;
this.w = new fx.Width(el, options);
this.el = $(el);
},

toggle: function(){
this.h.toggle();
this.w.toggle();
},

modify: function(hto, wto) {
this.h.custom(this.el.offsetHeight, this.el.offsetHeight + hto);
this.w.custom(this.el.offsetWidth, this.el.offsetWidth + wto);
},

custom: function(hto, wto) {
this.h.custom(this.el.offsetHeight, hto);
this.w.custom(this.el.offsetWidth, wto);
},

hide: function(){
this.h.hide();
this.w.hide();
}
}

//composition effect, calls Opacity and (Width and/or Height) alltogheter
fx.FadeSize = Class.create();
fx.FadeSize.prototype = {
initialize: function(el, options) {
this.el = $(el);
this.el.o = new fx.Opacity(el, options);
this.el.h = new fx.Height(el, options);
this.el.w = new fx.Width(el, options);
options.onComplete = null;
},

toggle: function() {
this.el.o.toggle();
for (var i = 0; i < arguments.length; i++) {
if (arguments[i] == 'height') this.el.h.toggle();
if (arguments[i] == 'width') this.el.w.toggle();
}
},

hide: function(){
this.el.o.hide();
for (var i = 0; i < arguments.length; i++) {
if (arguments[i] == 'height') this.el.h.hide();
if (arguments[i] == 'width') this.el.w.hide();
}
}
}

//intended to work with arrays.
var Multi = new Object();
Multi = function(){};
Multi.prototype = {
initialize: function(elements, options){
this.options = options;
this.el = this.getElementsFromArray(elements);
for (i=0;i<this.el.length;i++){
this.effect(this.el[i]);
}
},

getElementsFromArray: function(array) {
var elements = new Array();
for (i=0;i<array.length;i++) {
elements.push($(array[i]));
}
return elements;
}
}

//Fadesize with arrays
fx.MultiFadeSize = Class.create();
fx.MultiFadeSize.prototype = Object.extend(new Multi(), {
effect: function(el){
el.fs = new fx.FadeSize(el, this.options);
},

showThisHideOpen: function(el, delay, mode){
for (i=0;i<this.el.length;i++){
if (this.el[i].offsetHeight > 0 && this.el[i] != el && this.el[i].h.timer == null && el.h.timer == null){
this.el[i].fs.toggle(mode);
setTimeout(function(){el.fs.toggle(mode);}.bind(el), delay);
}

}
},

hide: function(el, mode){
el.fs.hide(mode);
}
});

var forceApplyButtonToBeVisible = false;
var forceSubmitButtonToBeVisible = false;

function IsApplyButtonForcedToBeVisible()
{
return forceApplyButtonToBeVisible;
}

function IsSubmitButtonForcedToBeVisible()
{
return forceSubmitButtonToBeVisible;
}

function SetButtonVisibilities(xml)
{
if(xml && xml.hasChildNodes)
{
for(var i = 0; i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "state")
{
forceApplyButtonToBeVisible = (
GetXmlData(node, "changes") == "pending"
);
forceSubmitButtonToBeVisible = (
GetXmlData(node, "flash") == "unsaved"
);
}
}
}
}
var fxArray;
function InitializeSubmitButton(xml)
{
fxArray = new Array();
SetButtonVisibilities(xml);
if(document.getElementById('apply_button'))
{
fadeInOutApply = new fx.Opacity('apply_button', {duration: 1000});
if(! forceApplyButtonToBeVisible)
{
fadeInOutApply.hide();
}
}
if(document.getElementById('submit_button'))
{
fadeInOutSubmit = new fx.Opacity('submit_button', {duration: 1000});
if(! forceSubmitButtonToBeVisible)
{
fadeInOutSubmit.hide();
}
}
if(document.getElementById('reassert_button'))
{
fadeInOutReassert = new fx.Opacity('reassert_button', {duration: 1000});
fadeInOutReassert.hide();
}
if(document.getElementById('test_button'))
{
fadeInOutTest = new fx.Opacity('test_button', {duration: 1000});
fadeInOutTest.hide();
}
}

function PushHierarchical(elements, element)
{
elements.push(element);
for (var i = 0; i < element.childNodes.length; i++) {
PushHierarchical(elements,element.childNodes[i]);
}
}

function SetFxDisplay(id, setting, init)
{
if(fxArray==undefined)fxArray = new Array();
var fh = fxArray[id];
if(fh==undefined){
var element = document.getElementById(id);
var elements = new Array();
PushHierarchical(elements, element);
fh = new fx.Opacity(elements.length > 1 ? elements : element, {duration: 1000});
if(setting != ''){
fh.hide();
}
fxArray[id]= fh;
}else if(init){
fh.clearTimer();
if(setting == ''){
fh.show();
}else{
fh.hide();
}
}else{
fh.clearTimer();
fh.custom(fh.now, setting == '' ? 1 : 0);
}
}

function IsFxDisplayVisible(id)
{
if(fxArray==undefined)fxArray = new Array();
var fh = fxArray[id];
return fh == undefined ? true : (fh.now > 0);
}
