
window.ajaxHistory =
{
/////////////////////////////////////////////////// private

// Our hash of key name/values.
storageHash: new Object(),

// Our current hash location, without the "#" symbol.
currentLocation: null,

// Our history change listener.
listener: null,

// A hidden IFrame we use in Internet Explorer to detect history changes.
iframe: null,

// Indicates to the browser whether to ignore location changes.
ignoreLocationChange: null,

// The amount of time in milliseconds that we should wait between add requests.
// Firefox is okay with 200 ms, but Internet Explorer needs 400.
WAIT_TIME: 200,

// The amount of time in milliseconds an add request has to wait in line before
// being run on a window.setTimeout.
currentWaitTime: 0,

// A flag that indicates that we should fire a history change event when we
// are ready, i.e. after we are initialized and we have a history change
// listener. This is needed due to an edge case in browsers other than
// Internet Explorer; if you leave a page entirely then return, we must fire
// this as a history change event. Unfortunately, we have lost all
// references to listeners from earlier, because JavaScript clears out.
fireOnNewListener: null,

// A variable that indicates whether this is the first time this page has
// been loaded. If you go to a web page, leave it for another one, and then
// return, the page's onload listener fires again. We need a way to
// differentiate between the first page load and subsequent ones.  This
// variable works hand in hand with the pageLoaded variable we store into
// historyStorage.
firstLoad: null,

// A variable to handle an important edge case in Internet Explorer. In IE,
// if a user manually types an address into their browser's location bar, we
// must intercept this by continiously checking the location bar with an
// timer interval. However, if we manually change the location bar ourselves
// programmatically, when using our hidden iframe, we need to ignore these
// changes. Unfortunately, these changes are not atomic, so we surround them
// with the variable 'ieAtomicLocationChange', that if true, means we are
// programmatically setting the location and should ignore this atomic
// chunked change.
ieAtomicLocationChange: null,

// relative location of iehack.html page
ieHackPage: null,

// Determines if this is Internet Explorer.
isInternetExplorer: function()
{
return (document.all && (navigator.userAgent.toLowerCase().indexOf('msie') != -1)) ? true : false;
},

isFirstLoad: function()
{
return (this.firstLoad == true) ? true : false;
},

// Removes any leading hash that might be on a location.
removeHash: function(hashValue)
{
if ((hashValue == null) || (hashValue == undefined))
{
return null;
}
else if ((hashValue == "") ||
((hashValue.length == 1) && (hashValue.charAt(0) == "#")))
{
return "";
}
else if ((hashValue.length > 1) && (hashValue.charAt(0) == "#"))
{
return hashValue.substring(1);
}
else
{
return hashValue;
}
},

getCurrentData: function()
{
return this.storageHash[this.getCurrentLocation()];
},

getCurrentLocation: function()
{
return this.removeHash(window.location.hash);
},

create: function()
{
// get our initial location
var initialHash = this.getCurrentLocation();

// save this as our current location
this.currentLocation = initialHash;

// write out a hidden iframe for IE and
// set the amount of time to wait between add() requests
if (this.isInternetExplorer())
{
document.write("<iframe style='border: 0px; width: 1px; "
+ "height: 1px; position: absolute; bottom: 0px; "
+ "right: 0px; visibility: visible;' "
+ "name='ajaxHistoryFrame' id='ajaxHistoryFrame' "
+ "src='" + this.ieHackPage + "?" + initialHash + "'>"
+ "</iframe>");

// wait 400 milliseconds between history
// updates on IE, versus 200 on Firefox
this.WAIT_TIME = 400;
}

// add an unload listener for the page; this is needed for Firefox 1.5+
// because this browser caches all dynamic updates to the page, which can
// break some of our logic related to testing whether this is the first
// instance a page has loaded or whether it is being pulled from the
// cache
var self = this;
window.onunload = function()
{
self.firstLoad = null;
};

// determine if this is our first page load; for Internet Explorer, we do
// this in this.iframeLoaded(), which is fired on page load. We do it
// there because we have no historyStorage at this point in IE, which
// only exists after the page is finished loading for that browser
if (this.isInternetExplorer() == false)
{
if (!this.storageHash["ajaxHistory_pageLoaded"])
{
this.ignoreLocationChange = true;
this.firstLoad = true;
this.storageHash["ajaxHistory_pageLoaded"] = true;
}
else
{
// indicate that we want to pay attention to this location change
this.ignoreLocationChange = false;

// For browser's other than IE, fire a history change event; on IE,
// the event will be thrown automatically when it's hidden iframe
// reloads on page load.  Unfortunately, we don't have any
// listeners yet; indicate that we want to fire an event when a
// listener is added.
this.fireOnNewListener = true;
}
}
else
{
// the iframe will get loaded on page load so ignore this fact
this.ignoreLocationChange = true;
}

if (this.isInternetExplorer())
{
this.iframe = document.getElementById("ajaxHistoryFrame");
}

// other browsers can use a location handler that checks at regular
// intervals as their primary mechanism; we use it for Internet
// Explorer as well to handle an important edge case; see
// checkLocation() for details
var self = this;
var locationHandler = function()
{
self.checkLocation();
};

setInterval(locationHandler, 100);
},

// Notify the listener of new history changes.
fireHistoryEvent: function(newHash)
{
// call our listener
this.listener.call(null, newHash, this.storageHash[newHash]);
},

// Sees if the browsers has changed location.  This is the primary history
// mechanism for Firefox. For Internet Explorer, we use this to handle an
// important edge case: if a user manually types in a new hash value into
// their Internet Explorer location bar and press enter, we want to
// intercept this and notify any history listener.
checkLocation: function()
{
// ignore any location changes that we made ourselves for browsers other
// than Internet Explorer
if ((this.isInternetExplorer() == false) &&
(this.ignoreLocationChange == true))
{
this.ignoreLocationChange = false;
return;
}

// if we are dealing with Internet Explorer and we are in the middle of
// making a location change from an iframe, ignore it
if ((this.isInternetExplorer() == false) &&
(this.ieAtomicLocationChange == true))
{
return;
}

// get hash location
var hash = this.getCurrentLocation();

// see if there has been a change
if (hash == this.currentLocation)
{
return;
}

// on Internet Explorer, we need to intercept users manually entering
// locations into the browser; we do this by comparing the browsers
// location against the iframes location; if they differ, we are
// dealing with a manual event and need to place it inside our history,
// otherwise we can return
this.ieAtomicLocationChange = true;

if (this.isInternetExplorer() && (this.getIFrameHash() != hash))
{
this.iframe.src = this.ieHackPage + "?" + hash;
}
else if (this.isInternetExplorer())
{
// the iframe is unchanged
return;
}

// save this new location
this.currentLocation = hash;

this.ieAtomicLocationChange = false;

// notify listeners of the change
this.fireHistoryEvent(hash);
},

// Gets the current location of the hidden IFrames that is stored as
// history. For Internet Explorer.
getIFrameHash: function()
{
// get the new location
var historyFrame = document.getElementById("ajaxHistoryFrame");
var doc = historyFrame.contentWindow.document;
var hash = new String(doc.location.search);

if ((hash.length == 1) && (hash.charAt(0) == "?"))
{
hash = "";
}
else if ((hash.length >= 2) && (hash.charAt(0) == "?"))
{
hash = hash.substring(1);
}

return hash;
},

// For IE, says when the hidden iframe has finished loading.
iframeLoaded: function(newLocation)
{
// ignore any location changes that we made ourselves
if (this.ignoreLocationChange == true)
{
this.ignoreLocationChange = false;
return;
}

// get the new location
var hash = new String(newLocation.search);
if ((hash.length == 1) && (hash.charAt(0) == "?"))
{
hash = "";
}
else if ((hash.length >= 2) && (hash.charAt(0) == "?"))
{
hash = hash.substring(1);
}

// move to this location in the browser location bar if we are not
// dealing with a page load event
if (this.pageLoadEvent != true)
{
window.location.hash = hash;
}

// notify listeners of the change
this.fireHistoryEvent(hash);
},

////////////////////////////////////////// public

initialize: function(ieHackPage)
{
this.ieHackPage = ieHackPage;

// only Internet Explorer needs to be explicitly initialized;
// other browsers don't have its particular behaviors.
// Basicly, IE doesn't autofill form data until the page
// is finished loading, which means historyStorage won't
// work until onload has been fired.
if (this.isInternetExplorer() == false)
{
return;
}

// if this is the first time this page has loaded...
if (!this.storageHash["ajaxHistory_pageLoaded"])
{
this.fireOnNewListener = false;
this.firstLoad = true;
this.storageHash["ajaxHistory_pageLoaded"] = true;
}
// else if this is a fake onload event
else
{
this.fireOnNewListener = true;
this.firstLoad = false;
}
},

addListener: function(callback)
{
this.listener = callback;

// if the page was just loaded fire and event
if (this.fireOnNewListener == true)
{
this.fireHistoryEvent(this.currentLocation);
this.fireOnNewListener = false;
}
},

add: function(newLocation, historyData)
{
// most browsers require that we wait a certain amount of time before changing the
// location, such as 200 milliseconds; rather than forcing external callers to use
// window.setTimeout to account for this to prevent bugs, we internally handle this
// detail by using a 'currentWaitTime' variable and have requests wait in line
var self = this;
var addImpl = function()
{
// indicate that the current wait time is now less
if (self.currentWaitTime > 0)
{
self.currentWaitTime = self.currentWaitTime - self.WAIT_TIME;
}

// remove any leading hash symbols on newLocation
newLocation = self.removeHash(newLocation);

// IE has a strange bug; if the newLocation
// is the same as _any_ preexisting id in the
// document, then the history action gets recorded
// twice; throw a programmer exception if there is
// an element with this ID
var idCheck = document.getElementById(newLocation);
if ((idCheck != undefined) || (idCheck != null))
{
var message = "ERROR: History locations can not have the same value as any ID's that might be in the document. The following ID has a conflict: " + newLocation;
throw message;
}

// store the history data into history storage
self.storageHash[newLocation] = historyData;

// indicate to the browser to ignore this upcomming
// location change
self.ignoreLocationChange = true;

// indicate to IE that this is an atomic location change
// block
self.ieAtomicLocationChange = true;

// save this as our current location
self.currentLocation = newLocation;

// change the browser location
window.location.hash = newLocation;

// change the hidden iframe's location if on IE
if (self.isInternetExplorer())
{
self.iframe.src = self.ieHackPage + "?" + newLocation;
}

// end of atomic location change block
// for IE
self.ieAtomicLocationChange = false;
};

// now execute this add request after waiting a certain amount of time,
// so as to queue up requests
window.setTimeout(addImpl, this.currentWaitTime);

// indicate that the next request will have to wait for awhile
this.currentWaitTime = this.currentWaitTime + this.WAIT_TIME;
}
};

// Initialize the ajaxHistory object
window.ajaxHistory.create();

//test
var postData;


function Ajax()
{
this.workId = 'ajaxWork' + new Date().getTime();
this.depth = 0;

this.TARGET = 0;
this.ATTR = 1;
this.DATA = 2;
this.SEARCH = 3;
this.TYPE = 4;
this.MAX = (this.TYPE + 1);

this.windowWidth = 0;
this.windowHeight = 0;

this.windowSize = function()
{
if (typeof(window.innerWidth) == 'number')
{
// Non-IE
this.windowWidth = window.innerWidth;
this.windowHeight = window.innerHeight;
}
else if (document.documentElement &&
(document.documentElement.clientWidth ||
document.documentElement.clientHeight))
{
// IE 6+ in 'standards compliant mode'
this.windowWidth = document.documentElement.clientWidth;
this.windowHeight = document.documentElement.clientHeight;
}
else if (document.body &&
(document.body.clientWidth ||
document.body.clientHeight))
{
// IE 4 compatible
this.windowWidth = document.body.clientWidth;
this.windowHeight = document.body.clientHeight;
}
}

this.getRequestObject = function()
{
var xmlreq = false;

if (window.XMLHttpRequest)
{
xmlreq = new XMLHttpRequest();
if (xmlreq.overrideMimeType)
{
xmlreq.overrideMimeType('text/xml');
}
}
else if (window.ActiveXObject)
{
try
{
xmlreq = new ActiveXObject("Msxml2.XMLHTTP");
}
catch(e)
{
try
{
xmlreq = new ActiveXObject("Microsoft.XMLHTTP");
}
catch(e)
{
}
}
}

if (!xmlreq)
{
alert('ERROR: Cannot create an XmlHttp instance.');
return false;
}

return xmlreq;
}

this.clearFormValues = function(formId)
{
var objForm = document.getElementById(formId);
var str = "";

if (objForm && objForm.tagName == 'FORM')
{
var formElements = objForm.elements;

for (var i = 0; i < formElements.length; i++)
{
if (formElements[i].type == 'submit')
{
continue;
}
else if ((formElements[i].type == 'radio') ||
(formElements[i].type == 'checkbox'))
{
formElements[i].checked = false;
}
else
{
formElements[i].value = '';
}
}
}

return str;
}

this.getFormValues = function(formId)
{
var objForm = document.getElementById(formId);
var str = "";

if (objForm && objForm.tagName == 'FORM')
{
var formElements = objForm.elements;

for (var i = 0; i < formElements.length; i++)
{
if (((formElements[i].type == 'radio') ||
(formElements[i].type == 'checkbox')) &&
(formElements[i].checked == false))
{
continue;
}

var name = formElements[i].name;

if (name)
{
if (str != "")
{
str += '&';
}

str += name + "=" + encodeURIComponent(formElements[i].value);
}
}
}

return str;
}


this.call = function(sFunction, queryArray)
{
var r;
var i;
var uri;

if (document.body)
{
document.body.style.cursor = 'wait';
}

var icon = document.getElementById("activity_icon");
if (icon)
{
this.windowSize();

/*
* The AJAX activity GIF being used is 128x128 pixels in size.  If
* the image ever changes then this code should be changed too.
*/

icon.style.top = Math.round((this.windowHeight / 2) - 64) + "px";
icon.style.left = Math.round((this.windowWidth / 2) - 64) + "px";

icon.style.display = "block";
}

uri = ajaxUri;

postData = "ajax=" + encodeURIComponent(sFunction);

if (queryArray)
{
if (queryArray[0] == true)
{
postData = postData + "&" + queryArray[1];
}
else
{
for (i = 1; i < queryArray.length; i++)
{
postData = postData + "&" + i + "=" + encodeURIComponent(queryArray[i]);
}
}
}

this.prepReq(uri);
return false;
}

this.prepReq = function(uri){

var r = this.getRequestObject();
r.open("POST", uri, true);

try
{
//r.setRequestHeader("Method", "POST " + uri );
r.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

}
catch(e)
{
alert("ERROR: Your browser does not support asynchronous POST requests.");
return false;
}

r.onreadystatechange = function()
{

var responseStatus;
try
{
responseStatus = r.status;
}
catch(e)
{
responseStatus = 0;
}
//alert("State : " + r.readyState + " Status : " + responseStatus);
if (r.readyState == 4)
{

if (responseStatus == 200)
{
if (r.responseXML)
{
ajax.processResponse(r.responseXML);
}
}
else if(responseStatus == 301 || responseStatus == 307)
{
var locationHeader = r.getResponseHeader("Location");
if(locationHeader)
{
ajax.prepReq(locationHeader);
}
return false;
}
else
{
alert("ERROR: There was a problem with the request (Status " + responseStatus + ")");
return false;
}
var activityIconNone = function()
{
document.body.style.cursor = 'default';

var icon = document.getElementById("activity_icon");
if (icon)
{
icon.style.display = "none";
}
};

window.setTimeout(activityIconNone, 500);
}
//else{alert("r.readyState : " + r.readyState + " r.responseXML : " + r.responseXML);}
}

r.send(postData);
delete r;
}

this.willChange = function(target, attribute, newData)
{
var oldData;
var tmp;

if (attribute == "innerHTML")
{
tmp = document.getElementById(this.workId);

if (tmp == null)
{
tmp = document.createElement("div");
tmp.setAttribute('id', this.workId);
tmp.style.display = "none";
tmp.style.visibility = "hidden";
document.body.appendChild(tmp);
}

tmp.innerHTML = newData;
newData = tmp.innerHTML;
}

eval("oldData = document.getElementById('" + target + "')." + attribute);

if (newData != oldData)
{
return true;
}

return false;
}

this.getXmlValues = function(node, vals, raw)
{
vals[this.TARGET] = "";
vals[this.ATTR] = "";
vals[this.DATA] = "";
vals[this.SEARCH] = "";
vals[this.TYPE] = "";

node.normalize();

for (j = 0; j < node.childNodes.length ; j++)
{
if ((node.childNodes[j].nodeName == "target") && node.childNodes[j].firstChild)
{
vals[this.TARGET] = node.childNodes[j].firstChild.nodeValue;
}
else if ((node.childNodes[j].nodeName == "attribute") && node.childNodes[j].firstChild)
{
vals[this.ATTR] = node.childNodes[j].firstChild.nodeValue;
}
else if ((node.childNodes[j].nodeName == "data") && node.childNodes[j].firstChild)
{
vals[this.DATA] =
(raw) ? node.childNodes[j] :
node.childNodes[j].firstChild.nodeValue;
}
else if ((node.childNodes[j].nodeName == "search") && node.childNodes[j].firstChild)
{
vals[this.SEARCH] = node.childNodes[j].firstChild.nodeValue;
}
else if ((node.childNodes[j].nodeName == "type") && node.childNodes[j].firstChild)
{
vals[this.TYPE] = node.childNodes[j].firstChild.nodeValue;
}
}
}

this.processResponse = function(xml)
{
if(xml==null)return;
var vals = new Array(this.MAX);

xml = xml.documentElement;

for (i = 0; i < xml.childNodes.length; i++)
{
if (xml.childNodes[i].nodeName == "alert")
{
if (xml.childNodes[i].firstChild)
{
alert(xml.childNodes[i].firstChild.nodeValue);
}
}
else if (xml.childNodes[i].nodeName == "xml")
{
this.getXmlValues(xml.childNodes[i].firstChild, vals, true);
eval(vals[this.TARGET] + "(vals[this.DATA]);");
}
else if (xml.childNodes[i].nodeName == "script")
{
this.getXmlValues(xml.childNodes[i], vals, false);

//alert("Loading new javascript for " + vals[this.TARGET]);

/*
* IE doesn't evaluate javascript code into the global space
* so check for IE here and call the execScript function to
* put the code in the global space.
*/
if(window.execScript)
{
window.execScript(vals[this.DATA]);
window.execScript("window." + vals[this.TARGET] + " = true;");
}
else
{
window.eval(vals[this.DATA]);
window.setTimeout(vals[this.DATA], 0);
window.eval("window." + vals[this.TARGET] + " = true;");
}
}
else if (xml.childNodes[i].nodeName == "assign")
{
this.getXmlValues(xml.childNodes[i], vals, false);

if (this.willChange(vals[this.TARGET], vals[this.ATTR], vals[this.DATA]))
{
eval("document.getElementById('" + vals[this.TARGET] + "')." + vals[this.ATTR] + " = vals[this.DATA];");
}
}
else if (xml.childNodes[i].nodeName == "append")
{
this.getXmlValues(xml.childNodes[i], vals, false);
eval("document.getElementById('" + vals[this.TARGET] + "')." + vals[this.ATTR] + " += vals[this.DATA];");
}
else if (xml.childNodes[i].nodeName == "prepend")
{
this.getXmlValues(xml.childNodes[i], vals, false);
eval("document.getElementById('" + vals[this.TARGET] + "')." + vals[this.ATTR] + " = vals[this.DATA] + document.getElementById('" + vals[this.TARGET] + "')." + vals[this.ATTR]);
}
else if (xml.childNodes[i].nodeName == "clear")
{
this.getXmlValues(xml.childNodes[i], vals, false);
eval("document.getElementById('" + vals[this.TARGET] + "')." + vals[this.ATTR] + " = '';");
}
else if (xml.childNodes[i].nodeName == "clearTBody")
{
this.getXmlValues(xml.childNodes[i], vals, false);
var tb = eval("document.getElementById('" + vals[this.TARGET] + "')");
while (tb.rows.length)
{
tb.deleteRow(0);
}
}
else if (xml.childNodes[i].nodeName == "addRowTBody")
{
this.getXmlValues(xml.childNodes[i], vals, false);
var tr = eval("document.getElementById('" + vals[this.TARGET] + "').insertRow(-1)");
tr.id = vals[this.ATTR];
}
else if (xml.childNodes[i].nodeName == "addColTBody")
{
this.getXmlValues(xml.childNodes[i], vals, false);
var td = eval("document.getElementById('" + vals[this.TARGET] + "').insertCell(-1)");
eval("td." + vals[this.ATTR] + " = vals[this.DATA]");
}
else if (xml.childNodes[i].nodeName == "remove")
{
this.getXmlValues(xml.childNodes[i], vals, false);
objElement = document.getElementById(vals[this.TARGET]);

if (objElement.parentNode && objElement.parentNode.removeChild)
{
objElement.parentNode.removeChild(objElement);
}
}
else if (xml.childNodes[i].nodeName == "replace")
{
this.getXmlValues(xml.childNodes[i], vals, false);
eval("var v = document.getElementById('" + vals[this.TARGET] +"')." + vals[this.ATTR]);
var v2 = v.indexOf(search) == -1 ? v : "";

while (v.indexOf(vals[this.SEARCH]) > -1)
{
x = v.indexOf(vals[this.SEARCH]) + vals[this.SEARCH].length + 1;
v2 += v.substr(0, x).replace(vals[this.SEARCH],data);
v = v.substr(x, v.length - x);
}

if (this.willChange(v[this.TARGET], v[this.ATTR], v2))
{
eval('document.getElementById("' + v[this.ATTR] + '").' + v[this.ATTR] + ' = v2;');
}
}
else if (xml.childNodes[i].nodeName == "create")
{
this.getXmlValues(xml.childNodes[i], vals, false);
var objParent = document.getElementById(vals[this.TARGET]);
objElement = document.createElement(vals[this.ATTR]);
objElement.setAttribute('id', vals[this.DATA]);

if (vals[this.TYPE] && vals[this.TYPE] != '')
{
objElement.setAttribute('type', vals[this.TYPE]);
}

objParent.appendChild(objElement);
if (objParent.tagName == "FORM")
{
}
}
}
}
}

var ajax = new Ajax();

function ajaxClearFormValues(formId)
{
return ajax.clearFormValues(formId);
}

function ajaxGetFormValuesWithoutClearingThem(formId)
{
return ajax.getFormValues(formId);
}

function ajaxGetFormValues(formId)
{
var str = ajax.getFormValues(formId);
ajaxClearFormValues(formId);
return str;
}

function ajaxHistoryChange(page, queryArray)
{
eval("ajax_" + page + "(queryArray);");
}

function ajax_AddToHistory(page, queryArray)
{
ajaxHistoryChange(page, queryArray);
ajaxHistory.add(page, queryArray);
return false;
}

function ajaxHistoryInitialize() // (ieHackPage, page, [queryArray])
{
ajaxHistory.initialize(Array.apply(null,arguments)[0]);
ajaxHistory.addListener(ajaxHistoryChange);

if (ajaxHistory.isFirstLoad() && Array.apply(null,arguments)[1])
{
ajax_AddToHistory(Array.apply(null,arguments)[1], Array.apply(null,arguments).slice(2));
}
}
