_msgs.sshclient =
[
/* 0  */ "ERROR: Must specify a Server name and at least one Public Key file.",
/* 1  */ "ERROR: Invalid RSA Public Key file.",
/* 2  */ "ERROR: Invalid DSA Public Key file.",
/* 3  */ "ERROR: Failed to save the SSH Client Known Host RSA Key.",
/* 4  */ "The new SSH Client Known Host RSA Key has been saved.",
/* 5  */ "ERROR: Failed to save the SSH Client Known Host DSA Key.",
/* 6  */ "The new SSH Client Known Host DSA Key has been saved.",
/* 7  */ "ERROR: Server name not specified.",
/* 8  */ "ERROR: Key Type not specified.",
/* 9  */ "ERROR: Failed to delete the RSA Key.",
/* 10 */ "ERROR: Failed to delete the DSA Key.",
/* 11 */ "ERROR: Unknown Key Type.",
/* 12 */ "ERROR: Must specify the Username.",
/* 13 */ "ERROR: Must specify the Key Type.",
/* 14 */ "ERROR: Invalid value for the Key Type.",
/* 15 */ "ERROR: Must specify the Bit Size.",
/* 16 */ "ERROR: Invalid value for the Bit Size.",
/* 17 */ "ERROR: Must specify a Username.",
/* 18 */ "ERROR: Must specify a Password and/or Key files.",
/* 19 */ "ERROR: Must specify both Private and Public Key files.",
/* 20 */ "ERROR: Must specify a Key Type.",
/* 21 */ "ERROR: Invalid Private Key file.",
/* 22 */ "ERROR: Invalid Public Key file.",
/* 23 */ "ERROR: Invalid RSA Private Key file.",
/* 24 */ "ERROR: Invalid DSA Private Key file.",
/* 25 */ "Added the User {}.",
/* 26 */ "ERROR: Failed to save the User.",
/* 27 */ "Updated the User {}.",
/* 28 */ "ERROR: User not specified.",
/* 29 */ "The Known Host {} has been deleted.",
/* 30 */ "The RSA Key for {} has been deleted.",
/* 31 */ "The DSA Key for {} has been deleted.",
/* 32 */ "ERROR: Failed to generate the new {} Keys for {}.",
/* 33 */ "The new {} Keys for {} have been generated and saved.",
/* 34 */ "The User {} has been deleted.",
/* 35 */ "The Remote Command for {} has been deleted.",
/* 36 */ "The RSA Key for {} has been deleted.",
/* 37 */ "The DSA Key for {} has been deleted.",
/* 38 */ "ERROR: Key bit size is too large. Maximum size is {}.",
/* 39 */ "All users have been deleted.",
/* 40 */ "All known hosts have been deleted.",
];

function SshServerKeysRender(xml)
{
SshServerKeysClearForm();
var d = document.getElementById('sshdata');
d.innerHTML = '';

var r = '';

var keyDeleteStartHref = " [<a href=\"javascript:void(0)\" onclick=\"if (confirm('Are you SURE you want to delete this infomation?')) ajax_SshServerKeysClean([true, 'key=";
var keyDeleteEndHref = "']); return false;\">Delete Key</a>]";

var keyViewStartHref = " [<a href=\"/sshserverkey?key=";
var keyViewEndHref = "\" target=\"_blank\">View Key</a>]";

var rsa = GetXmlBool(xml, "r");
var dsa = GetXmlBool(xml, "d");

r += "<table class=\"basicTable sshTable\">";

r += "<tr><td><b>Public RSA Key:</b></td><td>";
r += (!rsa) ?
"No RSA Key Configured" :
keyViewStartHref + "rsa" + keyViewEndHref + keyDeleteStartHref + "rsa" + keyDeleteEndHref;
r += "</td></tr>";

r += "<tr><td><b>Public DSA Key:</b></td><td>";
r += (!dsa) ?
"No DSA Key Configured" :
keyViewStartHref + "dsa" + keyViewEndHref + keyDeleteStartHref + "dsa" + keyDeleteEndHref;
r += "</td></tr>";

r += "</table>";

d.innerHTML = r;
}

function SshServerKeysClearForm()
{
var p;
var oldInput;
var newInput;

document.getElementById('keytypersa').checked = false;
document.getElementById('keytypedsa').checked = false;

p = document.getElementById('privkeyfileparent');
oldInput = document.getElementById('privkeyfile');
newInput = document.createElement('input');
newInput.id = 'privkeyfile';
newInput.name = 'privkey';
newInput.type = 'file';
newInput.size = '32';
newInput.maxlength = '255';
p.replaceChild(newInput, oldInput);

p = document.getElementById('pubkeyfileparent');
oldInput = document.getElementById('pubkeyfile');
newInput = document.createElement('input');
newInput.id = 'pubkeyfile';
newInput.name = 'pubkey';
newInput.type = 'file';
newInput.size = '32';
newInput.maxlength = '255';
p.replaceChild(newInput, oldInput);

document.getElementById('keytype_rsa').checked = false;
document.getElementById('keytype_dsa').checked = false;
document.getElementById('bits_512').checked = false;
document.getElementById('bits_768').checked = false;
document.getElementById('bits_1024').checked = false;
}

function SshServerAuthUsersRender(xml)
{
SshServerAuthUsersClearForm();
var d = document.getElementById('sshdata');
d.innerHTML = '';

var r = '';
var numUsers = 0;

var userDeleteStartHref = " [<a href=\"javascript:void(0)\" onclick=\"if (confirm('Are you SURE you want to delete the infomation?')) ajax_SshServerAuthUsersClean([true, 'user=";
var userDeleteEndHref = "']); return false;\">Delete ";

var userViewStartHref = " [<a href=\"/sshserveruser?user=";
var userViewEndHref = "\" target=\"_blank\">View Key</a>]";

for(var i = 0; xml && i < xml.childNodes.length; i++)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "u")
{
var name = GetXmlData(node, "n");
if(! name)
{
continue;
}
numUsers++;
var password = GetXmlBool(node, "p");
var rsa = GetXmlBool(node, "r");
var dsa = GetXmlBool(node, "d");

r += "<table class=\"basicTable sshTable\">";

r += "<tr><td><b>User:</b></td><td>" + name + userDeleteStartHref + encodeURIComponent(name) + "&amp;action=userdelete" + userDeleteEndHref + " User</a>]</td></tr>";

r += "<tr><td><b>Password:</b></td><td>";
r += (password) ? "Configured" : "Not Configured";
r += "</td></tr>";

r += "<tr><td><b>Public RSA Key:</b></td><td>";
r += (!rsa) ?
"No RSA Key Configured" :
userViewStartHref + encodeURIComponent(name) + "&amp;key=rsa" + userViewEndHref + userDeleteStartHref + encodeURIComponent(name) + "&amp;key=rsa&amp;action=userkeydelete" + userDeleteEndHref + " Key</a>]";
r += "</td></tr>";

r += "<tr><td><b>Public DSA Key:</b></td><td>";
r += (!dsa) ?
"No DSA Key Configured" :
userViewStartHref + encodeURIComponent(name) + "&amp;key=dsa" + userViewEndHref + userDeleteStartHref + encodeURIComponent(name) + "&amp;key=dsa&amp;action=userkeydelete" + userDeleteEndHref + " Key</a>]";
r += "</td></tr>";

r += "</table>";
}
}
if(numUsers == 0)
{
d.innerHTML = "No Authorized Users are currently configured for the SSH Server.<br/>";
}
else if(numUsers == 1)
{
d.innerHTML = r;
}
else
{
var p = '';
p += userDeleteStartHref + "all&amp;action=deleteall" + userDeleteEndHref + " All</a>]";
p += "<br/>";
d.innerHTML = p + r;
}
}

function SshServerAuthUsersClearForm()
{
var p;
var oldInput;
var newInput;

document.getElementById('usernametext').value = ''
document.getElementById('passwordtext').value = '';

p = document.getElementById('rsakeyfileparent');
oldInput = document.getElementById('rsakeyfile');
newInput = document.createElement('input');
newInput.id = 'rsakeyfile';
newInput.name = 'rsakey';
newInput.type = 'file';
newInput.size = '32';
newInput.maxlength = '255';
p.replaceChild(newInput, oldInput);

p = document.getElementById('dsakeyfileparent');
oldInput = document.getElementById('dsakeyfile');
newInput = document.createElement('input');
newInput.id = 'dsakeyfile';
newInput.name = 'dsakey';
newInput.type = 'file';
newInput.size = '32';
newInput.maxlength = '255';
p.replaceChild(newInput, oldInput);
}

function SshClientKnownHostsRender(xml)
{
SshClientKnownHostsClearForm();
var d = document.getElementById('sshdata');
d.innerHTML = '';

var r = '';
var numHosts = 0;

var hostDeleteStartHref = " [<a href=\"javascript:void(0)\" onclick=\"if (confirm('Are you SURE you want to delete the infomation?')) ajax_SshClientKnownHostsClean([true, 'server=";
var hostDeleteEndHref = "']); return false;\">Delete ";

var hostViewStartHref = " [<a href=\"/sshclienthost?server=";
var hostViewEndHref = "\" target=\"_blank\">View Key</a>]";

for(var i = 0; xml && i < xml.childNodes.length; i++)
{
var node = xml.childNodes[i];

if(node.nodeName.toLowerCase() == "s")
{
var name = GetXmlData(node, "n");
if(!name)
{
continue;
}

numHosts++;

var rsa = GetXmlBool(node, "r");
var dsa = GetXmlBool(node, "d");

r += "<table class=\"basicTable sshTable\">";

r += "<tr><td><b>Server:</b></td><td>" + name + hostDeleteStartHref + encodeURIComponent(name) + "&amp;action=serverdelete" + hostDeleteEndHref + " Server</a>]</td></tr>";

r += "<tr><td><b>Public RSA Key:</b></td><td>";
r += (!rsa) ?
"No RSA Key Configured" :
hostViewStartHref + encodeURIComponent(name) + "&amp;key=rsa" + hostViewEndHref + hostDeleteStartHref + encodeURIComponent(name) + "&amp;key=rsa&amp;action=serverkeydelete" + hostDeleteEndHref + " Key</a>]";
r += "</td></tr>";

r += "<tr><td><b>Public DSA Key:</b></td><td>";
r += (!dsa) ?
"No DSA Key Configured" :
hostViewStartHref + encodeURIComponent(name) + "&amp;key=dsa" + hostViewEndHref + hostDeleteStartHref + encodeURIComponent(name) + "&amp;key=dsa&amp;action=serverkeydelete" + hostDeleteEndHref + " Key</a>]";
r += "</td></tr>";

r += "</table>";
}
}
if(numHosts == 0)
{
d.innerHTML = "No Known Hosts are currently configured for the SSH Client.<br/>";
}
else if(numHosts == 1)
{
d.innerHTML = r;
}
else
{
var p = '';
p += hostDeleteStartHref + "all&amp;action=deleteall" + hostDeleteEndHref + " All</a>]";
p += "<br/>";
d.innerHTML = p + r;
}
}

function SshClientKnownHostsClearForm()
{
var p;
var oldInput;
var newInput;

document.getElementById('servertext').value = '';

p = document.getElementById('rsakeyfileparent');
oldInput = document.getElementById('rsakeyfile');
newInput = document.createElement('input');
newInput.id = 'rsakeyfile';
newInput.name = 'rsakey';
newInput.type = 'file';
newInput.size = '32';
newInput.maxlength = '255';
p.replaceChild(newInput, oldInput);

p = document.getElementById('dsakeyfileparent');
oldInput = document.getElementById('dsakeyfile');
newInput = document.createElement('input');
newInput.id = 'dsakeyfile';
newInput.name = 'dsakey';
newInput.type = 'file';
newInput.size = '32';
newInput.maxlength = '255';
p.replaceChild(newInput, oldInput);
}

function SshClientUsersRender(xml)
{
SshClientUsersClearForm();
var d = document.getElementById('sshdata');
d.innerHTML = '';

var r = '';
var numUsers = 0;

var userDeleteStartHref = " [<a href=\"javascript:void(0)\" onclick=\"if (confirm('Are you SURE you want to delete the infomation?')) ajax_SshClientUsersClean([true, 'user=";
var userDeleteEndHref = "']); return false;\">Delete ";

var userViewStartHref = " [<a href=\"/sshclientuser?user=";
var userViewEndHref = "\" target=\"_blank\">View Key</a>]";

for(var i = 0; xml && i < xml.childNodes.length; i++)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "u")
{
var name = GetXmlData(node, "n");
if(! name)
{
continue;
}
numUsers++;
var password = GetXmlBool(node, "p");
var command = GetXmlData(node, "c");
var rsa = GetXmlBool(node, "r");
var dsa = GetXmlBool(node, "d");

r += "<table class=\"basicTable sshTable\">";

r += "<tr><td><b>User:</b></td><td>" + name + userDeleteStartHref + encodeURIComponent(name) + "&amp;action=userdelete" + userDeleteEndHref + " User</a>]</td></tr>";

r += "<tr><td><b>Password:</b></td><td>";
r += password ? "Configured" : "Not Configured";
r += "</td></tr>";

r += "<tr><td><b>Remote Command:</b></td><td>";
r += ! command || command[0] == 0 ?
"&lt;Default login shell&gt;" :
unescape(command) + userDeleteStartHref + encodeURIComponent(name) + "&amp;action=usercommanddelete" + userDeleteEndHref + " Command</a>]";
r += "</td></tr>";

r += "<tr><td><b>Public RSA Key:</b></td><td>";
r += (! rsa) ?
"No RSA Key Configured" :
userViewStartHref + encodeURIComponent(name) + "&amp;key=rsa" + userViewEndHref + userDeleteStartHref + encodeURIComponent(name) + "&amp;key=rsa&amp;action=userkeydelete" + userDeleteEndHref + " Key</a>]";
r += "</td></tr>";

r += "<tr><td><b>Public DSA Key:</b></td><td>";
r += (! dsa) ?
"No DSA Key Configured" :
userViewStartHref + encodeURIComponent(name) + "&amp;key=dsa" + userViewEndHref + userDeleteStartHref + encodeURIComponent(name) + "&amp;key=dsa&amp;action=userkeydelete" + userDeleteEndHref + " Key</a>]";
r += "</td></tr>";

r += "</table>";
}
}
if(numUsers == 0)
{
d.innerHTML = "No Users are currently configured for the SSH Client.<br/>";
}
else if(numUsers == 1)
{
d.innerHTML = r;
}
else
{
var p = '';
p += userDeleteStartHref + "all&amp;action=deleteall" + userDeleteEndHref + " All</a>]";
p += "<br/>";
d.innerHTML = p + r;
}
}

function SshClientUsersClearForm()
{
var p;
var oldInput;
var newInput;

document.getElementById('usernametext').value = '';
document.getElementById('passwordtext').value = '';
document.getElementById('commandtext').value = '';
document.getElementById('keytypersa').checked = false;
document.getElementById('keytypedsa').checked = false;

p = document.getElementById('privkeyfileparent');
oldInput = document.getElementById('privkeyfile');
newInput = document.createElement('input');
newInput.id = 'privkeyfile';
newInput.name = 'privkey';
newInput.type = 'file';
newInput.size = '32';
newInput.maxlength = '255';
p.replaceChild(newInput, oldInput);

p = document.getElementById('pubkeyfileparent');
oldInput = document.getElementById('pubkeyfile');
newInput = document.createElement('input');
newInput.id = 'pubkeyfile';
newInput.name = 'pubkey';
newInput.type = 'file';
newInput.size = '32';
newInput.maxlength = '255';
p.replaceChild(newInput, oldInput);

document.getElementById('user_name').value = '';
document.getElementById('key_type_rsa').checked = false;
document.getElementById('key_type_dsa').checked = false;
document.getElementById('bits_512').checked = false;
document.getElementById('bits_768').checked = false;
document.getElementById('bits_1024').checked = false;
}
