function UpdateLineCmDisplay(initialize, optElement)
{
var mode = GetDisplayValue("new_LineCmdMode.Mode");
var useSerial = (
mode == "Use Serial String" ||
mode == "Use both Serial String and CP Group"
);
SetFxDisplay("wait_time_Display", useSerial ? "" : "none", initialize);
SetFxDisplay("serial_string_Display", useSerial ? "" : "none", initialize);
SetFxDisplay("echo_serial_string_Display", useSerial ? "" : "none", initialize);







Update(optElement);
}

function SetLineCmDisplay(xml)
{
{
var mode = document.getElementById('cmmode').innerHTML;
document.getElementById('cmmodeD').style.display =
mode.match(/Inactive/) ? 'none' : '';
}
displayElementRootNames = new Array();
SetDisplaySelection('LineCmdMode.Mode');
SetDisplaySelection('LineCmdMode.Wait_Time');
SetDisplaySelection('LineCmdMode.Serial_String');
SetDisplaySelection('LineCmdMode.Echo_Serial_String');




SetDisplaySelection('LineCmdMode.Signon_Message');
SetSubmit(false);
UpdateLineCmDisplay(true);
document.getElementById("cmform").style.display = "block";
}

function UpdateLineDisplay(initialize, optElement)
{
var isCDCACM = (
GetDisplayValue("new_Line.Interface").substring(0,11) == 'USB-CDC-ACM'
);
SetFxDisplay("baudRate_Display", ! isCDCACM ? "" : "none", initialize);
SetFxDisplay("parity_Display", ! isCDCACM ? "" : "none", initialize);
SetFxDisplay("dataBits_Display", ! isCDCACM ? "" : "none", initialize);
SetFxDisplay("stopBits_Display", ! isCDCACM ? "" : "none", initialize);
var baud = GetDisplayValue("new_Line.Baud_Rate");
SetDisplayValue("Selected_Baud_Rate", baud);
document.getElementById("line_baud_rate_D").style.display = (
GetDisplayValue("Selected_Baud_Rate") == "Custom" ? '' : 'none'
);





var show_flow = (




GetDisplayValue("new_Line.Interface").substring(0,10) != 'RS485 Half' &&

! isCDCACM
);
if(! show_flow)
{
SetDisplayValue("new_Line.Flow_Control","None");
}
SetFxDisplay("flowControl_Display", show_flow ? "" : "none", initialize);

var flow = document.forms[0].elements["new_Line.Flow_Control"];
var isRs485 = (
GetDisplayValue("new_Line.Interface").substring(0,5) == 'RS485'
);
if(isRs485)
{
flow.options[2] = null;
}
else if(! flow.options[2])
{
flow.options[2] = new Option("Hardware","Hardware",false,false);
}

var isSoftwareFlowControl = (
GetDisplayValue("new_Line.Flow_Control") == "Software"
);
SetFxDisplay(
"XON_Display",
show_flow && isSoftwareFlowControl ? "" : "none",
initialize
);
SetFxDisplay(
"XOFF_Display",
show_flow && isSoftwareFlowControl ? "" : "none",
initialize
);





var show_termination = (
isRs485 &&
GetDisplayValue("new_Line.Interface").substring(0,10) == 'RS485 Half'
);
SetFxDisplay(
"termination_Display", show_termination ? "" : "none", initialize
);
if(! show_termination)
{
SetDisplayValue("new_Line.Termination","Disabled");
}

Update(optElement);
}

function SetLineDisplay(xml)
{
{
var serform = document.getElementById('serform');
serform.Selected_Baud_Rate.length = 0;
var i = 0;
if(xml)
{
var baud = xml.getElementsByTagName("baud");
for(i = 0; baud && i < baud.length; ++i)
{
var bv = baud[i].firstChild.nodeValue;
serform.Selected_Baud_Rate.options[i] = new Option(
bv, bv, false, false
);
}
}
serform.Selected_Baud_Rate.options[i] = new Option(
"Custom", "Custom", false, true
);
}

{
var ie = document.forms[0].elements["new_Line.Interface"];
ie.length = 0;
if(xml)
{
var i;
var ifc = xml.getElementsByTagName("interface");
for(i = 0; ifc && i < ifc.length; ++i)
{
var ifcv = ifc[i].firstChild.nodeValue;
ie.options[i] = new Option(
ifcv, ifcv, false, false
);
}
ie.disabled = (i <= 1);
}
}

displayElementRootNames = new Array();
SetDisplaySelection('Line.Name');

SetDisplaySelection('Line.Interface');

SetDisplaySelection('Line.Termination');


SetDisplaySelection('Line.State');
SetDisplaySelection('Line.Protocol');
SetDisplaySelection('Line.Baud_Rate');
SetDisplaySelection('Line.Parity');
SetDisplaySelection('Line.Data_Bits');
SetDisplaySelection('Line.Stop_Bits');
SetDisplaySelection('Line.Flow_Control');
SetDisplaySelection('Line.Xon_Char');
SetDisplaySelection('Line.Xoff_Char');
SetDisplaySelection('Line.Gap_Timer');
SetDisplaySelection('Line.Threshold');
SetSubmit(false);
UpdateLineDisplay(true);
document.getElementById("serform").style.display = "block";
}

function LineRender(xml)
{
var numSerialPorts = GetXmlData(xml, "numSerialPorts");
var port = GetXmlData(xml, 'port');
var name = GetXmlData(xml, 'name');
document.getElementById("hiddenport").innerHTML = port;
var ref = "Line " + (Number(port) + 1);






document.getElementById("lineid").innerHTML = (
name.length > 0 ? name + ' (' + ref + ')' : ref
);
var d = document.getElementById("line_selection");
if(d)
{
var r = "";
r += '<table id="Nav1">';
r += "<tr>";
if(numSerialPorts > 4)
{
r += "<td align='right'><b>Select Line:</b></td>";
r += "<td align='left'>";
r += "<";
r += "select name='navSelect' ";
r += "id='navSelect' ";
r += "onchange=\" ";
r += "var page = document.getElementById('hiddencurrentserialpage').innerHTML;";
r += "return ajax_AddToHistory(page, [true, 'portnumber='+this.value]);";
r += " \" ";
r += ">"




for(
var i = 0;
i < (
numSerialPorts



);
++i
)
{
var sel = (port == i) ? " selected" : "";
r += "<option value='" + i + "' " + sel + ">Line " + (i+1) +" </option>";
}
r += "</select>";
r += "</td>";
}
else
{
for(var i = 0; i < numSerialPorts; ++i)
{
r += "<td id='sernav" + (i+1) + "'>";
r += "<a ";
r += "href='javascript:void(0)'";
r += "onclick=\"";
r += "var page = document.getElementById('hiddencurrentserialpage').innerHTML;";
r += "return ajax_AddToHistory(page, [true, 'portnumber=" + i + "']);";
r += "\"";
r += ">";
r += "Line " + (i+1);
r += "</a>";
r += "</td>";
}
}
r += "</tr>";
r += "</table>";
d.innerHTML = r;
HighlightElementInTable("Nav1", "sernav" + (Number(port)+1));
}
}
