function SetWLANScanSSID(xml)
{
var d = document.getElementById('ssid');
d.value = GetXmlData(xml, "value");
}

var configUnsaved=false;//this variable is used to determine if the configuration is unsaved

function clearWLANProfileUpdates(formId)
{
var objForm = document.getElementById(formId);

if (objForm && objForm.tagName == 'FORM')
{
var formElements = objForm.elements;

for (var i = 0; i < formElements.length; i++)
{
var name = formElements[i].name;
if (name)
{
if(0==formElements[i].name.indexOf('wlan_profile_delete.') && formElements[i].type == 'checkbox')
formElements[i].checked=false;
if(0==formElements[i].name.indexOf('wlan_profile_state.') && formElements[i].type == 'checkbox')
{
formElements[i].checked = (formElements[i].getAttribute('wlan_profile_state')=="true");
}
}
}
}
updateWLANProfileApplyAndSubmit(formId);
return;
}

function getWLANProfileUpdates(formId)
{
var objForm = document.getElementById(formId);
var str = "";

if (objForm && objForm.tagName == 'FORM')
{
var formElements = objForm.elements;

for (var i = 0; i < formElements.length; i++)
{
var name = formElements[i].name;
if (name)
{
if (formElements[i].type == 'submit')
{
continue;
}
if (formElements[i].name == 'iehack')
{
continue;
}
var value=formElements[i].value;
if ((0==formElements[i].name.indexOf('wlan_profile_state.') ||
0==formElements[i].name.indexOf('wlan_profile_delete.')) &&
formElements[i].type == 'checkbox')
{
value=formElements[i].checked;
}
if (str != "")
{
str += '&';
}
str += encodeURIComponent(name) + "=" + encodeURIComponent(value);
}
}
}
if (str != "")
{
str += '&';
}
str += "iehack=";
return str;
}

function updateWLANProfileApplyAndSubmit(formId,force)
{
var bApplyButtonVisible=false;
var bSubmitButtonVisible=false;
if(formId!=null)
{
var objForm = document.getElementById(formId);
if (objForm && objForm.tagName == 'FORM')
{
var formElements = objForm.elements;

for (var i = 0; i < formElements.length; i++)
{
var name = formElements[i].name;
if (name)
{
if (formElements[i].type == 'submit')
{
continue;
}
if (formElements[i].name == 'iehack')
{
continue;
}
if (0==formElements[i].name.indexOf('wlan_profile_state.') &&
formElements[i].type == 'checkbox')
{
var oldState=formElements[i].getAttribute('wlan_profile_state');
var newState=formElements[i].checked;
if(newState.toString()!=oldState)
{
bApplyButtonVisible=true;
bSubmitButtonVisible=true;
}
}
if (0==formElements[i].name.indexOf('wlan_profile_delete.') &&
formElements[i].type == 'checkbox')
{
if(formElements[i].checked)
{
//var profileName=formElements[i].name.substr(formElements[i].name.indexOf('.')+1);
bApplyButtonVisible=true;
bSubmitButtonVisible=true;
}
}
}
}
}
}
if(force!=null)
{
SetSubmit(false);
configUnsaved=(force.toString()=="true")?true:false;
}
if(document.getElementById('wlanprofile_cancel_button'))
{
document.getElementById('wlanprofile_cancel_button').disabled=false;
document.getElementById('wlanprofile_cancel_button').style.visibility=bApplyButtonVisible?"visible":"hidden";
}
if(document.getElementById('wlanprofile_apply_button'))
{
document.getElementById('wlanprofile_apply_button').disabled=false;
document.getElementById('wlanprofile_apply_button').style.visibility=bApplyButtonVisible?"visible":"hidden";
}
if(document.getElementById('wlanprofile_submit_button'))
{
document.getElementById('wlanprofile_submit_button').disabled=false;
document.getElementById('wlanprofile_submit_button').style.visibility=(bSubmitButtonVisible || configUnsaved)?"visible":"hidden";
}
}
function EnableSubmitButton(xml)
{
if(document.getElementById('apply_button'))
{
document.getElementById('apply_button').disabled=false;
}
if(document.getElementById('test_button'))
{
document.getElementById('test_button').disabled=false;
}
if(document.getElementById('submit_button'))
{
document.getElementById('submit_button').disabled=false;
}
}
function EnableTestConnectionButton(enable)
{
if(document.getElementById('test_button'))
{
document.getElementById('test_button').disabled=!enable;
}
}
function SetNewProfileName(xml)
{
var d = document.getElementById('networkprofilename');
d.innerHTML = GetXmlData(xml, "value");
}
var timer=null;
function Rescan()
{
var d=document.getElementById('wlanScanTable');
if(d)
{
var nav3 = '3';
var netno = document.getElementById('hiddennetwork').innerHTML;
var nav2 = document.getElementById('hiddennetworkinterfacelink').innerHTML;
document.getElementById('hiddennetworkstatusconfig').innerHTML = nav3;
ajax_WLANScanSSID([true, ajaxGetFormValues('ssidform') + '&netnumber=' + netno + '&2=' + nav2 + '&3=' + nav3]);
}
}
function UpdateRescan()
{
var d = document.getElementById('autorefresh');
clearTimeout(timer);
timer=null;
if(d && d.checked)
{
timer=setTimeout("Rescan()",15*1000);//update every 15 seconds
}
document.getElementById('hiddennetworkscanautorefresh').innerHTML = d.checked.toString();
}
function SetAutoRefresh(xml)
{
var d = document.getElementById('autorefresh');
d.checked = document.getElementById('hiddennetworkscanautorefresh').innerHTML=="true"?true:false;
if(d && d.checked)
{
clearTimeout(timer);
timer=null;
timer=setTimeout("Rescan()",15*1000);//update every 15 seconds
}
else
{
clearTimeout(timer);
timer=null;
}
}
function GenerateSignalStrengthIndicator(strength)
{
var table="";
var cell="";
var count=0;
if(strength>=-60)
{
cell="<td style='background-color:green' height='5' width='1'></td>";
count=5;
}
else if(strength>=-73)
{
cell="<td style='background-color:green' height='5' width='1'></td>";
count=4;
}
else if(strength>=-85)
{
cell="<td style='background-color:yellow' height='5' width='1'></td>";
count=3;
}
else if(strength>=-98)
{
cell="<td style='background-color:yellow' height='5' width='1'></td>";
count=2;
}
else if(strength>=-110)
{
cell="<td style='background-color:red' height='5' width='1'></td>";
count=1;
}
else
{
cell="<td style='background-color:red' height='5' width='1'></td>";
count=0;
}
table+="<table border='0'>";
for(row=0;row<1;row++)
{
table+="<tr>";
for(col=0;col<count;col++)
{
table+=cell;
}
table+="</tr>";
}
table+="</table>";
return table;
}

function SetNetworkLinks()
{
document.getElementById('netdhcpD').style.display = (
(document.getElementById('netdhcp').innerHTML == 'N/A' ||
document.getElementById('netdhcp').innerHTML == 'Off') ?
'none' : 'inline'
);
}

function SetInterfaceDisplay(xml)
{
displayElementRootNames = new Array();
SetSubmit(false);

SetDisplaySelection('Interface.State');

SetDisplaySelection('Interface.BOOTP');
SetDisplaySelection('Interface.DHCP');
SetDisplaySelection('Interface.Domain');
SetDisplaySelection('Interface.Hostname');
SetDisplaySelection('Interface.DHCP_Client_ID');



SetDisplaySelection('Interface.Default_Gateway');
SetDisplaySelection('Interface.IP_Address');
SetDisplaySelection('Interface.Primary_DNS');
SetDisplaySelection('Interface.Secondary_DNS');

SetDisplaySelection('Interface.MTU');

document.getElementById("networkform").style.display = "block";
}

function EthernetSpeedChange(value)
{
if(value == "Auto")
{
SetFxDisplay("ethernetduplexauto_Display", "");
SetFxDisplay("ethernetduplexhalf_Display", "");
SetFxDisplay("ethernetduplexfull_Display", "none");
}
else if(value == "1000")
{
SetFxDisplay("ethernetduplexauto_Display", "none");
SetFxDisplay("ethernetduplexhalf_Display", "none");
SetFxDisplay("ethernetduplexfull_Display", "none");
}
else
{
SetFxDisplay("ethernetduplexauto_Display", "none");
SetFxDisplay("ethernetduplexhalf_Display", "");
SetFxDisplay("ethernetduplexfull_Display", "");
}
Update();
}

function SetEthernetDisplay(xml)
{
displayElementRootNames = new Array();
SetSubmit(false);
var speed = SetDisplaySelection('Ethernet.Speed');
EthernetSpeedChange(speed);
SetDisplaySelection('Ethernet.Duplex');
document.getElementById("networkethform").style.display = "block";
}

function EthernetConfigPostProcedure()
{
FileSystemMonitor();
return ajax_EthernetConfPost(
[
true,
ajaxGetFormValuesWithoutClearingThem('networkethform')
]
);
}

function NetworkRender(xml)
{
var netno = Number(document.getElementById("hiddennetwork").innerHTML);
var d = document.getElementById("multinetworkdropdown");
if(d)
{
var r = "<";
r += "select name='navSelect' ";
r += "id='navSelect' ";
r += "onchange=\" ";
r += "var nav2 = document.getElementById('hiddennetworkinterfacelink').innerHTML;";
r += "var nav3 = document.getElementById('hiddennetworkstatusconfig').innerHTML;";
r += "document.getElementById('hiddennetwork').innerHTML = this.value;";
r += "return ajax_AddToHistory(";
r += "'NetworkPage', ";
r += "[true, 'netnumber=' + this.value + '&2=' + nav2 + '&3=' + nav3]";
r += ");";
r += " \" ";
r += ">";
for(var i = 0; i < 1 + 1; ++i)
{
var sel;
if(netno == i)
{
sel = " SELECTED ";
}
else
{
sel = "";
}
r += "<option value='" + i + "' " + sel + ">";
r += "Network " + (i + 1);
r += "</option>";
}
r += "</select>";
d.innerHTML = "";
d.innerHTML = r;
}

var scanResultTable = document.getElementById("wlanScanTable");
if(scanResultTable)
{
var row=scanResultTable.rows[1];//firstChild.nextSibling.firstChild;//get to first row: this has issue in FF
while(row)
{
col=row.getElementsByTagName('td')[3];//get the signal strength column
var strength=parseInt(col.innerHTML);
var originalContent=col.innerHTML;
col.innerHTML=GenerateSignalStrengthIndicator(strength)+originalContent;
row=row.nextSibling;
}
}

return;
}



function WLANConfigRender(xml)
{
var d = document.getElementById('wlan_new_values');
var e = document.getElementById('wlan_current_values');
var r = '';
var s = '';
r += '<table class="basicTable">';
for(var i = 1; i <= 4; ++i)
{
r += "<tr>";
r += "<td><b>Choice " + i + " Profile: </b></td>";
r += "<td>";
r += "<input ";
r += 'name="new_WLAN.Choice_' + i + '.Profile"';
r += 'type="text" size="30" maxlength="30" value=""';
r += 'onkeyup="Update();"';
r += 'onblur="Update();"';
r += 'onclick="Update();"';
r += "/>";
r += "</td>";
r += "</tr>";
s += '<div id="current_WLAN.Choice_' + i + '.Profile"></div>';
}

r += "<tr>";
r += "<td><b>Out of Range Scan Interval:</b></td>";
r += "<td>";
r += "<input ";
r+= 'name="new_WLAN.Out_of_Range_Scan_Interval"';
r+= 'type="text" size="5" maxlength="5" value=""';
r += 'onkeyup="Update();"';
r += 'onblur="Update();"';
r += 'onclick="Update();"';
r+= "/>&nbsp;seconds";
r+= "</td>";
r+= "</tr>";
s += '<div id="current_WLAN.Out_of_Range_Scan_Interval"></div>';
r += "<tr>";
r += "<td><b>Roaming:</b></td>";
r += "<td>";
r += '<label>';
r += "<input ";
r += 'onclick="Update();"';
r += 'name="new_WLAN.Roaming" type="radio" value="Enabled"';
r += "/>Enabled";
r += '</label>';
r += '<label>';
r += "<input ";
r += 'onclick="Update();"';
r += 'name="new_WLAN.Roaming" type="radio" value="Disabled"';
r += "/>Disabled";
r += '</label>';
r += "</td>";
r += "</tr>";
s += '<div id="current_WLAN.Roaming"></div>';


r += "<tr>";
r += "<td><b>RSSI Delta:</b></td>";
r += "<td>";
r += "<input ";
r+= 'name="new_WLAN.RSSI_Delta"';
r+= 'type="text" size="4" maxlength="4" value=""';
r += 'onkeyup="Update();"';
r += 'onblur="Update();"';
r += 'onclick="Update();"';
r+= "/>&nbsp;dBm";
r+= "</td>";
r+= "</tr>";
r+= '<tr>';
r+= '<td><b>Debugging Level:</b></td>';
r+= '<td><select onchange="Update();" name="new_WLAN.Debugging_Level">';
r+= '<option value="Dump">Dump</option>';
r+= '<option value="Debug">Debug</option>';
r+= '<option value="Info">Info</option>';
r+= '<option value="Warning">Warning</option>';
r+= '<option value="Error">Error</option>';
r+= '</select></td></tr>';
r += "<tr>";
r += "<td><b>Active Channel Scan Time:</b></td>";
r += "<td>";
r += "<input ";
r+= 'name="new_WLAN.Active_Channel_Scan_Time"';
r+= 'type="text" size="4" maxlength="4" value=""';
r += 'onkeyup="Update();"';
r += 'onblur="Update();"';
r += 'onclick="Update();"';
r+= "/>&nbsp;milliseconds";
r+= "</td>";
r+= "</tr>";
r += "<tr>";
r += "<td><b>Passive Channel Scan Time:</b></td>";
r += "<td>";
r += "<input ";
r+= 'name="new_WLAN.Passive_Channel_Scan_Time"';
r+= 'type="text" size="4" maxlength="4" value=""';
r += 'onkeyup="Update();"';
r += 'onblur="Update();"';
r += 'onclick="Update();"';
r+= "/>&nbsp;milliseconds";
r+= "</td>";
r+= "</tr>";
r+= '<tr>';
r+= '<td><b>Radio Band Selection:</b></td>';
r+= '<td><select onchange="Update();" name="new_WLAN.Radio_Band_Selection">';
r+= '<option value="2.4 GHz Only">2.4 GHz Only</option>';
r+= '<option value="5 GHz Only">5 GHz Only</option>';
r+= '<option value="Dual">Dual</option>';
r+= '</select></td></tr>';
r += "<tr>";
r += "<td><b>WLAN Watchdog:</b></td>";
r += "<td>";
r += '<label>';
r += "<input ";
r += 'onclick="Update();"';
r += 'name="new_WLAN.WLAN_Watchdog" type="radio" value="Enabled"';
r += "/>Enabled";
r += '</label>';
r += '<label>';
r += "<input ";
r += 'onclick="Update();"';
r += 'name="new_WLAN.WLAN_Watchdog" type="radio" value="Disabled"';
r += "/>Disabled";
r += '</label>';
r += "</td>";
r += "</tr>";
s += '<div id="current_WLAN.RSSI_Delta"></div>';
s += '<div id="current_WLAN.Debugging_Level"></div>';
s += '<div id="current_WLAN.Active_Channel_Scan_Time"></div>';
s += '<div id="current_WLAN.Passive_Channel_Scan_Time"></div>';
s += '<div id="current_WLAN.Radio_Band_Selection"></div>';
s += '<div id="current_WLAN.WLAN_Watchdog"></div>';





r += '</table>';
d.innerHTML = r;
e.innerHTML = s;
}

function SetWLANDisplay(xml)
{
displayElementRootNames = new Array();
SetSubmit(false, xml);
for(var i = 1; i <= 4; ++i)
{
SetDisplaySelection('WLAN.Choice_' + i + '.Profile');
}

SetDisplaySelection('WLAN.Out_of_Range_Scan_Interval');
SetDisplaySelection('WLAN.Roaming');


SetDisplaySelection('WLAN.RSSI_Delta');
SetDisplaySelection('WLAN.Debugging_Level');
SetDisplaySelection('WLAN.Active_Channel_Scan_Time');
SetDisplaySelection('WLAN.Passive_Channel_Scan_Time');
SetDisplaySelection('WLAN.Radio_Band_Selection');
SetDisplaySelection('WLAN.WLAN_Watchdog');

UpdateWlanDisplay(true);

EnableSubmitButton(xml);

document.getElementById("wlanform").style.display = "block";
}

function UpdateWlanDisplay(initialize)
{
Update();
}

function WLANNetworkChoicesRender(xml)
{
var d = document.getElementById('wlanScan');
if(d==null)return;
var r = '';
r += "<table class=\"basicTable\" id=\"wlanScanTable\">";
r += "<thead><tr align=left>	      <th><b>Network Name</b></th>	      <th><b>BSSID</b></th>	      <th><b>Ch</b></th>	      <th><b>RSSI</b></th>	      <th><b>Security Suite</b></th>	      </tr>	      </thead>";







if(xml && xml.hasChildNodes())
{
r += "<tbody id=\"wlanScan\" style=\"font-size: 8pt\">";
var nav3 = '3';
var netno = document.getElementById('hiddennetwork').innerHTML;
var nav2 = document.getElementById('hiddennetworkinterfacelink').innerHTML;
document.getElementById('hiddennetworkstatusconfig').innerHTML = nav3;
for(var i = 0; xml && i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "network")
{
r += "<tr>";
var ssid=GetXmlData(node, "ssid");//.replace(/^\s+|\s+$/g, '');
var flags=GetXmlData(node, "flags");//.replace("WPS","");//remove WPS from the security flags
var rssi=GetXmlData(node, "rssi");//.replace(/^\s+|\s+$/g, '');
var bssid=GetXmlData(node, "bssid");//.replace(/^\s+|\s+$/g, '');
var channel=GetXmlData(node, "channel");//.replace(/^\s+|\s+$/g, '');
r += "<td>";
r += "<a ";
r += "href=\"javascript:void(0)\" ";
r += "onclick=\"";
r += "clearTimeout(timer);timer=null;";
r += "ajax_AddToHistory(";
r += "'WLANProfilePage',";
r += "[true, '1=1&amp;netprofilename=New Profile&netnumber=" + netno + "&2=" + nav2 + "&3=" + nav3+"&ssid=" + ssid +"&bssid="+bssid+"&channel="+encodeURIComponent(channel)+"&rssi=" + rssi + "&flags="+encodeURIComponent(flags)+"']";
r += ");";
r += "return false;";
r += "\"";
r += ">";
r += ssid;
r += "</a>";
r += "</td>";
r += "<td>"+bssid+"</td>";
r += "<td>"+channel+"</td>";
r += "<td>"+rssi+"</td>";
r += "<td>"+flags+"</td>";
r += "</tr>";
}
}
r+="</tbody>";
}
r += "</table>";
d.innerHTML = r;
}

function WLANProfileChoicesRender(xml)
{
var d = document.getElementById('wlanprofiletable');
var flash_state=null;
var r = '';
if(! xml || ! xml.hasChildNodes())
{
r += "<p>No profiles are defined.</p>";
}
else
{
r += "<table>";
r += '<tr>';
r += '<td><b>View or Edit:</b></td><td><b>Delete:</b></td>';

r += '<td><b>Enabled:</b></td>';

r += '</tr>';
for(var i = 0; xml && i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "c")
{
var name = GetXmlData(node, "n");
var type = GetXmlData(node, "t");
var is_active = GetXmlData(node,"a");

r += "<tr>";
r += "<td>";
r += "<a ";
r += "href=\"javascript:void(0)\" ";
r += "onclick=\"";
r += "ajax_AddToHistory(";
r += "'WLANProfilePage',";
r += "[true, '1=1&amp;netprofilename=" + name + "']";
r += ");";
r += "return false;";
r += "\"";
r += ">";
r += '<img class="fsimage" src="/config/file.gif" />';
r += "</a>";
r += "&nbsp;";
r += "<a ";
r += "href=\"javascript:void(0)\" ";
r += "onclick=\"";
r += "ajax_AddToHistory(";
r += "'WLANProfilePage',";
r += "[true, '1=1&amp;netprofilename=" + name + "']";
r += ");";
r += "return false;";
r += "\"";
r += ">";
r += name;
r += "</a>";
r += "&nbsp;&nbsp;";
r += type!=null?"<i>"+type+"</i>":"";
if(is_active!=null && is_active=="true")
{
r += "&nbsp;&nbsp;";
r +="<img class='fsimage' src='/config/wifi.png' width='20' height='22' />";
//r+="<b><i>(Active)</i></b>";
}
r += "&nbsp;&nbsp;&nbsp;&nbsp;";
r += "</td>";
r += "<td>";

r += "<input type=\"checkbox\" ";
r += "onclick=updateWLANProfileApplyAndSubmit('wlanprofilesupdateform',null); ";
r += 'name="wlan_profile_delete.' + name +'" ';
r += '/>';
r += "</td>";
var state = GetXmlData(node, "s");
r += "<td>";
r += "<input type=\"checkbox\" ";
r += "onclick=updateWLANProfileApplyAndSubmit('wlanprofilesupdateform',null); ";
r += 'name="wlan_profile_state.' + name +'" ';
r += 'wlan_profile_state="' + state +'"';
if(state=="true")
{
r += 'checked/>';
}
else
{
r += '/>';
}
r += "</td>";
var priority = GetXmlData(node, "p");
r += "</tr>";
}
}
r += "</table>";
flash_state=GetXmlData(xml, "flash");
}
d.innerHTML = r;
updateWLANProfileApplyAndSubmit(null,(flash_state && flash_state=="unsaved")?true:false);
}
function TopologyChange(v, initial)
{
SetFxDisplay("channel_Display", v == "Adhoc" ? "" : "none", initial);
//SetFxDisplay("soft_roaming_Display", v == "Infrastructure" ? "" : "none", initial);
var e = document.forms[0].elements["new_WLAN_Profile_Security.Suite"];
var value = GetInputElementValue(e);
if(v == "Adhoc" && value != "None" && value != "WEP")
{
value = "None";
}
e.length = 0;
e.options[0] = new Option(
"None", "None", false, value == "None"
);
e.options[1] = new Option(
"WEP", "WEP", false, value == "WEP"
);
if(v == "Infrastructure")
{
e.options[2] = new Option(
"WPA", "WPA", false, value == "WPA"
);
e.options[3] = new Option(
"WPA2 / IEEE 802.11i", "WPA2", false, value == "WPA2"
);
}
}
function BuildWlanHtml(xml)
{
var d = document.getElementById('select_wpax_credential');
d.options.length = 0;
d.options[0] = new Option("<Unlisted>", "", true);
for(var i = 0; xml && xml.hasChildNodes() && i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "ssl_credential")
{
var name = GetXmlData(node, "name");
d.options[d.options.length] = new Option(name, name);
}
}
SetFxDisplay(
"select_wpax_credential_Display",
d.options.length > 1 ? "" : "none",
true
);
}
function SetWLANProfileDisplay(xml)
{
displayElementRootNames = new Array();
SetSubmit(false, xml);
var isQuickConnect=false;
var enableTestButton=true;
SetFxDisplay("settings_Display", "none", true);
SetFxDisplay("basicConfiguration_Display", "", true);
SetFxDisplay("advancedConfiguration_Display", "", true);
//if xml has created=false;ssid and flags has the information to display
if(xml && xml.hasChildNodes)
{
for(var i = 0; i < xml.childNodes.length; ++i)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "state")
{
var ssid=GetXmlData(node, "ssid");
if(ssid && ssid!="")
{
isQuickConnect=true;
SetFxDisplay("basicConfiguration_Display", "none", true);
SetFxDisplay("advancedConfiguration_Display", "", true);
toggleAdvancedConfigDisplay(ssid);
SetFxDisplay("settings_Display", "", true);
var d = document.getElementById('settings_SSID');
if(d)
{
d.innerHTML=ssid;
}
}
var bssid=GetXmlData(node, "bssid");
if(bssid != null)
{
var d = document.getElementById('settings_BSSID');
if(d)
{
d.innerHTML=bssid;
}
}
var flags=GetXmlData(node,"flags");//remove WPS from the security flags
if(flags != null)
{
flags=flags.replace("WPS","");
if(flags=="")flags="None"
var d = document.getElementById('settings_Flags');
if(d)
{
d.innerHTML=flags;
}
}
var rssi=GetXmlData(node, "rssi");
if(rssi)
{
var d = document.getElementById('settings_RSSI');
if(d)
{
d.innerHTML=rssi;
}
}
var wlanEnabled=GetXmlData(node, "wlan_enabled");
if(wlanEnabled && wlanEnabled==0)enableTestButton=false;
}
}
}
/* Basic */
SetDisplaySelection('WLAN_Profile_Basic.Network_Name');
var topology = SetDisplaySelection('WLAN_Profile_Basic.Topology');
SetDisplaySelection('WLAN_Profile_Basic.Channel');
//SetDisplaySelection('WLAN_Profile_Basic.Soft_Roaming');
TopologyChange(topology, true);
SetDisplaySelection('WLAN_Profile_Basic.State');
SetDisplaySelection('WLAN_Profile_Basic.Scan_2_4_GHz_Band');
var scan_5ghz = SetDisplaySelection('WLAN_Profile_Basic.Scan_5_GHz_Band');
SetDisplaySelection('WLAN_Profile_Basic.Scan_DFS_Channels');
SetFxDisplay("scan_dfs_channels_Display", scan_5ghz == "Enabled" ? "" : "none", true);
/* Advanced */
SetDisplaySelection('WLAN_Profile_Advanced.TX_Data_Rate_Maximum');
SetDisplaySelection('WLAN_Profile_Advanced.TX_Data_Rate');
SetDisplaySelection('WLAN_Profile_Advanced.TX_Power_Maximum');
SetDisplaySelection('WLAN_Profile_Advanced.Antenna_Diversity');
var power_mgmt = SetDisplaySelection('WLAN_Profile_Advanced.Power_Management');
SetDisplaySelection('WLAN_Profile_Advanced.Power_Management_Interval');
SetFxDisplay("power_mgmt_interval_Display", power_mgmt == "Enabled" ? "" : "none", true);
/* Security */
SetDisplaySelection('WLAN_Profile_Security.Suite');
SetDisplaySelection('WLAN_Profile_Security.Key_Type');
SetDisplaySelection('WLAN_Profile_Security.Passphrase');
SetDisplaySelection('WLAN_Profile_Security.WEP.Authentication');
SetDisplaySelection('WLAN_Profile_Security.WEP.Key_Size');
SetDisplaySelection('WLAN_Profile_Security.WEP.TX_Key_Index');
SetDisplaySelection('WLAN_Profile_Security.WEP.Key_1.Key');
SetDisplaySelection('WLAN_Profile_Security.WEP.Key_2.Key');
SetDisplaySelection('WLAN_Profile_Security.WEP.Key_3.Key');
SetDisplaySelection('WLAN_Profile_Security.WEP.Key_4.Key');
SetDisplaySelection('WLAN_Profile_Security.WPAx.Authentication');
SetDisplaySelection('WLAN_Profile_Security.WPAx.Key');
SetDisplaySelection('WLAN_Profile_Security.WPAx.IEEE_802_1X');
SetDisplaySelection('WLAN_Profile_Security.WPAx.EAP_TTLS_Option');
SetDisplaySelection('WLAN_Profile_Security.WPAx.PEAP_Option');
SetDisplaySelection('WLAN_Profile_Security.WPAx.Username');
SetDisplaySelection('WLAN_Profile_Security.WPAx.Password');
var v = SetDisplaySelection('WLAN_Profile_Security.WPAx.Encryption');
for(var n = 0; n < 3; ++n)
{
var bit = 1 << n;
var e = document.forms[0].elements[
'new_WLAN_Profile_Security.WPAx.Encryption_' + n
];
e.checked = (( v & bit) != 0);
}
SetDisplaySelection('WLAN_Profile_Security.WPAx.Validate_Certificate');
var credentialName = SetDisplaySelection('WLAN_Profile_Security.WPAx.Credentials');
SetDisplayValue('new_WLAN_Profile_Security.WPAx.Selected_Credential', credentialName);
WLANSecuritySetFx(true, isQuickConnect);
document.getElementById("networkwlanform").style.display = "block";
EnableSubmitButton(xml);
EnableTestConnectionButton(enableTestButton);
}
function WLANSecuritySetFx(initialize, quickConnect)
{
var suite = GetInputElementValue(
document.forms[0].elements["new_WLAN_Profile_Security.Suite"]
);
var suiteDispStyle = !quickConnect ? "" : "none";
SetFxDisplay("suite_Display", suiteDispStyle, initialize);
var isWEP = suite == "WEP";
var isWPAx = (suite == "WPA" || suite == "WPA2");
// Show "Security Configuration" section for wlan profiles and
// if quickConnect wlan is WEP/WPA/WPA2
var securityConfigDispStyle = !quickConnect || (quickConnect && (isWEP || isWPAx)) ? "" : "none";
SetFxDisplay("securityConfiguration_Display", securityConfigDispStyle, initialize);
var kt = GetInputElementValue(
document.forms[0].elements["new_WLAN_Profile_Security.Key_Type"]
);
var wpaxAuth = GetInputElementValue(
document.forms[0].elements[
"new_WLAN_Profile_Security.WPAx.Authentication"
]
);
var isIEEE802_1x = isWPAx && wpaxAuth == "802.1X";
var ieee802_1x_option = GetInputElementValue(
document.forms[0].elements[
"new_WLAN_Profile_Security.WPAx.IEEE_802_1X"
]
);
var keyTypeStyle = (!quickConnect && isWEP || (isWPAx && ! isIEEE802_1x)) ? "" : "none";
SetFxDisplay("key_type_Display", keyTypeStyle, initialize);
SetFxDisplay("wep_authentication_Display", isWEP ? "" : "none", initialize);
var wepDispStyle = !quickConnect && isWEP ? "" : "none";
SetFxDisplay("wep_key_size_Display", wepDispStyle, initialize);
//SetFxDisplay("wep_tx_key_index_Display", wepDispStyle, initialize);
var wepKeyDispStyle = isWEP && kt == "Hex" ? "" : "none";
SetFxDisplay("wep_tx_key_index_Display", wepKeyDispStyle, initialize);
SetFxDisplay("wep_key_1_Display", wepKeyDispStyle, initialize);
SetFxDisplay("wep_key_2_Display", wepKeyDispStyle, initialize);
SetFxDisplay("wep_key_3_Display", wepKeyDispStyle, initialize);
SetFxDisplay("wep_key_4_Display", wepKeyDispStyle, initialize);
var wpaxDispStyle = !quickConnect && isWPAx ? "" : "none";
SetFxDisplay("wpax_authentication_Display", wpaxDispStyle, initialize);
SetFxDisplay(
"wpax_key_Display",
isWPAx && wpaxAuth == "PSK" && kt == "Hex" ? "" : "none",
initialize
);
var wpax802_1xDispStyle = isIEEE802_1x ? "" : "none";
SetFxDisplay("wpax_ieee_802_1x_Display", wpax802_1xDispStyle, initialize);
SetFxDisplay(
"wpax_eap_ttls_option_Display",
isIEEE802_1x && ieee802_1x_option == "EAP-TTLS" ? "" : "none",
initialize
);
SetFxDisplay(
"wpax_peap_option_Display",
isIEEE802_1x && ieee802_1x_option == "PEAP" ? "" : "none",
initialize
);
var wpaxUsernameDispStyle = isIEEE802_1x ? "" : "none";
var wpaxPasswordDispStyle = isIEEE802_1x && ieee802_1x_option != "EAP-TLS" ? "" : "none";
SetFxDisplay("wpax_username_Display", wpaxUsernameDispStyle, initialize);
SetFxDisplay("wpax_password_Display", wpaxPasswordDispStyle, initialize);
SetFxDisplay("wpax_encryption_Display", wpaxDispStyle, initialize);
var wpaxCredentialsDispStyle = isIEEE802_1x && ieee802_1x_option == "EAP-TLS" ? "" : "none";
SetFxDisplay("wpax_validate_certificate_Display", wpaxCredentialsDispStyle, initialize);
SetFxDisplay("wpax_credentials_Display", wpaxCredentialsDispStyle, initialize);
var credential = GetDisplayValue("new_WLAN_Profile_Security.WPAx.Selected_Credential");
SetFxDisplay(
"wpax_credentials_selection_Display",
credential == "" ? "" : "none",
initialize
);
SetFxDisplay(
"passphrase_Display",
kt == "Passphrase" && (isWEP || (isWPAx && wpaxAuth == "PSK")) ? "" : "none",
initialize
);
if(quickConnect)
{
document.getElementById('securityConfiguration_Display').style.borderStyle="solid";
document.getElementById('securityConfiguration_Display').style.borderColor= "red";
}
else
{
document.getElementById('securityConfiguration_Display').style.borderStyle="none";
}
/*if(isWEP)
{
document.getElementById('new_WLAN_Profile_Security.WEP.Key_1.Key').focus();
document.getElementById('new_WLAN_Profile_Security.WEP.Key_1.Key').select();
}
if(isWPAx)
{
if(wpaxAuth=="PSK")
{
if(kt=="Hex")
{
document.getElementById('new_WLAN_Profile_Security.WPAx.Key').focus();
document.getElementById('new_WLAN_Profile_Security.WPAx.Key').select();
}
else
{
document.getElementById('new_WLAN_Profile_Security.Passphrase').focus();
document.getElementById('new_WLAN_Profile_Security.Passphrase').select();
}
}
else//IEEE802.1X
{
document.getElementById('new_WLAN_Profile_Security.WPAx.Username').focus();
document.getElementById('new_WLAN_Profile_Security.WPAx.Username').select();
}
}*/
}
function WLANSecurityDisplayUpdate(optElement)
{
var vEncryption = 0;
for(var n = 0; n < 3; ++n)
{
var bit = 1 << n;
var e = document.forms[0].elements[
'new_WLAN_Profile_Security.WPAx.Encryption_' + n
];
vEncryption = vEncryption | (e.checked ? bit : 0);
}
document.forms[0].elements[
'new_WLAN_Profile_Security.WPAx.Encryption'
].value = vEncryption;
Update(optElement);
var quickConnectSsid = "";
var elem = document.getElementById("settings_Display");
if(elem && elem.style.display=="")quickConnectSsid = GetDivValueById('settings_SSID');
WLANSecuritySetFx(false, quickConnectSsid != "");
}
function toggleAdvancedConfigDisplay(quickConnectSsid)
{
if (quickConnectSsid == null || !quickConnectSsid)
return;
var headerElement = document.getElementById("advancedConfiguration_Header");
var table = document.getElementById("advancedConfiguration_Display");
// Hide all rows: Display rightArr icon in front of header.
// Show all rows: Display downArr icon in front of header
if (headerElement.className) {
headerElement.className == "rightArr" ? headerElement.className = "downArr": headerElement.className = "rightArr";
}
// Default: Display rightArr icon in front of header. This means hide all rows.
else {
headerElement.className = "rightArr";
}
if (table) {
var trs = table.getElementsByTagName("tr");
var show_power_mgmt_interval_Display = false;
var tr = null;
for (var i = 0; i < trs.length; i++) {
// Ignore 1st row which is a header
if (i > 0) {
if (trs[i].id == "power_mgmt_interval_Display") {
SetFxDisplay(trs[i].id, show_power_mgmt_interval_Display ? "" : "none", false);
continue;
}
// Hide row
if (IsFxDisplayVisible(trs[i].id)) {
// Power Management is going to be hidden, so power management interval will also be hidden
if (trs[i].id == "power_mgmt_Display") {
show_power_mgmt_interval_Display = false;
}
SetFxDisplay(trs[i].id, "none", false);
}
// Show row
else {
// Power Management is going to be shown and it's enabled, show power management interval. Else, hide power management interval.
if (trs[i].id == "power_mgmt_Display" && GetDisplayValue("new_WLAN_Profile_Advanced.Power_Management") == "Enabled") {
show_power_mgmt_interval_Display = true;
}
SetFxDisplay(trs[i].id, "", false);
}
}
}
}
}
