
function FsDirCompare(a, b)
{
if (a > b) return 1;
if (a < b) return -1;
return 0;
}

function FsFileCompare(a, b)
{
if (a[0] > b[0]) return 1;
if (a[0] < b[0]) return -1;
return 0;
}

function FsBasename(path)
{
if (path == '/') return path;
var r = path.match(/[\/|\\]([^\\\/]+)$/);
if (!r) return '';
return r[1];
}

function FsDirname(path)
{
if (path == '/') return path;
var r = path.match(/(.*)[\/|\\][^\\\/]+$/);
if (!r) return '';
if (!r[1]) return '/';
return r[1];
}

function FsBrowseRender(xml)
{
if (!xml || !xml.hasChildNodes())
{
alert("ERROR: No Filesystem information available.");
return;
}

var cwd = xml.getElementsByTagName('cwd');
if (!cwd)
{
alert("ERROR: Unable to determine the current directory.");
return;
}

cwd = cwd[0].firstChild.nodeValue;

var i;
var j;
var r;

var b = document.getElementById('breadcrumbs');
b.innerHTML = '';

var d = document.getElementById('fsdata');
d.innerHTML = '';

r = '&nbsp;&nbsp;/';

if (cwd != '/')
{
var elems = cwd.split('/');
for (i = 0; i < elems.length; i++)
{
if (elems[i])
{
var ldir = '';

for (j = 0; j <= i; j++)
{
ldir += '/' + elems[j];
}

r += "&nbsp;<a href=\"javascript:void(0)\" onclick=\"return ajax_AddToHistory('FsBrowsePage', [true, 'dir=" + encodeURIComponent(ldir) + "']);\">" + elems[i] + "</a>&nbsp;/";
}
}
}

b.innerHTML = r;

var dirs = new Array();
var files = new Array();

var isUSB = xml.getElementsByTagName('isUSB');
if(isUSB && isUSB.length>0)
{
isUSB = isUSB[0].firstChild.nodeValue;
if(isUSB.toLowerCase()=="true")
{
var pathImage = document.getElementById('fsimage');
if(pathImage)
{
pathImage.src="/config/usb-icon.png";
}
}
}
var mounts=new Array();


for (i = 0; i < xml.childNodes.length; i++)
{
var node = xml.childNodes[i];

if (node.nodeName.toLowerCase() == "d")
{
dirs.push(node.firstChild.nodeValue);
}
}
dirs.sort(FsDirCompare);


for (i = 0; i < xml.childNodes.length; i++)
{
var node = xml.childNodes[i];

if (node.nodeName.toLowerCase() == "u")
{
mounts.push(node.firstChild.nodeValue);
}
}
mounts.sort(FsDirCompare);


for (var i = 0; i < xml.childNodes.length; i++)
{
var f = xml.getElementsByTagName("f" + i);
if (!f || !f.length)
{
break;
}
var fv = f[0].firstChild.nodeValue;

var fl = xml.getElementsByTagName("fl" + i);
var flv = fl[0].firstChild.nodeValue;

files.push(new Array(fv, flv));
}

files.sort(FsFileCompare);

var r = '';

r += "<table>";

var root = false;
if (cwd == '/')
{
root = true;
}

if (!root)
{
r += "<tr><td>&nbsp;&nbsp;&nbsp;<img src=\"/config/folder.gif\" /></td><td><a href=\"javascript:void(0)\" onclick=\"return ajax_AddToHistory('FsBrowsePage', [true, 'dir=" + encodeURIComponent(FsDirname(cwd)) + "']);\">&lt;up&gt;</a></td><td></td></tr>";
}


for (i = 0; i < mounts.length; i++)
{
r += "<tr>";
r += "<td>&nbsp;&nbsp;&nbsp;<img width=\"20\" height=\"22\" src=\"/config/usb-icon.png\" />&nbsp;&nbsp;<a href=\"javascript:void(0)\" onclick=\"if (confirm('Are you SURE you want to unmount " + mounts[i] + "?')) ajax_FsUnmount([true, 'dir=" + encodeURIComponent(cwd) + "&amp;path=";
r += (root) ? encodeURIComponent(cwd + mounts[i]) : encodeURIComponent(cwd + '/' + mounts[i]);
r += "&amp;action=unmount']); return false;\"><img width=\"18\" height=\"18\" src=\"/config/eject-icon.png\" /></a></td>";
r += "<td><a href=\"javascript:void(0)\" onclick=\"return ajax_AddToHistory('FsBrowsePage', [true, 'dir=";
r += (root) ? encodeURIComponent(cwd + mounts[i]) : encodeURIComponent(cwd + '/' + mounts[i]);
r += "']);\">" + mounts[i] + "</a></td><td></td>";
r += "</tr>";
}


for (i = 0; i < dirs.length; i++)
{
r += "<tr>";
r += "<td>&nbsp;&nbsp;&nbsp;<img src=\"/config/folder.gif\" />&nbsp;&nbsp;<a href=\"javascript:void(0)\" onclick=\"if (confirm('Are you SURE you want to delete the directory " + dirs[i] + "?')) ajax_FsBrowseClean([true, 'dir=" + encodeURIComponent(cwd) + "&amp;path=";
r += (root) ? encodeURIComponent(cwd + dirs[i]) : encodeURIComponent(cwd + '/' + dirs[i]);
r += "&amp;action=deletedir']); return false;\"><img src=\"/config/remove.gif\" /></a></td>";
r += "<td><a href=\"javascript:void(0)\" onclick=\"return ajax_AddToHistory('FsBrowsePage', [true, 'dir=";
r += (root) ? encodeURIComponent(cwd + dirs[i]) : encodeURIComponent(cwd + '/' + dirs[i]);
r += "']);\">" + dirs[i] + "</a></td><td></td>";
r += "</tr>";
}

for (i = 0; i < files.length; i++)
{
r += "<tr>";
r += "<td>&nbsp;&nbsp;&nbsp;<img src=\"/config/file.gif\" />&nbsp;&nbsp;<a href=\"javascript:void(0)\" onclick=\"if (confirm('Are you SURE you want to delete the file " + files[i][0] + "?')) ajax_FsBrowseClean([true, 'dir=" + encodeURIComponent(cwd) + "&amp;path=";
r += (root) ? encodeURIComponent(cwd + files[i][0]) : encodeURIComponent(cwd + '/' + files[i][0]);
r += "&amp;action=deletefile']); return false;\"><img src=\"/config/remove.gif\" /></a></td>";
r += "<td><a href=\"/fs?file=";
r += (root) ? encodeURIComponent(cwd + files[i][0]) : encodeURIComponent(cwd + '/' + files[i][0]);
r += "\" target=\"_blank\">" + files[i][0] + "</a></td><td>" + files[i][1] + "</td>";
r += "</tr>";
}

r += "</table>";

d.innerHTML = r;
}

function FsUploadClearForm(xml)
{
var p = document.getElementById('uploadform');
var oldInput = document.getElementById('fsuploadfile');
var newInput = document.createElement('input');
newInput.id = 'fsuploadfile';
newInput.name = 'selectedfile';
newInput.type = 'file';
newInput.size = '32';
newInput.maxlength = '255';
p.replaceChild(newInput, oldInput);
}
