_msgs.filter =
[
/* 0  */ "ERROR: Failed to get the filter statistics.",
/* 1  */ "ERROR: Invalid IP Address.",
/* 2  */ "ERROR: Invalid Network Mask.",
/* 3  */ "ERROR: The address is already in the IP Address Filter Table.",
/* 4  */ "ERROR: The IP Address Filter Table is full.",
/* 5  */ "ERROR: Failed to add the address to the IP Address Filter Table.",
/* 6  */ "ERROR: Must enter both an IP Address and Network Mask.",
/* 7  */ "ERROR: IP Address not in table.",
/* 8  */ "ERROR: Failed to remove the IP Address.",
/* 9  */ "The IP Address has been removed.",
/* 10 */ "{} has been added to the IP Address Filter Table.",
/* 11 */ "IP Address Filtering has been removed.",
];

function IpFilterRender(xml)
{
var d = document.getElementById('filterdata');
d.innerHTML = '';
var r = '';
var numIps = 0;
r += GetXmlData(xml, "si") + " incoming and " + GetXmlData(xml, "so");
r += " outgoing packets have been filtered since the last reboot.";
r += "<table class=\"basicTable ipFilterTable\">";
r += "<thead><tr><th>IP Address</th><th>Network Mask</th></tr></thead>";
r += "<tbody>";
for(var i = 0; xml && i < xml.childNodes.length; i++)
{
var node = xml.childNodes[i];
if(node.nodeName.toLowerCase() == "f")
{
numIps++;
var ip = GetXmlData(node, "i");
var mask = GetXmlData(node, "n");
r += "<tr><td>" + ip + " [<a ";
r += 'href="javascript:void(0)"';
r += 'onclick="';
r += "if(";
r += "confirm('Are you SURE you want to remove this address?')";
r += "){";
r += "FileSystemMonitor();";
r += "ajax_IpFilterClean(";
r += "[true,'action=delete&amp;ip=" + ip + "&amp;mask=" + mask + "']";
r += ");";
r += "}";
r += "return false;";
r += '"';
r += ">Remove</a>]</td><td>" + mask + "</td></tr>";
}
}
r += "</tbody></table>";
if(!numIps)
{
d.innerHTML = "The IP Filter Table is empty so ALL addresses are allowed.<br/>";
}
else
{
r += "<h3>[<a ";
r += 'href="javascript:void(0)"';
r += 'onclick="';
r += "if(";
r += "confirm('Are you SURE you want to remove filtering?')";
r += "){";
r += "FileSystemMonitor();";
r += "ajax_IpFilterClean([true, 'action=deleteall']);";
r += "}";
r += "return false;";
r += '"';
r += ">Remove All</a>]</h3>";
d.innerHTML = r;
}
}
