; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p loop-vectorize -force-vector-width=2 -S %s | FileCheck --check-prefixes=VF2 %s
; RUN: opt -p loop-vectorize -force-vector-width=4 -S %s | FileCheck --check-prefixes=VF4 %s

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-f80:128-n8:16:32:64-S128"

define void @test_2xi64(ptr noalias %data, ptr noalias %factor, i64 noundef %n) {
; VF2-LABEL: define void @test_2xi64(
; VF2-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*]]:
; VF2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 2
; VF2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 2
; VF2-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP2]], align 8
; VF2-NEXT:    [[TMP3:%.*]] = shl nsw <2 x i64> [[VEC_IND]], splat (i64 1)
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> poison, i64 [[TMP8]], i32 0
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> [[TMP10]], i64 [[TMP9]], i32 1
; VF2-NEXT:    [[TMP12:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[TMP11]]
; VF2-NEXT:    [[TMP13:%.*]] = extractelement <2 x i64> [[TMP12]], i32 0
; VF2-NEXT:    store i64 [[TMP13]], ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP14:%.*]] = extractelement <2 x i64> [[TMP12]], i32 1
; VF2-NEXT:    store i64 [[TMP14]], ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP15:%.*]] = or disjoint <2 x i64> [[TMP3]], splat (i64 1)
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i64> [[TMP15]], i32 0
; VF2-NEXT:    [[TMP17:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP16]]
; VF2-NEXT:    [[TMP18:%.*]] = extractelement <2 x i64> [[TMP15]], i32 1
; VF2-NEXT:    [[TMP19:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP18]]
; VF2-NEXT:    [[TMP20:%.*]] = load i64, ptr [[TMP17]], align 8
; VF2-NEXT:    [[TMP21:%.*]] = load i64, ptr [[TMP19]], align 8
; VF2-NEXT:    [[TMP22:%.*]] = insertelement <2 x i64> poison, i64 [[TMP20]], i32 0
; VF2-NEXT:    [[TMP23:%.*]] = insertelement <2 x i64> [[TMP22]], i64 [[TMP21]], i32 1
; VF2-NEXT:    [[TMP24:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[TMP23]]
; VF2-NEXT:    [[TMP25:%.*]] = extractelement <2 x i64> [[TMP24]], i32 0
; VF2-NEXT:    store i64 [[TMP25]], ptr [[TMP17]], align 8
; VF2-NEXT:    [[TMP26:%.*]] = extractelement <2 x i64> [[TMP24]], i32 1
; VF2-NEXT:    store i64 [[TMP26]], ptr [[TMP19]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], splat (i64 2)
; VF2-NEXT:    [[TMP27:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2-NEXT:    br i1 [[TMP27]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF2-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF2-NEXT:    br label %[[LOOP:.*]]
; VF2:       [[LOOP]]:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF2-NEXT:    [[L_FACTOR:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
; VF2-NEXT:    [[TMP28:%.*]] = shl nsw i64 [[IV]], 1
; VF2-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP28]]
; VF2-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF2-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_FACTOR]], [[L_0]]
; VF2-NEXT:    store i64 [[MUL_0]], ptr [[DATA_0]], align 8
; VF2-NEXT:    [[TMP29:%.*]] = or disjoint i64 [[TMP28]], 1
; VF2-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP29]]
; VF2-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF2-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_FACTOR]], [[L_1]]
; VF2-NEXT:    store i64 [[MUL_1]], ptr [[DATA_1]], align 8
; VF2-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF2-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF2-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP3:![0-9]+]]
; VF2:       [[EXIT]]:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @test_2xi64(
; VF4-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*]]:
; VF4-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 4
; VF4-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 4
; VF4-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF4-NEXT:    [[WIDE_LOAD:%.*]] = load <4 x i64>, ptr [[TMP2]], align 8
; VF4-NEXT:    [[TMP3:%.*]] = shl nsw <4 x i64> [[VEC_IND]], splat (i64 1)
; VF4-NEXT:    [[TMP4:%.*]] = extractelement <4 x i64> [[TMP3]], i32 0
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP3]], i32 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP3]], i32 2
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP3]], i32 3
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> poison, i64 [[TMP12]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> [[TMP16]], i64 [[TMP13]], i32 1
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 2
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 3
; VF4-NEXT:    [[TMP20:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[TMP19]]
; VF4-NEXT:    [[TMP21:%.*]] = extractelement <4 x i64> [[TMP20]], i32 0
; VF4-NEXT:    store i64 [[TMP21]], ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP22:%.*]] = extractelement <4 x i64> [[TMP20]], i32 1
; VF4-NEXT:    store i64 [[TMP22]], ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP23:%.*]] = extractelement <4 x i64> [[TMP20]], i32 2
; VF4-NEXT:    store i64 [[TMP23]], ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP24:%.*]] = extractelement <4 x i64> [[TMP20]], i32 3
; VF4-NEXT:    store i64 [[TMP24]], ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP25:%.*]] = or disjoint <4 x i64> [[TMP3]], splat (i64 1)
; VF4-NEXT:    [[TMP26:%.*]] = extractelement <4 x i64> [[TMP25]], i32 0
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP26]]
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP25]], i32 1
; VF4-NEXT:    [[TMP29:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP28]]
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP25]], i32 2
; VF4-NEXT:    [[TMP31:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP30]]
; VF4-NEXT:    [[TMP32:%.*]] = extractelement <4 x i64> [[TMP25]], i32 3
; VF4-NEXT:    [[TMP33:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP32]]
; VF4-NEXT:    [[TMP34:%.*]] = load i64, ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP35:%.*]] = load i64, ptr [[TMP29]], align 8
; VF4-NEXT:    [[TMP36:%.*]] = load i64, ptr [[TMP31]], align 8
; VF4-NEXT:    [[TMP37:%.*]] = load i64, ptr [[TMP33]], align 8
; VF4-NEXT:    [[TMP38:%.*]] = insertelement <4 x i64> poison, i64 [[TMP34]], i32 0
; VF4-NEXT:    [[TMP39:%.*]] = insertelement <4 x i64> [[TMP38]], i64 [[TMP35]], i32 1
; VF4-NEXT:    [[TMP40:%.*]] = insertelement <4 x i64> [[TMP39]], i64 [[TMP36]], i32 2
; VF4-NEXT:    [[TMP41:%.*]] = insertelement <4 x i64> [[TMP40]], i64 [[TMP37]], i32 3
; VF4-NEXT:    [[TMP42:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[TMP41]]
; VF4-NEXT:    [[TMP43:%.*]] = extractelement <4 x i64> [[TMP42]], i32 0
; VF4-NEXT:    store i64 [[TMP43]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP44:%.*]] = extractelement <4 x i64> [[TMP42]], i32 1
; VF4-NEXT:    store i64 [[TMP44]], ptr [[TMP29]], align 8
; VF4-NEXT:    [[TMP45:%.*]] = extractelement <4 x i64> [[TMP42]], i32 2
; VF4-NEXT:    store i64 [[TMP45]], ptr [[TMP31]], align 8
; VF4-NEXT:    [[TMP46:%.*]] = extractelement <4 x i64> [[TMP42]], i32 3
; VF4-NEXT:    store i64 [[TMP46]], ptr [[TMP33]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 4)
; VF4-NEXT:    [[TMP47:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF4-NEXT:    br i1 [[TMP47]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF4-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF4-NEXT:    br label %[[LOOP:.*]]
; VF4:       [[LOOP]]:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF4-NEXT:    [[L_FACTOR:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
; VF4-NEXT:    [[TMP48:%.*]] = shl nsw i64 [[IV]], 1
; VF4-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP48]]
; VF4-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF4-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_FACTOR]], [[L_0]]
; VF4-NEXT:    store i64 [[MUL_0]], ptr [[DATA_0]], align 8
; VF4-NEXT:    [[TMP49:%.*]] = or disjoint i64 [[TMP48]], 1
; VF4-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP49]]
; VF4-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF4-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_FACTOR]], [[L_1]]
; VF4-NEXT:    store i64 [[MUL_1]], ptr [[DATA_1]], align 8
; VF4-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF4-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF4-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP3:![0-9]+]]
; VF4:       [[EXIT]]:
; VF4-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %arrayidx = getelementptr inbounds i64, ptr %factor, i64 %iv
  %l.factor = load i64, ptr %arrayidx, align 8
  %1 = shl nsw i64 %iv, 1
  %data.0 = getelementptr inbounds i64, ptr %data, i64 %1
  %l.0 = load i64, ptr %data.0, align 8
  %mul.0 = mul i64 %l.factor, %l.0
  store i64 %mul.0, ptr %data.0, align 8
  %3 = or disjoint i64 %1, 1
  %data.1 = getelementptr inbounds i64, ptr %data, i64 %3
  %l.1 = load i64, ptr %data.1, align 8
  %mul.1 = mul i64 %l.factor, %l.1
  store i64 %mul.1, ptr %data.1, align 8
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, %n
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_2xi64_interleave_loads_order_flipped(ptr noalias %data, ptr noalias %factor, i64 noundef %n) {
; VF2-LABEL: define void @test_2xi64_interleave_loads_order_flipped(
; VF2-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*]]:
; VF2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 2
; VF2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 2
; VF2-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP2]], align 8
; VF2-NEXT:    [[TMP3:%.*]] = shl nsw <2 x i64> [[VEC_IND]], splat (i64 1)
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> poison, i64 [[TMP8]], i32 0
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> [[TMP10]], i64 [[TMP9]], i32 1
; VF2-NEXT:    [[TMP12:%.*]] = or disjoint <2 x i64> [[TMP3]], splat (i64 1)
; VF2-NEXT:    [[TMP13:%.*]] = extractelement <2 x i64> [[TMP12]], i32 0
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP13]]
; VF2-NEXT:    [[TMP15:%.*]] = extractelement <2 x i64> [[TMP12]], i32 1
; VF2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP15]]
; VF2-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP14]], align 8
; VF2-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP16]], align 8
; VF2-NEXT:    [[TMP19:%.*]] = insertelement <2 x i64> poison, i64 [[TMP17]], i32 0
; VF2-NEXT:    [[TMP20:%.*]] = insertelement <2 x i64> [[TMP19]], i64 [[TMP18]], i32 1
; VF2-NEXT:    [[TMP21:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[TMP20]]
; VF2-NEXT:    [[TMP22:%.*]] = extractelement <2 x i64> [[TMP21]], i32 0
; VF2-NEXT:    store i64 [[TMP22]], ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP23:%.*]] = extractelement <2 x i64> [[TMP21]], i32 1
; VF2-NEXT:    store i64 [[TMP23]], ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP24:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[TMP11]]
; VF2-NEXT:    [[TMP25:%.*]] = extractelement <2 x i64> [[TMP24]], i32 0
; VF2-NEXT:    store i64 [[TMP25]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[TMP26:%.*]] = extractelement <2 x i64> [[TMP24]], i32 1
; VF2-NEXT:    store i64 [[TMP26]], ptr [[TMP16]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], splat (i64 2)
; VF2-NEXT:    [[TMP27:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2-NEXT:    br i1 [[TMP27]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF2-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF2-NEXT:    br label %[[LOOP:.*]]
; VF2:       [[LOOP]]:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF2-NEXT:    [[L_FACTOR:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
; VF2-NEXT:    [[TMP28:%.*]] = shl nsw i64 [[IV]], 1
; VF2-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP28]]
; VF2-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF2-NEXT:    [[TMP29:%.*]] = or disjoint i64 [[TMP28]], 1
; VF2-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP29]]
; VF2-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF2-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_FACTOR]], [[L_1]]
; VF2-NEXT:    store i64 [[MUL_0]], ptr [[DATA_0]], align 8
; VF2-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_FACTOR]], [[L_0]]
; VF2-NEXT:    store i64 [[MUL_1]], ptr [[DATA_1]], align 8
; VF2-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF2-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF2-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP5:![0-9]+]]
; VF2:       [[EXIT]]:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @test_2xi64_interleave_loads_order_flipped(
; VF4-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*]]:
; VF4-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 4
; VF4-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 4
; VF4-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF4-NEXT:    [[WIDE_LOAD:%.*]] = load <4 x i64>, ptr [[TMP2]], align 8
; VF4-NEXT:    [[TMP3:%.*]] = shl nsw <4 x i64> [[VEC_IND]], splat (i64 1)
; VF4-NEXT:    [[TMP4:%.*]] = extractelement <4 x i64> [[TMP3]], i32 0
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP3]], i32 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP3]], i32 2
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP3]], i32 3
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> poison, i64 [[TMP12]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> [[TMP16]], i64 [[TMP13]], i32 1
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 2
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 3
; VF4-NEXT:    [[TMP20:%.*]] = or disjoint <4 x i64> [[TMP3]], splat (i64 1)
; VF4-NEXT:    [[TMP21:%.*]] = extractelement <4 x i64> [[TMP20]], i32 0
; VF4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP21]]
; VF4-NEXT:    [[TMP23:%.*]] = extractelement <4 x i64> [[TMP20]], i32 1
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP23]]
; VF4-NEXT:    [[TMP25:%.*]] = extractelement <4 x i64> [[TMP20]], i32 2
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP25]]
; VF4-NEXT:    [[TMP27:%.*]] = extractelement <4 x i64> [[TMP20]], i32 3
; VF4-NEXT:    [[TMP28:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP27]]
; VF4-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP22]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = load i64, ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = load i64, ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP32:%.*]] = load i64, ptr [[TMP28]], align 8
; VF4-NEXT:    [[TMP33:%.*]] = insertelement <4 x i64> poison, i64 [[TMP29]], i32 0
; VF4-NEXT:    [[TMP34:%.*]] = insertelement <4 x i64> [[TMP33]], i64 [[TMP30]], i32 1
; VF4-NEXT:    [[TMP35:%.*]] = insertelement <4 x i64> [[TMP34]], i64 [[TMP31]], i32 2
; VF4-NEXT:    [[TMP36:%.*]] = insertelement <4 x i64> [[TMP35]], i64 [[TMP32]], i32 3
; VF4-NEXT:    [[TMP37:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[TMP36]]
; VF4-NEXT:    [[TMP38:%.*]] = extractelement <4 x i64> [[TMP37]], i32 0
; VF4-NEXT:    store i64 [[TMP38]], ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP39:%.*]] = extractelement <4 x i64> [[TMP37]], i32 1
; VF4-NEXT:    store i64 [[TMP39]], ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP40:%.*]] = extractelement <4 x i64> [[TMP37]], i32 2
; VF4-NEXT:    store i64 [[TMP40]], ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP41:%.*]] = extractelement <4 x i64> [[TMP37]], i32 3
; VF4-NEXT:    store i64 [[TMP41]], ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP42:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[TMP19]]
; VF4-NEXT:    [[TMP43:%.*]] = extractelement <4 x i64> [[TMP42]], i32 0
; VF4-NEXT:    store i64 [[TMP43]], ptr [[TMP22]], align 8
; VF4-NEXT:    [[TMP44:%.*]] = extractelement <4 x i64> [[TMP42]], i32 1
; VF4-NEXT:    store i64 [[TMP44]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP45:%.*]] = extractelement <4 x i64> [[TMP42]], i32 2
; VF4-NEXT:    store i64 [[TMP45]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP46:%.*]] = extractelement <4 x i64> [[TMP42]], i32 3
; VF4-NEXT:    store i64 [[TMP46]], ptr [[TMP28]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 4)
; VF4-NEXT:    [[TMP47:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF4-NEXT:    br i1 [[TMP47]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF4-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF4-NEXT:    br label %[[LOOP:.*]]
; VF4:       [[LOOP]]:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF4-NEXT:    [[L_FACTOR:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
; VF4-NEXT:    [[TMP48:%.*]] = shl nsw i64 [[IV]], 1
; VF4-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP48]]
; VF4-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF4-NEXT:    [[TMP49:%.*]] = or disjoint i64 [[TMP48]], 1
; VF4-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP49]]
; VF4-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF4-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_FACTOR]], [[L_1]]
; VF4-NEXT:    store i64 [[MUL_0]], ptr [[DATA_0]], align 8
; VF4-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_FACTOR]], [[L_0]]
; VF4-NEXT:    store i64 [[MUL_1]], ptr [[DATA_1]], align 8
; VF4-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF4-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF4-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP5:![0-9]+]]
; VF4:       [[EXIT]]:
; VF4-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %arrayidx = getelementptr inbounds i64, ptr %factor, i64 %iv
  %l.factor = load i64, ptr %arrayidx, align 8
  %1 = shl nsw i64 %iv, 1
  %data.0 = getelementptr inbounds i64, ptr %data, i64 %1
  %l.0 = load i64, ptr %data.0, align 8
  %3 = or disjoint i64 %1, 1
  %data.1 = getelementptr inbounds i64, ptr %data, i64 %3
  %l.1 = load i64, ptr %data.1, align 8
  %mul.0 = mul i64 %l.factor, %l.1
  store i64 %mul.0, ptr %data.0, align 8
  %mul.1 = mul i64 %l.factor, %l.0
  store i64 %mul.1, ptr %data.1, align 8
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, %n
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_2xi64_store_order_flipped_1(ptr noalias %data, ptr noalias %factor, i64 noundef %n) {
; VF2-LABEL: define void @test_2xi64_store_order_flipped_1(
; VF2-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*]]:
; VF2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 2
; VF2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 2
; VF2-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP2]], align 8
; VF2-NEXT:    [[TMP3:%.*]] = shl nsw <2 x i64> [[VEC_IND]], splat (i64 1)
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> poison, i64 [[TMP8]], i32 0
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> [[TMP10]], i64 [[TMP9]], i32 1
; VF2-NEXT:    [[TMP12:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[TMP11]]
; VF2-NEXT:    [[TMP13:%.*]] = or disjoint <2 x i64> [[TMP3]], splat (i64 1)
; VF2-NEXT:    [[TMP14:%.*]] = extractelement <2 x i64> [[TMP13]], i32 0
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP14]]
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i64> [[TMP13]], i32 1
; VF2-NEXT:    [[TMP17:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP16]]
; VF2-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP15]], align 8
; VF2-NEXT:    [[TMP19:%.*]] = load i64, ptr [[TMP17]], align 8
; VF2-NEXT:    [[TMP20:%.*]] = insertelement <2 x i64> poison, i64 [[TMP18]], i32 0
; VF2-NEXT:    [[TMP21:%.*]] = insertelement <2 x i64> [[TMP20]], i64 [[TMP19]], i32 1
; VF2-NEXT:    [[TMP22:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[TMP21]]
; VF2-NEXT:    [[TMP23:%.*]] = extractelement <2 x i64> [[TMP22]], i32 0
; VF2-NEXT:    store i64 [[TMP23]], ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP24:%.*]] = extractelement <2 x i64> [[TMP22]], i32 1
; VF2-NEXT:    store i64 [[TMP24]], ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP25:%.*]] = extractelement <2 x i64> [[TMP12]], i32 0
; VF2-NEXT:    store i64 [[TMP25]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[TMP26:%.*]] = extractelement <2 x i64> [[TMP12]], i32 1
; VF2-NEXT:    store i64 [[TMP26]], ptr [[TMP17]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], splat (i64 2)
; VF2-NEXT:    [[TMP27:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2-NEXT:    br i1 [[TMP27]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF2-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF2-NEXT:    br label %[[LOOP:.*]]
; VF2:       [[LOOP]]:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF2-NEXT:    [[L_FACTOR:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
; VF2-NEXT:    [[TMP28:%.*]] = shl nsw i64 [[IV]], 1
; VF2-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP28]]
; VF2-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF2-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_FACTOR]], [[L_0]]
; VF2-NEXT:    [[TMP29:%.*]] = or disjoint i64 [[TMP28]], 1
; VF2-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP29]]
; VF2-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF2-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_FACTOR]], [[L_1]]
; VF2-NEXT:    store i64 [[MUL_1]], ptr [[DATA_0]], align 8
; VF2-NEXT:    store i64 [[MUL_0]], ptr [[DATA_1]], align 8
; VF2-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF2-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF2-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP7:![0-9]+]]
; VF2:       [[EXIT]]:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @test_2xi64_store_order_flipped_1(
; VF4-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*]]:
; VF4-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 4
; VF4-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 4
; VF4-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF4-NEXT:    [[WIDE_LOAD:%.*]] = load <4 x i64>, ptr [[TMP2]], align 8
; VF4-NEXT:    [[TMP3:%.*]] = shl nsw <4 x i64> [[VEC_IND]], splat (i64 1)
; VF4-NEXT:    [[TMP4:%.*]] = extractelement <4 x i64> [[TMP3]], i32 0
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP3]], i32 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP3]], i32 2
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP3]], i32 3
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> poison, i64 [[TMP12]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> [[TMP16]], i64 [[TMP13]], i32 1
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 2
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 3
; VF4-NEXT:    [[TMP20:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[TMP19]]
; VF4-NEXT:    [[TMP21:%.*]] = or disjoint <4 x i64> [[TMP3]], splat (i64 1)
; VF4-NEXT:    [[TMP22:%.*]] = extractelement <4 x i64> [[TMP21]], i32 0
; VF4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP22]]
; VF4-NEXT:    [[TMP24:%.*]] = extractelement <4 x i64> [[TMP21]], i32 1
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP24]]
; VF4-NEXT:    [[TMP26:%.*]] = extractelement <4 x i64> [[TMP21]], i32 2
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP26]]
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP21]], i32 3
; VF4-NEXT:    [[TMP29:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP28]]
; VF4-NEXT:    [[TMP30:%.*]] = load i64, ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = load i64, ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP32:%.*]] = load i64, ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP33:%.*]] = load i64, ptr [[TMP29]], align 8
; VF4-NEXT:    [[TMP34:%.*]] = insertelement <4 x i64> poison, i64 [[TMP30]], i32 0
; VF4-NEXT:    [[TMP35:%.*]] = insertelement <4 x i64> [[TMP34]], i64 [[TMP31]], i32 1
; VF4-NEXT:    [[TMP36:%.*]] = insertelement <4 x i64> [[TMP35]], i64 [[TMP32]], i32 2
; VF4-NEXT:    [[TMP37:%.*]] = insertelement <4 x i64> [[TMP36]], i64 [[TMP33]], i32 3
; VF4-NEXT:    [[TMP38:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[TMP37]]
; VF4-NEXT:    [[TMP39:%.*]] = extractelement <4 x i64> [[TMP38]], i32 0
; VF4-NEXT:    store i64 [[TMP39]], ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP40:%.*]] = extractelement <4 x i64> [[TMP38]], i32 1
; VF4-NEXT:    store i64 [[TMP40]], ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP41:%.*]] = extractelement <4 x i64> [[TMP38]], i32 2
; VF4-NEXT:    store i64 [[TMP41]], ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP42:%.*]] = extractelement <4 x i64> [[TMP38]], i32 3
; VF4-NEXT:    store i64 [[TMP42]], ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP43:%.*]] = extractelement <4 x i64> [[TMP20]], i32 0
; VF4-NEXT:    store i64 [[TMP43]], ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP44:%.*]] = extractelement <4 x i64> [[TMP20]], i32 1
; VF4-NEXT:    store i64 [[TMP44]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP45:%.*]] = extractelement <4 x i64> [[TMP20]], i32 2
; VF4-NEXT:    store i64 [[TMP45]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP46:%.*]] = extractelement <4 x i64> [[TMP20]], i32 3
; VF4-NEXT:    store i64 [[TMP46]], ptr [[TMP29]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 4)
; VF4-NEXT:    [[TMP47:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF4-NEXT:    br i1 [[TMP47]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF4-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF4-NEXT:    br label %[[LOOP:.*]]
; VF4:       [[LOOP]]:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF4-NEXT:    [[L_FACTOR:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
; VF4-NEXT:    [[TMP48:%.*]] = shl nsw i64 [[IV]], 1
; VF4-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP48]]
; VF4-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF4-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_FACTOR]], [[L_0]]
; VF4-NEXT:    [[TMP49:%.*]] = or disjoint i64 [[TMP48]], 1
; VF4-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP49]]
; VF4-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF4-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_FACTOR]], [[L_1]]
; VF4-NEXT:    store i64 [[MUL_1]], ptr [[DATA_0]], align 8
; VF4-NEXT:    store i64 [[MUL_0]], ptr [[DATA_1]], align 8
; VF4-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF4-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF4-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP7:![0-9]+]]
; VF4:       [[EXIT]]:
; VF4-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %arrayidx = getelementptr inbounds i64, ptr %factor, i64 %iv
  %l.factor = load i64, ptr %arrayidx, align 8
  %1 = shl nsw i64 %iv, 1
  %data.0 = getelementptr inbounds i64, ptr %data, i64 %1
  %l.0 = load i64, ptr %data.0, align 8
  %mul.0 = mul i64 %l.factor, %l.0
  %3 = or disjoint i64 %1, 1
  %data.1 = getelementptr inbounds i64, ptr %data, i64 %3
  %l.1 = load i64, ptr %data.1, align 8
  %mul.1 = mul i64 %l.factor, %l.1
  store i64 %mul.1, ptr %data.0, align 8
  store i64 %mul.0, ptr %data.1, align 8
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, %n
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_2xi64_store_order_flipped_2(ptr noalias %data, ptr noalias %factor, i64 noundef %n) {
; VF2-LABEL: define void @test_2xi64_store_order_flipped_2(
; VF2-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*]]:
; VF2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 2
; VF2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 2
; VF2-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP2]], align 8
; VF2-NEXT:    [[TMP3:%.*]] = shl nsw <2 x i64> [[VEC_IND]], splat (i64 1)
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> poison, i64 [[TMP8]], i32 0
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> [[TMP10]], i64 [[TMP9]], i32 1
; VF2-NEXT:    [[TMP12:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[TMP11]]
; VF2-NEXT:    [[TMP13:%.*]] = or disjoint <2 x i64> [[TMP3]], splat (i64 1)
; VF2-NEXT:    [[TMP14:%.*]] = extractelement <2 x i64> [[TMP13]], i32 0
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP14]]
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i64> [[TMP13]], i32 1
; VF2-NEXT:    [[TMP17:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP16]]
; VF2-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP15]], align 8
; VF2-NEXT:    [[TMP19:%.*]] = load i64, ptr [[TMP17]], align 8
; VF2-NEXT:    [[TMP20:%.*]] = insertelement <2 x i64> poison, i64 [[TMP18]], i32 0
; VF2-NEXT:    [[TMP21:%.*]] = insertelement <2 x i64> [[TMP20]], i64 [[TMP19]], i32 1
; VF2-NEXT:    [[TMP22:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[TMP21]]
; VF2-NEXT:    [[TMP23:%.*]] = extractelement <2 x i64> [[TMP12]], i32 0
; VF2-NEXT:    store i64 [[TMP23]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[TMP24:%.*]] = extractelement <2 x i64> [[TMP12]], i32 1
; VF2-NEXT:    store i64 [[TMP24]], ptr [[TMP17]], align 8
; VF2-NEXT:    [[TMP25:%.*]] = extractelement <2 x i64> [[TMP22]], i32 0
; VF2-NEXT:    store i64 [[TMP25]], ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP26:%.*]] = extractelement <2 x i64> [[TMP22]], i32 1
; VF2-NEXT:    store i64 [[TMP26]], ptr [[TMP7]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], splat (i64 2)
; VF2-NEXT:    [[TMP27:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2-NEXT:    br i1 [[TMP27]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP8:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF2-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF2-NEXT:    br label %[[LOOP:.*]]
; VF2:       [[LOOP]]:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF2-NEXT:    [[L_FACTOR:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
; VF2-NEXT:    [[TMP28:%.*]] = shl nsw i64 [[IV]], 1
; VF2-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP28]]
; VF2-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF2-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_FACTOR]], [[L_0]]
; VF2-NEXT:    [[TMP29:%.*]] = or disjoint i64 [[TMP28]], 1
; VF2-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP29]]
; VF2-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF2-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_FACTOR]], [[L_1]]
; VF2-NEXT:    store i64 [[MUL_0]], ptr [[DATA_1]], align 8
; VF2-NEXT:    store i64 [[MUL_1]], ptr [[DATA_0]], align 8
; VF2-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF2-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF2-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP9:![0-9]+]]
; VF2:       [[EXIT]]:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @test_2xi64_store_order_flipped_2(
; VF4-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*]]:
; VF4-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 4
; VF4-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 4
; VF4-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF4-NEXT:    [[WIDE_LOAD:%.*]] = load <4 x i64>, ptr [[TMP2]], align 8
; VF4-NEXT:    [[TMP3:%.*]] = shl nsw <4 x i64> [[VEC_IND]], splat (i64 1)
; VF4-NEXT:    [[TMP4:%.*]] = extractelement <4 x i64> [[TMP3]], i32 0
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP3]], i32 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP3]], i32 2
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP3]], i32 3
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> poison, i64 [[TMP12]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> [[TMP16]], i64 [[TMP13]], i32 1
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 2
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 3
; VF4-NEXT:    [[TMP20:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[TMP19]]
; VF4-NEXT:    [[TMP21:%.*]] = or disjoint <4 x i64> [[TMP3]], splat (i64 1)
; VF4-NEXT:    [[TMP22:%.*]] = extractelement <4 x i64> [[TMP21]], i32 0
; VF4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP22]]
; VF4-NEXT:    [[TMP24:%.*]] = extractelement <4 x i64> [[TMP21]], i32 1
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP24]]
; VF4-NEXT:    [[TMP26:%.*]] = extractelement <4 x i64> [[TMP21]], i32 2
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP26]]
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP21]], i32 3
; VF4-NEXT:    [[TMP29:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP28]]
; VF4-NEXT:    [[TMP30:%.*]] = load i64, ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = load i64, ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP32:%.*]] = load i64, ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP33:%.*]] = load i64, ptr [[TMP29]], align 8
; VF4-NEXT:    [[TMP34:%.*]] = insertelement <4 x i64> poison, i64 [[TMP30]], i32 0
; VF4-NEXT:    [[TMP35:%.*]] = insertelement <4 x i64> [[TMP34]], i64 [[TMP31]], i32 1
; VF4-NEXT:    [[TMP36:%.*]] = insertelement <4 x i64> [[TMP35]], i64 [[TMP32]], i32 2
; VF4-NEXT:    [[TMP37:%.*]] = insertelement <4 x i64> [[TMP36]], i64 [[TMP33]], i32 3
; VF4-NEXT:    [[TMP38:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[TMP37]]
; VF4-NEXT:    [[TMP39:%.*]] = extractelement <4 x i64> [[TMP20]], i32 0
; VF4-NEXT:    store i64 [[TMP39]], ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP40:%.*]] = extractelement <4 x i64> [[TMP20]], i32 1
; VF4-NEXT:    store i64 [[TMP40]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP41:%.*]] = extractelement <4 x i64> [[TMP20]], i32 2
; VF4-NEXT:    store i64 [[TMP41]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP42:%.*]] = extractelement <4 x i64> [[TMP20]], i32 3
; VF4-NEXT:    store i64 [[TMP42]], ptr [[TMP29]], align 8
; VF4-NEXT:    [[TMP43:%.*]] = extractelement <4 x i64> [[TMP38]], i32 0
; VF4-NEXT:    store i64 [[TMP43]], ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP44:%.*]] = extractelement <4 x i64> [[TMP38]], i32 1
; VF4-NEXT:    store i64 [[TMP44]], ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP45:%.*]] = extractelement <4 x i64> [[TMP38]], i32 2
; VF4-NEXT:    store i64 [[TMP45]], ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP46:%.*]] = extractelement <4 x i64> [[TMP38]], i32 3
; VF4-NEXT:    store i64 [[TMP46]], ptr [[TMP11]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 4)
; VF4-NEXT:    [[TMP47:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF4-NEXT:    br i1 [[TMP47]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP8:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF4-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF4-NEXT:    br label %[[LOOP:.*]]
; VF4:       [[LOOP]]:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF4-NEXT:    [[L_FACTOR:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
; VF4-NEXT:    [[TMP48:%.*]] = shl nsw i64 [[IV]], 1
; VF4-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP48]]
; VF4-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF4-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_FACTOR]], [[L_0]]
; VF4-NEXT:    [[TMP49:%.*]] = or disjoint i64 [[TMP48]], 1
; VF4-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP49]]
; VF4-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF4-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_FACTOR]], [[L_1]]
; VF4-NEXT:    store i64 [[MUL_0]], ptr [[DATA_1]], align 8
; VF4-NEXT:    store i64 [[MUL_1]], ptr [[DATA_0]], align 8
; VF4-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF4-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF4-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP9:![0-9]+]]
; VF4:       [[EXIT]]:
; VF4-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %arrayidx = getelementptr inbounds i64, ptr %factor, i64 %iv
  %l.factor = load i64, ptr %arrayidx, align 8
  %1 = shl nsw i64 %iv, 1
  %data.0 = getelementptr inbounds i64, ptr %data, i64 %1
  %l.0 = load i64, ptr %data.0, align 8
  %mul.0 = mul i64 %l.factor, %l.0
  %3 = or disjoint i64 %1, 1
  %data.1 = getelementptr inbounds i64, ptr %data, i64 %3
  %l.1 = load i64, ptr %data.1, align 8
  %mul.1 = mul i64 %l.factor, %l.1
  store i64 %mul.0, ptr %data.1, align 8
  store i64 %mul.1, ptr %data.0, align 8
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, %n
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_2xi64_different_loads_feeding_fmul(ptr noalias %data, ptr noalias %src.0, ptr noalias %src.1, i64 noundef %n) {
; VF2-LABEL: define void @test_2xi64_different_loads_feeding_fmul(
; VF2-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[SRC_0:%.*]], ptr noalias [[SRC_1:%.*]], i64 noundef [[N:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*]]:
; VF2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 2
; VF2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 2
; VF2-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[SRC_0]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP2]], align 8
; VF2-NEXT:    [[TMP3:%.*]] = shl nsw <2 x i64> [[VEC_IND]], splat (i64 1)
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP6]]
; VF2-NEXT:    [[WIDE_LOAD1:%.*]] = load <2 x i64>, ptr [[TMP2]], align 8
; VF2-NEXT:    [[TMP8:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[WIDE_LOAD1]]
; VF2-NEXT:    [[TMP9:%.*]] = extractelement <2 x i64> [[TMP8]], i32 0
; VF2-NEXT:    store i64 [[TMP9]], ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = extractelement <2 x i64> [[TMP8]], i32 1
; VF2-NEXT:    store i64 [[TMP10]], ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = or disjoint <2 x i64> [[TMP3]], splat (i64 1)
; VF2-NEXT:    [[TMP12:%.*]] = extractelement <2 x i64> [[TMP11]], i32 0
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP12]]
; VF2-NEXT:    [[TMP14:%.*]] = extractelement <2 x i64> [[TMP11]], i32 1
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP14]]
; VF2-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP13]], align 8
; VF2-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP15]], align 8
; VF2-NEXT:    [[TMP18:%.*]] = insertelement <2 x i64> poison, i64 [[TMP16]], i32 0
; VF2-NEXT:    [[TMP19:%.*]] = insertelement <2 x i64> [[TMP18]], i64 [[TMP17]], i32 1
; VF2-NEXT:    [[TMP20:%.*]] = getelementptr inbounds i64, ptr [[SRC_1]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP21:%.*]] = getelementptr inbounds i64, ptr [[TMP20]], i32 0
; VF2-NEXT:    [[WIDE_LOAD2:%.*]] = load <2 x i64>, ptr [[TMP21]], align 8
; VF2-NEXT:    [[TMP22:%.*]] = mul <2 x i64> [[WIDE_LOAD2]], [[TMP19]]
; VF2-NEXT:    [[TMP23:%.*]] = extractelement <2 x i64> [[TMP22]], i32 0
; VF2-NEXT:    store i64 [[TMP23]], ptr [[TMP13]], align 8
; VF2-NEXT:    [[TMP24:%.*]] = extractelement <2 x i64> [[TMP22]], i32 1
; VF2-NEXT:    store i64 [[TMP24]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], splat (i64 2)
; VF2-NEXT:    [[TMP25:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2-NEXT:    br i1 [[TMP25]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP10:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF2-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF2-NEXT:    br label %[[LOOP:.*]]
; VF2:       [[LOOP]]:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF2-NEXT:    [[GEP_SRC_0:%.*]] = getelementptr inbounds i64, ptr [[SRC_0]], i64 [[IV]]
; VF2-NEXT:    [[L_SRC_0:%.*]] = load i64, ptr [[GEP_SRC_0]], align 8
; VF2-NEXT:    [[TMP26:%.*]] = shl nsw i64 [[IV]], 1
; VF2-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP26]]
; VF2-NEXT:    [[L_0:%.*]] = load i64, ptr [[GEP_SRC_0]], align 8
; VF2-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_SRC_0]], [[L_0]]
; VF2-NEXT:    store i64 [[MUL_0]], ptr [[DATA_0]], align 8
; VF2-NEXT:    [[TMP27:%.*]] = or disjoint i64 [[TMP26]], 1
; VF2-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP27]]
; VF2-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF2-NEXT:    [[GEP_SRC_1:%.*]] = getelementptr inbounds i64, ptr [[SRC_1]], i64 [[IV]]
; VF2-NEXT:    [[L_SRC_1:%.*]] = load i64, ptr [[GEP_SRC_1]], align 8
; VF2-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_SRC_1]], [[L_1]]
; VF2-NEXT:    store i64 [[MUL_1]], ptr [[DATA_1]], align 8
; VF2-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF2-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF2-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP11:![0-9]+]]
; VF2:       [[EXIT]]:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @test_2xi64_different_loads_feeding_fmul(
; VF4-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[SRC_0:%.*]], ptr noalias [[SRC_1:%.*]], i64 noundef [[N:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*]]:
; VF4-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 4
; VF4-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 4
; VF4-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[SRC_0]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF4-NEXT:    [[WIDE_LOAD:%.*]] = load <4 x i64>, ptr [[TMP2]], align 8
; VF4-NEXT:    [[TMP3:%.*]] = shl nsw <4 x i64> [[VEC_IND]], splat (i64 1)
; VF4-NEXT:    [[TMP4:%.*]] = extractelement <4 x i64> [[TMP3]], i32 0
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP3]], i32 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP3]], i32 2
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP3]], i32 3
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP10]]
; VF4-NEXT:    [[WIDE_LOAD1:%.*]] = load <4 x i64>, ptr [[TMP2]], align 8
; VF4-NEXT:    [[TMP12:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[WIDE_LOAD1]]
; VF4-NEXT:    [[TMP13:%.*]] = extractelement <4 x i64> [[TMP12]], i32 0
; VF4-NEXT:    store i64 [[TMP13]], ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = extractelement <4 x i64> [[TMP12]], i32 1
; VF4-NEXT:    store i64 [[TMP14]], ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = extractelement <4 x i64> [[TMP12]], i32 2
; VF4-NEXT:    store i64 [[TMP15]], ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = extractelement <4 x i64> [[TMP12]], i32 3
; VF4-NEXT:    store i64 [[TMP16]], ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = or disjoint <4 x i64> [[TMP3]], splat (i64 1)
; VF4-NEXT:    [[TMP18:%.*]] = extractelement <4 x i64> [[TMP17]], i32 0
; VF4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP18]]
; VF4-NEXT:    [[TMP20:%.*]] = extractelement <4 x i64> [[TMP17]], i32 1
; VF4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP20]]
; VF4-NEXT:    [[TMP22:%.*]] = extractelement <4 x i64> [[TMP17]], i32 2
; VF4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP22]]
; VF4-NEXT:    [[TMP24:%.*]] = extractelement <4 x i64> [[TMP17]], i32 3
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP24]]
; VF4-NEXT:    [[TMP26:%.*]] = load i64, ptr [[TMP19]], align 8
; VF4-NEXT:    [[TMP27:%.*]] = load i64, ptr [[TMP21]], align 8
; VF4-NEXT:    [[TMP28:%.*]] = load i64, ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = insertelement <4 x i64> poison, i64 [[TMP26]], i32 0
; VF4-NEXT:    [[TMP31:%.*]] = insertelement <4 x i64> [[TMP30]], i64 [[TMP27]], i32 1
; VF4-NEXT:    [[TMP32:%.*]] = insertelement <4 x i64> [[TMP31]], i64 [[TMP28]], i32 2
; VF4-NEXT:    [[TMP33:%.*]] = insertelement <4 x i64> [[TMP32]], i64 [[TMP29]], i32 3
; VF4-NEXT:    [[TMP34:%.*]] = getelementptr inbounds i64, ptr [[SRC_1]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP35:%.*]] = getelementptr inbounds i64, ptr [[TMP34]], i32 0
; VF4-NEXT:    [[WIDE_LOAD2:%.*]] = load <4 x i64>, ptr [[TMP35]], align 8
; VF4-NEXT:    [[TMP36:%.*]] = mul <4 x i64> [[WIDE_LOAD2]], [[TMP33]]
; VF4-NEXT:    [[TMP37:%.*]] = extractelement <4 x i64> [[TMP36]], i32 0
; VF4-NEXT:    store i64 [[TMP37]], ptr [[TMP19]], align 8
; VF4-NEXT:    [[TMP38:%.*]] = extractelement <4 x i64> [[TMP36]], i32 1
; VF4-NEXT:    store i64 [[TMP38]], ptr [[TMP21]], align 8
; VF4-NEXT:    [[TMP39:%.*]] = extractelement <4 x i64> [[TMP36]], i32 2
; VF4-NEXT:    store i64 [[TMP39]], ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP40:%.*]] = extractelement <4 x i64> [[TMP36]], i32 3
; VF4-NEXT:    store i64 [[TMP40]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 4)
; VF4-NEXT:    [[TMP41:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF4-NEXT:    br i1 [[TMP41]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP10:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF4-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF4-NEXT:    br label %[[LOOP:.*]]
; VF4:       [[LOOP]]:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF4-NEXT:    [[GEP_SRC_0:%.*]] = getelementptr inbounds i64, ptr [[SRC_0]], i64 [[IV]]
; VF4-NEXT:    [[L_SRC_0:%.*]] = load i64, ptr [[GEP_SRC_0]], align 8
; VF4-NEXT:    [[TMP42:%.*]] = shl nsw i64 [[IV]], 1
; VF4-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP42]]
; VF4-NEXT:    [[L_0:%.*]] = load i64, ptr [[GEP_SRC_0]], align 8
; VF4-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_SRC_0]], [[L_0]]
; VF4-NEXT:    store i64 [[MUL_0]], ptr [[DATA_0]], align 8
; VF4-NEXT:    [[TMP43:%.*]] = or disjoint i64 [[TMP42]], 1
; VF4-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP43]]
; VF4-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF4-NEXT:    [[GEP_SRC_1:%.*]] = getelementptr inbounds i64, ptr [[SRC_1]], i64 [[IV]]
; VF4-NEXT:    [[L_SRC_1:%.*]] = load i64, ptr [[GEP_SRC_1]], align 8
; VF4-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_SRC_1]], [[L_1]]
; VF4-NEXT:    store i64 [[MUL_1]], ptr [[DATA_1]], align 8
; VF4-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF4-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF4-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP11:![0-9]+]]
; VF4:       [[EXIT]]:
; VF4-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %gep.src.0 = getelementptr inbounds i64, ptr %src.0, i64 %iv
  %l.src.0 = load i64, ptr %gep.src.0, align 8
  %1 = shl nsw i64 %iv, 1
  %data.0 = getelementptr inbounds i64, ptr %data, i64 %1
  %l.0 = load i64, ptr %gep.src.0, align 8
  %mul.0 = mul i64 %l.src.0, %l.0
  store i64 %mul.0, ptr %data.0, align 8
  %3 = or disjoint i64 %1, 1
  %data.1 = getelementptr inbounds i64, ptr %data, i64 %3
  %l.1 = load i64, ptr %data.1, align 8
  %gep.src.1 = getelementptr inbounds i64, ptr %src.1, i64 %iv
  %l.src.1 = load i64, ptr %gep.src.1, align 8
  %mul.1 = mul i64 %l.src.1, %l.1
  store i64 %mul.1, ptr %data.1, align 8
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, %n
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_3xi64(ptr noalias %data, ptr noalias %factor, i64 noundef %n) {
; VF2-LABEL: define void @test_3xi64(
; VF2-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*]]:
; VF2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 2
; VF2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 2
; VF2-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[INDEX]], 1
; VF2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i64, ptr [[TMP2]], i32 0
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP3]], align 8
; VF2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP0]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP1]], i32 0
; VF2-NEXT:    [[TMP6:%.*]] = load i64, ptr [[TMP4]], align 8
; VF2-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP8:%.*]] = insertelement <2 x i64> poison, i64 [[TMP6]], i32 0
; VF2-NEXT:    [[TMP9:%.*]] = insertelement <2 x i64> [[TMP8]], i64 [[TMP7]], i32 1
; VF2-NEXT:    [[TMP10:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[TMP9]]
; VF2-NEXT:    [[TMP11:%.*]] = extractelement <2 x i64> [[TMP10]], i32 0
; VF2-NEXT:    store i64 [[TMP11]], ptr [[TMP4]], align 8
; VF2-NEXT:    [[TMP12:%.*]] = extractelement <2 x i64> [[TMP10]], i32 1
; VF2-NEXT:    store i64 [[TMP12]], ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP0]], i32 1
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP1]], i32 1
; VF2-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP13]], align 8
; VF2-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP14]], align 8
; VF2-NEXT:    [[TMP17:%.*]] = insertelement <2 x i64> poison, i64 [[TMP15]], i32 0
; VF2-NEXT:    [[TMP18:%.*]] = insertelement <2 x i64> [[TMP17]], i64 [[TMP16]], i32 1
; VF2-NEXT:    [[TMP19:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[TMP18]]
; VF2-NEXT:    [[TMP20:%.*]] = extractelement <2 x i64> [[TMP19]], i32 0
; VF2-NEXT:    store i64 [[TMP20]], ptr [[TMP13]], align 8
; VF2-NEXT:    [[TMP21:%.*]] = extractelement <2 x i64> [[TMP19]], i32 1
; VF2-NEXT:    store i64 [[TMP21]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[TMP22:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP0]], i32 2
; VF2-NEXT:    [[TMP23:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP1]], i32 2
; VF2-NEXT:    [[TMP24:%.*]] = load i64, ptr [[TMP22]], align 8
; VF2-NEXT:    [[TMP25:%.*]] = load i64, ptr [[TMP23]], align 8
; VF2-NEXT:    [[TMP26:%.*]] = insertelement <2 x i64> poison, i64 [[TMP24]], i32 0
; VF2-NEXT:    [[TMP27:%.*]] = insertelement <2 x i64> [[TMP26]], i64 [[TMP25]], i32 1
; VF2-NEXT:    [[TMP28:%.*]] = mul <2 x i64> [[WIDE_LOAD]], [[TMP27]]
; VF2-NEXT:    [[TMP29:%.*]] = extractelement <2 x i64> [[TMP28]], i32 0
; VF2-NEXT:    store i64 [[TMP29]], ptr [[TMP22]], align 8
; VF2-NEXT:    [[TMP30:%.*]] = extractelement <2 x i64> [[TMP28]], i32 1
; VF2-NEXT:    store i64 [[TMP30]], ptr [[TMP23]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP31:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2-NEXT:    br i1 [[TMP31]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP12:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF2-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF2-NEXT:    br label %[[LOOP:.*]]
; VF2:       [[LOOP]]:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF2-NEXT:    [[L_FACTOR:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
; VF2-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[IV]], i32 0
; VF2-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF2-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_FACTOR]], [[L_0]]
; VF2-NEXT:    store i64 [[MUL_0]], ptr [[DATA_0]], align 8
; VF2-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[IV]], i32 1
; VF2-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF2-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_FACTOR]], [[L_1]]
; VF2-NEXT:    store i64 [[MUL_1]], ptr [[DATA_1]], align 8
; VF2-NEXT:    [[DATA_2:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[IV]], i32 2
; VF2-NEXT:    [[L_2:%.*]] = load i64, ptr [[DATA_2]], align 8
; VF2-NEXT:    [[MUL_2:%.*]] = mul i64 [[L_FACTOR]], [[L_2]]
; VF2-NEXT:    store i64 [[MUL_2]], ptr [[DATA_2]], align 8
; VF2-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF2-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF2-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP13:![0-9]+]]
; VF2:       [[EXIT]]:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @test_3xi64(
; VF4-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*]]:
; VF4-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 4
; VF4-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 4
; VF4-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[INDEX]], 1
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[INDEX]], 2
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[INDEX]], 3
; VF4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[TMP4]], i32 0
; VF4-NEXT:    [[WIDE_LOAD:%.*]] = load <4 x i64>, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP0]], i32 0
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP1]], i32 0
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP2]], i32 0
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP3]], i32 0
; VF4-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP6]], align 8
; VF4-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = insertelement <4 x i64> poison, i64 [[TMP10]], i32 0
; VF4-NEXT:    [[TMP15:%.*]] = insertelement <4 x i64> [[TMP14]], i64 [[TMP11]], i32 1
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> [[TMP15]], i64 [[TMP12]], i32 2
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> [[TMP16]], i64 [[TMP13]], i32 3
; VF4-NEXT:    [[TMP18:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[TMP17]]
; VF4-NEXT:    [[TMP19:%.*]] = extractelement <4 x i64> [[TMP18]], i32 0
; VF4-NEXT:    store i64 [[TMP19]], ptr [[TMP6]], align 8
; VF4-NEXT:    [[TMP20:%.*]] = extractelement <4 x i64> [[TMP18]], i32 1
; VF4-NEXT:    store i64 [[TMP20]], ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP21:%.*]] = extractelement <4 x i64> [[TMP18]], i32 2
; VF4-NEXT:    store i64 [[TMP21]], ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP22:%.*]] = extractelement <4 x i64> [[TMP18]], i32 3
; VF4-NEXT:    store i64 [[TMP22]], ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP0]], i32 1
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP1]], i32 1
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP2]], i32 1
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP3]], i32 1
; VF4-NEXT:    [[TMP27:%.*]] = load i64, ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP28:%.*]] = load i64, ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = load i64, ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = insertelement <4 x i64> poison, i64 [[TMP27]], i32 0
; VF4-NEXT:    [[TMP32:%.*]] = insertelement <4 x i64> [[TMP31]], i64 [[TMP28]], i32 1
; VF4-NEXT:    [[TMP33:%.*]] = insertelement <4 x i64> [[TMP32]], i64 [[TMP29]], i32 2
; VF4-NEXT:    [[TMP34:%.*]] = insertelement <4 x i64> [[TMP33]], i64 [[TMP30]], i32 3
; VF4-NEXT:    [[TMP35:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[TMP34]]
; VF4-NEXT:    [[TMP36:%.*]] = extractelement <4 x i64> [[TMP35]], i32 0
; VF4-NEXT:    store i64 [[TMP36]], ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP37:%.*]] = extractelement <4 x i64> [[TMP35]], i32 1
; VF4-NEXT:    store i64 [[TMP37]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP38:%.*]] = extractelement <4 x i64> [[TMP35]], i32 2
; VF4-NEXT:    store i64 [[TMP38]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP39:%.*]] = extractelement <4 x i64> [[TMP35]], i32 3
; VF4-NEXT:    store i64 [[TMP39]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP40:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP0]], i32 2
; VF4-NEXT:    [[TMP41:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP1]], i32 2
; VF4-NEXT:    [[TMP42:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP2]], i32 2
; VF4-NEXT:    [[TMP43:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[TMP3]], i32 2
; VF4-NEXT:    [[TMP44:%.*]] = load i64, ptr [[TMP40]], align 8
; VF4-NEXT:    [[TMP45:%.*]] = load i64, ptr [[TMP41]], align 8
; VF4-NEXT:    [[TMP46:%.*]] = load i64, ptr [[TMP42]], align 8
; VF4-NEXT:    [[TMP47:%.*]] = load i64, ptr [[TMP43]], align 8
; VF4-NEXT:    [[TMP48:%.*]] = insertelement <4 x i64> poison, i64 [[TMP44]], i32 0
; VF4-NEXT:    [[TMP49:%.*]] = insertelement <4 x i64> [[TMP48]], i64 [[TMP45]], i32 1
; VF4-NEXT:    [[TMP50:%.*]] = insertelement <4 x i64> [[TMP49]], i64 [[TMP46]], i32 2
; VF4-NEXT:    [[TMP51:%.*]] = insertelement <4 x i64> [[TMP50]], i64 [[TMP47]], i32 3
; VF4-NEXT:    [[TMP52:%.*]] = mul <4 x i64> [[WIDE_LOAD]], [[TMP51]]
; VF4-NEXT:    [[TMP53:%.*]] = extractelement <4 x i64> [[TMP52]], i32 0
; VF4-NEXT:    store i64 [[TMP53]], ptr [[TMP40]], align 8
; VF4-NEXT:    [[TMP54:%.*]] = extractelement <4 x i64> [[TMP52]], i32 1
; VF4-NEXT:    store i64 [[TMP54]], ptr [[TMP41]], align 8
; VF4-NEXT:    [[TMP55:%.*]] = extractelement <4 x i64> [[TMP52]], i32 2
; VF4-NEXT:    store i64 [[TMP55]], ptr [[TMP42]], align 8
; VF4-NEXT:    [[TMP56:%.*]] = extractelement <4 x i64> [[TMP52]], i32 3
; VF4-NEXT:    store i64 [[TMP56]], ptr [[TMP43]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[TMP57:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF4-NEXT:    br i1 [[TMP57]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP12:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF4-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF4-NEXT:    br label %[[LOOP:.*]]
; VF4:       [[LOOP]]:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF4-NEXT:    [[L_FACTOR:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
; VF4-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[IV]], i32 0
; VF4-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF4-NEXT:    [[MUL_0:%.*]] = mul i64 [[L_FACTOR]], [[L_0]]
; VF4-NEXT:    store i64 [[MUL_0]], ptr [[DATA_0]], align 8
; VF4-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[IV]], i32 1
; VF4-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF4-NEXT:    [[MUL_1:%.*]] = mul i64 [[L_FACTOR]], [[L_1]]
; VF4-NEXT:    store i64 [[MUL_1]], ptr [[DATA_1]], align 8
; VF4-NEXT:    [[DATA_2:%.*]] = getelementptr inbounds { i64, i64, i64 }, ptr [[DATA]], i64 [[IV]], i32 2
; VF4-NEXT:    [[L_2:%.*]] = load i64, ptr [[DATA_2]], align 8
; VF4-NEXT:    [[MUL_2:%.*]] = mul i64 [[L_FACTOR]], [[L_2]]
; VF4-NEXT:    store i64 [[MUL_2]], ptr [[DATA_2]], align 8
; VF4-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF4-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF4-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP13:![0-9]+]]
; VF4:       [[EXIT]]:
; VF4-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %arrayidx = getelementptr inbounds i64, ptr %factor, i64 %iv
  %l.factor = load i64, ptr %arrayidx, align 8
  %data.0 = getelementptr inbounds { i64 , i64, i64 }, ptr %data, i64 %iv, i32 0
  %l.0 = load i64, ptr %data.0, align 8
  %mul.0 = mul i64 %l.factor, %l.0
  store i64 %mul.0, ptr %data.0, align 8
  %data.1 = getelementptr inbounds { i64 , i64, i64 }, ptr %data, i64 %iv, i32 1
  %l.1 = load i64, ptr %data.1, align 8
  %mul.1 = mul i64 %l.factor, %l.1
  store i64 %mul.1, ptr %data.1, align 8
  %data.2 = getelementptr inbounds { i64 , i64, i64 }, ptr %data, i64 %iv, i32 2
  %l.2 = load i64, ptr %data.2, align 8
  %mul.2 = mul i64 %l.factor, %l.2
  store i64 %mul.2, ptr %data.2, align 8
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, %n
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}


define void @test_2xi32(ptr noalias %data, ptr noalias %factor, i64 noundef %n) {
; VF2-LABEL: define void @test_2xi32(
; VF2-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*]]:
; VF2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 2
; VF2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 2
; VF2-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[INDEX]], 1
; VF2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP2]], align 8
; VF2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[TMP3]], align 8
; VF2-NEXT:    [[TMP6:%.*]] = insertelement <2 x i32> poison, i32 [[TMP4]], i32 0
; VF2-NEXT:    [[TMP7:%.*]] = insertelement <2 x i32> [[TMP6]], i32 [[TMP5]], i32 1
; VF2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP0]], i32 0
; VF2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP1]], i32 0
; VF2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP8]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP9]], align 8
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i32> poison, i32 [[TMP10]], i32 0
; VF2-NEXT:    [[TMP13:%.*]] = insertelement <2 x i32> [[TMP12]], i32 [[TMP11]], i32 1
; VF2-NEXT:    [[TMP14:%.*]] = mul <2 x i32> [[TMP7]], [[TMP13]]
; VF2-NEXT:    [[TMP15:%.*]] = extractelement <2 x i32> [[TMP14]], i32 0
; VF2-NEXT:    store i32 [[TMP15]], ptr [[TMP8]], align 8
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i32> [[TMP14]], i32 1
; VF2-NEXT:    store i32 [[TMP16]], ptr [[TMP9]], align 8
; VF2-NEXT:    [[TMP17:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP0]], i32 1
; VF2-NEXT:    [[TMP18:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP1]], i32 1
; VF2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP17]], align 8
; VF2-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP18]], align 8
; VF2-NEXT:    [[TMP21:%.*]] = insertelement <2 x i32> poison, i32 [[TMP19]], i32 0
; VF2-NEXT:    [[TMP22:%.*]] = insertelement <2 x i32> [[TMP21]], i32 [[TMP20]], i32 1
; VF2-NEXT:    [[TMP23:%.*]] = mul <2 x i32> [[TMP7]], [[TMP22]]
; VF2-NEXT:    [[TMP24:%.*]] = extractelement <2 x i32> [[TMP23]], i32 0
; VF2-NEXT:    store i32 [[TMP24]], ptr [[TMP17]], align 8
; VF2-NEXT:    [[TMP25:%.*]] = extractelement <2 x i32> [[TMP23]], i32 1
; VF2-NEXT:    store i32 [[TMP25]], ptr [[TMP18]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP26:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2-NEXT:    br i1 [[TMP26]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP14:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF2-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF2-NEXT:    br label %[[LOOP:.*]]
; VF2:       [[LOOP]]:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF2-NEXT:    [[L_FACTOR:%.*]] = load i32, ptr [[ARRAYIDX]], align 8
; VF2-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[IV]], i32 0
; VF2-NEXT:    [[L_0:%.*]] = load i32, ptr [[DATA_0]], align 8
; VF2-NEXT:    [[MUL_0:%.*]] = mul i32 [[L_FACTOR]], [[L_0]]
; VF2-NEXT:    store i32 [[MUL_0]], ptr [[DATA_0]], align 8
; VF2-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[IV]], i32 1
; VF2-NEXT:    [[L_1:%.*]] = load i32, ptr [[DATA_1]], align 8
; VF2-NEXT:    [[MUL_1:%.*]] = mul i32 [[L_FACTOR]], [[L_1]]
; VF2-NEXT:    store i32 [[MUL_1]], ptr [[DATA_1]], align 8
; VF2-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF2-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF2-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP15:![0-9]+]]
; VF2:       [[EXIT]]:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @test_2xi32(
; VF4-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*]]:
; VF4-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 4
; VF4-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 4
; VF4-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[INDEX]], 1
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[INDEX]], 2
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[INDEX]], 3
; VF4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP4]], align 8
; VF4-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP6]], align 8
; VF4-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP12:%.*]] = insertelement <4 x i32> poison, i32 [[TMP8]], i32 0
; VF4-NEXT:    [[TMP13:%.*]] = insertelement <4 x i32> [[TMP12]], i32 [[TMP9]], i32 1
; VF4-NEXT:    [[TMP14:%.*]] = insertelement <4 x i32> [[TMP13]], i32 [[TMP10]], i32 2
; VF4-NEXT:    [[TMP15:%.*]] = insertelement <4 x i32> [[TMP14]], i32 [[TMP11]], i32 3
; VF4-NEXT:    [[TMP16:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP0]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP1]], i32 0
; VF4-NEXT:    [[TMP18:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP2]], i32 0
; VF4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP3]], i32 0
; VF4-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP16]], align 8
; VF4-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP17]], align 8
; VF4-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP18]], align 8
; VF4-NEXT:    [[TMP23:%.*]] = load i32, ptr [[TMP19]], align 8
; VF4-NEXT:    [[TMP24:%.*]] = insertelement <4 x i32> poison, i32 [[TMP20]], i32 0
; VF4-NEXT:    [[TMP25:%.*]] = insertelement <4 x i32> [[TMP24]], i32 [[TMP21]], i32 1
; VF4-NEXT:    [[TMP26:%.*]] = insertelement <4 x i32> [[TMP25]], i32 [[TMP22]], i32 2
; VF4-NEXT:    [[TMP27:%.*]] = insertelement <4 x i32> [[TMP26]], i32 [[TMP23]], i32 3
; VF4-NEXT:    [[TMP28:%.*]] = mul <4 x i32> [[TMP15]], [[TMP27]]
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i32> [[TMP28]], i32 0
; VF4-NEXT:    store i32 [[TMP29]], ptr [[TMP16]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i32> [[TMP28]], i32 1
; VF4-NEXT:    store i32 [[TMP30]], ptr [[TMP17]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i32> [[TMP28]], i32 2
; VF4-NEXT:    store i32 [[TMP31]], ptr [[TMP18]], align 8
; VF4-NEXT:    [[TMP32:%.*]] = extractelement <4 x i32> [[TMP28]], i32 3
; VF4-NEXT:    store i32 [[TMP32]], ptr [[TMP19]], align 8
; VF4-NEXT:    [[TMP33:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP0]], i32 1
; VF4-NEXT:    [[TMP34:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP1]], i32 1
; VF4-NEXT:    [[TMP35:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP2]], i32 1
; VF4-NEXT:    [[TMP36:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP3]], i32 1
; VF4-NEXT:    [[TMP37:%.*]] = load i32, ptr [[TMP33]], align 8
; VF4-NEXT:    [[TMP38:%.*]] = load i32, ptr [[TMP34]], align 8
; VF4-NEXT:    [[TMP39:%.*]] = load i32, ptr [[TMP35]], align 8
; VF4-NEXT:    [[TMP40:%.*]] = load i32, ptr [[TMP36]], align 8
; VF4-NEXT:    [[TMP41:%.*]] = insertelement <4 x i32> poison, i32 [[TMP37]], i32 0
; VF4-NEXT:    [[TMP42:%.*]] = insertelement <4 x i32> [[TMP41]], i32 [[TMP38]], i32 1
; VF4-NEXT:    [[TMP43:%.*]] = insertelement <4 x i32> [[TMP42]], i32 [[TMP39]], i32 2
; VF4-NEXT:    [[TMP44:%.*]] = insertelement <4 x i32> [[TMP43]], i32 [[TMP40]], i32 3
; VF4-NEXT:    [[TMP45:%.*]] = mul <4 x i32> [[TMP15]], [[TMP44]]
; VF4-NEXT:    [[TMP46:%.*]] = extractelement <4 x i32> [[TMP45]], i32 0
; VF4-NEXT:    store i32 [[TMP46]], ptr [[TMP33]], align 8
; VF4-NEXT:    [[TMP47:%.*]] = extractelement <4 x i32> [[TMP45]], i32 1
; VF4-NEXT:    store i32 [[TMP47]], ptr [[TMP34]], align 8
; VF4-NEXT:    [[TMP48:%.*]] = extractelement <4 x i32> [[TMP45]], i32 2
; VF4-NEXT:    store i32 [[TMP48]], ptr [[TMP35]], align 8
; VF4-NEXT:    [[TMP49:%.*]] = extractelement <4 x i32> [[TMP45]], i32 3
; VF4-NEXT:    store i32 [[TMP49]], ptr [[TMP36]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[TMP50:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF4-NEXT:    br i1 [[TMP50]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP14:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF4-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF4-NEXT:    br label %[[LOOP:.*]]
; VF4:       [[LOOP]]:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF4-NEXT:    [[L_FACTOR:%.*]] = load i32, ptr [[ARRAYIDX]], align 8
; VF4-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[IV]], i32 0
; VF4-NEXT:    [[L_0:%.*]] = load i32, ptr [[DATA_0]], align 8
; VF4-NEXT:    [[MUL_0:%.*]] = mul i32 [[L_FACTOR]], [[L_0]]
; VF4-NEXT:    store i32 [[MUL_0]], ptr [[DATA_0]], align 8
; VF4-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[IV]], i32 1
; VF4-NEXT:    [[L_1:%.*]] = load i32, ptr [[DATA_1]], align 8
; VF4-NEXT:    [[MUL_1:%.*]] = mul i32 [[L_FACTOR]], [[L_1]]
; VF4-NEXT:    store i32 [[MUL_1]], ptr [[DATA_1]], align 8
; VF4-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF4-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF4-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP15:![0-9]+]]
; VF4:       [[EXIT]]:
; VF4-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %arrayidx = getelementptr inbounds i64, ptr %factor, i64 %iv
  %l.factor = load i32 , ptr %arrayidx, align 8
  %data.0 = getelementptr inbounds { i32, i32, i32 }, ptr %data, i64 %iv, i32 0
  %l.0 = load i32, ptr %data.0, align 8
  %mul.0 = mul i32 %l.factor, %l.0
  store i32 %mul.0, ptr %data.0, align 8
  %data.1 = getelementptr inbounds { i32, i32, i32 }, ptr %data, i64 %iv, i32 1
  %l.1 = load i32, ptr %data.1, align 8
  %mul.1 = mul i32 %l.factor, %l.1
  store i32%mul.1, ptr %data.1, align 8
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, %n
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}
define void @test_3xi32(ptr noalias %data, ptr noalias %factor, i64 noundef %n) {
; VF2-LABEL: define void @test_3xi32(
; VF2-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*]]:
; VF2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 2
; VF2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 2
; VF2-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[INDEX]], 1
; VF2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP2]], align 8
; VF2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[TMP3]], align 8
; VF2-NEXT:    [[TMP6:%.*]] = insertelement <2 x i32> poison, i32 [[TMP4]], i32 0
; VF2-NEXT:    [[TMP7:%.*]] = insertelement <2 x i32> [[TMP6]], i32 [[TMP5]], i32 1
; VF2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP0]], i32 0
; VF2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP1]], i32 0
; VF2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP8]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP9]], align 8
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i32> poison, i32 [[TMP10]], i32 0
; VF2-NEXT:    [[TMP13:%.*]] = insertelement <2 x i32> [[TMP12]], i32 [[TMP11]], i32 1
; VF2-NEXT:    [[TMP14:%.*]] = mul <2 x i32> [[TMP7]], [[TMP13]]
; VF2-NEXT:    [[TMP15:%.*]] = extractelement <2 x i32> [[TMP14]], i32 0
; VF2-NEXT:    store i32 [[TMP15]], ptr [[TMP8]], align 8
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i32> [[TMP14]], i32 1
; VF2-NEXT:    store i32 [[TMP16]], ptr [[TMP9]], align 8
; VF2-NEXT:    [[TMP17:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP0]], i32 1
; VF2-NEXT:    [[TMP18:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP1]], i32 1
; VF2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP17]], align 8
; VF2-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP18]], align 8
; VF2-NEXT:    [[TMP21:%.*]] = insertelement <2 x i32> poison, i32 [[TMP19]], i32 0
; VF2-NEXT:    [[TMP22:%.*]] = insertelement <2 x i32> [[TMP21]], i32 [[TMP20]], i32 1
; VF2-NEXT:    [[TMP23:%.*]] = mul <2 x i32> [[TMP7]], [[TMP22]]
; VF2-NEXT:    [[TMP24:%.*]] = extractelement <2 x i32> [[TMP23]], i32 0
; VF2-NEXT:    store i32 [[TMP24]], ptr [[TMP17]], align 8
; VF2-NEXT:    [[TMP25:%.*]] = extractelement <2 x i32> [[TMP23]], i32 1
; VF2-NEXT:    store i32 [[TMP25]], ptr [[TMP18]], align 8
; VF2-NEXT:    [[TMP26:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP0]], i32 2
; VF2-NEXT:    [[TMP27:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP1]], i32 2
; VF2-NEXT:    [[TMP28:%.*]] = load i32, ptr [[TMP26]], align 8
; VF2-NEXT:    [[TMP29:%.*]] = load i32, ptr [[TMP27]], align 8
; VF2-NEXT:    [[TMP30:%.*]] = insertelement <2 x i32> poison, i32 [[TMP28]], i32 0
; VF2-NEXT:    [[TMP31:%.*]] = insertelement <2 x i32> [[TMP30]], i32 [[TMP29]], i32 1
; VF2-NEXT:    [[TMP32:%.*]] = mul <2 x i32> [[TMP7]], [[TMP31]]
; VF2-NEXT:    [[TMP33:%.*]] = extractelement <2 x i32> [[TMP32]], i32 0
; VF2-NEXT:    store i32 [[TMP33]], ptr [[TMP26]], align 8
; VF2-NEXT:    [[TMP34:%.*]] = extractelement <2 x i32> [[TMP32]], i32 1
; VF2-NEXT:    store i32 [[TMP34]], ptr [[TMP27]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP35:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2-NEXT:    br i1 [[TMP35]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP16:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF2-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF2-NEXT:    br label %[[LOOP:.*]]
; VF2:       [[LOOP]]:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF2-NEXT:    [[L_FACTOR:%.*]] = load i32, ptr [[ARRAYIDX]], align 8
; VF2-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[IV]], i32 0
; VF2-NEXT:    [[L_0:%.*]] = load i32, ptr [[DATA_0]], align 8
; VF2-NEXT:    [[MUL_0:%.*]] = mul i32 [[L_FACTOR]], [[L_0]]
; VF2-NEXT:    store i32 [[MUL_0]], ptr [[DATA_0]], align 8
; VF2-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[IV]], i32 1
; VF2-NEXT:    [[L_1:%.*]] = load i32, ptr [[DATA_1]], align 8
; VF2-NEXT:    [[MUL_1:%.*]] = mul i32 [[L_FACTOR]], [[L_1]]
; VF2-NEXT:    store i32 [[MUL_1]], ptr [[DATA_1]], align 8
; VF2-NEXT:    [[DATA_2:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[IV]], i32 2
; VF2-NEXT:    [[L_2:%.*]] = load i32, ptr [[DATA_2]], align 8
; VF2-NEXT:    [[MUL_2:%.*]] = mul i32 [[L_FACTOR]], [[L_2]]
; VF2-NEXT:    store i32 [[MUL_2]], ptr [[DATA_2]], align 8
; VF2-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF2-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF2-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP17:![0-9]+]]
; VF2:       [[EXIT]]:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @test_3xi32(
; VF4-SAME: ptr noalias [[DATA:%.*]], ptr noalias [[FACTOR:%.*]], i64 noundef [[N:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*]]:
; VF4-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 4
; VF4-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 4
; VF4-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[INDEX]], 1
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[INDEX]], 2
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[INDEX]], 3
; VF4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP4]], align 8
; VF4-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP6]], align 8
; VF4-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP12:%.*]] = insertelement <4 x i32> poison, i32 [[TMP8]], i32 0
; VF4-NEXT:    [[TMP13:%.*]] = insertelement <4 x i32> [[TMP12]], i32 [[TMP9]], i32 1
; VF4-NEXT:    [[TMP14:%.*]] = insertelement <4 x i32> [[TMP13]], i32 [[TMP10]], i32 2
; VF4-NEXT:    [[TMP15:%.*]] = insertelement <4 x i32> [[TMP14]], i32 [[TMP11]], i32 3
; VF4-NEXT:    [[TMP16:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP0]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP1]], i32 0
; VF4-NEXT:    [[TMP18:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP2]], i32 0
; VF4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP3]], i32 0
; VF4-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP16]], align 8
; VF4-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP17]], align 8
; VF4-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP18]], align 8
; VF4-NEXT:    [[TMP23:%.*]] = load i32, ptr [[TMP19]], align 8
; VF4-NEXT:    [[TMP24:%.*]] = insertelement <4 x i32> poison, i32 [[TMP20]], i32 0
; VF4-NEXT:    [[TMP25:%.*]] = insertelement <4 x i32> [[TMP24]], i32 [[TMP21]], i32 1
; VF4-NEXT:    [[TMP26:%.*]] = insertelement <4 x i32> [[TMP25]], i32 [[TMP22]], i32 2
; VF4-NEXT:    [[TMP27:%.*]] = insertelement <4 x i32> [[TMP26]], i32 [[TMP23]], i32 3
; VF4-NEXT:    [[TMP28:%.*]] = mul <4 x i32> [[TMP15]], [[TMP27]]
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i32> [[TMP28]], i32 0
; VF4-NEXT:    store i32 [[TMP29]], ptr [[TMP16]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i32> [[TMP28]], i32 1
; VF4-NEXT:    store i32 [[TMP30]], ptr [[TMP17]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i32> [[TMP28]], i32 2
; VF4-NEXT:    store i32 [[TMP31]], ptr [[TMP18]], align 8
; VF4-NEXT:    [[TMP32:%.*]] = extractelement <4 x i32> [[TMP28]], i32 3
; VF4-NEXT:    store i32 [[TMP32]], ptr [[TMP19]], align 8
; VF4-NEXT:    [[TMP33:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP0]], i32 1
; VF4-NEXT:    [[TMP34:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP1]], i32 1
; VF4-NEXT:    [[TMP35:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP2]], i32 1
; VF4-NEXT:    [[TMP36:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP3]], i32 1
; VF4-NEXT:    [[TMP37:%.*]] = load i32, ptr [[TMP33]], align 8
; VF4-NEXT:    [[TMP38:%.*]] = load i32, ptr [[TMP34]], align 8
; VF4-NEXT:    [[TMP39:%.*]] = load i32, ptr [[TMP35]], align 8
; VF4-NEXT:    [[TMP40:%.*]] = load i32, ptr [[TMP36]], align 8
; VF4-NEXT:    [[TMP41:%.*]] = insertelement <4 x i32> poison, i32 [[TMP37]], i32 0
; VF4-NEXT:    [[TMP42:%.*]] = insertelement <4 x i32> [[TMP41]], i32 [[TMP38]], i32 1
; VF4-NEXT:    [[TMP43:%.*]] = insertelement <4 x i32> [[TMP42]], i32 [[TMP39]], i32 2
; VF4-NEXT:    [[TMP44:%.*]] = insertelement <4 x i32> [[TMP43]], i32 [[TMP40]], i32 3
; VF4-NEXT:    [[TMP45:%.*]] = mul <4 x i32> [[TMP15]], [[TMP44]]
; VF4-NEXT:    [[TMP46:%.*]] = extractelement <4 x i32> [[TMP45]], i32 0
; VF4-NEXT:    store i32 [[TMP46]], ptr [[TMP33]], align 8
; VF4-NEXT:    [[TMP47:%.*]] = extractelement <4 x i32> [[TMP45]], i32 1
; VF4-NEXT:    store i32 [[TMP47]], ptr [[TMP34]], align 8
; VF4-NEXT:    [[TMP48:%.*]] = extractelement <4 x i32> [[TMP45]], i32 2
; VF4-NEXT:    store i32 [[TMP48]], ptr [[TMP35]], align 8
; VF4-NEXT:    [[TMP49:%.*]] = extractelement <4 x i32> [[TMP45]], i32 3
; VF4-NEXT:    store i32 [[TMP49]], ptr [[TMP36]], align 8
; VF4-NEXT:    [[TMP50:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP0]], i32 2
; VF4-NEXT:    [[TMP51:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP1]], i32 2
; VF4-NEXT:    [[TMP52:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP2]], i32 2
; VF4-NEXT:    [[TMP53:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[TMP3]], i32 2
; VF4-NEXT:    [[TMP54:%.*]] = load i32, ptr [[TMP50]], align 8
; VF4-NEXT:    [[TMP55:%.*]] = load i32, ptr [[TMP51]], align 8
; VF4-NEXT:    [[TMP56:%.*]] = load i32, ptr [[TMP52]], align 8
; VF4-NEXT:    [[TMP57:%.*]] = load i32, ptr [[TMP53]], align 8
; VF4-NEXT:    [[TMP58:%.*]] = insertelement <4 x i32> poison, i32 [[TMP54]], i32 0
; VF4-NEXT:    [[TMP59:%.*]] = insertelement <4 x i32> [[TMP58]], i32 [[TMP55]], i32 1
; VF4-NEXT:    [[TMP60:%.*]] = insertelement <4 x i32> [[TMP59]], i32 [[TMP56]], i32 2
; VF4-NEXT:    [[TMP61:%.*]] = insertelement <4 x i32> [[TMP60]], i32 [[TMP57]], i32 3
; VF4-NEXT:    [[TMP62:%.*]] = mul <4 x i32> [[TMP15]], [[TMP61]]
; VF4-NEXT:    [[TMP63:%.*]] = extractelement <4 x i32> [[TMP62]], i32 0
; VF4-NEXT:    store i32 [[TMP63]], ptr [[TMP50]], align 8
; VF4-NEXT:    [[TMP64:%.*]] = extractelement <4 x i32> [[TMP62]], i32 1
; VF4-NEXT:    store i32 [[TMP64]], ptr [[TMP51]], align 8
; VF4-NEXT:    [[TMP65:%.*]] = extractelement <4 x i32> [[TMP62]], i32 2
; VF4-NEXT:    store i32 [[TMP65]], ptr [[TMP52]], align 8
; VF4-NEXT:    [[TMP66:%.*]] = extractelement <4 x i32> [[TMP62]], i32 3
; VF4-NEXT:    store i32 [[TMP66]], ptr [[TMP53]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[TMP67:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF4-NEXT:    br i1 [[TMP67]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP16:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; VF4-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF4-NEXT:    br label %[[LOOP:.*]]
; VF4:       [[LOOP]]:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[FACTOR]], i64 [[IV]]
; VF4-NEXT:    [[L_FACTOR:%.*]] = load i32, ptr [[ARRAYIDX]], align 8
; VF4-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[IV]], i32 0
; VF4-NEXT:    [[L_0:%.*]] = load i32, ptr [[DATA_0]], align 8
; VF4-NEXT:    [[MUL_0:%.*]] = mul i32 [[L_FACTOR]], [[L_0]]
; VF4-NEXT:    store i32 [[MUL_0]], ptr [[DATA_0]], align 8
; VF4-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[IV]], i32 1
; VF4-NEXT:    [[L_1:%.*]] = load i32, ptr [[DATA_1]], align 8
; VF4-NEXT:    [[MUL_1:%.*]] = mul i32 [[L_FACTOR]], [[L_1]]
; VF4-NEXT:    store i32 [[MUL_1]], ptr [[DATA_1]], align 8
; VF4-NEXT:    [[DATA_2:%.*]] = getelementptr inbounds { i32, i32, i32 }, ptr [[DATA]], i64 [[IV]], i32 2
; VF4-NEXT:    [[L_2:%.*]] = load i32, ptr [[DATA_2]], align 8
; VF4-NEXT:    [[MUL_2:%.*]] = mul i32 [[L_FACTOR]], [[L_2]]
; VF4-NEXT:    store i32 [[MUL_2]], ptr [[DATA_2]], align 8
; VF4-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF4-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; VF4-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP17:![0-9]+]]
; VF4:       [[EXIT]]:
; VF4-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %arrayidx = getelementptr inbounds i64, ptr %factor, i64 %iv
  %l.factor = load i32 , ptr %arrayidx, align 8
  %data.0 = getelementptr inbounds { i32, i32, i32 }, ptr %data, i64 %iv, i32 0
  %l.0 = load i32, ptr %data.0, align 8
  %mul.0 = mul i32 %l.factor, %l.0
  store i32 %mul.0, ptr %data.0, align 8
  %data.1 = getelementptr inbounds { i32, i32, i32 }, ptr %data, i64 %iv, i32 1
  %l.1 = load i32, ptr %data.1, align 8
  %mul.1 = mul i32 %l.factor, %l.1
  store i32%mul.1, ptr %data.1, align 8
  %data.2 = getelementptr inbounds { i32, i32, i32 }, ptr %data, i64 %iv, i32 2
  %l.2 = load i32, ptr %data.2, align 8
  %mul.2 = mul i32 %l.factor, %l.2
  store i32 %mul.2, ptr %data.2, align 8
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, %n
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}
;.
; VF2: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]], [[META2:![0-9]+]]}
; VF2: [[META1]] = !{!"llvm.loop.isvectorized", i32 1}
; VF2: [[META2]] = !{!"llvm.loop.unroll.runtime.disable"}
; VF2: [[LOOP3]] = distinct !{[[LOOP3]], [[META2]], [[META1]]}
; VF2: [[LOOP4]] = distinct !{[[LOOP4]], [[META1]], [[META2]]}
; VF2: [[LOOP5]] = distinct !{[[LOOP5]], [[META2]], [[META1]]}
; VF2: [[LOOP6]] = distinct !{[[LOOP6]], [[META1]], [[META2]]}
; VF2: [[LOOP7]] = distinct !{[[LOOP7]], [[META2]], [[META1]]}
; VF2: [[LOOP8]] = distinct !{[[LOOP8]], [[META1]], [[META2]]}
; VF2: [[LOOP9]] = distinct !{[[LOOP9]], [[META2]], [[META1]]}
; VF2: [[LOOP10]] = distinct !{[[LOOP10]], [[META1]], [[META2]]}
; VF2: [[LOOP11]] = distinct !{[[LOOP11]], [[META2]], [[META1]]}
; VF2: [[LOOP12]] = distinct !{[[LOOP12]], [[META1]], [[META2]]}
; VF2: [[LOOP13]] = distinct !{[[LOOP13]], [[META2]], [[META1]]}
; VF2: [[LOOP14]] = distinct !{[[LOOP14]], [[META1]], [[META2]]}
; VF2: [[LOOP15]] = distinct !{[[LOOP15]], [[META2]], [[META1]]}
; VF2: [[LOOP16]] = distinct !{[[LOOP16]], [[META1]], [[META2]]}
; VF2: [[LOOP17]] = distinct !{[[LOOP17]], [[META2]], [[META1]]}
;.
; VF4: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]], [[META2:![0-9]+]]}
; VF4: [[META1]] = !{!"llvm.loop.isvectorized", i32 1}
; VF4: [[META2]] = !{!"llvm.loop.unroll.runtime.disable"}
; VF4: [[LOOP3]] = distinct !{[[LOOP3]], [[META2]], [[META1]]}
; VF4: [[LOOP4]] = distinct !{[[LOOP4]], [[META1]], [[META2]]}
; VF4: [[LOOP5]] = distinct !{[[LOOP5]], [[META2]], [[META1]]}
; VF4: [[LOOP6]] = distinct !{[[LOOP6]], [[META1]], [[META2]]}
; VF4: [[LOOP7]] = distinct !{[[LOOP7]], [[META2]], [[META1]]}
; VF4: [[LOOP8]] = distinct !{[[LOOP8]], [[META1]], [[META2]]}
; VF4: [[LOOP9]] = distinct !{[[LOOP9]], [[META2]], [[META1]]}
; VF4: [[LOOP10]] = distinct !{[[LOOP10]], [[META1]], [[META2]]}
; VF4: [[LOOP11]] = distinct !{[[LOOP11]], [[META2]], [[META1]]}
; VF4: [[LOOP12]] = distinct !{[[LOOP12]], [[META1]], [[META2]]}
; VF4: [[LOOP13]] = distinct !{[[LOOP13]], [[META2]], [[META1]]}
; VF4: [[LOOP14]] = distinct !{[[LOOP14]], [[META1]], [[META2]]}
; VF4: [[LOOP15]] = distinct !{[[LOOP15]], [[META2]], [[META1]]}
; VF4: [[LOOP16]] = distinct !{[[LOOP16]], [[META1]], [[META2]]}
; VF4: [[LOOP17]] = distinct !{[[LOOP17]], [[META2]], [[META1]]}
;.
