/*
 * Copyright 2021 NXP
 *
  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 *
 */
#ifdef ANDROID_DEBUG

//#define LOG_NDEBUG 0
#define LOG_TAG "vsi_daemon"
#include <log/log.h>
#include <android/log.h>
#include "vsi_daemon_debug.h"

#define LOG_BUF_SIZE 1024

void LogOutput(int level, const char *fmt, ...)
{
    va_list ap;
    char buf[LOG_BUF_SIZE];
    android_LogPriority android_level = ANDROID_LOG_VERBOSE;

    va_start(ap, fmt);
    vsnprintf(buf, LOG_BUF_SIZE, fmt, ap);
    va_end(ap);

    switch(level){
        case HANTRO_LEVEL_ERROR:
            android_level = ANDROID_LOG_ERROR;
            break;
        case HANTRO_LEVEL_WARNING:
        case HANTRO_LEVEL_FIXME:
            android_level = ANDROID_LOG_WARN;
            break;
        case HANTRO_LEVEL_INFO:
            android_level = ANDROID_LOG_INFO;
            break;
        case HANTRO_LEVEL_DEBUG:
            android_level = ANDROID_LOG_DEBUG;
            break;
        case HANTRO_LEVEL_LOG:
            android_level = ANDROID_LOG_VERBOSE;
        default:
            break;
    };
    __android_log_write(android_level, LOG_TAG, buf);

    return;
}
#endif


