/*
 * Copyright 2018-2021 NXP
 *
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
#ifndef _INCLUDE_LOOP_H
#define _INCLUDE_LOOP_H
#ifdef __cplusplus
extern "C"
{
#endif

#include <sys/epoll.h>

typedef void *Loop;

struct pitcher_poll_fd {
	int (*func)(struct pitcher_poll_fd *fd, unsigned int event, int *del);
	int fd;
	unsigned int events;
	unsigned int timeout;
	void *priv;
};

struct pitcher_timer_task {
	int (*func)(struct pitcher_timer_task *task, int *del);
	void *priv;
	unsigned int interval;
	int times;
};

Loop pitcher_open_loop(void);
void pitcher_close_loop(Loop loop);
int pitcher_loop_start(Loop loop);
int pitcher_loop_stop(Loop loop);
int pitcher_loop_run(Loop loop);
int pitcher_loop_add_poll_fd(Loop loop, struct pitcher_poll_fd *fd);
int pitcher_loop_add_task(Loop loop, struct pitcher_timer_task *task);
int pitcher_loop_del_poll_fd(Loop l, struct pitcher_poll_fd *fd);
int pitcher_loop_del_task(Loop l, struct pitcher_timer_task *task);
Loop pitcher_get_main_loop(void *context);

#ifdef __cplusplus
}
#endif
#endif
