#include "memtools_register_info.h"

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark AIPSTZ
#endif

// Bitfields in register AIPSTZ_MPR.
static const field_t hw_aipstz_mpr[] =
{
    {
        "MPROT5",
        "",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT3",
        "",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT2",
        "",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT1",
        "",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT0",
        "",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR.
static const field_t hw_aipstz_opacr[] =
{
    {
        "OPAC7",
        "",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC6",
        "",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC5",
        "",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC4",
        "",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC3",
        "",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC2",
        "",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC1",
        "",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC0",
        "",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR1.
static const field_t hw_aipstz_opacr1[] =
{
    {
        "OPAC15",
        "",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC14",
        "",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC13",
        "",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC12",
        "",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC11",
        "",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC10",
        "",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC9",
        "",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC8",
        "",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR2.
static const field_t hw_aipstz_opacr2[] =
{
    {
        "OPAC23",
        "",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC22",
        "",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC21",
        "",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC20",
        "",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC19",
        "",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC18",
        "",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC17",
        "",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC16",
        "",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR3.
static const field_t hw_aipstz_opacr3[] =
{
    {
        "OPAC31",
        "",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC30",
        "",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC29",
        "",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC28",
        "",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC27",
        "",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC26",
        "",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC25",
        "",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC24",
        "",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR4.
static const field_t hw_aipstz_opacr4[] =
{
    {
        "OPAC33",
        "",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC32",
        "",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a AIPSTZ module.
static const reg_t hw_aipstz[] =
{
    {
        "MPR",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_aipstz_mpr
    },
    {
        "OPACR",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr
    },
    {
        "OPACR1",
        "",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr1
    },
    {
        "OPACR2",
        "",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr2
    },
    {
        "OPACR3",
        "",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr3
    },
    {
        "OPACR4",
        "",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_aipstz_opacr4
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark APBH
#endif

// Bitfields in register APBH_CTRL0.
static const field_t hw_apbh_ctrl0[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL0_SET.
static const field_t hw_apbh_ctrl0_set[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL0_CLR.
static const field_t hw_apbh_ctrl0_clr[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL0_TOG.
static const field_t hw_apbh_ctrl0_tog[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1.
static const field_t hw_apbh_ctrl1[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1_SET.
static const field_t hw_apbh_ctrl1_set[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1_CLR.
static const field_t hw_apbh_ctrl1_clr[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1_TOG.
static const field_t hw_apbh_ctrl1_tog[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2.
static const field_t hw_apbh_ctrl2[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2_SET.
static const field_t hw_apbh_ctrl2_set[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2_CLR.
static const field_t hw_apbh_ctrl2_clr[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2_TOG.
static const field_t hw_apbh_ctrl2_tog[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL.
static const field_t hw_apbh_channel_ctrl[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL_SET.
static const field_t hw_apbh_channel_ctrl_set[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL_CLR.
static const field_t hw_apbh_channel_ctrl_clr[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL_TOG.
static const field_t hw_apbh_channel_ctrl_tog[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_DEVSEL.
static const field_t hw_apbh_devsel[] =
{
    {
        "CH0",
        "Reserved.",
        0, // LSB
        1, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH1",
        "Reserved.",
        2, // LSB
        3, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH2",
        "Reserved.",
        4, // LSB
        5, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH3",
        "Reserved.",
        6, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH4",
        "Reserved.",
        8, // LSB
        9, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH5",
        "Reserved.",
        10, // LSB
        11, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH6",
        "Reserved.",
        12, // LSB
        13, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH7",
        "Reserved.",
        14, // LSB
        15, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH8",
        "Reserved.",
        16, // LSB
        17, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH9",
        "Reserved.",
        18, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH10",
        "Reserved.",
        20, // LSB
        21, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH11",
        "Reserved.",
        22, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH12",
        "Reserved.",
        24, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH13",
        "Reserved.",
        26, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH14",
        "Reserved.",
        28, // LSB
        29, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH15",
        "Reserved.",
        30, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_DMA_BURST_SIZE.
static const field_t hw_apbh_dma_burst_size[] =
{
    {
        "CH0",
        "DMA burst size for GPMI channel 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1",
        "DMA burst size for GPMI channel 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2",
        "DMA burst size for GPMI channel 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3",
        "DMA burst size for GPMI channel 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4",
        "DMA burst size for GPMI channel 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5",
        "DMA burst size for GPMI channel 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6",
        "DMA burst size for GPMI channel 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7",
        "DMA burst size for GPMI channel 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8",
        "DMA burst size for SSP.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9",
        "Reserved.",
        18, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH10",
        "Reserved.",
        20, // LSB
        21, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH11",
        "Reserved.",
        22, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH12",
        "Reserved.",
        24, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH13",
        "Reserved.",
        26, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH14",
        "Reserved.",
        28, // LSB
        29, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH15",
        "Reserved.",
        30, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_DEBUG.
static const field_t hw_apbh_debug[] =
{
    {
        "GPMI_ONE_FIFO",
        "Set to 0ne and the 8 GPMI channels will share the DMA FIFO, and when s"
        "et to zero, the 8 GPMI channels will use its own DMA FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_CURCMDAR.
static const field_t hw_apbh_ch0_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_NXTCMDAR.
static const field_t hw_apbh_ch0_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_CMD.
static const field_t hw_apbh_ch0_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_BAR.
static const field_t hw_apbh_ch0_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_SEMA.
static const field_t hw_apbh_ch0_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_DEBUG1.
static const field_t hw_apbh_ch0_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_DEBUG2.
static const field_t hw_apbh_ch0_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_CURCMDAR.
static const field_t hw_apbh_ch1_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_NXTCMDAR.
static const field_t hw_apbh_ch1_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_CMD.
static const field_t hw_apbh_ch1_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_BAR.
static const field_t hw_apbh_ch1_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_SEMA.
static const field_t hw_apbh_ch1_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_DEBUG1.
static const field_t hw_apbh_ch1_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_DEBUG2.
static const field_t hw_apbh_ch1_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_CURCMDAR.
static const field_t hw_apbh_ch2_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_NXTCMDAR.
static const field_t hw_apbh_ch2_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_CMD.
static const field_t hw_apbh_ch2_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_BAR.
static const field_t hw_apbh_ch2_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_SEMA.
static const field_t hw_apbh_ch2_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_DEBUG1.
static const field_t hw_apbh_ch2_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_DEBUG2.
static const field_t hw_apbh_ch2_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_CURCMDAR.
static const field_t hw_apbh_ch3_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_NXTCMDAR.
static const field_t hw_apbh_ch3_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_CMD.
static const field_t hw_apbh_ch3_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_BAR.
static const field_t hw_apbh_ch3_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_SEMA.
static const field_t hw_apbh_ch3_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_DEBUG1.
static const field_t hw_apbh_ch3_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_DEBUG2.
static const field_t hw_apbh_ch3_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_CURCMDAR.
static const field_t hw_apbh_ch4_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_NXTCMDAR.
static const field_t hw_apbh_ch4_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_CMD.
static const field_t hw_apbh_ch4_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_BAR.
static const field_t hw_apbh_ch4_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_SEMA.
static const field_t hw_apbh_ch4_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_DEBUG1.
static const field_t hw_apbh_ch4_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_DEBUG2.
static const field_t hw_apbh_ch4_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_CURCMDAR.
static const field_t hw_apbh_ch5_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_NXTCMDAR.
static const field_t hw_apbh_ch5_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_CMD.
static const field_t hw_apbh_ch5_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_BAR.
static const field_t hw_apbh_ch5_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_SEMA.
static const field_t hw_apbh_ch5_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_DEBUG1.
static const field_t hw_apbh_ch5_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_DEBUG2.
static const field_t hw_apbh_ch5_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_CURCMDAR.
static const field_t hw_apbh_ch6_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_NXTCMDAR.
static const field_t hw_apbh_ch6_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_CMD.
static const field_t hw_apbh_ch6_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_BAR.
static const field_t hw_apbh_ch6_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_SEMA.
static const field_t hw_apbh_ch6_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_DEBUG1.
static const field_t hw_apbh_ch6_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_DEBUG2.
static const field_t hw_apbh_ch6_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_CURCMDAR.
static const field_t hw_apbh_ch7_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_NXTCMDAR.
static const field_t hw_apbh_ch7_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_CMD.
static const field_t hw_apbh_ch7_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_BAR.
static const field_t hw_apbh_ch7_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_SEMA.
static const field_t hw_apbh_ch7_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_DEBUG1.
static const field_t hw_apbh_ch7_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_DEBUG2.
static const field_t hw_apbh_ch7_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_CURCMDAR.
static const field_t hw_apbh_ch8_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_NXTCMDAR.
static const field_t hw_apbh_ch8_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_CMD.
static const field_t hw_apbh_ch8_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_BAR.
static const field_t hw_apbh_ch8_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_SEMA.
static const field_t hw_apbh_ch8_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_DEBUG1.
static const field_t hw_apbh_ch8_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_DEBUG2.
static const field_t hw_apbh_ch8_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_CURCMDAR.
static const field_t hw_apbh_ch9_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_NXTCMDAR.
static const field_t hw_apbh_ch9_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_CMD.
static const field_t hw_apbh_ch9_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_BAR.
static const field_t hw_apbh_ch9_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_SEMA.
static const field_t hw_apbh_ch9_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_DEBUG1.
static const field_t hw_apbh_ch9_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_DEBUG2.
static const field_t hw_apbh_ch9_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_CURCMDAR.
static const field_t hw_apbh_ch10_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_NXTCMDAR.
static const field_t hw_apbh_ch10_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_CMD.
static const field_t hw_apbh_ch10_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_BAR.
static const field_t hw_apbh_ch10_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_SEMA.
static const field_t hw_apbh_ch10_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_DEBUG1.
static const field_t hw_apbh_ch10_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_DEBUG2.
static const field_t hw_apbh_ch10_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_CURCMDAR.
static const field_t hw_apbh_ch11_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_NXTCMDAR.
static const field_t hw_apbh_ch11_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_CMD.
static const field_t hw_apbh_ch11_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_BAR.
static const field_t hw_apbh_ch11_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_SEMA.
static const field_t hw_apbh_ch11_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_DEBUG1.
static const field_t hw_apbh_ch11_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_DEBUG2.
static const field_t hw_apbh_ch11_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_CURCMDAR.
static const field_t hw_apbh_ch12_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_NXTCMDAR.
static const field_t hw_apbh_ch12_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_CMD.
static const field_t hw_apbh_ch12_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_BAR.
static const field_t hw_apbh_ch12_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_SEMA.
static const field_t hw_apbh_ch12_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_DEBUG1.
static const field_t hw_apbh_ch12_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_DEBUG2.
static const field_t hw_apbh_ch12_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_CURCMDAR.
static const field_t hw_apbh_ch13_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_NXTCMDAR.
static const field_t hw_apbh_ch13_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_CMD.
static const field_t hw_apbh_ch13_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_BAR.
static const field_t hw_apbh_ch13_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_SEMA.
static const field_t hw_apbh_ch13_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_DEBUG1.
static const field_t hw_apbh_ch13_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_DEBUG2.
static const field_t hw_apbh_ch13_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_CURCMDAR.
static const field_t hw_apbh_ch14_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_NXTCMDAR.
static const field_t hw_apbh_ch14_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_CMD.
static const field_t hw_apbh_ch14_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_BAR.
static const field_t hw_apbh_ch14_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_SEMA.
static const field_t hw_apbh_ch14_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_DEBUG1.
static const field_t hw_apbh_ch14_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_DEBUG2.
static const field_t hw_apbh_ch14_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_CURCMDAR.
static const field_t hw_apbh_ch15_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_NXTCMDAR.
static const field_t hw_apbh_ch15_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_CMD.
static const field_t hw_apbh_ch15_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_BAR.
static const field_t hw_apbh_ch15_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_SEMA.
static const field_t hw_apbh_ch15_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_DEBUG1.
static const field_t hw_apbh_ch15_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_DEBUG2.
static const field_t hw_apbh_ch15_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_VERSION.
static const field_t hw_apbh_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a APBH module.
static const reg_t hw_apbh[] =
{
    {
        "CTRL0",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0
    },
    {
        "CTRL0_SET",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0_set
    },
    {
        "CTRL0_CLR",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0_clr
    },
    {
        "CTRL0_TOG",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0_tog
    },
    {
        "CTRL1",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1
    },
    {
        "CTRL1_SET",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1_set
    },
    {
        "CTRL1_CLR",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1_clr
    },
    {
        "CTRL1_TOG",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1_tog
    },
    {
        "CTRL2",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2
    },
    {
        "CTRL2_SET",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2_set
    },
    {
        "CTRL2_CLR",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2_clr
    },
    {
        "CTRL2_TOG",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2_tog
    },
    {
        "CHANNEL_CTRL",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl
    },
    {
        "CHANNEL_CTRL_SET",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl_set
    },
    {
        "CHANNEL_CTRL_CLR",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl_clr
    },
    {
        "CHANNEL_CTRL_TOG",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl_tog
    },
    {
        "DEVSEL",
        "This register allows reassignment of the APBH device connected to the "
        "DMA Channels.",
        4, // Width in bytes
        0x00000040, // Base address offset
        false, // Readable
        false, // Writable
        16, // Number of bitfields
        hw_apbh_devsel
    },
    {
        "DMA_BURST_SIZE",
        "This register programs the apbh burst size of the APBH DMA devices whe"
        "n a DMA burst request is issued.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_apbh_dma_burst_size
    },
    {
        "DEBUG",
        "This register is for debug purpose.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_debug
    },
    {
        "CH0_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch0_curcmdar
    },
    {
        "CH0_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch0_nxtcmdar
    },
    {
        "CH0_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch0_cmd
    },
    {
        "CH0_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch0_bar
    },
    {
        "CH0_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch0_sema
    },
    {
        "CH0_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch0_debug1
    },
    {
        "CH0_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch0_debug2
    },
    {
        "CH1_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch1_curcmdar
    },
    {
        "CH1_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch1_nxtcmdar
    },
    {
        "CH1_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000190, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch1_cmd
    },
    {
        "CH1_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch1_bar
    },
    {
        "CH1_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000001b0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch1_sema
    },
    {
        "CH1_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch1_debug1
    },
    {
        "CH1_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000001d0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch1_debug2
    },
    {
        "CH2_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000001e0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch2_curcmdar
    },
    {
        "CH2_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000001f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch2_nxtcmdar
    },
    {
        "CH2_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch2_cmd
    },
    {
        "CH2_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000210, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch2_bar
    },
    {
        "CH2_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000220, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch2_sema
    },
    {
        "CH2_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000230, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch2_debug1
    },
    {
        "CH2_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000240, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch2_debug2
    },
    {
        "CH3_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000250, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch3_curcmdar
    },
    {
        "CH3_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000260, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch3_nxtcmdar
    },
    {
        "CH3_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000270, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch3_cmd
    },
    {
        "CH3_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000280, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch3_bar
    },
    {
        "CH3_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000290, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch3_sema
    },
    {
        "CH3_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000002a0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch3_debug1
    },
    {
        "CH3_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000002b0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch3_debug2
    },
    {
        "CH4_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000002c0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch4_curcmdar
    },
    {
        "CH4_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000002d0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch4_nxtcmdar
    },
    {
        "CH4_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000002e0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch4_cmd
    },
    {
        "CH4_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000002f0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch4_bar
    },
    {
        "CH4_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000300, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch4_sema
    },
    {
        "CH4_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000310, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch4_debug1
    },
    {
        "CH4_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000320, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch4_debug2
    },
    {
        "CH5_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000330, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch5_curcmdar
    },
    {
        "CH5_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000340, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch5_nxtcmdar
    },
    {
        "CH5_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000350, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch5_cmd
    },
    {
        "CH5_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000360, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch5_bar
    },
    {
        "CH5_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000370, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch5_sema
    },
    {
        "CH5_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000380, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch5_debug1
    },
    {
        "CH5_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000390, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch5_debug2
    },
    {
        "CH6_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000003a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch6_curcmdar
    },
    {
        "CH6_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000003b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch6_nxtcmdar
    },
    {
        "CH6_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000003c0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch6_cmd
    },
    {
        "CH6_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000003d0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch6_bar
    },
    {
        "CH6_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000003e0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch6_sema
    },
    {
        "CH6_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000003f0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch6_debug1
    },
    {
        "CH6_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch6_debug2
    },
    {
        "CH7_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000410, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch7_curcmdar
    },
    {
        "CH7_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000420, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch7_nxtcmdar
    },
    {
        "CH7_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000430, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch7_cmd
    },
    {
        "CH7_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000440, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch7_bar
    },
    {
        "CH7_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000450, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch7_sema
    },
    {
        "CH7_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000460, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch7_debug1
    },
    {
        "CH7_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000470, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch7_debug2
    },
    {
        "CH8_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000480, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch8_curcmdar
    },
    {
        "CH8_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000490, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch8_nxtcmdar
    },
    {
        "CH8_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000004a0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch8_cmd
    },
    {
        "CH8_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000004b0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch8_bar
    },
    {
        "CH8_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000004c0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch8_sema
    },
    {
        "CH8_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000004d0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch8_debug1
    },
    {
        "CH8_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000004e0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch8_debug2
    },
    {
        "CH9_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000004f0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch9_curcmdar
    },
    {
        "CH9_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000500, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch9_nxtcmdar
    },
    {
        "CH9_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000510, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch9_cmd
    },
    {
        "CH9_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000520, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch9_bar
    },
    {
        "CH9_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000530, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch9_sema
    },
    {
        "CH9_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000540, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch9_debug1
    },
    {
        "CH9_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000550, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch9_debug2
    },
    {
        "CH10_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000560, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch10_curcmdar
    },
    {
        "CH10_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000570, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch10_nxtcmdar
    },
    {
        "CH10_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000580, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch10_cmd
    },
    {
        "CH10_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000590, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch10_bar
    },
    {
        "CH10_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000005a0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch10_sema
    },
    {
        "CH10_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000005b0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch10_debug1
    },
    {
        "CH10_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000005c0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch10_debug2
    },
    {
        "CH11_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000005d0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch11_curcmdar
    },
    {
        "CH11_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000005e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch11_nxtcmdar
    },
    {
        "CH11_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000005f0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch11_cmd
    },
    {
        "CH11_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000600, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch11_bar
    },
    {
        "CH11_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000610, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch11_sema
    },
    {
        "CH11_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000620, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch11_debug1
    },
    {
        "CH11_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000630, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch11_debug2
    },
    {
        "CH12_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000640, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch12_curcmdar
    },
    {
        "CH12_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000650, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch12_nxtcmdar
    },
    {
        "CH12_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000660, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch12_cmd
    },
    {
        "CH12_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000670, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch12_bar
    },
    {
        "CH12_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000680, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch12_sema
    },
    {
        "CH12_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000690, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch12_debug1
    },
    {
        "CH12_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000006a0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch12_debug2
    },
    {
        "CH13_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000006b0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch13_curcmdar
    },
    {
        "CH13_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000006c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch13_nxtcmdar
    },
    {
        "CH13_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000006d0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch13_cmd
    },
    {
        "CH13_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000006e0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch13_bar
    },
    {
        "CH13_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000006f0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch13_sema
    },
    {
        "CH13_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000700, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch13_debug1
    },
    {
        "CH13_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000710, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch13_debug2
    },
    {
        "CH14_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000720, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch14_curcmdar
    },
    {
        "CH14_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000730, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch14_nxtcmdar
    },
    {
        "CH14_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000740, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch14_cmd
    },
    {
        "CH14_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000750, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch14_bar
    },
    {
        "CH14_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000760, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch14_sema
    },
    {
        "CH14_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000770, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch14_debug1
    },
    {
        "CH14_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000780, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch14_debug2
    },
    {
        "CH15_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000790, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch15_curcmdar
    },
    {
        "CH15_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000007a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch15_nxtcmdar
    },
    {
        "CH15_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000007b0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch15_cmd
    },
    {
        "CH15_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000007c0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch15_bar
    },
    {
        "CH15_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "rm platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000007d0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch15_sema
    },
    {
        "CH15_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000007e0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch15_debug1
    },
    {
        "CH15_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000007f0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch15_debug2
    },
    {
        "VERSION",
        "This register always returns a known read value for debug purposes it "
        "indicates the version of the block.",
        4, // Width in bytes
        0x00000800, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_apbh_version
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark BCH
#endif

// Bitfields in register BCH_CTRL.
static const field_t hw_bch_ctrl[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_SET.
static const field_t hw_bch_ctrl_set[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_CLR.
static const field_t hw_bch_ctrl_clr[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_TOG.
static const field_t hw_bch_ctrl_tog[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0.
static const field_t hw_bch_status0[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_SET.
static const field_t hw_bch_status0_set[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_CLR.
static const field_t hw_bch_status0_clr[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_TOG.
static const field_t hw_bch_status0_tog[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE.
static const field_t hw_bch_mode[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_SET.
static const field_t hw_bch_mode_set[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_CLR.
static const field_t hw_bch_mode_clr[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_TOG.
static const field_t hw_bch_mode_tog[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR.
static const field_t hw_bch_encodeptr[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_SET.
static const field_t hw_bch_encodeptr_set[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_CLR.
static const field_t hw_bch_encodeptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_TOG.
static const field_t hw_bch_encodeptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR.
static const field_t hw_bch_dataptr[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_SET.
static const field_t hw_bch_dataptr_set[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_CLR.
static const field_t hw_bch_dataptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_TOG.
static const field_t hw_bch_dataptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR.
static const field_t hw_bch_metaptr[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_SET.
static const field_t hw_bch_metaptr_set[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_CLR.
static const field_t hw_bch_metaptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_TOG.
static const field_t hw_bch_metaptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT.
static const field_t hw_bch_layoutselect[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_SET.
static const field_t hw_bch_layoutselect_set[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_CLR.
static const field_t hw_bch_layoutselect_clr[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_TOG.
static const field_t hw_bch_layoutselect_tog[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0.
static const field_t hw_bch_flash0layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_SET.
static const field_t hw_bch_flash0layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_CLR.
static const field_t hw_bch_flash0layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_TOG.
static const field_t hw_bch_flash0layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1.
static const field_t hw_bch_flash0layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_SET.
static const field_t hw_bch_flash0layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_CLR.
static const field_t hw_bch_flash0layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_TOG.
static const field_t hw_bch_flash0layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0.
static const field_t hw_bch_flash1layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_SET.
static const field_t hw_bch_flash1layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_CLR.
static const field_t hw_bch_flash1layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_TOG.
static const field_t hw_bch_flash1layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1.
static const field_t hw_bch_flash1layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_SET.
static const field_t hw_bch_flash1layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_CLR.
static const field_t hw_bch_flash1layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_TOG.
static const field_t hw_bch_flash1layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0.
static const field_t hw_bch_flash2layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_SET.
static const field_t hw_bch_flash2layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_CLR.
static const field_t hw_bch_flash2layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_TOG.
static const field_t hw_bch_flash2layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1.
static const field_t hw_bch_flash2layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_SET.
static const field_t hw_bch_flash2layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_CLR.
static const field_t hw_bch_flash2layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_TOG.
static const field_t hw_bch_flash2layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0.
static const field_t hw_bch_flash3layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_SET.
static const field_t hw_bch_flash3layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_CLR.
static const field_t hw_bch_flash3layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_TOG.
static const field_t hw_bch_flash3layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1.
static const field_t hw_bch_flash3layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_SET.
static const field_t hw_bch_flash3layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_CLR.
static const field_t hw_bch_flash3layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_TOG.
static const field_t hw_bch_flash3layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0.
static const field_t hw_bch_debug0[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_SET.
static const field_t hw_bch_debug0_set[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_CLR.
static const field_t hw_bch_debug0_clr[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_TOG.
static const field_t hw_bch_debug0_tog[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD.
static const field_t hw_bch_dbgkesread[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_SET.
static const field_t hw_bch_dbgkesread_set[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_CLR.
static const field_t hw_bch_dbgkesread_clr[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_TOG.
static const field_t hw_bch_dbgkesread_tog[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD.
static const field_t hw_bch_dbgcsferead[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_SET.
static const field_t hw_bch_dbgcsferead_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_CLR.
static const field_t hw_bch_dbgcsferead_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_TOG.
static const field_t hw_bch_dbgcsferead_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD.
static const field_t hw_bch_dbgsyndgenread[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_SET.
static const field_t hw_bch_dbgsyndgenread_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_CLR.
static const field_t hw_bch_dbgsyndgenread_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_TOG.
static const field_t hw_bch_dbgsyndgenread_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD.
static const field_t hw_bch_dbgahbmread[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_SET.
static const field_t hw_bch_dbgahbmread_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_CLR.
static const field_t hw_bch_dbgahbmread_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_TOG.
static const field_t hw_bch_dbgahbmread_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME.
static const field_t hw_bch_blockname[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_SET.
static const field_t hw_bch_blockname_set[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_CLR.
static const field_t hw_bch_blockname_clr[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_TOG.
static const field_t hw_bch_blockname_tog[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION.
static const field_t hw_bch_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_SET.
static const field_t hw_bch_version_set[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_CLR.
static const field_t hw_bch_version_clr[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_TOG.
static const field_t hw_bch_version_tog[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1.
static const field_t hw_bch_debug1[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1_SET.
static const field_t hw_bch_debug1_set[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1_CLR.
static const field_t hw_bch_debug1_clr[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1_TOG.
static const field_t hw_bch_debug1_tog[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a BCH module.
static const reg_t hw_bch[] =
{
    {
        "CTRL",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl
    },
    {
        "CTRL_SET",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_set
    },
    {
        "CTRL_CLR",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_clr
    },
    {
        "CTRL_TOG",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_tog
    },
    {
        "STATUS0",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0
    },
    {
        "STATUS0_SET",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_set
    },
    {
        "STATUS0_CLR",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_clr
    },
    {
        "STATUS0_TOG",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_tog
    },
    {
        "MODE",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode
    },
    {
        "MODE_SET",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_set
    },
    {
        "MODE_CLR",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_clr
    },
    {
        "MODE_TOG",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_tog
    },
    {
        "ENCODEPTR",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr
    },
    {
        "ENCODEPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_set
    },
    {
        "ENCODEPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_clr
    },
    {
        "ENCODEPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_tog
    },
    {
        "DATAPTR",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr
    },
    {
        "DATAPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_set
    },
    {
        "DATAPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_clr
    },
    {
        "DATAPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_tog
    },
    {
        "METAPTR",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr
    },
    {
        "METAPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_set
    },
    {
        "METAPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_clr
    },
    {
        "METAPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_tog
    },
    {
        "LAYOUTSELECT",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect
    },
    {
        "LAYOUTSELECT_SET",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_set
    },
    {
        "LAYOUTSELECT_CLR",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_clr
    },
    {
        "LAYOUTSELECT_TOG",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_tog
    },
    {
        "FLASH0LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0
    },
    {
        "FLASH0LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_set
    },
    {
        "FLASH0LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_clr
    },
    {
        "FLASH0LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_tog
    },
    {
        "FLASH0LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1
    },
    {
        "FLASH0LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_set
    },
    {
        "FLASH0LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_clr
    },
    {
        "FLASH0LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_tog
    },
    {
        "FLASH1LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0
    },
    {
        "FLASH1LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_set
    },
    {
        "FLASH1LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_clr
    },
    {
        "FLASH1LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_tog
    },
    {
        "FLASH1LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1
    },
    {
        "FLASH1LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_set
    },
    {
        "FLASH1LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_clr
    },
    {
        "FLASH1LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000bc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_tog
    },
    {
        "FLASH2LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0
    },
    {
        "FLASH2LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_set
    },
    {
        "FLASH2LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_clr
    },
    {
        "FLASH2LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000cc, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_tog
    },
    {
        "FLASH2LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1
    },
    {
        "FLASH2LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_set
    },
    {
        "FLASH2LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_clr
    },
    {
        "FLASH2LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000dc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_tog
    },
    {
        "FLASH3LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0
    },
    {
        "FLASH3LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_set
    },
    {
        "FLASH3LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_clr
    },
    {
        "FLASH3LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_tog
    },
    {
        "FLASH3LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1
    },
    {
        "FLASH3LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_set
    },
    {
        "FLASH3LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_clr
    },
    {
        "FLASH3LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000fc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_tog
    },
    {
        "DEBUG0",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0
    },
    {
        "DEBUG0_SET",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_set
    },
    {
        "DEBUG0_CLR",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_clr
    },
    {
        "DEBUG0_TOG",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x0000010c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_tog
    },
    {
        "DBGKESREAD",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread
    },
    {
        "DBGKESREAD_SET",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000114, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_set
    },
    {
        "DBGKESREAD_CLR",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_clr
    },
    {
        "DBGKESREAD_TOG",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_tog
    },
    {
        "DBGCSFEREAD",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead
    },
    {
        "DBGCSFEREAD_SET",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000124, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_set
    },
    {
        "DBGCSFEREAD_CLR",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000128, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_clr
    },
    {
        "DBGCSFEREAD_TOG",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000012c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_tog
    },
    {
        "DBGSYNDGENREAD",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread
    },
    {
        "DBGSYNDGENREAD_SET",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000134, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_set
    },
    {
        "DBGSYNDGENREAD_CLR",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000138, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_clr
    },
    {
        "DBGSYNDGENREAD_TOG",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000013c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_tog
    },
    {
        "DBGAHBMREAD",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread
    },
    {
        "DBGAHBMREAD_SET",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000144, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_set
    },
    {
        "DBGAHBMREAD_CLR",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000148, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_clr
    },
    {
        "DBGAHBMREAD_TOG",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000014c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_tog
    },
    {
        "BLOCKNAME",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname
    },
    {
        "BLOCKNAME_SET",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000154, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_set
    },
    {
        "BLOCKNAME_CLR",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000158, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_clr
    },
    {
        "BLOCKNAME_TOG",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x0000015c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_tog
    },
    {
        "VERSION",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version
    },
    {
        "VERSION_SET",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000164, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_set
    },
    {
        "VERSION_CLR",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000168, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_clr
    },
    {
        "VERSION_TOG",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x0000016c, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_tog
    },
    {
        "DEBUG1",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1
    },
    {
        "DEBUG1_SET",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x00000174, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1_set
    },
    {
        "DEBUG1_CLR",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x00000178, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1_clr
    },
    {
        "DEBUG1_TOG",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x0000017c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1_tog
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CACHE
#endif

// Registers in a CACHE module.
static const reg_t hw_cache[] =
{
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CCM
#endif

// Bitfields in register CCM_GPR0.
static const field_t hw_ccm_gpr0[] =
{
    {
        "GP0",
        "Timeout cycle count of ipg_clk, when perform read and write.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_GPR0_SET.
static const field_t hw_ccm_gpr0_set[] =
{
    {
        "GP0",
        "Timeout cycle count of ipg_clk, when perform read and write.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_GPR0_CLR.
static const field_t hw_ccm_gpr0_clr[] =
{
    {
        "GP0",
        "Timeout cycle count of ipg_clk, when perform read and write.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_GPR0_TOG.
static const field_t hw_ccm_gpr0_tog[] =
{
    {
        "GP0",
        "Timeout cycle count of ipg_clk, when perform read and write.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL0.
static const field_t hw_ccm_pll_ctrl0[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL0_SET.
static const field_t hw_ccm_pll_ctrl0_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL0_CLR.
static const field_t hw_ccm_pll_ctrl0_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL0_TOG.
static const field_t hw_ccm_pll_ctrl0_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL1.
static const field_t hw_ccm_pll_ctrl1[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL1_SET.
static const field_t hw_ccm_pll_ctrl1_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL1_CLR.
static const field_t hw_ccm_pll_ctrl1_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL1_TOG.
static const field_t hw_ccm_pll_ctrl1_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL2.
static const field_t hw_ccm_pll_ctrl2[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL2_SET.
static const field_t hw_ccm_pll_ctrl2_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL2_CLR.
static const field_t hw_ccm_pll_ctrl2_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL2_TOG.
static const field_t hw_ccm_pll_ctrl2_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL3.
static const field_t hw_ccm_pll_ctrl3[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL3_SET.
static const field_t hw_ccm_pll_ctrl3_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL3_CLR.
static const field_t hw_ccm_pll_ctrl3_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL3_TOG.
static const field_t hw_ccm_pll_ctrl3_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL4.
static const field_t hw_ccm_pll_ctrl4[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL4_SET.
static const field_t hw_ccm_pll_ctrl4_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL4_CLR.
static const field_t hw_ccm_pll_ctrl4_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL4_TOG.
static const field_t hw_ccm_pll_ctrl4_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL5.
static const field_t hw_ccm_pll_ctrl5[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL5_SET.
static const field_t hw_ccm_pll_ctrl5_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL5_CLR.
static const field_t hw_ccm_pll_ctrl5_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL5_TOG.
static const field_t hw_ccm_pll_ctrl5_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL6.
static const field_t hw_ccm_pll_ctrl6[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL6_SET.
static const field_t hw_ccm_pll_ctrl6_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL6_CLR.
static const field_t hw_ccm_pll_ctrl6_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL6_TOG.
static const field_t hw_ccm_pll_ctrl6_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL7.
static const field_t hw_ccm_pll_ctrl7[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL7_SET.
static const field_t hw_ccm_pll_ctrl7_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL7_CLR.
static const field_t hw_ccm_pll_ctrl7_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL7_TOG.
static const field_t hw_ccm_pll_ctrl7_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL8.
static const field_t hw_ccm_pll_ctrl8[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL8_SET.
static const field_t hw_ccm_pll_ctrl8_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL8_CLR.
static const field_t hw_ccm_pll_ctrl8_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL8_TOG.
static const field_t hw_ccm_pll_ctrl8_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL9.
static const field_t hw_ccm_pll_ctrl9[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL9_SET.
static const field_t hw_ccm_pll_ctrl9_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL9_CLR.
static const field_t hw_ccm_pll_ctrl9_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL9_TOG.
static const field_t hw_ccm_pll_ctrl9_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL10.
static const field_t hw_ccm_pll_ctrl10[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL10_SET.
static const field_t hw_ccm_pll_ctrl10_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL10_CLR.
static const field_t hw_ccm_pll_ctrl10_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL10_TOG.
static const field_t hw_ccm_pll_ctrl10_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL11.
static const field_t hw_ccm_pll_ctrl11[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL11_SET.
static const field_t hw_ccm_pll_ctrl11_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL11_CLR.
static const field_t hw_ccm_pll_ctrl11_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL11_TOG.
static const field_t hw_ccm_pll_ctrl11_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL12.
static const field_t hw_ccm_pll_ctrl12[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL12_SET.
static const field_t hw_ccm_pll_ctrl12_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL12_CLR.
static const field_t hw_ccm_pll_ctrl12_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL12_TOG.
static const field_t hw_ccm_pll_ctrl12_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL13.
static const field_t hw_ccm_pll_ctrl13[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL13_SET.
static const field_t hw_ccm_pll_ctrl13_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL13_CLR.
static const field_t hw_ccm_pll_ctrl13_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL13_TOG.
static const field_t hw_ccm_pll_ctrl13_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL14.
static const field_t hw_ccm_pll_ctrl14[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL14_SET.
static const field_t hw_ccm_pll_ctrl14_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL14_CLR.
static const field_t hw_ccm_pll_ctrl14_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL14_TOG.
static const field_t hw_ccm_pll_ctrl14_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL15.
static const field_t hw_ccm_pll_ctrl15[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL15_SET.
static const field_t hw_ccm_pll_ctrl15_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL15_CLR.
static const field_t hw_ccm_pll_ctrl15_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL15_TOG.
static const field_t hw_ccm_pll_ctrl15_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL16.
static const field_t hw_ccm_pll_ctrl16[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL16_SET.
static const field_t hw_ccm_pll_ctrl16_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL16_CLR.
static const field_t hw_ccm_pll_ctrl16_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL16_TOG.
static const field_t hw_ccm_pll_ctrl16_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL17.
static const field_t hw_ccm_pll_ctrl17[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL17_SET.
static const field_t hw_ccm_pll_ctrl17_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL17_CLR.
static const field_t hw_ccm_pll_ctrl17_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL17_TOG.
static const field_t hw_ccm_pll_ctrl17_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL18.
static const field_t hw_ccm_pll_ctrl18[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL18_SET.
static const field_t hw_ccm_pll_ctrl18_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL18_CLR.
static const field_t hw_ccm_pll_ctrl18_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL18_TOG.
static const field_t hw_ccm_pll_ctrl18_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL19.
static const field_t hw_ccm_pll_ctrl19[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL19_SET.
static const field_t hw_ccm_pll_ctrl19_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL19_CLR.
static const field_t hw_ccm_pll_ctrl19_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL19_TOG.
static const field_t hw_ccm_pll_ctrl19_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL20.
static const field_t hw_ccm_pll_ctrl20[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL20_SET.
static const field_t hw_ccm_pll_ctrl20_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL20_CLR.
static const field_t hw_ccm_pll_ctrl20_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL20_TOG.
static const field_t hw_ccm_pll_ctrl20_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL21.
static const field_t hw_ccm_pll_ctrl21[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL21_SET.
static const field_t hw_ccm_pll_ctrl21_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL21_CLR.
static const field_t hw_ccm_pll_ctrl21_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL21_TOG.
static const field_t hw_ccm_pll_ctrl21_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL22.
static const field_t hw_ccm_pll_ctrl22[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL22_SET.
static const field_t hw_ccm_pll_ctrl22_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL22_CLR.
static const field_t hw_ccm_pll_ctrl22_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL22_TOG.
static const field_t hw_ccm_pll_ctrl22_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL23.
static const field_t hw_ccm_pll_ctrl23[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL23_SET.
static const field_t hw_ccm_pll_ctrl23_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL23_CLR.
static const field_t hw_ccm_pll_ctrl23_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL23_TOG.
static const field_t hw_ccm_pll_ctrl23_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL24.
static const field_t hw_ccm_pll_ctrl24[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL24_SET.
static const field_t hw_ccm_pll_ctrl24_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL24_CLR.
static const field_t hw_ccm_pll_ctrl24_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL24_TOG.
static const field_t hw_ccm_pll_ctrl24_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL25.
static const field_t hw_ccm_pll_ctrl25[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL25_SET.
static const field_t hw_ccm_pll_ctrl25_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL25_CLR.
static const field_t hw_ccm_pll_ctrl25_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL25_TOG.
static const field_t hw_ccm_pll_ctrl25_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL26.
static const field_t hw_ccm_pll_ctrl26[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL26_SET.
static const field_t hw_ccm_pll_ctrl26_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL26_CLR.
static const field_t hw_ccm_pll_ctrl26_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL26_TOG.
static const field_t hw_ccm_pll_ctrl26_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL27.
static const field_t hw_ccm_pll_ctrl27[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL27_SET.
static const field_t hw_ccm_pll_ctrl27_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL27_CLR.
static const field_t hw_ccm_pll_ctrl27_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL27_TOG.
static const field_t hw_ccm_pll_ctrl27_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL28.
static const field_t hw_ccm_pll_ctrl28[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL28_SET.
static const field_t hw_ccm_pll_ctrl28_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL28_CLR.
static const field_t hw_ccm_pll_ctrl28_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL28_TOG.
static const field_t hw_ccm_pll_ctrl28_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL29.
static const field_t hw_ccm_pll_ctrl29[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL29_SET.
static const field_t hw_ccm_pll_ctrl29_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL29_CLR.
static const field_t hw_ccm_pll_ctrl29_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL29_TOG.
static const field_t hw_ccm_pll_ctrl29_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL30.
static const field_t hw_ccm_pll_ctrl30[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL30_SET.
static const field_t hw_ccm_pll_ctrl30_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL30_CLR.
static const field_t hw_ccm_pll_ctrl30_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL30_TOG.
static const field_t hw_ccm_pll_ctrl30_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL31.
static const field_t hw_ccm_pll_ctrl31[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL31_SET.
static const field_t hw_ccm_pll_ctrl31_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL31_CLR.
static const field_t hw_ccm_pll_ctrl31_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL31_TOG.
static const field_t hw_ccm_pll_ctrl31_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL32.
static const field_t hw_ccm_pll_ctrl32[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL32_SET.
static const field_t hw_ccm_pll_ctrl32_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL32_CLR.
static const field_t hw_ccm_pll_ctrl32_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL32_TOG.
static const field_t hw_ccm_pll_ctrl32_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL33.
static const field_t hw_ccm_pll_ctrl33[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL33_SET.
static const field_t hw_ccm_pll_ctrl33_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL33_CLR.
static const field_t hw_ccm_pll_ctrl33_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL33_TOG.
static const field_t hw_ccm_pll_ctrl33_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL34.
static const field_t hw_ccm_pll_ctrl34[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL34_SET.
static const field_t hw_ccm_pll_ctrl34_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL34_CLR.
static const field_t hw_ccm_pll_ctrl34_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL34_TOG.
static const field_t hw_ccm_pll_ctrl34_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL35.
static const field_t hw_ccm_pll_ctrl35[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL35_SET.
static const field_t hw_ccm_pll_ctrl35_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL35_CLR.
static const field_t hw_ccm_pll_ctrl35_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL35_TOG.
static const field_t hw_ccm_pll_ctrl35_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL36.
static const field_t hw_ccm_pll_ctrl36[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL36_SET.
static const field_t hw_ccm_pll_ctrl36_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL36_CLR.
static const field_t hw_ccm_pll_ctrl36_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL36_TOG.
static const field_t hw_ccm_pll_ctrl36_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL37.
static const field_t hw_ccm_pll_ctrl37[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL37_SET.
static const field_t hw_ccm_pll_ctrl37_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL37_CLR.
static const field_t hw_ccm_pll_ctrl37_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL37_TOG.
static const field_t hw_ccm_pll_ctrl37_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL38.
static const field_t hw_ccm_pll_ctrl38[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL38_SET.
static const field_t hw_ccm_pll_ctrl38_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL38_CLR.
static const field_t hw_ccm_pll_ctrl38_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_PLL_CTRL38_TOG.
static const field_t hw_ccm_pll_ctrl38_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR0.
static const field_t hw_ccm_ccgr0[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR0_SET.
static const field_t hw_ccm_ccgr0_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR0_CLR.
static const field_t hw_ccm_ccgr0_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR0_TOG.
static const field_t hw_ccm_ccgr0_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR1.
static const field_t hw_ccm_ccgr1[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR1_SET.
static const field_t hw_ccm_ccgr1_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR1_CLR.
static const field_t hw_ccm_ccgr1_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR1_TOG.
static const field_t hw_ccm_ccgr1_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR2.
static const field_t hw_ccm_ccgr2[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR2_SET.
static const field_t hw_ccm_ccgr2_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR2_CLR.
static const field_t hw_ccm_ccgr2_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR2_TOG.
static const field_t hw_ccm_ccgr2_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR3.
static const field_t hw_ccm_ccgr3[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR3_SET.
static const field_t hw_ccm_ccgr3_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR3_CLR.
static const field_t hw_ccm_ccgr3_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR3_TOG.
static const field_t hw_ccm_ccgr3_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR4.
static const field_t hw_ccm_ccgr4[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR4_SET.
static const field_t hw_ccm_ccgr4_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR4_CLR.
static const field_t hw_ccm_ccgr4_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR4_TOG.
static const field_t hw_ccm_ccgr4_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR5.
static const field_t hw_ccm_ccgr5[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR5_SET.
static const field_t hw_ccm_ccgr5_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR5_CLR.
static const field_t hw_ccm_ccgr5_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR5_TOG.
static const field_t hw_ccm_ccgr5_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR6.
static const field_t hw_ccm_ccgr6[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR6_SET.
static const field_t hw_ccm_ccgr6_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR6_CLR.
static const field_t hw_ccm_ccgr6_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR6_TOG.
static const field_t hw_ccm_ccgr6_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR7.
static const field_t hw_ccm_ccgr7[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR7_SET.
static const field_t hw_ccm_ccgr7_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR7_CLR.
static const field_t hw_ccm_ccgr7_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR7_TOG.
static const field_t hw_ccm_ccgr7_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR8.
static const field_t hw_ccm_ccgr8[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR8_SET.
static const field_t hw_ccm_ccgr8_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR8_CLR.
static const field_t hw_ccm_ccgr8_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR8_TOG.
static const field_t hw_ccm_ccgr8_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR9.
static const field_t hw_ccm_ccgr9[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR9_SET.
static const field_t hw_ccm_ccgr9_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR9_CLR.
static const field_t hw_ccm_ccgr9_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR9_TOG.
static const field_t hw_ccm_ccgr9_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR10.
static const field_t hw_ccm_ccgr10[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR10_SET.
static const field_t hw_ccm_ccgr10_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR10_CLR.
static const field_t hw_ccm_ccgr10_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR10_TOG.
static const field_t hw_ccm_ccgr10_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR11.
static const field_t hw_ccm_ccgr11[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR11_SET.
static const field_t hw_ccm_ccgr11_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR11_CLR.
static const field_t hw_ccm_ccgr11_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR11_TOG.
static const field_t hw_ccm_ccgr11_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR12.
static const field_t hw_ccm_ccgr12[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR12_SET.
static const field_t hw_ccm_ccgr12_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR12_CLR.
static const field_t hw_ccm_ccgr12_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR12_TOG.
static const field_t hw_ccm_ccgr12_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR13.
static const field_t hw_ccm_ccgr13[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR13_SET.
static const field_t hw_ccm_ccgr13_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR13_CLR.
static const field_t hw_ccm_ccgr13_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR13_TOG.
static const field_t hw_ccm_ccgr13_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR14.
static const field_t hw_ccm_ccgr14[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR14_SET.
static const field_t hw_ccm_ccgr14_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR14_CLR.
static const field_t hw_ccm_ccgr14_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR14_TOG.
static const field_t hw_ccm_ccgr14_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR15.
static const field_t hw_ccm_ccgr15[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR15_SET.
static const field_t hw_ccm_ccgr15_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR15_CLR.
static const field_t hw_ccm_ccgr15_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR15_TOG.
static const field_t hw_ccm_ccgr15_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR16.
static const field_t hw_ccm_ccgr16[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR16_SET.
static const field_t hw_ccm_ccgr16_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR16_CLR.
static const field_t hw_ccm_ccgr16_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR16_TOG.
static const field_t hw_ccm_ccgr16_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR17.
static const field_t hw_ccm_ccgr17[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR17_SET.
static const field_t hw_ccm_ccgr17_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR17_CLR.
static const field_t hw_ccm_ccgr17_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR17_TOG.
static const field_t hw_ccm_ccgr17_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR18.
static const field_t hw_ccm_ccgr18[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR18_SET.
static const field_t hw_ccm_ccgr18_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR18_CLR.
static const field_t hw_ccm_ccgr18_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR18_TOG.
static const field_t hw_ccm_ccgr18_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR19.
static const field_t hw_ccm_ccgr19[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR19_SET.
static const field_t hw_ccm_ccgr19_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR19_CLR.
static const field_t hw_ccm_ccgr19_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR19_TOG.
static const field_t hw_ccm_ccgr19_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR20.
static const field_t hw_ccm_ccgr20[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR20_SET.
static const field_t hw_ccm_ccgr20_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR20_CLR.
static const field_t hw_ccm_ccgr20_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR20_TOG.
static const field_t hw_ccm_ccgr20_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR21.
static const field_t hw_ccm_ccgr21[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR21_SET.
static const field_t hw_ccm_ccgr21_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR21_CLR.
static const field_t hw_ccm_ccgr21_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR21_TOG.
static const field_t hw_ccm_ccgr21_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR22.
static const field_t hw_ccm_ccgr22[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR22_SET.
static const field_t hw_ccm_ccgr22_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR22_CLR.
static const field_t hw_ccm_ccgr22_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR22_TOG.
static const field_t hw_ccm_ccgr22_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR23.
static const field_t hw_ccm_ccgr23[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR23_SET.
static const field_t hw_ccm_ccgr23_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR23_CLR.
static const field_t hw_ccm_ccgr23_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR23_TOG.
static const field_t hw_ccm_ccgr23_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR24.
static const field_t hw_ccm_ccgr24[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR24_SET.
static const field_t hw_ccm_ccgr24_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR24_CLR.
static const field_t hw_ccm_ccgr24_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR24_TOG.
static const field_t hw_ccm_ccgr24_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR25.
static const field_t hw_ccm_ccgr25[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR25_SET.
static const field_t hw_ccm_ccgr25_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR25_CLR.
static const field_t hw_ccm_ccgr25_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR25_TOG.
static const field_t hw_ccm_ccgr25_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR26.
static const field_t hw_ccm_ccgr26[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR26_SET.
static const field_t hw_ccm_ccgr26_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR26_CLR.
static const field_t hw_ccm_ccgr26_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR26_TOG.
static const field_t hw_ccm_ccgr26_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR27.
static const field_t hw_ccm_ccgr27[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR27_SET.
static const field_t hw_ccm_ccgr27_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR27_CLR.
static const field_t hw_ccm_ccgr27_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR27_TOG.
static const field_t hw_ccm_ccgr27_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR28.
static const field_t hw_ccm_ccgr28[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR28_SET.
static const field_t hw_ccm_ccgr28_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR28_CLR.
static const field_t hw_ccm_ccgr28_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR28_TOG.
static const field_t hw_ccm_ccgr28_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR29.
static const field_t hw_ccm_ccgr29[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR29_SET.
static const field_t hw_ccm_ccgr29_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR29_CLR.
static const field_t hw_ccm_ccgr29_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR29_TOG.
static const field_t hw_ccm_ccgr29_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR30.
static const field_t hw_ccm_ccgr30[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR30_SET.
static const field_t hw_ccm_ccgr30_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR30_CLR.
static const field_t hw_ccm_ccgr30_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR30_TOG.
static const field_t hw_ccm_ccgr30_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR31.
static const field_t hw_ccm_ccgr31[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR31_SET.
static const field_t hw_ccm_ccgr31_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR31_CLR.
static const field_t hw_ccm_ccgr31_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR31_TOG.
static const field_t hw_ccm_ccgr31_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR32.
static const field_t hw_ccm_ccgr32[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR32_SET.
static const field_t hw_ccm_ccgr32_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR32_CLR.
static const field_t hw_ccm_ccgr32_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR32_TOG.
static const field_t hw_ccm_ccgr32_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR33.
static const field_t hw_ccm_ccgr33[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR33_SET.
static const field_t hw_ccm_ccgr33_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR33_CLR.
static const field_t hw_ccm_ccgr33_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR33_TOG.
static const field_t hw_ccm_ccgr33_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR34.
static const field_t hw_ccm_ccgr34[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR34_SET.
static const field_t hw_ccm_ccgr34_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR34_CLR.
static const field_t hw_ccm_ccgr34_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR34_TOG.
static const field_t hw_ccm_ccgr34_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR35.
static const field_t hw_ccm_ccgr35[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR35_SET.
static const field_t hw_ccm_ccgr35_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR35_CLR.
static const field_t hw_ccm_ccgr35_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR35_TOG.
static const field_t hw_ccm_ccgr35_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR36.
static const field_t hw_ccm_ccgr36[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR36_SET.
static const field_t hw_ccm_ccgr36_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR36_CLR.
static const field_t hw_ccm_ccgr36_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR36_TOG.
static const field_t hw_ccm_ccgr36_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR37.
static const field_t hw_ccm_ccgr37[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR37_SET.
static const field_t hw_ccm_ccgr37_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR37_CLR.
static const field_t hw_ccm_ccgr37_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR37_TOG.
static const field_t hw_ccm_ccgr37_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR38.
static const field_t hw_ccm_ccgr38[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR38_SET.
static const field_t hw_ccm_ccgr38_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR38_CLR.
static const field_t hw_ccm_ccgr38_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR38_TOG.
static const field_t hw_ccm_ccgr38_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR39.
static const field_t hw_ccm_ccgr39[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR39_SET.
static const field_t hw_ccm_ccgr39_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR39_CLR.
static const field_t hw_ccm_ccgr39_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR39_TOG.
static const field_t hw_ccm_ccgr39_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR40.
static const field_t hw_ccm_ccgr40[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR40_SET.
static const field_t hw_ccm_ccgr40_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR40_CLR.
static const field_t hw_ccm_ccgr40_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR40_TOG.
static const field_t hw_ccm_ccgr40_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR41.
static const field_t hw_ccm_ccgr41[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR41_SET.
static const field_t hw_ccm_ccgr41_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR41_CLR.
static const field_t hw_ccm_ccgr41_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR41_TOG.
static const field_t hw_ccm_ccgr41_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR42.
static const field_t hw_ccm_ccgr42[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR42_SET.
static const field_t hw_ccm_ccgr42_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR42_CLR.
static const field_t hw_ccm_ccgr42_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR42_TOG.
static const field_t hw_ccm_ccgr42_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR43.
static const field_t hw_ccm_ccgr43[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR43_SET.
static const field_t hw_ccm_ccgr43_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR43_CLR.
static const field_t hw_ccm_ccgr43_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR43_TOG.
static const field_t hw_ccm_ccgr43_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR44.
static const field_t hw_ccm_ccgr44[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR44_SET.
static const field_t hw_ccm_ccgr44_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR44_CLR.
static const field_t hw_ccm_ccgr44_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR44_TOG.
static const field_t hw_ccm_ccgr44_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR45.
static const field_t hw_ccm_ccgr45[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR45_SET.
static const field_t hw_ccm_ccgr45_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR45_CLR.
static const field_t hw_ccm_ccgr45_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR45_TOG.
static const field_t hw_ccm_ccgr45_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR46.
static const field_t hw_ccm_ccgr46[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR46_SET.
static const field_t hw_ccm_ccgr46_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR46_CLR.
static const field_t hw_ccm_ccgr46_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR46_TOG.
static const field_t hw_ccm_ccgr46_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR47.
static const field_t hw_ccm_ccgr47[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR47_SET.
static const field_t hw_ccm_ccgr47_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR47_CLR.
static const field_t hw_ccm_ccgr47_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR47_TOG.
static const field_t hw_ccm_ccgr47_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR48.
static const field_t hw_ccm_ccgr48[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR48_SET.
static const field_t hw_ccm_ccgr48_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR48_CLR.
static const field_t hw_ccm_ccgr48_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR48_TOG.
static const field_t hw_ccm_ccgr48_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR49.
static const field_t hw_ccm_ccgr49[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR49_SET.
static const field_t hw_ccm_ccgr49_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR49_CLR.
static const field_t hw_ccm_ccgr49_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR49_TOG.
static const field_t hw_ccm_ccgr49_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR50.
static const field_t hw_ccm_ccgr50[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR50_SET.
static const field_t hw_ccm_ccgr50_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR50_CLR.
static const field_t hw_ccm_ccgr50_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR50_TOG.
static const field_t hw_ccm_ccgr50_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR51.
static const field_t hw_ccm_ccgr51[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR51_SET.
static const field_t hw_ccm_ccgr51_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR51_CLR.
static const field_t hw_ccm_ccgr51_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR51_TOG.
static const field_t hw_ccm_ccgr51_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR52.
static const field_t hw_ccm_ccgr52[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR52_SET.
static const field_t hw_ccm_ccgr52_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR52_CLR.
static const field_t hw_ccm_ccgr52_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR52_TOG.
static const field_t hw_ccm_ccgr52_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR53.
static const field_t hw_ccm_ccgr53[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR53_SET.
static const field_t hw_ccm_ccgr53_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR53_CLR.
static const field_t hw_ccm_ccgr53_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR53_TOG.
static const field_t hw_ccm_ccgr53_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR54.
static const field_t hw_ccm_ccgr54[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR54_SET.
static const field_t hw_ccm_ccgr54_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR54_CLR.
static const field_t hw_ccm_ccgr54_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR54_TOG.
static const field_t hw_ccm_ccgr54_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR55.
static const field_t hw_ccm_ccgr55[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR55_SET.
static const field_t hw_ccm_ccgr55_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR55_CLR.
static const field_t hw_ccm_ccgr55_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR55_TOG.
static const field_t hw_ccm_ccgr55_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR56.
static const field_t hw_ccm_ccgr56[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR56_SET.
static const field_t hw_ccm_ccgr56_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR56_CLR.
static const field_t hw_ccm_ccgr56_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR56_TOG.
static const field_t hw_ccm_ccgr56_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR57.
static const field_t hw_ccm_ccgr57[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR57_SET.
static const field_t hw_ccm_ccgr57_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR57_CLR.
static const field_t hw_ccm_ccgr57_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR57_TOG.
static const field_t hw_ccm_ccgr57_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR58.
static const field_t hw_ccm_ccgr58[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR58_SET.
static const field_t hw_ccm_ccgr58_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR58_CLR.
static const field_t hw_ccm_ccgr58_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR58_TOG.
static const field_t hw_ccm_ccgr58_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR59.
static const field_t hw_ccm_ccgr59[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR59_SET.
static const field_t hw_ccm_ccgr59_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR59_CLR.
static const field_t hw_ccm_ccgr59_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR59_TOG.
static const field_t hw_ccm_ccgr59_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR60.
static const field_t hw_ccm_ccgr60[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR60_SET.
static const field_t hw_ccm_ccgr60_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR60_CLR.
static const field_t hw_ccm_ccgr60_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR60_TOG.
static const field_t hw_ccm_ccgr60_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR61.
static const field_t hw_ccm_ccgr61[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR61_SET.
static const field_t hw_ccm_ccgr61_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR61_CLR.
static const field_t hw_ccm_ccgr61_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR61_TOG.
static const field_t hw_ccm_ccgr61_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR62.
static const field_t hw_ccm_ccgr62[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR62_SET.
static const field_t hw_ccm_ccgr62_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR62_CLR.
static const field_t hw_ccm_ccgr62_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR62_TOG.
static const field_t hw_ccm_ccgr62_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR63.
static const field_t hw_ccm_ccgr63[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR63_SET.
static const field_t hw_ccm_ccgr63_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR63_CLR.
static const field_t hw_ccm_ccgr63_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR63_TOG.
static const field_t hw_ccm_ccgr63_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR64.
static const field_t hw_ccm_ccgr64[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR64_SET.
static const field_t hw_ccm_ccgr64_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR64_CLR.
static const field_t hw_ccm_ccgr64_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR64_TOG.
static const field_t hw_ccm_ccgr64_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR65.
static const field_t hw_ccm_ccgr65[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR65_SET.
static const field_t hw_ccm_ccgr65_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR65_CLR.
static const field_t hw_ccm_ccgr65_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR65_TOG.
static const field_t hw_ccm_ccgr65_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR66.
static const field_t hw_ccm_ccgr66[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR66_SET.
static const field_t hw_ccm_ccgr66_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR66_CLR.
static const field_t hw_ccm_ccgr66_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR66_TOG.
static const field_t hw_ccm_ccgr66_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR67.
static const field_t hw_ccm_ccgr67[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR67_SET.
static const field_t hw_ccm_ccgr67_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR67_CLR.
static const field_t hw_ccm_ccgr67_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR67_TOG.
static const field_t hw_ccm_ccgr67_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR68.
static const field_t hw_ccm_ccgr68[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR68_SET.
static const field_t hw_ccm_ccgr68_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR68_CLR.
static const field_t hw_ccm_ccgr68_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR68_TOG.
static const field_t hw_ccm_ccgr68_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR69.
static const field_t hw_ccm_ccgr69[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR69_SET.
static const field_t hw_ccm_ccgr69_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR69_CLR.
static const field_t hw_ccm_ccgr69_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR69_TOG.
static const field_t hw_ccm_ccgr69_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR70.
static const field_t hw_ccm_ccgr70[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR70_SET.
static const field_t hw_ccm_ccgr70_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR70_CLR.
static const field_t hw_ccm_ccgr70_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR70_TOG.
static const field_t hw_ccm_ccgr70_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR71.
static const field_t hw_ccm_ccgr71[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR71_SET.
static const field_t hw_ccm_ccgr71_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR71_CLR.
static const field_t hw_ccm_ccgr71_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR71_TOG.
static const field_t hw_ccm_ccgr71_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR72.
static const field_t hw_ccm_ccgr72[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR72_SET.
static const field_t hw_ccm_ccgr72_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR72_CLR.
static const field_t hw_ccm_ccgr72_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR72_TOG.
static const field_t hw_ccm_ccgr72_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR73.
static const field_t hw_ccm_ccgr73[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR73_SET.
static const field_t hw_ccm_ccgr73_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR73_CLR.
static const field_t hw_ccm_ccgr73_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR73_TOG.
static const field_t hw_ccm_ccgr73_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR74.
static const field_t hw_ccm_ccgr74[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR74_SET.
static const field_t hw_ccm_ccgr74_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR74_CLR.
static const field_t hw_ccm_ccgr74_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR74_TOG.
static const field_t hw_ccm_ccgr74_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR75.
static const field_t hw_ccm_ccgr75[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR75_SET.
static const field_t hw_ccm_ccgr75_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR75_CLR.
static const field_t hw_ccm_ccgr75_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR75_TOG.
static const field_t hw_ccm_ccgr75_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR76.
static const field_t hw_ccm_ccgr76[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR76_SET.
static const field_t hw_ccm_ccgr76_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR76_CLR.
static const field_t hw_ccm_ccgr76_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR76_TOG.
static const field_t hw_ccm_ccgr76_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR77.
static const field_t hw_ccm_ccgr77[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR77_SET.
static const field_t hw_ccm_ccgr77_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR77_CLR.
static const field_t hw_ccm_ccgr77_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR77_TOG.
static const field_t hw_ccm_ccgr77_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR78.
static const field_t hw_ccm_ccgr78[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR78_SET.
static const field_t hw_ccm_ccgr78_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR78_CLR.
static const field_t hw_ccm_ccgr78_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR78_TOG.
static const field_t hw_ccm_ccgr78_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR79.
static const field_t hw_ccm_ccgr79[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR79_SET.
static const field_t hw_ccm_ccgr79_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR79_CLR.
static const field_t hw_ccm_ccgr79_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR79_TOG.
static const field_t hw_ccm_ccgr79_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR80.
static const field_t hw_ccm_ccgr80[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR80_SET.
static const field_t hw_ccm_ccgr80_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR80_CLR.
static const field_t hw_ccm_ccgr80_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR80_TOG.
static const field_t hw_ccm_ccgr80_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR81.
static const field_t hw_ccm_ccgr81[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR81_SET.
static const field_t hw_ccm_ccgr81_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR81_CLR.
static const field_t hw_ccm_ccgr81_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR81_TOG.
static const field_t hw_ccm_ccgr81_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR82.
static const field_t hw_ccm_ccgr82[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR82_SET.
static const field_t hw_ccm_ccgr82_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR82_CLR.
static const field_t hw_ccm_ccgr82_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR82_TOG.
static const field_t hw_ccm_ccgr82_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR83.
static const field_t hw_ccm_ccgr83[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR83_SET.
static const field_t hw_ccm_ccgr83_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR83_CLR.
static const field_t hw_ccm_ccgr83_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR83_TOG.
static const field_t hw_ccm_ccgr83_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR84.
static const field_t hw_ccm_ccgr84[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR84_SET.
static const field_t hw_ccm_ccgr84_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR84_CLR.
static const field_t hw_ccm_ccgr84_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR84_TOG.
static const field_t hw_ccm_ccgr84_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR85.
static const field_t hw_ccm_ccgr85[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR85_SET.
static const field_t hw_ccm_ccgr85_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR85_CLR.
static const field_t hw_ccm_ccgr85_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR85_TOG.
static const field_t hw_ccm_ccgr85_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR86.
static const field_t hw_ccm_ccgr86[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR86_SET.
static const field_t hw_ccm_ccgr86_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR86_CLR.
static const field_t hw_ccm_ccgr86_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR86_TOG.
static const field_t hw_ccm_ccgr86_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR87.
static const field_t hw_ccm_ccgr87[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR87_SET.
static const field_t hw_ccm_ccgr87_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR87_CLR.
static const field_t hw_ccm_ccgr87_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR87_TOG.
static const field_t hw_ccm_ccgr87_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR88.
static const field_t hw_ccm_ccgr88[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR88_SET.
static const field_t hw_ccm_ccgr88_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR88_CLR.
static const field_t hw_ccm_ccgr88_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR88_TOG.
static const field_t hw_ccm_ccgr88_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR89.
static const field_t hw_ccm_ccgr89[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR89_SET.
static const field_t hw_ccm_ccgr89_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR89_CLR.
static const field_t hw_ccm_ccgr89_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR89_TOG.
static const field_t hw_ccm_ccgr89_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR90.
static const field_t hw_ccm_ccgr90[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR90_SET.
static const field_t hw_ccm_ccgr90_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR90_CLR.
static const field_t hw_ccm_ccgr90_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR90_TOG.
static const field_t hw_ccm_ccgr90_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR91.
static const field_t hw_ccm_ccgr91[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR91_SET.
static const field_t hw_ccm_ccgr91_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR91_CLR.
static const field_t hw_ccm_ccgr91_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR91_TOG.
static const field_t hw_ccm_ccgr91_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR92.
static const field_t hw_ccm_ccgr92[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR92_SET.
static const field_t hw_ccm_ccgr92_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR92_CLR.
static const field_t hw_ccm_ccgr92_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR92_TOG.
static const field_t hw_ccm_ccgr92_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR93.
static const field_t hw_ccm_ccgr93[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR93_SET.
static const field_t hw_ccm_ccgr93_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR93_CLR.
static const field_t hw_ccm_ccgr93_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR93_TOG.
static const field_t hw_ccm_ccgr93_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR94.
static const field_t hw_ccm_ccgr94[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR94_SET.
static const field_t hw_ccm_ccgr94_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR94_CLR.
static const field_t hw_ccm_ccgr94_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR94_TOG.
static const field_t hw_ccm_ccgr94_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR95.
static const field_t hw_ccm_ccgr95[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR95_SET.
static const field_t hw_ccm_ccgr95_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR95_CLR.
static const field_t hw_ccm_ccgr95_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR95_TOG.
static const field_t hw_ccm_ccgr95_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR96.
static const field_t hw_ccm_ccgr96[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR96_SET.
static const field_t hw_ccm_ccgr96_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR96_CLR.
static const field_t hw_ccm_ccgr96_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR96_TOG.
static const field_t hw_ccm_ccgr96_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR97.
static const field_t hw_ccm_ccgr97[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR97_SET.
static const field_t hw_ccm_ccgr97_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR97_CLR.
static const field_t hw_ccm_ccgr97_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR97_TOG.
static const field_t hw_ccm_ccgr97_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR98.
static const field_t hw_ccm_ccgr98[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR98_SET.
static const field_t hw_ccm_ccgr98_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR98_CLR.
static const field_t hw_ccm_ccgr98_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR98_TOG.
static const field_t hw_ccm_ccgr98_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR99.
static const field_t hw_ccm_ccgr99[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR99_SET.
static const field_t hw_ccm_ccgr99_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR99_CLR.
static const field_t hw_ccm_ccgr99_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR99_TOG.
static const field_t hw_ccm_ccgr99_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR100.
static const field_t hw_ccm_ccgr100[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR100_SET.
static const field_t hw_ccm_ccgr100_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR100_CLR.
static const field_t hw_ccm_ccgr100_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR100_TOG.
static const field_t hw_ccm_ccgr100_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR101.
static const field_t hw_ccm_ccgr101[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR101_SET.
static const field_t hw_ccm_ccgr101_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR101_CLR.
static const field_t hw_ccm_ccgr101_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR101_TOG.
static const field_t hw_ccm_ccgr101_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR102.
static const field_t hw_ccm_ccgr102[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR102_SET.
static const field_t hw_ccm_ccgr102_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR102_CLR.
static const field_t hw_ccm_ccgr102_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR102_TOG.
static const field_t hw_ccm_ccgr102_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR103.
static const field_t hw_ccm_ccgr103[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR103_SET.
static const field_t hw_ccm_ccgr103_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR103_CLR.
static const field_t hw_ccm_ccgr103_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR103_TOG.
static const field_t hw_ccm_ccgr103_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR104.
static const field_t hw_ccm_ccgr104[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR104_SET.
static const field_t hw_ccm_ccgr104_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR104_CLR.
static const field_t hw_ccm_ccgr104_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR104_TOG.
static const field_t hw_ccm_ccgr104_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR105.
static const field_t hw_ccm_ccgr105[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR105_SET.
static const field_t hw_ccm_ccgr105_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR105_CLR.
static const field_t hw_ccm_ccgr105_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR105_TOG.
static const field_t hw_ccm_ccgr105_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR106.
static const field_t hw_ccm_ccgr106[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR106_SET.
static const field_t hw_ccm_ccgr106_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR106_CLR.
static const field_t hw_ccm_ccgr106_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR106_TOG.
static const field_t hw_ccm_ccgr106_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR107.
static const field_t hw_ccm_ccgr107[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR107_SET.
static const field_t hw_ccm_ccgr107_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR107_CLR.
static const field_t hw_ccm_ccgr107_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR107_TOG.
static const field_t hw_ccm_ccgr107_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR108.
static const field_t hw_ccm_ccgr108[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR108_SET.
static const field_t hw_ccm_ccgr108_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR108_CLR.
static const field_t hw_ccm_ccgr108_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR108_TOG.
static const field_t hw_ccm_ccgr108_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR109.
static const field_t hw_ccm_ccgr109[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR109_SET.
static const field_t hw_ccm_ccgr109_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR109_CLR.
static const field_t hw_ccm_ccgr109_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR109_TOG.
static const field_t hw_ccm_ccgr109_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR110.
static const field_t hw_ccm_ccgr110[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR110_SET.
static const field_t hw_ccm_ccgr110_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR110_CLR.
static const field_t hw_ccm_ccgr110_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR110_TOG.
static const field_t hw_ccm_ccgr110_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR111.
static const field_t hw_ccm_ccgr111[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR111_SET.
static const field_t hw_ccm_ccgr111_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR111_CLR.
static const field_t hw_ccm_ccgr111_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR111_TOG.
static const field_t hw_ccm_ccgr111_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR112.
static const field_t hw_ccm_ccgr112[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR112_SET.
static const field_t hw_ccm_ccgr112_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR112_CLR.
static const field_t hw_ccm_ccgr112_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR112_TOG.
static const field_t hw_ccm_ccgr112_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR113.
static const field_t hw_ccm_ccgr113[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR113_SET.
static const field_t hw_ccm_ccgr113_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR113_CLR.
static const field_t hw_ccm_ccgr113_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR113_TOG.
static const field_t hw_ccm_ccgr113_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR114.
static const field_t hw_ccm_ccgr114[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR114_SET.
static const field_t hw_ccm_ccgr114_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR114_CLR.
static const field_t hw_ccm_ccgr114_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR114_TOG.
static const field_t hw_ccm_ccgr114_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR115.
static const field_t hw_ccm_ccgr115[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR115_SET.
static const field_t hw_ccm_ccgr115_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR115_CLR.
static const field_t hw_ccm_ccgr115_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR115_TOG.
static const field_t hw_ccm_ccgr115_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR116.
static const field_t hw_ccm_ccgr116[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR116_SET.
static const field_t hw_ccm_ccgr116_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR116_CLR.
static const field_t hw_ccm_ccgr116_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR116_TOG.
static const field_t hw_ccm_ccgr116_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR117.
static const field_t hw_ccm_ccgr117[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR117_SET.
static const field_t hw_ccm_ccgr117_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR117_CLR.
static const field_t hw_ccm_ccgr117_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR117_TOG.
static const field_t hw_ccm_ccgr117_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR118.
static const field_t hw_ccm_ccgr118[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR118_SET.
static const field_t hw_ccm_ccgr118_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR118_CLR.
static const field_t hw_ccm_ccgr118_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR118_TOG.
static const field_t hw_ccm_ccgr118_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR119.
static const field_t hw_ccm_ccgr119[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR119_SET.
static const field_t hw_ccm_ccgr119_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR119_CLR.
static const field_t hw_ccm_ccgr119_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR119_TOG.
static const field_t hw_ccm_ccgr119_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR120.
static const field_t hw_ccm_ccgr120[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR120_SET.
static const field_t hw_ccm_ccgr120_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR120_CLR.
static const field_t hw_ccm_ccgr120_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR120_TOG.
static const field_t hw_ccm_ccgr120_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR121.
static const field_t hw_ccm_ccgr121[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR121_SET.
static const field_t hw_ccm_ccgr121_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR121_CLR.
static const field_t hw_ccm_ccgr121_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR121_TOG.
static const field_t hw_ccm_ccgr121_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR122.
static const field_t hw_ccm_ccgr122[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR122_SET.
static const field_t hw_ccm_ccgr122_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR122_CLR.
static const field_t hw_ccm_ccgr122_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR122_TOG.
static const field_t hw_ccm_ccgr122_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR123.
static const field_t hw_ccm_ccgr123[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR123_SET.
static const field_t hw_ccm_ccgr123_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR123_CLR.
static const field_t hw_ccm_ccgr123_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR123_TOG.
static const field_t hw_ccm_ccgr123_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR124.
static const field_t hw_ccm_ccgr124[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR124_SET.
static const field_t hw_ccm_ccgr124_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR124_CLR.
static const field_t hw_ccm_ccgr124_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR124_TOG.
static const field_t hw_ccm_ccgr124_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR125.
static const field_t hw_ccm_ccgr125[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR125_SET.
static const field_t hw_ccm_ccgr125_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR125_CLR.
static const field_t hw_ccm_ccgr125_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR125_TOG.
static const field_t hw_ccm_ccgr125_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR126.
static const field_t hw_ccm_ccgr126[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR126_SET.
static const field_t hw_ccm_ccgr126_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR126_CLR.
static const field_t hw_ccm_ccgr126_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR126_TOG.
static const field_t hw_ccm_ccgr126_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR127.
static const field_t hw_ccm_ccgr127[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR127_SET.
static const field_t hw_ccm_ccgr127_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR127_CLR.
static const field_t hw_ccm_ccgr127_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR127_TOG.
static const field_t hw_ccm_ccgr127_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR128.
static const field_t hw_ccm_ccgr128[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR128_SET.
static const field_t hw_ccm_ccgr128_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR128_CLR.
static const field_t hw_ccm_ccgr128_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR128_TOG.
static const field_t hw_ccm_ccgr128_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR129.
static const field_t hw_ccm_ccgr129[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR129_SET.
static const field_t hw_ccm_ccgr129_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR129_CLR.
static const field_t hw_ccm_ccgr129_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR129_TOG.
static const field_t hw_ccm_ccgr129_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR130.
static const field_t hw_ccm_ccgr130[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR130_SET.
static const field_t hw_ccm_ccgr130_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR130_CLR.
static const field_t hw_ccm_ccgr130_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR130_TOG.
static const field_t hw_ccm_ccgr130_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR131.
static const field_t hw_ccm_ccgr131[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR131_SET.
static const field_t hw_ccm_ccgr131_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR131_CLR.
static const field_t hw_ccm_ccgr131_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR131_TOG.
static const field_t hw_ccm_ccgr131_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR132.
static const field_t hw_ccm_ccgr132[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR132_SET.
static const field_t hw_ccm_ccgr132_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR132_CLR.
static const field_t hw_ccm_ccgr132_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR132_TOG.
static const field_t hw_ccm_ccgr132_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR133.
static const field_t hw_ccm_ccgr133[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR133_SET.
static const field_t hw_ccm_ccgr133_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR133_CLR.
static const field_t hw_ccm_ccgr133_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR133_TOG.
static const field_t hw_ccm_ccgr133_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR134.
static const field_t hw_ccm_ccgr134[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR134_SET.
static const field_t hw_ccm_ccgr134_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR134_CLR.
static const field_t hw_ccm_ccgr134_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR134_TOG.
static const field_t hw_ccm_ccgr134_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR135.
static const field_t hw_ccm_ccgr135[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR135_SET.
static const field_t hw_ccm_ccgr135_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR135_CLR.
static const field_t hw_ccm_ccgr135_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR135_TOG.
static const field_t hw_ccm_ccgr135_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR136.
static const field_t hw_ccm_ccgr136[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR136_SET.
static const field_t hw_ccm_ccgr136_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR136_CLR.
static const field_t hw_ccm_ccgr136_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR136_TOG.
static const field_t hw_ccm_ccgr136_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR137.
static const field_t hw_ccm_ccgr137[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR137_SET.
static const field_t hw_ccm_ccgr137_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR137_CLR.
static const field_t hw_ccm_ccgr137_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR137_TOG.
static const field_t hw_ccm_ccgr137_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR138.
static const field_t hw_ccm_ccgr138[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR138_SET.
static const field_t hw_ccm_ccgr138_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR138_CLR.
static const field_t hw_ccm_ccgr138_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR138_TOG.
static const field_t hw_ccm_ccgr138_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR139.
static const field_t hw_ccm_ccgr139[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR139_SET.
static const field_t hw_ccm_ccgr139_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR139_CLR.
static const field_t hw_ccm_ccgr139_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR139_TOG.
static const field_t hw_ccm_ccgr139_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR140.
static const field_t hw_ccm_ccgr140[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR140_SET.
static const field_t hw_ccm_ccgr140_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR140_CLR.
static const field_t hw_ccm_ccgr140_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR140_TOG.
static const field_t hw_ccm_ccgr140_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR141.
static const field_t hw_ccm_ccgr141[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR141_SET.
static const field_t hw_ccm_ccgr141_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR141_CLR.
static const field_t hw_ccm_ccgr141_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR141_TOG.
static const field_t hw_ccm_ccgr141_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR142.
static const field_t hw_ccm_ccgr142[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR142_SET.
static const field_t hw_ccm_ccgr142_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR142_CLR.
static const field_t hw_ccm_ccgr142_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR142_TOG.
static const field_t hw_ccm_ccgr142_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR143.
static const field_t hw_ccm_ccgr143[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR143_SET.
static const field_t hw_ccm_ccgr143_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR143_CLR.
static const field_t hw_ccm_ccgr143_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR143_TOG.
static const field_t hw_ccm_ccgr143_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR144.
static const field_t hw_ccm_ccgr144[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR144_SET.
static const field_t hw_ccm_ccgr144_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR144_CLR.
static const field_t hw_ccm_ccgr144_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR144_TOG.
static const field_t hw_ccm_ccgr144_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR145.
static const field_t hw_ccm_ccgr145[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR145_SET.
static const field_t hw_ccm_ccgr145_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR145_CLR.
static const field_t hw_ccm_ccgr145_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR145_TOG.
static const field_t hw_ccm_ccgr145_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR146.
static const field_t hw_ccm_ccgr146[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR146_SET.
static const field_t hw_ccm_ccgr146_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR146_CLR.
static const field_t hw_ccm_ccgr146_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR146_TOG.
static const field_t hw_ccm_ccgr146_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR147.
static const field_t hw_ccm_ccgr147[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR147_SET.
static const field_t hw_ccm_ccgr147_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR147_CLR.
static const field_t hw_ccm_ccgr147_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR147_TOG.
static const field_t hw_ccm_ccgr147_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR148.
static const field_t hw_ccm_ccgr148[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR148_SET.
static const field_t hw_ccm_ccgr148_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR148_CLR.
static const field_t hw_ccm_ccgr148_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR148_TOG.
static const field_t hw_ccm_ccgr148_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR149.
static const field_t hw_ccm_ccgr149[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR149_SET.
static const field_t hw_ccm_ccgr149_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR149_CLR.
static const field_t hw_ccm_ccgr149_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR149_TOG.
static const field_t hw_ccm_ccgr149_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR150.
static const field_t hw_ccm_ccgr150[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR150_SET.
static const field_t hw_ccm_ccgr150_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR150_CLR.
static const field_t hw_ccm_ccgr150_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR150_TOG.
static const field_t hw_ccm_ccgr150_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR151.
static const field_t hw_ccm_ccgr151[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR151_SET.
static const field_t hw_ccm_ccgr151_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR151_CLR.
static const field_t hw_ccm_ccgr151_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR151_TOG.
static const field_t hw_ccm_ccgr151_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR152.
static const field_t hw_ccm_ccgr152[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR152_SET.
static const field_t hw_ccm_ccgr152_set[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR152_CLR.
static const field_t hw_ccm_ccgr152_clr[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING3",
        "Clock gate control setting for domain 3.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR152_TOG.
static const field_t hw_ccm_ccgr152_tog[] =
{
    {
        "SETTING0",
        "Clock gate control setting for domain 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING1",
        "Clock gate control setting for domain 1.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SETTING2",
        "Clock gate control setting for domain 2.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
  