#include "memtools_register_info.h"

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ADC_16FIFO_15_CMD_BUFFER
#endif

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_VERID.
static const field_t hw_adc_16fifo_15_cmd_buffer_verid[] =
{
    {
        "RES",
        "This read only field indicates the maximum accuracy supported by this "
        "implementation.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DIFFEN",
        "This read only field indicates if differential operation is supported "
        "by this implementation.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MVI",
        "This read only field indicates if multiple Voltage Reference High inpu"
        "ts are supported by this implementation.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CSW",
        "This read only field indicates if channel scaling is supported by this"
        " implementation.",
        4, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VR1RNGI",
        "This read only field indicates if a control bit is implemented for sel"
        "ecting the input voltage range on Voltage Reference Option 1.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IADCKI",
        "This read only field indicates if this implementation of the ADC block"
        " includes an internal clock source.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CALOFSI",
        "This read only field indicates if a calibration function and trimming "
        "control register are implemented.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "This read only field returns the minor version number for the module s"
        "pecification.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "This read only field returns the major version number for the module s"
        "pecification.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_PARAM.
static const field_t hw_adc_16fifo_15_cmd_buffer_param[] =
{
    {
        "TRIG_NUM",
        "Number of Triggers implemented.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FIFOSIZE",
        "The maximum number of conversion datawords that can be stored in the r"
        "esult FIFO before an overflow occurs.",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CV_NUM",
        "Number of compare value registers implemented.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMD_NUM",
        "Number of command buffers implemented.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CTRL.
static const field_t hw_adc_16fifo_15_cmd_buffer_ctrl[] =
{
    {
        "ADCEN",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RST",
        "Reset all ADC internal logic and registers, except the Control Registe"
        "r.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOZEN",
        "Control system transition to Stop and Wait power modes while ADC is co"
        "nverting.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSTFIFO",
        "",
        8, // LSB
        8, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_STAT.
static const field_t hw_adc_16fifo_15_cmd_buffer_stat[] =
{
    {
        "RDY",
        "Indicates when the number of valid datawords in the result FIFO is gre"
        "ater than the watermark level set in the FCTRL[FWMARK] bitfield.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FOF",
        "Indicates that more data has been written to the Result FIFO than it c"
        "an hold.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGACT",
        "TRGACT is a read-only status field indicating the trigger associated w"
        "ith the command actively being processed.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDACT",
        "CMDACT is a read-only status field indicating the command that is acti"
        "vely being processed.",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_IE.
static const field_t hw_adc_16fifo_15_cmd_buffer_ie[] =
{
    {
        "FWMIE",
        "Configures ADC to generate watermark interrupt requests when RDY flag "
        "is asserted.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FOFIE",
        "Configures ADC to generate overflow interrupt requests when FOF flag i"
        "s asserted.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_DE.
static const field_t hw_adc_16fifo_15_cmd_buffer_de[] =
{
    {
        "FWMDE",
        "Configures ADC to generate DMA requests when RDY flag is asserted.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CFG.
static const field_t hw_adc_16fifo_15_cmd_buffer_cfg[] =
{
    {
        "TPRICTRL",
        "This bitfield controls how higher priority triggers are handled.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWRSEL",
        "Configures the ADC for power and performance.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFSEL",
        "Selects the voltage reference high used for conversions.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PUDLY",
        "When CFG[PWREN]=0b0, the ADC analog circuits are only powered while th"
        "e ADC is active and there is a counted delay defined by CFG[PUDLY] aft"
        "er an initial trigger transitions the ADC from its Idle state to allow"
        " time for the analog circuits to stabilize.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWREN",
        "Enables the ADC analog circuits.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_PAUSE.
static const field_t hw_adc_16fifo_15_cmd_buffer_pause[] =
{
    {
        "PAUSEDLY",
        "When PAUSEEN is set, the PAUSEDLY field controls the duration of pausi"
        "ng during command exection sequencing.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAUSEEN",
        "Enables the ADC pausing function.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_FCTRL.
static const field_t hw_adc_16fifo_15_cmd_buffer_fctrl[] =
{
    {
        "FCOUNT",
        "This read-only field indicates the number of datawords that are stored"
        " in the result FIFO.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FWMARK",
        "FWMARK is a programmable threshold setting.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_SWTRIG.
static const field_t hw_adc_16fifo_15_cmd_buffer_swtrig[] =
{
    {
        "SWT0",
        "Write 1 to SWT0 generates a trigger 0 event.",
        0, // LSB
        0, // MSB
        false, // Readable
        false // Writable
    },
    {
        "SWT1",
        "Write 1 to SWT1 generates a trigger 1 event.",
        1, // LSB
        1, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_TCTRL0.
static const field_t hw_adc_16fifo_15_cmd_buffer_tctrl0[] =
{
    {
        "HTEN",
        "Enable hardware trigger source to initiate conversion on the rising ed"
        "ge of the input trigger source.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPRI",
        "This bitfield sets the priority of the associated trigger source.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDLY",
        "Select the trigger delay duration to wait at the start of servicing a "
        "trigger event.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCMD",
        "Select the command from command buffer to execute upon detect of the a"
        "ssociated trigger event.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_TCTRL1.
static const field_t hw_adc_16fifo_15_cmd_buffer_tctrl1[] =
{
    {
        "HTEN",
        "Enable hardware trigger source to initiate conversion on the rising ed"
        "ge of the input trigger source.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPRI",
        "This bitfield sets the priority of the associated trigger source.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDLY",
        "Select the trigger delay duration to wait at the start of servicing a "
        "trigger event.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCMD",
        "Select the command from command buffer to execute upon detect of the a"
        "ssociated trigger event.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL1.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl1[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL2.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl2[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL3.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl3[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL4.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl4[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL5.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl5[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL6.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl6[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL7.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl7[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL8.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl8[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL9.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl9[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL10.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl10[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL11.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl11[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL12.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl12[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL13.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl13[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL14.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl14[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDL15.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdl15[] =
{
    {
        "ADCH",
        "Each ADCH channel selection has an associated A side and an associated"
        " B side input.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABSEL",
        "When DIFF=0b0, ABSEL selects the channel from either the A-side or B-s"
        "ide channel inputs.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIFF",
        "Configures the ADC to operate in differential mode or single-ended mod"
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCALE",
        "Reduce the selected ADC analog channel input voltage level by a factor"
        ".",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH1.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh1[] =
{
    {
        "CMPEN",
        "After an ADC channel input is sampled and converted and any averaging "
        "iterations are performed, the CMDHa[CMPEN] field guides operation of t"
        "he automatic compare function to optionally only store when the compar"
        "e operation is true.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH2.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh2[] =
{
    {
        "CMPEN",
        "After an ADC channel input is sampled and converted and any averaging "
        "iterations are performed, the CMDHa[CMPEN] field guides operation of t"
        "he automatic compare function to optionally only store when the compar"
        "e operation is true.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH3.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh3[] =
{
    {
        "CMPEN",
        "After an ADC channel input is sampled and converted and any averaging "
        "iterations are performed, the CMDHa[CMPEN] field guides operation of t"
        "he automatic compare function to optionally only store when the compar"
        "e operation is true.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH4.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh4[] =
{
    {
        "CMPEN",
        "After an ADC channel input is sampled and converted and any averaging "
        "iterations are performed, the CMDHa[CMPEN] field guides operation of t"
        "he automatic compare function to optionally only store when the compar"
        "e operation is true.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH5.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh5[] =
{
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH6.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh6[] =
{
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH7.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh7[] =
{
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH8.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh8[] =
{
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH9.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh9[] =
{
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH10.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh10[] =
{
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH11.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh11[] =
{
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH12.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh12[] =
{
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH13.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh13[] =
{
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH14.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh14[] =
{
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CMDH15.
static const field_t hw_adc_16fifo_15_cmd_buffer_cmdh15[] =
{
    {
        "LWI",
        "When LWI is clear, the LOOP field selects the number of times the sele"
        "cted channel is converted consecutively.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STS",
        "When programmed to 000 the minimum sample time of 3 ADCK cycles is sel"
        "ected.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Selects how many ADC conversions are averaged to create the ADC result"
        " (2AVGS).",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOOP",
        "Selects how many times this command executes (and stores conversion re"
        "sult to RESFIFO) before finish and transition to the next command or I"
        "dle state.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEXT",
        "Selects the next command to be executed after this command completes.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CV1.
static const field_t hw_adc_16fifo_15_cmd_buffer_cv1[] =
{
    {
        "CVL",
        "The compare function can be configured to check whether the result is "
        "less than, greater than, or if the result falls within or outside a ra"
        "nge determined by two compare values.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CVH",
        "The compare function can be configured to check whether the result is "
        "less than, greater than, or if the result falls within or outside a ra"
        "nge determined by two compare values.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CV2.
static const field_t hw_adc_16fifo_15_cmd_buffer_cv2[] =
{
    {
        "CVL",
        "The compare function can be configured to check whether the result is "
        "less than, greater than, or if the result falls within or outside a ra"
        "nge determined by two compare values.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CVH",
        "The compare function can be configured to check whether the result is "
        "less than, greater than, or if the result falls within or outside a ra"
        "nge determined by two compare values.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CV3.
static const field_t hw_adc_16fifo_15_cmd_buffer_cv3[] =
{
    {
        "CVL",
        "The compare function can be configured to check whether the result is "
        "less than, greater than, or if the result falls within or outside a ra"
        "nge determined by two compare values.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CVH",
        "The compare function can be configured to check whether the result is "
        "less than, greater than, or if the result falls within or outside a ra"
        "nge determined by two compare values.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_CV4.
static const field_t hw_adc_16fifo_15_cmd_buffer_cv4[] =
{
    {
        "CVL",
        "The compare function can be configured to check whether the result is "
        "less than, greater than, or if the result falls within or outside a ra"
        "nge determined by two compare values.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CVH",
        "The compare function can be configured to check whether the result is "
        "less than, greater than, or if the result falls within or outside a ra"
        "nge determined by two compare values.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_16FIFO_15_CMD_BUFFER_RESFIFO.
static const field_t hw_adc_16fifo_15_cmd_buffer_resfifo[] =
{
    {
        "D",
        "The formatting for the data in D is summarized in Data result register"
        " format description.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TSRC",
        "Indicate the trigger source that initiated a conversion and generated "
        "this result.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOOPCNT",
        "Indicate the loop count value during command execution that generated "
        "this result.",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDSRC",
        "Indicate the command buffer being executed that generated this result.",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VALID",
        "Indicate the FIFO entry is valid.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a ADC_16FIFO_15_CMD_BUFFER module.
static const reg_t hw_adc_16fifo_15_cmd_buffer[] =
{
    {
        "VERID",
        "The Version ID register indicates the version integrated for this inst"
        "ance on the device and also indicates inclusion/exclusion of several o"
        "ptional features.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        9, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_verid
    },
    {
        "PARAM",
        "The Parameter register indicates the size of several variable integrat"
        "ion options for this instance on the device.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_param
    },
    {
        "CTRL",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_ctrl
    },
    {
        "STAT",
        "The Status Register provides the current status of the ADC module.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_stat
    },
    {
        "IE",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_ie
    },
    {
        "DE",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_de
    },
    {
        "CFG",
        "The Configuration Register controls ADC functions that are common to a"
        "ll commands.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cfg
    },
    {
        "PAUSE",
        "The Pause Register controls an optional inserted delay between convers"
        "ions.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_pause
    },
    {
        "FCTRL",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_fctrl
    },
    {
        "SWTRIG",
        "The Software Trigger Register (SWTRIG) is written to initiate software"
        " triggered conversions.",
        4, // Width in bytes
        0x00000034, // Base address offset
        false, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_swtrig
    },
    {
        "TCTRL0",
        "The Trigger Control (TCTRLa) register implements control fields associ"
        "ated with each implemented trigger source.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_tctrl0
    },
    {
        "TCTRL1",
        "The Trigger Control (TCTRLa) register implements control fields associ"
        "ated with each implemented trigger source.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_tctrl1
    },
    {
        "CMDL1",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl1
    },
    {
        "CMDL2",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl2
    },
    {
        "CMDL3",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl3
    },
    {
        "CMDL4",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl4
    },
    {
        "CMDL5",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl5
    },
    {
        "CMDL6",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000128, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl6
    },
    {
        "CMDL7",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl7
    },
    {
        "CMDL8",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000138, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl8
    },
    {
        "CMDL9",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl9
    },
    {
        "CMDL10",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000148, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl10
    },
    {
        "CMDL11",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl11
    },
    {
        "CMDL12",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000158, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl12
    },
    {
        "CMDL13",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl13
    },
    {
        "CMDL14",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000168, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl14
    },
    {
        "CMDL15",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdl15
    },
    {
        "CMDH1",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh1
    },
    {
        "CMDH2",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x0000010c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh2
    },
    {
        "CMDH3",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000114, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh3
    },
    {
        "CMDH4",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh4
    },
    {
        "CMDH5",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000124, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh5
    },
    {
        "CMDH6",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x0000012c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh6
    },
    {
        "CMDH7",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000134, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh7
    },
    {
        "CMDH8",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x0000013c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh8
    },
    {
        "CMDH9",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000144, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh9
    },
    {
        "CMDH10",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x0000014c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh10
    },
    {
        "CMDH11",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000154, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh11
    },
    {
        "CMDH12",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x0000015c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh12
    },
    {
        "CMDH13",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000164, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh13
    },
    {
        "CMDH14",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x0000016c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh14
    },
    {
        "CMDH15",
        "There are 15 command buffers (CMDa), each constructed from two 32-bit "
        "registers (CMDLa:CMDHa) that can be configured for different channel s"
        "elect and varying conversion options.",
        4, // Width in bytes
        0x00000174, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cmdh15
    },
    {
        "CV1",
        "The compare value registers (CVa) contain values used to compare the c"
        "onversion result when the compare function is enabled.",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cv1
    },
    {
        "CV2",
        "The compare value registers (CVa) contain values used to compare the c"
        "onversion result when the compare function is enabled.",
        4, // Width in bytes
        0x00000204, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cv2
    },
    {
        "CV3",
        "The compare value registers (CVa) contain values used to compare the c"
        "onversion result when the compare function is enabled.",
        4, // Width in bytes
        0x00000208, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cv3
    },
    {
        "CV4",
        "The compare value registers (CVa) contain values used to compare the c"
        "onversion result when the compare function is enabled.",
        4, // Width in bytes
        0x0000020c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_cv4
    },
    {
        "RESFIFO",
        "The data result FIFO register (RESFIFO) is a 16 entry FIFO that stores"
        " the data result of ADC conversions.",
        4, // Width in bytes
        0x00000300, // Base address offset
        true, // Readable
        false, // Writable
        5, // Number of bitfields
        hw_adc_16fifo_15_cmd_buffer_resfifo
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark AXBS
#endif

// Registers in a AXBS module.
static const reg_t hw_axbs[] =
{
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CMP
#endif

// Bitfields in register CMP_VERID.
static const field_t hw_cmp_verid[] =
{
    {
        "FEATURE",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CMP_PARAM.
static const field_t hw_cmp_param[] =
{
    {
        "PARAM",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CMP_C0.
static const field_t hw_cmp_c0[] =
{
    {
        "HYSTCTR",
        "",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FILTER_CNT",
        "This field specifies the number of consecutive samples that must agree"
        " prior to the comparator ouput filter accepting a new output state.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN",
        "The EN bit enables the Analog Comparator Module.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPE",
        "The OPE bit enables the path from the comparator output to a selected "
        "pin.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COS",
        "",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INVT",
        "This bit allows selecting the polarity of the analog comparator functi"
        "on.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PMODE",
        "",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WE",
        "If a write to this register attempts to set both SE and WE, then only "
        "Sampling mode is taking effect in MCU Run mode and the Round Robin Cyc"
        "ling(Trigger Mode) is enabled in MCU STOP mode.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SE",
        "If a write to this register attempts to set both SE and WE, then only "
        "Sampling mode is taking effect in MCU Run mode and the Round Robin Cyc"
        "ling(Trigger Mode) is enabled in MCU STOP mode.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FPR",
        "Specifies the sampling period, in bus clock cycles, of the comparator "
        "output filter, when C1[SE] = 0.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COUT",
        "Returns the current value of the Analog Comparator output, when read.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CFF",
        "Detects a falling-edge on COUT, when set, during normal operation.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CFR",
        "Detects a rising-edge on COUT, when set, during normal operation.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IEF",
        "Enables the CFF interrupt from the CMP.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IER",
        "Enables the CFR interrupt from the CMP.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAEN",
        "Enables the DMA transfer triggered from the CMP module.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKEN",
        "This bit is used to enable the link from CMP to DAC enables.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CMP_C1.
static const field_t hw_cmp_c1[] =
{
    {
        "VOSEL",
        "This bit selects an output voltage from one of 256 distinct levels.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMODE",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VRSEL",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DACEN",
        "This bit is used to enable the DAC.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DACOE",
        "This bit is used to enable the DAC output.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHN0",
        "Channel 0 of the input enable for the round-robin checker.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHN1",
        "Channel 1 of the input enable for the round-robin checker.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHN2",
        "Channel 2 of the input enable for the round-robin checker.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHN3",
        "Channel 3 of the input enable for the round-robin checker.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHN4",
        "Channel 4 of the input enable for the round-robin checker.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHN5",
        "Channel 5 of the input enable for the round-robin checker.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MSEL",
        "These bits determine which input is selected for the negative mux.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSEL",
        "These bits determines which input is selected for the positive mux.",
        28, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CMP_C2.
static const field_t hw_cmp_c2[] =
{
    {
        "ACON",
        "The result of the input comparison for channel n .",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INITMOD",
        "These values specify the round robin clock cycles used to determine th"
        "e comparator and DAC initialization delays specified by the datasheet.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSAM",
        "For a given channel, this field specifies how many round-robin clock c"
        "ycles later the sample takes place.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0F",
        "External Channel 0 input changed flag.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1F",
        "External Channel 1 input changed flag.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2F",
        "External Channel 2 input changed flag.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3F",
        "External Channel 3 input changed flag.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4F",
        "External Channel 4 input changed flag.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5F",
        "External Channel 5 input changed flag.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FXMXCH",
        "This field indicates which channel in the mux port is fixed in a given"
        " round-robin mode.",
        25, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FXMP",
        "This bit is used to fix the analog mux port for the round-robin mode.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RRIE",
        "This bit enables the interrupt/wake-up when the comparison result chan"
        "ges for a given channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CMP_C3.
static const field_t hw_cmp_c3[] =
{
    {
        "ACPH2TC",
        "These values configures the analog comparator phase2 timing when RDIV "
        "is set to 1 which means the input volage level is above 1.8v.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACPH1TC",
        "These values configures the analog comparator phase1 timing when RDIV "
        "is set to 1 which means the input volage level is above 1.8v.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACSAT",
        "These values configures the analog comparator sampling timing(speicifi"
        "ed by the discrete mode clock period T which is selected by DMCS) in d"
        "iscrete mode.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMCS",
        "This bit is used to select the clock source in order to generate the r"
        "equiried timing for comparator to work in discrete mode.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDIVE",
        "This bit is used to enable the resistor divider for the inputs when th"
        "ey come from 3v domain and their values are above 1.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NCHCTEN",
        "This bit is used to enable the negative channel working in continuous "
        "mode.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCHCTEN",
        "This bit is used to enable the positive channel working in continuous "
        "mode.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CMP module.
static const reg_t hw_cmp[] =
{
    {
        "VERID",
        "Access: Supervisor read only User read only",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_cmp_verid
    },
    {
        "PARAM",
        "Access: Supervisor read only User read only",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_cmp_param
    },
    {
        "C0",
        "Access: Supervisor read/write User read/write",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_cmp_c0
    },
    {
        "C1",
        "Access: Supervisor read/write User read/write",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_cmp_c1
    },
    {
        "C2",
        "Access: Supervisor read/write User read/write",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_cmp_c2
    },
    {
        "C3",
        "Access: Supervisor read/write User read/write",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_cmp_c3
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CRC
#endif

// Bitfields in register CRC_DATA.
static const field_t hw_crc_data[] =
{
    {
        "LL",
        "When CTRL[WAS] is 1, values written to this field are part of the seed"
        " value.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LU",
        "When CTRL[WAS] is 1, values written to this field are part of the seed"
        " value.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HL",
        "In 16-bit CRC mode (CTRL[TCRC] is 0), this field is not used for progr"
        "amming a seed value.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HU",
        "In 16-bit CRC mode (CTRL[TCRC] is 0), this field is not used for progr"
        "amming a seed value.",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CRC_GPOLY.
static const field_t hw_crc_gpoly[] =
{
    {
        "LOW",
        "Writable and readable in both 32-bit and 16-bit CRC modes.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HIGH",
        "Writable and readable in 32-bit CRC mode (CTRL[TCRC] is 1).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CRC_CTRL.
static const field_t hw_crc_ctrl[] =
{
    {
        "TCRC",
        "Width of CRC protocol.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAS",
        "When asserted, a value written to the CRC data register is considered "
        "a seed value.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FXOR",
        "Some CRC protocols require the final checksum to be XORed with 0xFFFFF"
        "FFF or 0xFFFF.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TOTR",
        "Identifies the transpose configuration of the value read from the CRC "
        "Data register.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TOT",
        "Defines the transpose configuration of the data written to the CRC dat"
        "a register.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CRC module.
static const reg_t hw_crc[] =
{
    {
        "DATA",
        "The CRC Data register contains the value of the seed, data, and checks"
        "um.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_crc_data
    },
    {
        "GPOLY",
        "This register contains the value of the polynomial for the CRC calcula"
        "tion.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_crc_gpoly
    },
    {
        "CTRL",
        "This register controls the configuration and working of the CRC module"
        ".",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_crc_ctrl
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DAC
#endif

// Bitfields in register DAC_VERID.
static const field_t hw_dac_verid[] =
{
    {
        "FEATURE",
        "This read-only field returns the feature set number.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "This read-only field returns the minor version number for the module s"
        "pecification.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "This read-only field returns the major version number for the module s"
        "pecification.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DAC_PARAM.
static const field_t hw_dac_param[] =
{
    {
        "FIFOSZ",
        "The number of words in the DAC FIFO is 2^(FIFOSZ+1).",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DAC_DATA.
static const field_t hw_dac_data[] =
{
    {
        "DATA0",
        "",
        0, // LSB
        11, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DAC_CR.
static const field_t hw_dac_cr[] =
{
    {
        "FULLF",
        "This is the FIFO Full status bit.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NEMPTF",
        "This is the FIFO nearly empty flag.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WMF",
        "This field is set if the remaining FIFO data is less than or equal to "
        "the watermark setting.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UDFF",
        "This is the FIFO underflow status flag.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OVFF",
        "This is the FIFO overflow status flag.This flag indicates that more da"
        "ta has been written into FIFO than it can hold.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FULLIE",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EMPTIE",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WTMIE",
        "",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWTRG",
        "Active high.",
        12, // LSB
        12, // MSB
        false, // Readable
        false // Writable
    },
    {
        "TRGSEL",
        "",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DACRFS",
        "",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DACEN",
        "Starts the Programmable Reference Generator operation.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOEN",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWMD",
        "In Swing mode, the FIFO must be set up such that the FIFO is full.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UVIE",
        "",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFORST",
        "Resets the FIFO pointers.",
        21, // LSB
        21, // MSB
        false, // Readable
        false // Writable
    },
    {
        "SWRST",
        "Resets all internal logic and registers, in case of any failure during"
        " the Low-power mode.",
        22, // LSB
        22, // MSB
        false, // Readable
        false // Writable
    },
    {
        "DMAEN",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WML",
        "MAX is the FIFO size.",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DAC_PTR.
static const field_t hw_dac_ptr[] =
{
    {
        "DACWFP",
        "This is the FIFO write pointer.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DACRFP",
        "This is the FIFO read pointer.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DAC_CR2.
static const field_t hw_dac_cr2[] =
{
    {
        "BFEN",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BFMS",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BFHS",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IREF2",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IREF1",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IREF",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DAC_ITRM.
static const field_t hw_dac_itrm[] =
{
    {
        "TRIM",
        "",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a DAC module.
static const reg_t hw_dac[] =
{
    {
        "VERID",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_dac_verid
    },
    {
        "PARAM",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dac_param
    },
    {
        "DATA",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dac_data
    },
    {
        "CR",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_dac_cr
    },
    {
        "PTR",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_dac_ptr
    },
    {
        "CR2",
        "For CR2[6:4] (IREF, IREF1 and IREF2), it is suggested to enable one of"
        " the bits to reduce power.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_dac_cr2
    },
    {
        "ITRM",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dac_itrm
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DCD
#endif

// Bitfields in register DCD_CONTROL.
static const field_t hw_dcd_control[] =
{
    {
        "IACK",
        "Determines whether the interrupt is cleared.",
        0, // LSB
        0, // MSB
        false, // Readable
        false // Writable
    },
    {
        "IF",
        "Determines whether an interrupt is pending.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IE",
        "Enables/disables interrupts to the system.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BC12",
        "BC1.2 compatibility.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "START",
        "Determines whether the charger detection sequence is initiated.",
        24, // LSB
        24, // MSB
        false, // Readable
        false // Writable
    },
    {
        "SR",
        "Determines whether a software reset is performed.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCD_CLOCK.
static const field_t hw_dcd_clock[] =
{
    {
        "CLOCK_UNIT",
        "Specifies the unit of measure for the clock speed.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLOCK_SPEED",
        "The unit of measure is programmed in CLOCK_UNIT.",
        2, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCD_STATUS.
static const field_t hw_dcd_status[] =
{
    {
        "SEQ_RES",
        "Reports how the charger detection is attached.",
        16, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEQ_STAT",
        "Indicates the status of the charger detection sequence.",
        18, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ERR",
        "Indicates whether there is an error in the detection sequence.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TO",
        "Indicates whether the detection sequence has passed the timeout thresh"
        "hold.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ACTIVE",
        "Indicates whether the sequence is running.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCD_SIGNAL_OVERRIDE.
static const field_t hw_dcd_signal_override[] =
{
    {
        "PS",
        "Used to enable specified voltage and current source circuits on the US"
        "B_DP and USB_DM pins.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCD_TIMER0.
static const field_t hw_dcd_timer0[] =
{
    {
        "TUNITCON",
        "Displays the amount of elapsed time since the event of setting the STA"
        "RT bit plus the value of TSEQ_INIT.",
        0, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TSEQ_INIT",
        "TSEQ_INIT represents the system latency (in ms) measured from the time"
        " VBUS goes active to the time system software initiates the charger de"
        "tection sequence in the USBDCD module.",
        16, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCD_TIMER1.
static const field_t hw_dcd_timer1[] =
{
    {
        "TVDPSRC_ON",
        "This timing parameter is used after detection of the data pin.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDCD_DBNC",
        "Sets the time period (ms) to debounce the D+ signal during the data pi"
        "n contact detection phase.",
        16, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCD_TIMER2_BC11.
static const field_t hw_dcd_timer2_bc11[] =
{
    {
        "CHECK_DM",
        "Sets the amount of time (in ms) that the module waits after the device"
        " connects to the USB bus until checking the state of the D- line to de"
        "termine the type of charging port.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TVDPSRC_CON",
        "Sets the time period (ms) that the module waits after charging port de"
        "tection before system software must enable the D+ pullup to connect to"
        " the USB host.",
        16, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCD_TIMER2_BC12.
static const field_t hw_dcd_timer2_bc12[] =
{
    {
        "TVDMSRC_ON",
        "Sets the amount of time (in ms) that the module enables the VDM_SRC.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWAIT_AFTER_PRD",
        "Sets the amount of time (in ms) that the module waits after primary de"
        "tection before start to secondary detection.",
        16, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a DCD module.
static const reg_t hw_dcd[] =
{
    {
        "CONTROL",
        "Contains the control and interrupt bit fields.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_dcd_control
    },
    {
        "CLOCK",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcd_clock
    },
    {
        "STATUS",
        "Provides the current state of the module for system software monitorin"
        "g.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        5, // Number of bitfields
        hw_dcd_status
    },
    {
        "SIGNAL_OVERRIDE",
        "The Signal Override register provides a way for the customer to enable"
        " signaling required by the USB BC v1.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcd_signal_override
    },
    {
        "TIMER0",
        "TIMER0 has an TSEQ_INIT field that represents the system latency in ms"
        ".",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcd_timer0
    },
    {
        "TIMER1",
        "TIMER1 contains timing parameters.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcd_timer1
    },
    {
        "TIMER2_BC11",
        "TIMER2_BC11 contains timing parameters for USB Battery Charging Specif"
        "ication, v1.1.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcd_timer2_bc11
    },
    {
        "TIMER2_BC12",
        "TIMER2_BC12 contains timing parameters for USB Battery Charging Specif"
        "ication, v1.2.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcd_timer2_bc12
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DMA
#endif

// Bitfields in register DMA_CR.
static const field_t hw_dma_cr[] =
{
    {
        "EBWR",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDBG",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERCA",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERGA",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOE",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALT",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLM",
        "Do not use continuous link mode with a channel linking to itself if th"
        "ere is only one minor loop iteration per service request, for example,"
        " if the channel's NBYTES value is the same as either the source or des"
        "tination size.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EMLM",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRP0PRI",
        "Group 0 priority level when fixed priority group arbitration is enable"
        "d.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRP1PRI",
        "Group 1 priority level when fixed priority group arbitration is enable"
        "d.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECX",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CX",
        "",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_ES.
static const field_t hw_dma_es[] =
{
    {
        "DBE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SBE",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SGE",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NCE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DOE",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DAE",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SOE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SAE",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ERRCHN",
        "The channel number of the last recorded error, excluding GPE and CPE e"
        "rrors, or last recorded error canceled transfer.",
        8, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CPE",
        "",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "GPE",
        "",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ECX",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VLD",
        "Logical OR of all ERR status bits",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_ERQ.
static const field_t hw_dma_erq[] =
{
    {
        "ERQ0",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ1",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ2",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ3",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ4",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ5",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ6",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ7",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ8",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ9",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ10",
        "",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ11",
        "",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ12",
        "",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ13",
        "",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ14",
        "",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ15",
        "",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ16",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ17",
        "",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ18",
        "",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ19",
        "",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ20",
        "",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ21",
        "",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ22",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ23",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ24",
        "",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ25",
        "",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ26",
        "",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ27",
        "",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ28",
        "",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ29",
        "",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ30",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERQ31",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_EEI.
static const field_t hw_dma_eei[] =
{
    {
        "EEI0",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI1",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI2",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI3",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI4",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI5",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI6",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI7",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI8",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI9",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI10",
        "",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI11",
        "",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI12",
        "",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI13",
        "",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI14",
        "",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI15",
        "",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI16",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI17",
        "",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI18",
        "",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI19",
        "",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI20",
        "",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI21",
        "",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI22",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI23",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI24",
        "",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI25",
        "",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI26",
        "",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI27",
        "",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI28",
        "",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI29",
        "",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI30",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EEI31",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CEEI.
static const field_t hw_dma_ceei[] =
{
    {
        "CEEI",
        "Clears the corresponding bit in EEI",
        0, // LSB
        4, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CAEE",
        "",
        6, // LSB
        6, // MSB
        false, // Readable
        false // Writable
    },
    {
        "NOP",
        "",
        7, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_SEEI.
static const field_t hw_dma_seei[] =
{
    {
        "SEEI",
        "Sets the corresponding bit in EEI",
        0, // LSB
        4, // MSB
        false, // Readable
        false // Writable
    },
    {
        "SAEE",
        "",
        6, // LSB
        6, // MSB
        false, // Readable
        false // Writable
    },
    {
        "NOP",
        "",
        7, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CERQ.
static const field_t hw_dma_cerq[] =
{
    {
        "CERQ",
        "Clears the corresponding bit in ERQ.",
        0, // LSB
        4, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CAER",
        "",
        6, // LSB
        6, // MSB
        false, // Readable
        false // Writable
    },
    {
        "NOP",
        "",
        7, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_SERQ.
static const field_t hw_dma_serq[] =
{
    {
        "SERQ",
        "Sets the corresponding bit in ERQ.",
        0, // LSB
        4, // MSB
        false, // Readable
        false // Writable
    },
    {
        "SAER",
        "",
        6, // LSB
        6, // MSB
        false, // Readable
        false // Writable
    },
    {
        "NOP",
        "",
        7, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CDNE.
static const field_t hw_dma_cdne[] =
{
    {
        "CDNE",
        "Clears the corresponding bit in TCDn_CSR[DONE]",
        0, // LSB
        4, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CADN",
        "",
        6, // LSB
        6, // MSB
        false, // Readable
        false // Writable
    },
    {
        "NOP",
        "",
        7, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_SSRT.
static const field_t hw_dma_ssrt[] =
{
    {
        "SSRT",
        "Sets the corresponding bit in TCDn_CSR[START]",
        0, // LSB
        4, // MSB
        false, // Readable
        false // Writable
    },
    {
        "SAST",
        "",
        6, // LSB
        6, // MSB
        false, // Readable
        false // Writable
    },
    {
        "NOP",
        "",
        7, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CERR.
static const field_t hw_dma_cerr[] =
{
    {
        "CERR",
        "Clears the corresponding bit in ERR",
        0, // LSB
        4, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CAEI",
        "",
        6, // LSB
        6, // MSB
        false, // Readable
        false // Writable
    },
    {
        "NOP",
        "",
        7, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CINT.
static const field_t hw_dma_cint[] =
{
    {
        "CINT",
        "Clears the corresponding bit in INT",
        0, // LSB
        4, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CAIR",
        "",
        6, // LSB
        6, // MSB
        false, // Readable
        false // Writable
    },
    {
        "NOP",
        "",
        7, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_INT.
static const field_t hw_dma_int[] =
{
    {
        "INT0",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT1",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT2",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT3",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT4",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT5",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT6",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT7",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT8",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT9",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT10",
        "",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT11",
        "",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT12",
        "",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT13",
        "",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT14",
        "",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT15",
        "",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT16",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT17",
        "",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT18",
        "",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT19",
        "",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT20",
        "",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT21",
        "",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT22",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT23",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT24",
        "",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT25",
        "",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT26",
        "",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT27",
        "",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT28",
        "",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT29",
        "",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT30",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT31",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_ERR.
static const field_t hw_dma_err[] =
{
    {
        "ERR0",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR1",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR2",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR3",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR4",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR5",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR6",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR7",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR8",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR9",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR10",
        "",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR11",
        "",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR12",
        "",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR13",
        "",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR14",
        "",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR15",
        "",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR16",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR17",
        "",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR18",
        "",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR19",
        "",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR20",
        "",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR21",
        "",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR22",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR23",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR24",
        "",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR25",
        "",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR26",
        "",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR27",
        "",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR28",
        "",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR29",
        "",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR30",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR31",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_HRS.
static const field_t hw_dma_hrs[] =
{
    {
        "HRS0",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS1",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS2",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS3",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS4",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS5",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS6",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS7",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS8",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS9",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS10",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS11",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS12",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS13",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS14",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS15",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS16",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS17",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS18",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS19",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS20",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS21",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS22",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS23",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS24",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS25",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS26",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS27",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS28",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS29",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS30",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HRS31",
        "The HRS bit for its respective channel remains asserted for the period"
        " when a Hardware Request is Present on the Channel.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_EARS.
static const field_t hw_dma_ears[] =
{
    {
        "EDREQ_0",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_1",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_2",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_3",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_4",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_5",
        "",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_6",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_7",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_8",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_9",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_10",
        "",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_11",
        "",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_12",
        "",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_13",
        "",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_14",
        "",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_15",
        "",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_16",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_17",
        "",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_18",
        "",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_19",
        "",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_20",
        "",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_21",
        "",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_22",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_23",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_24",
        "",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_25",
        "",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_26",
        "",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_27",
        "",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_28",
        "",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_29",
        "",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_30",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EDREQ_31",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI3.
static const field_t hw_dma_dchpri3[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI2.
static const field_t hw_dma_dchpri2[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI1.
static const field_t hw_dma_dchpri1[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI0.
static const field_t hw_dma_dchpri0[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI7.
static const field_t hw_dma_dchpri7[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI6.
static const field_t hw_dma_dchpri6[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI5.
static const field_t hw_dma_dchpri5[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI4.
static const field_t hw_dma_dchpri4[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI11.
static const field_t hw_dma_dchpri11[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI10.
static const field_t hw_dma_dchpri10[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI9.
static const field_t hw_dma_dchpri9[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI8.
static const field_t hw_dma_dchpri8[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI15.
static const field_t hw_dma_dchpri15[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI14.
static const field_t hw_dma_dchpri14[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI13.
static const field_t hw_dma_dchpri13[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI12.
static const field_t hw_dma_dchpri12[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI19.
static const field_t hw_dma_dchpri19[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI18.
static const field_t hw_dma_dchpri18[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI17.
static const field_t hw_dma_dchpri17[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI16.
static const field_t hw_dma_dchpri16[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI23.
static const field_t hw_dma_dchpri23[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI22.
static const field_t hw_dma_dchpri22[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI21.
static const field_t hw_dma_dchpri21[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI20.
static const field_t hw_dma_dchpri20[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI27.
static const field_t hw_dma_dchpri27[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI26.
static const field_t hw_dma_dchpri26[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI25.
static const field_t hw_dma_dchpri25[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI24.
static const field_t hw_dma_dchpri24[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI31.
static const field_t hw_dma_dchpri31[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI30.
static const field_t hw_dma_dchpri30[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI29.
static const field_t hw_dma_dchpri29[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_DCHPRI28.
static const field_t hw_dma_dchpri28[] =
{
    {
        "CHPRI",
        "Channel priority when fixed-priority arbitration is enabled Reset valu"
        "e for the group and channel priority fields, GRPPRI and CHPRI, is equa"
        "l to the corresponding channel number for each priority register, that"
        " is, DCHPRI31[GRPPRI] = 0b01 and DCHPRI31[CHPRI] = 0b01111.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRPPRI",
        "Group priority assigned to this channel group when fixed-priority arbi"
        "tration is enabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DPA",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECP",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_SADDR.
static const field_t hw_dma_tcd0_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_SOFF.
static const field_t hw_dma_tcd0_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_ATTR.
static const field_t hw_dma_tcd0_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_NBYTES_MLNO.
static const field_t hw_dma_tcd0_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd0_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd0_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_SLAST.
static const field_t hw_dma_tcd0_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_DADDR.
static const field_t hw_dma_tcd0_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_CITER_ELINKYES.
static const field_t hw_dma_tcd0_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_CITER_ELINKNO.
static const field_t hw_dma_tcd0_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_DOFF.
static const field_t hw_dma_tcd0_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_DLASTSGA.
static const field_t hw_dma_tcd0_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_BITER_ELINKYES.
static const field_t hw_dma_tcd0_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_BITER_ELINKNO.
static const field_t hw_dma_tcd0_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD0_CSR.
static const field_t hw_dma_tcd0_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_SADDR.
static const field_t hw_dma_tcd1_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_SOFF.
static const field_t hw_dma_tcd1_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_ATTR.
static const field_t hw_dma_tcd1_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_NBYTES_MLNO.
static const field_t hw_dma_tcd1_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd1_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd1_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_SLAST.
static const field_t hw_dma_tcd1_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_DADDR.
static const field_t hw_dma_tcd1_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_CITER_ELINKYES.
static const field_t hw_dma_tcd1_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_CITER_ELINKNO.
static const field_t hw_dma_tcd1_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_DOFF.
static const field_t hw_dma_tcd1_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_DLASTSGA.
static const field_t hw_dma_tcd1_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_BITER_ELINKYES.
static const field_t hw_dma_tcd1_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_BITER_ELINKNO.
static const field_t hw_dma_tcd1_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD1_CSR.
static const field_t hw_dma_tcd1_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_SADDR.
static const field_t hw_dma_tcd2_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_SOFF.
static const field_t hw_dma_tcd2_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_ATTR.
static const field_t hw_dma_tcd2_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_NBYTES_MLNO.
static const field_t hw_dma_tcd2_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd2_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd2_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_SLAST.
static const field_t hw_dma_tcd2_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_DADDR.
static const field_t hw_dma_tcd2_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_CITER_ELINKYES.
static const field_t hw_dma_tcd2_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_CITER_ELINKNO.
static const field_t hw_dma_tcd2_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_DOFF.
static const field_t hw_dma_tcd2_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_DLASTSGA.
static const field_t hw_dma_tcd2_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_BITER_ELINKYES.
static const field_t hw_dma_tcd2_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_BITER_ELINKNO.
static const field_t hw_dma_tcd2_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD2_CSR.
static const field_t hw_dma_tcd2_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_SADDR.
static const field_t hw_dma_tcd3_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_SOFF.
static const field_t hw_dma_tcd3_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_ATTR.
static const field_t hw_dma_tcd3_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_NBYTES_MLNO.
static const field_t hw_dma_tcd3_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd3_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd3_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_SLAST.
static const field_t hw_dma_tcd3_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_DADDR.
static const field_t hw_dma_tcd3_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_CITER_ELINKYES.
static const field_t hw_dma_tcd3_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_CITER_ELINKNO.
static const field_t hw_dma_tcd3_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_DOFF.
static const field_t hw_dma_tcd3_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_DLASTSGA.
static const field_t hw_dma_tcd3_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_BITER_ELINKYES.
static const field_t hw_dma_tcd3_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_BITER_ELINKNO.
static const field_t hw_dma_tcd3_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD3_CSR.
static const field_t hw_dma_tcd3_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_SADDR.
static const field_t hw_dma_tcd4_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_SOFF.
static const field_t hw_dma_tcd4_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_ATTR.
static const field_t hw_dma_tcd4_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_NBYTES_MLNO.
static const field_t hw_dma_tcd4_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd4_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd4_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_SLAST.
static const field_t hw_dma_tcd4_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_DADDR.
static const field_t hw_dma_tcd4_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_CITER_ELINKYES.
static const field_t hw_dma_tcd4_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_CITER_ELINKNO.
static const field_t hw_dma_tcd4_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_DOFF.
static const field_t hw_dma_tcd4_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_DLASTSGA.
static const field_t hw_dma_tcd4_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_BITER_ELINKYES.
static const field_t hw_dma_tcd4_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_BITER_ELINKNO.
static const field_t hw_dma_tcd4_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD4_CSR.
static const field_t hw_dma_tcd4_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_SADDR.
static const field_t hw_dma_tcd5_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_SOFF.
static const field_t hw_dma_tcd5_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_ATTR.
static const field_t hw_dma_tcd5_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_NBYTES_MLNO.
static const field_t hw_dma_tcd5_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd5_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd5_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_SLAST.
static const field_t hw_dma_tcd5_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_DADDR.
static const field_t hw_dma_tcd5_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_CITER_ELINKYES.
static const field_t hw_dma_tcd5_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_CITER_ELINKNO.
static const field_t hw_dma_tcd5_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_DOFF.
static const field_t hw_dma_tcd5_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_DLASTSGA.
static const field_t hw_dma_tcd5_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_BITER_ELINKYES.
static const field_t hw_dma_tcd5_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_BITER_ELINKNO.
static const field_t hw_dma_tcd5_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD5_CSR.
static const field_t hw_dma_tcd5_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_SADDR.
static const field_t hw_dma_tcd6_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_SOFF.
static const field_t hw_dma_tcd6_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_ATTR.
static const field_t hw_dma_tcd6_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_NBYTES_MLNO.
static const field_t hw_dma_tcd6_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd6_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd6_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_SLAST.
static const field_t hw_dma_tcd6_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_DADDR.
static const field_t hw_dma_tcd6_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_CITER_ELINKYES.
static const field_t hw_dma_tcd6_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_CITER_ELINKNO.
static const field_t hw_dma_tcd6_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_DOFF.
static const field_t hw_dma_tcd6_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_DLASTSGA.
static const field_t hw_dma_tcd6_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_BITER_ELINKYES.
static const field_t hw_dma_tcd6_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_BITER_ELINKNO.
static const field_t hw_dma_tcd6_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD6_CSR.
static const field_t hw_dma_tcd6_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_SADDR.
static const field_t hw_dma_tcd7_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_SOFF.
static const field_t hw_dma_tcd7_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_ATTR.
static const field_t hw_dma_tcd7_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_NBYTES_MLNO.
static const field_t hw_dma_tcd7_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd7_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd7_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_SLAST.
static const field_t hw_dma_tcd7_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_DADDR.
static const field_t hw_dma_tcd7_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_CITER_ELINKYES.
static const field_t hw_dma_tcd7_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_CITER_ELINKNO.
static const field_t hw_dma_tcd7_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_DOFF.
static const field_t hw_dma_tcd7_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_DLASTSGA.
static const field_t hw_dma_tcd7_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_BITER_ELINKYES.
static const field_t hw_dma_tcd7_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_BITER_ELINKNO.
static const field_t hw_dma_tcd7_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD7_CSR.
static const field_t hw_dma_tcd7_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_SADDR.
static const field_t hw_dma_tcd8_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_SOFF.
static const field_t hw_dma_tcd8_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_ATTR.
static const field_t hw_dma_tcd8_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_NBYTES_MLNO.
static const field_t hw_dma_tcd8_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd8_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd8_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_SLAST.
static const field_t hw_dma_tcd8_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_DADDR.
static const field_t hw_dma_tcd8_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_CITER_ELINKYES.
static const field_t hw_dma_tcd8_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_CITER_ELINKNO.
static const field_t hw_dma_tcd8_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_DOFF.
static const field_t hw_dma_tcd8_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_DLASTSGA.
static const field_t hw_dma_tcd8_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_BITER_ELINKYES.
static const field_t hw_dma_tcd8_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_BITER_ELINKNO.
static const field_t hw_dma_tcd8_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD8_CSR.
static const field_t hw_dma_tcd8_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_SADDR.
static const field_t hw_dma_tcd9_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_SOFF.
static const field_t hw_dma_tcd9_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_ATTR.
static const field_t hw_dma_tcd9_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_NBYTES_MLNO.
static const field_t hw_dma_tcd9_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd9_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd9_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_SLAST.
static const field_t hw_dma_tcd9_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_DADDR.
static const field_t hw_dma_tcd9_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_CITER_ELINKYES.
static const field_t hw_dma_tcd9_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_CITER_ELINKNO.
static const field_t hw_dma_tcd9_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_DOFF.
static const field_t hw_dma_tcd9_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_DLASTSGA.
static const field_t hw_dma_tcd9_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_BITER_ELINKYES.
static const field_t hw_dma_tcd9_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_BITER_ELINKNO.
static const field_t hw_dma_tcd9_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD9_CSR.
static const field_t hw_dma_tcd9_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_SADDR.
static const field_t hw_dma_tcd10_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_SOFF.
static const field_t hw_dma_tcd10_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_ATTR.
static const field_t hw_dma_tcd10_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_NBYTES_MLNO.
static const field_t hw_dma_tcd10_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd10_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd10_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_SLAST.
static const field_t hw_dma_tcd10_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_DADDR.
static const field_t hw_dma_tcd10_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_CITER_ELINKYES.
static const field_t hw_dma_tcd10_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_CITER_ELINKNO.
static const field_t hw_dma_tcd10_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_DOFF.
static const field_t hw_dma_tcd10_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_DLASTSGA.
static const field_t hw_dma_tcd10_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_BITER_ELINKYES.
static const field_t hw_dma_tcd10_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_BITER_ELINKNO.
static const field_t hw_dma_tcd10_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD10_CSR.
static const field_t hw_dma_tcd10_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_SADDR.
static const field_t hw_dma_tcd11_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_SOFF.
static const field_t hw_dma_tcd11_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_ATTR.
static const field_t hw_dma_tcd11_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_NBYTES_MLNO.
static const field_t hw_dma_tcd11_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd11_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd11_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_SLAST.
static const field_t hw_dma_tcd11_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_DADDR.
static const field_t hw_dma_tcd11_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_CITER_ELINKYES.
static const field_t hw_dma_tcd11_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_CITER_ELINKNO.
static const field_t hw_dma_tcd11_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_DOFF.
static const field_t hw_dma_tcd11_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_DLASTSGA.
static const field_t hw_dma_tcd11_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_BITER_ELINKYES.
static const field_t hw_dma_tcd11_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_BITER_ELINKNO.
static const field_t hw_dma_tcd11_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD11_CSR.
static const field_t hw_dma_tcd11_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_SADDR.
static const field_t hw_dma_tcd12_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_SOFF.
static const field_t hw_dma_tcd12_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_ATTR.
static const field_t hw_dma_tcd12_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_NBYTES_MLNO.
static const field_t hw_dma_tcd12_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd12_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd12_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_SLAST.
static const field_t hw_dma_tcd12_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_DADDR.
static const field_t hw_dma_tcd12_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_CITER_ELINKYES.
static const field_t hw_dma_tcd12_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_CITER_ELINKNO.
static const field_t hw_dma_tcd12_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_DOFF.
static const field_t hw_dma_tcd12_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_DLASTSGA.
static const field_t hw_dma_tcd12_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_BITER_ELINKYES.
static const field_t hw_dma_tcd12_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_BITER_ELINKNO.
static const field_t hw_dma_tcd12_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD12_CSR.
static const field_t hw_dma_tcd12_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_SADDR.
static const field_t hw_dma_tcd13_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_SOFF.
static const field_t hw_dma_tcd13_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_ATTR.
static const field_t hw_dma_tcd13_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_NBYTES_MLNO.
static const field_t hw_dma_tcd13_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd13_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd13_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_SLAST.
static const field_t hw_dma_tcd13_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_DADDR.
static const field_t hw_dma_tcd13_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_CITER_ELINKYES.
static const field_t hw_dma_tcd13_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_CITER_ELINKNO.
static const field_t hw_dma_tcd13_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_DOFF.
static const field_t hw_dma_tcd13_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_DLASTSGA.
static const field_t hw_dma_tcd13_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_BITER_ELINKYES.
static const field_t hw_dma_tcd13_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_BITER_ELINKNO.
static const field_t hw_dma_tcd13_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD13_CSR.
static const field_t hw_dma_tcd13_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_SADDR.
static const field_t hw_dma_tcd14_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_SOFF.
static const field_t hw_dma_tcd14_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_ATTR.
static const field_t hw_dma_tcd14_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_NBYTES_MLNO.
static const field_t hw_dma_tcd14_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd14_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd14_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_SLAST.
static const field_t hw_dma_tcd14_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_DADDR.
static const field_t hw_dma_tcd14_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_CITER_ELINKYES.
static const field_t hw_dma_tcd14_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_CITER_ELINKNO.
static const field_t hw_dma_tcd14_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_DOFF.
static const field_t hw_dma_tcd14_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_DLASTSGA.
static const field_t hw_dma_tcd14_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_BITER_ELINKYES.
static const field_t hw_dma_tcd14_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_BITER_ELINKNO.
static const field_t hw_dma_tcd14_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD14_CSR.
static const field_t hw_dma_tcd14_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_SADDR.
static const field_t hw_dma_tcd15_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_SOFF.
static const field_t hw_dma_tcd15_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_ATTR.
static const field_t hw_dma_tcd15_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_NBYTES_MLNO.
static const field_t hw_dma_tcd15_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd15_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd15_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_SLAST.
static const field_t hw_dma_tcd15_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_DADDR.
static const field_t hw_dma_tcd15_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_CITER_ELINKYES.
static const field_t hw_dma_tcd15_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_CITER_ELINKNO.
static const field_t hw_dma_tcd15_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_DOFF.
static const field_t hw_dma_tcd15_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_DLASTSGA.
static const field_t hw_dma_tcd15_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_BITER_ELINKYES.
static const field_t hw_dma_tcd15_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_BITER_ELINKNO.
static const field_t hw_dma_tcd15_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD15_CSR.
static const field_t hw_dma_tcd15_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_SADDR.
static const field_t hw_dma_tcd16_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_SOFF.
static const field_t hw_dma_tcd16_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_ATTR.
static const field_t hw_dma_tcd16_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_NBYTES_MLNO.
static const field_t hw_dma_tcd16_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd16_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd16_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_SLAST.
static const field_t hw_dma_tcd16_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_DADDR.
static const field_t hw_dma_tcd16_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_CITER_ELINKYES.
static const field_t hw_dma_tcd16_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_CITER_ELINKNO.
static const field_t hw_dma_tcd16_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_DOFF.
static const field_t hw_dma_tcd16_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_DLASTSGA.
static const field_t hw_dma_tcd16_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_BITER_ELINKYES.
static const field_t hw_dma_tcd16_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_BITER_ELINKNO.
static const field_t hw_dma_tcd16_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD16_CSR.
static const field_t hw_dma_tcd16_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_SADDR.
static const field_t hw_dma_tcd17_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_SOFF.
static const field_t hw_dma_tcd17_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_ATTR.
static const field_t hw_dma_tcd17_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_NBYTES_MLNO.
static const field_t hw_dma_tcd17_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd17_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd17_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_SLAST.
static const field_t hw_dma_tcd17_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_DADDR.
static const field_t hw_dma_tcd17_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_CITER_ELINKYES.
static const field_t hw_dma_tcd17_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_CITER_ELINKNO.
static const field_t hw_dma_tcd17_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_DOFF.
static const field_t hw_dma_tcd17_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_DLASTSGA.
static const field_t hw_dma_tcd17_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_BITER_ELINKYES.
static const field_t hw_dma_tcd17_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_BITER_ELINKNO.
static const field_t hw_dma_tcd17_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD17_CSR.
static const field_t hw_dma_tcd17_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_SADDR.
static const field_t hw_dma_tcd18_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_SOFF.
static const field_t hw_dma_tcd18_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_ATTR.
static const field_t hw_dma_tcd18_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_NBYTES_MLNO.
static const field_t hw_dma_tcd18_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd18_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd18_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_SLAST.
static const field_t hw_dma_tcd18_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_DADDR.
static const field_t hw_dma_tcd18_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_CITER_ELINKYES.
static const field_t hw_dma_tcd18_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_CITER_ELINKNO.
static const field_t hw_dma_tcd18_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_DOFF.
static const field_t hw_dma_tcd18_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_DLASTSGA.
static const field_t hw_dma_tcd18_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_BITER_ELINKYES.
static const field_t hw_dma_tcd18_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_BITER_ELINKNO.
static const field_t hw_dma_tcd18_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD18_CSR.
static const field_t hw_dma_tcd18_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_SADDR.
static const field_t hw_dma_tcd19_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_SOFF.
static const field_t hw_dma_tcd19_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_ATTR.
static const field_t hw_dma_tcd19_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_NBYTES_MLNO.
static const field_t hw_dma_tcd19_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd19_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd19_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_SLAST.
static const field_t hw_dma_tcd19_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_DADDR.
static const field_t hw_dma_tcd19_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_CITER_ELINKYES.
static const field_t hw_dma_tcd19_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_CITER_ELINKNO.
static const field_t hw_dma_tcd19_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_DOFF.
static const field_t hw_dma_tcd19_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_DLASTSGA.
static const field_t hw_dma_tcd19_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_BITER_ELINKYES.
static const field_t hw_dma_tcd19_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_BITER_ELINKNO.
static const field_t hw_dma_tcd19_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD19_CSR.
static const field_t hw_dma_tcd19_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_SADDR.
static const field_t hw_dma_tcd20_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_SOFF.
static const field_t hw_dma_tcd20_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_ATTR.
static const field_t hw_dma_tcd20_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_NBYTES_MLNO.
static const field_t hw_dma_tcd20_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd20_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd20_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_SLAST.
static const field_t hw_dma_tcd20_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_DADDR.
static const field_t hw_dma_tcd20_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_CITER_ELINKYES.
static const field_t hw_dma_tcd20_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_CITER_ELINKNO.
static const field_t hw_dma_tcd20_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_DOFF.
static const field_t hw_dma_tcd20_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_DLASTSGA.
static const field_t hw_dma_tcd20_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_BITER_ELINKYES.
static const field_t hw_dma_tcd20_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_BITER_ELINKNO.
static const field_t hw_dma_tcd20_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD20_CSR.
static const field_t hw_dma_tcd20_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_SADDR.
static const field_t hw_dma_tcd21_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_SOFF.
static const field_t hw_dma_tcd21_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_ATTR.
static const field_t hw_dma_tcd21_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_NBYTES_MLNO.
static const field_t hw_dma_tcd21_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd21_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd21_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_SLAST.
static const field_t hw_dma_tcd21_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_DADDR.
static const field_t hw_dma_tcd21_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_CITER_ELINKYES.
static const field_t hw_dma_tcd21_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_CITER_ELINKNO.
static const field_t hw_dma_tcd21_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_DOFF.
static const field_t hw_dma_tcd21_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_DLASTSGA.
static const field_t hw_dma_tcd21_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_BITER_ELINKYES.
static const field_t hw_dma_tcd21_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_BITER_ELINKNO.
static const field_t hw_dma_tcd21_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD21_CSR.
static const field_t hw_dma_tcd21_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_SADDR.
static const field_t hw_dma_tcd22_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_SOFF.
static const field_t hw_dma_tcd22_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_ATTR.
static const field_t hw_dma_tcd22_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_NBYTES_MLNO.
static const field_t hw_dma_tcd22_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd22_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd22_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_SLAST.
static const field_t hw_dma_tcd22_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_DADDR.
static const field_t hw_dma_tcd22_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_CITER_ELINKYES.
static const field_t hw_dma_tcd22_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_CITER_ELINKNO.
static const field_t hw_dma_tcd22_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_DOFF.
static const field_t hw_dma_tcd22_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_DLASTSGA.
static const field_t hw_dma_tcd22_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_BITER_ELINKYES.
static const field_t hw_dma_tcd22_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_BITER_ELINKNO.
static const field_t hw_dma_tcd22_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD22_CSR.
static const field_t hw_dma_tcd22_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_SADDR.
static const field_t hw_dma_tcd23_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_SOFF.
static const field_t hw_dma_tcd23_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_ATTR.
static const field_t hw_dma_tcd23_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_NBYTES_MLNO.
static const field_t hw_dma_tcd23_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd23_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd23_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_SLAST.
static const field_t hw_dma_tcd23_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_DADDR.
static const field_t hw_dma_tcd23_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_CITER_ELINKYES.
static const field_t hw_dma_tcd23_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_CITER_ELINKNO.
static const field_t hw_dma_tcd23_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_DOFF.
static const field_t hw_dma_tcd23_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_DLASTSGA.
static const field_t hw_dma_tcd23_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_BITER_ELINKYES.
static const field_t hw_dma_tcd23_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_BITER_ELINKNO.
static const field_t hw_dma_tcd23_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD23_CSR.
static const field_t hw_dma_tcd23_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_SADDR.
static const field_t hw_dma_tcd24_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_SOFF.
static const field_t hw_dma_tcd24_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_ATTR.
static const field_t hw_dma_tcd24_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_NBYTES_MLNO.
static const field_t hw_dma_tcd24_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd24_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd24_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_SLAST.
static const field_t hw_dma_tcd24_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_DADDR.
static const field_t hw_dma_tcd24_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_CITER_ELINKYES.
static const field_t hw_dma_tcd24_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_CITER_ELINKNO.
static const field_t hw_dma_tcd24_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_DOFF.
static const field_t hw_dma_tcd24_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_DLASTSGA.
static const field_t hw_dma_tcd24_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_BITER_ELINKYES.
static const field_t hw_dma_tcd24_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_BITER_ELINKNO.
static const field_t hw_dma_tcd24_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD24_CSR.
static const field_t hw_dma_tcd24_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_SADDR.
static const field_t hw_dma_tcd25_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_SOFF.
static const field_t hw_dma_tcd25_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_ATTR.
static const field_t hw_dma_tcd25_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_NBYTES_MLNO.
static const field_t hw_dma_tcd25_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd25_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd25_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_SLAST.
static const field_t hw_dma_tcd25_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_DADDR.
static const field_t hw_dma_tcd25_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_CITER_ELINKYES.
static const field_t hw_dma_tcd25_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_CITER_ELINKNO.
static const field_t hw_dma_tcd25_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_DOFF.
static const field_t hw_dma_tcd25_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_DLASTSGA.
static const field_t hw_dma_tcd25_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_BITER_ELINKYES.
static const field_t hw_dma_tcd25_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_BITER_ELINKNO.
static const field_t hw_dma_tcd25_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD25_CSR.
static const field_t hw_dma_tcd25_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_SADDR.
static const field_t hw_dma_tcd26_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_SOFF.
static const field_t hw_dma_tcd26_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_ATTR.
static const field_t hw_dma_tcd26_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_NBYTES_MLNO.
static const field_t hw_dma_tcd26_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd26_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd26_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_SLAST.
static const field_t hw_dma_tcd26_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_DADDR.
static const field_t hw_dma_tcd26_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_CITER_ELINKYES.
static const field_t hw_dma_tcd26_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_CITER_ELINKNO.
static const field_t hw_dma_tcd26_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_DOFF.
static const field_t hw_dma_tcd26_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_DLASTSGA.
static const field_t hw_dma_tcd26_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_BITER_ELINKYES.
static const field_t hw_dma_tcd26_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_BITER_ELINKNO.
static const field_t hw_dma_tcd26_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD26_CSR.
static const field_t hw_dma_tcd26_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_SADDR.
static const field_t hw_dma_tcd27_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_SOFF.
static const field_t hw_dma_tcd27_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_ATTR.
static const field_t hw_dma_tcd27_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_NBYTES_MLNO.
static const field_t hw_dma_tcd27_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd27_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd27_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_SLAST.
static const field_t hw_dma_tcd27_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_DADDR.
static const field_t hw_dma_tcd27_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_CITER_ELINKYES.
static const field_t hw_dma_tcd27_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_CITER_ELINKNO.
static const field_t hw_dma_tcd27_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_DOFF.
static const field_t hw_dma_tcd27_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_DLASTSGA.
static const field_t hw_dma_tcd27_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_BITER_ELINKYES.
static const field_t hw_dma_tcd27_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_BITER_ELINKNO.
static const field_t hw_dma_tcd27_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD27_CSR.
static const field_t hw_dma_tcd27_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_SADDR.
static const field_t hw_dma_tcd28_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_SOFF.
static const field_t hw_dma_tcd28_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_ATTR.
static const field_t hw_dma_tcd28_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_NBYTES_MLNO.
static const field_t hw_dma_tcd28_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd28_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd28_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_SLAST.
static const field_t hw_dma_tcd28_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_DADDR.
static const field_t hw_dma_tcd28_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_CITER_ELINKYES.
static const field_t hw_dma_tcd28_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_CITER_ELINKNO.
static const field_t hw_dma_tcd28_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_DOFF.
static const field_t hw_dma_tcd28_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_DLASTSGA.
static const field_t hw_dma_tcd28_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_BITER_ELINKYES.
static const field_t hw_dma_tcd28_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_BITER_ELINKNO.
static const field_t hw_dma_tcd28_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD28_CSR.
static const field_t hw_dma_tcd28_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_SADDR.
static const field_t hw_dma_tcd29_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_SOFF.
static const field_t hw_dma_tcd29_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_ATTR.
static const field_t hw_dma_tcd29_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_NBYTES_MLNO.
static const field_t hw_dma_tcd29_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd29_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd29_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_SLAST.
static const field_t hw_dma_tcd29_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_DADDR.
static const field_t hw_dma_tcd29_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_CITER_ELINKYES.
static const field_t hw_dma_tcd29_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_CITER_ELINKNO.
static const field_t hw_dma_tcd29_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_DOFF.
static const field_t hw_dma_tcd29_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_DLASTSGA.
static const field_t hw_dma_tcd29_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_BITER_ELINKYES.
static const field_t hw_dma_tcd29_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_BITER_ELINKNO.
static const field_t hw_dma_tcd29_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD29_CSR.
static const field_t hw_dma_tcd29_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_SADDR.
static const field_t hw_dma_tcd30_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_SOFF.
static const field_t hw_dma_tcd30_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_ATTR.
static const field_t hw_dma_tcd30_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_NBYTES_MLNO.
static const field_t hw_dma_tcd30_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd30_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd30_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_SLAST.
static const field_t hw_dma_tcd30_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_DADDR.
static const field_t hw_dma_tcd30_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_CITER_ELINKYES.
static const field_t hw_dma_tcd30_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_CITER_ELINKNO.
static const field_t hw_dma_tcd30_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_DOFF.
static const field_t hw_dma_tcd30_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_DLASTSGA.
static const field_t hw_dma_tcd30_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_BITER_ELINKYES.
static const field_t hw_dma_tcd30_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_BITER_ELINKNO.
static const field_t hw_dma_tcd30_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD30_CSR.
static const field_t hw_dma_tcd30_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_SADDR.
static const field_t hw_dma_tcd31_saddr[] =
{
    {
        "SADDR",
        "Memory address pointing to the source data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_SOFF.
static const field_t hw_dma_tcd31_soff[] =
{
    {
        "SOFF",
        "Sign-extended offset applied to the current source address to form the"
        " next-state value as each source read is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_ATTR.
static const field_t hw_dma_tcd31_attr[] =
{
    {
        "DSIZE",
        "See the SSIZE definition",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMOD",
        "See the SMOD definition",
        3, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSIZE",
        "Using a Reserved value causes a configuration error.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMOD",
        "",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_NBYTES_MLNO.
static const field_t hw_dma_tcd31_nbytes_mlno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_NBYTES_MLOFFNO.
static const field_t hw_dma_tcd31_nbytes_mloffno[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_NBYTES_MLOFFYES.
static const field_t hw_dma_tcd31_nbytes_mloffyes[] =
{
    {
        "NBYTES",
        "Number of bytes to be transferred in each service request of the chann"
        "el.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLOFF",
        "",
        10, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMLOE",
        "Selects whether the minor loop offset is applied to the destination ad"
        "dress upon minor loop completion.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMLOE",
        "Selects whether the minor loop offset is applied to the source address"
        " upon minor loop completion.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_SLAST.
static const field_t hw_dma_tcd31_slast[] =
{
    {
        "SLAST",
        "Adjustment value added to the source address at the completion of the "
        "major iteration count.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_DADDR.
static const field_t hw_dma_tcd31_daddr[] =
{
    {
        "DADDR",
        "Memory address pointing to the destination data.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_CITER_ELINKYES.
static const field_t hw_dma_tcd31_citer_elinkyes[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest to the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_CITER_ELINKNO.
static const field_t hw_dma_tcd31_citer_elinkno[] =
{
    {
        "CITER",
        "This field is the current major loop count for the channel.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables linking to "
        "another channel, defined by the LINKCH field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_DOFF.
static const field_t hw_dma_tcd31_doff[] =
{
    {
        "DOFF",
        "Sign-extended offset applied to the current destination address to for"
        "m the next-state value as each destination write is completed.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_DLASTSGA.
static const field_t hw_dma_tcd31_dlastsga[] =
{
    {
        "DLASTSGA",
        "Destination last address adjustment or the memory address for the next"
        " transfer control descriptor to be loaded into this channel (scatter/g"
        "ather).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_BITER_ELINKYES.
static const field_t hw_dma_tcd31_biter_elinkyes[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINKCH",
        "If channel-to-channel linking is enabled (ELINK = 1), then after the m"
        "inor loop is exhausted, the eDMA engine initiates a channel service re"
        "quest at the channel defined by this field by setting that channel's T"
        "CDn_CSR[START] bit.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_BITER_ELINKNO.
static const field_t hw_dma_tcd31_biter_elinkno[] =
{
    {
        "BITER",
        "As the transfer control descriptor is first loaded by software, this 9"
        "-bit (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the valu"
        "e in the CITER field.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ELINK",
        "As the channel completes the minor loop, this flag enables the linking"
        " to another channel, defined by BITER[LINKCH].",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_TCD31_CSR.
static const field_t hw_dma_tcd31_csr[] =
{
    {
        "START",
        "If this flag is set, the channel is requesting service.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMAJOR",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT when the current major iteration c"
        "ount reaches zero.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTHALF",
        "If this flag is set, the channel generates an interrupt request by set"
        "ting the appropriate bit in the INT register when the current major it"
        "eration count reaches the halfway point.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DREQ",
        "If this flag is set, the eDMA hardware automatically clears the corres"
        "ponding ERQ bit when the current major iteration count reaches zero.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESG",
        "As the channel completes the major loop, this flag enables scatter/gat"
        "her processing in the current channel.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORELINK",
        "As the channel completes the major loop, this flag enables the linking"
        " to another channel, defined by MAJORLINKCH.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACTIVE",
        "This flag signals the channel is currently in execution.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE",
        "This flag indicates the eDMA has completed the major loop.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAJORLINKCH",
        "If (MAJORELINK = 0) then: No channel-to-channel linking, or chaining, "
        "is performed after the major loop counter is exhausted.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWC",
        "Throttles the amount of bus bandwidth consumed by the eDMA.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a DMA module.
static const reg_t hw_dma[] =
{
    {
        "CR",
        "The CR defines the basic operating configuration of the DMA.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_dma_cr
    },
    {
        "ES",
        "The ES provides information concerning the last recorded channel error"
        ".",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        13, // Number of bitfields
        hw_dma_es
    },
    {
        "ERQ",
        "The ERQ register provides a bit map for the 32 channels to enable the "
        "request signal for each channel.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_dma_erq
    },
    {
        "EEI",
        "The EEI register provides a bit map for the 32 channels to enable the "
        "error interrupt signal for each channel.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_dma_eei
    },
    {
        "CEEI",
        "The CEEI provides a simple memory-mapped mechanism to clear a given bi"
        "t in the EEI to disable the error interrupt for a given channel.",
        1, // Width in bytes
        0x00000018, // Base address offset
        false, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_ceei
    },
    {
        "SEEI",
        "The SEEI provides a simple memory-mapped mechanism to set a given bit "
        "in the EEI to enable the error interrupt for a given channel.",
        1, // Width in bytes
        0x00000019, // Base address offset
        false, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_seei
    },
    {
        "CERQ",
        "The CERQ provides a simple memory-mapped mechanism to clear a given bi"
        "t in the ERQ to disable the DMA request for a given channel.",
        1, // Width in bytes
        0x0000001a, // Base address offset
        false, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_cerq
    },
    {
        "SERQ",
        "The SERQ provides a simple memory-mapped mechanism to set a given bit "
        "in the ERQ to enable the DMA request for a given channel.",
        1, // Width in bytes
        0x0000001b, // Base address offset
        false, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_serq
    },
    {
        "CDNE",
        "The CDNE provides a simple memory-mapped mechanism to clear the DONE b"
        "it in the TCD of the given channel.",
        1, // Width in bytes
        0x0000001c, // Base address offset
        false, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_cdne
    },
    {
        "SSRT",
        "The SSRT provides a simple memory-mapped mechanism to set the START bi"
        "t in the TCD of the given channel.",
        1, // Width in bytes
        0x0000001d, // Base address offset
        false, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_ssrt
    },
    {
        "CERR",
        "The CERR provides a simple memory-mapped mechanism to clear a given bi"
        "t in the ERR to disable the error condition flag for a given channel.",
        1, // Width in bytes
        0x0000001e, // Base address offset
        false, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_cerr
    },
    {
        "CINT",
        "The CINT provides a simple, memory-mapped mechanism to clear a given b"
        "it in the INT to disable the interrupt request for a given channel.",
        1, // Width in bytes
        0x0000001f, // Base address offset
        false, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_cint
    },
    {
        "INT",
        "The INT register provides a bit map for the 32 channels signaling the "
        "presence of an interrupt request for each channel.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_dma_int
    },
    {
        "ERR",
        "The ERR register provides a bit map for the 32 channels, signaling the"
        " presence of an error for each channel.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_dma_err
    },
    {
        "HRS",
        "The HRS register provides a bit map for the DMA channels, signaling th"
        "e presence of a hardware request for each channel.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        false, // Writable
        32, // Number of bitfields
        hw_dma_hrs
    },
    {
        "EARS",
        "The EARS register is used to enable or disable the DMA requests in by "
        "AND'ing the bits of these two registers.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_dma_ears
    },
    {
        "DCHPRI3",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri3
    },
    {
        "DCHPRI2",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000101, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri2
    },
    {
        "DCHPRI1",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000102, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri1
    },
    {
        "DCHPRI0",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000103, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri0
    },
    {
        "DCHPRI7",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri7
    },
    {
        "DCHPRI6",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000105, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri6
    },
    {
        "DCHPRI5",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000106, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri5
    },
    {
        "DCHPRI4",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000107, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri4
    },
    {
        "DCHPRI11",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri11
    },
    {
        "DCHPRI10",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000109, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri10
    },
    {
        "DCHPRI9",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000010a, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri9
    },
    {
        "DCHPRI8",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000010b, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri8
    },
    {
        "DCHPRI15",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000010c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri15
    },
    {
        "DCHPRI14",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000010d, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri14
    },
    {
        "DCHPRI13",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000010e, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri13
    },
    {
        "DCHPRI12",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000010f, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri12
    },
    {
        "DCHPRI19",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri19
    },
    {
        "DCHPRI18",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000111, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri18
    },
    {
        "DCHPRI17",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000112, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri17
    },
    {
        "DCHPRI16",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000113, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri16
    },
    {
        "DCHPRI23",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000114, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri23
    },
    {
        "DCHPRI22",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000115, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri22
    },
    {
        "DCHPRI21",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000116, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri21
    },
    {
        "DCHPRI20",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000117, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri20
    },
    {
        "DCHPRI27",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri27
    },
    {
        "DCHPRI26",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x00000119, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri26
    },
    {
        "DCHPRI25",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000011a, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri25
    },
    {
        "DCHPRI24",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000011b, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri24
    },
    {
        "DCHPRI31",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri31
    },
    {
        "DCHPRI30",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000011d, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri30
    },
    {
        "DCHPRI29",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000011e, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri29
    },
    {
        "DCHPRI28",
        "When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the"
        " contents of these registers define the unique priorities associated w"
        "ith each channel within a group.",
        1, // Width in bytes
        0x0000011f, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_dchpri28
    },
    {
        "TCD0_SADDR",
        "",
        4, // Width in bytes
        0x00001000, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd0_saddr
    },
    {
        "TCD0_SOFF",
        "",
        2, // Width in bytes
        0x00001004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd0_soff
    },
    {
        "TCD0_ATTR",
        "",
        2, // Width in bytes
        0x00001006, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd0_attr
    },
    {
        "TCD0_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd0_nbytes_mlno
    },
    {
        "TCD0_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001008, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd0_nbytes_mloffno
    },
    {
        "TCD0_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001008, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd0_nbytes_mloffyes
    },
    {
        "TCD0_SLAST",
        "",
        4, // Width in bytes
        0x0000100c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd0_slast
    },
    {
        "TCD0_DADDR",
        "",
        4, // Width in bytes
        0x00001010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd0_daddr
    },
    {
        "TCD0_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001016, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd0_citer_elinkyes
    },
    {
        "TCD0_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001016, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd0_citer_elinkno
    },
    {
        "TCD0_DOFF",
        "",
        2, // Width in bytes
        0x00001014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd0_doff
    },
    {
        "TCD0_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd0_dlastsga
    },
    {
        "TCD0_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000101e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd0_biter_elinkyes
    },
    {
        "TCD0_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000101e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd0_biter_elinkno
    },
    {
        "TCD0_CSR",
        "",
        2, // Width in bytes
        0x0000101c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd0_csr
    },
    {
        "TCD1_SADDR",
        "",
        4, // Width in bytes
        0x00001020, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd1_saddr
    },
    {
        "TCD1_SOFF",
        "",
        2, // Width in bytes
        0x00001024, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd1_soff
    },
    {
        "TCD1_ATTR",
        "",
        2, // Width in bytes
        0x00001026, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd1_attr
    },
    {
        "TCD1_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd1_nbytes_mlno
    },
    {
        "TCD1_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001028, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd1_nbytes_mloffno
    },
    {
        "TCD1_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001028, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd1_nbytes_mloffyes
    },
    {
        "TCD1_SLAST",
        "",
        4, // Width in bytes
        0x0000102c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd1_slast
    },
    {
        "TCD1_DADDR",
        "",
        4, // Width in bytes
        0x00001030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd1_daddr
    },
    {
        "TCD1_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001036, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd1_citer_elinkyes
    },
    {
        "TCD1_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001036, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd1_citer_elinkno
    },
    {
        "TCD1_DOFF",
        "",
        2, // Width in bytes
        0x00001034, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd1_doff
    },
    {
        "TCD1_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001038, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd1_dlastsga
    },
    {
        "TCD1_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000103e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd1_biter_elinkyes
    },
    {
        "TCD1_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000103e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd1_biter_elinkno
    },
    {
        "TCD1_CSR",
        "",
        2, // Width in bytes
        0x0000103c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd1_csr
    },
    {
        "TCD2_SADDR",
        "",
        4, // Width in bytes
        0x00001040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd2_saddr
    },
    {
        "TCD2_SOFF",
        "",
        2, // Width in bytes
        0x00001044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd2_soff
    },
    {
        "TCD2_ATTR",
        "",
        2, // Width in bytes
        0x00001046, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd2_attr
    },
    {
        "TCD2_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001048, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd2_nbytes_mlno
    },
    {
        "TCD2_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001048, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd2_nbytes_mloffno
    },
    {
        "TCD2_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001048, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd2_nbytes_mloffyes
    },
    {
        "TCD2_SLAST",
        "",
        4, // Width in bytes
        0x0000104c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd2_slast
    },
    {
        "TCD2_DADDR",
        "",
        4, // Width in bytes
        0x00001050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd2_daddr
    },
    {
        "TCD2_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001056, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd2_citer_elinkyes
    },
    {
        "TCD2_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001056, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd2_citer_elinkno
    },
    {
        "TCD2_DOFF",
        "",
        2, // Width in bytes
        0x00001054, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd2_doff
    },
    {
        "TCD2_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001058, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd2_dlastsga
    },
    {
        "TCD2_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000105e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd2_biter_elinkyes
    },
    {
        "TCD2_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000105e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd2_biter_elinkno
    },
    {
        "TCD2_CSR",
        "",
        2, // Width in bytes
        0x0000105c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd2_csr
    },
    {
        "TCD3_SADDR",
        "",
        4, // Width in bytes
        0x00001060, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd3_saddr
    },
    {
        "TCD3_SOFF",
        "",
        2, // Width in bytes
        0x00001064, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd3_soff
    },
    {
        "TCD3_ATTR",
        "",
        2, // Width in bytes
        0x00001066, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd3_attr
    },
    {
        "TCD3_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001068, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd3_nbytes_mlno
    },
    {
        "TCD3_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001068, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd3_nbytes_mloffno
    },
    {
        "TCD3_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001068, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd3_nbytes_mloffyes
    },
    {
        "TCD3_SLAST",
        "",
        4, // Width in bytes
        0x0000106c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd3_slast
    },
    {
        "TCD3_DADDR",
        "",
        4, // Width in bytes
        0x00001070, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd3_daddr
    },
    {
        "TCD3_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001076, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd3_citer_elinkyes
    },
    {
        "TCD3_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001076, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd3_citer_elinkno
    },
    {
        "TCD3_DOFF",
        "",
        2, // Width in bytes
        0x00001074, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd3_doff
    },
    {
        "TCD3_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001078, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd3_dlastsga
    },
    {
        "TCD3_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000107e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd3_biter_elinkyes
    },
    {
        "TCD3_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000107e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd3_biter_elinkno
    },
    {
        "TCD3_CSR",
        "",
        2, // Width in bytes
        0x0000107c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd3_csr
    },
    {
        "TCD4_SADDR",
        "",
        4, // Width in bytes
        0x00001080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd4_saddr
    },
    {
        "TCD4_SOFF",
        "",
        2, // Width in bytes
        0x00001084, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd4_soff
    },
    {
        "TCD4_ATTR",
        "",
        2, // Width in bytes
        0x00001086, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd4_attr
    },
    {
        "TCD4_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001088, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd4_nbytes_mlno
    },
    {
        "TCD4_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001088, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd4_nbytes_mloffno
    },
    {
        "TCD4_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001088, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd4_nbytes_mloffyes
    },
    {
        "TCD4_SLAST",
        "",
        4, // Width in bytes
        0x0000108c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd4_slast
    },
    {
        "TCD4_DADDR",
        "",
        4, // Width in bytes
        0x00001090, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd4_daddr
    },
    {
        "TCD4_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001096, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd4_citer_elinkyes
    },
    {
        "TCD4_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001096, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd4_citer_elinkno
    },
    {
        "TCD4_DOFF",
        "",
        2, // Width in bytes
        0x00001094, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd4_doff
    },
    {
        "TCD4_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001098, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd4_dlastsga
    },
    {
        "TCD4_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000109e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd4_biter_elinkyes
    },
    {
        "TCD4_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000109e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd4_biter_elinkno
    },
    {
        "TCD4_CSR",
        "",
        2, // Width in bytes
        0x0000109c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd4_csr
    },
    {
        "TCD5_SADDR",
        "",
        4, // Width in bytes
        0x000010a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd5_saddr
    },
    {
        "TCD5_SOFF",
        "",
        2, // Width in bytes
        0x000010a4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd5_soff
    },
    {
        "TCD5_ATTR",
        "",
        2, // Width in bytes
        0x000010a6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd5_attr
    },
    {
        "TCD5_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000010a8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd5_nbytes_mlno
    },
    {
        "TCD5_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000010a8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd5_nbytes_mloffno
    },
    {
        "TCD5_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000010a8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd5_nbytes_mloffyes
    },
    {
        "TCD5_SLAST",
        "",
        4, // Width in bytes
        0x000010ac, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd5_slast
    },
    {
        "TCD5_DADDR",
        "",
        4, // Width in bytes
        0x000010b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd5_daddr
    },
    {
        "TCD5_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000010b6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd5_citer_elinkyes
    },
    {
        "TCD5_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000010b6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd5_citer_elinkno
    },
    {
        "TCD5_DOFF",
        "",
        2, // Width in bytes
        0x000010b4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd5_doff
    },
    {
        "TCD5_DLASTSGA",
        "",
        4, // Width in bytes
        0x000010b8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd5_dlastsga
    },
    {
        "TCD5_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000010be, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd5_biter_elinkyes
    },
    {
        "TCD5_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000010be, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd5_biter_elinkno
    },
    {
        "TCD5_CSR",
        "",
        2, // Width in bytes
        0x000010bc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd5_csr
    },
    {
        "TCD6_SADDR",
        "",
        4, // Width in bytes
        0x000010c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd6_saddr
    },
    {
        "TCD6_SOFF",
        "",
        2, // Width in bytes
        0x000010c4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd6_soff
    },
    {
        "TCD6_ATTR",
        "",
        2, // Width in bytes
        0x000010c6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd6_attr
    },
    {
        "TCD6_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000010c8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd6_nbytes_mlno
    },
    {
        "TCD6_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000010c8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd6_nbytes_mloffno
    },
    {
        "TCD6_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000010c8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd6_nbytes_mloffyes
    },
    {
        "TCD6_SLAST",
        "",
        4, // Width in bytes
        0x000010cc, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd6_slast
    },
    {
        "TCD6_DADDR",
        "",
        4, // Width in bytes
        0x000010d0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd6_daddr
    },
    {
        "TCD6_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000010d6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd6_citer_elinkyes
    },
    {
        "TCD6_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000010d6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd6_citer_elinkno
    },
    {
        "TCD6_DOFF",
        "",
        2, // Width in bytes
        0x000010d4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd6_doff
    },
    {
        "TCD6_DLASTSGA",
        "",
        4, // Width in bytes
        0x000010d8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd6_dlastsga
    },
    {
        "TCD6_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000010de, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd6_biter_elinkyes
    },
    {
        "TCD6_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000010de, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd6_biter_elinkno
    },
    {
        "TCD6_CSR",
        "",
        2, // Width in bytes
        0x000010dc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd6_csr
    },
    {
        "TCD7_SADDR",
        "",
        4, // Width in bytes
        0x000010e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd7_saddr
    },
    {
        "TCD7_SOFF",
        "",
        2, // Width in bytes
        0x000010e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd7_soff
    },
    {
        "TCD7_ATTR",
        "",
        2, // Width in bytes
        0x000010e6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd7_attr
    },
    {
        "TCD7_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000010e8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd7_nbytes_mlno
    },
    {
        "TCD7_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000010e8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd7_nbytes_mloffno
    },
    {
        "TCD7_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000010e8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd7_nbytes_mloffyes
    },
    {
        "TCD7_SLAST",
        "",
        4, // Width in bytes
        0x000010ec, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd7_slast
    },
    {
        "TCD7_DADDR",
        "",
        4, // Width in bytes
        0x000010f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd7_daddr
    },
    {
        "TCD7_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000010f6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd7_citer_elinkyes
    },
    {
        "TCD7_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000010f6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd7_citer_elinkno
    },
    {
        "TCD7_DOFF",
        "",
        2, // Width in bytes
        0x000010f4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd7_doff
    },
    {
        "TCD7_DLASTSGA",
        "",
        4, // Width in bytes
        0x000010f8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd7_dlastsga
    },
    {
        "TCD7_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000010fe, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd7_biter_elinkyes
    },
    {
        "TCD7_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000010fe, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd7_biter_elinkno
    },
    {
        "TCD7_CSR",
        "",
        2, // Width in bytes
        0x000010fc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd7_csr
    },
    {
        "TCD8_SADDR",
        "",
        4, // Width in bytes
        0x00001100, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd8_saddr
    },
    {
        "TCD8_SOFF",
        "",
        2, // Width in bytes
        0x00001104, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd8_soff
    },
    {
        "TCD8_ATTR",
        "",
        2, // Width in bytes
        0x00001106, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd8_attr
    },
    {
        "TCD8_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001108, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd8_nbytes_mlno
    },
    {
        "TCD8_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001108, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd8_nbytes_mloffno
    },
    {
        "TCD8_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001108, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd8_nbytes_mloffyes
    },
    {
        "TCD8_SLAST",
        "",
        4, // Width in bytes
        0x0000110c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd8_slast
    },
    {
        "TCD8_DADDR",
        "",
        4, // Width in bytes
        0x00001110, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd8_daddr
    },
    {
        "TCD8_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001116, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd8_citer_elinkyes
    },
    {
        "TCD8_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001116, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd8_citer_elinkno
    },
    {
        "TCD8_DOFF",
        "",
        2, // Width in bytes
        0x00001114, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd8_doff
    },
    {
        "TCD8_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001118, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd8_dlastsga
    },
    {
        "TCD8_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000111e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd8_biter_elinkyes
    },
    {
        "TCD8_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000111e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd8_biter_elinkno
    },
    {
        "TCD8_CSR",
        "",
        2, // Width in bytes
        0x0000111c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd8_csr
    },
    {
        "TCD9_SADDR",
        "",
        4, // Width in bytes
        0x00001120, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd9_saddr
    },
    {
        "TCD9_SOFF",
        "",
        2, // Width in bytes
        0x00001124, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd9_soff
    },
    {
        "TCD9_ATTR",
        "",
        2, // Width in bytes
        0x00001126, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd9_attr
    },
    {
        "TCD9_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001128, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd9_nbytes_mlno
    },
    {
        "TCD9_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001128, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd9_nbytes_mloffno
    },
    {
        "TCD9_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001128, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd9_nbytes_mloffyes
    },
    {
        "TCD9_SLAST",
        "",
        4, // Width in bytes
        0x0000112c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd9_slast
    },
    {
        "TCD9_DADDR",
        "",
        4, // Width in bytes
        0x00001130, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd9_daddr
    },
    {
        "TCD9_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001136, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd9_citer_elinkyes
    },
    {
        "TCD9_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001136, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd9_citer_elinkno
    },
    {
        "TCD9_DOFF",
        "",
        2, // Width in bytes
        0x00001134, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd9_doff
    },
    {
        "TCD9_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001138, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd9_dlastsga
    },
    {
        "TCD9_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000113e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd9_biter_elinkyes
    },
    {
        "TCD9_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000113e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd9_biter_elinkno
    },
    {
        "TCD9_CSR",
        "",
        2, // Width in bytes
        0x0000113c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd9_csr
    },
    {
        "TCD10_SADDR",
        "",
        4, // Width in bytes
        0x00001140, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd10_saddr
    },
    {
        "TCD10_SOFF",
        "",
        2, // Width in bytes
        0x00001144, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd10_soff
    },
    {
        "TCD10_ATTR",
        "",
        2, // Width in bytes
        0x00001146, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd10_attr
    },
    {
        "TCD10_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001148, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd10_nbytes_mlno
    },
    {
        "TCD10_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001148, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd10_nbytes_mloffno
    },
    {
        "TCD10_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001148, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd10_nbytes_mloffyes
    },
    {
        "TCD10_SLAST",
        "",
        4, // Width in bytes
        0x0000114c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd10_slast
    },
    {
        "TCD10_DADDR",
        "",
        4, // Width in bytes
        0x00001150, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd10_daddr
    },
    {
        "TCD10_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001156, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd10_citer_elinkyes
    },
    {
        "TCD10_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001156, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd10_citer_elinkno
    },
    {
        "TCD10_DOFF",
        "",
        2, // Width in bytes
        0x00001154, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd10_doff
    },
    {
        "TCD10_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001158, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd10_dlastsga
    },
    {
        "TCD10_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000115e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd10_biter_elinkyes
    },
    {
        "TCD10_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000115e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd10_biter_elinkno
    },
    {
        "TCD10_CSR",
        "",
        2, // Width in bytes
        0x0000115c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd10_csr
    },
    {
        "TCD11_SADDR",
        "",
        4, // Width in bytes
        0x00001160, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd11_saddr
    },
    {
        "TCD11_SOFF",
        "",
        2, // Width in bytes
        0x00001164, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd11_soff
    },
    {
        "TCD11_ATTR",
        "",
        2, // Width in bytes
        0x00001166, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd11_attr
    },
    {
        "TCD11_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001168, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd11_nbytes_mlno
    },
    {
        "TCD11_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001168, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd11_nbytes_mloffno
    },
    {
        "TCD11_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001168, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd11_nbytes_mloffyes
    },
    {
        "TCD11_SLAST",
        "",
        4, // Width in bytes
        0x0000116c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd11_slast
    },
    {
        "TCD11_DADDR",
        "",
        4, // Width in bytes
        0x00001170, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd11_daddr
    },
    {
        "TCD11_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001176, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd11_citer_elinkyes
    },
    {
        "TCD11_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001176, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd11_citer_elinkno
    },
    {
        "TCD11_DOFF",
        "",
        2, // Width in bytes
        0x00001174, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd11_doff
    },
    {
        "TCD11_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001178, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd11_dlastsga
    },
    {
        "TCD11_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000117e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd11_biter_elinkyes
    },
    {
        "TCD11_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000117e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd11_biter_elinkno
    },
    {
        "TCD11_CSR",
        "",
        2, // Width in bytes
        0x0000117c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd11_csr
    },
    {
        "TCD12_SADDR",
        "",
        4, // Width in bytes
        0x00001180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd12_saddr
    },
    {
        "TCD12_SOFF",
        "",
        2, // Width in bytes
        0x00001184, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd12_soff
    },
    {
        "TCD12_ATTR",
        "",
        2, // Width in bytes
        0x00001186, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd12_attr
    },
    {
        "TCD12_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001188, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd12_nbytes_mlno
    },
    {
        "TCD12_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001188, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd12_nbytes_mloffno
    },
    {
        "TCD12_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001188, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd12_nbytes_mloffyes
    },
    {
        "TCD12_SLAST",
        "",
        4, // Width in bytes
        0x0000118c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd12_slast
    },
    {
        "TCD12_DADDR",
        "",
        4, // Width in bytes
        0x00001190, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd12_daddr
    },
    {
        "TCD12_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001196, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd12_citer_elinkyes
    },
    {
        "TCD12_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001196, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd12_citer_elinkno
    },
    {
        "TCD12_DOFF",
        "",
        2, // Width in bytes
        0x00001194, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd12_doff
    },
    {
        "TCD12_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001198, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd12_dlastsga
    },
    {
        "TCD12_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000119e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd12_biter_elinkyes
    },
    {
        "TCD12_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000119e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd12_biter_elinkno
    },
    {
        "TCD12_CSR",
        "",
        2, // Width in bytes
        0x0000119c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd12_csr
    },
    {
        "TCD13_SADDR",
        "",
        4, // Width in bytes
        0x000011a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd13_saddr
    },
    {
        "TCD13_SOFF",
        "",
        2, // Width in bytes
        0x000011a4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd13_soff
    },
    {
        "TCD13_ATTR",
        "",
        2, // Width in bytes
        0x000011a6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd13_attr
    },
    {
        "TCD13_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000011a8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd13_nbytes_mlno
    },
    {
        "TCD13_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000011a8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd13_nbytes_mloffno
    },
    {
        "TCD13_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000011a8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd13_nbytes_mloffyes
    },
    {
        "TCD13_SLAST",
        "",
        4, // Width in bytes
        0x000011ac, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd13_slast
    },
    {
        "TCD13_DADDR",
        "",
        4, // Width in bytes
        0x000011b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd13_daddr
    },
    {
        "TCD13_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000011b6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd13_citer_elinkyes
    },
    {
        "TCD13_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000011b6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd13_citer_elinkno
    },
    {
        "TCD13_DOFF",
        "",
        2, // Width in bytes
        0x000011b4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd13_doff
    },
    {
        "TCD13_DLASTSGA",
        "",
        4, // Width in bytes
        0x000011b8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd13_dlastsga
    },
    {
        "TCD13_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000011be, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd13_biter_elinkyes
    },
    {
        "TCD13_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000011be, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd13_biter_elinkno
    },
    {
        "TCD13_CSR",
        "",
        2, // Width in bytes
        0x000011bc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd13_csr
    },
    {
        "TCD14_SADDR",
        "",
        4, // Width in bytes
        0x000011c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd14_saddr
    },
    {
        "TCD14_SOFF",
        "",
        2, // Width in bytes
        0x000011c4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd14_soff
    },
    {
        "TCD14_ATTR",
        "",
        2, // Width in bytes
        0x000011c6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd14_attr
    },
    {
        "TCD14_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000011c8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd14_nbytes_mlno
    },
    {
        "TCD14_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000011c8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd14_nbytes_mloffno
    },
    {
        "TCD14_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000011c8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd14_nbytes_mloffyes
    },
    {
        "TCD14_SLAST",
        "",
        4, // Width in bytes
        0x000011cc, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd14_slast
    },
    {
        "TCD14_DADDR",
        "",
        4, // Width in bytes
        0x000011d0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd14_daddr
    },
    {
        "TCD14_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000011d6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd14_citer_elinkyes
    },
    {
        "TCD14_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000011d6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd14_citer_elinkno
    },
    {
        "TCD14_DOFF",
        "",
        2, // Width in bytes
        0x000011d4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd14_doff
    },
    {
        "TCD14_DLASTSGA",
        "",
        4, // Width in bytes
        0x000011d8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd14_dlastsga
    },
    {
        "TCD14_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000011de, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd14_biter_elinkyes
    },
    {
        "TCD14_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000011de, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd14_biter_elinkno
    },
    {
        "TCD14_CSR",
        "",
        2, // Width in bytes
        0x000011dc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd14_csr
    },
    {
        "TCD15_SADDR",
        "",
        4, // Width in bytes
        0x000011e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd15_saddr
    },
    {
        "TCD15_SOFF",
        "",
        2, // Width in bytes
        0x000011e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd15_soff
    },
    {
        "TCD15_ATTR",
        "",
        2, // Width in bytes
        0x000011e6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd15_attr
    },
    {
        "TCD15_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000011e8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd15_nbytes_mlno
    },
    {
        "TCD15_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000011e8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd15_nbytes_mloffno
    },
    {
        "TCD15_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000011e8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd15_nbytes_mloffyes
    },
    {
        "TCD15_SLAST",
        "",
        4, // Width in bytes
        0x000011ec, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd15_slast
    },
    {
        "TCD15_DADDR",
        "",
        4, // Width in bytes
        0x000011f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd15_daddr
    },
    {
        "TCD15_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000011f6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd15_citer_elinkyes
    },
    {
        "TCD15_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000011f6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd15_citer_elinkno
    },
    {
        "TCD15_DOFF",
        "",
        2, // Width in bytes
        0x000011f4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd15_doff
    },
    {
        "TCD15_DLASTSGA",
        "",
        4, // Width in bytes
        0x000011f8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd15_dlastsga
    },
    {
        "TCD15_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000011fe, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd15_biter_elinkyes
    },
    {
        "TCD15_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000011fe, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd15_biter_elinkno
    },
    {
        "TCD15_CSR",
        "",
        2, // Width in bytes
        0x000011fc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd15_csr
    },
    {
        "TCD16_SADDR",
        "",
        4, // Width in bytes
        0x00001200, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd16_saddr
    },
    {
        "TCD16_SOFF",
        "",
        2, // Width in bytes
        0x00001204, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd16_soff
    },
    {
        "TCD16_ATTR",
        "",
        2, // Width in bytes
        0x00001206, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd16_attr
    },
    {
        "TCD16_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001208, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd16_nbytes_mlno
    },
    {
        "TCD16_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001208, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd16_nbytes_mloffno
    },
    {
        "TCD16_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001208, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd16_nbytes_mloffyes
    },
    {
        "TCD16_SLAST",
        "",
        4, // Width in bytes
        0x0000120c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd16_slast
    },
    {
        "TCD16_DADDR",
        "",
        4, // Width in bytes
        0x00001210, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd16_daddr
    },
    {
        "TCD16_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001216, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd16_citer_elinkyes
    },
    {
        "TCD16_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001216, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd16_citer_elinkno
    },
    {
        "TCD16_DOFF",
        "",
        2, // Width in bytes
        0x00001214, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd16_doff
    },
    {
        "TCD16_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001218, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd16_dlastsga
    },
    {
        "TCD16_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000121e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd16_biter_elinkyes
    },
    {
        "TCD16_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000121e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd16_biter_elinkno
    },
    {
        "TCD16_CSR",
        "",
        2, // Width in bytes
        0x0000121c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd16_csr
    },
    {
        "TCD17_SADDR",
        "",
        4, // Width in bytes
        0x00001220, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd17_saddr
    },
    {
        "TCD17_SOFF",
        "",
        2, // Width in bytes
        0x00001224, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd17_soff
    },
    {
        "TCD17_ATTR",
        "",
        2, // Width in bytes
        0x00001226, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd17_attr
    },
    {
        "TCD17_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001228, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd17_nbytes_mlno
    },
    {
        "TCD17_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001228, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd17_nbytes_mloffno
    },
    {
        "TCD17_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001228, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd17_nbytes_mloffyes
    },
    {
        "TCD17_SLAST",
        "",
        4, // Width in bytes
        0x0000122c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd17_slast
    },
    {
        "TCD17_DADDR",
        "",
        4, // Width in bytes
        0x00001230, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd17_daddr
    },
    {
        "TCD17_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001236, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd17_citer_elinkyes
    },
    {
        "TCD17_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001236, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd17_citer_elinkno
    },
    {
        "TCD17_DOFF",
        "",
        2, // Width in bytes
        0x00001234, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd17_doff
    },
    {
        "TCD17_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001238, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd17_dlastsga
    },
    {
        "TCD17_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000123e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd17_biter_elinkyes
    },
    {
        "TCD17_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000123e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd17_biter_elinkno
    },
    {
        "TCD17_CSR",
        "",
        2, // Width in bytes
        0x0000123c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd17_csr
    },
    {
        "TCD18_SADDR",
        "",
        4, // Width in bytes
        0x00001240, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd18_saddr
    },
    {
        "TCD18_SOFF",
        "",
        2, // Width in bytes
        0x00001244, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd18_soff
    },
    {
        "TCD18_ATTR",
        "",
        2, // Width in bytes
        0x00001246, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd18_attr
    },
    {
        "TCD18_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001248, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd18_nbytes_mlno
    },
    {
        "TCD18_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001248, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd18_nbytes_mloffno
    },
    {
        "TCD18_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001248, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd18_nbytes_mloffyes
    },
    {
        "TCD18_SLAST",
        "",
        4, // Width in bytes
        0x0000124c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd18_slast
    },
    {
        "TCD18_DADDR",
        "",
        4, // Width in bytes
        0x00001250, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd18_daddr
    },
    {
        "TCD18_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001256, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd18_citer_elinkyes
    },
    {
        "TCD18_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001256, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd18_citer_elinkno
    },
    {
        "TCD18_DOFF",
        "",
        2, // Width in bytes
        0x00001254, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd18_doff
    },
    {
        "TCD18_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001258, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd18_dlastsga
    },
    {
        "TCD18_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000125e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd18_biter_elinkyes
    },
    {
        "TCD18_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000125e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd18_biter_elinkno
    },
    {
        "TCD18_CSR",
        "",
        2, // Width in bytes
        0x0000125c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd18_csr
    },
    {
        "TCD19_SADDR",
        "",
        4, // Width in bytes
        0x00001260, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd19_saddr
    },
    {
        "TCD19_SOFF",
        "",
        2, // Width in bytes
        0x00001264, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd19_soff
    },
    {
        "TCD19_ATTR",
        "",
        2, // Width in bytes
        0x00001266, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd19_attr
    },
    {
        "TCD19_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001268, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd19_nbytes_mlno
    },
    {
        "TCD19_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001268, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd19_nbytes_mloffno
    },
    {
        "TCD19_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001268, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd19_nbytes_mloffyes
    },
    {
        "TCD19_SLAST",
        "",
        4, // Width in bytes
        0x0000126c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd19_slast
    },
    {
        "TCD19_DADDR",
        "",
        4, // Width in bytes
        0x00001270, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd19_daddr
    },
    {
        "TCD19_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001276, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd19_citer_elinkyes
    },
    {
        "TCD19_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001276, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd19_citer_elinkno
    },
    {
        "TCD19_DOFF",
        "",
        2, // Width in bytes
        0x00001274, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd19_doff
    },
    {
        "TCD19_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001278, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd19_dlastsga
    },
    {
        "TCD19_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000127e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd19_biter_elinkyes
    },
    {
        "TCD19_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000127e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd19_biter_elinkno
    },
    {
        "TCD19_CSR",
        "",
        2, // Width in bytes
        0x0000127c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd19_csr
    },
    {
        "TCD20_SADDR",
        "",
        4, // Width in bytes
        0x00001280, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd20_saddr
    },
    {
        "TCD20_SOFF",
        "",
        2, // Width in bytes
        0x00001284, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd20_soff
    },
    {
        "TCD20_ATTR",
        "",
        2, // Width in bytes
        0x00001286, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd20_attr
    },
    {
        "TCD20_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001288, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd20_nbytes_mlno
    },
    {
        "TCD20_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001288, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd20_nbytes_mloffno
    },
    {
        "TCD20_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001288, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd20_nbytes_mloffyes
    },
    {
        "TCD20_SLAST",
        "",
        4, // Width in bytes
        0x0000128c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd20_slast
    },
    {
        "TCD20_DADDR",
        "",
        4, // Width in bytes
        0x00001290, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd20_daddr
    },
    {
        "TCD20_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001296, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd20_citer_elinkyes
    },
    {
        "TCD20_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001296, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd20_citer_elinkno
    },
    {
        "TCD20_DOFF",
        "",
        2, // Width in bytes
        0x00001294, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd20_doff
    },
    {
        "TCD20_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001298, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd20_dlastsga
    },
    {
        "TCD20_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000129e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd20_biter_elinkyes
    },
    {
        "TCD20_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000129e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd20_biter_elinkno
    },
    {
        "TCD20_CSR",
        "",
        2, // Width in bytes
        0x0000129c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd20_csr
    },
    {
        "TCD21_SADDR",
        "",
        4, // Width in bytes
        0x000012a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd21_saddr
    },
    {
        "TCD21_SOFF",
        "",
        2, // Width in bytes
        0x000012a4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd21_soff
    },
    {
        "TCD21_ATTR",
        "",
        2, // Width in bytes
        0x000012a6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd21_attr
    },
    {
        "TCD21_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000012a8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd21_nbytes_mlno
    },
    {
        "TCD21_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000012a8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd21_nbytes_mloffno
    },
    {
        "TCD21_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000012a8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd21_nbytes_mloffyes
    },
    {
        "TCD21_SLAST",
        "",
        4, // Width in bytes
        0x000012ac, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd21_slast
    },
    {
        "TCD21_DADDR",
        "",
        4, // Width in bytes
        0x000012b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd21_daddr
    },
    {
        "TCD21_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000012b6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd21_citer_elinkyes
    },
    {
        "TCD21_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000012b6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd21_citer_elinkno
    },
    {
        "TCD21_DOFF",
        "",
        2, // Width in bytes
        0x000012b4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd21_doff
    },
    {
        "TCD21_DLASTSGA",
        "",
        4, // Width in bytes
        0x000012b8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd21_dlastsga
    },
    {
        "TCD21_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000012be, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd21_biter_elinkyes
    },
    {
        "TCD21_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000012be, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd21_biter_elinkno
    },
    {
        "TCD21_CSR",
        "",
        2, // Width in bytes
        0x000012bc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd21_csr
    },
    {
        "TCD22_SADDR",
        "",
        4, // Width in bytes
        0x000012c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd22_saddr
    },
    {
        "TCD22_SOFF",
        "",
        2, // Width in bytes
        0x000012c4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd22_soff
    },
    {
        "TCD22_ATTR",
        "",
        2, // Width in bytes
        0x000012c6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd22_attr
    },
    {
        "TCD22_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000012c8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd22_nbytes_mlno
    },
    {
        "TCD22_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000012c8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd22_nbytes_mloffno
    },
    {
        "TCD22_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000012c8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd22_nbytes_mloffyes
    },
    {
        "TCD22_SLAST",
        "",
        4, // Width in bytes
        0x000012cc, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd22_slast
    },
    {
        "TCD22_DADDR",
        "",
        4, // Width in bytes
        0x000012d0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd22_daddr
    },
    {
        "TCD22_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000012d6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd22_citer_elinkyes
    },
    {
        "TCD22_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000012d6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd22_citer_elinkno
    },
    {
        "TCD22_DOFF",
        "",
        2, // Width in bytes
        0x000012d4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd22_doff
    },
    {
        "TCD22_DLASTSGA",
        "",
        4, // Width in bytes
        0x000012d8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd22_dlastsga
    },
    {
        "TCD22_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000012de, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd22_biter_elinkyes
    },
    {
        "TCD22_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000012de, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd22_biter_elinkno
    },
    {
        "TCD22_CSR",
        "",
        2, // Width in bytes
        0x000012dc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd22_csr
    },
    {
        "TCD23_SADDR",
        "",
        4, // Width in bytes
        0x000012e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd23_saddr
    },
    {
        "TCD23_SOFF",
        "",
        2, // Width in bytes
        0x000012e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd23_soff
    },
    {
        "TCD23_ATTR",
        "",
        2, // Width in bytes
        0x000012e6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd23_attr
    },
    {
        "TCD23_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000012e8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd23_nbytes_mlno
    },
    {
        "TCD23_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000012e8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd23_nbytes_mloffno
    },
    {
        "TCD23_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000012e8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd23_nbytes_mloffyes
    },
    {
        "TCD23_SLAST",
        "",
        4, // Width in bytes
        0x000012ec, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd23_slast
    },
    {
        "TCD23_DADDR",
        "",
        4, // Width in bytes
        0x000012f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd23_daddr
    },
    {
        "TCD23_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000012f6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd23_citer_elinkyes
    },
    {
        "TCD23_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000012f6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd23_citer_elinkno
    },
    {
        "TCD23_DOFF",
        "",
        2, // Width in bytes
        0x000012f4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd23_doff
    },
    {
        "TCD23_DLASTSGA",
        "",
        4, // Width in bytes
        0x000012f8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd23_dlastsga
    },
    {
        "TCD23_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000012fe, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd23_biter_elinkyes
    },
    {
        "TCD23_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000012fe, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd23_biter_elinkno
    },
    {
        "TCD23_CSR",
        "",
        2, // Width in bytes
        0x000012fc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd23_csr
    },
    {
        "TCD24_SADDR",
        "",
        4, // Width in bytes
        0x00001300, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd24_saddr
    },
    {
        "TCD24_SOFF",
        "",
        2, // Width in bytes
        0x00001304, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd24_soff
    },
    {
        "TCD24_ATTR",
        "",
        2, // Width in bytes
        0x00001306, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd24_attr
    },
    {
        "TCD24_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001308, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd24_nbytes_mlno
    },
    {
        "TCD24_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001308, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd24_nbytes_mloffno
    },
    {
        "TCD24_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001308, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd24_nbytes_mloffyes
    },
    {
        "TCD24_SLAST",
        "",
        4, // Width in bytes
        0x0000130c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd24_slast
    },
    {
        "TCD24_DADDR",
        "",
        4, // Width in bytes
        0x00001310, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd24_daddr
    },
    {
        "TCD24_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001316, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd24_citer_elinkyes
    },
    {
        "TCD24_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001316, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd24_citer_elinkno
    },
    {
        "TCD24_DOFF",
        "",
        2, // Width in bytes
        0x00001314, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd24_doff
    },
    {
        "TCD24_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001318, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd24_dlastsga
    },
    {
        "TCD24_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000131e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd24_biter_elinkyes
    },
    {
        "TCD24_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000131e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd24_biter_elinkno
    },
    {
        "TCD24_CSR",
        "",
        2, // Width in bytes
        0x0000131c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd24_csr
    },
    {
        "TCD25_SADDR",
        "",
        4, // Width in bytes
        0x00001320, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd25_saddr
    },
    {
        "TCD25_SOFF",
        "",
        2, // Width in bytes
        0x00001324, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd25_soff
    },
    {
        "TCD25_ATTR",
        "",
        2, // Width in bytes
        0x00001326, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd25_attr
    },
    {
        "TCD25_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001328, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd25_nbytes_mlno
    },
    {
        "TCD25_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001328, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd25_nbytes_mloffno
    },
    {
        "TCD25_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001328, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd25_nbytes_mloffyes
    },
    {
        "TCD25_SLAST",
        "",
        4, // Width in bytes
        0x0000132c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd25_slast
    },
    {
        "TCD25_DADDR",
        "",
        4, // Width in bytes
        0x00001330, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd25_daddr
    },
    {
        "TCD25_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001336, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd25_citer_elinkyes
    },
    {
        "TCD25_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001336, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd25_citer_elinkno
    },
    {
        "TCD25_DOFF",
        "",
        2, // Width in bytes
        0x00001334, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd25_doff
    },
    {
        "TCD25_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001338, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd25_dlastsga
    },
    {
        "TCD25_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000133e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd25_biter_elinkyes
    },
    {
        "TCD25_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000133e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd25_biter_elinkno
    },
    {
        "TCD25_CSR",
        "",
        2, // Width in bytes
        0x0000133c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd25_csr
    },
    {
        "TCD26_SADDR",
        "",
        4, // Width in bytes
        0x00001340, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd26_saddr
    },
    {
        "TCD26_SOFF",
        "",
        2, // Width in bytes
        0x00001344, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd26_soff
    },
    {
        "TCD26_ATTR",
        "",
        2, // Width in bytes
        0x00001346, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd26_attr
    },
    {
        "TCD26_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001348, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd26_nbytes_mlno
    },
    {
        "TCD26_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001348, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd26_nbytes_mloffno
    },
    {
        "TCD26_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001348, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd26_nbytes_mloffyes
    },
    {
        "TCD26_SLAST",
        "",
        4, // Width in bytes
        0x0000134c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd26_slast
    },
    {
        "TCD26_DADDR",
        "",
        4, // Width in bytes
        0x00001350, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd26_daddr
    },
    {
        "TCD26_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001356, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd26_citer_elinkyes
    },
    {
        "TCD26_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001356, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd26_citer_elinkno
    },
    {
        "TCD26_DOFF",
        "",
        2, // Width in bytes
        0x00001354, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd26_doff
    },
    {
        "TCD26_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001358, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd26_dlastsga
    },
    {
        "TCD26_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000135e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd26_biter_elinkyes
    },
    {
        "TCD26_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000135e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd26_biter_elinkno
    },
    {
        "TCD26_CSR",
        "",
        2, // Width in bytes
        0x0000135c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd26_csr
    },
    {
        "TCD27_SADDR",
        "",
        4, // Width in bytes
        0x00001360, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd27_saddr
    },
    {
        "TCD27_SOFF",
        "",
        2, // Width in bytes
        0x00001364, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd27_soff
    },
    {
        "TCD27_ATTR",
        "",
        2, // Width in bytes
        0x00001366, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd27_attr
    },
    {
        "TCD27_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001368, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd27_nbytes_mlno
    },
    {
        "TCD27_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001368, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd27_nbytes_mloffno
    },
    {
        "TCD27_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001368, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd27_nbytes_mloffyes
    },
    {
        "TCD27_SLAST",
        "",
        4, // Width in bytes
        0x0000136c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd27_slast
    },
    {
        "TCD27_DADDR",
        "",
        4, // Width in bytes
        0x00001370, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd27_daddr
    },
    {
        "TCD27_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001376, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd27_citer_elinkyes
    },
    {
        "TCD27_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001376, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd27_citer_elinkno
    },
    {
        "TCD27_DOFF",
        "",
        2, // Width in bytes
        0x00001374, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd27_doff
    },
    {
        "TCD27_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001378, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd27_dlastsga
    },
    {
        "TCD27_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000137e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd27_biter_elinkyes
    },
    {
        "TCD27_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000137e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd27_biter_elinkno
    },
    {
        "TCD27_CSR",
        "",
        2, // Width in bytes
        0x0000137c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd27_csr
    },
    {
        "TCD28_SADDR",
        "",
        4, // Width in bytes
        0x00001380, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd28_saddr
    },
    {
        "TCD28_SOFF",
        "",
        2, // Width in bytes
        0x00001384, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd28_soff
    },
    {
        "TCD28_ATTR",
        "",
        2, // Width in bytes
        0x00001386, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd28_attr
    },
    {
        "TCD28_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x00001388, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd28_nbytes_mlno
    },
    {
        "TCD28_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001388, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd28_nbytes_mloffno
    },
    {
        "TCD28_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x00001388, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd28_nbytes_mloffyes
    },
    {
        "TCD28_SLAST",
        "",
        4, // Width in bytes
        0x0000138c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd28_slast
    },
    {
        "TCD28_DADDR",
        "",
        4, // Width in bytes
        0x00001390, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd28_daddr
    },
    {
        "TCD28_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001396, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd28_citer_elinkyes
    },
    {
        "TCD28_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x00001396, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd28_citer_elinkno
    },
    {
        "TCD28_DOFF",
        "",
        2, // Width in bytes
        0x00001394, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd28_doff
    },
    {
        "TCD28_DLASTSGA",
        "",
        4, // Width in bytes
        0x00001398, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd28_dlastsga
    },
    {
        "TCD28_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x0000139e, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd28_biter_elinkyes
    },
    {
        "TCD28_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x0000139e, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd28_biter_elinkno
    },
    {
        "TCD28_CSR",
        "",
        2, // Width in bytes
        0x0000139c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd28_csr
    },
    {
        "TCD29_SADDR",
        "",
        4, // Width in bytes
        0x000013a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd29_saddr
    },
    {
        "TCD29_SOFF",
        "",
        2, // Width in bytes
        0x000013a4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd29_soff
    },
    {
        "TCD29_ATTR",
        "",
        2, // Width in bytes
        0x000013a6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd29_attr
    },
    {
        "TCD29_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000013a8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd29_nbytes_mlno
    },
    {
        "TCD29_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000013a8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd29_nbytes_mloffno
    },
    {
        "TCD29_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000013a8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd29_nbytes_mloffyes
    },
    {
        "TCD29_SLAST",
        "",
        4, // Width in bytes
        0x000013ac, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd29_slast
    },
    {
        "TCD29_DADDR",
        "",
        4, // Width in bytes
        0x000013b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd29_daddr
    },
    {
        "TCD29_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000013b6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd29_citer_elinkyes
    },
    {
        "TCD29_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000013b6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd29_citer_elinkno
    },
    {
        "TCD29_DOFF",
        "",
        2, // Width in bytes
        0x000013b4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd29_doff
    },
    {
        "TCD29_DLASTSGA",
        "",
        4, // Width in bytes
        0x000013b8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd29_dlastsga
    },
    {
        "TCD29_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000013be, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd29_biter_elinkyes
    },
    {
        "TCD29_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000013be, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd29_biter_elinkno
    },
    {
        "TCD29_CSR",
        "",
        2, // Width in bytes
        0x000013bc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd29_csr
    },
    {
        "TCD30_SADDR",
        "",
        4, // Width in bytes
        0x000013c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd30_saddr
    },
    {
        "TCD30_SOFF",
        "",
        2, // Width in bytes
        0x000013c4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd30_soff
    },
    {
        "TCD30_ATTR",
        "",
        2, // Width in bytes
        0x000013c6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd30_attr
    },
    {
        "TCD30_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000013c8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd30_nbytes_mlno
    },
    {
        "TCD30_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000013c8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd30_nbytes_mloffno
    },
    {
        "TCD30_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000013c8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd30_nbytes_mloffyes
    },
    {
        "TCD30_SLAST",
        "",
        4, // Width in bytes
        0x000013cc, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd30_slast
    },
    {
        "TCD30_DADDR",
        "",
        4, // Width in bytes
        0x000013d0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd30_daddr
    },
    {
        "TCD30_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000013d6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd30_citer_elinkyes
    },
    {
        "TCD30_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000013d6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd30_citer_elinkno
    },
    {
        "TCD30_DOFF",
        "",
        2, // Width in bytes
        0x000013d4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd30_doff
    },
    {
        "TCD30_DLASTSGA",
        "",
        4, // Width in bytes
        0x000013d8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd30_dlastsga
    },
    {
        "TCD30_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000013de, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd30_biter_elinkyes
    },
    {
        "TCD30_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000013de, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd30_biter_elinkno
    },
    {
        "TCD30_CSR",
        "",
        2, // Width in bytes
        0x000013dc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd30_csr
    },
    {
        "TCD31_SADDR",
        "",
        4, // Width in bytes
        0x000013e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd31_saddr
    },
    {
        "TCD31_SOFF",
        "",
        2, // Width in bytes
        0x000013e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd31_soff
    },
    {
        "TCD31_ATTR",
        "",
        2, // Width in bytes
        0x000013e6, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd31_attr
    },
    {
        "TCD31_NBYTES_MLNO",
        "This register, or one of the next two registers (TCD_NBYTES_MLOFFNO, T"
        "CD_NBYTES_MLOFFYES), defines the number of bytes to transfer per reque"
        "st.",
        4, // Width in bytes
        0x000013e8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd31_nbytes_mlno
    },
    {
        "TCD31_NBYTES_MLOFFNO",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFYES), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000013e8, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd31_nbytes_mloffno
    },
    {
        "TCD31_NBYTES_MLOFFYES",
        "One of three registers (this register, TCD_NBYTES_MLNO, or TCD_NBYTES_"
        "MLOFFNO), defines the number of bytes to transfer per request.",
        4, // Width in bytes
        0x000013e8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_tcd31_nbytes_mloffyes
    },
    {
        "TCD31_SLAST",
        "",
        4, // Width in bytes
        0x000013ec, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd31_slast
    },
    {
        "TCD31_DADDR",
        "",
        4, // Width in bytes
        0x000013f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd31_daddr
    },
    {
        "TCD31_CITER_ELINKYES",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000013f6, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd31_citer_elinkyes
    },
    {
        "TCD31_CITER_ELINKNO",
        "This register contains the minor-loop channel-linking configuration an"
        "d the channel's current iteration count.",
        2, // Width in bytes
        0x000013f6, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd31_citer_elinkno
    },
    {
        "TCD31_DOFF",
        "",
        2, // Width in bytes
        0x000013f4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd31_doff
    },
    {
        "TCD31_DLASTSGA",
        "",
        4, // Width in bytes
        0x000013f8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dma_tcd31_dlastsga
    },
    {
        "TCD31_BITER_ELINKYES",
        "If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is define"
        "d as follows.",
        2, // Width in bytes
        0x000013fe, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dma_tcd31_biter_elinkyes
    },
    {
        "TCD31_BITER_ELINKNO",
        "If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is de"
        "fined as follows.",
        2, // Width in bytes
        0x000013fe, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dma_tcd31_biter_elinkno
    },
    {
        "TCD31_CSR",
        "",
        2, // Width in bytes
        0x000013fc, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dma_tcd31_csr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DMA_CH_MUX
#endif

// Bitfields in register DMA_CH_MUX_CHCFG0.
static const field_t hw_dma_ch_mux_chcfg0[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG1.
static const field_t hw_dma_ch_mux_chcfg1[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG2.
static const field_t hw_dma_ch_mux_chcfg2[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG3.
static const field_t hw_dma_ch_mux_chcfg3[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG4.
static const field_t hw_dma_ch_mux_chcfg4[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG5.
static const field_t hw_dma_ch_mux_chcfg5[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG6.
static const field_t hw_dma_ch_mux_chcfg6[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG7.
static const field_t hw_dma_ch_mux_chcfg7[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG8.
static const field_t hw_dma_ch_mux_chcfg8[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG9.
static const field_t hw_dma_ch_mux_chcfg9[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG10.
static const field_t hw_dma_ch_mux_chcfg10[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG11.
static const field_t hw_dma_ch_mux_chcfg11[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG12.
static const field_t hw_dma_ch_mux_chcfg12[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG13.
static const field_t hw_dma_ch_mux_chcfg13[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG14.
static const field_t hw_dma_ch_mux_chcfg14[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG15.
static const field_t hw_dma_ch_mux_chcfg15[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG16.
static const field_t hw_dma_ch_mux_chcfg16[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG17.
static const field_t hw_dma_ch_mux_chcfg17[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG18.
static const field_t hw_dma_ch_mux_chcfg18[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG19.
static const field_t hw_dma_ch_mux_chcfg19[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG20.
static const field_t hw_dma_ch_mux_chcfg20[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG21.
static const field_t hw_dma_ch_mux_chcfg21[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG22.
static const field_t hw_dma_ch_mux_chcfg22[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG23.
static const field_t hw_dma_ch_mux_chcfg23[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG24.
static const field_t hw_dma_ch_mux_chcfg24[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG25.
static const field_t hw_dma_ch_mux_chcfg25[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG26.
static const field_t hw_dma_ch_mux_chcfg26[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG27.
static const field_t hw_dma_ch_mux_chcfg27[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG28.
static const field_t hw_dma_ch_mux_chcfg28[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG29.
static const field_t hw_dma_ch_mux_chcfg29[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG30.
static const field_t hw_dma_ch_mux_chcfg30[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DMA_CH_MUX_CHCFG31.
static const field_t hw_dma_ch_mux_chcfg31[] =
{
    {
        "SOURCE",
        "Specifies which DMA source, if any, is routed to a particular DMA chan"
        "nel.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "A_ON",
        "Enables the DMA Channel to be always ON.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRIG",
        "Enables the periodic trigger capability for the triggered DMA channel.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENBL",
        "Enables the channel for DMA Mux.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a DMA_CH_MUX module.
static const reg_t hw_dma_ch_mux[] =
{
    {
        "CHCFG0",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg0
    },
    {
        "CHCFG1",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg1
    },
    {
        "CHCFG2",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg2
    },
    {
        "CHCFG3",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg3
    },
    {
        "CHCFG4",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg4
    },
    {
        "CHCFG5",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg5
    },
    {
        "CHCFG6",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg6
    },
    {
        "CHCFG7",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg7
    },
    {
        "CHCFG8",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg8
    },
    {
        "CHCFG9",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg9
    },
    {
        "CHCFG10",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg10
    },
    {
        "CHCFG11",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg11
    },
    {
        "CHCFG12",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg12
    },
    {
        "CHCFG13",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg13
    },
    {
        "CHCFG14",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg14
    },
    {
        "CHCFG15",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg15
    },
    {
        "CHCFG16",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg16
    },
    {
        "CHCFG17",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg17
    },
    {
        "CHCFG18",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg18
    },
    {
        "CHCFG19",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg19
    },
    {
        "CHCFG20",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg20
    },
    {
        "CHCFG21",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg21
    },
    {
        "CHCFG22",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg22
    },
    {
        "CHCFG23",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg23
    },
    {
        "CHCFG24",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg24
    },
    {
        "CHCFG25",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg25
    },
    {
        "CHCFG26",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg26
    },
    {
        "CHCFG27",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg27
    },
    {
        "CHCFG28",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg28
    },
    {
        "CHCFG29",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg29
    },
    {
        "CHCFG30",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg30
    },
    {
        "CHCFG31",
        "Each of the DMA channels can be independently enabled/disabled and ass"
        "ociated with one of the DMA slots (peripheral slots or always-on slots"
        ") in the system.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dma_ch_mux_chcfg31
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EWM
#endif

// Bitfields in register EWM_CTRL.
static const field_t hw_ewm_ctrl[] =
{
    {
        "EWMEN",
        "This bit when set, enables the EWM module.",
        0, // LSB
        0, // MSB
        false, // Readable
        false // Writable
    },
    {
        "ASSIN",
        "Default assert state of the EWM_in signal is logic zero.",
        1, // LSB
        1, // MSB
        false, // Readable
        false // Writable
    },
    {
        "INEN",
        "This bit when set, enables the EWM_in port.",
        2, // LSB
        2, // MSB
        false, // Readable
        false // Writable
    },
    {
        "INTEN",
        "This bit when set and EWM_OUT_b is asserted, an interrupt request is g"
        "enerated.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EWM_SERV.
static const field_t hw_ewm_serv[] =
{
    {
        "SERVICE",
        "The EWM refresh mechanism requires the CPU to write two values to the "
        "SERV register: a first data byte of 0xB4, followed by a second data by"
        "te of 0x2C.",
        0, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EWM_CMPL.
static const field_t hw_ewm_cmpl[] =
{
    {
        "COMPAREL",
        "To prevent runaway code from changing this field, software should writ"
        "e to this field after a CPU reset even if the (default) minimum refres"
        "h time is required.",
        0, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EWM_CMPH.
static const field_t hw_ewm_cmph[] =
{
    {
        "COMPAREH",
        "To prevent runaway code from changing this field, software should writ"
        "e to this field after a CPU reset even if the (default) maximum refres"
        "h time is required.",
        0, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EWM_CLKCTRL.
static const field_t hw_ewm_clkctrl[] =
{
    {
        "CLKSEL",
        "EWM has 4 possible low power clock sources for running EWM counter.",
        0, // LSB
        1, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EWM_CLKPRESCALER.
static const field_t hw_ewm_clkprescaler[] =
{
    {
        "CLK_DIV",
        "Selected low power clock source for running the EWM counter can be pre"
        "scaled as below.",
        0, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a EWM module.
static const reg_t hw_ewm[] =
{
    {
        "CTRL",
        "The CTRL register is cleared by any reset.",
        1, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ewm_ctrl
    },
    {
        "SERV",
        "The SERV register provides the interface from the CPU to the EWM modul"
        "e.",
        1, // Width in bytes
        0x00000001, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ewm_serv
    },
    {
        "CMPL",
        "The CMPL register is reset to zero after a CPU reset.",
        1, // Width in bytes
        0x00000002, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ewm_cmpl
    },
    {
        "CMPH",
        "The CMPH register is reset to 0xFF after a CPU reset.",
        1, // Width in bytes
        0x00000003, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ewm_cmph
    },
    {
        "CLKCTRL",
        "This CLKCTRL register is reset to 0x00 after a CPU reset.",
        1, // Width in bytes
        0x00000004, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ewm_clkctrl
    },
    {
        "CLKPRESCALER",
        "This CLKPRESCALER register is reset to 0x00 after a CPU reset.",
        1, // Width in bytes
        0x00000005, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ewm_clkprescaler
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark FB
#endif

// Bitfields in register FB_CSAR0.
static const field_t hw_fb_csar0[] =
{
    {
        "BA",
        "Defines the base address for memory dedicated to the associated chip-s"
        "elect.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSMR0.
static const field_t hw_fb_csmr0[] =
{
    {
        "V",
        "Specifies whether the corresponding CSAR, CSMR, and CSCR contents are "
        "valid.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Controls write accesses to the address range in the corresponding CSAR"
        ".",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BAM",
        "Defines the associated chip-select's block size by masking address bit"
        "s.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSCR0.
static const field_t hw_fb_cscr0[] =
{
    {
        "BSTW",
        "Specifies whether burst writes are enabled for memory associated with "
        "each chip select.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BSTR",
        "Specifies whether burst reads are enabled for memory associated with e"
        "ach chip select.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BEM",
        "Specifies whether the corresponding FB_BE_B is asserted for read acces"
        "ses.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PS",
        "Specifies the data port width of the associated chip-select, and deter"
        "mines where data is driven during write cycles and where data is sampl"
        "ed during read cycles.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AA",
        "Asserts the internal transfer acknowledge for accesses specified by th"
        "e chip-select address.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BLS",
        "Specifies if data on FB_AD appears left-aligned or right-aligned durin"
        "g the data phase of a FlexBus access.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WS",
        "Specifies the number of wait states inserted after FlexBus asserts the"
        " associated chip-select and before an internal transfer acknowledge is"
        " generated (WS = 00h inserts 0 wait states, .",
        10, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRAH",
        "Controls the address, data, and attribute hold time after the terminat"
        "ion of a write cycle that hits in the associated chip-select's address"
        " space.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDAH",
        "Controls the address and attribute hold time after the termination dur"
        "ing a read cycle that hits in the associated chip-select's address spa"
        "ce.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASET",
        "Controls when the chip-select is asserted with respect to assertion of"
        " a valid address and attributes.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTS",
        "Extended Transfer Start/Extended Address Latch Enable Controls how lon"
        "g FB_TS_B /FB_ALE is asserted.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWSEN",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWS",
        "Used only when the SWSEN bit is 1b.",
        26, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSAR1.
static const field_t hw_fb_csar1[] =
{
    {
        "BA",
        "Defines the base address for memory dedicated to the associated chip-s"
        "elect.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSMR1.
static const field_t hw_fb_csmr1[] =
{
    {
        "V",
        "Specifies whether the corresponding CSAR, CSMR, and CSCR contents are "
        "valid.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Controls write accesses to the address range in the corresponding CSAR"
        ".",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BAM",
        "Defines the associated chip-select's block size by masking address bit"
        "s.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSCR1.
static const field_t hw_fb_cscr1[] =
{
    {
        "BSTW",
        "Specifies whether burst writes are enabled for memory associated with "
        "each chip select.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BSTR",
        "Specifies whether burst reads are enabled for memory associated with e"
        "ach chip select.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BEM",
        "Specifies whether the corresponding FB_BE_B is asserted for read acces"
        "ses.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PS",
        "Specifies the data port width of the associated chip-select, and deter"
        "mines where data is driven during write cycles and where data is sampl"
        "ed during read cycles.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AA",
        "Asserts the internal transfer acknowledge for accesses specified by th"
        "e chip-select address.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BLS",
        "Specifies if data on FB_AD appears left-aligned or right-aligned durin"
        "g the data phase of a FlexBus access.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WS",
        "Specifies the number of wait states inserted after FlexBus asserts the"
        " associated chip-select and before an internal transfer acknowledge is"
        " generated (WS = 00h inserts 0 wait states, .",
        10, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRAH",
        "Controls the address, data, and attribute hold time after the terminat"
        "ion of a write cycle that hits in the associated chip-select's address"
        " space.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDAH",
        "Controls the address and attribute hold time after the termination dur"
        "ing a read cycle that hits in the associated chip-select's address spa"
        "ce.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASET",
        "Controls when the chip-select is asserted with respect to assertion of"
        " a valid address and attributes.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTS",
        "Extended Transfer Start/Extended Address Latch Enable Controls how lon"
        "g FB_TS_B /FB_ALE is asserted.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWSEN",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWS",
        "Used only when the SWSEN bit is 1b.",
        26, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSAR2.
static const field_t hw_fb_csar2[] =
{
    {
        "BA",
        "Defines the base address for memory dedicated to the associated chip-s"
        "elect.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSMR2.
static const field_t hw_fb_csmr2[] =
{
    {
        "V",
        "Specifies whether the corresponding CSAR, CSMR, and CSCR contents are "
        "valid.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Controls write accesses to the address range in the corresponding CSAR"
        ".",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BAM",
        "Defines the associated chip-select's block size by masking address bit"
        "s.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSCR2.
static const field_t hw_fb_cscr2[] =
{
    {
        "BSTW",
        "Specifies whether burst writes are enabled for memory associated with "
        "each chip select.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BSTR",
        "Specifies whether burst reads are enabled for memory associated with e"
        "ach chip select.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BEM",
        "Specifies whether the corresponding FB_BE_B is asserted for read acces"
        "ses.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PS",
        "Specifies the data port width of the associated chip-select, and deter"
        "mines where data is driven during write cycles and where data is sampl"
        "ed during read cycles.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AA",
        "Asserts the internal transfer acknowledge for accesses specified by th"
        "e chip-select address.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BLS",
        "Specifies if data on FB_AD appears left-aligned or right-aligned durin"
        "g the data phase of a FlexBus access.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WS",
        "Specifies the number of wait states inserted after FlexBus asserts the"
        " associated chip-select and before an internal transfer acknowledge is"
        " generated (WS = 00h inserts 0 wait states, .",
        10, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRAH",
        "Controls the address, data, and attribute hold time after the terminat"
        "ion of a write cycle that hits in the associated chip-select's address"
        " space.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDAH",
        "Controls the address and attribute hold time after the termination dur"
        "ing a read cycle that hits in the associated chip-select's address spa"
        "ce.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASET",
        "Controls when the chip-select is asserted with respect to assertion of"
        " a valid address and attributes.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTS",
        "Extended Transfer Start/Extended Address Latch Enable Controls how lon"
        "g FB_TS_B /FB_ALE is asserted.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWSEN",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWS",
        "Used only when the SWSEN bit is 1b.",
        26, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSAR3.
static const field_t hw_fb_csar3[] =
{
    {
        "BA",
        "Defines the base address for memory dedicated to the associated chip-s"
        "elect.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSMR3.
static const field_t hw_fb_csmr3[] =
{
    {
        "V",
        "Specifies whether the corresponding CSAR, CSMR, and CSCR contents are "
        "valid.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Controls write accesses to the address range in the corresponding CSAR"
        ".",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BAM",
        "Defines the associated chip-select's block size by masking address bit"
        "s.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSCR3.
static const field_t hw_fb_cscr3[] =
{
    {
        "BSTW",
        "Specifies whether burst writes are enabled for memory associated with "
        "each chip select.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BSTR",
        "Specifies whether burst reads are enabled for memory associated with e"
        "ach chip select.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BEM",
        "Specifies whether the corresponding FB_BE_B is asserted for read acces"
        "ses.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PS",
        "Specifies the data port width of the associated chip-select, and deter"
        "mines where data is driven during write cycles and where data is sampl"
        "ed during read cycles.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AA",
        "Asserts the internal transfer acknowledge for accesses specified by th"
        "e chip-select address.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BLS",
        "Specifies if data on FB_AD appears left-aligned or right-aligned durin"
        "g the data phase of a FlexBus access.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WS",
        "Specifies the number of wait states inserted after FlexBus asserts the"
        " associated chip-select and before an internal transfer acknowledge is"
        " generated (WS = 00h inserts 0 wait states, .",
        10, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRAH",
        "Controls the address, data, and attribute hold time after the terminat"
        "ion of a write cycle that hits in the associated chip-select's address"
        " space.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDAH",
        "Controls the address and attribute hold time after the termination dur"
        "ing a read cycle that hits in the associated chip-select's address spa"
        "ce.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASET",
        "Controls when the chip-select is asserted with respect to assertion of"
        " a valid address and attributes.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTS",
        "Extended Transfer Start/Extended Address Latch Enable Controls how lon"
        "g FB_TS_B /FB_ALE is asserted.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWSEN",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWS",
        "Used only when the SWSEN bit is 1b.",
        26, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSAR4.
static const field_t hw_fb_csar4[] =
{
    {
        "BA",
        "Defines the base address for memory dedicated to the associated chip-s"
        "elect.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSMR4.
static const field_t hw_fb_csmr4[] =
{
    {
        "V",
        "Specifies whether the corresponding CSAR, CSMR, and CSCR contents are "
        "valid.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Controls write accesses to the address range in the corresponding CSAR"
        ".",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BAM",
        "Defines the associated chip-select's block size by masking address bit"
        "s.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSCR4.
static const field_t hw_fb_cscr4[] =
{
    {
        "BSTW",
        "Specifies whether burst writes are enabled for memory associated with "
        "each chip select.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BSTR",
        "Specifies whether burst reads are enabled for memory associated with e"
        "ach chip select.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BEM",
        "Specifies whether the corresponding FB_BE_B is asserted for read acces"
        "ses.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PS",
        "Specifies the data port width of the associated chip-select, and deter"
        "mines where data is driven during write cycles and where data is sampl"
        "ed during read cycles.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AA",
        "Asserts the internal transfer acknowledge for accesses specified by th"
        "e chip-select address.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BLS",
        "Specifies if data on FB_AD appears left-aligned or right-aligned durin"
        "g the data phase of a FlexBus access.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WS",
        "Specifies the number of wait states inserted after FlexBus asserts the"
        " associated chip-select and before an internal transfer acknowledge is"
        " generated (WS = 00h inserts 0 wait states, .",
        10, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRAH",
        "Controls the address, data, and attribute hold time after the terminat"
        "ion of a write cycle that hits in the associated chip-select's address"
        " space.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDAH",
        "Controls the address and attribute hold time after the termination dur"
        "ing a read cycle that hits in the associated chip-select's address spa"
        "ce.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASET",
        "Controls when the chip-select is asserted with respect to assertion of"
        " a valid address and attributes.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTS",
        "Extended Transfer Start/Extended Address Latch Enable Controls how lon"
        "g FB_TS_B /FB_ALE is asserted.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWSEN",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWS",
        "Used only when the SWSEN bit is 1b.",
        26, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSAR5.
static const field_t hw_fb_csar5[] =
{
    {
        "BA",
        "Defines the base address for memory dedicated to the associated chip-s"
        "elect.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSMR5.
static const field_t hw_fb_csmr5[] =
{
    {
        "V",
        "Specifies whether the corresponding CSAR, CSMR, and CSCR contents are "
        "valid.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Controls write accesses to the address range in the corresponding CSAR"
        ".",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BAM",
        "Defines the associated chip-select's block size by masking address bit"
        "s.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSCR5.
static const field_t hw_fb_cscr5[] =
{
    {
        "BSTW",
        "Specifies whether burst writes are enabled for memory associated with "
        "each chip select.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BSTR",
        "Specifies whether burst reads are enabled for memory associated with e"
        "ach chip select.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BEM",
        "Specifies whether the corresponding FB_BE_B is asserted for read acces"
        "ses.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PS",
        "Specifies the data port width of the associated chip-select, and deter"
        "mines where data is driven during write cycles and where data is sampl"
        "ed during read cycles.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AA",
        "Asserts the internal transfer acknowledge for accesses specified by th"
        "e chip-select address.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BLS",
        "Specifies if data on FB_AD appears left-aligned or right-aligned durin"
        "g the data phase of a FlexBus access.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WS",
        "Specifies the number of wait states inserted after FlexBus asserts the"
        " associated chip-select and before an internal transfer acknowledge is"
        " generated (WS = 00h inserts 0 wait states, .",
        10, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRAH",
        "Controls the address, data, and attribute hold time after the terminat"
        "ion of a write cycle that hits in the associated chip-select's address"
        " space.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDAH",
        "Controls the address and attribute hold time after the termination dur"
        "ing a read cycle that hits in the associated chip-select's address spa"
        "ce.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASET",
        "Controls when the chip-select is asserted with respect to assertion of"
        " a valid address and attributes.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTS",
        "Extended Transfer Start/Extended Address Latch Enable Controls how lon"
        "g FB_TS_B /FB_ALE is asserted.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWSEN",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWS",
        "Used only when the SWSEN bit is 1b.",
        26, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FB_CSPMCR.
static const field_t hw_fb_cspmcr[] =
{
    {
        "GROUP5",
        "Controls the multiplexing of the FB_TA_B, FB_CS3_B, and FB_BE_7_0_B si"
        "gnals.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GROUP4",
        "Controls the multiplexing of the FB_TBST_B, FB_CS2_B, and FB_BE_15_8_B"
        " signals.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GROUP3",
        "Controls the multiplexing of the FB_CS5_B, FB_TSIZ1, and FB_BE_23_16_B"
        " signals.",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GROUP2",
        "Controls the multiplexing of the FB_CS4_B, FB_TSIZ0, and FB_BE_31_24_B"
        " signals.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GROUP1",
        "Controls the multiplexing of the FB_ALE, FB_CS1_B, and FB_TS_B signals"
        ".",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a FB module.
static const reg_t hw_fb[] =
{
    {
        "CSAR0",
        "Specifies the associated chip-select's base address.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fb_csar0
    },
    {
        "CSMR0",
        "Specifies the address mask and allowable access types for the associat"
        "ed chip-select.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_fb_csmr0
    },
    {
        "CSCR0",
        "Controls the auto-acknowledge, address setup and hold times, port size"
        ", burst capability, and number of wait states for the associated chip "
        "select.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_fb_cscr0
    },
    {
        "CSAR1",
        "Specifies the associated chip-select's base address.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fb_csar1
    },
    {
        "CSMR1",
        "Specifies the address mask and allowable access types for the associat"
        "ed chip-select.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_fb_csmr1
    },
    {
        "CSCR1",
        "Controls the auto-acknowledge, address setup and hold times, port size"
        ", burst capability, and number of wait states for the associated chip "
        "select.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_fb_cscr1
    },
    {
        "CSAR2",
        "Specifies the associated chip-select's base address.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fb_csar2
    },
    {
        "CSMR2",
        "Specifies the address mask and allowable access types for the associat"
        "ed chip-select.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_fb_csmr2
    },
    {
        "CSCR2",
        "Controls the auto-acknowledge, address setup and hold times, port size"
        ", burst capability, and number of wait states for the associated chip "
        "select.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_fb_cscr2
    },
    {
        "CSAR3",
        "Specifies the associated chip-select's base address.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fb_csar3
    },
    {
        "CSMR3",
        "Specifies the address mask and allowable access types for the associat"
        "ed chip-select.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_fb_csmr3
    },
    {
        "CSCR3",
        "Controls the auto-acknowledge, address setup and hold times, port size"
        ", burst capability, and number of wait states for the associated chip "
        "select.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_fb_cscr3
    },
    {
        "CSAR4",
        "Specifies the associated chip-select's base address.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fb_csar4
    },
    {
        "CSMR4",
        "Specifies the address mask and allowable access types for the associat"
        "ed chip-select.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_fb_csmr4
    },
    {
        "CSCR4",
        "Controls the auto-acknowledge, address setup and hold times, port size"
        ", burst capability, and number of wait states for the associated chip "
        "select.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_fb_cscr4
    },
    {
        "CSAR5",
        "Specifies the associated chip-select's base address.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_fb_csar5
    },
    {
        "CSMR5",
        "Specifies the address mask and allowable access types for the associat"
        "ed chip-select.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_fb_csmr5
    },
    {
        "CSCR5",
        "Controls the auto-acknowledge, address setup and hold times, port size"
        ", burst capability, and number of wait states for the associated chip "
        "select.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_fb_cscr5
    },
    {
        "CSPMCR",
        "Controls the multiplexing of the FlexBus signals.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_fb_cspmcr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark FLEXIO_8SHIFT_8TIM_32PIN
#endif

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUF0.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbuf0[] =
{
    {
        "SHIFTBUF",
        "Shift buffer data is used for a variety of functions depending on the "
        "SMOD setting: For SMOD=Receive, Shifter data is transferred into SHIFT"
        "BUF at the expiration of Timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUF1.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbuf1[] =
{
    {
        "SHIFTBUF",
        "Shift buffer data is used for a variety of functions depending on the "
        "SMOD setting: For SMOD=Receive, Shifter data is transferred into SHIFT"
        "BUF at the expiration of Timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUF2.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbuf2[] =
{
    {
        "SHIFTBUF",
        "Shift buffer data is used for a variety of functions depending on the "
        "SMOD setting: For SMOD=Receive, Shifter data is transferred into SHIFT"
        "BUF at the expiration of Timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUF3.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbuf3[] =
{
    {
        "SHIFTBUF",
        "Shift buffer data is used for a variety of functions depending on the "
        "SMOD setting: For SMOD=Receive, Shifter data is transferred into SHIFT"
        "BUF at the expiration of Timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUF4.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbuf4[] =
{
    {
        "SHIFTBUF",
        "Shift buffer data is used for a variety of functions depending on the "
        "SMOD setting: For SMOD=Receive, Shifter data is transferred into SHIFT"
        "BUF at the expiration of Timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUF5.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbuf5[] =
{
    {
        "SHIFTBUF",
        "Shift buffer data is used for a variety of functions depending on the "
        "SMOD setting: For SMOD=Receive, Shifter data is transferred into SHIFT"
        "BUF at the expiration of Timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUF6.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbuf6[] =
{
    {
        "SHIFTBUF",
        "Shift buffer data is used for a variety of functions depending on the "
        "SMOD setting: For SMOD=Receive, Shifter data is transferred into SHIFT"
        "BUF at the expiration of Timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUF7.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbuf7[] =
{
    {
        "SHIFTBUF",
        "Shift buffer data is used for a variety of functions depending on the "
        "SMOD setting: For SMOD=Receive, Shifter data is transferred into SHIFT"
        "BUF at the expiration of Timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCFG0.
static const field_t hw_flexio_8shift_8tim_32pin_shiftcfg0[] =
{
    {
        "SSTART",
        "For SMOD=Transmit, this field allows automatic start bit insertion if "
        "the selected timer has also enabled a start bit.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSTOP",
        "For SMOD=Transmit, this field allows automatic stop bit insertion if t"
        "he selected timer has also enabled a stop bit.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INSRC",
        "Selects the input source for the shifter.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWIDTH",
        "For all Shifters, this register field configures the number of bits to"
        " be shifted on each Shift clock as follows: 1-bit shift for PWIDTH=0 4"
        "-bit shift for PWIDTH=1...3 8-bit shift for PWIDTH=4...7 16-bit shift "
        "for PWIDTH=8...15 32-bit shift for PWIDTH=16...31 For Shifters which s"
        "upport parallel transmit (SHIFTER0, SHIFTER4) or parallel receive (SHI"
        "FTER3, SHIFTER7), this register field, together with SHIFTCTL[PINSEL],"
        " also selects the pins to be driven or sampled on each Shift clock as "
        "follows: FXIO_D[PINSEL+PWIDTH]:FXIO_D[PINSEL] For SMOD=State, this fie"
        "ld is used to disable state outputs.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCFG1.
static const field_t hw_flexio_8shift_8tim_32pin_shiftcfg1[] =
{
    {
        "SSTART",
        "For SMOD=Transmit, this field allows automatic start bit insertion if "
        "the selected timer has also enabled a start bit.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSTOP",
        "For SMOD=Transmit, this field allows automatic stop bit insertion if t"
        "he selected timer has also enabled a stop bit.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INSRC",
        "Selects the input source for the shifter.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWIDTH",
        "For all Shifters, this register field configures the number of bits to"
        " be shifted on each Shift clock as follows: 1-bit shift for PWIDTH=0 4"
        "-bit shift for PWIDTH=1...3 8-bit shift for PWIDTH=4...7 16-bit shift "
        "for PWIDTH=8...15 32-bit shift for PWIDTH=16...31 For Shifters which s"
        "upport parallel transmit (SHIFTER0, SHIFTER4) or parallel receive (SHI"
        "FTER3, SHIFTER7), this register field, together with SHIFTCTL[PINSEL],"
        " also selects the pins to be driven or sampled on each Shift clock as "
        "follows: FXIO_D[PINSEL+PWIDTH]:FXIO_D[PINSEL] For SMOD=State, this fie"
        "ld is used to disable state outputs.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCFG2.
static const field_t hw_flexio_8shift_8tim_32pin_shiftcfg2[] =
{
    {
        "SSTART",
        "For SMOD=Transmit, this field allows automatic start bit insertion if "
        "the selected timer has also enabled a start bit.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSTOP",
        "For SMOD=Transmit, this field allows automatic stop bit insertion if t"
        "he selected timer has also enabled a stop bit.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INSRC",
        "Selects the input source for the shifter.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWIDTH",
        "For all Shifters, this register field configures the number of bits to"
        " be shifted on each Shift clock as follows: 1-bit shift for PWIDTH=0 4"
        "-bit shift for PWIDTH=1...3 8-bit shift for PWIDTH=4...7 16-bit shift "
        "for PWIDTH=8...15 32-bit shift for PWIDTH=16...31 For Shifters which s"
        "upport parallel transmit (SHIFTER0, SHIFTER4) or parallel receive (SHI"
        "FTER3, SHIFTER7), this register field, together with SHIFTCTL[PINSEL],"
        " also selects the pins to be driven or sampled on each Shift clock as "
        "follows: FXIO_D[PINSEL+PWIDTH]:FXIO_D[PINSEL] For SMOD=State, this fie"
        "ld is used to disable state outputs.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCFG3.
static const field_t hw_flexio_8shift_8tim_32pin_shiftcfg3[] =
{
    {
        "SSTART",
        "For SMOD=Transmit, this field allows automatic start bit insertion if "
        "the selected timer has also enabled a start bit.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSTOP",
        "For SMOD=Transmit, this field allows automatic stop bit insertion if t"
        "he selected timer has also enabled a stop bit.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INSRC",
        "Selects the input source for the shifter.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWIDTH",
        "For all Shifters, this register field configures the number of bits to"
        " be shifted on each Shift clock as follows: 1-bit shift for PWIDTH=0 4"
        "-bit shift for PWIDTH=1...3 8-bit shift for PWIDTH=4...7 16-bit shift "
        "for PWIDTH=8...15 32-bit shift for PWIDTH=16...31 For Shifters which s"
        "upport parallel transmit (SHIFTER0, SHIFTER4) or parallel receive (SHI"
        "FTER3, SHIFTER7), this register field, together with SHIFTCTL[PINSEL],"
        " also selects the pins to be driven or sampled on each Shift clock as "
        "follows: FXIO_D[PINSEL+PWIDTH]:FXIO_D[PINSEL] For SMOD=State, this fie"
        "ld is used to disable state outputs.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCFG4.
static const field_t hw_flexio_8shift_8tim_32pin_shiftcfg4[] =
{
    {
        "SSTART",
        "For SMOD=Transmit, this field allows automatic start bit insertion if "
        "the selected timer has also enabled a start bit.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSTOP",
        "For SMOD=Transmit, this field allows automatic stop bit insertion if t"
        "he selected timer has also enabled a stop bit.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INSRC",
        "Selects the input source for the shifter.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWIDTH",
        "For all Shifters, this register field configures the number of bits to"
        " be shifted on each Shift clock as follows: 1-bit shift for PWIDTH=0 4"
        "-bit shift for PWIDTH=1...3 8-bit shift for PWIDTH=4...7 16-bit shift "
        "for PWIDTH=8...15 32-bit shift for PWIDTH=16...31 For Shifters which s"
        "upport parallel transmit (SHIFTER0, SHIFTER4) or parallel receive (SHI"
        "FTER3, SHIFTER7), this register field, together with SHIFTCTL[PINSEL],"
        " also selects the pins to be driven or sampled on each Shift clock as "
        "follows: FXIO_D[PINSEL+PWIDTH]:FXIO_D[PINSEL] For SMOD=State, this fie"
        "ld is used to disable state outputs.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCFG5.
static const field_t hw_flexio_8shift_8tim_32pin_shiftcfg5[] =
{
    {
        "SSTART",
        "For SMOD=Transmit, this field allows automatic start bit insertion if "
        "the selected timer has also enabled a start bit.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSTOP",
        "For SMOD=Transmit, this field allows automatic stop bit insertion if t"
        "he selected timer has also enabled a stop bit.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INSRC",
        "Selects the input source for the shifter.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWIDTH",
        "For all Shifters, this register field configures the number of bits to"
        " be shifted on each Shift clock as follows: 1-bit shift for PWIDTH=0 4"
        "-bit shift for PWIDTH=1...3 8-bit shift for PWIDTH=4...7 16-bit shift "
        "for PWIDTH=8...15 32-bit shift for PWIDTH=16...31 For Shifters which s"
        "upport parallel transmit (SHIFTER0, SHIFTER4) or parallel receive (SHI"
        "FTER3, SHIFTER7), this register field, together with SHIFTCTL[PINSEL],"
        " also selects the pins to be driven or sampled on each Shift clock as "
        "follows: FXIO_D[PINSEL+PWIDTH]:FXIO_D[PINSEL] For SMOD=State, this fie"
        "ld is used to disable state outputs.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCFG6.
static const field_t hw_flexio_8shift_8tim_32pin_shiftcfg6[] =
{
    {
        "SSTART",
        "For SMOD=Transmit, this field allows automatic start bit insertion if "
        "the selected timer has also enabled a start bit.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSTOP",
        "For SMOD=Transmit, this field allows automatic stop bit insertion if t"
        "he selected timer has also enabled a stop bit.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INSRC",
        "Selects the input source for the shifter.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWIDTH",
        "For all Shifters, this register field configures the number of bits to"
        " be shifted on each Shift clock as follows: 1-bit shift for PWIDTH=0 4"
        "-bit shift for PWIDTH=1...3 8-bit shift for PWIDTH=4...7 16-bit shift "
        "for PWIDTH=8...15 32-bit shift for PWIDTH=16...31 For Shifters which s"
        "upport parallel transmit (SHIFTER0, SHIFTER4) or parallel receive (SHI"
        "FTER3, SHIFTER7), this register field, together with SHIFTCTL[PINSEL],"
        " also selects the pins to be driven or sampled on each Shift clock as "
        "follows: FXIO_D[PINSEL+PWIDTH]:FXIO_D[PINSEL] For SMOD=State, this fie"
        "ld is used to disable state outputs.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCFG7.
static const field_t hw_flexio_8shift_8tim_32pin_shiftcfg7[] =
{
    {
        "SSTART",
        "For SMOD=Transmit, this field allows automatic start bit insertion if "
        "the selected timer has also enabled a start bit.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSTOP",
        "For SMOD=Transmit, this field allows automatic stop bit insertion if t"
        "he selected timer has also enabled a stop bit.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INSRC",
        "Selects the input source for the shifter.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PWIDTH",
        "For all Shifters, this register field configures the number of bits to"
        " be shifted on each Shift clock as follows: 1-bit shift for PWIDTH=0 4"
        "-bit shift for PWIDTH=1...3 8-bit shift for PWIDTH=4...7 16-bit shift "
        "for PWIDTH=8...15 32-bit shift for PWIDTH=16...31 For Shifters which s"
        "upport parallel transmit (SHIFTER0, SHIFTER4) or parallel receive (SHI"
        "FTER3, SHIFTER7), this register field, together with SHIFTCTL[PINSEL],"
        " also selects the pins to be driven or sampled on each Shift clock as "
        "follows: FXIO_D[PINSEL+PWIDTH]:FXIO_D[PINSEL] For SMOD=State, this fie"
        "ld is used to disable state outputs.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCTL0.
static const field_t hw_flexio_8shift_8tim_32pin_timctl0[] =
{
    {
        "TIMOD",
        "In 8-bit baud counter mode, the lower 8-bits of the counter and compar"
        "e register are used to configure the baud rate of the timer shift cloc"
        "k, and the upper 8-bits are used to configure the shifter bit count.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Timer input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSRC",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSEL",
        "The valid values for TRGSEL will depend on the FLEXIO_PARAM register.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCTL1.
static const field_t hw_flexio_8shift_8tim_32pin_timctl1[] =
{
    {
        "TIMOD",
        "In 8-bit baud counter mode, the lower 8-bits of the counter and compar"
        "e register are used to configure the baud rate of the timer shift cloc"
        "k, and the upper 8-bits are used to configure the shifter bit count.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Timer input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSRC",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSEL",
        "The valid values for TRGSEL will depend on the FLEXIO_PARAM register.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCTL2.
static const field_t hw_flexio_8shift_8tim_32pin_timctl2[] =
{
    {
        "TIMOD",
        "In 8-bit baud counter mode, the lower 8-bits of the counter and compar"
        "e register are used to configure the baud rate of the timer shift cloc"
        "k, and the upper 8-bits are used to configure the shifter bit count.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Timer input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSRC",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSEL",
        "The valid values for TRGSEL will depend on the FLEXIO_PARAM register.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCTL3.
static const field_t hw_flexio_8shift_8tim_32pin_timctl3[] =
{
    {
        "TIMOD",
        "In 8-bit baud counter mode, the lower 8-bits of the counter and compar"
        "e register are used to configure the baud rate of the timer shift cloc"
        "k, and the upper 8-bits are used to configure the shifter bit count.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Timer input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSRC",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSEL",
        "The valid values for TRGSEL will depend on the FLEXIO_PARAM register.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCTL4.
static const field_t hw_flexio_8shift_8tim_32pin_timctl4[] =
{
    {
        "TIMOD",
        "In 8-bit baud counter mode, the lower 8-bits of the counter and compar"
        "e register are used to configure the baud rate of the timer shift cloc"
        "k, and the upper 8-bits are used to configure the shifter bit count.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Timer input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSRC",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSEL",
        "The valid values for TRGSEL will depend on the FLEXIO_PARAM register.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCTL5.
static const field_t hw_flexio_8shift_8tim_32pin_timctl5[] =
{
    {
        "TIMOD",
        "In 8-bit baud counter mode, the lower 8-bits of the counter and compar"
        "e register are used to configure the baud rate of the timer shift cloc"
        "k, and the upper 8-bits are used to configure the shifter bit count.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Timer input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSRC",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSEL",
        "The valid values for TRGSEL will depend on the FLEXIO_PARAM register.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCTL6.
static const field_t hw_flexio_8shift_8tim_32pin_timctl6[] =
{
    {
        "TIMOD",
        "In 8-bit baud counter mode, the lower 8-bits of the counter and compar"
        "e register are used to configure the baud rate of the timer shift cloc"
        "k, and the upper 8-bits are used to configure the shifter bit count.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Timer input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSRC",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSEL",
        "The valid values for TRGSEL will depend on the FLEXIO_PARAM register.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCTL7.
static const field_t hw_flexio_8shift_8tim_32pin_timctl7[] =
{
    {
        "TIMOD",
        "In 8-bit baud counter mode, the lower 8-bits of the counter and compar"
        "e register are used to configure the baud rate of the timer shift cloc"
        "k, and the upper 8-bits are used to configure the shifter bit count.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Timer input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSRC",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRGSEL",
        "The valid values for TRGSEL will depend on the FLEXIO_PARAM register.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCFG0.
static const field_t hw_flexio_8shift_8tim_32pin_timcfg0[] =
{
    {
        "TSTART",
        "When start bit is enabled, configured shifters will output the content"
        "s of the start bit when the timer is enabled and the timer counter wil"
        "l reload from the compare register on the first rising edge of the shi"
        "ft clock.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSTOP",
        "The stop bit can be added on a timer compare (between each word) or on"
        " a timer disable.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMENA",
        "Configures the condition that causes the Timer to be enabled and start"
        " decrementing.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDIS",
        "Configures the condition that causes the Timer to be disabled and stop"
        " decrementing.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMRST",
        "Configures the condition that causes the timer counter (and optionally"
        " the timer output) to be reset.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDEC",
        "Configures the source of the Timer decrement and the source of the Shi"
        "ft clock.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMOUT",
        "Configures the initial state of the Timer Output and whether it is aff"
        "ected by the Timer reset.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCFG1.
static const field_t hw_flexio_8shift_8tim_32pin_timcfg1[] =
{
    {
        "TSTART",
        "When start bit is enabled, configured shifters will output the content"
        "s of the start bit when the timer is enabled and the timer counter wil"
        "l reload from the compare register on the first rising edge of the shi"
        "ft clock.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSTOP",
        "The stop bit can be added on a timer compare (between each word) or on"
        " a timer disable.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMENA",
        "Configures the condition that causes the Timer to be enabled and start"
        " decrementing.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDIS",
        "Configures the condition that causes the Timer to be disabled and stop"
        " decrementing.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMRST",
        "Configures the condition that causes the timer counter (and optionally"
        " the timer output) to be reset.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDEC",
        "Configures the source of the Timer decrement and the source of the Shi"
        "ft clock.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMOUT",
        "Configures the initial state of the Timer Output and whether it is aff"
        "ected by the Timer reset.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCFG2.
static const field_t hw_flexio_8shift_8tim_32pin_timcfg2[] =
{
    {
        "TSTART",
        "When start bit is enabled, configured shifters will output the content"
        "s of the start bit when the timer is enabled and the timer counter wil"
        "l reload from the compare register on the first rising edge of the shi"
        "ft clock.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSTOP",
        "The stop bit can be added on a timer compare (between each word) or on"
        " a timer disable.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMENA",
        "Configures the condition that causes the Timer to be enabled and start"
        " decrementing.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDIS",
        "Configures the condition that causes the Timer to be disabled and stop"
        " decrementing.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMRST",
        "Configures the condition that causes the timer counter (and optionally"
        " the timer output) to be reset.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDEC",
        "Configures the source of the Timer decrement and the source of the Shi"
        "ft clock.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMOUT",
        "Configures the initial state of the Timer Output and whether it is aff"
        "ected by the Timer reset.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCFG3.
static const field_t hw_flexio_8shift_8tim_32pin_timcfg3[] =
{
    {
        "TSTART",
        "When start bit is enabled, configured shifters will output the content"
        "s of the start bit when the timer is enabled and the timer counter wil"
        "l reload from the compare register on the first rising edge of the shi"
        "ft clock.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSTOP",
        "The stop bit can be added on a timer compare (between each word) or on"
        " a timer disable.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMENA",
        "Configures the condition that causes the Timer to be enabled and start"
        " decrementing.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDIS",
        "Configures the condition that causes the Timer to be disabled and stop"
        " decrementing.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMRST",
        "Configures the condition that causes the timer counter (and optionally"
        " the timer output) to be reset.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDEC",
        "Configures the source of the Timer decrement and the source of the Shi"
        "ft clock.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMOUT",
        "Configures the initial state of the Timer Output and whether it is aff"
        "ected by the Timer reset.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCFG4.
static const field_t hw_flexio_8shift_8tim_32pin_timcfg4[] =
{
    {
        "TSTART",
        "When start bit is enabled, configured shifters will output the content"
        "s of the start bit when the timer is enabled and the timer counter wil"
        "l reload from the compare register on the first rising edge of the shi"
        "ft clock.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSTOP",
        "The stop bit can be added on a timer compare (between each word) or on"
        " a timer disable.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMENA",
        "Configures the condition that causes the Timer to be enabled and start"
        " decrementing.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDIS",
        "Configures the condition that causes the Timer to be disabled and stop"
        " decrementing.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMRST",
        "Configures the condition that causes the timer counter (and optionally"
        " the timer output) to be reset.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDEC",
        "Configures the source of the Timer decrement and the source of the Shi"
        "ft clock.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMOUT",
        "Configures the initial state of the Timer Output and whether it is aff"
        "ected by the Timer reset.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCFG5.
static const field_t hw_flexio_8shift_8tim_32pin_timcfg5[] =
{
    {
        "TSTART",
        "When start bit is enabled, configured shifters will output the content"
        "s of the start bit when the timer is enabled and the timer counter wil"
        "l reload from the compare register on the first rising edge of the shi"
        "ft clock.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSTOP",
        "The stop bit can be added on a timer compare (between each word) or on"
        " a timer disable.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMENA",
        "Configures the condition that causes the Timer to be enabled and start"
        " decrementing.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDIS",
        "Configures the condition that causes the Timer to be disabled and stop"
        " decrementing.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMRST",
        "Configures the condition that causes the timer counter (and optionally"
        " the timer output) to be reset.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDEC",
        "Configures the source of the Timer decrement and the source of the Shi"
        "ft clock.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMOUT",
        "Configures the initial state of the Timer Output and whether it is aff"
        "ected by the Timer reset.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCFG6.
static const field_t hw_flexio_8shift_8tim_32pin_timcfg6[] =
{
    {
        "TSTART",
        "When start bit is enabled, configured shifters will output the content"
        "s of the start bit when the timer is enabled and the timer counter wil"
        "l reload from the compare register on the first rising edge of the shi"
        "ft clock.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSTOP",
        "The stop bit can be added on a timer compare (between each word) or on"
        " a timer disable.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMENA",
        "Configures the condition that causes the Timer to be enabled and start"
        " decrementing.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDIS",
        "Configures the condition that causes the Timer to be disabled and stop"
        " decrementing.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMRST",
        "Configures the condition that causes the timer counter (and optionally"
        " the timer output) to be reset.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDEC",
        "Configures the source of the Timer decrement and the source of the Shi"
        "ft clock.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMOUT",
        "Configures the initial state of the Timer Output and whether it is aff"
        "ected by the Timer reset.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCFG7.
static const field_t hw_flexio_8shift_8tim_32pin_timcfg7[] =
{
    {
        "TSTART",
        "When start bit is enabled, configured shifters will output the content"
        "s of the start bit when the timer is enabled and the timer counter wil"
        "l reload from the compare register on the first rising edge of the shi"
        "ft clock.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSTOP",
        "The stop bit can be added on a timer compare (between each word) or on"
        " a timer disable.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMENA",
        "Configures the condition that causes the Timer to be enabled and start"
        " decrementing.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDIS",
        "Configures the condition that causes the Timer to be disabled and stop"
        " decrementing.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMRST",
        "Configures the condition that causes the timer counter (and optionally"
        " the timer output) to be reset.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMDEC",
        "Configures the source of the Timer decrement and the source of the Shi"
        "ft clock.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMOUT",
        "Configures the initial state of the Timer Output and whether it is aff"
        "ected by the Timer reset.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCMP0.
static const field_t hw_flexio_8shift_8tim_32pin_timcmp0[] =
{
    {
        "CMP",
        "The timer compare value is loaded into the timer counter when the time"
        "r is first enabled, when the timer is reset and when the timer decreme"
        "nts down to zero.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCMP1.
static const field_t hw_flexio_8shift_8tim_32pin_timcmp1[] =
{
    {
        "CMP",
        "The timer compare value is loaded into the timer counter when the time"
        "r is first enabled, when the timer is reset and when the timer decreme"
        "nts down to zero.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCMP2.
static const field_t hw_flexio_8shift_8tim_32pin_timcmp2[] =
{
    {
        "CMP",
        "The timer compare value is loaded into the timer counter when the time"
        "r is first enabled, when the timer is reset and when the timer decreme"
        "nts down to zero.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCMP3.
static const field_t hw_flexio_8shift_8tim_32pin_timcmp3[] =
{
    {
        "CMP",
        "The timer compare value is loaded into the timer counter when the time"
        "r is first enabled, when the timer is reset and when the timer decreme"
        "nts down to zero.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCMP4.
static const field_t hw_flexio_8shift_8tim_32pin_timcmp4[] =
{
    {
        "CMP",
        "The timer compare value is loaded into the timer counter when the time"
        "r is first enabled, when the timer is reset and when the timer decreme"
        "nts down to zero.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCMP5.
static const field_t hw_flexio_8shift_8tim_32pin_timcmp5[] =
{
    {
        "CMP",
        "The timer compare value is loaded into the timer counter when the time"
        "r is first enabled, when the timer is reset and when the timer decreme"
        "nts down to zero.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCMP6.
static const field_t hw_flexio_8shift_8tim_32pin_timcmp6[] =
{
    {
        "CMP",
        "The timer compare value is loaded into the timer counter when the time"
        "r is first enabled, when the timer is reset and when the timer decreme"
        "nts down to zero.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMCMP7.
static const field_t hw_flexio_8shift_8tim_32pin_timcmp7[] =
{
    {
        "CMP",
        "The timer compare value is loaded into the timer counter when the time"
        "r is first enabled, when the timer is reset and when the timer decreme"
        "nts down to zero.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_CTRL.
static const field_t hw_flexio_8shift_8tim_32pin_ctrl[] =
{
    {
        "FLEXEN",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWRST",
        "The FlexIO Control Register is not affected by the software reset, all"
        " other logic in the FlexIO is affected by the software reset and regis"
        "ter accesses are ignored until this bit is cleared.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FASTACC",
        "Enables fast register accesses to FlexIO registers, but requires the F"
        "lexIO functional clock to be at least twice the frequency of the bus c"
        "lock.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGE",
        "Enables FlexIO operation in Debug mode.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOZEN",
        "Disables FlexIO operation in Doze modes.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTSTAT.
static const field_t hw_flexio_8shift_8tim_32pin_shiftstat[] =
{
    {
        "SSF",
        "The shifter status flag is updated when one of the following events oc"
        "curs: For SMOD=Receive, the status flag is set when SHIFTBUF has been "
        "loaded with data from Shifter (SHIFTBUF is full), and the status flag "
        "is cleared when SHIFTBUF register is read.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMSTAT.
static const field_t hw_flexio_8shift_8tim_32pin_timstat[] =
{
    {
        "TSF",
        "The timer status flag sets depending on the timer mode, and can be cle"
        "ared by writing logic one to the flag.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTERR.
static const field_t hw_flexio_8shift_8tim_32pin_shifterr[] =
{
    {
        "SEF",
        "The shifter error flag is set when one of the following events occurs:"
        " For SMOD=Receive, indicates Shifter was ready to store new data into "
        "SHIFTBUF before the previous data was read from SHIFTBUF (SHIFTBUF Ove"
        "rrun), or indicates that the received start or stop bit does not match"
        " the expected value.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBBS0.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbbs0[] =
{
    {
        "SHIFTBUFBBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBBS1.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbbs1[] =
{
    {
        "SHIFTBUFBBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBBS2.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbbs2[] =
{
    {
        "SHIFTBUFBBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBBS3.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbbs3[] =
{
    {
        "SHIFTBUFBBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBBS4.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbbs4[] =
{
    {
        "SHIFTBUFBBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBBS5.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbbs5[] =
{
    {
        "SHIFTBUFBBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBBS6.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbbs6[] =
{
    {
        "SHIFTBUFBBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBBS7.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbbs7[] =
{
    {
        "SHIFTBUFBBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCTL0.
static const field_t hw_flexio_8shift_8tim_32pin_shiftctl0[] =
{
    {
        "SMOD",
        "Configures the mode of the Shifter.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Shifter input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMSEL",
        "Selects which Timer is used for controlling the logic/shift register a"
        "nd generating the Shift clock.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCTL1.
static const field_t hw_flexio_8shift_8tim_32pin_shiftctl1[] =
{
    {
        "SMOD",
        "Configures the mode of the Shifter.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Shifter input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMSEL",
        "Selects which Timer is used for controlling the logic/shift register a"
        "nd generating the Shift clock.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCTL2.
static const field_t hw_flexio_8shift_8tim_32pin_shiftctl2[] =
{
    {
        "SMOD",
        "Configures the mode of the Shifter.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Shifter input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMSEL",
        "Selects which Timer is used for controlling the logic/shift register a"
        "nd generating the Shift clock.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCTL3.
static const field_t hw_flexio_8shift_8tim_32pin_shiftctl3[] =
{
    {
        "SMOD",
        "Configures the mode of the Shifter.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Shifter input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMSEL",
        "Selects which Timer is used for controlling the logic/shift register a"
        "nd generating the Shift clock.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCTL4.
static const field_t hw_flexio_8shift_8tim_32pin_shiftctl4[] =
{
    {
        "SMOD",
        "Configures the mode of the Shifter.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Shifter input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMSEL",
        "Selects which Timer is used for controlling the logic/shift register a"
        "nd generating the Shift clock.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCTL5.
static const field_t hw_flexio_8shift_8tim_32pin_shiftctl5[] =
{
    {
        "SMOD",
        "Configures the mode of the Shifter.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Shifter input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMSEL",
        "Selects which Timer is used for controlling the logic/shift register a"
        "nd generating the Shift clock.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCTL6.
static const field_t hw_flexio_8shift_8tim_32pin_shiftctl6[] =
{
    {
        "SMOD",
        "Configures the mode of the Shifter.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Shifter input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMSEL",
        "Selects which Timer is used for controlling the logic/shift register a"
        "nd generating the Shift clock.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTCTL7.
static const field_t hw_flexio_8shift_8tim_32pin_shiftctl7[] =
{
    {
        "SMOD",
        "Configures the mode of the Shifter.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPOL",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINSEL",
        "Selects which pin is used by the Shifter input or output.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINCFG",
        "",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMPOL",
        "",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMSEL",
        "Selects which Timer is used for controlling the logic/shift register a"
        "nd generating the Shift clock.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_VERID.
static const field_t hw_flexio_8shift_8tim_32pin_verid[] =
{
    {
        "FEATURE",
        "This read only field returns the feature set number.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "This read only field returns the minor version number for the module s"
        "pecification.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "This read only field returns the major version number for the module s"
        "pecification.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_PARAM.
static const field_t hw_flexio_8shift_8tim_32pin_param[] =
{
    {
        "SHIFTER",
        "Number of Shifters implemented.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TIMER",
        "Number of Timers implemented.",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PIN",
        "Number of Pins implemented.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TRIGGER",
        "Number of external triggers implemented.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_TIMIEN.
static const field_t hw_flexio_8shift_8tim_32pin_timien[] =
{
    {
        "TEIE",
        "Enables interrupt generation when corresponding TSF is set.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTSIEN.
static const field_t hw_flexio_8shift_8tim_32pin_shiftsien[] =
{
    {
        "SSIE",
        "Enables interrupt generation when corresponding SSF is set.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTEIEN.
static const field_t hw_flexio_8shift_8tim_32pin_shifteien[] =
{
    {
        "SEIE",
        "Enables interrupt generation when corresponding SEF is set.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTSDEN.
static const field_t hw_flexio_8shift_8tim_32pin_shiftsden[] =
{
    {
        "SSDE",
        "Enables DMA request generation when corresponding SSF is set.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBYS0.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbys0[] =
{
    {
        "SHIFTBUFBYS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "yte swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBYS1.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbys1[] =
{
    {
        "SHIFTBUFBYS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "yte swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBYS2.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbys2[] =
{
    {
        "SHIFTBUFBYS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "yte swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBYS3.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbys3[] =
{
    {
        "SHIFTBUFBYS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "yte swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBYS4.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbys4[] =
{
    {
        "SHIFTBUFBYS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "yte swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBYS5.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbys5[] =
{
    {
        "SHIFTBUFBYS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "yte swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBYS6.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbys6[] =
{
    {
        "SHIFTBUFBYS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "yte swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBYS7.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbys7[] =
{
    {
        "SHIFTBUFBYS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "yte swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBIS0.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbis0[] =
{
    {
        "SHIFTBUFBIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBIS1.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbis1[] =
{
    {
        "SHIFTBUFBIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBIS2.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbis2[] =
{
    {
        "SHIFTBUFBIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBIS3.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbis3[] =
{
    {
        "SHIFTBUFBIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBIS4.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbis4[] =
{
    {
        "SHIFTBUFBIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBIS5.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbis5[] =
{
    {
        "SHIFTBUFBIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBIS6.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbis6[] =
{
    {
        "SHIFTBUFBIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFBIS7.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufbis7[] =
{
    {
        "SHIFTBUFBIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are b"
        "it swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_PIN.
static const field_t hw_flexio_8shift_8tim_32pin_pin[] =
{
    {
        "PDI",
        "Returns the input data on each of the FlexIO pins.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFHWS0.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufhws0[] =
{
    {
        "SHIFTBUFHWS",
        "Alias to SHIFTBUF register, except reads/writes to this register are h"
        "alf word swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFHWS1.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufhws1[] =
{
    {
        "SHIFTBUFHWS",
        "Alias to SHIFTBUF register, except reads/writes to this register are h"
        "alf word swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFHWS2.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufhws2[] =
{
    {
        "SHIFTBUFHWS",
        "Alias to SHIFTBUF register, except reads/writes to this register are h"
        "alf word swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFHWS3.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufhws3[] =
{
    {
        "SHIFTBUFHWS",
        "Alias to SHIFTBUF register, except reads/writes to this register are h"
        "alf word swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFHWS4.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufhws4[] =
{
    {
        "SHIFTBUFHWS",
        "Alias to SHIFTBUF register, except reads/writes to this register are h"
        "alf word swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFHWS5.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufhws5[] =
{
    {
        "SHIFTBUFHWS",
        "Alias to SHIFTBUF register, except reads/writes to this register are h"
        "alf word swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFHWS6.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufhws6[] =
{
    {
        "SHIFTBUFHWS",
        "Alias to SHIFTBUF register, except reads/writes to this register are h"
        "alf word swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFHWS7.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufhws7[] =
{
    {
        "SHIFTBUFHWS",
        "Alias to SHIFTBUF register, except reads/writes to this register are h"
        "alf word swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNIS0.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnis0[] =
{
    {
        "SHIFTBUFNIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNIS1.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnis1[] =
{
    {
        "SHIFTBUFNIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNIS2.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnis2[] =
{
    {
        "SHIFTBUFNIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNIS3.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnis3[] =
{
    {
        "SHIFTBUFNIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNIS4.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnis4[] =
{
    {
        "SHIFTBUFNIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNIS5.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnis5[] =
{
    {
        "SHIFTBUFNIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNIS6.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnis6[] =
{
    {
        "SHIFTBUFNIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNIS7.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnis7[] =
{
    {
        "SHIFTBUFNIS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNBS0.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnbs0[] =
{
    {
        "SHIFTBUFNBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNBS1.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnbs1[] =
{
    {
        "SHIFTBUFNBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNBS2.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnbs2[] =
{
    {
        "SHIFTBUFNBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNBS3.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnbs3[] =
{
    {
        "SHIFTBUFNBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNBS4.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnbs4[] =
{
    {
        "SHIFTBUFNBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNBS5.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnbs5[] =
{
    {
        "SHIFTBUFNBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNBS6.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnbs6[] =
{
    {
        "SHIFTBUFNBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTBUFNBS7.
static const field_t hw_flexio_8shift_8tim_32pin_shiftbufnbs7[] =
{
    {
        "SHIFTBUFNBS",
        "Alias to SHIFTBUF register, except reads/writes to this register are n"
        "ibble swapped within each byte.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXIO_8SHIFT_8TIM_32PIN_SHIFTSTATE.
static const field_t hw_flexio_8shift_8tim_32pin_shiftstate[] =
{
    {
        "STATE",
        "The current state field maintains a pointer to keep track of the curre"
        "nt Shifter (configured for State mode) enabled to drive outputs and co"
        "mpute the next state.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a FLEXIO_8SHIFT_8TIM_32PIN module.
static const reg_t hw_flexio_8shift_8tim_32pin[] =
{
    {
        "SHIFTBUF0",
        "",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbuf0
    },
    {
        "SHIFTBUF1",
        "",
        4, // Width in bytes
        0x00000204, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbuf1
    },
    {
        "SHIFTBUF2",
        "",
        4, // Width in bytes
        0x00000208, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbuf2
    },
    {
        "SHIFTBUF3",
        "",
        4, // Width in bytes
        0x0000020c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbuf3
    },
    {
        "SHIFTBUF4",
        "",
        4, // Width in bytes
        0x00000210, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbuf4
    },
    {
        "SHIFTBUF5",
        "",
        4, // Width in bytes
        0x00000214, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbuf5
    },
    {
        "SHIFTBUF6",
        "",
        4, // Width in bytes
        0x00000218, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbuf6
    },
    {
        "SHIFTBUF7",
        "",
        4, // Width in bytes
        0x0000021c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbuf7
    },
    {
        "SHIFTCFG0",
        "",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftcfg0
    },
    {
        "SHIFTCFG1",
        "",
        4, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftcfg1
    },
    {
        "SHIFTCFG2",
        "",
        4, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftcfg2
    },
    {
        "SHIFTCFG3",
        "",
        4, // Width in bytes
        0x0000010c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftcfg3
    },
    {
        "SHIFTCFG4",
        "",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftcfg4
    },
    {
        "SHIFTCFG5",
        "",
        4, // Width in bytes
        0x00000114, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftcfg5
    },
    {
        "SHIFTCFG6",
        "",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftcfg6
    },
    {
        "SHIFTCFG7",
        "",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftcfg7
    },
    {
        "TIMCTL0",
        "",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timctl0
    },
    {
        "TIMCTL1",
        "",
        4, // Width in bytes
        0x00000404, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timctl1
    },
    {
        "TIMCTL2",
        "",
        4, // Width in bytes
        0x00000408, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timctl2
    },
    {
        "TIMCTL3",
        "",
        4, // Width in bytes
        0x0000040c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timctl3
    },
    {
        "TIMCTL4",
        "",
        4, // Width in bytes
        0x00000410, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timctl4
    },
    {
        "TIMCTL5",
        "",
        4, // Width in bytes
        0x00000414, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timctl5
    },
    {
        "TIMCTL6",
        "",
        4, // Width in bytes
        0x00000418, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timctl6
    },
    {
        "TIMCTL7",
        "",
        4, // Width in bytes
        0x0000041c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timctl7
    },
    {
        "TIMCFG0",
        "The options to enable or disable the timer using the Timer N-1 enable "
        "or disable are reserved when N is evenly divisible by 4 (eg: Timer 0).",
        4, // Width in bytes
        0x00000480, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcfg0
    },
    {
        "TIMCFG1",
        "The options to enable or disable the timer using the Timer N-1 enable "
        "or disable are reserved when N is evenly divisible by 4 (eg: Timer 0).",
        4, // Width in bytes
        0x00000484, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcfg1
    },
    {
        "TIMCFG2",
        "The options to enable or disable the timer using the Timer N-1 enable "
        "or disable are reserved when N is evenly divisible by 4 (eg: Timer 0).",
        4, // Width in bytes
        0x00000488, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcfg2
    },
    {
        "TIMCFG3",
        "The options to enable or disable the timer using the Timer N-1 enable "
        "or disable are reserved when N is evenly divisible by 4 (eg: Timer 0).",
        4, // Width in bytes
        0x0000048c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcfg3
    },
    {
        "TIMCFG4",
        "The options to enable or disable the timer using the Timer N-1 enable "
        "or disable are reserved when N is evenly divisible by 4 (eg: Timer 0).",
        4, // Width in bytes
        0x00000490, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcfg4
    },
    {
        "TIMCFG5",
        "The options to enable or disable the timer using the Timer N-1 enable "
        "or disable are reserved when N is evenly divisible by 4 (eg: Timer 0).",
        4, // Width in bytes
        0x00000494, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcfg5
    },
    {
        "TIMCFG6",
        "The options to enable or disable the timer using the Timer N-1 enable "
        "or disable are reserved when N is evenly divisible by 4 (eg: Timer 0).",
        4, // Width in bytes
        0x00000498, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcfg6
    },
    {
        "TIMCFG7",
        "The options to enable or disable the timer using the Timer N-1 enable "
        "or disable are reserved when N is evenly divisible by 4 (eg: Timer 0).",
        4, // Width in bytes
        0x0000049c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcfg7
    },
    {
        "TIMCMP0",
        "",
        4, // Width in bytes
        0x00000500, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcmp0
    },
    {
        "TIMCMP1",
        "",
        4, // Width in bytes
        0x00000504, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcmp1
    },
    {
        "TIMCMP2",
        "",
        4, // Width in bytes
        0x00000508, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcmp2
    },
    {
        "TIMCMP3",
        "",
        4, // Width in bytes
        0x0000050c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcmp3
    },
    {
        "TIMCMP4",
        "",
        4, // Width in bytes
        0x00000510, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcmp4
    },
    {
        "TIMCMP5",
        "",
        4, // Width in bytes
        0x00000514, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcmp5
    },
    {
        "TIMCMP6",
        "",
        4, // Width in bytes
        0x00000518, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcmp6
    },
    {
        "TIMCMP7",
        "",
        4, // Width in bytes
        0x0000051c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timcmp7
    },
    {
        "CTRL",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_ctrl
    },
    {
        "SHIFTSTAT",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftstat
    },
    {
        "TIMSTAT",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timstat
    },
    {
        "SHIFTERR",
        "",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shifterr
    },
    {
        "SHIFTBUFBBS0",
        "",
        4, // Width in bytes
        0x00000380, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbbs0
    },
    {
        "SHIFTBUFBBS1",
        "",
        4, // Width in bytes
        0x00000384, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbbs1
    },
    {
        "SHIFTBUFBBS2",
        "",
        4, // Width in bytes
        0x00000388, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbbs2
    },
    {
        "SHIFTBUFBBS3",
        "",
        4, // Width in bytes
        0x0000038c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbbs3
    },
    {
        "SHIFTBUFBBS4",
        "",
        4, // Width in bytes
        0x00000390, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbbs4
    },
    {
        "SHIFTBUFBBS5",
        "",
        4, // Width in bytes
        0x00000394, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbbs5
    },
    {
        "SHIFTBUFBBS6",
        "",
        4, // Width in bytes
        0x00000398, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbbs6
    },
    {
        "SHIFTBUFBBS7",
        "",
        4, // Width in bytes
        0x0000039c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbbs7
    },
    {
        "SHIFTCTL0",
        "",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftctl0
    },
    {
        "SHIFTCTL1",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftctl1
    },
    {
        "SHIFTCTL2",
        "",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftctl2
    },
    {
        "SHIFTCTL3",
        "",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftctl3
    },
    {
        "SHIFTCTL4",
        "",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftctl4
    },
    {
        "SHIFTCTL5",
        "",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftctl5
    },
    {
        "SHIFTCTL6",
        "",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftctl6
    },
    {
        "SHIFTCTL7",
        "",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftctl7
    },
    {
        "VERID",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_verid
    },
    {
        "PARAM",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_param
    },
    {
        "TIMIEN",
        "",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_timien
    },
    {
        "SHIFTSIEN",
        "",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftsien
    },
    {
        "SHIFTEIEN",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shifteien
    },
    {
        "SHIFTSDEN",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftsden
    },
    {
        "SHIFTBUFBYS0",
        "",
        4, // Width in bytes
        0x00000300, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbys0
    },
    {
        "SHIFTBUFBYS1",
        "",
        4, // Width in bytes
        0x00000304, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbys1
    },
    {
        "SHIFTBUFBYS2",
        "",
        4, // Width in bytes
        0x00000308, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbys2
    },
    {
        "SHIFTBUFBYS3",
        "",
        4, // Width in bytes
        0x0000030c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbys3
    },
    {
        "SHIFTBUFBYS4",
        "",
        4, // Width in bytes
        0x00000310, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbys4
    },
    {
        "SHIFTBUFBYS5",
        "",
        4, // Width in bytes
        0x00000314, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbys5
    },
    {
        "SHIFTBUFBYS6",
        "",
        4, // Width in bytes
        0x00000318, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbys6
    },
    {
        "SHIFTBUFBYS7",
        "",
        4, // Width in bytes
        0x0000031c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbys7
    },
    {
        "SHIFTBUFBIS0",
        "",
        4, // Width in bytes
        0x00000280, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbis0
    },
    {
        "SHIFTBUFBIS1",
        "",
        4, // Width in bytes
        0x00000284, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbis1
    },
    {
        "SHIFTBUFBIS2",
        "",
        4, // Width in bytes
        0x00000288, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbis2
    },
    {
        "SHIFTBUFBIS3",
        "",
        4, // Width in bytes
        0x0000028c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbis3
    },
    {
        "SHIFTBUFBIS4",
        "",
        4, // Width in bytes
        0x00000290, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbis4
    },
    {
        "SHIFTBUFBIS5",
        "",
        4, // Width in bytes
        0x00000294, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbis5
    },
    {
        "SHIFTBUFBIS6",
        "",
        4, // Width in bytes
        0x00000298, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbis6
    },
    {
        "SHIFTBUFBIS7",
        "",
        4, // Width in bytes
        0x0000029c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufbis7
    },
    {
        "PIN",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_pin
    },
    {
        "SHIFTBUFHWS0",
        "",
        4, // Width in bytes
        0x00000700, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufhws0
    },
    {
        "SHIFTBUFHWS1",
        "",
        4, // Width in bytes
        0x00000704, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufhws1
    },
    {
        "SHIFTBUFHWS2",
        "",
        4, // Width in bytes
        0x00000708, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufhws2
    },
    {
        "SHIFTBUFHWS3",
        "",
        4, // Width in bytes
        0x0000070c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufhws3
    },
    {
        "SHIFTBUFHWS4",
        "",
        4, // Width in bytes
        0x00000710, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufhws4
    },
    {
        "SHIFTBUFHWS5",
        "",
        4, // Width in bytes
        0x00000714, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufhws5
    },
    {
        "SHIFTBUFHWS6",
        "",
        4, // Width in bytes
        0x00000718, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufhws6
    },
    {
        "SHIFTBUFHWS7",
        "",
        4, // Width in bytes
        0x0000071c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufhws7
    },
    {
        "SHIFTBUFNIS0",
        "",
        4, // Width in bytes
        0x00000780, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnis0
    },
    {
        "SHIFTBUFNIS1",
        "",
        4, // Width in bytes
        0x00000784, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnis1
    },
    {
        "SHIFTBUFNIS2",
        "",
        4, // Width in bytes
        0x00000788, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnis2
    },
    {
        "SHIFTBUFNIS3",
        "",
        4, // Width in bytes
        0x0000078c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnis3
    },
    {
        "SHIFTBUFNIS4",
        "",
        4, // Width in bytes
        0x00000790, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnis4
    },
    {
        "SHIFTBUFNIS5",
        "",
        4, // Width in bytes
        0x00000794, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnis5
    },
    {
        "SHIFTBUFNIS6",
        "",
        4, // Width in bytes
        0x00000798, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnis6
    },
    {
        "SHIFTBUFNIS7",
        "",
        4, // Width in bytes
        0x0000079c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnis7
    },
    {
        "SHIFTBUFNBS0",
        "",
        4, // Width in bytes
        0x00000680, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnbs0
    },
    {
        "SHIFTBUFNBS1",
        "",
        4, // Width in bytes
        0x00000684, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnbs1
    },
    {
        "SHIFTBUFNBS2",
        "",
        4, // Width in bytes
        0x00000688, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnbs2
    },
    {
        "SHIFTBUFNBS3",
        "",
        4, // Width in bytes
        0x0000068c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnbs3
    },
    {
        "SHIFTBUFNBS4",
        "",
        4, // Width in bytes
        0x00000690, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnbs4
    },
    {
        "SHIFTBUFNBS5",
        "",
        4, // Width in bytes
        0x00000694, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnbs5
    },
    {
        "SHIFTBUFNBS6",
        "",
        4, // Width in bytes
        0x00000698, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnbs6
    },
    {
        "SHIFTBUFNBS7",
        "",
        4, // Width in bytes
        0x0000069c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftbufnbs7
    },
    {
        "SHIFTSTATE",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexio_8shift_8tim_32pin_shiftstate
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPIO
#endif

// Bitfields in register GPIO_PDOR.
static const field_t hw_gpio_pdor[] =
{
    {
        "PDO",
        "Register bits for unbonded pins return an undefined value when read.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_PSOR.
static const field_t hw_gpio_psor[] =
{
    {
        "PTSO",
        "Writing to this register updates the contents of the corresponding bit"
        " in the PDOR as follows: 0b - Corresponding bit in PDORn does not chan"
        "ge.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_PCOR.
static const field_t hw_gpio_pcor[] =
{
    {
        "PTCO",
        "Writing to this register updates the contents of the corresponding bit"
        " in the Port Data Output Register (PDOR) as follows: 0b - Correspondin"
        "g bit in PDORn does not change.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_PTOR.
static const field_t hw_gpio_ptor[] =
{
    {
        "PTTO",
        "Writing to this register updates the contents of the corresponding bit"
        " in the PDOR as follows: 0b - Corresponding bit in PDORn does not chan"
        "ge.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_PDIR.
static const field_t hw_gpio_pdir[] =
{
    {
        "PDI",
        "Reads 0 at the unimplemented pins for a particular device.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_PDDR.
static const field_t hw_gpio_pddr[] =
{
    {
        "PDD",
        "Configures individual port pins for input or output.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_GACR.
static const field_t hw_gpio_gacr[] =
{
    {
        "ACB0",
        "This 3 bit field defines the attributes required to access the corresp"
        "onding GPIO port's programming model.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROB0",
        "This register bit provides a mechanism to \"lock\" the configuration s"
        "tate defined by ACB0.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACB1",
        "This 3 bit field defines the attributes required to access the corresp"
        "onding GPIO port's programming model.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROB1",
        "This register bit provides a mechanism to \"lock\" the configuration s"
        "tate defined by ACB1.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACB2",
        "This 3 bit field defines the attributes required to access the corresp"
        "onding GPIO port's programming model.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROB2",
        "This register bit provides a mechanism to \"lock\" the configuration s"
        "tate defined by ACB2.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACB3",
        "This 3 bit field defines the attributes required to access the corresp"
        "onding GPIO port's programming model.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROB3",
        "This register bit provides a mechanism to \"lock\" the configuration s"
        "tate defined by ACB3.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPIO module.
static const reg_t hw_gpio[] =
{
    {
        "PDOR",
        "This register configures the logic levels that are driven on each gene"
        "ral-purpose output pin.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_pdor
    },
    {
        "PSOR",
        "This register configures whether to set the fields of the PDOR.",
        4, // Width in bytes
        0x00000004, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_psor
    },
    {
        "PCOR",
        "This register configures whether to clear the fields of PDOR.",
        4, // Width in bytes
        0x00000008, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_pcor
    },
    {
        "PTOR",
        "This register toggles the logic levels that are driven on each general"
        "-purpose output pin.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_ptor
    },
    {
        "PDIR",
        "This register captures the logic levels that are driven into each gene"
        "ral-purpose input pin.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpio_pdir
    },
    {
        "PDDR",
        "The PDDR configures the individual port pins for input or output.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_pddr
    },
    {
        "GACR",
        "The GPIO module supports a device-specific number of data ports, organ"
        "ized as 32-bit words.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_gpio_gacr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark SAI_2CH
#endif

// Bitfields in register SAI_2CH_TCSR.
static const field_t hw_sai_2ch_tcsr[] =
{
    {
        "FRDE",
        "Enables/disables DMA requests.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWDE",
        "Enables/disables DMA requests.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRIE",
        "Enables/disables FIFO request interrupts.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWIE",
        "Enables/disables FIFO warning interrupts.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FEIE",
        "Enables/disables FIFO error interrupts.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEIE",
        "Enables/disables sync error interrupts.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSIE",
        "Enables/disables word start interrupts.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRF",
        "Indicates that the number of words in an enabled transmit channel FIFO"
        " is less than or equal to the transmit FIFO watermark.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FWF",
        "Indicates that an enabled transmit FIFO is empty.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FEF",
        "Indicates that an enabled transmit FIFO has underrun.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEF",
        "Indicates that an error in the externally-generated frame sync has bee"
        "n detected.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSF",
        "Indicates that the start of the configured word has been detected.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SR",
        "When set, resets the internal transmitter logic including the FIFO poi"
        "nters.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FR",
        "Resets the FIFO pointers.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "BCE",
        "Enables the transmit bit clock, separately from the TE.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGE",
        "Enables/disables transmitter operation in Debug mode.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPE",
        "Configures transmitter operation in Stop mode.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE",
        "Enables/disables the transmitter.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_TCR1.
static const field_t hw_sai_2ch_tcr1[] =
{
    {
        "TFW",
        "Configures the watermark level for all enabled transmit channels.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_TCR2.
static const field_t hw_sai_2ch_tcr2[] =
{
    {
        "DIV",
        "Divides down the audio master clock to generate the bit clock when con"
        "figured for an internal bit clock.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Configures the direction of the bit clock.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCP",
        "Configures the polarity of the bit clock.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MSEL",
        "Selects the audio Master Clock option used to generate an internally g"
        "enerated bit clock.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCI",
        "When this field is set and using an internally generated bit clock in "
        "either synchronous or asynchronous mode, the bit clock actually used b"
        "y the transmitter is delayed by the pad output delay (the transmitter "
        "is clocked by the pad input as if the clock was externally generated).",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "This field swaps the bit clock used by the transmitter.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYNC",
        "Configures between asynchronous and synchronous modes of operation.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_TCR3.
static const field_t hw_sai_2ch_tcr3[] =
{
    {
        "WDFL",
        "Configures which word sets the start of word flag.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE",
        "Enables the corresponding data channel for transmit operation.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CFR",
        "Resets the FIFO pointers for a specific channel.",
        24, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_TCR4.
static const field_t hw_sai_2ch_tcr4[] =
{
    {
        "FSD",
        "Configures the direction of the frame sync.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSP",
        "Configures the polarity of the frame sync.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ONDEM",
        "When set, and the frame sync is generated internally, a frame sync is "
        "only generated when the FIFO warning flag is clear.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MF",
        "Configures whether the LSB or the MSB is transmitted first.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYWD",
        "Configures the length of the frame sync in number of bit clocks.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRSZ",
        "Configures the number of words in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FPACK",
        "Enables packing of 8-bit data or 16-bit data into each 32-bit FIFO wor"
        "d.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCOMB",
        "When FIFO combine mode is enabled for FIFO writes, software writing to"
        " any FIFO data register will alternate the write among the enabled dat"
        "a channel FIFOs.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCONT",
        "Configures when the SAI will continue transmitting after a FIFO error "
        "has been detected.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_TCR5.
static const field_t hw_sai_2ch_tcr5[] =
{
    {
        "FBT",
        "Configures the bit index for the first bit transmitted for each word i"
        "n the frame.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "W0W",
        "Configures the number of bits in the first word in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WNW",
        "Configures the number of bits in each word, for each word except the f"
        "irst in the frame.",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_TDR0.
static const field_t hw_sai_2ch_tdr0[] =
{
    {
        "TDR",
        "Writes to this register when the transmit FIFO is not full will push t"
        "he data written into the transmit data FIFO.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_TDR1.
static const field_t hw_sai_2ch_tdr1[] =
{
    {
        "TDR",
        "Writes to this register when the transmit FIFO is not full will push t"
        "he data written into the transmit data FIFO.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_TFR0.
static const field_t hw_sai_2ch_tfr0[] =
{
    {
        "RFP",
        "FIFO read pointer for transmit data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for transmit data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WCP",
        "When FIFO Combine mode is enabled for writes, indicates that this data"
        " channel is the next FIFO to be written.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_TFR1.
static const field_t hw_sai_2ch_tfr1[] =
{
    {
        "RFP",
        "FIFO read pointer for transmit data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for transmit data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WCP",
        "When FIFO Combine mode is enabled for writes, indicates that this data"
        " channel is the next FIFO to be written.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_TMR.
static const field_t hw_sai_2ch_tmr[] =
{
    {
        "TWM",
        "Configures whether the transmit word is masked (transmit data pins are"
        " tri-stated and transmit data not read from FIFO) for the correspondin"
        "g word in the frame.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_RCSR.
static const field_t hw_sai_2ch_rcsr[] =
{
    {
        "FRDE",
        "Enables/disables DMA requests.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWDE",
        "Enables/disables DMA requests.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRIE",
        "Enables/disables FIFO request interrupts.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWIE",
        "Enables/disables FIFO warning interrupts.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FEIE",
        "Enables/disables FIFO error interrupts.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEIE",
        "Enables/disables sync error interrupts.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSIE",
        "Enables/disables word start interrupts.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRF",
        "Indicates that the number of words in an enabled receive channel FIFO "
        "is greater than the receive FIFO watermark.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FWF",
        "Indicates that an enabled receive FIFO is full.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FEF",
        "Indicates that an enabled receive FIFO has overflowed.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEF",
        "Indicates that an error in the externally-generated frame sync has bee"
        "n detected.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSF",
        "Indicates that the start of the configured word has been detected.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SR",
        "Resets the internal receiver logic including the FIFO pointers.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FR",
        "Resets the FIFO pointers.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "BCE",
        "Enables the receive bit clock, separately from RE.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGE",
        "Enables/disables receiver operation in Debug mode.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPE",
        "Configures receiver operation in Stop mode.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE",
        "Enables/disables the receiver.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_RCR1.
static const field_t hw_sai_2ch_rcr1[] =
{
    {
        "RFW",
        "Configures the watermark level for all enabled receiver channels.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_RCR2.
static const field_t hw_sai_2ch_rcr2[] =
{
    {
        "DIV",
        "Divides down the audio master clock to generate the bit clock when con"
        "figured for an internal bit clock.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Configures the direction of the bit clock.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCP",
        "Configures the polarity of the bit clock.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MSEL",
        "Selects the audio Master Clock option used to generate an internally g"
        "enerated bit clock.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCI",
        "When this field is set and using an internally generated bit clock in "
        "either synchronous or asynchronous mode, the bit clock actually used b"
        "y the receiver is delayed by the pad output delay (the receiver is clo"
        "cked by the pad input as if the clock was externally generated).",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "This field swaps the bit clock used by the receiver.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYNC",
        "Configures between asynchronous and synchronous modes of operation.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_RCR3.
static const field_t hw_sai_2ch_rcr3[] =
{
    {
        "WDFL",
        "Configures which word the start of word flag is set.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCE",
        "Enables the corresponding data channel for receive operation.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CFR",
        "Resets the FIFO pointers for a specific channel.",
        24, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_RCR4.
static const field_t hw_sai_2ch_rcr4[] =
{
    {
        "FSD",
        "Configures the direction of the frame sync.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSP",
        "Configures the polarity of the frame sync.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ONDEM",
        "When set, and the frame sync is generated internally, a frame sync is "
        "only generated when the FIFO warning flag is clear.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MF",
        "Configures whether the LSB or the MSB is received first.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYWD",
        "Configures the length of the frame sync in number of bit clocks.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRSZ",
        "Configures the number of words in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FPACK",
        "Enables packing of 8-bit data or 16-bit data into each 32-bit FIFO wor"
        "d.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCOMB",
        "When FIFO combine mode is enabled for FIFO reads, software reading any"
        " FIFO data register will alternate the read among the enabled data cha"
        "nnel FIFOs.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCONT",
        "Configures when the SAI will continue receiving after a FIFO error has"
        " been detected.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_RCR5.
static const field_t hw_sai_2ch_rcr5[] =
{
    {
        "FBT",
        "Configures the bit index for the first bit received for each word in t"
        "he frame.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "W0W",
        "Configures the number of bits in the first word in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WNW",
        "Configures the number of bits in each word, for each word except the f"
        "irst in the frame.",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_RDR0.
static const field_t hw_sai_2ch_rdr0[] =
{
    {
        "RDR",
        "Reads from this register when the receive FIFO is not empty will retur"
        "n the data from the top of the receive FIFO.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_RDR1.
static const field_t hw_sai_2ch_rdr1[] =
{
    {
        "RDR",
        "Reads from this register when the receive FIFO is not empty will retur"
        "n the data from the top of the receive FIFO.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_RFR0.
static const field_t hw_sai_2ch_rfr0[] =
{
    {
        "RFP",
        "FIFO read pointer for receive data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RCP",
        "When FIFO Combine mode is enabled for reads, indicates that this data "
        "channel is the next FIFO to be read.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for receive data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_RFR1.
static const field_t hw_sai_2ch_rfr1[] =
{
    {
        "RFP",
        "FIFO read pointer for receive data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RCP",
        "When FIFO Combine mode is enabled for reads, indicates that this data "
        "channel is the next FIFO to be read.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for receive data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_2CH_RMR.
static const field_t hw_sai_2ch_rmr[] =
{
    {
        "RWM",
        "Configures whether the receive word is masked (received data ignored a"
        "nd not written to receive FIFO) for the corresponding word in the fram"
        "e.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a SAI_2CH module.
static const reg_t hw_sai_2ch[] =
{
    {
        "TCSR",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_sai_2ch_tcsr
    },
    {
        "TCR1",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_2ch_tcr1
    },
    {
        "TCR2",
        "This register must not be altered when TCSR[TE] is set.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_sai_2ch_tcr2
    },
    {
        "TCR3",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_sai_2ch_tcr3
    },
    {
        "TCR4",
        "This register must not be altered when TCSR[TE] is set.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_sai_2ch_tcr4
    },
    {
        "TCR5",
        "This register must not be altered when TCSR[TE] is set.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_sai_2ch_tcr5
    },
    {
        "TDR0",
        "",
        4, // Width in bytes
        0x00000020, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_2ch_tdr0
    },
    {
        "TDR1",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_2ch_tdr1
    },
    {
        "TFR0",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_2ch_tfr0
    },
    {
        "TFR1",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_2ch_tfr1
    },
    {
        "TMR",
        "This register is double-buffered and updates: When TCSR[TE] is first s"
        "et At the end of each frame.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_2ch_tmr
    },
    {
        "RCSR",
        "",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_sai_2ch_rcsr
    },
    {
        "RCR1",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_2ch_rcr1
    },
    {
        "RCR2",
        "This register must not be altered when RCSR[RE] is set.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_sai_2ch_rcr2
    },
    {
        "RCR3",
        "",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_sai_2ch_rcr3
    },
    {
        "RCR4",
        "This register must not be altered when RCSR[RE] is set.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_sai_2ch_rcr4
    },
    {
        "RCR5",
        "This register must not be altered when RCSR[RE] is set.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_sai_2ch_rcr5
    },
    {
        "RDR0",
        "",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_sai_2ch_rdr0
    },
    {
        "RDR1",
        "",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_sai_2ch_rdr1
    },
    {
        "RFR0",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_2ch_rfr0
    },
    {
        "RFR1",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_2ch_rfr1
    },
    {
        "RMR",
        "This register is double-buffered and updates: When RCSR[RE] is first s"
        "et At the end of each frame This allows the masked words in each frame"
        " to change from frame to frame.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_2ch_rmr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark SAI_4CH
#endif

// Bitfields in register SAI_4CH_TCSR.
static const field_t hw_sai_4ch_tcsr[] =
{
    {
        "FRDE",
        "Enables/disables DMA requests.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWDE",
        "Enables/disables DMA requests.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRIE",
        "Enables/disables FIFO request interrupts.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWIE",
        "Enables/disables FIFO warning interrupts.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FEIE",
        "Enables/disables FIFO error interrupts.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEIE",
        "Enables/disables sync error interrupts.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSIE",
        "Enables/disables word start interrupts.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRF",
        "Indicates that the number of words in an enabled transmit channel FIFO"
        " is less than or equal to the transmit FIFO watermark.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FWF",
        "Indicates that an enabled transmit FIFO is empty.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FEF",
        "Indicates that an enabled transmit FIFO has underrun.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEF",
        "Indicates that an error in the externally-generated frame sync has bee"
        "n detected.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSF",
        "Indicates that the start of the configured word has been detected.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SR",
        "When set, resets the internal transmitter logic including the FIFO poi"
        "nters.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FR",
        "Resets the FIFO pointers.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "BCE",
        "Enables the transmit bit clock, separately from the TE.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGE",
        "Enables/disables transmitter operation in Debug mode.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPE",
        "Configures transmitter operation in Stop mode.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE",
        "Enables/disables the transmitter.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TCR1.
static const field_t hw_sai_4ch_tcr1[] =
{
    {
        "TFW",
        "Configures the watermark level for all enabled transmit channels.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TCR2.
static const field_t hw_sai_4ch_tcr2[] =
{
    {
        "DIV",
        "Divides down the audio master clock to generate the bit clock when con"
        "figured for an internal bit clock.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Configures the direction of the bit clock.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCP",
        "Configures the polarity of the bit clock.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MSEL",
        "Selects the audio Master Clock option used to generate an internally g"
        "enerated bit clock.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCI",
        "When this field is set and using an internally generated bit clock in "
        "either synchronous or asynchronous mode, the bit clock actually used b"
        "y the transmitter is delayed by the pad output delay (the transmitter "
        "is clocked by the pad input as if the clock was externally generated).",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "This field swaps the bit clock used by the transmitter.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYNC",
        "Configures between asynchronous and synchronous modes of operation.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TCR3.
static const field_t hw_sai_4ch_tcr3[] =
{
    {
        "WDFL",
        "Configures which word sets the start of word flag.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE",
        "Enables the corresponding data channel for transmit operation.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CFR",
        "Resets the FIFO pointers for a specific channel.",
        24, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TCR4.
static const field_t hw_sai_4ch_tcr4[] =
{
    {
        "FSD",
        "Configures the direction of the frame sync.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSP",
        "Configures the polarity of the frame sync.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ONDEM",
        "When set, and the frame sync is generated internally, a frame sync is "
        "only generated when the FIFO warning flag is clear.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MF",
        "Configures whether the LSB or the MSB is transmitted first.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYWD",
        "Configures the length of the frame sync in number of bit clocks.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRSZ",
        "Configures the number of words in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FPACK",
        "Enables packing of 8-bit data or 16-bit data into each 32-bit FIFO wor"
        "d.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCOMB",
        "When FIFO combine mode is enabled for FIFO writes, software writing to"
        " any FIFO data register will alternate the write among the enabled dat"
        "a channel FIFOs.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCONT",
        "Configures when the SAI will continue transmitting after a FIFO error "
        "has been detected.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TCR5.
static const field_t hw_sai_4ch_tcr5[] =
{
    {
        "FBT",
        "Configures the bit index for the first bit transmitted for each word i"
        "n the frame.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "W0W",
        "Configures the number of bits in the first word in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WNW",
        "Configures the number of bits in each word, for each word except the f"
        "irst in the frame.",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TDR0.
static const field_t hw_sai_4ch_tdr0[] =
{
    {
        "TDR",
        "Writes to this register when the transmit FIFO is not full will push t"
        "he data written into the transmit data FIFO.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TDR1.
static const field_t hw_sai_4ch_tdr1[] =
{
    {
        "TDR",
        "Writes to this register when the transmit FIFO is not full will push t"
        "he data written into the transmit data FIFO.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TDR2.
static const field_t hw_sai_4ch_tdr2[] =
{
    {
        "TDR",
        "Writes to this register when the transmit FIFO is not full will push t"
        "he data written into the transmit data FIFO.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TDR3.
static const field_t hw_sai_4ch_tdr3[] =
{
    {
        "TDR",
        "Writes to this register when the transmit FIFO is not full will push t"
        "he data written into the transmit data FIFO.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TFR0.
static const field_t hw_sai_4ch_tfr0[] =
{
    {
        "RFP",
        "FIFO read pointer for transmit data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for transmit data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WCP",
        "When FIFO Combine mode is enabled for writes, indicates that this data"
        " channel is the next FIFO to be written.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TFR1.
static const field_t hw_sai_4ch_tfr1[] =
{
    {
        "RFP",
        "FIFO read pointer for transmit data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for transmit data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WCP",
        "When FIFO Combine mode is enabled for writes, indicates that this data"
        " channel is the next FIFO to be written.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TFR2.
static const field_t hw_sai_4ch_tfr2[] =
{
    {
        "RFP",
        "FIFO read pointer for transmit data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for transmit data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WCP",
        "When FIFO Combine mode is enabled for writes, indicates that this data"
        " channel is the next FIFO to be written.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TFR3.
static const field_t hw_sai_4ch_tfr3[] =
{
    {
        "RFP",
        "FIFO read pointer for transmit data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for transmit data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WCP",
        "When FIFO Combine mode is enabled for writes, indicates that this data"
        " channel is the next FIFO to be written.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_TMR.
static const field_t hw_sai_4ch_tmr[] =
{
    {
        "TWM",
        "Configures whether the transmit word is masked (transmit data pins are"
        " tri-stated and transmit data not read from FIFO) for the correspondin"
        "g word in the frame.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RCSR.
static const field_t hw_sai_4ch_rcsr[] =
{
    {
        "FRDE",
        "Enables/disables DMA requests.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWDE",
        "Enables/disables DMA requests.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRIE",
        "Enables/disables FIFO request interrupts.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWIE",
        "Enables/disables FIFO warning interrupts.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FEIE",
        "Enables/disables FIFO error interrupts.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEIE",
        "Enables/disables sync error interrupts.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSIE",
        "Enables/disables word start interrupts.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRF",
        "Indicates that the number of words in an enabled receive channel FIFO "
        "is greater than the receive FIFO watermark.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FWF",
        "Indicates that an enabled receive FIFO is full.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FEF",
        "Indicates that an enabled receive FIFO has overflowed.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEF",
        "Indicates that an error in the externally-generated frame sync has bee"
        "n detected.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSF",
        "Indicates that the start of the configured word has been detected.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SR",
        "Resets the internal receiver logic including the FIFO pointers.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FR",
        "Resets the FIFO pointers.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "BCE",
        "Enables the receive bit clock, separately from RE.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGE",
        "Enables/disables receiver operation in Debug mode.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPE",
        "Configures receiver operation in Stop mode.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE",
        "Enables/disables the receiver.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RCR1.
static const field_t hw_sai_4ch_rcr1[] =
{
    {
        "RFW",
        "Configures the watermark level for all enabled receiver channels.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RCR2.
static const field_t hw_sai_4ch_rcr2[] =
{
    {
        "DIV",
        "Divides down the audio master clock to generate the bit clock when con"
        "figured for an internal bit clock.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Configures the direction of the bit clock.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCP",
        "Configures the polarity of the bit clock.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MSEL",
        "Selects the audio Master Clock option used to generate an internally g"
        "enerated bit clock.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCI",
        "When this field is set and using an internally generated bit clock in "
        "either synchronous or asynchronous mode, the bit clock actually used b"
        "y the receiver is delayed by the pad output delay (the receiver is clo"
        "cked by the pad input as if the clock was externally generated).",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "This field swaps the bit clock used by the receiver.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYNC",
        "Configures between asynchronous and synchronous modes of operation.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RCR3.
static const field_t hw_sai_4ch_rcr3[] =
{
    {
        "WDFL",
        "Configures which word the start of word flag is set.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCE",
        "Enables the corresponding data channel for receive operation.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CFR",
        "Resets the FIFO pointers for a specific channel.",
        24, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RCR4.
static const field_t hw_sai_4ch_rcr4[] =
{
    {
        "FSD",
        "Configures the direction of the frame sync.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSP",
        "Configures the polarity of the frame sync.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ONDEM",
        "When set, and the frame sync is generated internally, a frame sync is "
        "only generated when the FIFO warning flag is clear.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MF",
        "Configures whether the LSB or the MSB is received first.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYWD",
        "Configures the length of the frame sync in number of bit clocks.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRSZ",
        "Configures the number of words in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FPACK",
        "Enables packing of 8-bit data or 16-bit data into each 32-bit FIFO wor"
        "d.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCOMB",
        "When FIFO combine mode is enabled for FIFO reads, software reading any"
        " FIFO data register will alternate the read among the enabled data cha"
        "nnel FIFOs.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCONT",
        "Configures when the SAI will continue receiving after a FIFO error has"
        " been detected.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RCR5.
static const field_t hw_sai_4ch_rcr5[] =
{
    {
        "FBT",
        "Configures the bit index for the first bit received for each word in t"
        "he frame.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "W0W",
        "Configures the number of bits in the first word in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WNW",
        "Configures the number of bits in each word, for each word except the f"
        "irst in the frame.",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RDR0.
static const field_t hw_sai_4ch_rdr0[] =
{
    {
        "RDR",
        "Reads from this register when the receive FIFO is not empty will retur"
        "n the data from the top of the receive FIFO.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RDR1.
static const field_t hw_sai_4ch_rdr1[] =
{
    {
        "RDR",
        "Reads from this register when the receive FIFO is not empty will retur"
        "n the data from the top of the receive FIFO.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RDR2.
static const field_t hw_sai_4ch_rdr2[] =
{
    {
        "RDR",
        "Reads from this register when the receive FIFO is not empty will retur"
        "n the data from the top of the receive FIFO.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RDR3.
static const field_t hw_sai_4ch_rdr3[] =
{
    {
        "RDR",
        "Reads from this register when the receive FIFO is not empty will retur"
        "n the data from the top of the receive FIFO.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RFR0.
static const field_t hw_sai_4ch_rfr0[] =
{
    {
        "RFP",
        "FIFO read pointer for receive data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RCP",
        "When FIFO Combine mode is enabled for reads, indicates that this data "
        "channel is the next FIFO to be read.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for receive data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RFR1.
static const field_t hw_sai_4ch_rfr1[] =
{
    {
        "RFP",
        "FIFO read pointer for receive data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RCP",
        "When FIFO Combine mode is enabled for reads, indicates that this data "
        "channel is the next FIFO to be read.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for receive data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RFR2.
static const field_t hw_sai_4ch_rfr2[] =
{
    {
        "RFP",
        "FIFO read pointer for receive data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RCP",
        "When FIFO Combine mode is enabled for reads, indicates that this data "
        "channel is the next FIFO to be read.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for receive data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RFR3.
static const field_t hw_sai_4ch_rfr3[] =
{
    {
        "RFP",
        "FIFO read pointer for receive data channel.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RCP",
        "When FIFO Combine mode is enabled for reads, indicates that this data "
        "channel is the next FIFO to be read.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for receive data channel.",
        16, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register SAI_4CH_RMR.
static const field_t hw_sai_4ch_rmr[] =
{
    {
        "RWM",
        "Configures whether the receive word is masked (received data ignored a"
        "nd not written to receive FIFO) for the corresponding word in the fram"
        "e.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a SAI_4CH module.
static const reg_t hw_sai_4ch[] =
{
    {
        "TCSR",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_sai_4ch_tcsr
    },
    {
        "TCR1",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_4ch_tcr1
    },
    {
        "TCR2",
        "This register must not be altered when TCSR[TE] is set.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_sai_4ch_tcr2
    },
    {
        "TCR3",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_sai_4ch_tcr3
    },
    {
        "TCR4",
        "This register must not be altered when TCSR[TE] is set.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_sai_4ch_tcr4
    },
    {
        "TCR5",
        "This register must not be altered when TCSR[TE] is set.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_sai_4ch_tcr5
    },
    {
        "TDR0",
        "",
        4, // Width in bytes
        0x00000020, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_4ch_tdr0
    },
    {
        "TDR1",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_4ch_tdr1
    },
    {
        "TDR2",
        "",
        4, // Width in bytes
        0x00000028, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_4ch_tdr2
    },
    {
        "TDR3",
        "",
        4, // Width in bytes
        0x0000002c, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_4ch_tdr3
    },
    {
        "TFR0",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_4ch_tfr0
    },
    {
        "TFR1",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_4ch_tfr1
    },
    {
        "TFR2",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_4ch_tfr2
    },
    {
        "TFR3",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_4ch_tfr3
    },
    {
        "TMR",
        "This register is double-buffered and updates: When TCSR[TE] is first s"
        "et At the end of each frame.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_4ch_tmr
    },
    {
        "RCSR",
        "",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_sai_4ch_rcsr
    },
    {
        "RCR1",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_4ch_rcr1
    },
    {
        "RCR2",
        "This register must not be altered when RCSR[RE] is set.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_sai_4ch_rcr2
    },
    {
        "RCR3",
        "",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_sai_4ch_rcr3
    },
    {
        "RCR4",
        "This register must not be altered when RCSR[RE] is set.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_sai_4ch_rcr4
    },
    {
        "RCR5",
        "This register must not be altered when RCSR[RE] is set.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_sai_4ch_rcr5
    },
    {
        "RDR0",
        "",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_sai_4ch_rdr0
    },
    {
        "RDR1",
        "",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_sai_4ch_rdr1
    },
    {
        "RDR2",
        "",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_sai_4ch_rdr2
    },
    {
        "RDR3",
        "",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_sai_4ch_rdr3
    },
    {
        "RFR0",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_4ch_rfr0
    },
    {
        "RFR1",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_4ch_rfr1
    },
    {
        "RFR2",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x000000c8, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_4ch_rfr2
    },
    {
        "RFR3",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x000000cc, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_sai_4ch_rfr3
    },
    {
        "RMR",
        "This register is double-buffered and updates: When RCSR[RE] is first s"
        "et At the end of each frame This allows the masked words in each frame"
        " to change from frame to frame.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_sai_4ch_rmr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark IOMUXC0
#endif

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA0.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta0[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA1.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta1[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA2.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta2[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA3.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta3[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA4.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta4[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA5.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta5[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA6.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta6[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA7.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta7[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA8.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta8[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA9.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta9[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA10.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta10[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA11.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta11[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA12.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta12[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA13.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta13[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA14.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta14[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA15.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta15[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA16.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta16[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA17.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta17[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA18.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta18[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA19.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta19[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA20.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta20[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA21.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta21[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFCS",
        "Select one out of next values for pad: PADn",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFD",
        "Select one out of next values for pad: PADn",
        22, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC0_SW_MUX_CTL_PAD_PTA22.
static const field_t hw_iomuxc0_sw_mux_ctl_pad_pta22[] =
{
    {
        "PS",
        "Select one out of next values for pad: PADn",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PE",
        "Select one out of next values for pad: PADn",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRE",
        "Select one out of next values for pad: PADn",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ODE",
        "Select one out of next values for pad: PADn",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSE",
        "Select one out of next values for pad: PADn",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX_MODE",
        "Selects one of the maximum sixteen modes available for any pad.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LK",
        "When enabled, prevents writes to fields: PS, PE, SRE, ODE, DSE, MUX_MO"
        "DE and LK.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBE",
        "Select one out of next values for pad: PADn",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBE",
        "Select one out of next values for pad: PADn",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DFE",
        "Select one out of next values for pad: PADn",
        20, // LSB
        20, // MSB
        true, // Readable
     