/*
 * Copyright (C) 2012 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this software; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */
#include "memtools_register_info.h"

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark AIPSTZ
#endif

// Bitfields in register AIPSTZ_MPR.
static const field_t hw_aipstz_mpr[] =
{
    {
        "MPROT3",
        "Master 3 Priviledge, Buffer, Read, Write Control.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT2",
        "Master 2 Priviledge, Buffer, Read, Write Control",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT1",
        "Master 1 Priviledge, Buffer, Read, Write Control",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPROT0",
        "Master 0 Priviledge, Buffer, Read, Write Control",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR.
static const field_t hw_aipstz_opacr[] =
{
    {
        "OPAC7",
        "Off-platform Peripheral Access Control 7",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC6",
        "Off-platform Peripheral Access Control 6",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC5",
        "Off-platform Peripheral Access Control 5",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC4",
        "Off-platform Peripheral Access Control 4",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC3",
        "Off-platform Peripheral Access Control 3",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC2",
        "Off-platform Peripheral Access Control 2",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC1",
        "Off-platform Peripheral Access Control 1",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC0",
        "Off-platform Peripheral Access Control 0",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR1.
static const field_t hw_aipstz_opacr1[] =
{
    {
        "OPAC15",
        "Off-platform Peripheral Access Control 15",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC14",
        "Off-platform Peripheral Access Control 14",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC13",
        "Off-platform Peripheral Access Control 13",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC12",
        "Off-platform Peripheral Access Control 12",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC11",
        "Off-platform Peripheral Access Control 11",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC10",
        "Off-platform Peripheral Access Control 10",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC9",
        "Off-platform Peripheral Access Control 9",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC8",
        "Off-platform Peripheral Access Control 8",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR2.
static const field_t hw_aipstz_opacr2[] =
{
    {
        "OPAC23",
        "Off-platform Peripheral Access Control 23",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC22",
        "Off-platform Peripheral Access Control 22",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC21",
        "Off-platform Peripheral Access Control 21",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC20",
        "Off-platform Peripheral Access Control 20",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC19",
        "Off-platform Peripheral Access Control 19",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC18",
        "Off-platform Peripheral Access Control 18",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC17",
        "Off-platform Peripheral Access Control 17",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC16",
        "Off-platform Peripheral Access Control 16",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR3.
static const field_t hw_aipstz_opacr3[] =
{
    {
        "OPAC31",
        "Off-platform Peripheral Access Control 31",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC30",
        "Off-platform Peripheral Access Control 30",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC29",
        "Off-platform Peripheral Access Control 29",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC28",
        "Off-platform Peripheral Access Control 28",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC27",
        "Off-platform Peripheral Access Control 27",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC26",
        "Off-platform Peripheral Access Control 26",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC25",
        "Off-platform Peripheral Access Control 25",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC24",
        "Off-platform Peripheral Access Control 24",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AIPSTZ_OPACR4.
static const field_t hw_aipstz_opacr4[] =
{
    {
        "OPAC33",
        "Off-platform Peripheral Access Control 33",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPAC32",
        "Off-platform Peripheral Access Control 32",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a AIPSTZ module.
static const reg_t hw_aipstz[] =
{
    {
        "MPR",
        "Each AIPSTZ_MPR specifies 16 4-bit fields defining the access privileg"
        "e level associated with a bus master in the platform, as well as speci"
        "fying whether write accesses from this master are bufferable shown in "
        " The registers provide one field per bus master, where field 15 corres"
        "ponds to master 15, field 14 to master 14,...",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_aipstz_mpr
    },
    {
        "OPACR",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr
    },
    {
        "OPACR1",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr1
    },
    {
        "OPACR2",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr2
    },
    {
        "OPACR3",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_aipstz_opacr3
    },
    {
        "OPACR4",
        "Each of the off-platform peripherals have an Off-platform Peripheral A"
        "ccess Control Register (AIPSTZ_OPACR) which defines the access levels "
        "supported by the given block.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_aipstz_opacr4
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ARMGLOBALTIMER
#endif

// Bitfields in register ARMGLOBALTIMER_COUNTER0.
static const field_t hw_armglobaltimer_counter0[] =
{
    {
        "VALUE",
        "32-bits of the counter value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_COUNTER1.
static const field_t hw_armglobaltimer_counter1[] =
{
    {
        "VALUE",
        "32-bits of the counter value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_CONTROL.
static const field_t hw_armglobaltimer_control[] =
{
    {
        "TIMER_ENABLE",
        "Timer enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COMP_ENABLE",
        "This bit is banked per Cortex-A9 processor.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ENABLE",
        "This bit is banked per Cortex-A9 processor.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUTO_INCREMENT",
        "This bit is banked per Cortex-A9 processor.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESCALER",
        "The prescaler modifies the clock period for the decrementing event for"
        " the Counter Register.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_IRQSTATUS.
static const field_t hw_armglobaltimer_irqstatus[] =
{
    {
        "EVENT_FLAG",
        "The event flag is a sticky bit that is automatically set when the Coun"
        "ter Register reaches the Comparator Register value.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_COMPARATOR0.
static const field_t hw_armglobaltimer_comparator0[] =
{
    {
        "VALUE",
        "32-bits of the comparator value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_COMPARATOR1.
static const field_t hw_armglobaltimer_comparator1[] =
{
    {
        "VALUE",
        "32-bits of the comparator value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ARMGLOBALTIMER_AUTOINCREMENT.
static const field_t hw_armglobaltimer_autoincrement[] =
{
    {
        "VALUE",
        "32-bit auto-increment value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ARMGLOBALTIMER module.
static const reg_t hw_armglobaltimer[] =
{
    {
        "COUNTER0",
        "There are two timer counter registers.",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_counter0
    },
    {
        "COUNTER1",
        "There are two timer counter registers.",
        4, // Width in bytes
        0x00000204, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_counter1
    },
    {
        "CONTROL",
        "Configuration and control of the Global Timer.",
        4, // Width in bytes
        0x00000208, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_armglobaltimer_control
    },
    {
        "IRQSTATUS",
        "This is a banked register for all Cortex-A9 processors present.",
        4, // Width in bytes
        0x0000020c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_irqstatus
    },
    {
        "COMPARATOR0",
        "There are two timer counter registers.",
        4, // Width in bytes
        0x00000210, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_comparator0
    },
    {
        "COMPARATOR1",
        "There are two timer counter registers.",
        4, // Width in bytes
        0x00000214, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_comparator1
    },
    {
        "AUTOINCREMENT",
        "This 32-bit register gives the increment value of the Comparator Regis"
        "ter when the Auto-increment bit is set in the Timer Control Register.",
        4, // Width in bytes
        0x00000218, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_armglobaltimer_autoincrement
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ASRC
#endif

// Bitfields in register ASRC_ASRCTR.
static const field_t hw_asrc_asrctr[] =
{
    {
        "ASRCEN",
        "ASRC Enable  Enable the operation of ASRC.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREA",
        "ASRC Enable A  Enable the operation of the conversion A of ASRC.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREB",
        "ASRC Enable B  Enable the operation of the conversion B of ASRC.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREC",
        "ASRC Enable C  Enable the operation of the conversion C of ASRC.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRST",
        "Software Reset  This bit is self-clear bit.",
        4, // LSB
        4, // MSB
        false, // Readable
        true // Writable
    },
    {
        "IDRA",
        "Use Ideal Ratio for Pair A  When USRA=0, this bit has no usage.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRA",
        "Use Ratio for Pair A  Use ratio as the input to ASRC.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDRB",
        "Use Ideal Ratio for Pair B  When USRB=0, this bit has no usage.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRB",
        "Use Ratio for Pair B  Use ratio as the input to ASRC.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDRC",
        "Use Ideal Ratio for Pair C  When USRC=0, this bit has no usage.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRC",
        "Use Ratio for Pair C  Use ratio as the input to ASRC.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSA",
        "ASRC Pair A Automatic Selection For Processing Options  When this bit "
        "is 1, pair A will automatic update its pre-processing and post-process"
        "ing options (ASRCFG: PREMODA, ASRCFG:POSTMODA see ASRC Misc Control Re"
        "gister 1 for Pair C ) based on the frequencies it detected.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSB",
        "ASRC Pair B Automatic Selection For Processing Options  When this bit "
        "is 1, pair B will automatic update its pre-processing and post-process"
        "ing options (ASRCFG: PREMODB, ASRCFG:POSTMODB see ASRC Misc Control Re"
        "gister 1 for Pair C ) based on the frequencies it detected.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSC",
        "ASRC Pair C Automatic Selection For Processing Options  When this bit "
        "is 1, pair C will automatic update its pre-processing and post-process"
        "ing options (ASRCFG: PREMODC, ASRCFG:POSTMODC see ASRC Misc Control Re"
        "gister 1 for Pair C ) based on the frequencies it detected.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIER.
static const field_t hw_asrc_asrier[] =
{
    {
        "ADIEA",
        "Data Input A Interrupt Enable  Enables the data input A Interrupt.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADIEB",
        "Data Input B Interrupt Enable  Enables the data input B interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADIEC",
        "Data Input C Interrupt Enable  Enables the data input C interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEA",
        "Data Output A Interrupt Enable  Enables the data output A interrupt.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEB",
        "Data Output B Interrupt Enable  Enables the data output B interrupt.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEC",
        "Data Output C Interrupt Enable  Enables the data output C interrupt.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOLIE",
        "Overload Interrupt Enable  Enables the overload interrupt.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AFPWE",
        "FP in Wait State Interrupt Enable  Enables the FP in wait state interr"
        "upt.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCNCR.
static const field_t hw_asrc_asrcncr[] =
{
    {
        "ANCA",
        "Number of A Channels",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ANCB",
        "Number of B Channels",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ANCC",
        "Number of C Channels ANCC+ANCB+ANCA<=10.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCFG.
static const field_t hw_asrc_asrcfg[] =
{
    {
        "PREMODA",
        "Pre-Processing Configuration for Conversion Pair A  These bits will be"
        " read/write by user if ASRCTR:ATSA=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSA=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair C ).",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODA",
        "Post-Processing Configuration for Conversion Pair A  These bits will b"
        "e read/write by user if ASRCTR:ATSA=0, and can also be automatically u"
        "pdated by the ASRC internal logic if ASRCTR:ATSA=1 (see ASRC Misc Cont"
        "rol Register 1 for Pair C ).",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREMODB",
        "Pre-Processing Configuration for Conversion Pair B  These bits will be"
        " read/write by user if ASRCTR:ATSB=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSB=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair C ).",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODB",
        "Post-Processing Configuration for Conversion Pair B  These bits will b"
        "e read/write by user if ASRCTR:ATSB=0, and can also be automatically u"
        "pdated by the ASRC internal logic if ASRCTR:ATSB=1 (see ASRC Misc Cont"
        "rol Register 1 for Pair C ).",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREMODC",
        "Pre-Processing Configuration for Conversion Pair C  These bits will be"
        " read/write by user if ASRCTR:ATSC=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSC=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair C ).",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODC",
        "Post-Processing Configuration for Conversion Pair C  These bits will b"
        "e read/write by user if ASRCTR:ATSC=0, and can also be automatically u"
        "pdated by the ASRC internal logic if ASRCTR:ATSC=1 (see ASRC Misc Cont"
        "rol Register 1 for Pair C ).",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRA",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir A",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRB",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir B",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRC",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir C",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INIRQA",
        "Initialization for Conversion Pair A is served  When this bit is 1, it"
        " means the initialization for conversion pair A is served.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INIRQB",
        "Initialization for Conversion Pair B is served  When this bit is 1, it"
        " means the initialization for conversion pair B is served.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INIRQC",
        "Initialization for Conversion Pair C is served  When this bit is 1, it"
        " means the initialization for conversion pair C is served.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCSR.
static const field_t hw_asrc_asrcsr[] =
{
    {
        "AICSA",
        "Input Clock Source A",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICSB",
        "Input Clock Source B",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICSC",
        "Input Clock Source C",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSA",
        "Output Clock Source A",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSB",
        "Output Clock Source B",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSC",
        "Output Clock Source C",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCDR1.
static const field_t hw_asrc_asrcdr1[] =
{
    {
        "AICPA",
        "Input Clock Prescaler A  Specify the prescaling factor of the input pr"
        "escaler A.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDA",
        "Input Clock Divider A  Specify the divide ratio of the input clock div"
        "ider A.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICPB",
        "Input Clock Prescaler B  Specify the prescaling factor of the input pr"
        "escaler B.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDB",
        "Input Clock Divider B  Specify the divide ratio of the input clock div"
        "ider B.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPA",
        "Output Clock Prescaler A  Specify the prescaling factor of the output "
        "prescaler A.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDA",
        "Output Clock Divider A  Specify the divide ratio of the output clock d"
        "ivider A.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPB",
        "Output Clock Prescaler B  Specify the prescaling factor of the output "
        "prescaler B.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDB",
        "Output Clock Divider B  Specify the divide ratio of the output clock d"
        "ivider B.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCDR2.
static const field_t hw_asrc_asrcdr2[] =
{
    {
        "AICPC",
        "Input Clock Prescaler C  Specify the prescaling factor of the input pr"
        "escaler C.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDC",
        "Input Clock Divider C  Specify the divide ratio of the input clock div"
        "ider C.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPC",
        "Output Clock Prescaler C  Specify the prescaling factor of the output "
        "prescaler C.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDC",
        "Output Clock Divider C  Specify the divide ratio of the output clock d"
        "ivider C.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRSTR.
static const field_t hw_asrc_asrstr[] =
{
    {
        "AIDEA",
        "Number of data in Input Data Buffer A is less than threshold  When set"
        ", this bit indicates that number of data still available in ASRDIRA is"
        " less than threshold and the processor can write data to ASRDIRA.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDEB",
        "Number of data in Input Data Buffer B is less than threshold  When set"
        ", this bit indicates that number of data still available in ASRDIRB is"
        " less than threshold and the processor can write data to ASRDIRB.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDEC",
        "Number of data in Input Data Buffer C is less than threshold  When set"
        ", this bit indicates that number of data still available in ASRDIRC is"
        " less than threshold and the processor can write data to ASRDIRC.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFA",
        "Number of data in Output Data Buffer A is greater than threshold  When"
        " set, this bit indicates that number of data already existing in ASRDO"
        "RA is greater than threshold and the processor can read data from ASRD"
        "ORA.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFB",
        "Number of data in Output Data Buffer B is greater than threshold  When"
        " set, this bit indicates that number of data already existing in ASRDO"
        "RB is greater than threshold and the processor can read data from ASRD"
        "ORB.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFC",
        "Number of data in Output Data Buffer C is greater than threshold  When"
        " set, this bit indicates that number of data already existing in ASRDO"
        "RC is greater than threshold and the processor can read data from ASRD"
        "ORC.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOLE",
        "Overload Error Flag  When set, this bit indicates that the task rate i"
        "s too high for the ASRC to handle.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FPWT",
        "FP is in wait states  This bit is for debug only.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUA",
        "Input Data Buffer A has underflowed  When set, this bit indicates that"
        " input data buffer A has underflowed.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUB",
        "Input Data Buffer B has underflowed  When set, this bit indicates that"
        " input data buffer B has underflowed.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUC",
        "Input Data Buffer C has underflowed  When set, this bit indicates that"
        " input data buffer C has underflowed.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOA",
        "Output Data Buffer A has overflowed  When set, this bit indicates that"
        " output data buffer A has overflowed.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOB",
        "Output Data Buffer B has overflowed  When set, this bit indicates that"
        " output data buffer B has overflowed.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOC",
        "Output Data Buffer C has overflowed  When set, this bit indicates that"
        " output data buffer C has overflowed.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLA",
        "Pair A Input Task Overload  When set, this bit indicates that pair A i"
        "nput task is oveloaded.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLB",
        "Pair B Input Task Overload  When set, this bit indicates that pair B i"
        "nput task is oveloaded.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLC",
        "Pair C Input Task Overload  When set, this bit indicates that pair C i"
        "nput task is oveloaded.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLA",
        "Pair A Output Task Overload  When set, this bit indicates that pair A "
        "output task is oveloaded.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLB",
        "Pair B Output Task Overload  When set, this bit indicates that pair B "
        "output task is oveloaded.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLC",
        "Pair C Output Task Overload  When set, this bit indicates that pair C "
        "output task is oveloaded.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ATQOL",
        "Task Queue FIFO overload  When set, this bit indicates that task queue"
        " FIFO logic is oveloaded.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DSLCNT",
        "DSL Counter Input to FIFO ready  When set, this bit indicates that new"
        " DSL counter information is stored in the internal ASRC FIFO.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMN1.
static const field_t hw_asrc_asrpmn1[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMN2.
static const field_t hw_asrc_asrpmn2[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMN3.
static const field_t hw_asrc_asrpmn3[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMN4.
static const field_t hw_asrc_asrpmn4[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMN5.
static const field_t hw_asrc_asrpmn5[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRTFR1.
static const field_t hw_asrc_asrtfr1[] =
{
    {
        "TF_BASE",
        "Base address for task queue FIFO.",
        6, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF_FILL",
        "Current number of entries in task queue FIFO.",
        13, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCCR.
static const field_t hw_asrc_asrccr[] =
{
    {
        "ACIA",
        "The channel counter for Pair A's input FIFO  These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "A's input FIFO's usage.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACIB",
        "The channel counter for Pair B's input FIFO  These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "B's input FIFO's usage.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACIC",
        "The channel counter for Pair C's input FIFO  These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "C's input FIFO's usage.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOA",
        "The channel counter for Pair A's output FIFO  These bits stand for the"
        " current channel being accessed through shared peripheral bus for Pair"
        " A's output FIFO's usage.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOB",
        "The channel counter for Pair B's output FIFO  These bits stand for the"
        " current channel being accessed through shared peripheral bus for Pair"
        " B's output FIFO's usage.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOC",
        "The channel counter for Pair C's output FIFO  These bits stand for the"
        " current channel being accessed through shared peripheral bus for Pair"
        " C's output FIFO's usage.",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIA.
static const field_t hw_asrc_asrdia[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOA.
static const field_t hw_asrc_asrdoa[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIB.
static const field_t hw_asrc_asrdib[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOB.
static const field_t hw_asrc_asrdob[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIC.
static const field_t hw_asrc_asrdic[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOC.
static const field_t hw_asrc_asrdoc[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHA.
static const field_t hw_asrc_asridrha[] =
{
    {
        "IDRATIOA",
        "IDRATIOA[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLA.
static const field_t hw_asrc_asridrla[] =
{
    {
        "IDRATIOA",
        "IDRATIOA[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHB.
static const field_t hw_asrc_asridrhb[] =
{
    {
        "IDRATIOB",
        "IDRATIOB[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLB.
static const field_t hw_asrc_asridrlb[] =
{
    {
        "IDRATIOB",
        "IDRATIOB[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHC.
static const field_t hw_asrc_asridrhc[] =
{
    {
        "IDRATIOC",
        "IDRATIOC[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLC.
static const field_t hw_asrc_asridrlc[] =
{
    {
        "IDRATIOC",
        "IDRATIOC[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASR76K.
static const field_t hw_asrc_asr76k[] =
{
    {
        "ASR76K",
        "Value for the period of the 76kHz sampling clock.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASR56K.
static const field_t hw_asrc_asr56k[] =
{
    {
        "ASR56K",
        "Value for the period of the 56kHz sampling clock",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRA.
static const field_t hw_asrc_asrmcra[] =
{
    {
        "INFIFO_THRESHOLDA",
        "The threshold for Pair A's input FIFO per channel  These bits stand fo"
        "r the threshold for Pair A's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFA",
        "Re-sync Output FIFO Channel Counter  If bit set, force ASRCCR:ACOA=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFA",
        "Re-sync Input FIFO Channel Counter  If bit set, force ASRCCR:ACIA=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDA",
        "The threshold for Pair A's output FIFO per channel  These bits stand f"
        "or the threshold for Pair A's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYA",
        "Bypass Polyphase Filtering for Pair A  This bit will determine whether"
        " the polyphase filtering part of Pair A conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLA",
        "Stall Pair A conversion in case of Buffer Near Empty/Full Condition  T"
        "his bit will determine whether the near empty/full FIFO condition will"
        " stall the rate conversion for pair A.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHA",
        "Use external thresholds for FIFO control of Pair A  This bit will dete"
        "rmine whether the FIFO thresholds externally defined in this register "
        "is used to control ASRC internal FIFO logic for pair A.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFA",
        "Initialize buf of Pair A when pair A is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTA.
static const field_t hw_asrc_asrfsta[] =
{
    {
        "INFIFO_FILLA",
        "The fillings for Pair A's input FIFO per channel  These bits stand for"
        " the fillings for Pair A's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEA",
        "Input FIFO is near Empty for Pair A  This bit is to indicate whether t"
        "he input FIFO of Pair A is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLA",
        "The fillings for Pair A's output FIFO per channel  These bits stand fo"
        "r the fillings for Pair A's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFA",
        "Output FIFO is near Full for Pair A  This bit is to indicate whether t"
        "he output FIFO of Pair A is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRB.
static const field_t hw_asrc_asrmcrb[] =
{
    {
        "INFIFO_THRESHOLDB",
        "The threshold for Pair B's input FIFO per channel  These bits stand fo"
        "r the threshold for Pair B's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFB",
        "Re-sync Output FIFO Channel Counter  If bit set, force ASRCCR:ACOB=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFB",
        "Re-sync Input FIFO Channel Counter  If bit set, force ASRCCR:ACIB=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDB",
        "The threshold for Pair B's output FIFO per channel  These bits stand f"
        "or the threshold for Pair B's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYB",
        "Bypass Polyphase Filtering for Pair B  This bit will determine whether"
        " the polyphase filtering part of Pair B conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLB",
        "Stall Pair B conversion in case of Buffer Near Empty/Full Condition  T"
        "his bit will determine whether the near empty/full FIFO condition will"
        " stall the rate conversion for pair B.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHB",
        "Use external thresholds for FIFO control of Pair B  This bit will dete"
        "rmine whether the FIFO thresholds externally defined in this register "
        "is used to control ASRC internal FIFO logic for pair B.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFB",
        "Initialize buf of Pair B when pair B is enabled  This bit is used to c"
        "ontrol whether the buffer is to be zeroized when pair B is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTB.
static const field_t hw_asrc_asrfstb[] =
{
    {
        "INFIFO_FILLB",
        "The fillings for Pair B's input FIFO per channel  These bits stand for"
        " the fillings for Pair B's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEB",
        "Input FIFO is near Empty for Pair B  This bit is to indicate whether t"
        "he input FIFO of Pair B is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLB",
        "The fillings for Pair B's output FIFO per channel  These bits stand fo"
        "r the fillings for Pair B's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFB",
        "Output FIFO is near Full for Pair B  This bit is to indicate whether t"
        "he output FIFO of Pair B is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRC.
static const field_t hw_asrc_asrmcrc[] =
{
    {
        "INFIFO_THRESHOLDC",
        "The threshold for Pair C's input FIFO per channel  These bits stand fo"
        "r the threshold for Pair C's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFC",
        "Re-sync Output FIFO Channel Counter  If bit set, force ASRCCR:ACOC=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFC",
        "Re-sync Input FIFO Channel Counter  If bit set, force ASRCCR:ACIC=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDC",
        "The threshold for Pair C's output FIFO per channel  These bits stand f"
        "or the threshold for Pair C's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYC",
        "Bypass Polyphase Filtering for Pair C  This bit will determine whether"
        " the polyphase filtering part of Pair C conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLC",
        "Stall Pair C conversion in case of Buffer Near Empty/Full Condition  T"
        "his bit will determine whether the near empty/full FIFO condition will"
        " stall the rate conversion for pair C.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHC",
        "Use external thresholds for FIFO control of Pair C  This bit will dete"
        "rmine whether the FIFO thresholds externally defined in this register "
        "is used to control ASRC internal FIFO logic for pair C.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFC",
        "Initialize buf of Pair C when pair C is enabled  This bit is used to c"
        "ontrol whether the buffer is to be zeroized when pair C is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTC.
static const field_t hw_asrc_asrfstc[] =
{
    {
        "INFIFO_FILLC",
        "The fillings for Pair C's input FIFO per channel  These bits stand for"
        " the fillings for Pair C's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEC",
        "Input FIFO is near Empty for Pair C  This bit is to indicate whether t"
        "he input FIFO of Pair C is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLC",
        "The fillings for Pair C's output FIFO per channel  These bits stand fo"
        "r the fillings for Pair C's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFC",
        "Output FIFO is near Full for Pair C  This bit is to indicate whether t"
        "he output FIFO of Pair C is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1A.
static const field_t hw_asrc_asrmcr1a[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO  This bit will determine the bit w"
        "idth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO  This bit will determine the "
        "sign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO  This bit will determine the data al"
        "ignment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO  This bit will determine the data ali"
        "gnment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO  These three bits will determine the bitw"
        "idth for the audio data into ASRC  All other settings not shown are re"
        "served.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1B.
static const field_t hw_asrc_asrmcr1b[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO  This bit will determine the bit w"
        "idth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO  This bit will determine the "
        "sign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO  This bit will determine the data al"
        "ignment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO  This bit will determine the data ali"
        "gnment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO  These three bits will determine the bitw"
        "idth for the audio data into ASRC  All other settings not shown are re"
        "served.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1C.
static const field_t hw_asrc_asrmcr1c[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO  This bit will determine the bit w"
        "idth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO  This bit will determine the "
        "sign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO  This bit will determine the data al"
        "ignment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO  This bit will determine the data ali"
        "gnment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO  These three bits will determine the bitw"
        "idth for the audio data into ASRC  All other settings not shown are re"
        "served.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UNIMPLEMENTED",
        "",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a ASRC module.
static const reg_t hw_asrc[] =
{
    {
        "ASRCTR",
        "The ASRC control register (ASRCTR) is a 24-bit read/write register tha"
        "t controls the ASRC operations.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_asrc_asrctr
    },
    {
        "ASRIER",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_asrc_asrier
    },
    {
        "ASRCNCR",
        "The ASRC channel number configuration register (ASRCNCR) is a 24-bit r"
        "ead/write register that sets the number of channels used by each ASRC "
        "conversion pair.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_asrc_asrcncr
    },
    {
        "ASRCFG",
        "The ASRC configuration status register (ASRCFG) is a 24-bit read/write"
        " register that sets and/or automatically senses the ASRC operations.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_asrc_asrcfg
    },
    {
        "ASRCSR",
        "The ASRC clock source register (ASRCSR) is a 24-bit read/write registe"
        "r that controls the sources of the input and output clocks of the ASRC"
        ".",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_asrc_asrcsr
    },
    {
        "ASRCDR1",
        "The ASRC clock divider register (ASRCDR1) is a two 24-bit read/write r"
        "egister that controls the division factors of the ASRC input and outpu"
        "t clock sources.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_asrc_asrcdr1
    },
    {
        "ASRCDR2",
        "The ASRC clock divider register (ASRCDR2) is a two 24-bit read/write r"
        "egister that controls the division factors of the ASRC input and outpu"
        "t clock sources.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_asrc_asrcdr2
    },
    {
        "ASRSTR",
        "The ASRC status register (ASRSTR) is a 24-bit read-write register used"
        " by the processor core to examine the status of the ASRC block and cle"
        "ar the overload interrupt request and AOLE flag bit.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        23, // Number of bitfields
        hw_asrc_asrstr
    },
    {
        "ASRPMN1",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asrpmn1
    },
    {
        "ASRPMN2",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asrpmn2
    },
    {
        "ASRPMN3",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asrpmn3
    },
    {
        "ASRPMN4",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asrpmn4
    },
    {
        "ASRPMN5",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asrpmn5
    },
    {
        "ASRTFR1",
        "The register defines and shows the parameters for ASRC inner task queu"
        "e FIFOs.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_asrc_asrtfr1
    },
    {
        "ASRCCR",
        "The ASRC channel counter register (ASRCCR) is a 24-bit read/write regi"
        "ster that sets and reflects the current specific input/output FIFO bei"
        "ng accessed through shared peripheral bus for each ASRC conversion pai"
        "r.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_asrc_asrccr
    },
    {
        "ASRDIA",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000060, // Base address offset
        false, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asrdia
    },
    {
        "ASRDOA",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_asrc_asrdoa
    },
    {
        "ASRDIB",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000068, // Base address offset
        false, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asrdib
    },
    {
        "ASRDOB",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_asrc_asrdob
    },
    {
        "ASRDIC",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000070, // Base address offset
        false, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asrdic
    },
    {
        "ASRDOC",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_asrc_asrdoc
    },
    {
        "ASRIDRHA",
        "The ideal ratio registers (ASRIDRHA, ASRIDRLA) hold the ratio value ID"
        "RATIOA.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asridrha
    },
    {
        "ASRIDRLA",
        "The ideal ratio registers (ASRIDRHA, ASRIDRLA) hold the ratio value ID"
        "RATIOA.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asridrla
    },
    {
        "ASRIDRHB",
        "The ideal ratio registers (ASRIDRHB, ASRIDRLB) hold the ratio value ID"
        "RATIOB.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asridrhb
    },
    {
        "ASRIDRLB",
        "The ideal ratio registers (ASRIDRHB, ASRIDRLB) hold the ratio value ID"
        "RATIOB.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asridrlb
    },
    {
        "ASRIDRHC",
        "The ideal ratio registers (ASRIDRHC, ASRIDRLC) hold the ratio value ID"
        "RATIOC.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asridrhc
    },
    {
        "ASRIDRLC",
        "The ideal ratio registers (ASRIDRHC, ASRIDRLC) hold the ratio value ID"
        "RATIOC.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asridrlc
    },
    {
        "ASR76K",
        "The register (ASR76K) holds the period of the 76kHz sampling clock in "
        "terms of the ASRC processing clock with frequency Fs ASRC .",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asr76k
    },
    {
        "ASR56K",
        "The register (ASR56K) holds the period of the 56kHz sampling clock in "
        "terms of the ASRC processing clock with frequency Fs ASRC .",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asr56k
    },
    {
        "ASRMCRA",
        "The register (ASRMCRA) is used to control Pair A internal logic.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_asrc_asrmcra
    },
    {
        "ASRFSTA",
        "The register (ASRFSTA) is used to show Pair A internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        false, // Writable
        5, // Number of bitfields
        hw_asrc_asrfsta
    },
    {
        "ASRMCRB",
        "The register (ASRMCRB) is used to control Pair B internal logic.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_asrc_asrmcrb
    },
    {
        "ASRFSTB",
        "The register (ASRFSTB) is used to show Pair B internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        false, // Writable
        5, // Number of bitfields
        hw_asrc_asrfstb
    },
    {
        "ASRMCRC",
        "The register (ASRMCRC) is used to control Pair C internal logic.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_asrc_asrmcrc
    },
    {
        "ASRFSTC",
        "The register (ASRFSTC) is used to show Pair C internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000b4, // Base address offset
        true, // Readable
        false, // Writable
        5, // Number of bitfields
        hw_asrc_asrfstc
    },
    {
        "ASRMCR1A",
        "The register (ASRMCR1A) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_asrc_asrmcr1a
    },
    {
        "ASRMCR1B",
        "The register (ASRMCR1A) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_asrc_asrmcr1b
    },
    {
        "ASRMCR1C",
        "The register (ASRMCR1A) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c8, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_asrc_asrmcr1c
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark AUDMUX
#endif

// Bitfields in register AUDMUX_PTCR1.
static const field_t hw_audmux_ptcr1[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR1.
static const field_t hw_audmux_pdcr1[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR2.
static const field_t hw_audmux_ptcr2[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR2.
static const field_t hw_audmux_pdcr2[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR3.
static const field_t hw_audmux_ptcr3[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR3.
static const field_t hw_audmux_pdcr3[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR4.
static const field_t hw_audmux_ptcr4[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR4.
static const field_t hw_audmux_pdcr4[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR5.
static const field_t hw_audmux_ptcr5[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR5.
static const field_t hw_audmux_pdcr5[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR6.
static const field_t hw_audmux_ptcr6[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR6.
static const field_t hw_audmux_pdcr6[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PTCR7.
static const field_t hw_audmux_ptcr7[] =
{
    {
        "SYN",
        "Synchronous/Asynchronous Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSEL",
        "Receive Clock Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCLKDIR",
        "Receive Clock Direction Control.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSEL",
        "Receive Frame Sync Select.",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFS_DIR",
        "Receive Frame Sync Direction Control.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCSEL",
        "Transmit Clock Select.",
        22, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKDIR",
        "Transmit Clock Direction Control.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSEL",
        "Transmit Frame Sync Select.",
        27, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFS_DIR",
        "Transmit Frame Sync Direction Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register AUDMUX_PDCR7.
static const field_t hw_audmux_pdcr7[] =
{
    {
        "INMMASK",
        "Internal Network Mode Mask.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Mode Select.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXRXEN",
        "Transmit/Receive Switch Enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDSEL",
        "Receive Data Select.",
        13, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a AUDMUX module.
static const reg_t hw_audmux[] =
{
    {
        "PTCR1",
        "PTCR1 is the Port Timing Control Register for Port 1.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr1
    },
    {
        "PDCR1",
        "PDCR1 is the Port Data Control Register for Port 1.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr1
    },
    {
        "PTCR2",
        "PTCR2 is the Port Timing Control Register for Port 2.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr2
    },
    {
        "PDCR2",
        "PDCR2 is the Port Data Control Register for Port 2.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr2
    },
    {
        "PTCR3",
        "PTCR3 is the Port Timing Control Register for Port 3.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr3
    },
    {
        "PDCR3",
        "PDCR3 is the Port Data Control Register for Port 3.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr3
    },
    {
        "PTCR4",
        "Port Timing Control Register for Port 4",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr4
    },
    {
        "PDCR4",
        "PDCR4 is the Port Data Control Register for Port 4.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr4
    },
    {
        "PTCR5",
        "Port Timing Control Register for Port 5",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr5
    },
    {
        "PDCR5",
        "PDCR5 is the Port Data Control Register for Port 5.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr5
    },
    {
        "PTCR6",
        "Port Timing Control Register for Port 6",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr6
    },
    {
        "PDCR6",
        "PDCR6 is the Port Data Control Register for Port 6.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr6
    },
    {
        "PTCR7",
        "Port Timing Control Register for Port 7",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_audmux_ptcr7
    },
    {
        "PDCR7",
        "PDCR7 is the Port Data Control Register for Port 7 .",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_audmux_pdcr7
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CCM
#endif

// Bitfields in register CCM_CCR.
static const field_t hw_ccm_ccr[] =
{
    {
        "OSCNT",
        "Oscillator ready counter value.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_EN",
        "On chip oscillator enable bit - this bit value is reflected on the out"
        "put cosc_en.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_COUNT",
        "Well Bias counter.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG_BYPASS_COUNT",
        "Counter for analog_reg_bypass signal assertion after standby voltage r"
        "equest by pmic_vstby_req.",
        21, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBC_EN",
        "Enable for REG_BYPASS_COUNTER.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCDR.
static const field_t hw_ccm_ccdr[] =
{
    {
        "MMDC_CH1_MASK",
        "During divider ratio mmdc_ch1_axi_podf change or sync mux periph2_clk_"
        "sel change (but not jtag) or SRC request during warm reset, mask hands"
        "hake with mmdc_ch1 module.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_CH0_MASK",
        "During divider ratio mmdc_ch0_axi_podf change or sync mux periph_clk_s"
        "el change (but not jtag) or SRC request during warm reset, mask handsh"
        "ake with mmdc_ch0 module.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSR.
static const field_t hw_ccm_csr[] =
{
    {
        "REF_EN_B",
        "Status of the value of ref_en_b output of ccm",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COSC_READY",
        "Status indication of on board oscillator.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCSR.
static const field_t hw_ccm_ccsr[] =
{
    {
        "PLL3_SW_CLK_SEL",
        "Selects source to generate pll3_sw_clk.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL2_SW_CLK_SEL",
        "Selects source to generate pll2_sw_clk.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL1_SW_CLK_SEL",
        "Selects source to generate pll1_sw_clk.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STEP_SEL",
        "Selects the option to be chosen for the step frequency when shifting A"
        "RM frequency.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_396M_DIS_MASK",
        "Mask of 396M PFD auto-disable.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_352M_DIS_MASK",
        "Mask of 352M PFD auto-disable.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_594M_DIS_MASK",
        "Mask of 594M PFD auto-disable.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_508M_DIS_MASK",
        "Mask of 508M PFD auto-disable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_454M_DIS_MASK",
        "Mask of 454M PFD auto-disable.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_720M_DIS_MASK",
        "Mask of 720M PFD auto-disable.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDF_540M_DIS_MASK",
        "Mask of 540M PFD auto-disable.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CACRR.
static const field_t hw_ccm_cacrr[] =
{
    {
        "ARM_PODF",
        "Divider for ARM clock root.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CBCDR.
static const field_t hw_ccm_cbcdr[] =
{
    {
        "PERIPH2_CLK2_PODF",
        "Divider for periph2_clk2 podf.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_CH1_AXI_PODF",
        "Divider for mmdc_ch1_axi podf.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_SEL",
        "AXI clock source select",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_ALT_SEL",
        "AXI alternative clock select",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPG_PODF",
        "Divider for ipg podf.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_PODF",
        "Divider for ahb podf.",
        10, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_PODF",
        "Divider for axi podf.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_CH0_AXI_PODF",
        "Divider for mmdc_ch0_axi podf.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK_SEL",
        "Selector for peripheral main clock (source of mmdc_ch0_axi_clk_root).",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK_SEL",
        "Selector for peripheral2 main clock (source of mmdc_ch1_axi_clk_root )"
        ".",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK2_PODF",
        "Divider for periph2 clock podf.",
        27, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CBCMR.
static const field_t hw_ccm_cbcmr[] =
{
    {
        "GPU2D_AXI_CLK_SEL",
        "Selector for gpu2d_axi clock multiplexer",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU3D_AXI_CLK_SEL",
        "Selector for gpu3d_axi clock multiplexer",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU3D_CORE_CLK_SEL",
        "Selector for gpu3d_core clock multiplexer",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU3D_SHADER_CLK_SEL",
        "Selector for gpu3d_shader clock multiplexer",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCIE_AXI_CLK_SEL",
        "Selector for pcie_axi clock multiplexer",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VDOAXI_CLK_SEL",
        "Selector for vdoaxi clock multiplexer",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK2_SEL",
        "Selector for peripheral clk2 clock multiplexer",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPU_AXI_CLK_SEL",
        "Selector for VPU axi clock multiplexer",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU2D_CLK_SEL",
        "Selector for open vg clock multiplexer",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_PERIPH_CLK_SEL",
        "Selector for pre_periph clock multiplexer",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK2_SEL",
        "Selector for periph2_clk2 clock multiplexer",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_PERIPH2_CLK_SEL",
        "Selector for pre_periph2 clock multiplexer",
        21, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU2D_CORE_CLK_PODF",
        "Divider for gpu2d_core clock.",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU3D_CORE_PODF",
        "Divider for gpu3d_core clock.",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU3D_SHADER_PODF",
        "Divider for gpu3d_shader clock.",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCMR1.
static const field_t hw_ccm_cscmr1[] =
{
    {
        "PERCLK_PODF",
        "Divider for perclk podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI1_CLK_SEL",
        "Selector for ssi1 clock multiplexer",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI2_CLK_SEL",
        "Selector for ssi2 clock multiplexer",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI3_CLK_SEL",
        "Selector for ssi3 clock multiplexer",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC1_CLK_SEL",
        "Selector for usdhc1 clock multiplexer",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC2_CLK_SEL",
        "Selector for usdhc2 clock multiplexer",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC3_CLK_SEL",
        "Selector for usdhc3 clock multiplexer",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC4_CLK_SEL",
        "Selector for usdhc4 clock multiplexer",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EMI_PODF",
        "Divider for aclk_emi clock root.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EMI_SLOW_PODF",
        "Divider for aclk_emi_slow clock root.",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EMI_SEL",
        "Selector for aclk_emi root clock multiplexer",
        27, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EMI_SLOW_SEL",
        "Selector for aclk_emi_slow root clock multiplexer",
        29, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCMR2.
static const field_t hw_ccm_cscmr2[] =
{
    {
        "CAN_CLK_PODF",
        "Divider for can clock podf.",
        2, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI0_IPU_DIV",
        "Control for divider of ldb clock for IPU di0",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI1_IPU_DIV",
        "Control for divider of ldb clock for IPU di1",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESAI_CLK_SEL",
        "Selector for esai clock multiplexer",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR1.
static const field_t hw_ccm_cscdr1[] =
{
    {
        "UART_CLK_PODF",
        "Divider for uart clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC1_PODF",
        "Divider for usdhc1 clock podf.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC2_PODF",
        "Divider for usdhc2 clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC3_PODF",
        "Divider for usdhc3 clock podf.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC4_PODF",
        "Divider for esdhc4 clock pred.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPU_AXI_PODF",
        "Divider for vpu axi clock podf.",
        25, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CS1CDR.
static const field_t hw_ccm_cs1cdr[] =
{
    {
        "SSI1_CLK_PODF",
        "Divider for ssi1 clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI1_CLK_PRED",
        "Divider for ssi1 clock pred.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESAI_CLK_PRED",
        "Divider for esai clock pred.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI3_CLK_PODF",
        "Divider for ssi3 clock podf.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI3_CLK_PRED",
        "Divider for ssi3 clock pred.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ESAI_CLK_PODF",
        "Divider for esai clock podf.",
        25, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CS2CDR.
static const field_t hw_ccm_cs2cdr[] =
{
    {
        "SSI2_CLK_PODF",
        "Divider for ssi2 clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSI2_CLK_PRED",
        "Divider for ssi2 clock pred.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI0_CLK_SEL",
        "Selector for ldb_di1 clock multiplexer",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI1_CLK_SEL",
        "Selector for ldb_di1 clock multiplexer",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENFC_CLK_SEL",
        "Selector for enfc clock multiplexer",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENFC_CLK_PRED",
        "Divider for enfc clock pred divider.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENFC_CLK_PODF",
        "Divider for enfc clock divider.",
        21, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CDCDR.
static const field_t hw_ccm_cdcdr[] =
{
    {
        "SPDIF1_CLK_SEL",
        "Selector for spdif1 clock multiplexer",
        7, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF1_CLK_PODF",
        "Divider for spdif1 clock podf.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF1_CLK_PRED",
        "Divider for spdif1 clock pred.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_SEL",
        "Selector for spdif0 clock multiplexer",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_PODF",
        "Divider for spdif0 clock podf.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_PRED",
        "Divider for spdif0 clock pred.",
        25, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HSI_TX_CLK_SEL",
        "Selector for hsi_tx clock multiplexer",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HSI_TX_PODF",
        "Divider for hsi_tx clock podf.",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CHSCCDR.
static const field_t hw_ccm_chsccdr[] =
{
    {
        "IPU1_DI0_CLK_SEL",
        "Selector for ipu1 di0 root clock multiplexer",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_DI0_PODF",
        "Divider for ipu1_di0 clock divider.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_DI0_PRE_CLK_SEL",
        "Selector for ipu1 di0 root clock pre-multiplexer",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_DI1_CLK_SEL",
        "Selector for ipu1 di1 root clock multiplexer",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_DI1_PODF",
        "Divider for ipu1_di clock divider.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_DI1_PRE_CLK_SEL",
        "Selector for ipu1 di1 root clock pre-multiplexer",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR2.
static const field_t hw_ccm_cscdr2[] =
{
    {
        "IPU2_DI0_CLK_SEL",
        "Selector for ipu2 di0 root clock multiplexer",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_DI0_PODF",
        "Divider for ipu2_di0 clock divider.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_DI0_PRE_CLK_SEL",
        "Selector for ipu2 di0 root clock pre-multiplexer",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_DI1_CLK_SEL",
        "Selector for ipu1 di2 root clock multiplexer",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_DI1_PODF",
        "Divider for ipu2_di1 clock divider.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_DI1_PRE_CLK_SEL",
        "Selector for ipu2 di1 root clock pre-multiplexer",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECSPI_CLK_PODF",
        "Divider for ecspi clock podf.",
        19, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR3.
static const field_t hw_ccm_cscdr3[] =
{
    {
        "IPU1_HSP_CLK_SEL",
        "Selector for ipu1_hsp clock multiplexer",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_HSP_PODF",
        "Divider for ipu1_hsp clock.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_HSP_CLK_SEL",
        "Selector for ipu2_hsp clock multiplexer",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_HSP_PODF",
        "Divider for ipu2_hsp clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CWDR.
static const field_t hw_ccm_cwdr[] =
{
    { 0 } // Terminator
};

// Bitfields in register CCM_CDHIPR.
static const field_t hw_ccm_cdhipr[] =
{
    {
        "AXI_PODF_BUSY",
        "Busy indicator for axi_podf.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AHB_PODF_BUSY",
        "Busy indicator for ahb_podf.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MMDC_CH1_PODF_BUSY",
        "Busy indicator for mmdc_ch1_axi_podf.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH2_CLK_SEL_BUSY",
        "Busy indicator for periph2_clk_sel mux control.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MMDC_CH0_PODF_BUSY",
        "Busy indicator for mmdc_ch0_axi_podf.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH_CLK_SEL_BUSY",
        "Busy indicator for periph_clk_sel mux control.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ARM_PODF_BUSY",
        "Busy indicator for arm_podf.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CTOR.
static const field_t hw_ccm_ctor[] =
{
    {
        "OBS_SPARE_OUTPUT_2_SEL",
        "Selection of the signal to be generated on obs_output_2 (output of CCM"
        ") for observability on the pads.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBS_SPARE_OUTPUT_1_SEL",
        "Selection of the signal to be generated on obs_output_1 (output of CCM"
        ") for observability on the pads.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBS_SPARE_OUTPUT_0_SEL",
        "Selection of the signal to be generated on obs_output_0 (output of CCM"
        ") for observability on the pads.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBS_EN",
        "observability enable bit.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CLPCR.
static const field_t hw_ccm_clpcr[] =
{
    {
        "LPM",
        "Setting the low power mode that system will enter on next assertion of"
        " dsm_request signal.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_PMIC_VFUNCTIONAL_READY",
        "By asserting this bit CCM will bypass waiting for pmic_vfunctional_rea"
        "dy signal when coming out of STOP mode.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_CLK_DIS_ON_LPM",
        "Define if ARM clocks (arm_clk, soc_mxclk, soc_pclk, soc_dbg_pclk, vl_w"
        "rck) will be disabled on wait mode.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SBYOS",
        "Standby clock oscillator bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIS_REF_OSC",
        "dis_ref_osc - in run mode, software can manually control closing of ex"
        "ternal reference oscillator clock, i.e.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSTBY",
        "Voltage standby request bit.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STBY_COUNT",
        "Standby counter definition.",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_PWRDOWN",
        "In run mode, software can manually control powering down of on chip os"
        "cillator, i.e.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WB_PER_AT_LPM",
        "Enable periphery charge pump for well biasing at low power mode (stop "
        "or wait)",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_MMDC_CH0_LPM_HS",
        "Bypass handshake with mmdc_ch0 on next entrance to low power mode (wai"
        "t or stop mode).",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_MMDC_CH1_LPM_HS",
        "Bypass handshake with mmdc_ch1 on next entrance to low power mode (wai"
        "t or stop mode).",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CORE0_WFI",
        "Mask WFI of core0 for entering low power mode  Note: assertion of all "
        "bits[27:22] will generate low power mode request",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CORE1_WFI",
        "Mask WFI of core1 for entering low power mode  Note: assertion of all "
        "bits[27:22] will generate low power mode request",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CORE2_WFI",
        "Mask WFI of core2 for entering low power mode  Note: assertion of all "
        "bits[27:22] will generate low power mode request",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CORE3_WFI",
        "Mask WFI of core3 for entering low power mode  Note: assertion of all "
        "bits[27:22] will generate low power mode request",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_SCU_IDLE",
        "Mask SCU IDLE for entering low power mode  Note: assertion of all bits"
        "[27:22] will generate low power mode request",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_L2CC_IDLE",
        "Mask L2CC IDLE for entering low power mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CISR.
static const field_t hw_ccm_cisr[] =
{
    {
        "LRF_PLL",
        "Interrupt ipi_int_2 generated due to lock of all enabled and not bypas"
        "eed pll's",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_READY",
        "Interrupt ipi_int_2 generated due to on board oscillator ready, i.e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of axi_a_podf",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_B_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of axi_b_podf",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH2_CLK_SEL_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of periph2_clk_s"
        "el",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of ahb_podf",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_CH1_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of mmdc_ch0_podf"
        "_ loaded",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK_SEL_LOADED",
        "Interrupt ipi_int_1 generated due to update of periph_clk_sel.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_CH0_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to update of mmdc_ch0_axi_podf.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_PODF_LOADED",
        "Interrupt ipi_int_1 generated due to frequency change of arm_podf.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CIMR.
static const field_t hw_ccm_cimr[] =
{
    {
        "MASK_LRF_PLL",
        "mask interrupt generation due to lrf of pll's",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_COSC_READY",
        "mask interrupt generation due to on board oscillator ready",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_AXI_PODF_LOADED",
        "mask interrupt generation due to frequency change of axi_podf",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_AXI_B_PODF_LOADED",
        "mask interrupt generation due to frequency change of axi_b_podf",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MASK_PERIPH2_CLK_SEL_LOADED",
        "mask interrupt generation due to update of periph2_clk_sel.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_AHB_PODF_LOADED",
        "mask interrupt generation due to frequency change of ahb_podf",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_MMDC_CH1_PODF_LOADED",
        "mask interrupt generation due to update of mask_mmdc_ch1_podf",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_PERIPH_CLK_SEL_LOADED",
        "mask interrupt generation due to update of periph_clk_sel.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_MMDC_CH0_PODF_LOADED",
        "mask interrupt generation due to update of mask_mmdc_ch0_podf",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_PODF_LOADED",
        "mask interrupt generation due to frequency change of arm_podf",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCOSR.
static const field_t hw_ccm_ccosr[] =
{
    {
        "CLKO1_SEL",
        "Selection of the clock to be generated on clko1",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_DIV",
        "Setting the divider of CLKO1",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_EN",
        "Enable of CLKO1 clock",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_CLKO2_SEL",
        "CLKO1 output to reflect clko1 or clko2 clocks",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_SEL",
        "Selection of the clock to be generated on clko2",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_DIV",
        "Setting the divider of CLKO2",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_EN",
        "Enable of CLKO2 clock",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CGPR.
static const field_t hw_ccm_cgpr[] =
{
    {
        "PMIC_DELAY_SCALER",
        "Defines clock dividion of clock for stby_count (pmic delay counter)",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_EXT_CLK_DIS",
        "Disable external clock driver of MMDC during STOP mode",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EFUSE_PROG_SUPPLY_GATE",
        "Defines the value of the output signal cgpr_dout[4].",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FPL",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR0.
static const field_t hw_ccm_ccgr0[] =
{
    {
        "CG0",
        "aips_tz1 clocks (aips_tz1_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "aips_tz2 clocks (aips_tz2_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "apbhdma hclk clock (apbhdma_hclk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "asrc clock (asrc_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "caam_secure_mem clock (caam_secure_mem_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "caam_wrapper_aclk clock (caam_wrapper_aclk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "caam_wrapper_ipg clock (caam_wrapper_ipg_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "can1 clock (can1_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "can1_serial clock (can1_serial_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "can2 clock (can2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "can2_serial clock (can2_serial_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "CPU debug clocks (cheetah_dbg_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "dcic 1 clocks (dcic1_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "dcic2 clocks (dcic2_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "dtcp clocks (dtcp_dtcp_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR1.
static const field_t hw_ccm_ccgr1[] =
{
    {
        "CG0",
        "ecspi1 clocks (ecspi1_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "ecspi2 clocks (ecspi2_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "ecspi3 clocks (ecspi3_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "ecspi4 clocks (ecspi4_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "ecspi5 clocks (ecspi5_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "clock (enet_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "epit1 clocks (epit1_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "epit2 clocks (epit2_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "esai clocks (esai_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "Reserved",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "gpt bus clock (gpt_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "gpt serial clock (gpt_serial_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "gpu2d clock (gpu2d_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "gpu3d clock (gpu3d_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "Reserved",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR2.
static const field_t hw_ccm_ccgr2[] =
{
    {
        "CG0",
        "hdmi_tx_iahbclk, hdmi_tx_ihclk clock (hdmi_tx_iahbclk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "Reserved",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "hdmi_tx_isfrclk clock (hdmi_tx_isfrclk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "i2c1_serial clock (i2c1_serial_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "i2c2_serial clock (i2c2_serial_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "i2c3_serial clock (i2c3_serial_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "OCOTP_CTRL clock (iim_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "iomux_ipt_clk_io clock (iomux_ipt_clk_io_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "ipmux1 clock (ipmux1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "ipmux2 clock (ipmux2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "ipmux3 clock (ipmux3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "ipsync_ip2apb_tzasc1_ipg clocks (ipsync_ip2apb_tzasc1_ipg_master_clk_e"
        "nable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "ipsync_vdoa_ipg clocks (ipsync_ip2apb_tzasc2_ipg clocks)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "ipsync_vdoa_ipg clocks (ipsync_vdoa_ipg_master_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "Reserved",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR3.
static const field_t hw_ccm_ccgr3[] =
{
    {
        "CG0",
        "ipu1_ipu clock (ipu1_ipu_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "ipu1_ipu_di0 clock (ipu1_ipu_di0_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "ipu1_ipu_di1 clock (ipu1_ipu_di1_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "ipu2_ipu clock (ipu2_ipu_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "ipu2_ipu_di0 clock (ipu2_ipu_di0_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "ipu2_ipu_di1 clock (ipu2_ipu_di1_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "ldb_di0 clock (ldb_di0_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "ldb_di1 clock (ldb_di1_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "mipi_core_cfg clock (mipi_core_cfg_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "mlb clock (mlb_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "mmdc_core_aclk_fast_core_p0 clock (mmdc_core_aclk_fast_core_p0_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "mmdc_core_aclk_fast_core_p1 clock (mmdc_core_aclk_fast_core_p1_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "mmdc_core_ipg_clk_p0 clock (mmdc_core_ipg_clk_p0_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "mmdc_core_ipg_clk_p1 clock (mmdc_core_ipg_clk_p1_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "ocram clock (ocram_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "openvgaxiclk clock (openvgaxiclk_clk_root_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR4.
static const field_t hw_ccm_ccgr4[] =
{
    {
        "CG0",
        "125M clocks (125M_root_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "Reserved.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "Reserved.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "Reserved.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "pl301_mx6qfast1_s133 clock (pl301_mx6qfast1_s133clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "Reserved",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "pl301_mx6qper1_bch clocks (pl301_mx6qper1_bchclk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "pl301_mx6qper2_mainclk_enable (pl301_mx6qper2_mainclk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "pwm1 clocks (pwm1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "pwm2 clocks (pwm2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "pwm3 clocks (pwm3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "pwm4 clocks (pwm4_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "rawnand_u_bch_input_apb clock (rawnand_u_bch_input_apb_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "rawnand_u_gpmi_bch_input_bch clock (rawnand_u_gpmi_bch_input_bch_clk_e"
        "nable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "rawnand_u_gpmi_bch_input_gpmi_io clock (rawnand_u_gpmi_bch_input_gpmi_"
        "io_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "rawnand_u_gpmi_input_apb clock rawnand_u_gpmi_input_apb_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR5.
static const field_t hw_ccm_ccgr5[] =
{
    {
        "CG0",
        "rom clock (rom_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "Reserved",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "100M clock (100M_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "sdma clock (sdma_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "Reserved",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "Reserved",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "spba clock (spba_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "spdif clock (spdif_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "Reserved",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "ssi1 clocks (ssi1_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "ssi2 clocks (ssi2_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "ssi3 clocks (ssi3_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "uart clock (uart_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "uart_serial clock (uart_serial_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "Reserved",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR6.
static const field_t hw_ccm_ccgr6[] =
{
    {
        "CG0",
        "usboh3 clock (usboh3_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "usdhc1 clocks (usdhc1_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "usdhc2 clocks (usdhc2_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "usdhc3 clocks (usdhc3_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "usdhc4 clocks (usdhc4_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "emi_slow clocks (emi_slow_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "vdoaxiclk root clock (vdoaxiclk_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "vpu clocks (vpu_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "Reserved",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "Reserved",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "Reserved",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "Reserved",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "Reserved",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "Reserved",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "Reserved",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CMEOR.
static const field_t hw_ccm_cmeor[] =
{
    {
        "MOD_EN_OV_VDOA",
        "overide clock enable signal from vdoa - clock will not be gated based "
        "on vdoa signal.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_GPT",
        "overide clock enable signal from gpt - clock will not be gated based o"
        "n gpt's signal 'ipg_enable_clk' .",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_EPIT",
        "overide clock enable signal from epit - clock will not be gated based "
        "on epit's signal 'ipg_enable_clk' .",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_USDHC",
        "overide clock enable signal from usdhc.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_DAP",
        "overide clock enable signal from dap- clock will not be gated based on"
        " dap's signal 'dap_dbgen' .",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_VPU",
        "overide clock enable signal from vpu- clock will not be gated based on"
        " vpu's signal 'vpu_idle' .",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_GPU2D",
        "overide clock enable signal from gpu2d - clock will not be gated based"
        " on gpu2d's signal 'gpu2d_busy' .",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_GPU3D",
        "overide clock enable signal from gpu3d - clock will not be gated based"
        " on gpu3d's signal.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_CAN2_CPI",
        "overide clock enable signal from can2 - clock will not be gated based "
        "on can's signal 'enable_clk_cpi'.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_CAN1_CPI",
        "overide clock enable signal from can1 - clock will not be gated based "
        "on can's signal 'enable_clk_cpi'.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CCM module.
static const reg_t hw_ccm[] =
{
    {
        "CCR",
        "The figure below represents the CCM Control Register (CCR), which cont"
        "ains bits to control general operation of CCM.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_ccm_ccr
    },
    {
        "CCDR",
        "The figure below represents the CCM Control Divider Register (CCDR), w"
        "hich contains bits that control the loading of the dividers that need "
        "handshake with the modules they affect.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_ccm_ccdr
    },
    {
        "CSR",
        "The figure below represents the CCM status Register (CSR).",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_ccm_csr
    },
    {
        "CCSR",
        "The figure below represents the CCM Clock Switcher register (CCSR).",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_ccsr
    },
    {
        "CACRR",
        "The figure below represents the CCM Arm Clock Root register (CACRR).",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_cacrr
    },
    {
        "CBCDR",
        "The figure below represents the CCM Bus Clock Divider Register (CBCDR)"
        ".",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_cbcdr
    },
    {
        "CBCMR",
        "The figure below represents the CCM Bus Clock Multiplexer Register (CB"
        "CMR).",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_ccm_cbcmr
    },
    {
        "CSCMR1",
        "The figure below represents the CCM Serial Clock Multiplexer Register "
        "1 (CSCMR1).",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_cscmr1
    },
    {
        "CSCMR2",
        "The figure below represents the CCM Serial Clock Multiplexer Register "
        "2 (CSCMR2).",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_cscmr2
    },
    {
        "CSCDR1",
        "The figure below represents the CCM Serial Clock Divider Register 1 (C"
        "SCDR1).",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cscdr1
    },
    {
        "CS1CDR",
        "The figure below represents the CCM SSI1, SSI3, ESAI Clock Divider Reg"
        "ister (CS1CDR).",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cs1cdr
    },
    {
        "CS2CDR",
        "The figure below represents the CCM SSI2, LDB Clock Divider Register ("
        "CS2CDR).",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_cs2cdr
    },
    {
        "CDCDR",
        "The figure below represents the CCM DI Clock Divider Register (CDCDR).",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_cdcdr
    },
    {
        "CHSCCDR",
        "The figure below represents the CCM IPU1 DI Clock Divider Register (CH"
        "SCCDR).",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_chsccdr
    },
    {
        "CSCDR2",
        "The figure below represents the CCM Serial Clock Divider Register 2(CS"
        "CDR2).",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_cscdr2
    },
    {
        "CSCDR3",
        "The figure below represents the CCM Serial Clock Divider Register 3(CS"
        "CDR3).",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_cscdr3
    },
    {
        "CWDR",
        "The figure below represents the CCM Wakeup Detector Register (CWDR).",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_ccm_cwdr
    },
    {
        "CDHIPR",
        "The figure below represents the CCM Divider Handshake In-Process Regis"
        "ter (CDHIPR).",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        false, // Writable
        7, // Number of bitfields
        hw_ccm_cdhipr
    },
    {
        "CTOR",
        "The figure below represents the CCM Testing Observability Register (CT"
        "OR).",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_ctor
    },
    {
        "CLPCR",
        "The figure below represents the CCM Low Power Control Register (CLPCR)"
        ".",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_clpcr
    },
    {
        "CISR",
        "The figure below represents the CCM Interrupt Status Register (CISR).",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cisr
    },
    {
        "CIMR",
        "The figure below represents the CCM Interrupt Mask Register (CIMR).",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cimr
    },
    {
        "CCOSR",
        "The figure below represents the CCM Clock Output Source Register (CCOS"
        "R).",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_ccosr
    },
    {
        "CGPR",
        "Fast PLL enable.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_cgpr
    },
    {
        "CCGR0",
        "CG(i) bits CCGR 0-7  These bits are used to turn on/off the clock to e"
        "ach module independently.The following table details the possible cloc"
        "k activity conditions for each module         CGR value    Clock Activ"
        "ity Description        00    clock is off during all modes.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr0
    },
    {
        "CCGR1",
        "The figure below represents the CCM Clock Gating Register 1(CCM_CCGR1)"
        ".",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr1
    },
    {
        "CCGR2",
        "The figure below represents the CCM Clock Gating Register 2 (CCM_CCGR2"
        ").",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr2
    },
    {
        "CCGR3",
        "The figure below represents the CCM Clock Gating Register 3 (CCM_CCGR3"
        ").",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr3
    },
    {
        "CCGR4",
        "The figure below represents the CCM Clock Gating Register 4 (CCM_CCGR4"
        ").",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr4
    },
    {
        "CCGR5",
        "The figure below represents the CCM Clock Gating Register 5 (CCM_CCGR5"
        ").",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr5
    },
    {
        "CCGR6",
        "The figure below represents the CCM Clock Gating Register 6 (CCM_CCGR6"
        ").",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr6
    },
    {
        "CMEOR",
        "The follow figure represents the CCM Module Enable Override Register ("
        "CMEOR).",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cmeor
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CCM_ANALOG
#endif

// Bitfields in register CCM_ANALOG_PLL_ARM.
static const field_t hw_ccm_analog_pll_arm[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LF",
        "Reserved by Freescale.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_LF",
        "Reserved by Freescale.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_CP",
        "Reserved by Freescale.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_CP",
        "Reserved by Freescale.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLD_RING_OFF",
        "Analog debug bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_SEL",
        "Analog Debug Bit",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_24MHZ_SEL",
        "Analog Debug Bit",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_USB1.
static const field_t hw_ccm_analog_pll_usb1[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_USB2.
static const field_t hw_ccm_analog_pll_usb2[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_SYS.
static const field_t hw_ccm_analog_pll_sys[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LF",
        "Reserved by Freescale",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_LF",
        "Reserved by Freescale",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_CP",
        "Reserved by Freescale",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_CP",
        "Reserved by Freescale",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLD_RING_OFF",
        "Analog Debug bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_SYS_SS.
static const field_t hw_ccm_analog_pll_sys_ss[] =
{
    {
        "STEP",
        "frequency change step = step/B*24MHz.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "This bit enables the spread spectrum modulation.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP",
        "Frequency change = stop/B*24MHz.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_SYS_NUM.
static const field_t hw_ccm_analog_pll_sys_num[] =
{
    {
        "A",
        "30 bit numerator (A) of fractional loop divider (signed integer).",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_SYS_DENOM.
static const field_t hw_ccm_analog_pll_sys_denom[] =
{
    {
        "B",
        "30 bit Denominator (B) of fractional loop divider (unsigned integer).",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_AUDIO.
static const field_t hw_ccm_analog_pll_audio[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LF",
        "Reserved by Freescale.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_LF",
        "Reserved by Freescale.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_CP",
        "Reserved by Freescale.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_CP",
        "Reserved by Freescale.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLD_RING_OFF",
        "Analog debug Bit",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSC_EN",
        "Reserved Bit",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_AUDIO_NUM.
static const field_t hw_ccm_analog_pll_audio_num[] =
{
    {
        "A",
        "30 bit numerator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_AUDIO_DENOM.
static const field_t hw_ccm_analog_pll_audio_denom[] =
{
    {
        "B",
        "30 bit Denominator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_VIDEO.
static const field_t hw_ccm_analog_pll_video[] =
{
    {
        "DIV_SELECT",
        "This field controls the pll loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LF",
        "Reserved by Freescale.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_LF",
        "Reserved by Freescale.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_CP",
        "Reserved by Freescale.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_CP",
        "Reserved by Freescale.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLD_RING_OFF",
        "Analog Debug bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSC_EN",
        "Revserved BIt",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked;  0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_VIDEO_NUM.
static const field_t hw_ccm_analog_pll_video_num[] =
{
    {
        "A",
        "30 bit numerator of fractional loop divider(Signed number), absolute v"
        "alue should be less than denominator",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_VIDEO_DENOM.
static const field_t hw_ccm_analog_pll_video_denom[] =
{
    {
        "B",
        "30 bit Denominator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_MLB.
static const field_t hw_ccm_analog_pll_mlb[] =
{
    {
        "HOLD_RING_OFF",
        "Analog debug bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHASE_SEL",
        "Analog debut bit.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VDDA_DELAY_CFG",
        "Configure the phase delay of the MLB PLL by adjusting the delay line i"
        "n Vddio power domain.",
        17, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VDDD_DELAY_CFG",
        "Configure the phase delay of the MLB PLL by adjusting the delay line i"
        "n core Vdd poser domain.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_CLK_DELAY_CFG",
        "Configure the phase delay of the MLB PLL RX Clock.",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MLB_FLT_RES_CFG",
        "Configure the filter resistor for different divider ratio of MLB PLL.",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "Lock bit",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PLL_ENET.
static const field_t hw_ccm_analog_pll_enet[] =
{
    {
        "DIV_SELECT",
        "Controls the frequency of the ethernet reference clock.00 - 25MHz; 01 "
        "- 50MHz; 10 - 100MHz (not 50% duty cycle); 11 - 125MHz;",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_LF",
        "Reserved by Freescale",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_LF",
        "Reserved by Freescale",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_CP",
        "Reserved by Freescale",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOUBLE_CP",
        "Reserved by Freescale",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLD_RING_OFF",
        "Analog debug bit",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the ethernet clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the pll.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_100M",
        "Enables an offset in the phase frequency detector.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PFD_480.
static const field_t hw_ccm_analog_pfd_480[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_PFD_528.
static const field_t hw_ccm_analog_pfd_528[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_MISC0.
static const field_t hw_ccm_analog_misc0[] =
{
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        11, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_MISC2.
static const field_t hw_ccm_analog_misc2[] =
{
    {
        "PLL3_DISABLE",
        "Default value of \"0\".",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL: 0x0=div-by-1(default), 0x1=div-by-2"
        ", 0x2=div-by-1, 0x3=div-by-4.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL: 0x0=div-by-1(default), 0x1=div-by-2"
        ", 0x2=div-by-1, 0x3=div-by-4.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video: 0x0=div-by-1(default), 0x1=div-by-2, 0x2=div-b"
        "y-1, 0x3=div-by-4.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CCM_ANALOG module.
static const reg_t hw_ccm_analog[] =
{
    {
        "PLL_ARM",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_pll_arm
    },
    {
        "PLL_USB1",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_pll_usb1
    },
    {
        "PLL_USB2",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_pll_usb2
    },
    {
        "PLL_SYS",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_pll_sys
    },
    {
        "PLL_SYS_SS",
        "This register contains the 528 PLL spread spectrum controls.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ccm_analog_pll_sys_ss
    },
    {
        "PLL_SYS_NUM",
        "This register contains the numerator of 528MHz PLL fractional loop div"
        "ider (signed number).",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_pll_sys_num
    },
    {
        "PLL_SYS_DENOM",
        "This register contains the Denominator of 528MHz PLL fractional loop d"
        "ivider.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_pll_sys_denom
    },
    {
        "PLL_AUDIO",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_pll_audio
    },
    {
        "PLL_AUDIO_NUM",
        "This register contains the numerator (A) of Audio PLL fractional loop "
        "divider.(Signed number), absolute value should be less than denominato"
        "r  Absolute value should be less than denominator",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_pll_audio_num
    },
    {
        "PLL_AUDIO_DENOM",
        "This register contains the Denominator (B) of Audio PLL fractional loo"
        "p divider.(unsigned number)",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_pll_audio_denom
    },
    {
        "PLL_VIDEO",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_pll_video
    },
    {
        "PLL_VIDEO_NUM",
        "This register contains the numerator (A) of Video PLL fractional loop "
        "divider.(Signed number)  Absolute value should be less than denominato"
        "r",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_pll_video_num
    },
    {
        "PLL_VIDEO_DENOM",
        "This register contains the Denominator (B) of Video PLL fractional loo"
        "p divider.(Unsigned number)",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_pll_video_denom
    },
    {
        "PLL_MLB",
        "This register defines the control bits for the MLB PLL.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_pll_mlb
    },
    {
        "PLL_ENET",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_pll_enet
    },
    {
        "PFD_480",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_pfd_480
    },
    {
        "PFD_528",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_pfd_528
    },
    {
        "MISC0",
        "This register defines the control for miscellaneous CCM Analog blocks.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_misc0
    },
    {
        "MISC2",
        "This register defines the control for miscellaneous CCM Analog blocks.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_analog_misc2
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CSI2IPU
#endif

// Bitfields in register CSI2IPU_SW_RST.
static const field_t hw_csi2ipu_sw_rst[] =
{
    {
        "SW_RST",
        "Software Reset",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLK_SEL",
        "Clock mode selection",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "YUV422_8BIT_FM",
        "YUV422 8-bit mode selection",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RGB444_FM",
        "rgb444 mode selection",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CSI2IPU module.
static const reg_t hw_csi2ipu[] =
{
    {
        "SW_RST",
        "This register describes the IPU interface signals.",
        4, // Width in bytes
        0x00000f00, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_csi2ipu_sw_rst
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CSU
#endif

// Bitfields in register CSU_CSL0.
static const field_t hw_csu_csl0[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL1.
static const field_t hw_csu_csl1[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL2.
static const field_t hw_csu_csl2[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL3.
static const field_t hw_csu_csl3[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL4.
static const field_t hw_csu_csl4[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL5.
static const field_t hw_csu_csl5[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL6.
static const field_t hw_csu_csl6[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL7.
static const field_t hw_csu_csl7[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL8.
static const field_t hw_csu_csl8[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL9.
static const field_t hw_csu_csl9[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL10.
static const field_t hw_csu_csl10[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL11.
static const field_t hw_csu_csl11[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL12.
static const field_t hw_csu_csl12[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL13.
static const field_t hw_csu_csl13[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL14.
static const field_t hw_csu_csl14[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL15.
static const field_t hw_csu_csl15[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL16.
static const field_t hw_csu_csl16[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL17.
static const field_t hw_csu_csl17[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL18.
static const field_t hw_csu_csl18[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL19.
static const field_t hw_csu_csl19[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL20.
static const field_t hw_csu_csl20[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL21.
static const field_t hw_csu_csl21[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL22.
static const field_t hw_csu_csl22[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL23.
static const field_t hw_csu_csl23[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL24.
static const field_t hw_csu_csl24[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL25.
static const field_t hw_csu_csl25[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL26.
static const field_t hw_csu_csl26[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL27.
static const field_t hw_csu_csl27[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL28.
static const field_t hw_csu_csl28[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL29.
static const field_t hw_csu_csl29[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL30.
static const field_t hw_csu_csl30[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL31.
static const field_t hw_csu_csl31[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL32.
static const field_t hw_csu_csl32[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL33.
static const field_t hw_csu_csl33[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL34.
static const field_t hw_csu_csl34[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL35.
static const field_t hw_csu_csl35[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL36.
static const field_t hw_csu_csl36[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL37.
static const field_t hw_csu_csl37[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL38.
static const field_t hw_csu_csl38[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_CSL39.
static const field_t hw_csu_csl39[] =
{
    {
        "SUR_S2",
        "Secure user read access control for the second slave",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S2",
        "Secure supervisor read access control for the second slave",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S2",
        "Non-secure user read access control for the second slave",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S2",
        "Non-secure supervisor read access control for the second slave",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S2",
        "Secure user write access control for the second slave",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S2",
        "Secure supervisor write access control for the second slave",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S2",
        "Non-secure user write access control for the second slave",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S2",
        "Non-secure supervisor write access control for the second slave",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S2",
        "Lock bit corresponding to the second slave.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUR_S1",
        "Secure user read access control for the first slave",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSR_S1",
        "Secure supervisor read access control for the first slave",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUR_S1",
        "Non-secure user read access control for the first slave",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSR_S1",
        "Non-secure supervisor read access control for the first slave",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUW_S1",
        "Secure user write access control for the first slave",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSW_S1",
        "Secure supervisor write access control for the first slave",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NUW_S1",
        "Non-secure user write access control for the first slave",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSW_S1",
        "Non-secure supervisor write access control for the first slave",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_S1",
        "Lock bit corresponding to the first slave.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_HP0.
static const field_t hw_csu_hp0[] =
{
    {
        "HP_PCIE",
        "Indicates the Privilege/User Mode for PCIE",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_PCIE",
        "Lock bit set by TZ software for HP_PCIE.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_SATA",
        "Indicates the Privilege/User Mode for SATA",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_SATA",
        "Lock bit set by TZ software for HP_SATA.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_SDMA",
        "Indicates the Privilege/User Mode for SDMA.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_SDMA",
        "Lock bit set by TZ software for HP_SDMA.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_PU",
        "Indicates the Privilege/User Mode for GPU3D, GPU2D, VPU, IPU1, IPU2, O"
        "penVG and VDOA.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_PU",
        "Lock bit set by TZ software for HP_PU.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_USB",
        "Indicates the Privilege/User Mode for USB.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USB",
        "Lock bit set by TZ software for HP_USB.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_TEST",
        "Indicates the Privilege/User Mode for IOMUX Test Port.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_TEST",
        "Lock bit set by TZ software for HP_TEST.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_MLB",
        "Indicate the mode Privilege/User Mode for MLB.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_MLB",
        "Lock bit set by TZ software for HP_MLB.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_CAAM",
        "Indicates the Privilege/User Mode for CAAM",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_CAAM",
        "Lock bit set by TZ software for HP_CAAM.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_RAWNAND",
        "Indicates the Privilege/User Mode for RawNAND",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_RAWNAND",
        "Lock bit set by TZ software for HP_RAWNAND.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_APBHDMA",
        "Indicates the Privilege/User Mode for APBHDMA",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_ABPHDMA",
        "Lock bit set by TZ software for HP_APBHDMA.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_ENET",
        "Indicates the Privilege/User Mode for ENET",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_ENET",
        "Lock bit set by TZ software for HP_ENET.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_DAP",
        "Indicates the Privilege/User Mode for DAP",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_DAP",
        "Lock bit set by TZ software for HP_DAP.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_USDHC1",
        "Indicates the Privilege/User Mode for USDHC1",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC1",
        "Lock bit set by TZ software for HP_USDHC1.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_USDHC2",
        "Indicates the Privilege/User Mode for USDHC2",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC2",
        "Lock bit set by TZ software for HP_USDHC2.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_USDHC3",
        "Indicates the Privilege/User Mode for USDHC3",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC3",
        "Lock bit set by TZ software for HP_USDHC3.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HP_USDHC4",
        "Indicates the Privilege/User Mode for USDHC4.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC4",
        "Lock bit set by TZ software for HP_USDHC4.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_HP1.
static const field_t hw_csu_hp1[] =
{
    {
        "HP_HDMI_HSI",
        "Indicates the Privilege/User Mode for HDMI Tx and HSI.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_HDMI_HSI",
        "Lock bit set by TZ software for HP_HDMI_HSI.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_SA.
static const field_t hw_csu_sa[] =
{
    {
        "NSA_CP15",
        "Indicate the Type (Secured/Non-Secured) Access to ARM CP15 register.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_CP15",
        "Lock bit set by TZ software for NSA_CP15.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_SATA",
        "Indicates the type of access (Secured/Non-Secured) for SATA",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_SATA",
        "Lock bit set by TZ software for NSA_SATA.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_SDMA",
        "Indicate the Type (Secured/Non-Secured) Access for SDMA.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_SDMA",
        "Lock bit set by TZ software for NSA_SDMA.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_PU",
        "Indicate the Type (Secured/Non-Secured) Access for GPU3D, VDOA, GPU2D,"
        " IPU1, IPU2, OPENVG and VPU.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_PU",
        "Lock bit set by TZ software for NSA_PU.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_USB_MLB",
        "Indicate the Type (Secured/Non-Secured) Access for USB and MLB.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USB_MLB",
        "Lock bit set by TZ software for NSA_USB_MLB.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_PCIE_TEST",
        "Indicate the Type (Secured/Non-Secured) Access for PCIe and IOMUX Test"
        " Port.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_PCIE_TEST",
        "Lock bit set by TZ software for NSA_PCIE_TEST.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_RAWNAND_APBHDMA",
        "Indicate the Type (Secured/Non-Secured) Access for RawNAND and apbhdma"
        "t.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_RAWNAND_APBHDMA",
        "Lock bit set by TZ software for NSA_RAWNAND_APBHDMA.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_ENET",
        "Indicate the Type (Secured/Non-Secured) Access for ENET.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_ENET",
        "Lock bit set by TZ software for NSA_ENET.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_DAP",
        "Access Policy indicator bits",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_DAP",
        "Lock bit set by TZ software for NSA_DAP.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_USDHC1",
        "Indicate the Type (Secured/Non-Secured) Access for USDHC1.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC1",
        "Lock bit set by TZ software for NSA_USDHC1.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_USDHC2",
        "Indicate the Type (Secured/Non-Secured) Access for USDHC2.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC2",
        "Lock bit set by TZ software for NSA_USDHC2.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_USDHC3",
        "Indicate the Type (Secured/Non-Secured) Access for USDHC3.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC3",
        "Lock bit set by TZ software for NSA_USDHC3.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_USDHC4",
        "Indicate the Type (Secured/Non-Secured) Access for USDHC4.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC4",
        "Lock bit set by TZ software for NSA_USDHC14.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NSA_HDMI_HSI",
        "Indicate the Type (Secured/Non-Secured) Access for HDMI Tx and HSI.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_HDMI_HSI",
        "Lock bit set by TZ software for NSA_HDMI_HSI.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_HPCONTROL0.
static const field_t hw_csu_hpcontrol0[] =
{
    {
        "HPC_PCIE",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of PCIE.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_PCIE",
        "Lock bit set by TZ software for HPC_PCIE.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_SATA",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of SATA.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_SATA",
        "Lock bit set by TZ software for HPC_SATA.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_SDMA",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of SDMA.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_SDMA",
        "Lock bit set by TZ software for HPC_SDMA.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_PU",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of GPU3D, GPU2D, VPU, IPU1, IPU2, OpenVG and VDO"
        "A.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_PU",
        "Lock bit set by TZ software for HPC_PU.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_USB",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of USB.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USB",
        "Lock bit set by TZ software for HPC_USB.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_TEST",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of IOMUX Test Port.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_TEST",
        "Lock bit set by TZ software for HPC_TEST.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_MLB",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of MLB.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_MLB",
        "Lock bit set by TZ software for HPC_MLB.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_CAAM",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of CAAM.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_CAAM",
        "Lock bit set by TZ software for HPC_CAAM.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_RAWNAND",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of RawNAND.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_RAWNAND",
        "Lock bit set by TZ software for HPC_RAWNAND.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_APBHDMA",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of apbhdma.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_ABPHDMA",
        "Lock bit set by TZ software for HPC_APBHDMA.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_ENET",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of ENET.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_ENET",
        "Lock bit set by TZ software for HPC_ENET.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_DAP",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of DAP.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_DAP",
        "Lock bit set by TZ software for HPC_DAP.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_USDHC1",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of USDHC1.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC1",
        "Lock bit set by TZ software for HPC_USDHC1.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_USDHC2",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of USDHC2.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC2",
        "Lock bit set by TZ software for HPC_USDHC2.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_USDHC3",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of USDHC3.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC3",
        "Lock bit set by TZ software for HPC_USDHC3.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPC_USDHC4",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of USDHC4.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_USDHC4",
        "Lock bit set by TZ software for HPC_USDHC4.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSU_HPCONTROL1.
static const field_t hw_csu_hpcontrol1[] =
{
    {
        "HPC_HDMI_HSI",
        "Determines if the Register value of the HP field corresponding will be"
        " pass as the hprot[1] of HDMI Tx and HSI.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L_HDMI_HSI",
        "Lock bit set by TZ software for HPC_HDMI_HSI.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CSU module.
static const reg_t hw_csu[] =
{
    {
        "CSL0",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl0
    },
    {
        "CSL1",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl1
    },
    {
        "CSL2",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl2
    },
    {
        "CSL3",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl3
    },
    {
        "CSL4",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl4
    },
    {
        "CSL5",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl5
    },
    {
        "CSL6",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl6
    },
    {
        "CSL7",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl7
    },
    {
        "CSL8",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl8
    },
    {
        "CSL9",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl9
    },
    {
        "CSL10",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl10
    },
    {
        "CSL11",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl11
    },
    {
        "CSL12",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl12
    },
    {
        "CSL13",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl13
    },
    {
        "CSL14",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl14
    },
    {
        "CSL15",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl15
    },
    {
        "CSL16",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl16
    },
    {
        "CSL17",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl17
    },
    {
        "CSL18",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl18
    },
    {
        "CSL19",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl19
    },
    {
        "CSL20",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl20
    },
    {
        "CSL21",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl21
    },
    {
        "CSL22",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl22
    },
    {
        "CSL23",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl23
    },
    {
        "CSL24",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl24
    },
    {
        "CSL25",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl25
    },
    {
        "CSL26",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl26
    },
    {
        "CSL27",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl27
    },
    {
        "CSL28",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl28
    },
    {
        "CSL29",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl29
    },
    {
        "CSL30",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl30
    },
    {
        "CSL31",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl31
    },
    {
        "CSL32",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl32
    },
    {
        "CSL33",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl33
    },
    {
        "CSL34",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl34
    },
    {
        "CSL35",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl35
    },
    {
        "CSL36",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl36
    },
    {
        "CSL37",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl37
    },
    {
        "CSL38",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl38
    },
    {
        "CSL39",
        "There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers.",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csu_csl39
    },
    {
        "HP0",
        "The SCU_HP0 and SCU_HP1 registers may be programmed to determine the p"
        "rivilege (either User Mode or Supervisor Mode) for seventeen different"
        " master groups.",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_csu_hp0
    },
    {
        "HP1",
        "The SCU_HP1 register is an expansion of the SCU_HP0 register.",
        4, // Width in bytes
        0x00000204, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_csu_hp1
    },
    {
        "SA",
        "The Secure Access register may be programmed to specify the access pol"
        "icy (either Secure or Non-secure) for up to sixteen different masters.",
        4, // Width in bytes
        0x00000218, // Base address offset
        true, // Readable
        true, // Writable
        28, // Number of bitfields
        hw_csu_sa
    },
    {
        "HPCONTROL0",
        "The HP Control registers CSU_HPCONTROL0 and CSU_HPCONTROL1 enable CSU "
        "to control the USER/SUPERVISOR mode state for the specified masters.",
        4, // Width in bytes
        0x00000358, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_csu_hpcontrol0
    },
    {
        "HPCONTROL1",
        "The SCU_HPCONTROL1 register is expansion of SCU_HPCONTROL0 register.",
        4, // Width in bytes
        0x0000035c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_csu_hpcontrol1
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DCIC
#endif

// Bitfields in register DCIC_DCICC.
static const field_t hw_dcic_dcicc[] =
{
    {
        "IC_EN",
        "Integrity Check enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DE_POL",
        "DATA_EN_IN signal polarity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HSYNC_POL",
        "HSYNC_IN signal polarity.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSYNC_POL",
        "VSYNC_IN signal polarity.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLK_POL",
        "DISP_CLK signal polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICIC.
static const field_t hw_dcic_dcicic[] =
{
    {
        "EI_MASK",
        "Error Interrupt mask.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FI_MASK",
        "Functional Interrupt mask.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FREEZE_MASK",
        "Disable change of interrupt masks.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXT_SIG_EN",
        "External controller mismatch indication signal.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICS.
static const field_t hw_dcic_dcics[] =
{
    {
        "ROI_MATCH_STAT",
        "Each set bit of this field indicates there was a mismatch at appropria"
        "te ROIs signature during the last frame.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EI_STAT",
        "Error Interrupt status.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FI_STAT",
        "Functional Interrupt status.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICRC.
static const field_t hw_dcic_dcicrc[] =
{
    {
        "START_OFFSET_X",
        "Column number of ROIs upper-left corner (X coordinate)  Range: 0 to 2^"
        " 13 -1",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "START_OFFSET_Y",
        "Row number of ROIs upper-left corner (Y coordinate)  Range: 0 to 2^ 12"
        " -1",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROI_FREEZE",
        "When set, the only parameter of ROI #m that can be changed is referenc"
        "e signature.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROI_EN",
        "ROI #m tracking enable",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICRS.
static const field_t hw_dcic_dcicrs[] =
{
    {
        "END_OFFSET_X",
        "Column number of ROIs lower-right corner (X coordinate)  Range: 1 to 2"
        "^ 13 -1",
        0, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "END_OFFSET_Y",
        "Row number of ROIs lower-right corner (Y coordinate)  Range: 1 to 2^ 1"
        "2 -1",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICRRS.
static const field_t hw_dcic_dcicrrs[] =
{
    {
        "REFERENCE_SIGNATURE",
        "32-bit expected signature (CRC calculation result) for ROI #m",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DCIC_DCICRCS.
static const field_t hw_dcic_dcicrcs[] =
{
    {
        "CALCULATED_SIGNATURE",
        "32-bit actual signature (CRC calculation result) for ROI #m during the"
        " last frame.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a DCIC module.
static const reg_t hw_dcic[] =
{
    {
        "DCICC",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_dcic_dcicc
    },
    {
        "DCICIC",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dcic_dcicic
    },
    {
        "DCICS",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dcic_dcics
    },
    {
        "DCICRC",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_dcic_dcicrc
    },
    {
        "DCICRS",
        "",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dcic_dcicrs
    },
    {
        "DCICRRS",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_dcic_dcicrrs
    },
    {
        "DCICRCS",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_dcic_dcicrcs
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark DVFSC
#endif

// Bitfields in register DVFSC_THRS.
static const field_t hw_dvfsc_thrs[] =
{
    {
        "PNCTHR",
        "Panic threshold for load tracking",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DWTHR",
        "Down threshold for load tracking",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPTHR",
        "Upper threshold for load tracking",
        22, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_COUN.
static const field_t hw_dvfsc_coun[] =
{
    {
        "UPCNT",
        "UP counter threshold value",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DN_CNT",
        "Down counter threshold value",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_SIG1.
static const field_t hw_dvfsc_sig1[] =
{
    {
        "WSW6",
        "General purpose load tracking signal weight dvfs_w_sig[6]",
        2, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW7",
        "General purpose load tracking signal weight dvfs_w_sig[7]",
        5, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW8",
        "General purpose load tracking signal weight dvfs_w_sig[8]",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW9",
        "General purpose load tracking signal weight dvfs_w_sig[9]",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW10",
        "General purpose load tracking signal weight dvfs_w_sig[10]",
        14, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW11",
        "General purpose load tracking signal weight dvfs_w_sig[11]",
        17, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW12",
        "General purpose load tracking signal weight dvfs_w_sig[12]",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW13",
        "General purpose load tracking signal weight dvfs_w_sig[13]",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW14",
        "General purpose load tracking signal weight dvfs_w_sig[14]",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW15",
        "General purpose load tracking signal weight dvfs_w_sig[15]",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSSIG0.
static const field_t hw_dvfsc_dvfssig0[] =
{
    {
        "WSW0",
        "General purpose load tracking signal weight dvfs_w_sig[0].",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW1",
        "General purpose load tracking signal weight dvfs_w_sig[1].",
        6, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW2",
        "General purpose load tracking signal weight dvfs_w_sig[2]",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW3",
        "General purpose load tracking signal weight dvfs_w_sig[3]",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW4",
        "General purpose load tracking signal weight dvfs_w_sig[4]",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSW5",
        "General purpose load tracking signal weight dvfs_w_sig[5]",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSGPC0.
static const field_t hw_dvfsc_dvfsgpc0[] =
{
    {
        "GPBC0",
        "GPBC0 - General Purpose bits Counter 0  During period of this counter "
        "the GeP bit 0 will be set and WSW0 will be added to the calculations.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "C0ACT",
        "C0ACT - Counter 0 active indicator",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "C0STRT",
        "C0STRT - Counter 0 start  Setting of this bit will initialize down cou"
        "nting of the GPC0 value.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSGPC1.
static const field_t hw_dvfsc_dvfsgpc1[] =
{
    {
        "GPBC1",
        "GPBC1 - General Purpose bits Counter 1  During period of this counter "
        "the GeP bit 1 will be set and WSW1 will be added to the calculations.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "C1ACT",
        "C1ACT - Counter 1 active indicator",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "C1STRT",
        "C1STRT - Counter 1start  Setting of this bit will initialize down coun"
        "ting of the GPC1 value.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSGPBT.
static const field_t hw_dvfsc_dvfsgpbt[] =
{
    {
        "GPB0",
        "General purpose bit 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB1",
        "General purpose bit 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB2",
        "General purpose bit 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB3",
        "General purpose bit 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB4",
        "General purpose bit 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB5",
        "General purpose bit 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB6",
        "General purpose bit 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB7",
        "General purpose bit 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB8",
        "General purpose bit 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB9",
        "General purpose bit 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB10",
        "General purpose bit 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB11",
        "General purpose bit 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB12",
        "General purpose bit 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB13",
        "General purpose bit 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB14",
        "General purpose bit 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPB15",
        "General purpose bit 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSEMAC.
static const field_t hw_dvfsc_dvfsemac[] =
{
    {
        "EMAC",
        "EMAC - EMA control value",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFEN0",
        "DVFS tracking for core0 enable.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFEN1",
        "DVFS tracking for core1 enable.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFEN2",
        "DVFS tracking for core2 enable.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFEN3",
        "DVFS tracking for core3 enable.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSVAI0",
        "DVFS Frequency adjustment status of core 0.",
        16, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FSVAI1",
        "DVFS Frequency adjustment status of core 1.",
        18, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FSVAI2",
        "DVFS Frequency adjustment status of core 2.",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FSVAI3",
        "DVFS Frequency adjustment status of core 3.",
        22, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFIM0",
        "DVFS Wait for Interrupt of core 0 mask bit",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFIM1",
        "DVFS Wait for Interrupt of core 1 mask bit",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFIM2",
        "DVFS Wait for Interrupt of core 2mask bit",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFIM3",
        "DVFS Wait for Interrupt of core 3 mask bit",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_CNTR.
static const field_t hw_dvfsc_cntr[] =
{
    {
        "LTBRSR",
        "LTBRSR - Load Tracking Buffer Register Source:",
        3, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LTBRSH",
        "LTBRSH - Load Tracking Buffer Register Shift:",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFUS",
        "PFUS - Periodic Frequency Update Status",
        6, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFUE",
        "PFUE - Period Frequency Update Enable",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIV_RATIO",
        "DIV_RATIO - Divider value.",
        11, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MINF",
        "Minimum frequency reached.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAXF",
        "Maximum frequency reached.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSVAI",
        "FSVAI  DVFS Frequency adjustment interrupt.",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FSVAIM",
        "DVFS Frequency adjustment interrupt mask.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PIRQS",
        "PIRQS - Pattern IRQ Source  * write '1' to clear.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFIS",
        "DVFS Interrupt select.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBFL0",
        "Load buffer 0 - full status bit.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBFL1",
        "Load buffer 1 - full status bit.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBMI",
        "Load buffer full mask interrupt.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFEV",
        "Always give a DVFS event.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIV3CK",
        "DIV3CK - div_3_clk division ratio inside the DVFS module.",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR0_0.
static const field_t hw_dvfsc_dvfsltr0_0[] =
{
    {
        "LTS0_0",
        "core 0 Load Tracking Sample 0",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_1",
        "core 0 Load Tracking Sample 1",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_2",
        "core 0 Load Tracking Sample 2",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_3",
        "core 0 Load Tracking Sample 3",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_4",
        "core 0 Load Tracking Sample 4",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_5",
        "core 0 Load Tracking Sample 5",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_6",
        "core 0 Load Tracking Sample 6",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_7",
        "core 0 Load Tracking Sample 7",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR0_1.
static const field_t hw_dvfsc_dvfsltr0_1[] =
{
    {
        "LTS0_8",
        "core 0 Load Tracking Sample 8",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_9",
        "core 0 Load Tracking Sample 9",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_10",
        "core 0 Load Tracking Sample 10",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_11",
        "core 0 Load Tracking Sample 11",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_12",
        "core 0 Load Tracking Sample 12",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_13",
        "core 0 Load Tracking Sample 13",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_14",
        "core 0 Load Tracking Sample 14",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS0_15",
        "core 0 Load Tracking Sample 15",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR1_0.
static const field_t hw_dvfsc_dvfsltr1_0[] =
{
    {
        "LTS1_0",
        "core 0 Load Tracking Sample 0",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_1",
        "core 0 Load Tracking Sample 1",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_2",
        "core 0 Load Tracking Sample 2",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_3",
        "core 0 Load Tracking Sample 3",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_4",
        "core 0 Load Tracking Sample 4",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_5",
        "core 0 Load Tracking Sample 5",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_6",
        "core 0 Load Tracking Sample 6",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_7",
        "core 0 Load Tracking Sample 7",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSLTR1_1.
static const field_t hw_dvfsc_dvfsltr1_1[] =
{
    {
        "LTS1_8",
        "core 0 Load Tracking Sample 8",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_9",
        "core 0 Load Tracking Sample 9",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_10",
        "core 0 Load Tracking Sample 10",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_11",
        "core 0 Load Tracking Sample 11",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_12",
        "core 0 Load Tracking Sample 12",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_13",
        "core 0 Load Tracking Sample 13",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_14",
        "core 0 Load Tracking Sample 14",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LTS1_15",
        "core 0 Load Tracking Sample 15",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT0.
static const field_t hw_dvfsc_dvfspt0[] =
{
    {
        "FPTN0",
        "FPTN0 - Frequency pattern 0 counter  During period of this counter the"
        " frequency will be reduced from the EMA-detected level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT0A",
        "PT0A - Pattern 0 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT1.
static const field_t hw_dvfsc_dvfspt1[] =
{
    {
        "FPTN1",
        "FPTN1 - Frequency pattern 1 counter  During period of this counter the"
        " frequency will be set to the EMA-detected level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT1A",
        "PT1A - Pattern 1 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT2.
static const field_t hw_dvfsc_dvfspt2[] =
{
    {
        "FPTN2",
        "FPTN2 - Frequency pattern 2 counter  During period of this counter the"
        " frequency will be increased to higher, than detected by the EMA-detec"
        "ted level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT2A",
        "PT2A - Pattern 2 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "P2THR",
        "P2THR - Pattern 2 Threshold  Threshold of current DVFS load (after EMA"
        "), for generating interrupts with PFUS indicators 110, 111.",
        26, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register DVFSC_DVFSPT3.
static const field_t hw_dvfsc_dvfspt3[] =
{
    {
        "FPTN3",
        "FPTN3 - Frequency pattern 3 counter  During period of this counter the"
        " frequency will be set to the EMA-detected level.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PT3A",
        "PT3A - Pattern 3 currently active (read-only)",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a DVFSC module.
static const reg_t hw_dvfsc[] =
{
    {
        "THRS",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_thrs
    },
    {
        "COUN",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_coun
    },
    {
        "SIG1",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_dvfsc_sig1
    },
    {
        "DVFSSIG0",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_dvfsc_dvfssig0
    },
    {
        "DVFSGPC0",
        "DVFS general purpose bits weight counter.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_dvfsgpc0
    },
    {
        "DVFSGPC1",
        "DVFS general purpose bits weight counter1.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_dvfsgpc1
    },
    {
        "DVFSGPBT",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_dvfsc_dvfsgpbt
    },
    {
        "DVFSEMAC",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_dvfsc_dvfsemac
    },
    {
        "CNTR",
        "DIV3CK division         DIV3CK setting  dividing ratio  sum_3 passing "
        "bits  div_1_clk cumulative divider      00  1  4-0  1*512=512    001  "
        "4  6-2  4*512=2048    010  16  8-4  16*512=8192    011  64  10-6  64*5"
        "12=32768    100  256  12-8  256*512=131072    101  1024  16-10  1024*5"
        "12=524288       Preliminary Divider definition       DIV_RATIO value  "
        "ARM clk division ratio      000000  1    000001  2    000010  3    ...",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_dvfsc_cntr
    },
    {
        "DVFSLTR0_0",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr0_0
    },
    {
        "DVFSLTR0_1",
        "",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr0_1
    },
    {
        "DVFSLTR1_0",
        "",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr1_0
    },
    {
        "DVFSLTR1_1",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_dvfsc_dvfsltr1_1
    },
    {
        "DVFSPT0",
        "",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_dvfspt0
    },
    {
        "DVFSPT1",
        "",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_dvfspt1
    },
    {
        "DVFSPT2",
        "",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_dvfsc_dvfspt2
    },
    {
        "DVFSPT3",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_dvfsc_dvfspt3
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ECSPI
#endif

// Bitfields in register ECSPI_RXDATA.
static const field_t hw_ecspi_rxdata[] =
{
    {
        "ECSPI_RXDATA",
        "Receive Data.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_TXDATA.
static const field_t hw_ecspi_txdata[] =
{
    {
        "ECSPI_TXDATA",
        "Transmit Data.",
        0, // LSB
        31, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_CONREG.
static const field_t hw_ecspi_conreg[] =
{
    {
        "EN",
        "SPI Block Enable Control.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HT",
        "Hardware Trigger Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XCH",
        "SPI Exchange Bit.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMC",
        "Start Mode Control.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHANNEL_MODE",
        "SPI CHANNEL MODE selects the mode for each SPI channel.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIVIDER",
        "SPI Post Divider.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_DIVIDER",
        "SPI Pre Divider.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRCTL",
        "SPI Data Ready Control.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHANNEL_SELECT",
        "SPI CHANNEL SELECT bits.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BURST_LENGTH",
        "Burst Length.",
        20, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_CONFIGREG.
static const field_t hw_ecspi_configreg[] =
{
    {
        "SCLK_PHA",
        "SPI Clock/Data Phase Control.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCLK_POL",
        "SPI Clock Polarity Control.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SS_CTL",
        "SPI SS Wave Form Select.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SS_POL",
        "SPI SS Polarity Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_CTL",
        "DATA CTL.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCLK_CTL",
        "SCLK CTL.",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HT_LENGTH",
        "HT LENGTH.",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_INTREG.
static const field_t hw_ecspi_intreg[] =
{
    {
        "TEEN",
        "TXFIFO Empty Interrupt enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDREN",
        "TXFIFO Data Request Interrupt enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFEN",
        "TXFIFO Full Interrupt enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RREN",
        "RXFIFO Ready Interrupt enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDREN",
        "RXFIFO Data Request Interrupt enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFEN",
        "RXFIFO Full Interrupt enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROEN",
        "RXFIFO Overflow Interrupt enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCEN",
        "Transfer Completed Interrupt enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_DMAREG.
static const field_t hw_ecspi_dmareg[] =
{
    {
        "TX_THRESHOLD",
        "TX THRESHOLD.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEDEN",
        "TXFIFO Empty DMA Request Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_THRESHOLD",
        "RX THRESHOLD.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDEN",
        "RXFIFO DMA Request Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_DMA_LENGTH",
        "RX DMA LENGTH.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXTDEN",
        "RXFIFO TAIL DMA Request Enable.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_STATREG.
static const field_t hw_ecspi_statreg[] =
{
    {
        "TE",
        "TXFIFO Empty.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TDR",
        "TXFIFO Data Request.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TF",
        "TXFIFO Full.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RR",
        "RXFIFO Ready.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RDR",
        "RXFIFO Data Request.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RF",
        "RXFIFO Full.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RO",
        "RXFIFO Overflow.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TC",
        "Transfer Completed Status bit.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_PERIODREG.
static const field_t hw_ecspi_periodreg[] =
{
    {
        "SAMPLE_PERIOD",
        "Sample Period Control.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSRC",
        "Clock Source Control.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSD_CTL",
        "Chip Select Delay Control bits.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_TESTREG.
static const field_t hw_ecspi_testreg[] =
{
    {
        "TXCNT",
        "TXFIFO Counter.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXCNT",
        "RXFIFO Counter.",
        8, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBC",
        "Loop Back Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_MSGDATA.
static const field_t hw_ecspi_msgdata[] =
{
    {
        "ECSPI_MSGDATA",
        "ECSPI_MSGDATA holds the top word of MSG Data FIFO.",
        0, // LSB
        31, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ECSPI module.
static const reg_t hw_ecspi[] =
{
    {
        "RXDATA",
        "The Receive Data register (ECSPI_RXDATA) is a read-only register that "
        "forms the top word of the 64 x 32 receive FIFO.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ecspi_rxdata
    },
    {
        "TXDATA",
        "The Transmit Data (ECSPI_TXDATA) register is a write-only data registe"
        "r that forms the bottom word of the 64 x 32 TXFIFO.",
        4, // Width in bytes
        0x00000004, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ecspi_txdata
    },
    {
        "CONREG",
        "The Control Register (ECSPI_CONREG) allows software to enable the ECSP"
        "I , configure its operating modes, specify the divider value, and SPI_"
        "RDY control signal, and define the transfer length.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ecspi_conreg
    },
    {
        "CONFIGREG",
        "The Config Register (ECSPI_CONFIGREG) allows software to configure eac"
        "h SPI channel, configure its operating modes, specify the phase and po"
        "larity of the clock, configure the Chip Select (SS), and define the HT"
        " transfer length.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ecspi_configreg
    },
    {
        "INTREG",
        "The Interrupt Control Register (ECSPI_INTREG) enables the generation o"
        "f interrupts to the host processor.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ecspi_intreg
    },
    {
        "DMAREG",
        "The Direct Memory Access Control Register (ECSPI_DMAREG) provides soft"
        "ware a way to use an on-chip DMA controller for ECSPI data.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ecspi_dmareg
    },
    {
        "STATREG",
        "The ECSPI Status Register (ECSPI_STATREG) reflects the status of the E"
        "CSPI's operating condition.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ecspi_statreg
    },
    {
        "PERIODREG",
        "The Sample Period Control Register (ECSPI_PERIODREG) provides software"
        " a way to insert delays (wait states) between consecutive SPI transfer"
        "s.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ecspi_periodreg
    },
    {
        "TESTREG",
        "The Test Control Register (ECSPI_TESTREG) provides software a mechanis"
        "m to internally connect the receive and transmit devices of the ECSPI "
        " , and monitor the contents of the receive and transmit FIFOs.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ecspi_testreg
    },
    {
        "MSGDATA",
        "The Message Data Register (ECSPI_MSGDATA) forms the top word of the 16"
        " x 32 MSG Data FIFO.",
        4, // Width in bytes
        0x00000040, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ecspi_msgdata
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EIM
#endif

// Bitfields in register EIM_CS0GCR1.
static const field_t hw_eim_cs0gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0GCR2.
static const field_t hw_eim_cs0gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0RCR1.
static const field_t hw_eim_cs0rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0RCR2.
static const field_t hw_eim_cs0rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0WCR1.
static const field_t hw_eim_cs0wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0WCR2.
static const field_t hw_eim_cs0wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1GCR1.
static const field_t hw_eim_cs1gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1GCR2.
static const field_t hw_eim_cs1gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1RCR1.
static const field_t hw_eim_cs1rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1RCR2.
static const field_t hw_eim_cs1rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1WCR1.
static const field_t hw_eim_cs1wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1WCR2.
static const field_t hw_eim_cs1wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2GCR1.
static const field_t hw_eim_cs2gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2GCR2.
static const field_t hw_eim_cs2gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2RCR1.
static const field_t hw_eim_cs2rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2RCR2.
static const field_t hw_eim_cs2rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2WCR1.
static const field_t hw_eim_cs2wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2WCR2.
static const field_t hw_eim_cs2wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3GCR1.
static const field_t hw_eim_cs3gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3GCR2.
static const field_t hw_eim_cs3gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3RCR1.
static const field_t hw_eim_cs3rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3RCR2.
static const field_t hw_eim_cs3rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3WCR1.
static const field_t hw_eim_cs3wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3WCR2.
static const field_t hw_eim_cs3wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_WCR.
static const field_t hw_eim_wcr[] =
{
    {
        "BCM",
        "Burst Clock Mode.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBCD",
        "General Burst Clock Divisor.",
        1, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTEN",
        "Interrupt Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTPOL",
        "Interrupt Polarity.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WDOG_EN",
        "Memory WDog enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WDOG_LIMIT",
        "Memory Watch Dog (WDog) cycle limit.",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_WIAR.
static const field_t hw_eim_wiar[] =
{
    {
        "IPS_REQ",
        "IPS request.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPS_ACK",
        "IPS ACK.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT",
        "Interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERRST",
        "READY After Reset.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EN",
        "ACLK enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_EAR.
static const field_t hw_eim_ear[] =
{
    {
        "ERROR_ADDR",
        "Error Address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a EIM module.
static const reg_t hw_eim[] =
{
    {
        "CS0GCR1",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs0gcr1
    },
    {
        "CS0GCR2",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs0gcr2
    },
    {
        "CS0RCR1",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs0rcr1
    },
    {
        "CS0RCR2",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs0rcr2
    },
    {
        "CS0WCR1",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs0wcr1
    },
    {
        "CS0WCR2",
        "",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs0wcr2
    },
    {
        "CS1GCR1",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs1gcr1
    },
    {
        "CS1GCR2",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs1gcr2
    },
    {
        "CS1RCR1",
        "",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs1rcr1
    },
    {
        "CS1RCR2",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs1rcr2
    },
    {
        "CS1WCR1",
        "",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs1wcr1
    },
    {
        "CS1WCR2",
        "",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs1wcr2
    },
    {
        "CS2GCR1",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs2gcr1
    },
    {
        "CS2GCR2",
        "",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs2gcr2
    },
    {
        "CS2RCR1",
        "",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs2rcr1
    },
    {
        "CS2RCR2",
        "",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs2rcr2
    },
    {
        "CS2WCR1",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs2wcr1
    },
    {
        "CS2WCR2",
        "",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs2wcr2
    },
    {
        "CS3GCR1",
        "",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs3gcr1
    },
    {
        "CS3GCR2",
        "",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs3gcr2
    },
    {
        "CS3RCR1",
        "",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs3rcr1
    },
    {
        "CS3RCR2",
        "",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs3rcr2
    },
    {
        "CS3WCR1",
        "",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs3wcr1
    },
    {
        "CS3WCR2",
        "",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs3wcr2
    },
    {
        "WCR",
        "",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_wcr
    },
    {
        "WIAR",
        "",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_wiar
    },
    {
        "EAR",
        "",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_ear
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ENET
#endif

// Bitfields in register ENET_EIR.
static const field_t hw_enet_eir[] =
{
    {
        "TS_TIMER",
        "The adjustable timer reached the period event.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TS_AVAIL",
        "Indicates that the timestamp of the last transmitted timing frame is a"
        "vailable in the ATSTMP register.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP",
        "Read-only status bit to indicate that a magic packet has been detected"
        ".",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLR",
        "Indicates a frame was received with a payload length error.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UN",
        "Indicates the transmit FIFO became empty before the complete frame was"
        " transmitted.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Indicates a collision occurred on each of 16 successive attempts to tr"
        "ansmit the frame.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LC",
        "Indicates a collision occurred beyond the collision window (slot time)"
        " in half-duplex mode.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EBERR",
        "Indicates a system bus error occurred when a uDMA transaction is under"
        "way.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII",
        "Indicates that the MII has completed the data transfer requested.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB",
        "Indicates a receive buffer descriptor is not the last in the frame has"
        " been updated.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF",
        "Indicates a frame has been received and the last corresponding buffer "
        "descriptor has been updated.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB",
        "Indicates a transmit buffer descriptor has been updated.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF",
        "Indicates a frame has been transmitted and the last corresponding buff"
        "er descriptor has been updated.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRA",
        "This interrupt is asserted after the transmitter is put into a pause s"
        "tate after completion of the frame currently being transmitted.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABT",
        "Indicates the transmitted frame length exceeds RCR[MAX_FL] bytes.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABR",
        "Indicates a frame was received with length in excess of RCR[MAX_FL] by"
        "tes.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_EIMR.
static const field_t hw_enet_eimr[] =
{
    {
        "TS_TIMER",
        "Corresponds to interrupt source TS_TIMER defined by the EIR register a"
        "nd determines whether an interrupt condition can generate an interrupt"
        ".",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TS_AVAIL",
        "Corresponds to interrupt source TS_AVAIL defined by the EIR register a"
        "nd determines whether an interrupt condition can generate an interrupt"
        ".",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP",
        "Corresponds to interrupt source WAKEUP defined by the EIR register and"
        " determines whether an interrupt condition can generate an interrupt.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLR",
        "Corresponds to interrupt source PLR defined by the EIR register and de"
        "termines whether an interrupt condition can generate an interrupt.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UN",
        "Corresponds to interrupt source UN defined by the EIR register and det"
        "ermines whether an interrupt condition can generate an interrupt.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Corresponds to interrupt source RL defined by the EIR register and det"
        "ermines whether an interrupt condition can generate an interrupt.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LC",
        "Corresponds to interrupt source LC defined by the EIR register and det"
        "ermines whether an interrupt condition can generate an interrupt.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EBERR",
        "Corresponds to interrupt source EBERR defined by the EIR register and "
        "determines whether an interrupt condition can generate an interrupt.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII",
        "Corresponds to interrupt source MII defined by the EIR register and de"
        "termines whether an interrupt condition can generate an interrupt.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB",
        "Corresponds to interrupt source RXB defined by the EIR register and de"
        "termines whether an interrupt condition can generate an interrupt.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF",
        "Corresponds to interrupt source RXF defined by the EIR register and de"
        "termines whether an interrupt condition can generate an interrupt.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB",
        "Corresponds to interrupt source TXB defined by the EIR register and de"
        "termines whether an interrupt condition can generate an interrupt.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF",
        "Corresponds to interrupt source TXF defined by the EIR register and de"
        "termines whether an interrupt condition can generate an interrupt.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRA",
        "Corresponds to interrupt source GRA defined by the EIR register and de"
        "termines whether an interrupt condition can generate an interrupt.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABT",
        "Corresponds to interrupt source BABT defined by the EIR register and d"
        "etermines whether an interrupt condition can generate an interrupt.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABR",
        "Corresponds to interrupt source BABR defined by the EIR register and d"
        "etermines whether an interrupt condition can generate an interrupt.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDAR.
static const field_t hw_enet_rdar[] =
{
    {
        "RDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDAR.
static const field_t hw_enet_tdar[] =
{
    {
        "TDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ECR.
static const field_t hw_enet_ecr[] =
{
    {
        "RESET",
        "When this field is set, it clears the ETHER_EN field.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ETHEREN",
        "Enables/disables the Ethernet MAC.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAGICEN",
        "Enables/disables magic packet detection.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLEEP",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN1588",
        "Enables enhanced functionality of the MAC.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGEN",
        "Enables the MAC to enter hardware freeze mode when the device enters d"
        "ebug mode.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPEN",
        "Controls device behavior in doze mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MMFR.
static const field_t hw_enet_mmfr[] =
{
    {
        "DATA",
        "This is the field for data to be written to or read from the PHY regis"
        "ter.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TA",
        "This field must be programmed to 10 to generate a valid MII management"
        " frame.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RA",
        "Specifies one of up to 32 registers within the specified PHY device.",
        18, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PA",
        "Specifies one of up to 32 attached PHY devices.",
        23, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OP",
        "Determines the frame operation.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ST",
        "These fields must be programmed to 01 for a valid MII management frame"
        ".",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MSCR.
static const field_t hw_enet_mscr[] =
{
    {
        "MII_SPEED",
        "Controls the frequency of the MII management interface clock (MDC) rel"
        "ative to the internal module clock.",
        1, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIS_PRE",
        "Enables/disables prepending a preamble to the MII management frame.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLDTIME",
        "IEEE802.3 clause 22 defines a minimum of 10 ns for the holdtime on the"
        " MDIO output.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MIBC.
static const field_t hw_enet_mibc[] =
{
    {
        "MIB_CLEAR",
        "If set, all statistics counters are reset to 0.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MIB_IDLE",
        "If this status field is set, the MIB block is not currently updating a"
        "ny MIB counters.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MIB_DIS",
        "If this control field is set, the MIB logic halts and does not update "
        "any MIB counters.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RCR.
static const field_t hw_enet_rcr[] =
{
    {
        "LOOP",
        "This is an MII internal loopback, therefore MII_MODE must be written t"
        "o 1 and RMII_MODE must be written to 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRT",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII_MODE",
        "This field must always be set.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PROM",
        "All frames are accepted regardless of address matching.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BC_REJ",
        "If set, frames with destination address (DA) equal to 0xFFFF_FFFF_FFFF"
        " are rejected unless the PROM field is set.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCE",
        "If set, the receiver detects PAUSE frames.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RMII_MODE",
        "Specifies whether the MAC is configured for MII mode or RMII operation"
        " .",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RMII_10T",
        "Enables 10-Mbps mode of the RMII .",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PADEN",
        "Specifies whether the MAC removes padding from received frames.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAUFWD",
        "Specifies whether pause frames are terminated or forwarded.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRCFWD",
        "Specifies whether the CRC field of received frames is transmitted or s"
        "tripped.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CFEN",
        "Enables/disables the MAC control frame.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAX_FL",
        "Resets to decimal 1518.",
        16, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NLC",
        "Enables/disables a payload length check.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRS",
        "Read-only status indicating that the MAC receive datapath is stopped.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCR.
static const field_t hw_enet_tcr[] =
{
    {
        "GTS",
        "When this field is set, MAC stops transmission after any frame current"
        "ly transmitted is complete and EIR[GRA] is set.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FDEN",
        "If this field is set, frames transmit independent of carrier sense and"
        " collision inputs.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFC_PAUSE",
        "Pauses frame transmission.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFC_PAUSE",
        "This status field is set when a full-duplex flow control pause frame i"
        "s received and the transmitter pauses for the duration defined in this"
        " pause frame.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ADDSEL",
        "If ADDINS is set, indicates the MAC address that overwrites the source"
        " MAC address.",
        5, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDINS",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRCFWD",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_PALR.
static const field_t hw_enet_palr[] =
{
    {
        "PADDR1",
        "Bytes 0 (bits 31:24), 1 (bits 23:16), 2 (bits 15:8), and 3 (bits 7:0) "
        "of the 6-byte individual address are used for exact match and the sour"
        "ce address field in PAUSE frames.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_PAUR.
static const field_t hw_enet_paur[] =
{
    {
        "TYPE",
        "These fields have a constant value of 0x8808.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PADDR2",
        "Bytes 4 (bits 31:24) and 5 (bits 23:16) of the 6-byte individual addre"
        "ss used for exact match, and the source address field in PAUSE frames.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_OPD.
static const field_t hw_enet_opd[] =
{
    {
        "PAUSE_DUR",
        "Pause duration field used in PAUSE frames.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE",
        "These fields have a constant value of 0x0001.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IAUR.
static const field_t hw_enet_iaur[] =
{
    {
        "IADDR1",
        "Contains the upper 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a unicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IALR.
static const field_t hw_enet_ialr[] =
{
    {
        "IADDR2",
        "Contains the lower 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a unicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_GAUR.
static const field_t hw_enet_gaur[] =
{
    {
        "GADDR1",
        "Contains the upper 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a multicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_GALR.
static const field_t hw_enet_galr[] =
{
    {
        "GADDR2",
        "Contains the lower 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a multicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TFWR.
static const field_t hw_enet_tfwr[] =
{
    {
        "TFWR",
        "If STRFWD is cleared, indicates the number of bytes written to the tra"
        "nsmit FIFO before transmission of a frame begins.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STRFWD",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDSR.
static const field_t hw_enet_rdsr[] =
{
    {
        "R_DES_START",
        "Pointer to the beginning of the receive buffer descriptor queue.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDSR.
static const field_t hw_enet_tdsr[] =
{
    {
        "X_DES_START",
        "Pointer to the beginning of the transmit buffer descriptor queue.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MRBR.
static const field_t hw_enet_mrbr[] =
{
    {
        "R_BUF_SIZE",
        "Receive buffer size in bytes.",
        4, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RSFL.
static const field_t hw_enet_rsfl[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_RSEM.
static const field_t hw_enet_rsem[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_RAEM.
static const field_t hw_enet_raem[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_RAFL.
static const field_t hw_enet_rafl[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_TSEM.
static const field_t hw_enet_tsem[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_TAEM.
static const field_t hw_enet_taem[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_TAFL.
static const field_t hw_enet_tafl[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_TIPG.
static const field_t hw_enet_tipg[] =
{
    {
        "IPG",
        "Indicates the IPG, in bytes, between transmitted frames.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_FTRL.
static const field_t hw_enet_ftrl[] =
{
    {
        "TRUNC_FL",
        "Indicates the value a receive frame is truncated, if it is greater tha"
        "n this value.",
        0, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TACC.
static const field_t hw_enet_tacc[] =
{
    {
        "SHIFT16",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPCHK",
        "Enables insertion of IP header checksum.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PROCHK",
        "Enables insertion of protocol checksum.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RACC.
static const field_t hw_enet_racc[] =
{
    {
        "PADREM",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPDIS",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRODIS",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINEDIS",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SHIFT16",
        "When this field is set, the actual frame data starts at bit 16 of the "
        "first word read from the RX FIFO aligning the Ethernet payload on a 32"
        "-bit boundary.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATCR.
static const field_t hw_enet_atcr[] =
{
    {
        "EN",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFEN",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFRST",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PEREN",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPER",
        "Enables event signal output assertion on period event.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESTART",
        "Resets the timer to zero.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAPTURE",
        "",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLAVE",
        "",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATVR.
static const field_t hw_enet_atvr[] =
{
    {
        "ATIME",
        "A write sets the timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATOFF.
static const field_t hw_enet_atoff[] =
{
    {
        "OFFSET",
        "Offset value for one-shot event generation.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATPER.
static const field_t hw_enet_atper[] =
{
    {
        "PERIOD",
        "Value for generating periodic events.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATCOR.
static const field_t hw_enet_atcor[] =
{
    {
        "COR",
        "Defines after how many timer clock cycles (ts_clk) the correction coun"
        "ter should be reset and trigger a correction increment on the timer.",
        0, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATINC.
static const field_t hw_enet_atinc[] =
{
    {
        "INC",
        "The timer increments by this amount each clock cycle.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_CORR",
        "This value is added every time the correction timer expires (every clo"
        "ck cycle given in ATCOR).",
        8, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATSTMP.
static const field_t hw_enet_atstmp[] =
{
    {
        "TIMESTAMP",
        "Timestamp of the last frame transmitted by the core that had TxBD[TS] "
        "set .",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ENET module.
static const reg_t hw_enet[] =
{
    {
        "EIR",
        "When an event occurs that sets a bit in EIR, an interrupt occurs if th"
        "e corresponding bit in the interrupt mask register (EIMR) is also set.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_enet_eir
    },
    {
        "EIMR",
        "EIMR controls which interrupt events are allowed to generate actual in"
        "terrupts.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_enet_eimr
    },
    {
        "RDAR",
        "RDAR is a command register, written by the user, to indicate that the "
        "receive descriptor ring has been updated, that is, that the driver pro"
        "duced empty receive buffers with the empty bit set.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdar
    },
    {
        "TDAR",
        "The TDAR is a command register that the user writes to indicate that t"
        "he transmit descriptor ring has been updated, that is, that transmit b"
        "uffers have been produced by the driver with the ready bit set in the "
        "buffer descriptor.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdar
    },
    {
        "ECR",
        "ECR is a read/write user register, though hardware may also alter fiel"
        "ds in this register.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_enet_ecr
    },
    {
        "MMFR",
        "Writing to MMFR triggers a management frame transaction to the PHY dev"
        "ice unless MSCR is programmed to zero.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_enet_mmfr
    },
    {
        "MSCR",
        "MSCR provides control of the MII clock (MDC pin) frequency and allows "
        "a preamble drop on the MII management frame.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_mscr
    },
    {
        "MIBC",
        "MIBC is a read/write register controlling and observing the state of t"
        "he MIB block.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_mibc
    },
    {
        "RCR",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_enet_rcr
    },
    {
        "TCR",
        "TCR is read/write and configures the transmit block.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_enet_tcr
    },
    {
        "PALR",
        "PALR contains the lower 32 bits (bytes 0, 1, 2, 3) of the 48-bit addre"
        "ss used in the address recognition process to compare with the destina"
        "tion address (DA) field of receive frames with an individual DA.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_palr
    },
    {
        "PAUR",
        "PAUR contains the upper 16 bits (bytes 4 and 5) of the 48-bit address "
        "used in the address recognition process to compare with the destinatio"
        "n address (DA) field of receive frames with an individual DA.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_paur
    },
    {
        "OPD",
        "OPD is read/write accessible.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_opd
    },
    {
        "IAUR",
        "IAUR contains the upper 32 bits of the 64-bit individual address hash "
        "table.",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_iaur
    },
    {
        "IALR",
        "IALR contains the lower 32 bits of the 64-bit individual address hash "
        "table.",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_ialr
    },
    {
        "GAUR",
        "GAUR contains the upper 32 bits of the 64-bit hash table used in the a"
        "ddress recognition process for receive frames with a multicast address"
        ".",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_gaur
    },
    {
        "GALR",
        "GALR contains the lower 32 bits of the 64-bit hash table used in the a"
        "ddress recognition process for receive frames with a multicast address"
        ".",
        4, // Width in bytes
        0x00000124, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_galr
    },
    {
        "TFWR",
        "If TFR[STRFWD] is cleared, TFWR[TFWR] controls the amount of data requ"
        "ired in the transmit FIFO before transmission of a frame can begin.",
        4, // Width in bytes
        0x00000144, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_tfwr
    },
    {
        "RDSR",
        "RDSR points to the beginning of the circular receive buffer descriptor"
        " queue in external memory.",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdsr
    },
    {
        "TDSR",
        "TDSR provides a pointer to the beginning of the circular transmit buff"
        "er descriptor queue in external memory.",
        4, // Width in bytes
        0x00000184, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdsr
    },
    {
        "MRBR",
        "The MRBR is a user-programmable register that dictates the maximum siz"
        "e of all receive buffers.",
        4, // Width in bytes
        0x00000188, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_mrbr
    },
    {
        "RSFL",
        "",
        4, // Width in bytes
        0x00000190, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_enet_rsfl
    },
    {
        "RSEM",
        "",
        4, // Width in bytes
        0x00000194, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_enet_rsem
    },
    {
        "RAEM",
        "",
        4, // Width in bytes
        0x00000198, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_enet_raem
    },
    {
        "RAFL",
        "",
        4, // Width in bytes
        0x0000019c, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_enet_rafl
    },
    {
        "TSEM",
        "",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_enet_tsem
    },
    {
        "TAEM",
        "",
        4, // Width in bytes
        0x000001a4, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_enet_taem
    },
    {
        "TAFL",
        "",
        4, // Width in bytes
        0x000001a8, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_enet_tafl
    },
    {
        "TIPG",
        "",
        4, // Width in bytes
        0x000001ac, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tipg
    },
    {
        "FTRL",
        "",
        4, // Width in bytes
        0x000001b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_ftrl
    },
    {
        "TACC",
        "TACC controls accelerator actions when sending frames.",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_tacc
    },
    {
        "RACC",
        "",
        4, // Width in bytes
        0x000001c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_racc
    },
    {
        "ATCR",
        "ATCR command fields can trigger the corresponding events directly.",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_enet_atcr
    },
    {
        "ATVR",
        "",
        4, // Width in bytes
        0x00000404, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atvr
    },
    {
        "ATOFF",
        "",
        4, // Width in bytes
        0x00000408, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atoff
    },
    {
        "ATPER",
        "",
        4, // Width in bytes
        0x0000040c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atper
    },
    {
        "ATCOR",
        "",
        4, // Width in bytes
        0x00000410, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atcor
    },
    {
        "ATINC",
        "",
        4, // Width in bytes
        0x00000414, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_atinc
    },
    {
        "ATSTMP",
        "",
        4, // Width in bytes
        0x00000418, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_atstmp
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EPIT
#endif

// Bitfields in register EPIT_CR.
static const field_t hw_epit_cr[] =
{
    {
        "EN",
        "This bit enables the EPIT.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENMOD",
        "EPIT enable mode.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCIEN",
        "Output compare interrupt enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RLD",
        "Counter reload control.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESCALAR",
        "Counter clock prescaler value.",
        4, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Software reset.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IOVW",
        "EPIT counter overwrite enable.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGEN",
        "This bit is used to keep the EPIT functional in debug mode.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAITEN",
        "This read/write control bit enables the operation of the EPIT during w"
        "ait mode.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPEN",
        "EPIT stop mode enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM",
        "EPIT output mode.This bit field determines the mode of EPIT output on "
        "the output pin.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKSRC",
        "Select clock source  These bits determine which clock input is to be s"
        "elected for running the counter.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_SR.
static const field_t hw_epit_sr[] =
{
    {
        "OCIF",
        "Output compare interrupt flag.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_LR.
static const field_t hw_epit_lr[] =
{
    {
        "LOAD",
        "Load value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_CMPR.
static const field_t hw_epit_cmpr[] =
{
    {
        "COMPARE",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_CNR.
static const field_t hw_epit_cnr[] =
{
    {
        "COUNT",
        "Counter value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a EPIT module.
static const reg_t hw_epit[] =
{
    {
        "CR",
        "The EPIT control register (EPIT_CR) is used to configure the operating"
        " settings of the EPIT.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_epit_cr
    },
    {
        "SR",
        "The EPIT status register (EPIT_SR) has a single status bit for the out"
        "put compare event.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_sr
    },
    {
        "LR",
        "The EPIT load register (EPIT_LR) contains the value that is to be load"
        "ed into the counter when EPIT counter reaches zero if the RLD bit in E"
        "PIT_CR is set.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_lr
    },
    {
        "CMPR",
        "The EPIT compare register (EPIT_CMPR) holds the value that determines "
        "when a compare event is generated.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_cmpr
    },
    {
        "CNR",
        "The EPIT counter register (EPIT_CNR) contains the current count value "
        "and can be read at any time without disturbing the counter.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_epit_cnr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ESAI
#endif

// Bitfields in register ESAI_ETDR.
static const field_t hw_esai_etdr[] =
{
    {
        "ETDR",
        "ESAI Transmit Data Register.",
        0, // LSB
        31, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_ERDR.
static const field_t hw_esai_erdr[] =
{
    {
        "ERDR",
        "ESAI Receive Data Register.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_ECR.
static const field_t hw_esai_ecr[] =
{
    {
        "ESAIEN",
        "ESAI Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERST",
        "ESAI Reset.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERO",
        "EXTAL Receiver Out.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERI",
        "EXTAL Receiver In.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ETO",
        "EXTAL Transmitter Out.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ETI",
        "EXTAL Transmitter In.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_ESR.
static const field_t hw_esai_esr[] =
{
    {
        "RD",
        "Receive Data.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RED",
        "Receive Even Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RDE",
        "Receive Data Exception.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RLS",
        "Receive Last Slot.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TD",
        "Transmit Data.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TED",
        "Transmit Even Data.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TDE",
        "Transmit Data Exception.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TLS",
        "Transmit Last Slot.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TFE",
        "Transmit FIFO Empty.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RFF",
        "Receive FIFO Full.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TINIT",
        "Transmit Initialization.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TFCR.
static const field_t hw_esai_tfcr[] =
{
    {
        "TFE",
        "Transmit FIFO Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFR",
        "Transmit FIFO Reset.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE0",
        "Transmitter #0 FIFO Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE1",
        "Transmitter #1 FIFO Enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE2",
        "Transmitter #2 FIFO Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE3",
        "Transmitter #3 FIFO Enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE4",
        "Transmitter #4 FIFO Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE5",
        "Transmitter #5 FIFO Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFWM",
        "Transmit FIFO Watermark.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWA",
        "Transmit Word Alignment.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIEN",
        "Transmitter Initialization Enable.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TFSR.
static const field_t hw_esai_tfsr[] =
{
    {
        "TFCNT",
        "Transmit FIFO Counter.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NTFI",
        "Next Transmitter FIFO In.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NTFO",
        "Next Transmitter FIFO Out.",
        12, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RFCR.
static const field_t hw_esai_rfcr[] =
{
    {
        "RFE",
        "Receive FIFO Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFR",
        "Receive FIFO Reset.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE0",
        "Receiver #0 FIFO Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE1",
        "Receiver #1 FIFO Enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE2",
        "Receiver #2 FIFO Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE3",
        "Receiver #3 FIFO Enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFWM",
        "Receive FIFO Watermark.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWA",
        "Receive Word Alignment.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REXT",
        "Receive Extension.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RFSR.
static const field_t hw_esai_rfsr[] =
{
    {
        "RFCNT",
        "Receive FIFO Counter.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NRFO",
        "Next Receiver FIFO Out.",
        8, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NRFI",
        "Next Receiver FIFO In.",
        12, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX0.
static const field_t hw_esai_tx0[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX1.
static const field_t hw_esai_tx1[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX2.
static const field_t hw_esai_tx2[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX3.
static const field_t hw_esai_tx3[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX4.
static const field_t hw_esai_tx4[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX5.
static const field_t hw_esai_tx5[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TX.
static const field_t hw_esai_tx[] =
{
    {
        "TXN",
        "Stores the data to be transmitted and is automatically transferred to "
        "the transmit shift registers.",
        0, // LSB
        23, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RX0.
static const field_t hw_esai_rx0[] =
{
    {
        "RXN",
        "Accept data from the receive shift registers when they become full  Se"
        "e",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RX1.
static const field_t hw_esai_rx1[] =
{
    {
        "RXN",
        "Accept data from the receive shift registers when they become full  Se"
        "e",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RX2.
static const field_t hw_esai_rx2[] =
{
    {
        "RXN",
        "Accept data from the receive shift registers when they become full  Se"
        "e",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RX3.
static const field_t hw_esai_rx3[] =
{
    {
        "RXN",
        "Accept data from the receive shift registers when they become full  Se"
        "e",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_SAISR.
static const field_t hw_esai_saisr[] =
{
    {
        "IF0",
        "ESAI_SAISR Serial Input Flag 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IF1",
        "ESAI_SAISR Serial Inout Flag 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IF2",
        "ESAI_SAISR Serial Input Flag 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RFS",
        "ESAI_SAISR Receive Frame Sync Flag.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ROE",
        "ESAI_SAISR Receive Overrun Error Flag.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RDF",
        "ESAI_SAISR Receive Data Register Full.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REDF",
        "ESAI_SAISR Receive Even-Data Register Full.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RODF",
        "ESAI_SAISR Receive Odd-Data Register Full.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TFS",
        "ESAI_SAISR Transmit Frame Sync Flar.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TUE",
        "ESAI_SAISR Transmit Underrun Error Flag.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TDE",
        "ESAI_SAISR Transmit Data Register Empty.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TEDE",
        "ESAI_SAISR Transmit Even-DataRegister Empty.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TODFE",
        "ESAI_SAISR Transmit Odd-Data Register Empty.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_SAICR.
static const field_t hw_esai_saicr[] =
{
    {
        "OF0",
        "ESAI_SAICR Serial Output Flag 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF1",
        "ESAI_SAICR Serial Output Flag 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF2",
        "ESAI_SAICR Serial Output Flag 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYN",
        "ESAI_SAICR Synchronous Mode Selection.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEBE",
        "ESAI_SAICR Transmit External Buffer Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ALC",
        "ESAI_SAICR Alignment Control.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TCR.
static const field_t hw_esai_tcr[] =
{
    {
        "TE0",
        "ESAI_TCR ESAI Transmit 0 Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE1",
        "ESAI_TCR ESAI Transmit 1 Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE2",
        "ESAI_TCR ESAI Transmit 2 Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE3",
        "ESAI_TCR ESAI Transmit 3 Enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE4",
        "ESAI_TCR ESAI Transmit 4 Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE5",
        "ESAI_TCR ESAI Transmit 5 Enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSHFD",
        "ESAI_TCR Transmit Shift Direction.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWA",
        "ESAI_TCR Transmit Word Alignment Control.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMOD",
        "ESAI_TCR Transmit Network Mode Control (TMOD1-TMOD0).",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSWS",
        "ESAI_TCR Tx Slot and Word Length Select (TSWS4-TSWS0).",
        10, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSL",
        "ESAI_TCR Transmit Frame Sync Length.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSR",
        "ESAI_TCR Transmit Frame Sync Relative Timing.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PADC",
        "ESAI_TCR Transmit Zero Padding Control.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPR",
        "ESAI_TCR Transmit Section Personal Reset.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEIE",
        "ESAI_TCR Transmit Exception Interrupt Enable.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEDIE",
        "ESAI_TCR Transmit Even Slot Data Interrupt Enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "ESAI_TCR Transmit Interrupt Enable.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TLIE",
        "ESAI_TCR Transmit Last Slot Interrupt Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TCCR.
static const field_t hw_esai_tccr[] =
{
    {
        "TPM",
        "ESAI_TCCR Transmit Prescale Modulus Select.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPSR",
        "ESAI_TCCR Transmit Prescaler Range.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDC",
        "ESAI_TCCR Tx Frame Rate Divider Control.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFP",
        "ESAI_TCCR Tx High Frequency Clock Divider.",
        14, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCKP",
        "ESAI_TCCR Transmit Clock Polarity.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSP",
        "ESAI_TCCR Transmit Frame Sync Polarity.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "THCKP",
        "ESAI_TCCR Transmit High Frequency Clock Polarity.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCKD",
        "ESAI_TCCR Transmit Clock Source Direction.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFSD",
        "ESAI_TCCR Transmit Frame Sync Signal Direction.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "THCKD",
        "ESAI_TCCR Transmit High Frequency Clock Direction.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RCR.
static const field_t hw_esai_rcr[] =
{
    {
        "RE0",
        "ESAI_RCR ESAI Receiver 0 Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE1",
        "ESAI_RCR ESAI Receiver 1 Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE2",
        "ESAI_RCR ESAI Receiver 2 Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE3",
        "ESAI_RCR ESAI Receiver 3 Enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSHFD",
        "ESAI_RCR Receiver Shift Direction.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWA",
        "ESAI_RCR Receiver Word Alignment Control.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RMOD",
        "ESAI_RCR Receiver Network Mode Control.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSWS",
        "ESAI_RCR Receiver Slot and Word Select.",
        10, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSL",
        "ESAI_RCR Receiver Frame Sync Length.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSR",
        "ESAI_RCR Receiver Frame Sync Relative Timing.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RPR",
        "ESAI_RCR Receiver Section Personal Reset.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REIE",
        "ESAI_RCR Receive Exception Interrupt Enable.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REDIE",
        "ESAI_RCR Receive Even Slot Data Interrupt Enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RIE",
        "ESAI_RCR Receive Interrupt Enable.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RLIE",
        "ESAI_RCR Receive Last Slot Interrupt Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RCCR.
static const field_t hw_esai_rccr[] =
{
    {
        "RPM",
        "ESAI_RCCR Receiver Prescale Modulus Select.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RPSP",
        "ESAI_RCCR Receiver Prescaler Range.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDC",
        "ESAI_RCCR Rx Frame Rate Divider Control.",
        9, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFP",
        "ESAI_RCCR Rx High Frequency Clock Divider.",
        14, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCKP",
        "The Receiver Clock Polarity (RCKP) bit controls on which bit clock edg"
        "e data and frame sync are clocked out and latched in.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSP",
        "ESAI_RCCR Receiver Frame Sync Polarity.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RHCKP",
        "ESAI_RCCR Receiver High Frequency Clock Polarity.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCKD",
        "ESAI_RCCR Receiver Clock Source Direction.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFSD",
        "ESAI_RCCR Receiver Frame Sync Signal Direction.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RHCKD",
        "ESAI_RCCR Receiver High Frequency Clock Direction.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TSMA.
static const field_t hw_esai_tsma[] =
{
    {
        "TS",
        "When bit number N in ESAI_TSMA is cleared, all the transmit data pins "
        "of the enabled transmitters are tri-stated during transmit time slot n"
        "umber N.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_TSMB.
static const field_t hw_esai_tsmb[] =
{
    {
        "TS",
        "When bit number N in ESAI_TSMB is cleared, all the transmit data pins "
        "of the enabled transmitters are tri-stated during transmit time slot n"
        "umber N.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RSMA.
static const field_t hw_esai_rsma[] =
{
    {
        "RS",
        "When bit number N in the ESAI_RSMA register is cleared, the data from "
        "the enabled receivers input pins are shifted into their receive shift "
        "registers during slot number N.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_RSMB.
static const field_t hw_esai_rsmb[] =
{
    {
        "RS",
        "When bit number N in the ESAI_RSMB register is cleared, the data from "
        "the enabled receivers input pins are shifted into their receive shift "
        "registers during slot number N.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_PRRC.
static const field_t hw_esai_prrc[] =
{
    {
        "PDC",
        "See .",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ESAI_PCRC.
static const field_t hw_esai_pcrc[] =
{
    {
        "PC",
        "See .",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ESAI module.
static const reg_t hw_esai[] =
{
    {
        "ETDR",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_etdr
    },
    {
        "ERDR",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_esai_erdr
    },
    {
        "ECR",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_esai_ecr
    },
    {
        "ESR",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        false, // Writable
        11, // Number of bitfields
        hw_esai_esr
    },
    {
        "TFCR",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_esai_tfcr
    },
    {
        "TFSR",
        "",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_esai_tfsr
    },
    {
        "RFCR",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_esai_rfcr
    },
    {
        "RFSR",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_esai_rfsr
    },
    {
        "TX0",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x00000080, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx0
    },
    {
        "TX1",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x00000088, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx1
    },
    {
        "TX2",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx2
    },
    {
        "TX3",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x00000090, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx3
    },
    {
        "TX4",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x00000094, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx4
    },
    {
        "TX5",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x00000098, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx5
    },
    {
        "TX",
        "ESAI_TX5, ESAI_TX4, ESAI_TX3, ESAI_TX2, ESAI_TX1 and ESAI_TX0 are 32-b"
        "it write-only registers.",
        4, // Width in bytes
        0x0000009c, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tx
    },
    {
        "RX0",
        "ESAI_RX3, ESAI_RX2, ESAI_RX1, and ESAI_RX0 are 32-bit read-only regist"
        "ers that accept data from the receive shift registers when they become"
        " full ( and ).",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_esai_rx0
    },
    {
        "RX1",
        "ESAI_RX3, ESAI_RX2, ESAI_RX1, and ESAI_RX0 are 32-bit read-only regist"
        "ers that accept data from the receive shift registers when they become"
        " full ( and ).",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_esai_rx1
    },
    {
        "RX2",
        "ESAI_RX3, ESAI_RX2, ESAI_RX1, and ESAI_RX0 are 32-bit read-only regist"
        "ers that accept data from the receive shift registers when they become"
        " full ( and ).",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_esai_rx2
    },
    {
        "RX3",
        "ESAI_RX3, ESAI_RX2, ESAI_RX1, and ESAI_RX0 are 32-bit read-only regist"
        "ers that accept data from the receive shift registers when they become"
        " full ( and ).",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_esai_rx3
    },
    {
        "SAISR",
        "The Status Register (ESAI_SAISR) is a read-only status register used b"
        "y the ARM Core to read the status and serial input flags of the ESAI.",
        4, // Width in bytes
        0x000000cc, // Base address offset
        true, // Readable
        false, // Writable
        13, // Number of bitfields
        hw_esai_saisr
    },
    {
        "SAICR",
        "The read/write Common Control Register (ESAI_SAICR) contains control b"
        "its for functions that affect both the receive and transmit sections o"
        "f the ESAI.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_esai_saicr
    },
    {
        "TCR",
        "The read/write Transmit Control Register (ESAI_TCR) controls the ESAI "
        "transmitter section.",
        4, // Width in bytes
        0x000000d4, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_esai_tcr
    },
    {
        "TCCR",
        "The read/write Transmitter Clock Control Register (ESAI_TCCR) controls"
        " the ESAI transmitter clock generator bit and frame sync rates, the bi"
        "t clock and high frequency clock sources and the directions of the HCK"
        "T, FST and SCKT signals.",
        4, // Width in bytes
        0x000000d8, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_esai_tccr
    },
    {
        "RCR",
        "The read/write Receive Control Register (ESAI_RCR) controls the ESAI r"
        "eceiver section.",
        4, // Width in bytes
        0x000000dc, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_esai_rcr
    },
    {
        "RCCR",
        "The read/write Receiver Clock Control Register (ESAI_RCCR) controls th"
        "e ESAI receiver clock generator bit and frame sync rates, word length,"
        " and number of words per frame for the serial data.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_esai_rccr
    },
    {
        "TSMA",
        "The Transmit Slot Mask Register A together with Transmit Slot Mask Reg"
        "ister B (ESAI_TSMA and ESAI_TSMB) are two read/write registers used by"
        " the transmitters in network mode to determine for each slot whether t"
        "o transmit a data word and generate a transmitter empty condition (TDE"
        "=1), or to tri-state the transmitter data pins.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tsma
    },
    {
        "TSMB",
        "The Transmit Slot Mask Register B together with Transmit Slot Mask Reg"
        "ister A (ESAI_TSMA and ESAI_TSMB) are two read/write registers used by"
        " the transmitters in network mode to determine for each slot whether t"
        "o transmit a data word and generate a transmitter empty condition (TDE"
        "=1), or to tri-state the transmitter data pins.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_tsmb
    },
    {
        "RSMA",
        "The Receive Slot Mask Register A together with Receive Slot Mask Regis"
        "ter B (ESAI_RSMA and ESAI_RSMB) are two read/write registers used by t"
        "he receiver in network mode to determine for each slot whether to rece"
        "ive a data word and generate a receiver full condition (RDF=1), or to "
        "ignore the received data.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_rsma
    },
    {
        "RSMB",
        "The Receive Slot Mask Register B together with Receive Slot Mask Regis"
        "ter A (ESAI_RSMA and ESAI_RSMB) are two read/write registers used by t"
        "he receiver in network mode to determine for each slot whether to rece"
        "ive a data word and generate a receiver full condition (RDF=1), or to "
        "ignore the received data.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_rsmb
    },
    {
        "PRRC",
        "There are two registers to control the ESAI personal reset status: Por"
        "t C Direction Register (ESAI_PRRC) and Port C Control Register (ESAI_P"
        "CRC).",
        4, // Width in bytes
        0x000000f8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_prrc
    },
    {
        "PCRC",
        "The read/write 32-bit Port C Control Register (ESAI_PCRC) in conjuncti"
        "on with the Port C Direction Register (ESAI_PRRC) controls the functio"
        "nality of the ESAI personal reset state.",
        4, // Width in bytes
        0x000000fc, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_esai_pcrc
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark FLEXCAN
#endif

// Bitfields in register FLEXCAN_MCR.
static const field_t hw_flexcan_mcr[] =
{
    {
        "MAXMB",
        "This 6-bit field defines the maximum number of message buffers that wi"
        "ll take part in the matching and arbitration processes.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDAM",
        "This 2-bit field identifies the format of the elements of the Rx FIFO "
        "filter table, as shown below.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AEN",
        "This bit is supplied for backwards compatibility reasons.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LPRIO_EN",
        "This bit is provided for backwards compatibility reasons.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCC",
        "This bit is provided to support Backwards Compatibility with previous "
        "FLEXCAN versions.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRX_DIS",
        "This bit defines whether FLEXCAN is allowed to receive frames transmit"
        "ted by itself.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOZE",
        "This bit defines whether FLEXCAN is allowed to enter low power mode wh"
        "en Doze Mode is requested at ARM platform level.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAK_SRC",
        "This bit defines whether the integrated low-pass filter is applied to "
        "protect the Rx CAN input.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LPM_ACK",
        "This read-only bit indicates that FLEXCAN is either in Disable Mode an"
        "d Stop Mode.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WRN_EN",
        "When asserted, this bit enables the generation of the TWRN_INT and RWR"
        "N_INT flags in the Error and Status Register.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLF_WAK",
        "This bit enables the Self Wake Up feature when FLEXCAN is in Stop Mode"
        ".",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUPV",
        "This bit configures some of the FLEXCAN registers to be either in Supe"
        "rvisor or Unrestricted memory space.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRZ_ACK",
        "This read-only bit indicates that FLEXCAN is in Freeze Mode and its pr"
        "escaler is stopped.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SOFT_RST",
        "When this bit is asserted, FLEXCAN resets its internal state machines "
        "and some of the memory mapped registers.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAK_MSK",
        "This bit enables the Wake Up Interrupt generation.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NOT_RDY",
        "This read-only bit indicates that FLEXCAN is either in Disable Mode, S"
        "top Mode or Freeze Mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALT",
        "Assertion of this bit puts the FLEXCAN block into Freeze Mode.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FEN",
        "This bit controls whether the FIFO feature is enabled or not.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRZ",
        "The FRZ bit specifies the FLEXCAN behavior when the HALT bit in the MC"
        "R Register is set or when Debug Mode is requested at ARM platform leve"
        "l.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MDIS",
        "This bit controls whether FLEXCAN is enabled or not.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_CTRL.
static const field_t hw_flexcan_ctrl[] =
{
    {
        "PROP_SEG",
        "This 3-bit field defines the length of the Propagation Segment in the "
        "bit time.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOM",
        "This bit configures FLEXCAN to operate in Listen Only Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBUF",
        "This bit defines the ordering mechanism for Message Buffer transmissio"
        "n.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSYN",
        "This bit enables a mechanism that resets the free-running timer each t"
        "ime a message is received in Message Buffer 0.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BOFF_REC",
        "This bit defines how FLEXCAN recovers from Bus Off state.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMP",
        "This bit defines the sampling mode of CAN bits at the Rx input.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWRN_MSK",
        "This bit provides a mask for the Rx Warning Interrupt associated with "
        "the RWRN_INT flag in the Error and Status Register.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWRN_MSK",
        "This bit provides a mask for the Tx Warning Interrupt associated with "
        "the TWRN_INT flag in the Error and Status Register.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LPB",
        "This bit configures FLEXCAN to operate in Loop-Back Mode.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR_MSK",
        "This bit provides a mask for the Error Interrupt.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BOFF_MSK",
        "This bit provides a mask for the Bus Off Interrupt.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSEG2",
        "This 3-bit field defines the length of Phase Buffer Segment 2 in the b"
        "it time.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSEG1",
        "This 3-bit field defines the length of Phase Buffer Segment 1 in the b"
        "it time.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RJW",
        "This 2-bit field defines the maximum number of time quanta One time qu"
        "antum is equal to the Sclock period.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESDIV",
        "This 8-bit field defines the ratio between the CPI clock frequency and"
        " the Serial Clock (Sclock) frequency.",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_TIMER.
static const field_t hw_flexcan_timer[] =
{
    {
        "TIMER",
        "Timer value  Contains the free-running counter value.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RXGMASK.
static const field_t hw_flexcan_rxgmask[] =
{
    {
        "MI31_MI0",
        "For normal Rx message buffers, the mask bits affect the ID filter prog"
        "rammed on the message buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RX14MASK.
static const field_t hw_flexcan_rx14mask[] =
{
    {
        "MI31_MI0",
        "Acceptance mask for the Identifier in Message Buffer 14",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RX15MASK.
static const field_t hw_flexcan_rx15mask[] =
{
    {
        "MI31_MI0",
        "Acceptance mask for the Identifier in Message Buffer 15",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_ECR.
static const field_t hw_flexcan_ecr[] =
{
    {
        "TX_ERR_COUNTER",
        "Transmit Error Counter",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_ERR_COUNTER",
        "Receive Error Counter",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_ESR.
static const field_t hw_flexcan_esr[] =
{
    {
        "WAK_INT",
        "When FLEXCAN is Stop Mode and a recessive to dominant transition is de"
        "tected on the CAN bus and if the WAK_MSK bit in the MCR Register is se"
        "t, an interrupt is generated to the ARM.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR_INT",
        "This bit indicates that at least one of the Error Bits (bits 15-10) is"
        " set.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BOFF_INT",
        "This bit is set when FLEXCAN enters Bus Off state.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FLT_CONF",
        "This 2-bit field indicates the Confinement State of the FLEXCAN block,"
        " as shown in below:  If the LOM bit in the Control Register is asserte"
        "d, the FLT_CONF field will indicate Error Passive.",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TXRX",
        "This bit indicates if FLEXCAN is transmitting or receiving a message w"
        "hen the CAN bus is not in IDLE state.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE",
        "This bit indicates when CAN bus is in IDLE state.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_WRN",
        "This bit indicates when repetitive errors are occurring during message"
        " reception.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TX_WRN",
        "This bit indicates when repetitive errors are occurring during message"
        " transmission.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STF_ERR",
        "This bit indicates that a Stuffing Error has been detected.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FRM_ERR",
        "This bit indicates that a Form Error has been detected by the receiver"
        " node, that is, a fixed-form bit field contains at least one illegal b"
        "it.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CRC_ERR",
        "This bit indicates that a CRC Error has been detected by the receiver "
        "node, that is, the calculated CRC is different from the received.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ACK_ERR",
        "This bit indicates that an Acknowledge Error has been detected by the "
        "transmitter node, that is, a dominant bit has not been detected during"
        " the ACK SLOT.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BIT0_ERR",
        "This bit indicates when an inconsistency occurs between the transmitte"
        "d and the received bit in a message.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BIT1_ERR",
        "This bit indicates when an inconsistency occurs between the transmitte"
        "d and the received bit in a message.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RWRN_INT",
        "If the WRN_EN bit in MCR is asserted, the RWRN_INT bit is set when the"
        " RX_WRN flag transitions from 0 to 1, meaning that the Rx error counte"
        "rs reached 96.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWRN_INT",
        "If the WRN_EN bit in MCR is asserted, the TWRN_INT bit is set when the"
        " TX_WRN flag transitions from 0 to 1, meaning that the Tx error counte"
        "r reached 96.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IMASK2.
static const field_t hw_flexcan_imask2[] =
{
    {
        "BUF63M",
        "Each bit enables or disables the respective FLEXCAN Message Buffer (MB"
        "32 to MB63) Interrupt.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IMASK1.
static const field_t hw_flexcan_imask1[] =
{
    {
        "BUF31M_BUF0M",
        "Each bit enables or disables the respective FLEXCAN Message Buffer (MB"
        "0 to MB31) Interrupt.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IFLAG2.
static const field_t hw_flexcan_iflag2[] =
{
    {
        "BUF63I_BUF32I",
        "Each bit flags the respective FLEXCAN Message Buffer (MB32 to MB63) in"
        "terrupt.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IFLAG1.
static const field_t hw_flexcan_iflag1[] =
{
    {
        "BUF4I_BUF0I",
        "If the FIFO is not enabled, these bits flag the interrupts for MB0 to "
        "MB4.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF5I",
        "If the FIFO is not enabled, this bit flags the interrupt for MB5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF6I",
        "If the FIFO is not enabled, this bit flags the interrupt for MB6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF7I",
        "If the FIFO is not enabled, this bit flags the interrupt for MB7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF31I_BUF8I",
        "Each bit flags the respective FLEXCAN Message Buffer (MB8 to MB31) int"
        "errupt.",
        8, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_GFWR.
static const field_t hw_flexcan_gfwr[] =
{
    {
        "GFWR",
        "It determines the Glitch Filter Width.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RX0IMR.
static const field_t hw_flexcan_rx0imr[] =
{
    {
        "MI31_MI0",
        "For normal Rx message buffers, the mask bits affect the ID filter prog"
        "rammed on the message buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RX63IMR.
static const field_t hw_flexcan_rx63imr[] =
{
    {
        "MI31_MI0",
        "For normal Rx message buffers, the mask bits affect the ID filter prog"
        "rammed on the message buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a FLEXCAN module.
static const reg_t hw_flexcan[] =
{
    {
        "MCR",
        "This register defines global system configurations, such as the block "
        "operation mode (low power, for example) and maximum message buffer con"
        "figuration.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        20, // Number of bitfields
        hw_flexcan_mcr
    },
    {
        "CTRL",
        "This register is defined for specific FLEXCAN control features related"
        " to the CAN bus, such as bit-rate, programmable sampling point within "
        "an Rx bit, Loop Back Mode, Listen Only Mode, Bus Off recovery behavior"
        " and interrupt enabling (Bus-Off, Error, Warning).",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_flexcan_ctrl
    },
    {
        "TIMER",
        "This register represents a 16-bit free running counter that can be rea"
        "d and written by the ARM.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_timer
    },
    {
        "RXGMASK",
        "Supports individual masks per message buffer, setting the BCC bit in M"
        "CR causes the RXGMASK Register to have no effect on the block operatio"
        "n.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rxgmask
    },
    {
        "RX14MASK",
        "Setting the BCC bit in MCR causes the RX14MASK Register to have no eff"
        "ect on the block operation.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rx14mask
    },
    {
        "RX15MASK",
        "Setting the BCC bit in MCR causes the RX15MASK Register to have no eff"
        "ect on the block operation.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rx15mask
    },
    {
        "ECR",
        "This register has 2 8-bit fields reflecting the value of two FLEXCAN e"
        "rror counters: Transmit Error Counter (Tx_Err_Counter field) and Recei"
        "ve Error Counter (Rx_Err_Counter field).",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_flexcan_ecr
    },
    {
        "ESR",
        "This register reflects various error conditions.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_flexcan_esr
    },
    {
        "IMASK2",
        "This register allows any number of a range of 32 Message Buffer Interr"
        "upts to be enabled or disabled.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_imask2
    },
    {
        "IMASK1",
        "This register allows the enabling or disabling of any number of a rang"
        "e of 32 Message Buffer Interrupts.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_imask1
    },
    {
        "IFLAG2",
        "This register defines the flags for 32 Message Buffer interrupts.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_iflag2
    },
    {
        "IFLAG1",
        "This register defines the flags for 32 Message Buffer interrupts and F"
        "IFO interrupts.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_flexcan_iflag1
    },
    {
        "GFWR",
        "The Glitch Filter just takes effects when FLEXCAN enters the STOP mode"
        ".",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_gfwr
    },
    {
        "RX0IMR",
        "These registers are used as acceptance masks for ID filtering in Rx me"
        "ssage buffers and the FIFO.",
        4, // Width in bytes
        0x00000880, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rx0imr
    },
    {
        "RX63IMR",
        "These registers are used as acceptance masks for ID filtering in Rx me"
        "ssage buffers and the FIFO.",
        4, // Width in bytes
        0x0000097c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rx63imr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPC
#endif

// Bitfields in register GPC_CNTR.
static const field_t hw_gpc_cntr[] =
{
    {
        "GPU_VPU_PDN_REQ",
        "GPU /VPU Power Down request.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_VPU_PUP_REQ",
        "GPU /VPU Power Up request.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFS0CR",
        "DVFS0 (ARM) Change request (bit is read-only)",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "GPCIRQM",
        "GPC interrupt/event masking",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_PGR.
static const field_t hw_gpc_pgr[] =
{
    {
        "DRCIC",
        "Debug ref cir in mux control",
        29, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR1.
static const field_t hw_gpc_imr1[] =
{
    {
        "IMR1",
        "IRQ[63:32] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR2.
static const field_t hw_gpc_imr2[] =
{
    {
        "IMR2",
        "IRQ[95:64] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR3.
static const field_t hw_gpc_imr3[] =
{
    {
        "IMR3",
        "IRQ[127:96] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR4.
static const field_t hw_gpc_imr4[] =
{
    {
        "IMR4",
        "IRQ[159:128] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR1.
static const field_t hw_gpc_isr1[] =
{
    {
        "ISR1",
        "IRQ[63:32] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR2.
static const field_t hw_gpc_isr2[] =
{
    {
        "ISR2",
        "IRQ[95:64] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR3.
static const field_t hw_gpc_isr3[] =
{
    {
        "ISR3",
        "IRQ[127:96] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR4.
static const field_t hw_gpc_isr4[] =
{
    {
        "ISR4",
        "IRQ[159:128] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPC module.
static const reg_t hw_gpc[] =
{
    {
        "CNTR",
        "CNTR - Interface control register",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gpc_cntr
    },
    {
        "PGR",
        "PGR - Power Gating Register",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_pgr
    },
    {
        "IMR1",
        "IMR1 Register - masking of irq[63:32].",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr1
    },
    {
        "IMR2",
        "IMR2 Register - masking of irq[95:64].",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr2
    },
    {
        "IMR3",
        "IMR3 Register - masking of irq[127:96].",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr3
    },
    {
        "IMR4",
        "IMR4 Register - masking of irq[159:128].",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr4
    },
    {
        "ISR1",
        "ISR1 Register - status of irq [63:32].",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr1
    },
    {
        "ISR2",
        "ISR2 Register - status of irq [95:64].",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr2
    },
    {
        "ISR3",
        "ISR3 Register - status of irq [127:96].",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr3
    },
    {
        "ISR4",
        "ISR4 Register - status of irq [159:128].",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr4
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPIO
#endif

// Bitfields in register GPIO_DR.
static const field_t hw_gpio_dr[] =
{
    {
        "DR",
        "Data bits.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_GDIR.
static const field_t hw_gpio_gdir[] =
{
    {
        "GDIR",
        "GPIO direction bits.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_PSR.
static const field_t hw_gpio_psr[] =
{
    {
        "PSR",
        "GPIO pad status bits (status bits).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_ICR1.
static const field_t hw_gpio_icr1[] =
{
    {
        "ICR0",
        "Interrupt configuration 1 fields.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR1",
        "Interrupt configuration 1 fields.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR2",
        "Interrupt configuration 1 fields.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR3",
        "Interrupt configuration 1 fields.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR4",
        "Interrupt configuration 1 fields.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR5",
        "Interrupt configuration 1 fields.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR6",
        "Interrupt configuration 1 fields.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR7",
        "Interrupt configuration 1 fields.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR8",
        "Interrupt configuration 1 fields.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR9",
        "Interrupt configuration 1 fields.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR10",
        "Interrupt configuration 1 fields.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR11",
        "Interrupt configuration 1 fields.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR12",
        "Interrupt configuration 1 fields.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR13",
        "Interrupt configuration 1 fields.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR14",
        "Interrupt configuration 1 fields.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR15",
        "Interrupt configuration 1 fields.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_ICR2.
static const field_t hw_gpio_icr2[] =
{
    {
        "ICR16",
        "Interrupt configuration 2 fields.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR17",
        "Interrupt configuration 2 fields.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR18",
        "Interrupt configuration 2 fields.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR19",
        "Interrupt configuration 2 fields.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR20",
        "Interrupt configuration 2 fields.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR21",
        "Interrupt configuration 2 fields.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR22",
        "Interrupt configuration 2 fields.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR23",
        "Interrupt configuration 2 fields.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR24",
        "Interrupt configuration 2 fields.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR25",
        "Interrupt configuration 2 fields.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR26",
        "Interrupt configuration 2 fields.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR27",
        "Interrupt configuration 2 fields.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR28",
        "Interrupt configuration 2 fields.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR29",
        "Interrupt configuration 2 fields.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR30",
        "Interrupt configuration 2 fields.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR31",
        "Interrupt configuration 2 fields.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_IMR.
static const field_t hw_gpio_imr[] =
{
    {
        "IMR",
        "Interrupt Mask bits.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_ISR.
static const field_t hw_gpio_isr[] =
{
    {
        "ISR",
        "Interrupt status bits - Bit n of this register is asserted (active hig"
        "h) when the active condition (as determined by the corresponding ICR b"
        "it) is detected on the GPIO input and is waiting for service.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_EDGE_SEL.
static const field_t hw_gpio_edge_sel[] =
{
    {
        "GPIO_EDGE_SEL",
        "Edge select.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPIO module.
static const reg_t hw_gpio[] =
{
    {
        "DR",
        "The 32-bit GPIO_DR register stores data that is ready to be driven to "
        "the output lines.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_dr
    },
    {
        "GDIR",
        "GPIO_GDIR functions as direction control when the IOMUXC is in GPIO mo"
        "de.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_gdir
    },
    {
        "PSR",
        "GPIO_PSR is a read-only register.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpio_psr
    },
    {
        "ICR1",
        "GPIO_ICR1 contains 16 two-bit fields, where each field specifies the i"
        "nterrupt configuration for a different input signal.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_gpio_icr1
    },
    {
        "ICR2",
        "GPIO_ICR2 contains 16 two-bit fields, where each field specifies the i"
        "nterrupt configuration for a different input signal.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_gpio_icr2
    },
    {
        "IMR",
        "GPIO_IMR contains masking bits for each interrupt line.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_imr
    },
    {
        "ISR",
        "The GPIO_ISR functions as an interrupt status indicator.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_isr
    },
    {
        "EDGE_SEL",
        "GPIO_EDGE_SEL may be used to override the ICR registers' configuration"
        ".",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_edge_sel
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPT
#endif

// Bitfields in register GPT_CR.
static const field_t hw_gpt_cr[] =
{
    {
        "EN",
        "GPT Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENMOD",
        "GPT Enable mode.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGEN",
        "GPT debug mode enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAITEN",
        "GPT Wait Mode enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOZEEN",
        "GPT Doze Mode Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPEN",
        "GPT Stop Mode enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKSRC",
        "Clock Source select.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRR",
        "Free-Run or Restart mode.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Software reset.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IM1",
        "See IM2",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IM2",
        "IM2 (bits 19-18, Input Capture Channel 2 operating mode)  IM1 (bits 17"
        "-16, Input Capture Channel 1 operating mode)  The IM n bit field deter"
        "mines the transition on the input pin (for Input capture channel n ), "
        "which will trigger a capture event.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM1",
        "See OM3",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM2",
        "See OM3",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM3",
        "OM3 (bits 28-26) controls the Output Compare Channel 3 operating mode.",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FO1",
        "See F03",
        29, // LSB
        29, // MSB
        false, // Readable
        true // Writable
    },
    {
        "FO2",
        "See F03",
        30, // LSB
        30, // MSB
        false, // Readable
        true // Writable
    },
    {
        "FO3",
        "FO3 Force Output Compare Channel 3  FO2 Force Output Compare Channel 2"
        "  FO1 Force Output Compare Channel 1  The FO n bit causes the pin acti"
        "on programmed for the timer Output Compare n pin (according to the OM "
        "n bits in this register).",
        31, // LSB
        31, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_PR.
static const field_t hw_gpt_pr[] =
{
    {
        "PRESCALER",
        "Prescaler bits.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_SR.
static const field_t hw_gpt_sr[] =
{
    {
        "OF1",
        "See OF3",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF2",
        "See OF3",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF3",
        "OF3 Output Compare 3 Flag  OF2 Output Compare 2 Flag  OF1 Output Compa"
        "re 1 Flag  The OF n bit indicates that a compare event has occurred on"
        " Output Compare channel n .",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF1",
        "See IF2",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF2",
        "IF2 Input capture 2 Flag  IF1 Input capture 1 Flag  The IF n bit indic"
        "ates that a capture event has occurred on Input Capture channel n .",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROV",
        "Rollover Flag.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_IR.
static const field_t hw_gpt_ir[] =
{
    {
        "OF1IE",
        "See OF3IE",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF2IE",
        "See OF3IE",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF3IE",
        "OF3IE Output Compare 3 Interrupt Enable  OF2IE Output Compare 2 Interr"
        "upt Enable  OF1IE Output Compare 1 Interrupt Enable  The OF n IE bit c"
        "ontrols the Output Compare Channel n interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF1IE",
        "See IF2IE",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF2IE",
        "IF2IE Input capture 2 Interrupt Enable  IF1IE Input capture 1 Interrup"
        "t Enable  The IF n IE bit controls the IF n IE Input Capture n Interru"
        "pt Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROVIE",
        "Rollover Interrupt Enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_OCR1.
static const field_t hw_gpt_ocr1[] =
{
    {
        "COMP",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_OCR2.
static const field_t hw_gpt_ocr2[] =
{
    {
        "COMP",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_OCR3.
static const field_t hw_gpt_ocr3[] =
{
    {
        "COMP",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_ICR1.
static const field_t hw_gpt_icr1[] =
{
    {
        "CAPT",
        "Capture Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_ICR2.
static const field_t hw_gpt_icr2[] =
{
    {
        "CAPT",
        "Capture Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_CNT.
static const field_t hw_gpt_cnt[] =
{
    {
        "COUNT",
        "Counter Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPT module.
static const reg_t hw_gpt[] =
{
    {
        "CR",
        "The GPT Control Register (GPT_CR) is used to program and configure GPT"
        " operations.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_gpt_cr
    },
    {
        "PR",
        "The GPT Prescaler Register (GPT_PR) contains bits that determine the d"
        "ivide value of the clock that runs the counter.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpt_pr
    },
    {
        "SR",
        "The GPT Status Register (GPT_SR) contains bits that indicate that a co"
        "unter has rolled over, and if any event has occurred on the Input Capt"
        "ure and Output Compare channels.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gpt_sr
    },
    {
        "IR",
        "The GPT Interrupt Register (GPT_IR) contains bits that control whether"
        " interrupts are generated after rollover, input capture and output com"
        "pare events.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gpt_ir
    },
    {
        "OCR1",
        "The GPT Compare Register 1 (GPT_OCR1) holds the value that determines "
        "when a compare event will be generated on Output Compare Channel 1.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpt_ocr1
    },
    {
        "OCR2",
        "The GPT Compare Register 2 (GPT_OCR2) holds the value that determines "
        "when a compare event will be generated on Output Compare Channel 2.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpt_ocr2
    },
    {
        "OCR3",
        "The GPT Compare Register 3 (GPT_OCR3) holds the value that determines "
        "when a compare event will be generated on Output Compare Channel 3.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpt_ocr3
    },
    {
        "ICR1",
        "The GPT Input Capture Register 1 (GPT_ICR1) is a read-only register th"
        "at holds the value that was in the counter during the last capture eve"
        "nt on Input Capture Channel 1.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpt_icr1
    },
    {
        "ICR2",
        "The GPT Input capture Register 2 (GPT_ICR2) is a read-only register wh"
        "ich holds the value that was in the counter during the last capture ev"
        "ent on input capture channel 2.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpt_icr2
    },
    {
        "CNT",
        "The GPT Counter Register (GPT_CNT) is the main counter's register.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpt_cnt
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPU2D
#endif

// Bitfields in register GPU2D_AQHICLOCKCONTROL.
static const field_t hw_gpu2d_aqhiclockcontrol[] =
{
    {
        "MULTI_PIPE_USE_SINGLE_AXI",
        "Force all the transactions to go to one AXI.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MULTI_PIPE_REG_SELECT",
        "Determines which HI/MC to use while reading registers.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISOLATE_GPU",
        "Isolate GPU bit",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDLE_VG",
        "VG pipe is idle.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDLE2_D",
        "2D pipe is idle.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDLE3_D",
        "3D pipe is idle.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOFT_RESET",
        "Soft resets the IP.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_DEBUG_REGISTERS",
        "Disable debug registers.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_RAM_CLOCK_GATING",
        "Disables clock gating for rams.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSCALE_CMD_LOAD",
        "",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSCALE_VAL",
        "",
        23, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLK2D_DIS",
        "Disable 2D clock.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLK3D_DIS",
        "Disable 3D clock.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQHIIDLE.
static const field_t hw_gpu2d_aqhiidle[] =
{
    {
        "AXI_LP",
        "AXI is in low power mode.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_TS",
        "TS is idle.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_FP",
        "FP is idle.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_IM",
        "IM is idle.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_VG",
        "VG is idle.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_TX",
        "TX is idle.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_RA",
        "RA is idle.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_SE",
        "SE is idle.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_PA",
        "PA is idle.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_SH",
        "SH is idle.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_PE",
        "PE is idle.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_DE",
        "DE is idle.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_FE",
        "FE is idle.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQAXICONFIG.
static const field_t hw_gpu2d_aqaxiconfig[] =
{
    {
        "ARCACHE",
        "",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AWCACHE",
        "",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARID",
        "",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AWID",
        "",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQAXISTATUS.
static const field_t hw_gpu2d_aqaxistatus[] =
{
    {
        "WR_ERR_ID",
        "",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RD_ERR_ID",
        "",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DET_WR_ERR",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DET_RD_ERR",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQINTRACKNOWLEDGE.
static const field_t hw_gpu2d_aqintracknowledge[] =
{
    {
        "INTR_VEC",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQINTRENBL.
static const field_t hw_gpu2d_aqintrenbl[] =
{
    {
        "INTR_ENBL_VEC",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AQIDENT.
static const field_t hw_gpu2d_aqident[] =
{
    {
        "CUSTOMER",
        "Customer value.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TECHNOLOGY",
        "Technology value.",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REVISION",
        "Revision value.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PRODUCT",
        "Product value.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FAMILY",
        "Family value.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_FEATURES.
static const field_t hw_gpu2d_features[] =
{
    {
        "FE20_BIT_INDEX",
        "Supports 20 bit index.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RS_YUV_TARGET",
        "Supports resolving into YUV target.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BYTE_WRITE_3D",
        "3D PE has byte write capability.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FE20",
        "FE 2.0 is present.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VGTS",
        "VG tessellator is present.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PIPE_VG",
        "VG pipe is present.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MEM32_BIT_SUPPORT",
        "32 bit memory address support.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUY2_RENDER_TARGET",
        "YUY2 support in PE and YUY2 to RGB conversion in resolve.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALF_TX_CACHE",
        "TX cache is half.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALF_PE_CACHE",
        "PE cache is half.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUY2_AVERAGING",
        "YUY2 averaging support in resolve.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NO_SCALER",
        "IP does not have 2D scaler.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BYTE_WRITE_2D",
        "Supports byte write in 2D.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUFFER_INTERLEAVING",
        "IP supports interleaving depth and color buffers.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NO422_TEXTURE",
        "IP does not have 422 texture input format.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NO_EZ",
        "IP does not have early-Z.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MIN_AREA",
        "IP is configured to have minimum area.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CG",
        "Second level clock gating is available.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUV420_TILER",
        "YUV 4:2:0 tiler is available.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HIGH_DYNAMIC_RANGE",
        "Shows if the IP has HDR support.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FAST_SCALER",
        "Shows if the IP has HD scaler.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ETC1_TEXTURE_COMPRESSION",
        "ETC1 texture compression.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PIPE_2D",
        "Shows if there is 2D engine.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DC",
        "Shows if there is a display controller in the IP.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MSAA",
        "MSAA support.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUV420_FILTER",
        "YUV 4:2:0 support in filter blit.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ZCOMPRESSION",
        "Depth and color compression.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_MODE",
        "Debug registers.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DXT_TEXTURE_COMPRESSION",
        "DXT texture compression.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PIPE_3D",
        "3D pipe.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SPECIAL_ANTI_ALIASING",
        "Full-screen anti-aliasing.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FAST_CLEAR",
        "Fast clear.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPID.
static const field_t hw_gpu2d_chipid[] =
{
    {
        "ID",
        "Id.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPREV.
static const field_t hw_gpu2d_chiprev[] =
{
    {
        "REV",
        "Revision.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPDATE.
static const field_t hw_gpu2d_chipdate[] =
{
    {
        "DATE",
        "Date.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPTIME.
static const field_t hw_gpu2d_chiptime[] =
{
    {
        "TIME",
        "Time.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPCUSTOMER.
static const field_t hw_gpu2d_chipcustomer[] =
{
    {
        "GROUP",
        "Group.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPANY",
        "Company.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_MINORFEATURES0.
static const field_t hw_gpu2d_minorfeatures0[] =
{
    {
        "FLIP_Y",
        "Y flipping capability is added to resolve.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DUAL_RETURN_BUS",
        "Dual Return Bus from HI to clients.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENDIANNESS_CONFIG",
        "Configurable endianness support.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TEXTURE8_K",
        "Supports 8Kx8K textures.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECT_TEXTURE_CONVERTER",
        "Driver hack is not needed.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SPECIAL_MSAA_LOD",
        "Special LOD calculation when MSAA is on.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FAST_CLEAR_FLUSH",
        "Proper flush is done in fast clear cache.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "_2DPE20",
        "2D PE 2.0 is present.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECT_AUTO_DISABLE",
        "Auto disable in FC is correct.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RENDER_8K",
        "Supports 8K render target.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TILE_STATUS_2BITS",
        "2 bits are used instead of 4 bits for tile status.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEPARATE_TILE_STATUS_WHEN_INTERLEAVED",
        "Use 2 separate tile status buffers in interleaved mode.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SUPER_TILED_32X32",
        "32x32 super tile is available.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_20",
        "Major updates to VG pipe (TS buffer tiling.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TS_EXTENDED_COMMANDS",
        "New commands added to the tessellator.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPRESSION_FIFO_FIXED",
        "If this bit is not set, the FIFO counter should be set to 50.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "EXTRA_SHADER_INSTRUCTIONS0",
        "Floor, ceil, and sign instructions are available.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_FILTER",
        "VG filter is available.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_21",
        "Minor updates to VG pipe (Event generation from VG, TS, PE).",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SHADER_GETS_W",
        "W is sent to SH from RA.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "EXTRA_SHADER_INSTRUCTIONS1",
        "Sqrt, sin, cos instructions are available.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEFAULT_REG0",
        "Unavailable registers will return 0.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MC_20",
        "New style MC with separate paths for color and depth.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SHADER_MSAA_SIDEBAND",
        "Put the MSAA data into sideband fifo.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUG_FIXES0",
        "",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VAA",
        "VAA is available or not.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BYPASS_IN_MSAA",
        "Shader supports bypass mode when MSAA is enabled.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HIERARCHICAL_Z",
        "Hierarchiccal Z is supported.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEW_TEXTURE",
        "New texture unit is available.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "A8_TARGET_SUPPORT",
        "2D engine supports A8 target.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECT_STENCIL",
        "Correct stencil behavior in depth only.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENHANCE_VR",
        "Enhance VR and add a mode to walk 16 pixels in 16-bit mode in Vertical"
        " pass to improve $ hit rate when rotating 90/270.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CACHECONTROL.
static const field_t hw_gpu2d_cachecontrol[] =
{
    {
        "NOT_USED",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_RESETMEMCOUNTERS.
static const field_t hw_gpu2d_resetmemcounters[] =
{
    {
        "RESET",
        "",
        0, // LSB
        31, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALREADS.
static const field_t hw_gpu2d_totalreads[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALWRITES.
static const field_t hw_gpu2d_totalwrites[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPSPECS.
static const field_t hw_gpu2d_chipspecs[] =
{
    {
        "VERTEX_OUTPUT_BUFFER_SIZE",
        "Log2 of vertex output buffer size.",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NUM_PIXEL_PIPES",
        "Number of pixel pipes.",
        4, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NUM_SHADER_CORES",
        "Number of shader cores.",
        7, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VERTEX_CACHE_SIZE",
        "Number of entries in the vertex shader cache.",
        15, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "THREAD_COUNT",
        "Log2 of thread count.",
        20, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TEMP_REGISTERS",
        "Log2 of temporary registers.",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STREAMS",
        "Number of vertex streams.",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALWRITEBURSTS.
static const field_t hw_gpu2d_totalwritebursts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALWRITEREQS.
static const field_t hw_gpu2d_totalwritereqs[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALWRITELASTS.
static const field_t hw_gpu2d_totalwritelasts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALREADBURSTS.
static const field_t hw_gpu2d_totalreadbursts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALREADREQS.
static const field_t hw_gpu2d_totalreadreqs[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALREADLASTS.
static const field_t hw_gpu2d_totalreadlasts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_GPOUT0.
static const field_t hw_gpu2d_gpout0[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_GPOUT1.
static const field_t hw_gpu2d_gpout1[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_GPOUT2.
static const field_t hw_gpu2d_gpout2[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_AXICONTROL.
static const field_t hw_gpu2d_axicontrol[] =
{
    {
        "WR_FULL_BURST_MODE",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_MINORFEATURES1.
static const field_t hw_gpu2d_minorfeatures1[] =
{
    {
        "TEXTURE_STRIDE",
        "Texture has stride and memory addressing.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUG_FIXES2",
        "",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUG_FIXES1",
        "",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_DOUBLE_BUFFER",
        "Double buffering support for VG (second TS-->VG semaphore is present).",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "V2_COMPRESSION",
        "V2 compression.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSUV_SWIZZLE",
        "Resolve UV swizzle.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALCYCLES.
static const field_t hw_gpu2d_totalcycles[] =
{
    {
        "CYCLES",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_TOTALIDLECYLES.
static const field_t hw_gpu2d_totalidlecyles[] =
{
    {
        "CYCLES",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_CHIPSPECS2.
static const field_t hw_gpu2d_chipspecs2[] =
{
    {
        "CYCLES",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_MODULEPOWERCONTROLS.
static const field_t hw_gpu2d_modulepowercontrols[] =
{
    {
        "TURN_OFF_COUNTER",
        "Counter value for clock gating the module if the module is idle for th"
        "is amount of clock cycles.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TURN_ON_COUNTER",
        "Number of clock cycles to wait after turning on the clock.",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_STARVE_MODULE_CLOCK_GATING",
        "Disables module level clock gating for starve/idle condition.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_STALL_MODULE_CLOCK_GATING",
        "Disables module level clock gating for stall condition.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_MODULE_CLOCK_GATING",
        "Enables module level clock gating.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_MODULEPOWERMODULECONTROL.
static const field_t hw_gpu2d_modulepowermodulecontrol[] =
{
    {
        "DISABLE_MODULE_CLOCK_GATING_TS",
        "Disables module level clock gating for TS.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_FP",
        "Disables module level clock gating for FP.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_IM",
        "Disables module level clock gating for IM.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_VG",
        "Disables module level clock gating for VG.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_TX",
        "Disables module level clock gating for TX.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_RA",
        "Disables module level clock gating for RA.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_SE",
        "Disables module level clock gating for SE.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_PA",
        "Disables module level clock gating for PA.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_SH",
        "Disables module level clock gating for SH.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_PE",
        "Disables module level clock gating for PE.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_DE",
        "Disables module level clock gating for DE.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_MODULE_CLOCK_GATING_FE",
        "Disables module level clock gating for FE.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU2D_MODULEPOWERMODULESTATUS.
static const field_t hw_gpu2d_modulepowermodulestatus[] =
{
    {
        "MODULE_CLOCK_GATED_TS",
        "Module level clock gating is ON for TS.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_FP",
        "Module level clock gating is ON for FP.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_IM",
        "Module level clock gating is ON for IM.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_VG",
        "Module level clock gating is ON for VG.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_TX",
        "Module level clock gating is ON for TX.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_RA",
        "Module level clock gating is ON for RA.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_SE",
        "Module level clock gating is ON for SE.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_PA",
        "Module level clock gating is ON for PA.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_SH",
        "Module level clock gating is ON for SH.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_PE",
        "Module level clock gating is ON for PE.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_DE",
        "Module level clock gating is ON for DE.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CLOCK_GATED_FE",
        "Module level clock gating is ON for FE.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPU2D module.
static const reg_t hw_gpu2d[] =
{
    {
        "AQHICLOCKCONTROL",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_gpu2d_aqhiclockcontrol
    },
    {
        "AQHIIDLE",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        13, // Number of bitfields
        hw_gpu2d_aqhiidle
    },
    {
        "AQAXICONFIG",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gpu2d_aqaxiconfig
    },
    {
        "AQAXISTATUS",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gpu2d_aqaxistatus
    },
    {
        "AQINTRACKNOWLEDGE",
        "Interrupt acknowledge register.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_aqintracknowledge
    },
    {
        "AQINTRENBL",
        "Interrupt enable register.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_aqintrenbl
    },
    {
        "AQIDENT",
        "Identification register.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        false, // Writable
        5, // Number of bitfields
        hw_gpu2d_aqident
    },
    {
        "FEATURES",
        "Shows which features are enabled in this chip.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        32, // Number of bitfields
        hw_gpu2d_features
    },
    {
        "CHIPID",
        "Shows the ID for the chip in BCD.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_chipid
    },
    {
        "CHIPREV",
        "Shows the revision for the chip in BCD.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_chiprev
    },
    {
        "CHIPDATE",
        "Shows the release date for the IP.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_chipdate
    },
    {
        "CHIPTIME",
        "Shows the release time for the IP.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_chiptime
    },
    {
        "CHIPCUSTOMER",
        "Shows the customer and group for the IP.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_gpu2d_chipcustomer
    },
    {
        "MINORFEATURES0",
        "Shows which minor features are enabled in this chip.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        false, // Writable
        32, // Number of bitfields
        hw_gpu2d_minorfeatures0
    },
    {
        "CACHECONTROL",
        "",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_cachecontrol
    },
    {
        "RESETMEMCOUNTERS",
        "Writing 1 will reset the counters and stop counting.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_resetmemcounters
    },
    {
        "TOTALREADS",
        "Total reads in terms of 64bits.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalreads
    },
    {
        "TOTALWRITES",
        "Total writes in terms of 64bits.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalwrites
    },
    {
        "CHIPSPECS",
        "Specs for the chip.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        false, // Writable
        7, // Number of bitfields
        hw_gpu2d_chipspecs
    },
    {
        "TOTALWRITEBURSTS",
        "Total write Data Count in terms of 64bits.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalwritebursts
    },
    {
        "TOTALWRITEREQS",
        "Total write Request Count.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalwritereqs
    },
    {
        "TOTALWRITELASTS",
        "Total WLAST Count.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalwritelasts
    },
    {
        "TOTALREADBURSTS",
        "Total Read Data Count in terms of 64bits.",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalreadbursts
    },
    {
        "TOTALREADREQS",
        "Total Read Request Count.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalreadreqs
    },
    {
        "TOTALREADLASTS",
        "Total RLAST Count.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalreadlasts
    },
    {
        "GPOUT0",
        "General Purpose output register0.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_gpout0
    },
    {
        "GPOUT1",
        "General Purpose output register1.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_gpout1
    },
    {
        "GPOUT2",
        "General Purpose output register2.",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_gpout2
    },
    {
        "AXICONTROL",
        "Special Handling on AXI Bus",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_axicontrol
    },
    {
        "MINORFEATURES1",
        "Shows which features are enabled in this chip.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_gpu2d_minorfeatures1
    },
    {
        "TOTALCYCLES",
        "Total cycles.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalcycles
    },
    {
        "TOTALIDLECYLES",
        "Total cycles where the GPU is idle.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_totalidlecyles
    },
    {
        "CHIPSPECS2",
        "Specs for the chip.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu2d_chipspecs2
    },
    {
        "MODULEPOWERCONTROLS",
        "The Power Management register set has just a few registers for control"
        "ling clock gating within the core.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_gpu2d_modulepowercontrols
    },
    {
        "MODULEPOWERMODULECONTROL",
        "Module level control registers.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gpu2d_modulepowermodulecontrol
    },
    {
        "MODULEPOWERMODULESTATUS",
        "Module level control status.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        false, // Writable
        12, // Number of bitfields
        hw_gpu2d_modulepowermodulestatus
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPU3D
#endif

// Bitfields in register GPU3D_AQH_CLK_CTRL.
static const field_t hw_gpu3d_aqh_clk_ctrl[] =
{
    {
        "CLK3D_DIS",
        "Disable 3D clock.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLK2D_DIS",
        "Disable 2D clock.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSCALE_VAL",
        "",
        2, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSCALE_CMD_LOAD",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_RAM_CLOCK_GATING",
        "Disables clock gating for rams.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISABLE_DEBUG_REGISTERS",
        "Disable debug registers.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOFT_RESET",
        "Soft resets the IP.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDLE3_D",
        "3D pipe is idle.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDLE2_D",
        "2D pipe is idle.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDLE_VG",
        "VG is idle.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISOLATE_GPU",
        "Isolate GPU bit",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MULTI_PIPE_REG_SELECT",
        "Determines which HI/MC to use while reading registers.",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MULTI_PIPE_USE_SINGLE_AXI",
        "Force all the transactions to go to one AXI",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_AQH_IDLE.
static const field_t hw_gpu3d_aqh_idle[] =
{
    {
        "IDLE_FE",
        "FE is idle.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_DE",
        "DE is idle.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_PE",
        "PE is idle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_SH",
        "SH is idle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_PA",
        "PA is idle.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_SE",
        "SE is idle.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_RA",
        "RA is idle.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_TX",
        "TX is idle.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_VG",
        "VG is idle.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_IM",
        "IM is idle.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_FP",
        "FP is idle.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE_TS",
        "TS is idle.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AXI_LP",
        "AXI is in low power mode.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_AQA_CFG.
static const field_t hw_gpu3d_aqa_cfg[] =
{
    {
        "AWID",
        "",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARID",
        "",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AWCACHE",
        "",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARCACHE",
        "",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_AQA_STATUS.
static const field_t hw_gpu3d_aqa_status[] =
{
    {
        "WR_ERR_ID",
        "",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_ERR_ID",
        "",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DET_WR_ERR",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DET_RD_ERR",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_AQI_ACK.
static const field_t hw_gpu3d_aqi_ack[] =
{
    {
        "INTR_VEC",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_AQI_ENBL.
static const field_t hw_gpu3d_aqi_enbl[] =
{
    {
        "INTR_ENBL_VEC",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_AQIDENT.
static const field_t hw_gpu3d_aqident[] =
{
    {
        "CUSTOMER",
        "Customer value.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TECHNOLOGY",
        "Technology value.",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REVISION",
        "Revision value.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PRODUCT",
        "Product value.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FAMILY",
        "Family value.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GC_FEAT.
static const field_t hw_gpu3d_gc_feat[] =
{
    {
        "FAST_CLEAR",
        "Fast clear.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SPECIAL_ANTI_ALIASING",
        "Full-screen anti-aliasing.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PIPE_3D",
        "3D pipe.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DXT_TEXTURE_COMPRESSION",
        "DXT texture compression.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_MODE",
        "Debug registers.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ZCOMPRESSION",
        "Depth and color compression.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUV420_FILTER",
        "YUV 4:2:0 support in filter blit.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MSAA",
        "MSAA support.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DC",
        "Shows if there is a display controller in the IP.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PIPE_2D",
        "Shows if there is 2D engine.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ETC1_TEXTURE_COMPRESSION",
        "ETC1 texture compression.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FAST_SCALER",
        "Shows if the IP has HD scaler.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HIGH_DYNAMIC_RANGE",
        "Shows if the IP has HDR support.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUV420_TILER",
        "YUV 4:2:0 tiler is available.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MODULE_CG",
        "Secong level clock gating is available.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MIN_AREA",
        "IP is configured to have minimum area.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NO_EZ",
        "IP does not have early-Z.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NO422_TEXTURE",
        "IP does not have 422 texture input format.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUFFER_INTERLEAVING",
        "IP supports interleaving depth and color buffers.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BYTE_WRITE_2D",
        "Supports byte write in 2D.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NO_SCALER",
        "IP does not have 2D scaler.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUY2_AVERAGING",
        "YUY2 averaging support in resolve.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALF_PE_CACHE",
        "PE cache is half.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALF_TX_CACHE",
        "TX cache is half.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "YUY2_RENDER_TARGET",
        "YUY2 support in PE and YUY2 to RGB conversion in resolve.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MEM32_BIT_SUPPORT",
        "32 bit memory address support.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PIPE_VG",
        "VCG pipe is present.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VGTS",
        "VG tessellator is present.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FE20",
        "FE 2.0 is present.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BYTE_WRITE_3D",
        "3D PE has byte write capability.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RS_YUV_TARGET",
        "Supports resolving into YUV target.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FE20_BIT_INDEX",
        "Supports 20 bit index.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCC_ID.
static const field_t hw_gpu3d_gcc_id[] =
{
    {
        "ID",
        "Id",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCC_REV.
static const field_t hw_gpu3d_gcc_rev[] =
{
    {
        "REV",
        "Revision",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCC_DATE.
static const field_t hw_gpu3d_gcc_date[] =
{
    {
        "DATE",
        "Date",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCC_TIME.
static const field_t hw_gpu3d_gcc_time[] =
{
    {
        "TIME",
        "Time",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCC_CUST.
static const field_t hw_gpu3d_gcc_cust[] =
{
    {
        "GROUP",
        "Group",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPANY",
        "Company",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCM_FEAT_0.
static const field_t hw_gpu3d_gcm_feat_0[] =
{
    {
        "FLIP_Y",
        "Y flipping capability is added to resolve.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DUAL_RETURN_BUS",
        "Dual Return Bus from HI to clients.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENDIANNESS_CONFIG",
        "Configurable endianness support.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TESTURE8_K",
        "Supports 8Kx8K textures.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECT_TEXTURE_CONVERTER",
        "Driver hack is not needed.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SPECIAL_MSAA_LOD",
        "Special LOD calculation when MSAA is on.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FAST_CLEAR_FLUSH",
        "Proper flush is done in fast clear cache.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "_2DPE20",
        "2D PE 2.0 is present.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECT_AUTO_DISABLE",
        "Auto disable in FC is correct.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RENDER_8K",
        "Supports 8K render target.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TILE_STATUS_2BITS",
        "2 bits are used instead of 4 bits for tile status.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEPARATE_TILE_STATUS_WHEN_INTERLEAVED",
        "Use 2 separate tile status buffers in interleaved mode.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SUPER_TILED_32X32",
        "32x32 super tile is available.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_20",
        "Major updates to VG pipe (TS buffer tiling.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TS_EXTENDED_COMMANDS",
        "New commands added to the tessellator.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPRESSION_FIFO_FIXED",
        "If this bit is not set, the FIFO counter should be set to 50.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "EXTRA_SHADER_INSTRUCTIONS0",
        "Floor, ceil, and sign instructions are available.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_FILTER",
        "VG filter is available.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_21",
        "Minor updates to VG pipe (Event generation from VG, TS, PE).",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SHADER_GETS_W",
        "W is sent to SH from RA.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "EXTRA_SHADER_INSTRUCTIONS1",
        "Sqrt, sin, cos intructions are available.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEFAULT_REG0",
        "Unavailable registers will return 0.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MC_20",
        "New stlye MC with separate paths for color and depth.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SHADER_MSAA_SIDEBAND",
        "Put the MSAA data into sideband fifo.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUG_FIXES0",
        "",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VAA",
        "VAA is available or not.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BYPASS_IN_MSAA",
        "Shader supports bypass modew when MSAA is enabled.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HIERARCHICAL_Z",
        "Hierarchical Z is supported.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEW_TEXTURE",
        "New texture unit is available.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "A8_TARGET_SUPPORT",
        "2D engine supports A8 target.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECT_STENCIL",
        "Correct stencil behavior in depth only.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ENHANCE_VR",
        "Enhance VR and add a mode to walk 16 pixels in 16-bit mode in Vertical"
        " pass to improve $ hit rate when rotating 90/270.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCC_CRTL.
static const field_t hw_gpu3d_gcc_crtl[] =
{
    {
        "NOT_USED",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCR_MEM_CTRS.
static const field_t hw_gpu3d_gcr_mem_ctrs[] =
{
    {
        "RESET",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCT_READS.
static const field_t hw_gpu3d_gct_reads[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCT_WRITES.
static const field_t hw_gpu3d_gct_writes[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCC_SPECS.
static const field_t hw_gpu3d_gcc_specs[] =
{
    {
        "STREAMS",
        "Number of vertex streams.",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TEAMP_REGISTERS",
        "Log2 of temporary registers.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "THREAD_COUNT",
        "Log2 of thread count.",
        8, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VERTEX_CACHE_SIZE",
        "Number of entries in the vertex shader cache.",
        12, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NUM_SHADER_CORES",
        "Number of shader cores.",
        20, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NUM_PIXEL_PIPES",
        "Number of pixel pipes.",
        25, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VERTEX_OUTPUT_BUFFER_SIZE",
        "Log2 of vertex output buffer size.",
        28, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCT_WRITE_BURSTS.
static const field_t hw_gpu3d_gct_write_bursts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCT_WRITE_REQS.
static const field_t hw_gpu3d_gct_write_reqs[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCT_WRITE_LASTS.
static const field_t hw_gpu3d_gct_write_lasts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCT_READ_BURSTS.
static const field_t hw_gpu3d_gct_read_bursts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCT_READ_REQS.
static const field_t hw_gpu3d_gct_read_reqs[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCT_READ_LASTS.
static const field_t hw_gpu3d_gct_read_lasts[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCGPO_0.
static const field_t hw_gpu3d_gcgpo_0[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCGPO_1.
static const field_t hw_gpu3d_gcgpo_1[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCGPO_2.
static const field_t hw_gpu3d_gcgpo_2[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCA_CRTL.
static const field_t hw_gpu3d_gca_crtl[] =
{
    {
        "WR_FULL_BURST_MODE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCM_FEAT_1.
static const field_t hw_gpu3d_gcm_feat_1[] =
{
    {
        "RSUV_SWIZZLE",
        "Resolve UV swizzle.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "V2_COMPRESSION",
        "V2 compression.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VG_DOUBLE_BUFFER",
        "Double buffering support for VG (second TS-->VG semaphore is present).",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUG_FIXES1",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUG_FIXES2",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TEXTURE_STRIDE",
        "Texture has stride and memory addressing.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCT_CYCLES.
static const field_t hw_gpu3d_gct_cycles[] =
{
    {
        "CYCLES",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPU3D_GCT_IDLE_CYCLES.
static const field_t hw_gpu3d_gct_idle_cycles[] =
{
    {
        "CYCLES",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPU3D module.
static const reg_t hw_gpu3d[] =
{
    {
        "AQH_CLK_CTRL",
        "Clock control register.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_gpu3d_aqh_clk_ctrl
    },
    {
        "AQH_IDLE",
        "Idle status register.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        13, // Number of bitfields
        hw_gpu3d_aqh_idle
    },
    {
        "AQA_CFG",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gpu3d_aqa_cfg
    },
    {
        "AQA_STATUS",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_gpu3d_aqa_status
    },
    {
        "AQI_ACK",
        "Interrupt acknowledge register.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_aqi_ack
    },
    {
        "AQI_ENBL",
        "Interrupt enable register.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu3d_aqi_enbl
    },
    {
        "AQIDENT",
        "Identification register.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        false, // Writable
        5, // Number of bitfields
        hw_gpu3d_aqident
    },
    {
        "GC_FEAT",
        "Shows which features are enabled in this chip.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        32, // Number of bitfields
        hw_gpu3d_gc_feat
    },
    {
        "GCC_ID",
        "Shows the ID for the chip in SBCD.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gcc_id
    },
    {
        "GCC_REV",
        "Shows the revision for the chip in BCD.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gcc_rev
    },
    {
        "GCC_DATE",
        "Shows the release date for the IP.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gcc_date
    },
    {
        "GCC_TIME",
        "Shows the release time for the IP.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gcc_time
    },
    {
        "GCC_CUST",
        "Shows the customer and group for the IP.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_gpu3d_gcc_cust
    },
    {
        "GCM_FEAT_0",
        "Shows which minor features are enabled in this chip.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        false, // Writable
        32, // Number of bitfields
        hw_gpu3d_gcm_feat_0
    },
    {
        "GCC_CRTL",
        "Not used.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu3d_gcc_crtl
    },
    {
        "GCR_MEM_CTRS",
        "Writing 1 will reset the counters and stop counting.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu3d_gcr_mem_ctrs
    },
    {
        "GCT_READS",
        "Total reads in terms of 64 bits.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gct_reads
    },
    {
        "GCT_WRITES",
        "Total writes in terms of 64 bits.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gct_writes
    },
    {
        "GCC_SPECS",
        "Specs for the chip.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        false, // Writable
        7, // Number of bitfields
        hw_gpu3d_gcc_specs
    },
    {
        "GCT_WRITE_BURSTS",
        "Total write Data Count in terms of 64 bits.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gct_write_bursts
    },
    {
        "GCT_WRITE_REQS",
        "Total write Request Count.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gct_write_reqs
    },
    {
        "GCT_WRITE_LASTS",
        "Total WLAST Count.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gct_write_lasts
    },
    {
        "GCT_READ_BURSTS",
        "Total Read Data COunt in terms of 64 bits.",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gct_read_bursts
    },
    {
        "GCT_READ_REQS",
        "Total Read Request Count.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gct_read_reqs
    },
    {
        "GCT_READ_LASTS",
        "Total RLAST Count.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpu3d_gct_read_lasts
    },
    {
        "GCGPO_0",
        "General Purpose output register 0.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu3d_gcgpo_0
    },
    {
        "GCGPO_1",
        "General Purpose output register 1.",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu3d_gcgpo_1
    },
    {
        "GCGPO_2",
        "General Purpose output register 2.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu3d_gcgpo_2
    },
    {
        "GCA_CRTL",
        "Speacial Handling on AXI Bus.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu3d_gca_crtl
    },
    {
        "GCM_FEAT_1",
        "Shows which features are enabled in this chip.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_gpu3d_gcm_feat_1
    },
    {
        "GCT_CYCLES",
        "Total cycles.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu3d_gct_cycles
    },
    {
        "GCT_IDLE_CYCLES",
        "Total cycles where the GPU is idle.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpu3d_gct_idle_cycles
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark HDMI
#endif

// Bitfields in register HDMI_DESIGN_ID.
static const field_t hw_hdmi_design_id[] =
{
    {
        "DESIGN_ID",
        "This is a 1 byte design ID code fixed by Freescale that Identifies the"
        " main revision of the HDMI TX controller.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_REVISION_ID.
static const field_t hw_hdmi_revision_id[] =
{
    {
        "REVISION_ID",
        "This is a one byte revision ID code fixed by Freescale that Identifies"
        " the main revision of the HDMI TX controller.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PRODUCT_ID0.
static const field_t hw_hdmi_product_id0[] =
{
    {
        "PRODUCT_ID0",
        "This one byte fixed code Identifies Freescale's product line (\"A0h\" "
        "for HDMI TX products).",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PRODUCT_ID1.
static const field_t hw_hdmi_product_id1[] =
{
    {
        "PRODUCT_ID1",
        "This one byte fixed code identifies Freescale's product line according"
        " to:  01h HDMI TX Controller  02h DWC_hdmi_rx Controller  C1h HDMI TX "
        "Controller with HDCP encryption engine  C2h DWC_hdmi_rx Controller wit"
        "h encryption engine",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CONFIG0_ID.
static const field_t hw_hdmi_config0_id[] =
{
    {
        "HDCP",
        "Indicates if HDCP is present",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CEC",
        "Indicates if CEC is present",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CSC",
        "Indicates if Color Space Conversion block is present",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HDMI14",
        "Indicates if HDMI 1.4 features are present",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDI2S",
        "Indicates if I2S interface is present",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDSPDIF",
        "Indicates if SPDIF interface is present",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDHBR",
        "Indicates if HBR interface is present",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PREPEN",
        "Indicates if it is possible to use internal pixel repetition",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CONFIG1_ID.
static const field_t hw_hdmi_config1_id[] =
{
    {
        "CONFAHB",
        "Indicates that configuration interface is AHB interface",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CONFAPB",
        "Indicates that configuration interface is APB interface",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CONFOCP",
        "Indicates that configuration interface is OCP interface",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CONFI2C",
        "Indicates that configuration interface is I2C interface",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CONFSFRDIR",
        "Indicates that configuration interface is SFR interface",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CONFIG2_ID.
static const field_t hw_hdmi_config2_id[] =
{
    {
        "PHYTYPE",
        "Indicates the type of PHY interface selected:  00h Legacy PHY (HDMI TX"
        " PHY)  F2h PHY_Gen2 (HDMI 3D TX PHY)  E2h PHY_Gen2 (HDMI 3D TX PHY) + "
        "HEAC PHY",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CONFIG3_ID.
static const field_t hw_hdmi_config3_id[] =
{
    {
        "CONFGPAUD",
        "Indicates that configuration interface is Generic Parallel Audio (GPAU"
        "D) interface",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_FC_STAT0.
static const field_t hw_hdmi_ih_fc_stat0[] =
{
    {
        "NULL_",
        "Active after successful transmission of an Null packet.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACR",
        "Active after successful transmission of an Audio Clock Regeneration (N"
        "/CTS transmission) packet.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDS",
        "Active after successful transmission of an Audio Sample packet.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBA",
        "Reserved",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DST",
        "Reserved",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HBR",
        "Active after successful transmission of an Audio HBR packet.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACP",
        "Active after successful transmission of an Audio Content Protection pa"
        "cket.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDI",
        "Active after successful transmission of an Audio InfoFrame packet.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_FC_STAT1.
static const field_t hw_hdmi_ih_fc_stat1[] =
{
    {
        "GCP",
        "Active after successful transmission of an General Control Packet.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVI",
        "Active after successful transmission of an AVI infoFrame packet.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPEG",
        "Reserved",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPD",
        "Active after successful transmission of an Source Product Descriptor i"
        "nfoFrame packet.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSD",
        "Active after successful transmission of an Vendor Specific Data infoFr"
        "ame packet.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR2",
        "Active after successful transmission of an International Standard Reco"
        "rding Code 2 packet.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR1",
        "Active after successful transmission of an International Standard Reco"
        "rding Code 1 packet.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GMD",
        "Active after successful transmission of an Gamut metadata packet.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_FC_STAT2.
static const field_t hw_hdmi_ih_fc_stat2[] =
{
    {
        "HIGHPRIORITY_OVERFLOW",
        "Frame Composer high priority packet queue descriptor overflow indicati"
        "on.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOWPRIORITY_OVERFLOW",
        "Frame Composer low priority packet queue descriptor overflow indicatio"
        "n.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_AS_STAT0.
static const field_t hw_hdmi_ih_as_stat0[] =
{
    {
        "AUD_FIFO_OVERFLOW",
        "Audio Sampler audio FIFO full indication.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUD_FIFO_UNDERFLOW",
        "Audio Sampler audio FIFO empty indication.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUD_FIFO_UNDERFLOW_THR",
        "Audio Sampler audio FIFO empty threshold (four samples) indication.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_PHY_STAT0.
static const field_t hw_hdmi_ih_phy_stat0[] =
{
    {
        "HDP",
        "HDMI Hot Plug Detect indication.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TX_PHY_LOCK",
        "TX PHY PLL lock indication.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE",
        "TX PHY RX_SENSE indication for driver 0.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE1",
        "TX PHY RX_SENSE indication for driver 1.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE2",
        "TX PHY RX_SENSE indication for driver 2.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE3",
        "TX PHY RX_SENSE indication for driver 3.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_I2CM_STAT0.
static const field_t hw_hdmi_ih_i2cm_stat0[] =
{
    {
        "I2CMASTER_ERROR",
        "I2C Master error indication",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "I2CMASTERDONE",
        "I2C Master done indication",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_CEC_STAT0.
static const field_t hw_hdmi_ih_cec_stat0[] =
{
    {
        "DONE",
        "CEC Done Indication",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOM",
        "CEC End of Message Indication",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK",
        "CEC Nack indication",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARB_LOST",
        "CEC Arb_Lost indication",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_INITIATOR",
        "CEC Error_follow indication",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_FOLLOW",
        "CEC Error_follow indication",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP",
        "CEC Wake-up indication",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_VP_STAT0.
static const field_t hw_hdmi_ih_vp_stat0[] =
{
    {
        "FIFOEMPTYBYP",
        "Video packetizer 8-bit bypass fifo empty interrupt",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOFULLBYP",
        "Video packetizer 8-bit bypass fifo full interrupt",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOEMPTYREMAP",
        "Video packetizer pixel YCC 422 re-mapper FIFO empty interrupt",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOFULLREMAP",
        "Video packetizer pixel YCC 422 re-mapper FIFO full interrupt",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOEMPTYPP",
        "Video packetizer pixel packing FIFO empty interrupt",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOFULLPP",
        "Video packetizer pixel packing FIFO full interrupt",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOEMPTYREPET",
        "Video packetizer pixel repeater FIFO empty interrupt",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOFULLREPET",
        "Video packetizer pixel repeater FIFO full interrupt",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_I2CMPHY_STAT0.
static const field_t hw_hdmi_ih_i2cmphy_stat0[] =
{
    {
        "I2CMPHYERROR",
        "I2C Master PHY error indication",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "I2CMPHYDONE",
        "I2C Master PHY done indication",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_AHBDMAAUD_STAT0.
static const field_t hw_hdmi_ih_ahbdmaaud_stat0[] =
{
    {
        "AHBDMAAUD_INTBUFFEMPTY",
        "AHB audio DMA Buffer empty interrupt",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTBUFFFULL",
        "AHB audio DMA Buffer full interrupt",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTDONE",
        "AHB audio DMA done interrupt",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTRETRYSPLIT",
        "AHB audio DMA RETRY/SPLIT interrupt",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTLOSTOWNERSHIP",
        "AHB audio DMA lost ownership interrupt",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTERROR",
        "AHB audio DMA error interrupt",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_MUTE_FC_STAT0.
static const field_t hw_hdmi_ih_mute_fc_stat0[] =
{
    {
        "NULL_",
        "When set to 1, mutes IH_ FC_STAT0[0]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACR",
        "When set to 1, mutes IH_ FC_STAT0[1]",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDS",
        "When set to 1, mutes IH_ FC_STAT0[2]",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OBA",
        "When set to 1, mutes IH_ FC_STAT0[3]",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DST",
        "When set to 1, mutes IH_ FC_STAT0[4]",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HBR",
        "When set to 1, mutes IH_ FC_STAT0[5]",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACP",
        "When set to 1, mutes IH_ FC_STAT0[6]",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDI",
        "When set to 1, mutes IH_ FC_STAT0[7]",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_MUTE_FC_STAT1.
static const field_t hw_hdmi_ih_mute_fc_stat1[] =
{
    {
        "GCP",
        "When set to 1, mutes IH_ FC_STAT1[0]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVI",
        "When set to 1, mutes IH_ FC_STAT1[1]",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MPEG",
        "When set to 1, mutes IH_ FC_STAT1[2]",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPD",
        "When set to 1, mutes IH_ FC_STAT1[3]",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSD",
        "When set to 1, mutes IH_ FC_STAT1[4]",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR2",
        "When set to 1, mutes IH_ FC_STAT1[5]",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR1",
        "When set to 1, mutes IH_ FC_STAT1[6]",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GMD",
        "When set to 1, mutes IH_ FC_STAT1[7]",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_MUTE_FC_STAT2.
static const field_t hw_hdmi_ih_mute_fc_stat2[] =
{
    {
        "HIGHPRIORITY_OVERFLOW",
        "When set to 1, mutes IH_ FC_STAT2[0]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOWPRIORITY_OVERFLOW",
        "When set to 1, mutes IH_ FC_STAT2[1]",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_MUTE_AS_STAT0.
static const field_t hw_hdmi_ih_mute_as_stat0[] =
{
    {
        "AUD_FIFO_OVERFLOW",
        "When set to 1, mutes IH_ AS_STAT0[0]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUD_FIFO_UNDERFLOW",
        "When set to 1, mutes IH_ AS_STAT0[1]",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUD_FIFO_UNDERFLOW_THR",
        "When set to 1, mutes IH_ AS_STAT0[2]",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_MUTE_PHY_STAT0.
static const field_t hw_hdmi_ih_mute_phy_stat0[] =
{
    {
        "HDP",
        "When set to 1, mutes IH_ PHY_STAT0[0]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TX_PHY_LOCK",
        "When set to 1, mutes IH_ PHY_STAT0[1]",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE",
        "When set to 1, mutes IH_ PHY_STAT0[2]",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE1",
        "When set to 1, mutes IH_ PHY_STAT0[3]",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE2",
        "When set to 1, mutes IH_ PHY_STAT0[4]",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE3",
        "When set to 1, mutes IH_ PHY_STAT0[5]",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_MUTE_I2CM_STAT0.
static const field_t hw_hdmi_ih_mute_i2cm_stat0[] =
{
    {
        "I2CMASTER_ERROR",
        "When set to 1, mutes IH_ I2CM_STAT0[0]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "I2CMASTERDONE",
        "When set to 1, mutes IH_ I2CM_STAT0[1]",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_MUTE_CEC_STAT0.
static const field_t hw_hdmi_ih_mute_cec_stat0[] =
{
    {
        "DONE",
        "When set to 1, mutes IH_ CEC_STAT0[0]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOM",
        "When set to 1, mutes IH_ CEC_STAT0[1]",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK",
        "When set to 1, mutes IH_ CEC_STAT0[2]",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARB_LOST",
        "When set to 1, mutes IH_ CEC_STAT0[3]",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_INITIATOR",
        "When set to 1, mutes IH_ CEC_STAT0[4]",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_FOLLOW",
        "When set to 1, mutes IH_ CEC_STAT0[5]",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP",
        "When set to 1, mutes IH_ CEC_STAT0[6]",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_MUTE_VP_STAT0.
static const field_t hw_hdmi_ih_mute_vp_stat0[] =
{
    {
        "FIFOEMPTYBYP",
        "When set to 1, mutes IH_ VP_STAT0[0]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOFULLBYP",
        "When set to 1, mutes IH_ VP_STAT0[1]",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOEMPTYREMAP",
        "When set to 1, mutes IH_ VP_STAT0[2]",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOFULLREMAP",
        "When set to 1, mutes IH_ VP_STAT0[3]",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOEMPTYPP",
        "When set to 1, mutes IH_ VP_STAT0[4]",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOFULLPP",
        "When set to 1, mutes IH_ VP_STAT0[5]",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOEMPTYREPET",
        "When set to 1, mutes IH_ VP_STAT0[6]",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFOFULLREPET",
        "When set to 1, mutes IH_ VP_STAT0[7]",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_MUTE_I2CMPHY_STAT0.
static const field_t hw_hdmi_ih_mute_i2cmphy_stat0[] =
{
    {
        "I2CMPHYERROR",
        "When set to 1, mutes IH_ I2CMPHY_STAT0[0]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "I2CMPHYDONE",
        "When set to 1, mutes IH_ I2CMPHY_STAT0[1]",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_MUTE_AHBDMAAUD_STAT0.
static const field_t hw_hdmi_ih_mute_ahbdmaaud_stat0[] =
{
    {
        "AHBDMAAUD_INTBUFFEMPTY",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[0]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTBUFFFULL",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[1]",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTDONE",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[2]",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTRETRYSPLIT",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[3]",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTLOSTOWNERSHIP",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[4]",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTERROR",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[5]",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_IH_MUTE.
static const field_t hw_hdmi_ih_mute[] =
{
    {
        "AHBDMAAUD_INTBUFFEMPTY",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[0]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTBUFFFULL",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[1]",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTDONE",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[2]",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTRETRYSPLIT",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[3]",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTLOSTOWNERSHIP",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[4]",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHBDMAAUD_INTERROR",
        "When set to 1, mutes IH_AHBDMAAUD_STAT0[5]",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_TX_INVID0.
static const field_t hw_hdmi_tx_invid0[] =
{
    {
        "VIDEO_MAPPING",
        "video_mapping",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTERNAL_DE_GENERATOR",
        "Internal data enable (DE) generator enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_TX_INSTUFFING.
static const field_t hw_hdmi_tx_instuffing[] =
{
    {
        "GYDATA_STUFFING",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCRDATA_STUFFING",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCBDATA_STUFFING",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_TX_GYDATA0.
static const field_t hw_hdmi_tx_gydata0[] =
{
    {
        "GYDATA",
        "gydata[7:0].This register defines the value of gydata[7:0] when TX_INS"
        "TUFFING[0] (gydata_stuffing) is set to 1b.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_TX_GYDATA1.
static const field_t hw_hdmi_tx_gydata1[] =
{
    {
        "GYDATA",
        "gydata[15:8].This register defines the value of gydata[15:8] when TX_I"
        "NSTUFFING[0] (gydata_stuffing) is set to 1b.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_TX_RCRDATA0.
static const field_t hw_hdmi_tx_rcrdata0[] =
{
    {
        "RCRDATA",
        "rcrdata[7:0].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_TX_RCRDATA1.
static const field_t hw_hdmi_tx_rcrdata1[] =
{
    {
        "RCRDATA",
        "rcrdata[15:8].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_TX_BCBDATA0.
static const field_t hw_hdmi_tx_bcbdata0[] =
{
    {
        "BCBDATA",
        "bcbdata[7:0].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_TX_BCBDATA1.
static const field_t hw_hdmi_tx_bcbdata1[] =
{
    {
        "BCBDATA",
        "bcbdata[15:8].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_VP_STATUS.
static const field_t hw_hdmi_vp_status[] =
{
    {
        "PACKING_PHASE",
        "Read only register that holds the \"packing phase\" output by the Vide"
        "o packetizer block.",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_VP_PR_CD.
static const field_t hw_hdmi_vp_pr_cd[] =
{
    {
        "DESIRED_PR_FACTOR",
        "Desired pixel repetition factor configuration.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COLOR_DEPTH",
        "Color depth configuration:  other Reserved.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_VP_STUFF.
static const field_t hw_hdmi_vp_stuff[] =
{
    {
        "PR_STUFFING",
        "Pixel repeater stuffing control",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PP_STUFFING",
        "Pixel packing stuffing control",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "YCC422_STUFFING",
        "YCC 422 remap stuffing control.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICX_GOTO_P0_ST",
        "Reserved.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IFIX_PP_TO_LAST",
        "Reserved.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDEFAULT_PHASE",
        "Controls the default phase packing machine used according to: \"If the"
        " transmitted video format has timing such that the phase of the first "
        "pixel of every Video Data Period corresponds to pixel packing phase 0 "
        "(for example, 10P0, 12P0, 16P0), the Source may set the Default_Phase "
        "bit in the GCP.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_VP_REMAP.
static const field_t hw_hdmi_vp_remap[] =
{
    {
        "YCC422_SIZE",
        "YCC 422 remap input video size:",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_VP_CONF.
static const field_t hw_hdmi_vp_conf[] =
{
    {
        "OUTPUT_SELECTOR",
        "Video packetizer output selection.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_SELECT",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "YCC422_EN",
        "YCC 422 select enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PR_EN",
        "Pixel repeater enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PP_EN",
        "Pixel packing enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_EN",
        "Bypass enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_VP_STAT.
static const field_t hw_hdmi_vp_stat[] =
{
    {
        "OSTEMPTYBYP",
        "Video packetizer 8-bit bypass FIFO empty status.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSTFULLBYP",
        "Video packetizer 8-bit bypass FIFO full status.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSTEMPTYREMAP",
        "Video packetizer pixel YCC 422 re-mapper FIFO empty status.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSTFULLREMAP",
        "Video packetizer pixel YCC 422 re-mapper FIFO full status.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSTEMPTYPP",
        "Video packetizer pixel packing FIFO empty status.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSTFULLPP",
        "Video packetizer pixel packing FIFO full status.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSTEMPTYREPET",
        "Video packetizer pixel repeater FIFO empty status.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSTFULLREPET",
        "Video packetizer pixel repeater FIFO full status.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_VP_INT.
static const field_t hw_hdmi_vp_int[] =
{
    {
        "OINTEMPTYBYP",
        "Video packetizer 8-bit bypass FIFO empty status.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OINTFULLBYP",
        "Video packetizer 8-bit bypass FIFO full status.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OINTEMPTYREMAP",
        "Video packetizer pixel YCC 422 re-mapper FIFO empty status.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OINTFULLREMAP",
        "Video packetizer pixel YCC 422 re-mapper FIFO full status.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OINTEMPTYPP",
        "Video packetizer pixel packing FIFO empty status",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OINTFULLPP",
        "Video packetizer pixel packing FIFO full status",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OINTEMPTYREPET",
        "Video packetizer pixel repeater FIFO empty status",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OINTFULLREPET",
        "Video packetizer pixel repeater FIFO full status",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_VP_MASK.
static const field_t hw_hdmi_vp_mask[] =
{
    {
        "VPMASK",
        "Mask bit for VP_INT[0] interrupt bit.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPMASK1",
        "Mask bit for VP_INT[1] interrupt bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPMASK2",
        "Mask bit for VP_INT[2] interrupt bit.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPMASK3",
        "Mask bit for VP_INT[3] interrupt bit.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPMASK4",
        "Mask bit for VP_INT[4] interrupt bit.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPMASK5",
        "Mask bit for VP_INT[5] interrupt bit.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPMASK6",
        "Mask bit for VP_INT[6] interrupt bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPMASK7",
        "Mask bit for VP_INT[7] interrupt bit.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_VP_POL.
static const field_t hw_hdmi_vp_pol[] =
{
    {
        "VPPOL",
        "Polarity bit for VP_INT[0] interrupt bit.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPPOL1",
        "Polarity bit for VP_INT[1] interrupt bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPPOL2",
        "Polarity bit for VP_INT[2] interrupt bit.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPPOL3",
        "Polarity bit for VP_INT[3] interrupt bit.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPPOL4",
        "Polarity bit for VP_INT[4] interrupt bit.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPPOL5",
        "Polarity bit for VP_INT[5] interrupt bit.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPPOL6",
        "Polarity bit for VP_INT[6] interrupt bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPPOL7",
        "Polarity bit for VP_INT[7] interrupt bit.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INHACTIV0.
static const field_t hw_hdmi_fc_inhactiv0[] =
{
    {
        "H_IN_ACTIV",
        "Input video Horizontal active pixel region width.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INHACTIV1.
static const field_t hw_hdmi_fc_inhactiv1[] =
{
    {
        "H_IN_ACTIV",
        "Input video Horizontal active pixel region width.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INHBLANK0.
static const field_t hw_hdmi_fc_inhblank0[] =
{
    {
        "H_IN_BLANK",
        "Input video Horizontal blanking pixel region width.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INHBLANK1.
static const field_t hw_hdmi_fc_inhblank1[] =
{
    {
        "H_IN_BLANK",
        "Input video Horizontal blanking pixel region width.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INVACTIV0.
static const field_t hw_hdmi_fc_invactiv0[] =
{
    {
        "V_IN_ACTIV",
        "Input video Vertical active pixel region width.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INVACTIV1.
static const field_t hw_hdmi_fc_invactiv1[] =
{
    {
        "V_IN_ACTIV",
        "Input video Vertical active pixel region width.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INVBLANK.
static const field_t hw_hdmi_fc_invblank[] =
{
    {
        "V_IN_BLANK",
        "Input video Vertical blanking pixel region width.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_HSYNCINDELAY0.
static const field_t hw_hdmi_fc_hsyncindelay0[] =
{
    {
        "H_IN_DELAY",
        "Input video Hsync active edge delay.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_HSYNCINDELAY1.
static const field_t hw_hdmi_fc_hsyncindelay1[] =
{
    {
        "H_IN_DELAY",
        "Input video Hsync active edge delay.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_HSYNCINWIDTH0.
static const field_t hw_hdmi_fc_hsyncinwidth0[] =
{
    {
        "H_IN_WIDTH",
        "Input video Hsync active pulse width.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_HSYNCINWIDTH1.
static const field_t hw_hdmi_fc_hsyncinwidth1[] =
{
    {
        "H_IN_WIDTH",
        "Input video Hsync active pulse width.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSYNCINDELAY.
static const field_t hw_hdmi_fc_vsyncindelay[] =
{
    {
        "V_IN_DELAY",
        "Input video Vsync active edge delay.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSYNCINWIDTH.
static const field_t hw_hdmi_fc_vsyncinwidth[] =
{
    {
        "V_IN_WIDTH",
        "Value after Reset: 000000b  Input video Vsync active pulse width: Inte"
        "ger number of pixel clock cycles [0...63].",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INFREQ0.
static const field_t hw_hdmi_fc_infreq0[] =
{
    {
        "INFREQ",
        "Video refresh rate in Hz*1E3 format.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INFREQ1.
static const field_t hw_hdmi_fc_infreq1[] =
{
    {
        "INFREQ",
        "Video refresh rate in Hz*1E3 format.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INFREQ2.
static const field_t hw_hdmi_fc_infreq2[] =
{
    {
        "INFREQ",
        "Video refresh rate in Hz*1E3 format.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_CTRLDUR.
static const field_t hw_hdmi_fc_ctrldur[] =
{
    {
        "CTRLPERIODDURATION",
        "Configuration of the control period minimum duration (min.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_EXCTRLDUR.
static const field_t hw_hdmi_fc_exctrldur[] =
{
    {
        "EXCTRLPERIODDURATION",
        "Configuration of the extended control period minimum duration (min.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_EXCTRLSPAC.
static const field_t hw_hdmi_fc_exctrlspac[] =
{
    {
        "EXCTRLPERIODSPACING",
        "Configuration of the maximum spacing between consecutive extended cont"
        "rol periods (max of 50msec, see HDMI 1.4a specification):  generated s"
        "pacing = (1/freq tmds clock)*256*256*extctrlperiodspacing",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_CH0PREAM.
static const field_t hw_hdmi_fc_ch0pream[] =
{
    {
        "CH0_PREAMBLE_FILTER",
        "When in control mode, configures 8-bits that are going to fill the cha"
        "nnel 0 data lines not used to transmit the preamble (for more clarific"
        "ations refer to HDMI 1.4a specification).",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_CH1PREAM.
static const field_t hw_hdmi_fc_ch1pream[] =
{
    {
        "CH1_PREAMBLE_FILTER",
        "When in control mode, configures 6-bits that are going to fill the cha"
        "nnel 1 data lines not used to transmit the preamble (for more clarific"
        "ations refer to HDMI 1.4a specification).",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_CH2PREAM.
static const field_t hw_hdmi_fc_ch2pream[] =
{
    {
        "CH2_PREAMBLE_FILTER",
        "When in control mode, configures 6-bits that are going to fill the cha"
        "nnel 2 data lines not used to transmit the preamble (for more clarific"
        "ations, see HDMI 1.4a specification).",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVICONF3.
static const field_t hw_hdmi_fc_aviconf3[] =
{
    {
        "CN1",
        "IT content type according to CEA specification",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "YQ1",
        "Quantization range according to CEA specification.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GCP.
static const field_t hw_hdmi_fc_gcp[] =
{
    {
        "CLEAR_AVMUTE",
        "Value of \"clear_avmute\" in the GCP packet.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SET_AVMUTE",
        "Value of \"set_avmute\" in the GCP packet.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEFAULT_PHASE",
        "Value of \"default_phase\" in the GCP packet.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVICONF0.
static const field_t hw_hdmi_fc_aviconf0[] =
{
    {
        "FC_AVICONF0",
        "RGB/YCC indication  Value after Reset: 0b",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FC_AVICONF01",
        "Bar information",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FC_AVICONF02",
        "Scan information",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FC_AVICONF03",
        "Active format present",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FC_AVICONF04",
        "",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVICONF1.
static const field_t hw_hdmi_fc_aviconf1[] =
{
    {
        "FC_AVICONF1",
        "Active aspect ratio  Value after Reset: 0b",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FC_AVICONF11",
        "Picture aspect ratio",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FC_AVICONF0",
        "Colorimetry",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVICONF2.
static const field_t hw_hdmi_fc_aviconf2[] =
{
    {
        "FC_AVICONF2",
        "Non-uniform picture scaling  Value after Reset: 0b",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FC_AVICONF21",
        "Extended colorimetry",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FC_AVICONF22",
        "IT content",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVIVID.
static const field_t hw_hdmi_fc_avivid[] =
{
    {
        "FC_AVIVID",
        "the AVI infoFrame Video Identification code.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVIETB0.
static const field_t hw_hdmi_fc_avietb0[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVIETB1.
static const field_t hw_hdmi_fc_avietb1[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVISBB0.
static const field_t hw_hdmi_fc_avisbb0[] =
{
    {
        "FC_AVISBB0",
        "Line number of Start of Bottom Bar (lower 8 bits)",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVISBB1.
static const field_t hw_hdmi_fc_avisbb1[] =
{
    {
        "FC_AVISBB1",
        "Line number of Start of Bottom Bar (upper 8 bits)",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVIELB0.
static const field_t hw_hdmi_fc_avielb0[] =
{
    {
        "FC_AVIELB0",
        "Pixel number of end of left Bar (lower 8 bits)",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVIELB1.
static const field_t hw_hdmi_fc_avielb1[] =
{
    {
        "FC_AVIELB1",
        "Pixel number of end of left Bar (lower 8 bits)",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVISRB0.
static const field_t hw_hdmi_fc_avisrb0[] =
{
    {
        "FC_AVISRB0",
        "Pixel number of start of right Bar (lower 8 bits)",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AVISRB1.
static const field_t hw_hdmi_fc_avisrb1[] =
{
    {
        "FC_AVISRB1",
        "Pixel number of start of right Bar (upper 8 bits)",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AUDICONF0.
static const field_t hw_hdmi_fc_audiconf0[] =
{
    {
        "CT",
        "Coding Type",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CC",
        "Channel count",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AUDICONF1.
static const field_t hw_hdmi_fc_audiconf1[] =
{
    {
        "SF",
        "Sampling frequency",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SS",
        "Sampling size",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AUDICONF2.
static const field_t hw_hdmi_fc_audiconf2[] =
{
    {
        "CA",
        "Channel allocation",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AUDICONF3.
static const field_t hw_hdmi_fc_audiconf3[] =
{
    {
        "LSV",
        "Level shift value (for down mixing)",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DM_INH",
        "Down mix enable",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LFEPBL",
        "LFE playback information",
        5, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDIEEEID0.
static const field_t hw_hdmi_fc_vsdieeeid0[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDSIZE.
static const field_t hw_hdmi_fc_vsdsize[] =
{
    {
        "VSDSIZE",
        "Packet size as described in HDMI Vendor Specific InfoFrame (from HDMI "
        "specification).",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDIEEEID1.
static const field_t hw_hdmi_fc_vsdieeeid1[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDIEEEID2.
static const field_t hw_hdmi_fc_vsdieeeid2[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD0.
static const field_t hw_hdmi_fc_vsdpayload0[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD1.
static const field_t hw_hdmi_fc_vsdpayload1[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD2.
static const field_t hw_hdmi_fc_vsdpayload2[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD3.
static const field_t hw_hdmi_fc_vsdpayload3[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD4.
static const field_t hw_hdmi_fc_vsdpayload4[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD5.
static const field_t hw_hdmi_fc_vsdpayload5[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD6.
static const field_t hw_hdmi_fc_vsdpayload6[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD7.
static const field_t hw_hdmi_fc_vsdpayload7[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD8.
static const field_t hw_hdmi_fc_vsdpayload8[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD9.
static const field_t hw_hdmi_fc_vsdpayload9[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD10.
static const field_t hw_hdmi_fc_vsdpayload10[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD11.
static const field_t hw_hdmi_fc_vsdpayload11[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD12.
static const field_t hw_hdmi_fc_vsdpayload12[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD13.
static const field_t hw_hdmi_fc_vsdpayload13[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD14.
static const field_t hw_hdmi_fc_vsdpayload14[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD15.
static const field_t hw_hdmi_fc_vsdpayload15[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD16.
static const field_t hw_hdmi_fc_vsdpayload16[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD17.
static const field_t hw_hdmi_fc_vsdpayload17[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD18.
static const field_t hw_hdmi_fc_vsdpayload18[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD19.
static const field_t hw_hdmi_fc_vsdpayload19[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD20.
static const field_t hw_hdmi_fc_vsdpayload20[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD21.
static const field_t hw_hdmi_fc_vsdpayload21[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD22.
static const field_t hw_hdmi_fc_vsdpayload22[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_VSDPAYLOAD23.
static const field_t hw_hdmi_fc_vsdpayload23[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_SPDVENDORNAME0.
static const field_t hw_hdmi_fc_spdvendorname0[] =
{
    {
        "VENDOR_NAME",
        "Vendor name",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_SPDPRODUCTNAME0.
static const field_t hw_hdmi_fc_spdproductname0[] =
{
    {
        "PRODUCT_NAME",
        "Product name",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_SPDDEVICEINF.
static const field_t hw_hdmi_fc_spddeviceinf[] =
{
    {
        "PRODUCT_DESCRIPTOR",
        "Product descriptor",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AUDSCONF.
static const field_t hw_hdmi_fc_audsconf[] =
{
    {
        "AUD_PACKET_LAYOUT",
        "Set the audio packet layout to be sent in the packet:",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUD_PACKET_SAMPFIT",
        "Set the audio packet sample flat value to be sent on the packet.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_AUDSSTAT.
static const field_t hw_hdmi_fc_audsstat[] =
{
    {
        "PACKET_SAMPPRS",
        "Shows the data sample present indication of the last Audio sample pack"
        "et sent by the HDMI TX Controller.",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_CTRLQHIGH.
static const field_t hw_hdmi_fc_ctrlqhigh[] =
{
    {
        "ONHIGHATTENDED",
        "Configures the number of high priority packets or audio sample packets"
        " consecutively attended before checking low priority queue status.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_CTRLQLOW.
static const field_t hw_hdmi_fc_ctrlqlow[] =
{
    {
        "ONLOWATTENDED",
        "Configures the number of low priority packets or null packets consecut"
        "ively attended before checking high priority queue status or audio sam"
        "ple availability.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_ACP0.
static const field_t hw_hdmi_fc_acp0[] =
{
    {
        "ACPTYPE",
        "Configures the ACP packet type.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_ACP1.
static const field_t hw_hdmi_fc_acp1[] =
{
    {
        "AUDIO_CONTENTPACKET",
        "Audio content packet",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_ISCR1_0.
static const field_t hw_hdmi_fc_iscr1_0[] =
{
    {
        "ISRC_CONT",
        "Indication of ISRC2.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISRC_VALID",
        "Valid of ISRC1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISRC_STATUS",
        "Status of ISRC1.",
        2, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_ISCR1_1.
static const field_t hw_hdmi_fc_iscr1_1[] =
{
    {
        "ISRC1",
        "Configures the contents of the ISRC1 packet:",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_ISCR2_0.
static const field_t hw_hdmi_fc_iscr2_0[] =
{
    {
        "ISRC2",
        "Configures the contents of the ISRC1 packet:",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DATAUTO0.
static const field_t hw_hdmi_fc_datauto0[] =
{
    {
        "ACP_AUTO",
        "Enables ACP automatic packet scheduling",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR1_AUTO",
        "Enables ISRC1 automatic packet scheduling",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR2_AUTO",
        "Enables ISRC2 automatic packet scheduling",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSD_AUTO",
        "Enables VSD automatic packet scheduling",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPD_AUTO",
        "Enables SPD automatic packet scheduling",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DATAUTO1.
static const field_t hw_hdmi_fc_datauto1[] =
{
    {
        "AUTO_FRAME_INTERPOLATION",
        "Packet frame interpolation, for automatic packet scheduling",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DATAUTO2.
static const field_t hw_hdmi_fc_datauto2[] =
{
    {
        "AUTO_LINE_SPACING",
        "Packets line spacing, for automatic packet scheduling",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUTO_FRAME_PACKETS",
        "Packets per frame, for automatic packet scheduling",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DATMAN.
static const field_t hw_hdmi_fc_datman[] =
{
    {
        "ACP_TX",
        "ACP packet",
        0, // LSB
        0, // MSB
        false, // Readable
        true // Writable
    },
    {
        "ISR1_TX",
        "ISRC1 packet",
        1, // LSB
        1, // MSB
        false, // Readable
        true // Writable
    },
    {
        "ISCR2_TX",
        "ISRC2 packet",
        2, // LSB
        2, // MSB
        false, // Readable
        true // Writable
    },
    {
        "VSD_TX",
        "VSD packet",
        3, // LSB
        3, // MSB
        false, // Readable
        true // Writable
    },
    {
        "SPD_TX",
        "SPD packet",
        4, // LSB
        4, // MSB
        false, // Readable
        true // Writable
    },
    {
        "NULL_TX",
        "Null packet",
        5, // LSB
        5, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DATAUTO3.
static const field_t hw_hdmi_fc_datauto3[] =
{
    {
        "ACR_AUTO",
        "Enable ACR packet insertion",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDI_AUTO",
        "Enable AUDI packet insertion",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GCP_AUTO",
        "Enable GCP packet insertion",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVI_AUTO",
        "Enable AVI packet insertion",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_RDRB0.
static const field_t hw_hdmi_fc_rdrb0[] =
{
    {
        "ACRFRAMEINTERPOLATION",
        "ACR frame interpolation",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_RDRB1.
static const field_t hw_hdmi_fc_rdrb1[] =
{
    {
        "ACRPACKETLINESPACING",
        "ACR packet line spacing",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACRPACKETSINFRAME",
        "ACR packets in frame",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_RDRB2.
static const field_t hw_hdmi_fc_rdrb2[] =
{
    {
        "AUDIFRAMEINTERPOLATION",
        "Audio frame interpolation",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_RDRB3.
static const field_t hw_hdmi_fc_rdrb3[] =
{
    {
        "AUDIPACKETLINESPACING",
        "Audio packets line spacing",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIPACKETSINFRAME",
        "Audio packets per frame",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_RDRB4.
static const field_t hw_hdmi_fc_rdrb4[] =
{
    {
        "GCPFRAMEINTERPOLATION",
        "GCP packets line spacing",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_RDRB5.
static const field_t hw_hdmi_fc_rdrb5[] =
{
    {
        "GCPPACKETLINESPACING",
        "GCP packets line spacing",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GCPPACKETSINFRAME",
        "GCP packets per frame",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_RDRB6.
static const field_t hw_hdmi_fc_rdrb6[] =
{
    {
        "AVIFRAMEINTERPOLATION",
        "GCP packets line spacing",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_RDRB7.
static const field_t hw_hdmi_fc_rdrb7[] =
{
    {
        "AVIPACKETLINESPACING",
        "AVI packets line spacing",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVIPACKETSINFRAME",
        "AVI packets per frame",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_STAT0.
static const field_t hw_hdmi_fc_stat0[] =
{
    {
        "NULL_",
        "Status bit  Active after successful transmission of an Null packet.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ACR",
        "Status bit  Active after successful transmission of an Audio Clock Reg"
        "eneration (N/CTS transmission) packet.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDS",
        "Status bit  Active after successful transmission of an Audio Sample pa"
        "cket.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HBR",
        "Status bit.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ACP",
        "Status bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDI",
        "Status bit  Active after successful transmission of an Audio InfoFrame"
        " packet.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INT0.
static const field_t hw_hdmi_fc_int0[] =
{
    {
        "NULL_",
        "Interrupt indication bit  Active after successful transmission of an N"
        "ull packet interrupt.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACR",
        "Interrupt indication bit  Active after successful transmission of an A"
        "udio Clock Regeneration (N/CTS transmission) packet interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDS",
        "Interrupt indication bit  Active after successful transmission of an A"
        "udio Sample packet interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HBR",
        "Interrupt indication bit  Active after successful transmission of a Au"
        "dio HBR packet interrupt.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACP",
        "Interrupt indication bit  Active after successful transmission of an A"
        "udio Content Protection packet interrupt.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDI",
        "Interrupt indication bit  Active after successful transmission of an A"
        "udio InfoFrame packet interrupt.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_MASK0.
static const field_t hw_hdmi_fc_mask0[] =
{
    {
        "NULL_",
        "Mask bit for FC_INT0.NULL interrupt bit  Value after Reset: 0b",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACR",
        "Mask bit for FC_INT0.ACR interrupt bit  Value after Reset: 0b",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDS",
        "Mask bit for FC_INT0.AUDS interrupt bit  Value after Reset: 0b",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HBR",
        "Mask bit for FC_INT0.HBR interrupt bit  Value after Reset: 0b",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACP",
        "Mask bit for FC_INT0.ACP interrupt bit  Value after Reset: 0b",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDI",
        "Mask bit for FC_INT0.AUDI interrupt bit  Value after Reset: 0b",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_POL0.
static const field_t hw_hdmi_fc_pol0[] =
{
    {
        "NULL_",
        "Polarity bit for FC_INT0.NULL interrupt bit  Value after Reset: 0b",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACR",
        "Polarity bit for FC_INT0.ACR interrupt bit  Value after Reset: 0b",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDS",
        "Polarity bit for FC_INT0.AUDS interrupt bit  Value after Reset: 0b",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HBR",
        "Polarity bit for FC_INT0.HBR interrupt bit  Value after Reset: 0b",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACP",
        "Polarity bit for FC_INT0.ACP interrupt bit  Value after Reset: 0b",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDI",
        "Polarity bit for FC_INT0.AUDI interrupt bit  Value after Reset: 0b",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_STAT1.
static const field_t hw_hdmi_fc_stat1[] =
{
    {
        "GCP",
        "Status bit  Active after successful transmission of an General Content"
        " Packet.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVI",
        "Status bit  Active after successful transmission of an AVI infoFrame p"
        "acket.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPD",
        "Active after successful transmission of an Source Product Descriptor i"
        "nfoFrame packet.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSD",
        "Active after successful transmission of an Vendor Specific Data infoFr"
        "ame packet.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR2",
        "Active after successful transmission of an International Standard Reco"
        "rding Code 2 packet.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR1",
        "Status bit  Active after successful transmission of an International S"
        "tandard Recording Code 1 packet.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GMD",
        "Status bit  Active after successful transmission of an Gamut metadata "
        "packet.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INT1.
static const field_t hw_hdmi_fc_int1[] =
{
    {
        "GCP",
        "Interrupt indication bit  Active after successful transmission of an G"
        "eneral Content Packet interrupt.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVI",
        "Interrupt indication bit  Active after successful transmission of an A"
        "VI infoFrame packet interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPD",
        "Interrupt indication bit  Active after successful transmission of an S"
        "ource Product Descriptor infoFrame packet interrupt.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSD",
        "Interrupt indication bit  Active after successful transmission of an V"
        "endor Specific Data infoFrame packet interrupt.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR2",
        "Interrupt indication bit  Active after successful transmission of an I"
        "nternational Standard Recording  Code 2 packet interrupt.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR1",
        "Interrupt indication bit  Active after successful transmission of an I"
        "nternational Standard Recording  Code 1 packet interrupt.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GMD",
        "Interrupt indication bit  Active after successful transmission of an G"
        "amut metadata packet interrupt.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_MASK1.
static const field_t hw_hdmi_fc_mask1[] =
{
    {
        "GCP",
        "Mask bit for FC_INT1.GCP interrupt bit",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVI",
        "Mask bit for FC_INT1.AVI interrupt bit",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPD",
        "Mask bit for FC_INT1.SPD interrupt bit",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSD",
        "Mask bit for FC_INT1.VSD interrupt bit",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR2",
        "Mask bit for FC_INT1.ISRC2 interrupt bit",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR1",
        "Mask bit for FC_INT1.ISRC1 interrupt bit",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GMD",
        "Mask bit for FC_INT1.GMD interrupt bit",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_POL1.
static const field_t hw_hdmi_fc_pol1[] =
{
    {
        "GCP",
        "Polarity bit for FC_INT1.GCP interrupt bit",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVI",
        "Polarity bit for FC_INT1.AVI interrupt bit",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPD",
        "Polarity bit for FC_INT1.SPD interrupt bit",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSD",
        "Polarity bit for FC_INT1.VSD interrupt bit",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR2",
        "Polarity bit for FC_INT1.ISRC2 interrupt bit",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ISCR1",
        "Polarity bit for FC_INT1.ISRC1 interrupt bit",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GMD",
        "Polarity bit for FC_INT1.GMD interrupt bit",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_STAT2.
static const field_t hw_hdmi_fc_stat2[] =
{
    {
        "HIGHPRIORITY_OVERFLOW",
        "Status bit  Frame Composer high priority packet queue descriptor overf"
        "low indication.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOWPRIORITY_OVERFLOW",
        "Status bit  Frame Composer low priority packet queue descriptor overfl"
        "ow indication.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_INT2.
static const field_t hw_hdmi_fc_int2[] =
{
    {
        "HIGHPRIORITY_OVERFLOW",
        "Interrupt indication bit  Frame Composer high priority packet queue de"
        "scriptor overflow indication interrupt.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOWPRIORITY_OVERFLOW",
        "Interrupt indication bit  Frame Composer low priority packet queue des"
        "criptor overflow indication interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_MASK2.
static const field_t hw_hdmi_fc_mask2[] =
{
    {
        "HIGHPRIORITY_OVERFLOW",
        "Mask bit for FC_INT1.HighPriority_overflow interrupt bit  Value after "
        "Reset: 0b",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOWPRIORITY_OVERFLOW",
        "Mask bit for FC_INT1.LowPriority_overflow interrupt bit  Value after R"
        "eset: 0b",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_POL2.
static const field_t hw_hdmi_fc_pol2[] =
{
    {
        "HIGHPRIORITY_OVERFLOW",
        "Polarity bit for FC_INT1.HighPriority_overflow interrupt bit  Value af"
        "ter Reset: 1b",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOWPRIORITY_OVERFLOW",
        "Polarity bit for FC_INT1.LowPriority_overflow interrupt bit  Value aft"
        "er Reset: 1b",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_PRCONF.
static const field_t hw_hdmi_fc_prconf[] =
{
    {
        "OUTPUT_PR_FACTOR",
        "Configures the video pixel repetition ratio to be sent on the AVI info"
        "Frame.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INCOMING_PR_FACTOR",
        "Configures the input video pixel repetition.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_STAT.
static const field_t hw_hdmi_fc_gmd_stat[] =
{
    {
        "IGMDCURRENT_GAMUT_SEQ_NUM",
        "Gamut scheduling: Current Gamut packet sequence number",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IGMDPACKET_SEQ",
        "Gamut scheduling: Gamut packet sequence",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IGMDDNEXT_FIELD",
        "Gamut scheduling: Gamut Next field",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IGMDNO_CRNT_GBD",
        "Gamut scheduling: No current gamut data",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_EN.
static const field_t hw_hdmi_fc_gmd_en[] =
{
    {
        "GMDENABLETX",
        "Gamut Metadata packet transmission enable (1b).",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_UP.
static const field_t hw_hdmi_fc_gmd_up[] =
{
    {
        "GMDUPDATEPACKET",
        "Gamut Metadata packet update.",
        0, // LSB
        0, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_CONF.
static const field_t hw_hdmi_fc_gmd_conf[] =
{
    {
        "GMDPACKETLINESPACING",
        "Number of line spacing between the transmitted GMD packets",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GMDPACKETSINFRAME",
        "Number of GMD packets per frame or video field (profile P0)",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_HB.
static const field_t hw_hdmi_fc_gmd_hb[] =
{
    {
        "GMDAFFECTED_GAMUT_SEQ_NUM",
        "Affected gamut sequence number",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GMDGBD_PROFILE",
        "GMD profile bits",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB0.
static const field_t hw_hdmi_fc_gmd_pb0[] =
{
    {
        "FC_GMD_PB0",
        "Gamut Metadata packet byte0",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB1.
static const field_t hw_hdmi_fc_gmd_pb1[] =
{
    {
        "FC_GMD_PB1",
        "Gamut Metadata packet byte1",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB2.
static const field_t hw_hdmi_fc_gmd_pb2[] =
{
    {
        "FC_GMD_PB2",
        "Gamut Metadata packet byte2",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB3.
static const field_t hw_hdmi_fc_gmd_pb3[] =
{
    {
        "FC_GMD_PB3",
        "Gamut Metadata packet byte3",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB4.
static const field_t hw_hdmi_fc_gmd_pb4[] =
{
    {
        "FC_GMD_PB4",
        "Gamut Metadata packet byte4",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB5.
static const field_t hw_hdmi_fc_gmd_pb5[] =
{
    {
        "FC_GMD_PB5",
        "Gamut Metadata packet byte5",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB6.
static const field_t hw_hdmi_fc_gmd_pb6[] =
{
    {
        "FC_GMD_PB6",
        "Gamut Metadata packet byte6",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB7.
static const field_t hw_hdmi_fc_gmd_pb7[] =
{
    {
        "FC_GMD_PB2",
        "Gamut Metadata packet byte7",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB8.
static const field_t hw_hdmi_fc_gmd_pb8[] =
{
    {
        "FC_GMD_PB8",
        "Gamut Metadata packet byte8",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB9.
static const field_t hw_hdmi_fc_gmd_pb9[] =
{
    {
        "FC_GMD_PB9",
        "Gamut Metadata packet byte9",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB10.
static const field_t hw_hdmi_fc_gmd_pb10[] =
{
    {
        "FC_GMD_PB10",
        "Gamut Metadata packet byte10",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB11.
static const field_t hw_hdmi_fc_gmd_pb11[] =
{
    {
        "FC_GMD_PB11",
        "Gamut Metadata packet byte11",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB12.
static const field_t hw_hdmi_fc_gmd_pb12[] =
{
    {
        "FC_GMD_PB12",
        "Gamut Metadata packet byte12",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB13.
static const field_t hw_hdmi_fc_gmd_pb13[] =
{
    {
        "FC_GMD_PB13",
        "Gamut Metadata packet byte13",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB14.
static const field_t hw_hdmi_fc_gmd_pb14[] =
{
    {
        "FC_GMD_PB14",
        "Gamut Metadata packet byte14",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB15.
static const field_t hw_hdmi_fc_gmd_pb15[] =
{
    {
        "FC_GMD_PB15",
        "Gamut Metadata packet byte15",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB16.
static const field_t hw_hdmi_fc_gmd_pb16[] =
{
    {
        "FC_GMD_PB16",
        "Gamut Metadata packet byte16",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB17.
static const field_t hw_hdmi_fc_gmd_pb17[] =
{
    {
        "FC_GMD_PB17",
        "Gamut Metadata packet byte17",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB18.
static const field_t hw_hdmi_fc_gmd_pb18[] =
{
    {
        "FC_GMD_PB18",
        "Gamut Metadata packet byte18",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB19.
static const field_t hw_hdmi_fc_gmd_pb19[] =
{
    {
        "FC_GMD_PB18",
        "Gamut Metadata packet byte18",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB20.
static const field_t hw_hdmi_fc_gmd_pb20[] =
{
    {
        "FC_GMD_PB20",
        "Gamut Metadata packet byte20",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB21.
static const field_t hw_hdmi_fc_gmd_pb21[] =
{
    {
        "FC_GMD_PB21",
        "Gamut Metadata packet byte21",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB22.
static const field_t hw_hdmi_fc_gmd_pb22[] =
{
    {
        "FC_GMD_PB22",
        "Gamut Metadata packet byte22",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB23.
static const field_t hw_hdmi_fc_gmd_pb23[] =
{
    {
        "FC_GMD_PB23",
        "Gamut Metadata packet byte23",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB24.
static const field_t hw_hdmi_fc_gmd_pb24[] =
{
    {
        "FC_GMD_PB24",
        "Gamut Metadata packet byte24",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB25.
static const field_t hw_hdmi_fc_gmd_pb25[] =
{
    {
        "FC_GMD_PB25",
        "Gamut Metadata packet byte25",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB26.
static const field_t hw_hdmi_fc_gmd_pb26[] =
{
    {
        "FC_GMD_PB26",
        "Gamut Metadata packet byte26",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_GMD_PB27.
static const field_t hw_hdmi_fc_gmd_pb27[] =
{
    {
        "FC_GMD_PB27",
        "Gamut Metadata packet byte27",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGFORCE.
static const field_t hw_hdmi_fc_dbgforce[] =
{
    {
        "FORCEVIDEO",
        "Force fixed video output with FC_DBGTMDSx registers contain.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FORCEAUDIO",
        "Force fixed audio output with FC_DBGAUDxCHx registers contain.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD0CH0.
static const field_t hw_hdmi_fc_dbgaud0ch0[] =
{
    {
        "FC_DBGAUD0CH0",
        "the audio fixed data byte0 to be used in channel 0 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD1CH0.
static const field_t hw_hdmi_fc_dbgaud1ch0[] =
{
    {
        "FC_DBGAUD1CH0",
        "the audio fixed data byte1 to be used in channel 0 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD2CH0.
static const field_t hw_hdmi_fc_dbgaud2ch0[] =
{
    {
        "FC_DBGAUD2CH0",
        "the audio fixed data byte2 to be used in channel 0 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD0CH1.
static const field_t hw_hdmi_fc_dbgaud0ch1[] =
{
    {
        "FC_DBGAUD0CH1",
        "the audio fixed data byte2 to be used in channel 0 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD1CH1.
static const field_t hw_hdmi_fc_dbgaud1ch1[] =
{
    {
        "FC_DBGAUD1CH1",
        "the audio fixed data byte1 to be used in channel 1 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD2CH1.
static const field_t hw_hdmi_fc_dbgaud2ch1[] =
{
    {
        "FC_DBGAUD2CH1",
        "the audio fixed data byte2 to be used in channel 1 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD0CH2.
static const field_t hw_hdmi_fc_dbgaud0ch2[] =
{
    {
        "FC_DBGAUD0CH2",
        "the audio fixed data byte0 to be used in channel 2 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD1CH2.
static const field_t hw_hdmi_fc_dbgaud1ch2[] =
{
    {
        "FC_DBGAUD1CH2",
        "the audio fixed data byte1 to be used in channel 2 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD2CH2.
static const field_t hw_hdmi_fc_dbgaud2ch2[] =
{
    {
        "FC_DBGAUD2CH2",
        "the audio fixed data byte2 to be used in channel 2 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD0CH3.
static const field_t hw_hdmi_fc_dbgaud0ch3[] =
{
    {
        "FC_DBGAUD0CH3",
        "the audio fixed data byte0 to be used in channel 3 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD1CH3.
static const field_t hw_hdmi_fc_dbgaud1ch3[] =
{
    {
        "FC_DBGAUD1CH3",
        "the audio fixed data byte1 to be used in channel 3 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD2CH3.
static const field_t hw_hdmi_fc_dbgaud2ch3[] =
{
    {
        "FC_DBGAUD2CH3",
        "the audio fixed data byte2 to be used in channel 3 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD0CH4.
static const field_t hw_hdmi_fc_dbgaud0ch4[] =
{
    {
        "FC_DBGAUD0CH4",
        "the audio fixed data byte0 to be used in channel 4 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD1CH4.
static const field_t hw_hdmi_fc_dbgaud1ch4[] =
{
    {
        "FC_DBGAUD1CH4",
        "the audio fixed data byte1 to be used in channel 4 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD2CH4.
static const field_t hw_hdmi_fc_dbgaud2ch4[] =
{
    {
        "FC_DBGAUD2CH4",
        "the audio fixed data byte2 to be used in channel 4 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD0CH5.
static const field_t hw_hdmi_fc_dbgaud0ch5[] =
{
    {
        "FC_DBGAUD0CH5",
        "the audio fixed data byte0 to be used in channel 5 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD1CH5.
static const field_t hw_hdmi_fc_dbgaud1ch5[] =
{
    {
        "FC_DBGAUD1CH5",
        "the audio fixed data byte1 to be used in channel 5 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD2CH5.
static const field_t hw_hdmi_fc_dbgaud2ch5[] =
{
    {
        "FC_DBGAUD2CH5",
        "the audio fixed data byte2 to be used in channel 5 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD0CH6.
static const field_t hw_hdmi_fc_dbgaud0ch6[] =
{
    {
        "FC_DBGAUD0CH6",
        "The audio fixed data byte0 to be used in channel 6 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD1CH6.
static const field_t hw_hdmi_fc_dbgaud1ch6[] =
{
    {
        "FC_DBGAUD1CH6",
        "the audio fixed data byte1 to be used in channel 6 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD2CH6.
static const field_t hw_hdmi_fc_dbgaud2ch6[] =
{
    {
        "FC_DBGAUD2CH6",
        "the audio fixed data byte2 to be used in channel 6 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD0CH7.
static const field_t hw_hdmi_fc_dbgaud0ch7[] =
{
    {
        "FC_DBGAUD0CH7",
        "the audio fixed data byte0 to be used in channel 7 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD1CH7.
static const field_t hw_hdmi_fc_dbgaud1ch7[] =
{
    {
        "FC_DBGAUD1CH7",
        "the audio fixed data byte1 to be used in channel 0 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGAUD2CH7.
static const field_t hw_hdmi_fc_dbgaud2ch7[] =
{
    {
        "FC_DBGAUD2CH7",
        "the audio fixed data byte2 to be used in channel 0 when in fixed audio"
        " selection",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGTMDS0.
static const field_t hw_hdmi_fc_dbgtmds0[] =
{
    {
        "FC_DBGTMDS0",
        "set B pixel component value in RGB video or Cb pixel component value i"
        "n YCbCr",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGTMDS1.
static const field_t hw_hdmi_fc_dbgtmds1[] =
{
    {
        "FC_DBGTMDS1",
        "set G pixel component value in RGB video or Y pixel component value in"
        " YCbCr",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_FC_DBGTMDS2.
static const field_t hw_hdmi_fc_dbgtmds2[] =
{
    {
        "FC_DBGTMDS2",
        "set R pixel component value in RGB video or Cr pixel component value i"
        "n YCbCr",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_CONF0.
static const field_t hw_hdmi_phy_conf0[] =
{
    {
        "SELDIPIF",
        "Select interface control.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SELDATAENPOL",
        "Select data enable polarity.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GEN2_ENHPDRXSENSE",
        "PHY_Gen2 ENHPDRXSENSE signal  Value after Reset: 1b",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GEN2_TXPWRON",
        "PHY_Gen2 TXPWRON signal  Value after Reset: 0b",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GEN2_PDDQ",
        "PHY_Gen2 PDDQ signal  Value after Reset: 0b",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPARECTRL",
        "Reserved.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENTMDS",
        "Enable TMDS drivers, bias, and TMDS digital logic.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PDZ",
        "Power-down enable (active low 0b).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_TST0.
static const field_t hw_hdmi_phy_tst0[] =
{
    {
        "TESTCLK",
        "Test clock signal.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TESTEN",
        "Reserved.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TESTCLR",
        "Enable TMDS drivers, bias and tmds digital logic.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_TST1.
static const field_t hw_hdmi_phy_tst1[] =
{
    {
        "TESTDIN",
        "Test data input.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_TST2.
static const field_t hw_hdmi_phy_tst2[] =
{
    {
        "TESTDOUT",
        "Test data output.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_STAT0.
static const field_t hw_hdmi_phy_stat0[] =
{
    {
        "TX_PHY_LOCK",
        "Status bit.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HPD",
        "Status bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_SENSE",
        "Status bit.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_SENSE1",
        "Status bit.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_SENSE2",
        "Status bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_SENSE3",
        "Status bit.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_INT0.
static const field_t hw_hdmi_phy_int0[] =
{
    {
        "TX_PHY_LOCK",
        "Interrupt indication bit  TX PHY PLL lock indication interrupt.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HPD",
        "Interrupt indication bit  HDMI Hot Plug Detect indication interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_SENSE",
        "Interrupt indication bit  TX PHY RX_SENSE indication interrupt for TMD"
        "S channel 0 driver.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_SENSE1",
        "Interrupt indication bit  TX PHY RX_SENSE indication interrupt for TMD"
        "S channel 1 driver.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_SENSE2",
        "Interrupt indication bit  TX PHY RX_SENSE indication interrupt for TMD"
        "S channel 2 driver.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_SENSE3",
        "Interrupt indication bit  TX PHY RX_SENSE indication interrupt for TMD"
        "S CLK driver.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_MASK0.
static const field_t hw_hdmi_phy_mask0[] =
{
    {
        "TX_PHY_LOCK",
        "Mask bit for PHY_INT0.TX_PHY_LOCK interrupt bit",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPD",
        "Mask bit for PHY_INT0.HPD interrupt bit",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE",
        "Mask bit for PHY_INT0.RX_SENSE[0] interrupt bit",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE1",
        "Mask bit for PHY_INT0.RX_SENSE[1] interrupt bit",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE2",
        "Mask bit for PHY_INT0.RX_SENSE[2] interrupt bit",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE3",
        "Mask bit for PHY_INT0.RX_SENSE[3] interrupt bit",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_POL0.
static const field_t hw_hdmi_phy_pol0[] =
{
    {
        "TX_PHY_LOCK",
        "Polarity bit for PHY_INT0.TX_PHY_LOCK interrupt bit",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HPD",
        "Polarity bit for PHY_INT0.HPD interrupt bit",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE",
        "Polarity bit for PHY_INT0.RX_SENSE[0] interrupt bit",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE1",
        "Polarity bit for PHY_INT0.RX_SENSE[1] interrupt bit",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE2",
        "Polarity bit for PHY_INT0.RX_SENSE[2] interrupt bit",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_SENSE3",
        "Polarity bit for PHY_INT0.RX_SENSE[3] interrupt bit",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_SLAVE_ADDR.
static const field_t hw_hdmi_phy_i2cm_slave_addr[] =
{
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_ADDRESS_ADDR.
static const field_t hw_hdmi_phy_i2cm_address_addr[] =
{
    {
        "ADDRESS",
        "Register address for read and write operations.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_DATAO_1_ADDR.
static const field_t hw_hdmi_phy_i2cm_datao_1_addr[] =
{
    {
        "DATAO",
        "MSB's of data to be written on register pointed by address [7:0].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_DATAO_0_ADDR.
static const field_t hw_hdmi_phy_i2cm_datao_0_addr[] =
{
    {
        "DATAO",
        "LSB's of data to be written on register pointed by address [7:0].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_DATAI_1_ADDR.
static const field_t hw_hdmi_phy_i2cm_datai_1_addr[] =
{
    {
        "DATAI",
        "MSB's of data read from the register pointed by address [7:0].",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_DATAI_0_ADDR.
static const field_t hw_hdmi_phy_i2cm_datai_0_addr[] =
{
    {
        "DATAI",
        "LSB's of data read from the register pointed by address [7:0].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_OPERATION_ADDR.
static const field_t hw_hdmi_phy_i2cm_operation_addr[] =
{
    {
        "READ",
        "Read operation request.",
        0, // LSB
        0, // MSB
        false, // Readable
        true // Writable
    },
    {
        "WRITE",
        "Write operation request",
        4, // LSB
        4, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_INT_ADDR.
static const field_t hw_hdmi_phy_i2cm_int_addr[] =
{
    {
        "DONE_STATUS",
        "Operation done status bit.Marks the end of a rd or write operation.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE_INTERRUPT",
        "Operation done interrupt bit.{done_interrupt =(done_mask==0b)&& (done_"
        "status==done_pol)}.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE_MASK",
        "Done interrupt mask signal  Value after Reset: 0b",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE_POL",
        "Done interrupt polarity configuration  Value after Reset: 1b",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_CTLINT_ADDR.
static const field_t hw_hdmi_phy_i2cm_ctlint_addr[] =
{
    {
        "ARBITRATION_STATUS",
        "Arbitration error status bit.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARBITRATION_INTERRUPT",
        "Arbitration error interrupt bit.{arbitration_interrupt = (arbitration_"
        "mask==0b)&& (arbitration_status==arbitration_pol)}.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARBITRATION_MASK",
        "Arbitration error interrupt mask signal.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARBITRATION_POL",
        "Arbitration error interrupt polarity configuration.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK_STATUS",
        "Not acknowledge error status bit.Error on I2C not acknowledge.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK_INTERRUPT",
        "Not acknowledge error interrupt bit.{nack_interrupt = nack_mask==0b) &"
        "& (nack_status==nack_pol)}.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK_MASK",
        "Not acknowledge error interrupt mask signal  Value after Reset: 0b",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK_POL",
        "Not acknowledge error interrupt polarity configuration.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_DIV_ADDR.
static const field_t hw_hdmi_phy_i2cm_div_addr[] =
{
    {
        "FAST_MODE",
        "Sets the I2C Master to work in Fast Mode or Standard Mode  (x implies "
        "that it can take any value)  Value after Reset: 1011b  1xxxb Fast Mode"
        "  0xxxb Standard Mode",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_SOFTRSTZ_ADDR.
static const field_t hw_hdmi_phy_i2cm_softrstz_addr[] =
{
    {
        "I2C_SOFTRST",
        "I2C Master PHY Software Reset.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR.
static const field_t hw_hdmi_phy_i2cm_ss_scl_hcnt_1_addr[] =
{
    {
        "I2CMP_SS_SCL_HCNT",
        "Value after Reset: 8'h00",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR.
static const field_t hw_hdmi_phy_i2cm_ss_scl_hcnt_0_addr[] =
{
    {
        "I2CMP_SS_SCL_HCNT",
        "Value after Reset: 8'h6C",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR.
static const field_t hw_hdmi_phy_i2cm_ss_scl_lcnt_1_addr[] =
{
    {
        "I2CMP_SS_SCL_LCNT",
        "Value after Reset: 8'h00",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR.
static const field_t hw_hdmi_phy_i2cm_ss_scl_lcnt_0_addr[] =
{
    {
        "I2CMP_SS_SCL_LCNT",
        "Value after Reset: 8'h7F",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR.
static const field_t hw_hdmi_phy_i2cm_fs_scl_hcnt_1_addr[] =
{
    {
        "I2CMP_FS_SCL_HCNT",
        "Value after Reset: 8'h00",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR.
static const field_t hw_hdmi_phy_i2cm_fs_scl_hcnt_0_addr[] =
{
    {
        "I2CMP_FS_SCL_HCNT",
        "Value after Reset: 8'h11",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR.
static const field_t hw_hdmi_phy_i2cm_fs_scl_lcnt_1_addr[] =
{
    {
        "I2CMP_FS_SCL_LCNT",
        "Value after Reset: 8'h00",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR.
static const field_t hw_hdmi_phy_i2cm_fs_scl_lcnt_0_addr[] =
{
    {
        "I2CMP_FS_SCL_LCNT",
        "Value after Reset: 8'h24",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AUD_N1.
static const field_t hw_hdmi_aud_n1[] =
{
    {
        "AUDN",
        "HDMI Audio Clock Regenerator N value",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AUD_N2.
static const field_t hw_hdmi_aud_n2[] =
{
    {
        "AUDN",
        "HDMI Audio Clock Regenerator N value",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AUD_N3.
static const field_t hw_hdmi_aud_n3[] =
{
    {
        "AUDN",
        "HDMI Audio Clock Regenerator N value",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AUD_CTS1.
static const field_t hw_hdmi_aud_cts1[] =
{
    {
        "AUDCTS",
        "HDMI Audio Clock Regenerator CTS calculated value.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AUD_CTS2.
static const field_t hw_hdmi_aud_cts2[] =
{
    {
        "AUDCTS",
        "HDMI Audio Clock Regenerator CTS calculated value.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AUD_CTS3.
static const field_t hw_hdmi_aud_cts3[] =
{
    {
        "AUDCTS",
        "HDMI Audio Clock Regenerator CTS calculated value.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_CONF0.
static const field_t hw_hdmi_ahb_dma_conf0[] =
{
    {
        "BURST_MODE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INCR_TYPE",
        "Forced size burst mode.",
        1, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_HLOCK",
        "Enable request of locked burst AHB mechanism.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HBR",
        "HBR packets enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SW_FIFO_RST",
        "This is the software reset bit for the audio and FIFOs clear.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_START.
static const field_t hw_hdmi_ahb_dma_start[] =
{
    {
        "DATA_BUFFER_READY",
        "Data buffer ready",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_STOP.
static const field_t hw_hdmi_ahb_dma_stop[] =
{
    {
        "STOP_DMA_TRANSACTION",
        "Stop DMA transaction",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_THRSLD.
static const field_t hw_hdmi_ahb_dma_thrsld[] =
{
    {
        "FIFO_THRESHOLD",
        "FIFO medium threshold occupation value",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_STRADDR0.
static const field_t hw_hdmi_ahb_dma_straddr0[] =
{
    {
        "INITIAL_ADDR",
        "Defines init_addr[7:0] for bits 7-0 to initiate DMA burst transactions",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_STRADDR1.
static const field_t hw_hdmi_ahb_dma_straddr1[] =
{
    {
        "INITIAL_ADDR",
        "Defines init_addr[15:8] for bits 7-0 to initiate DMA burst transaction"
        "s",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_STRADDR2.
static const field_t hw_hdmi_ahb_dma_straddr2[] =
{
    {
        "INITIAL_ADDR",
        "Defines init_addr[23:16] for bits 7-0 to initiate DMA burst transactio"
        "ns",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_STRADDR3.
static const field_t hw_hdmi_ahb_dma_straddr3[] =
{
    {
        "INITIAL_ADDR",
        "Defines init_addr[31:24] for bits 7-0 to initiate DMA burst transactio"
        "ns",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_STPADDR0.
static const field_t hw_hdmi_ahb_dma_stpaddr0[] =
{
    {
        "FINAL_ADDR",
        "Defines final_addr[7:0] for bits 7-0 to initiate DMA burst transaction"
        "s",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_STPADDR1.
static const field_t hw_hdmi_ahb_dma_stpaddr1[] =
{
    {
        "FINAL_ADDR",
        "Defines final_addr[15:8] for bits 7-0 to initiate DMA burst transactio"
        "ns",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_STPADDR2.
static const field_t hw_hdmi_ahb_dma_stpaddr2[] =
{
    {
        "FINAL_ADDR",
        "Defines final_addr[23:16] for bits 7-0 to initiate DMA burst transacti"
        "ons",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_STPADDR3.
static const field_t hw_hdmi_ahb_dma_stpaddr3[] =
{
    {
        "FINAL_ADDR",
        "Defines final_addr[31:24] for bits 7-0 to initiate DMA burst transacti"
        "ons",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_BSTADDR0.
static const field_t hw_hdmi_ahb_dma_bstaddr0[] =
{
    {
        "BURST_START",
        "Start address for the current burst operation",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_BSTADDR1.
static const field_t hw_hdmi_ahb_dma_bstaddr1[] =
{
    {
        "BURST_START",
        "Start address for the current burst operation",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_BSTADDR2.
static const field_t hw_hdmi_ahb_dma_bstaddr2[] =
{
    {
        "BURST_START",
        "Start address for the current burst operation",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_BSTADDR3.
static const field_t hw_hdmi_ahb_dma_bstaddr3[] =
{
    {
        "BURST_START",
        "Start address for the current burst operation",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_MBLENGTH0.
static const field_t hw_hdmi_ahb_dma_mblength0[] =
{
    {
        "MBURSTLENGTH",
        "Requested burst length",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_MBLENGTH1.
static const field_t hw_hdmi_ahb_dma_mblength1[] =
{
    {
        "MBURSTLENGTH",
        "Requested burst length",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MBURSTLENGTH1",
        "Requested burst length",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MBURSTLENGTH2",
        "Requested burst length",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_STAT.
static const field_t hw_hdmi_ahb_dma_stat[] =
{
    {
        "STATFIFOEMPTY",
        "Status of audio FIFO empty interrupt.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATFIFOFULL",
        "Status of audio FIFO full interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATTHRFIFOEMPTY",
        "Status of audio FIFO empty when audio FIFO has less than four samples.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATERROR",
        "Status of error interrupt.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATLOSTOWNERSHIP",
        "Status of master lost ownership when in burst transfer.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATRETRYSPLIT",
        "Status of retry/split interrupt.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATDONE",
        "Status of DMA end of operation interrupt.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_INT.
static const field_t hw_hdmi_ahb_dma_int[] =
{
    {
        "INTFIFOEMPTY",
        "Audio FIFO empty interrupt.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INTFIFOFULL",
        "Audio FIFO full interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INTTHRFIFOEMPTY",
        "Audio FIFO empty interrupt when audio FIFO has less than four samples.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INTERROR",
        "Error interrupt.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INTLOSTOWNERSHIP",
        "Master lost ownership interrupt when in burst transfer.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INTRETRYSPLIT",
        "Retry/split interrupt.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INTDONE",
        "DMA end of operation interrupt.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_MASK.
static const field_t hw_hdmi_ahb_dma_mask[] =
{
    {
        "FIFO_EMPTY_MASK",
        "Audio FIFO empty interrupt mask.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_FULL_MASK",
        "Audio FIFO full interrupt mask.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_THREMPTY_MASK",
        "Audio FIFO empty interrupt mask when audio FIFO has less than four sam"
        "ples.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_MASK",
        "Error interrupt mask.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOSTOWNERSHIP_MASK",
        "Master lost ownership interrupt mask when in burst transfer.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RETRYSPLIT_MASK",
        "Retry/split interrupt mask.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE_MASK",
        "DMA end of operation interrupt mask.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_POL.
static const field_t hw_hdmi_ahb_dma_pol[] =
{
    {
        "FIFO_EMPTY_POLARITY",
        "Audio FIFO empty interrupt mask.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_FULL_POLARITY",
        "Audio FIFO full interrupt mask.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIFO_THRFIFOEMPTY_POLARITY",
        "Audio FIFO empty interrupt mask when audio FIFO has less than four sam"
        "ples.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_POLARITY",
        "Error interrupt mask.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOSTOWNERSHIP_POLARITY",
        "Master lost ownership interrupt mask when in burst transfer.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RETRYSPLIT_POLARITY",
        "Retry/split interrupt mask.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE_POLARITY",
        "DMA end of operation interrupt mask.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_CONF1.
static const field_t hw_hdmi_ahb_dma_conf1[] =
{
    {
        "CH_IN_EN",
        "Channel 0 is always enabled.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH_IN_EN1",
        "Channel 1 is always enabled.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH_IN_EN2",
        "Channel 2 enable bit",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH_IN_EN3",
        "Channel 3 enable bit",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH_IN_EN4",
        "Channel 4 enable bit",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH_IN_EN5",
        "Channel 5 enable bit",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH_IN_EN6",
        "Channel 6 enable bit",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH_IN_EN7",
        "Channel 7 enable bit",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_BUFFSTAT.
static const field_t hw_hdmi_ahb_dma_buffstat[] =
{
    {
        "BUFF_EMPTY",
        "Buffer empty flag status",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUFF_FULL",
        "Buffer full flag status",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_BUFFINT.
static const field_t hw_hdmi_ahb_dma_buffint[] =
{
    {
        "INT_BUFF_EMPTY",
        "Buffer empty flag interrupt",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INT_BUFF_FULL",
        "Buffer full flag interrupt",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_BUFFMASK.
static const field_t hw_hdmi_ahb_dma_buffmask[] =
{
    {
        "INT_BUFF_EMPTY",
        "Buffer empty flag mask",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT_BUFF_FULL",
        "Buffer full flag mask",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_AHB_DMA_BUFFPOL.
static const field_t hw_hdmi_ahb_dma_buffpol[] =
{
    {
        "INT_BUFF_EMPTY",
        "Buffer empty flag polarity",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT_BUFF_FULL",
        "Buffer full flag polarity",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_MC_CLKDIS.
static const field_t hw_hdmi_mc_clkdis[] =
{
    {
        "PIXELCLK_DISABLE",
        "Pixel clock synchronous disable signal.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMDSCLK_DISABLE",
        "TMDS clock synchronous disable signal.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREPCLK_DISABLE",
        "Pixel Repetition clock synchronous disable signal.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDCLK_DISABLE",
        "Audio Sampler clock synchronous disable signal.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSCCLK_DISABLE",
        "Color Space Converter clock synchronous disable signal.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CECCLK_DISABLE",
        "CEC Engine clock synchronous disable signal.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HDCPCLK_DISABLE",
        "Reserved",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_MC_SWRSTZREQ.
static const field_t hw_hdmi_mc_swrstzreq[] =
{
    {
        "PIXELSWRST_REQ",
        "Pixel software reset request.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMDSSWRST_REQ",
        "TMDS software reset request.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREPSWRST_REQ",
        "Pixel Repetition clock synchronous disable signal.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CECSWRST_REQ",
        "CEC software reset request.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_MC_FLOWCTRL.
static const field_t hw_hdmi_mc_flowctrl[] =
{
    {
        "FEED_THROUGH_OFF",
        "Video path Feed Through enable bit:",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_MC_PHYRSTZ.
static const field_t hw_hdmi_mc_phyrstz[] =
{
    {
        "PHYRSTZ",
        "HDMI Source PHY active low reset control.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_MC_LOCKONCLOCK.
static const field_t hw_hdmi_mc_lockonclock[] =
{
    {
        "CECCLK",
        "CEC clock status.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREPCLK",
        "Pixel repetition clock status.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCLKTCLK",
        "TMDS clock status.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCLK",
        "Pixel clock status.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_MC_HEACPHY_RST.
static const field_t hw_hdmi_mc_heacphy_rst[] =
{
    {
        "HEACPHYRST",
        "HEAC PHY reset (active high)",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_CFG.
static const field_t hw_hdmi_csc_cfg[] =
{
    {
        "DECMODE",
        "Chroma decimation configuration: decmode[1:0] Chroma decimation 00 dec"
        "imation disabled 01 H d?",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTMODE",
        "Chroma interpolation configuration:  00 interpolation disabled  01 H u"
        " (z) = 1 + z -1   10 H u (z)=1/2 + Z -1 +1/2 z -2   11 interpolation d"
        "isabled.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_SCALE.
static const field_t hw_hdmi_csc_scale[] =
{
    {
        "CSC_COLORDE_PTH",
        "Color space converter color depth configuration:  Other: Reserved.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_A1_MSB.
static const field_t hw_hdmi_csc_coef_a1_msb[] =
{
    {
        "CSC_COEF_A1_MSB",
        "Color Space Conversion A1 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_A1_LSB.
static const field_t hw_hdmi_csc_coef_a1_lsb[] =
{
    {
        "CSC_COEF_A1_LSB",
        "Color Space Conversion A1 LSB coefficient",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_A2_MSB.
static const field_t hw_hdmi_csc_coef_a2_msb[] =
{
    {
        "CSC_COEF_A2_MSB",
        "Color Space Conversion A2 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_A2_LSB.
static const field_t hw_hdmi_csc_coef_a2_lsb[] =
{
    {
        "CSC_COEF_A2_LSB",
        "Color Space Conversion A2 LSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_A3_MSB.
static const field_t hw_hdmi_csc_coef_a3_msb[] =
{
    {
        "CSC_COEF_A3_MSB",
        "Color Space Conversion A3 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_A3_LSB.
static const field_t hw_hdmi_csc_coef_a3_lsb[] =
{
    {
        "CSC_COEF_A3_LSB",
        "Color Space Conversion A3 LSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_A4_MSB.
static const field_t hw_hdmi_csc_coef_a4_msb[] =
{
    {
        "CSC_COEF_A4_MSB",
        "Color Space Conversion A4 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_A4_LSB.
static const field_t hw_hdmi_csc_coef_a4_lsb[] =
{
    {
        "CSC_COEF_A4_LSB",
        "Color Space Conversion A4 LSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_B1_MSB.
static const field_t hw_hdmi_csc_coef_b1_msb[] =
{
    {
        "CSC_COEF_B1_MSB",
        "Color Space Conversion B1 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_B1_LSB.
static const field_t hw_hdmi_csc_coef_b1_lsb[] =
{
    {
        "CSC_COEF_B1_LSB",
        "Color Space Conversion B1 LSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_B2_MSB.
static const field_t hw_hdmi_csc_coef_b2_msb[] =
{
    {
        "CSC_COEF_B2_MSB",
        "Color Space Conversion B2 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_B2_LSB.
static const field_t hw_hdmi_csc_coef_b2_lsb[] =
{
    {
        "CSC_COEF_B2_LSB",
        "Color Space Conversion B2 LSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_B3_MSB.
static const field_t hw_hdmi_csc_coef_b3_msb[] =
{
    {
        "CSC_COEF_B3_MSB",
        "Color Space Conversion B3 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_B3_LSB.
static const field_t hw_hdmi_csc_coef_b3_lsb[] =
{
    {
        "CSC_COEF_B3_LSB",
        "Color Space Conversion B3 LSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_B4_MSB.
static const field_t hw_hdmi_csc_coef_b4_msb[] =
{
    {
        "CSC_COEF_B4_MSB",
        "Color Space Conversion B4 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_B4_LSB.
static const field_t hw_hdmi_csc_coef_b4_lsb[] =
{
    {
        "CSC_COEF_B4_LSB",
        "Color Space Conversion B4 LSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_C1_MSB.
static const field_t hw_hdmi_csc_coef_c1_msb[] =
{
    {
        "CSC_COEF_C1_MSB",
        "Color Space Conversion C1 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_C1_LSB.
static const field_t hw_hdmi_csc_coef_c1_lsb[] =
{
    {
        "CSC_COEF_C1_LSB",
        "Color Space Conversion C1 LSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_C2_MSB.
static const field_t hw_hdmi_csc_coef_c2_msb[] =
{
    {
        "CSC_COEF_C2_MSB",
        "Color Space Conversion C2 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_C2_LSB.
static const field_t hw_hdmi_csc_coef_c2_lsb[] =
{
    {
        "CSC_COEF_C2_LSB",
        "Color Space Conversion C2 LSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_C3_MSB.
static const field_t hw_hdmi_csc_coef_c3_msb[] =
{
    {
        "CSC_COEF_C3_MSB",
        "Color Space Conversion C3 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEF_C3_LSB.
static const field_t hw_hdmi_csc_coef_c3_lsb[] =
{
    {
        "CSC_COEF_C3_LSB",
        "Color Space Conversion C3 LSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEFC4_MSB.
static const field_t hw_hdmi_csc_coefc4_msb[] =
{
    {
        "CSC_COEFC4_MSB",
        "Color Space Conversion C4 MSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CSC_COEFC4_LSB.
static const field_t hw_hdmi_csc_coefc4_lsb[] =
{
    {
        "CSC_COEFC4_LSB",
        "Color Space Conversion C4 LSB coefficient.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_CTRL.
static const field_t hw_hdmi_cec_ctrl[] =
{
    {
        "SEND",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRAME_TYP",
        "",
        1, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BC_NACK",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STANDBY",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_STAT.
static const field_t hw_hdmi_cec_stat[] =
{
    {
        "DONE",
        "The current transmission is successful (for initiator only).",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "EOM",
        "EOM is detected so that the received data is ready in the receiver dat"
        "a buffer (for follower only).",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NACK",
        "A frame is not acknowledged in a directly addressed message.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ARB_LOST",
        "The initiator losses the CEC line arbitration to a second initiator.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ERROR_INIT",
        "An error is detected on cec line (for initiator only).",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ERROR_FOLL",
        "An error is notified by a follower.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAKEUP",
        "Follower received wake-up command (for follower only).",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_MASK.
static const field_t hw_hdmi_cec_mask[] =
{
    {
        "DONE_MASK",
        "The current transmission is successful (for initiator only).",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOM_MASK",
        "EOM is detected so that the received data is ready in the receiver dat"
        "a buffer (for follower only).",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK_MASK",
        "A frame is not acknowledged in a directly addressed message.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARB_LOST_MASK",
        "The initiator losses the CEC line arbitration to a second initiator.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_INIT_MASK",
        "An error is detected on cec line (for initiator only).",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_FOLL__MASK",
        "An error is notified by a follower.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP_MASK",
        "Follower wake-up signal mask",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_POLARITY.
static const field_t hw_hdmi_cec_polarity[] =
{
    {
        "DONE_POL",
        "Current transmission success or not signal polarity",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOM_POL",
        "EOM detect signal polarity (follower only)",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK_POL",
        "Frame NACK signal polarity",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARB_LOST_POL",
        "Initiator Arbitration lost signal polarity",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_INIT_POL",
        "CEC line error polarity (for initiator only)",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERROR_FOLL_POL",
        "CEC line error polarity (for follower only)",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP_POL",
        "Follower wakeup signal polarity",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_INT.
static const field_t hw_hdmi_cec_int[] =
{
    {
        "DONE_INT",
        "EOM detect interrupt (for follower only)",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "EOM_INT",
        "Frame NACK interrupt",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NACK_INT",
        "Initiator Arbitration lost interrupt",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ARB_LOST_INT",
        "CEC line error interrupt (for initiator only)",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ERROR_INIT_INT",
        "CEC line error interrupt (for follower only)",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ERROR_FOLL_INT",
        "Follower wakeup interrupt",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAKEUP_INT",
        "Follower wakeup signal polarity",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_ADDR_L.
static const field_t hw_hdmi_cec_addr_l[] =
{
    {
        "CEC_ADDR_L",
        "Logical address 0 - Device TV",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_L1",
        "Logical address 1 - Recording Device 1",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_L2",
        "Logical address 2 - Recording Device 2",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_L3",
        "Logical address 3 - Tuner 1",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_L4",
        "Logical address 4 - Playback Device 1",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_L5",
        "Logical address 5 - Audio System",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_L6",
        "Logical address 6 - Tuner 2",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_L7",
        "Logical address 7 - Tuner 3",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_ADDR_H.
static const field_t hw_hdmi_cec_addr_h[] =
{
    {
        "CEC_ADDR_H",
        "Logical address 8 - Playback Device 2",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_H1",
        "Logical address 9 - Playback Device 3",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_H2",
        "Logical address 10 - Tuner 4",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_H3",
        "Logical address 11 - Playback Device 3",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_H4",
        "Logical address 12 - Reserved",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_H5",
        "Logical address 13 - Reserved",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_H6",
        "Logical address 14 - Free use",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CEC_ADDR_H7",
        "Logical address 15 - Unregistered (as initiator address), Broadcast (a"
        "s destination address)",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_TX_CNT.
static const field_t hw_hdmi_cec_tx_cnt[] =
{
    {
        "CEC_TX_CNT",
        "CEC Transmitter Counter register:  Value after Reset: 5'b00000",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_RX_CNT.
static const field_t hw_hdmi_cec_rx_cnt[] =
{
    {
        "TX_DATA",
        "Header block in CEC_TX_DATA0  Data blockn in CEC_TX_DATAn",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_TX_DATAN.
static const field_t hw_hdmi_cec_tx_datan[] =
{
    {
        "RX_DATA",
        "Header block in CEC_RX_DATA0  Data blockn in CEC_RX_DATAn",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_RX_DATAN.
static const field_t hw_hdmi_cec_rx_datan[] =
{
    {
        "CEC_RX_CNT",
        "CEC Receiver Counter register  Value after Reset: 5'b00000",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_LOCK.
static const field_t hw_hdmi_cec_lock[] =
{
    {
        "LOCKED_BUFFER",
        "When a frame is received, this bit would be active.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_CEC_WKUPCTRL.
static const field_t hw_hdmi_cec_wkupctrl[] =
{
    {
        "OPCODE0X04EN",
        "OPCODE 0x04 wake up enable",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE0X0DEN",
        "OPCODE 0x0D wake up enable",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE0X41EN",
        "OPCODE 0x41 wake up enable",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE0X42EN",
        "OPCODE 0x42 wake up enable",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE0X44EN",
        "OPCODE 0x44 wake up enable",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE0X70EN",
        "OPCODE 0x70 wake up enable",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE0X82EN",
        "OPCODE 0x82 wake up enable",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE0X86EN",
        "OPCODE 0x86 wake up enable",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_SLAVE.
static const field_t hw_hdmi_i2cm_slave[] =
{
    {
        "SLAVEADDR",
        "Slave address to be sent during read and write normal operations.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_ADDRESS.
static const field_t hw_hdmi_i2cm_address[] =
{
    {
        "ADDRESS",
        "Register address for read and write operations.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_DATAO.
static const field_t hw_hdmi_i2cm_datao[] =
{
    {
        "DATAO",
        "Data to be written on register pointed by address[7:0].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_DATAI.
static const field_t hw_hdmi_i2cm_datai[] =
{
    {
        "DATAI",
        "Data read from register pointed by address[7:0].",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_OPERATION.
static const field_t hw_hdmi_i2cm_operation[] =
{
    {
        "RD",
        "Read operation request.",
        0, // LSB
        0, // MSB
        false, // Readable
        true // Writable
    },
    {
        "RD_EXT",
        "After writing 1'b1 to rd_ext bit a extended data read operation is sta"
        "rted (E- DDC read operation).",
        1, // LSB
        1, // MSB
        false, // Readable
        true // Writable
    },
    {
        "WR",
        "Write operation request.",
        4, // LSB
        4, // MSB
        false, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_INT.
static const field_t hw_hdmi_i2cm_int[] =
{
    {
        "DONE_STATUS",
        "Operation done status bit.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE_INTERRUPT",
        "Operation done interrupt bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE_MASK",
        "Done interrupt mask signal.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DONE_POL",
        "Done interrupt polarity configuration.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_CTLINT.
static const field_t hw_hdmi_i2cm_ctlint[] =
{
    {
        "ARBITRATION_STATUS",
        "Arbitration error status bit.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARBITRATION_INTERRUPT",
        "Arbitration error interrupt bit.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARBITRATION_MASK",
        "Arbitration error interrupt mask signal.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARBITRATION_POL",
        "Arbitration error interrupt polarity configuration.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK_STATUS",
        "Not acknowledge error status bit.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK_INTERRUPT",
        "Not acknowledge error interrupt bit.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK_MASK",
        "Not acknowledge error interrupt mask signal.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NACK_POL",
        "Not acknowledge error interrupt polarity configuration.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_DIV.
static const field_t hw_hdmi_i2cm_div[] =
{
    {
        "FAST_STD_MODE",
        "Sets the I2C Master to work in Fast Mode or Standard Mode:",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_SEGADDR.
static const field_t hw_hdmi_i2cm_segaddr[] =
{
    {
        "SEGADDR",
        "E-DDC Extended read segment address",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_SOFTRSTZ.
static const field_t hw_hdmi_i2cm_softrstz[] =
{
    {
        "I2C_SOFTRST",
        "I2C Master Software Reset.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_SEGPTR.
static const field_t hw_hdmi_i2cm_segptr[] =
{
    {
        "I2CM_SEGPTR",
        "I2CM_SEGPTR is used for EDID reading operations, particularly for the "
        "Extended Data Read Operation (See \") which is used for Enhanced DDC.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_SS_SCL_HCNT_1_ADDR.
static const field_t hw_hdmi_i2cm_ss_scl_hcnt_1_addr[] =
{
    {
        "I2CMP_SS_SCL_HCNT",
        "Value after Reset: 8'h00",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_SS_SCL_HCNT_0_ADDR.
static const field_t hw_hdmi_i2cm_ss_scl_hcnt_0_addr[] =
{
    {
        "I2CMP_SS_SCL_HCNT",
        "Value after Reset: 8'h6C",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_SS_SCL_LCNT_1_ADDR.
static const field_t hw_hdmi_i2cm_ss_scl_lcnt_1_addr[] =
{
    {
        "I2CMP_SS_SCL_LCNT",
        "Value after Reset: 8'h00",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_SS_SCL_LCNT_0_ADDR.
static const field_t hw_hdmi_i2cm_ss_scl_lcnt_0_addr[] =
{
    {
        "I2CMP_SS_SCL_LCNT",
        "Value after Reset: 8'h7F",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_FS_SCL_HCNT_1_ADDR.
static const field_t hw_hdmi_i2cm_fs_scl_hcnt_1_addr[] =
{
    {
        "I2CMP_FS_SCL_HCNT",
        "Value after Reset: 8'h00",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_FS_SCL_HCNT_0_ADDR.
static const field_t hw_hdmi_i2cm_fs_scl_hcnt_0_addr[] =
{
    {
        "I2CMP_FS_SCL_HCNT",
        "Value after Reset: 8'h11",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_FS_SCL_LCNT_1_ADDR.
static const field_t hw_hdmi_i2cm_fs_scl_lcnt_1_addr[] =
{
    {
        "I2CMP_FS_SCL_LCNT",
        "Value after Reset: 8'h00",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_I2CM_FS_SCL_LCNT_0_ADDR.
static const field_t hw_hdmi_i2cm_fs_scl_lcnt_0_addr[] =
{
    {
        "I2CMP_FS_SCL_LCNT",
        "Value after Reset: 8'h24",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register HDMI_BASE_POINTER_ADDR.
static const field_t hw_hdmi_base_pointer_addr[] =
{
    {
        "BASE_POINTER_BASE_ADDR",
        "Defines the base address for base pointer operation mode.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_BASE_POINTER_ADDR",
        "Enables the base pointer operation mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a HDMI module.
static const reg_t hw_hdmi[] =
{
    {
        "DESIGN_ID",
        "The following are the registers used to identify the HDMI TX controlle"
        "r.",
        1, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_design_id
    },
    {
        "REVISION_ID",
        "Name: Revision Identification Register  Address Offset: 0x0001  Size: "
        "8 bits  Value after Reset: Implementation Dependent  Access: Read",
        1, // Width in bytes
        0x00000001, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_revision_id
    },
    {
        "PRODUCT_ID0",
        "Name: Product Identification Register 0  Address Offset: 0x0002  Size:"
        " 8 bits  Value after Reset: Implementation Dependent  Access: Read",
        1, // Width in bytes
        0x00000002, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_product_id0
    },
    {
        "PRODUCT_ID1",
        "Name: Product Identification Register 1  Address Offset: 0x0003  Size:"
        " 8 bits  Value after Reset: Implementation Dependent  Access: Read",
        1, // Width in bytes
        0x00000003, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_product_id1
    },
    {
        "CONFIG0_ID",
        "Name: Configuration Identification Register 0  Address Offset: 0x0004 "
        " Size: 8 bits  Value after Reset: Implementation Dependent  Access: Re"
        "ad",
        1, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_hdmi_config0_id
    },
    {
        "CONFIG1_ID",
        "Name: Configuration Identification Register 1  Address Offset: 0x0005 "
        " Size: 8 bits  Value after Reset: Implementation Dependent  Access: Re"
        "ad",
        1, // Width in bytes
        0x00000005, // Base address offset
        true, // Readable
        false, // Writable
        5, // Number of bitfields
        hw_hdmi_config1_id
    },
    {
        "CONFIG2_ID",
        "Name: Configuration Identification Register 2  Address Offset: 0x0006 "
        " Size: 8 bits  Value after Reset: Implementation Dependent  Access: Re"
        "ad",
        1, // Width in bytes
        0x00000006, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_config2_id
    },
    {
        "CONFIG3_ID",
        "Name: Configuration Identification Register 3  Address Offset: 0x0007 "
        " Size: 8 bits  Value after Reset: Implementation Dependent  Access: Re"
        "ad",
        1, // Width in bytes
        0x00000007, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_config3_id
    },
    {
        "IH_FC_STAT0",
        "This section describes clear on write (1 to corresponding bit) status "
        "registers, which contain the following active-high, sticky bit interru"
        "pts.",
        1, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_ih_fc_stat0
    },
    {
        "IH_FC_STAT1",
        "Address Offset: 0x0101  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Clear on Write",
        1, // Width in bytes
        0x00000101, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_ih_fc_stat1
    },
    {
        "IH_FC_STAT2",
        "Address Offset: 0x0102  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Clear on Write",
        1, // Width in bytes
        0x00000102, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_ih_fc_stat2
    },
    {
        "IH_AS_STAT0",
        "Address Offset: 0x0103  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Clear on Write",
        1, // Width in bytes
        0x00000103, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_hdmi_ih_as_stat0
    },
    {
        "IH_PHY_STAT0",
        "Address Offset: 0x0104  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Clear on Write/Read",
        1, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_ih_phy_stat0
    },
    {
        "IH_I2CM_STAT0",
        "Address Offset: 0x0105  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Clear on Write/Read",
        1, // Width in bytes
        0x00000105, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_ih_i2cm_stat0
    },
    {
        "IH_CEC_STAT0",
        "Address Offset: 0x0106  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Clear on Write",
        1, // Width in bytes
        0x00000106, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_hdmi_ih_cec_stat0
    },
    {
        "IH_VP_STAT0",
        "Address Offset: 0x0107  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Clear on Write",
        1, // Width in bytes
        0x00000107, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_ih_vp_stat0
    },
    {
        "IH_I2CMPHY_STAT0",
        "This clear on write (1 to corresponding bit) register contains the fol"
        "lowing active high sticky bit interrupts.",
        1, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_ih_i2cmphy_stat0
    },
    {
        "IH_AHBDMAAUD_STAT0",
        "Address Offset: 0x0109  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Clear on Write",
        1, // Width in bytes
        0x00000109, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_ih_ahbdmaaud_stat0
    },
    {
        "IH_MUTE_FC_STAT0",
        "Address Offset: 0x0180  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_ih_mute_fc_stat0
    },
    {
        "IH_MUTE_FC_STAT1",
        "Address Offset: 0x0181  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000181, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_ih_mute_fc_stat1
    },
    {
        "IH_MUTE_FC_STAT2",
        "Address Offset: 0x0182  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000182, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_ih_mute_fc_stat2
    },
    {
        "IH_MUTE_AS_STAT0",
        "Address Offset: 0x0183  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000183, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_hdmi_ih_mute_as_stat0
    },
    {
        "IH_MUTE_PHY_STAT0",
        "Address Offset: 0x0184  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000184, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_ih_mute_phy_stat0
    },
    {
        "IH_MUTE_I2CM_STAT0",
        "Address Offset: 0x0185  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000185, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_ih_mute_i2cm_stat0
    },
    {
        "IH_MUTE_CEC_STAT0",
        "Address Offset: 0x0186  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000186, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_hdmi_ih_mute_cec_stat0
    },
    {
        "IH_MUTE_VP_STAT0",
        "Address Offset: 0x0187  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000187, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_ih_mute_vp_stat0
    },
    {
        "IH_MUTE_I2CMPHY_STAT0",
        "Address Offset: 0x0188  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000188, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_ih_mute_i2cmphy_stat0
    },
    {
        "IH_MUTE_AHBDMAAUD_STAT0",
        "Address Offset: 0x0189  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000189, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_ih_mute_ahbdmaaud_stat0
    },
    {
        "IH_MUTE",
        "Address Offset: 0x01FF  Size: 8 bits  Value after Reset: 0x03  Access:"
        " Read/Write",
        1, // Width in bytes
        0x000001ff, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_ih_mute
    },
    {
        "TX_INVID0",
        "This registers contains the input video mapping code as defined in Tab"
        "le 2-1.",
        1, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_tx_invid0
    },
    {
        "TX_INSTUFFING",
        "This register enables the stuffing mechanism of the Video Sampler modu"
        "le in order to correctly perform Color Space Conversion of the ITU.601"
        " standard YCC video.",
        1, // Width in bytes
        0x00000201, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_hdmi_tx_instuffing
    },
    {
        "TX_GYDATA0",
        "Address Offset: 0x0202  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000202, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_tx_gydata0
    },
    {
        "TX_GYDATA1",
        "Address Offset: 0x0203  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000203, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_tx_gydata1
    },
    {
        "TX_RCRDATA0",
        "Address Offset: 0x0204  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000204, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_tx_rcrdata0
    },
    {
        "TX_RCRDATA1",
        "Address Offset: 0x0205  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000205, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_tx_rcrdata1
    },
    {
        "TX_BCBDATA0",
        "Address Offset: 0x0206  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000206, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_tx_bcbdata0
    },
    {
        "TX_BCBDATA1",
        "Address Offset: 0x0207  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00000207, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_tx_bcbdata1
    },
    {
        "VP_STATUS",
        "Address Offset: 0x0800  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read",
        1, // Width in bytes
        0x00000800, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_vp_status
    },
    {
        "VP_PR_CD",
        "This register configures the Color Depth of the input video and Pixel "
        "repetition to apply to video.",
        1, // Width in bytes
        0x00000801, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_vp_pr_cd
    },
    {
        "VP_STUFF",
        "This register controls the Pixel repetition, pixel packing and YCC422 "
        "stuffing.",
        1, // Width in bytes
        0x00000802, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_vp_stuff
    },
    {
        "VP_REMAP",
        "This register controls YCC422 remap of the Video Packetizer.",
        1, // Width in bytes
        0x00000803, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_vp_remap
    },
    {
        "VP_CONF",
        "This register controls the Video Packetizer output selection, bypass s"
        "elect, YCC422 enable, Pixel repeater, and pixel packing enabling.",
        1, // Width in bytes
        0x00000804, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_vp_conf
    },
    {
        "VP_STAT",
        "This register contains the following active high FIFO status indicatio"
        "ns:   Address Offset: 0x0805  Size: 8 bits  Value after Reset: 0x00  A"
        "ccess: Read",
        1, // Width in bytes
        0x00000805, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_hdmi_vp_stat
    },
    {
        "VP_INT",
        "This register contains the interrupt indication of the VP_STAT status "
        "interrupts.",
        1, // Width in bytes
        0x00000806, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_hdmi_vp_int
    },
    {
        "VP_MASK",
        "Mask register for generation of VP_INT interrupts.",
        1, // Width in bytes
        0x00000807, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_vp_mask
    },
    {
        "VP_POL",
        "Polarity register for generation of VP_INT interrupts.",
        1, // Width in bytes
        0x00000808, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_vp_pol
    },
    {
        "FC_INHACTIV0",
        "Address Offset: 0x1001  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001001, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_inhactiv0
    },
    {
        "FC_INHACTIV1",
        "Address Offset: 0x1002  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001002, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_inhactiv1
    },
    {
        "FC_INHBLANK0",
        "Address Offset: 0x1003  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001003, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_inhblank0
    },
    {
        "FC_INHBLANK1",
        "Address Offset: 0x1004  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_inhblank1
    },
    {
        "FC_INVACTIV0",
        "Address Offset: 0x1005  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001005, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_invactiv0
    },
    {
        "FC_INVACTIV1",
        "Address Offset: 0x1006  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001006, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_invactiv1
    },
    {
        "FC_INVBLANK",
        "Address Offset: 0x1007  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001007, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_invblank
    },
    {
        "FC_HSYNCINDELAY0",
        "Address Offset: 0x1008  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_hsyncindelay0
    },
    {
        "FC_HSYNCINDELAY1",
        "Address Offset: 0x1009  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001009, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_hsyncindelay1
    },
    {
        "FC_HSYNCINWIDTH0",
        "Address Offset: 0x100A  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000100a, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_hsyncinwidth0
    },
    {
        "FC_HSYNCINWIDTH1",
        "Address Offset: 0x100B  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000100b, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_hsyncinwidth1
    },
    {
        "FC_VSYNCINDELAY",
        "Address Offset: 0x100C  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000100c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_vsyncindelay
    },
    {
        "FC_VSYNCINWIDTH",
        "Address Offset: 0x100D  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000100d, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_vsyncinwidth
    },
    {
        "FC_INFREQ0",
        "Address Offset: 0x100E  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000100e, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_infreq0
    },
    {
        "FC_INFREQ1",
        "Address Offset: 0x100F  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000100f, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_infreq1
    },
    {
        "FC_INFREQ2",
        "Address Offset: 0x1010  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_infreq2
    },
    {
        "FC_CTRLDUR",
        "Address Offset: 0x1011  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001011, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_ctrldur
    },
    {
        "FC_EXCTRLDUR",
        "Address Offset: 0x1012  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001012, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_exctrldur
    },
    {
        "FC_EXCTRLSPAC",
        "Address Offset: 0x1013  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001013, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_exctrlspac
    },
    {
        "FC_CH0PREAM",
        "Address Offset: 0x1014  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_ch0pream
    },
    {
        "FC_CH1PREAM",
        "Address Offset: 0x1015  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001015, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_ch1pream
    },
    {
        "FC_CH2PREAM",
        "Address Offset: 0x1016  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001016, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_ch2pream
    },
    {
        "FC_AVICONF3",
        "Address Offset: 0x1017  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write   configuration of Quantization range and IT content type.",
        1, // Width in bytes
        0x00001017, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_aviconf3
    },
    {
        "FC_GCP",
        "Configures the General Control Packet A/V mute indicators and the defa"
        "ult phase.",
        1, // Width in bytes
        0x00001018, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_hdmi_fc_gcp
    },
    {
        "FC_AVICONF0",
        "Configures the following contents of the AVI infoFrame:   RGB/YCC indi"
        "cation  Bar information  Scan information  Active format present  Prog"
        "ressive/Interlaced indicator  Active aspect ratio  Picture aspect rati"
        "o  Colorimetry  IT content  Extended colorimetry  Quantization range  "
        "Non-uniform picture scaling   For more information, refer to HDMI 1.4a"
        " and CEA - 861D specifications.",
        1, // Width in bytes
        0x00001019, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_hdmi_fc_aviconf0
    },
    {
        "FC_AVICONF1",
        "Address Offset: 0x101A  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000101a, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_hdmi_fc_aviconf1
    },
    {
        "FC_AVICONF2",
        "Address Offset: 0x101B  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000101b, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_hdmi_fc_aviconf2
    },
    {
        "FC_AVIVID",
        "Configures the AVI infoFrame Video Identification code.",
        1, // Width in bytes
        0x0000101c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_avivid
    },
    {
        "FC_AVIETB0",
        "These registers define the AVI infoFrame End of Top Bar value.",
        1, // Width in bytes
        0x0000101d, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_avietb0
    },
    {
        "FC_AVIETB1",
        "Address Offset: 0x101E  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000101e, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_avietb1
    },
    {
        "FC_AVISBB0",
        "These registers define the AVI infoFrame Start of Bottom Bar value.",
        1, // Width in bytes
        0x0000101f, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_avisbb0
    },
    {
        "FC_AVISBB1",
        "Address Offset: 0x1020  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001020, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_avisbb1
    },
    {
        "FC_AVIELB0",
        "These registers define the AVI infoFrame End of Left Bar value.",
        1, // Width in bytes
        0x00001021, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_avielb0
    },
    {
        "FC_AVIELB1",
        "Address Offset: 0x1022  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001022, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_avielb1
    },
    {
        "FC_AVISRB0",
        "These registers define the AVI infoFrame Start of Right Bar value.",
        1, // Width in bytes
        0x00001023, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_avisrb0
    },
    {
        "FC_AVISRB1",
        "Address Offset: 0x1024  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001024, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_avisrb1
    },
    {
        "FC_AUDICONF0",
        "These registers configure the following contents of the AUDIO infoFram"
        "e:   Coding type  Channel count  Sampling frequency  Sampling size  Ch"
        "annel allocation  Audio level shift value  Down mix enable   For more "
        "information, refer to CEA-861D specification.",
        1, // Width in bytes
        0x00001025, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_audiconf0
    },
    {
        "FC_AUDICONF1",
        "",
        1, // Width in bytes
        0x00001026, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_audiconf1
    },
    {
        "FC_AUDICONF2",
        "",
        1, // Width in bytes
        0x00001027, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_audiconf2
    },
    {
        "FC_AUDICONF3",
        "",
        1, // Width in bytes
        0x00001028, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_hdmi_fc_audiconf3
    },
    {
        "FC_VSDIEEEID0",
        "These registers configure the Vendor Specific infoFrame IEEE registrat"
        "ion identifier.",
        1, // Width in bytes
        0x00001029, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdieeeid0
    },
    {
        "FC_VSDSIZE",
        "Address Offset: 0x102A  Size: 8 bits  Value after Reset: 0x1B  Access:"
        " Read/Write   configuration of Packet size.",
        1, // Width in bytes
        0x0000102a, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_vsdsize
    },
    {
        "FC_VSDIEEEID1",
        "Address Offset: 0x102a  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001030, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdieeeid1
    },
    {
        "FC_VSDIEEEID2",
        "Address Offset: 0x102b  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001031, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdieeeid2
    },
    {
        "FC_VSDPAYLOAD0",
        "These registers configure the Vendor Specific infoFrame 24 bytes speci"
        "fic payload.",
        1, // Width in bytes
        0x00001032, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload0
    },
    {
        "FC_VSDPAYLOAD1",
        "Address Offset: 0x1033  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001033, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload1
    },
    {
        "FC_VSDPAYLOAD2",
        "Address Offset: 0x1034  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001034, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload2
    },
    {
        "FC_VSDPAYLOAD3",
        "Address Offset: 0x1035  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001035, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload3
    },
    {
        "FC_VSDPAYLOAD4",
        "Address Offset: 0x1036  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001036, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload4
    },
    {
        "FC_VSDPAYLOAD5",
        "Address Offset: 0x1037  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001037, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload5
    },
    {
        "FC_VSDPAYLOAD6",
        "Address Offset: 0x1038  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001038, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload6
    },
    {
        "FC_VSDPAYLOAD7",
        "Address Offset: 0x1039  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001039, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload7
    },
    {
        "FC_VSDPAYLOAD8",
        "Address Offset: 0x103a  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000103a, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload8
    },
    {
        "FC_VSDPAYLOAD9",
        "Address Offset: 0x103b  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000103b, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload9
    },
    {
        "FC_VSDPAYLOAD10",
        "Address Offset: 0x103c  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000103c, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload10
    },
    {
        "FC_VSDPAYLOAD11",
        "Address Offset: 0x103d  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000103d, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload11
    },
    {
        "FC_VSDPAYLOAD12",
        "Address Offset: 0x103e  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000103e, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload12
    },
    {
        "FC_VSDPAYLOAD13",
        "Address Offset: 0x103f  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000103f, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload13
    },
    {
        "FC_VSDPAYLOAD14",
        "Address Offset: 0x1040  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001040, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload14
    },
    {
        "FC_VSDPAYLOAD15",
        "Address Offset: 0x1041  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001041, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload15
    },
    {
        "FC_VSDPAYLOAD16",
        "Address Offset: 0x1042  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001042, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload16
    },
    {
        "FC_VSDPAYLOAD17",
        "Address Offset: 0x1043  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001043, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload17
    },
    {
        "FC_VSDPAYLOAD18",
        "Address Offset: 0x1044  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001044, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload18
    },
    {
        "FC_VSDPAYLOAD19",
        "Address Offset: 0x1045  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001045, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload19
    },
    {
        "FC_VSDPAYLOAD20",
        "Address Offset: 0x1046  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001046, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload20
    },
    {
        "FC_VSDPAYLOAD21",
        "Address Offset: 0x1047  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001047, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload21
    },
    {
        "FC_VSDPAYLOAD22",
        "Address Offset: 0x1048  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001048, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload22
    },
    {
        "FC_VSDPAYLOAD23",
        "Address Offset: 0x1049  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001049, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_fc_vsdpayload23
    },
    {
        "FC_SPDVENDORNAME0",
        "These registers configure the Source Product Descriptor infoFrame 8 by"
        "tes Vendor name.",
        1, // Width in bytes
        0x0000104a, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_spdvendorname0
    },
    {
        "FC_SPDPRODUCTNAME0",
        "These registers configure the Source Product Descriptor infoFrame 16 b"
        "ytes Product name.",
        1, // Width in bytes
        0x00001052, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_spdproductname0
    },
    {
        "FC_SPDDEVICEINF",
        "This register configures Source Product Descriptor infoFrame descripti"
        "on device field.",
        1, // Width in bytes
        0x00001062, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_spddeviceinf
    },
    {
        "FC_AUDSCONF",
        "Configures the Audio sample packet sample flat and layout configuratio"
        "n.",
        1, // Width in bytes
        0x00001063, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_audsconf
    },
    {
        "FC_AUDSSTAT",
        "Shows the data sample present indication of the last Audio sample pack"
        "et sent by the HDMI TX Controller.",
        1, // Width in bytes
        0x00001064, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_audsstat
    },
    {
        "FC_CTRLQHIGH",
        "Address Offset: 0x1073  Size: 8 bits  Value after Reset: 0x0F  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001073, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_ctrlqhigh
    },
    {
        "FC_CTRLQLOW",
        "Address Offset: 0x1074  Size: 8 bits  Value after Reset: 0x03  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001074, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_ctrlqlow
    },
    {
        "FC_ACP0",
        "Configures the following contents of the ACP packet.",
        1, // Width in bytes
        0x00001075, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_acp0
    },
    {
        "FC_ACP1",
        "Configures the following contents of the Audio Content Packet (ACP) bo"
        "dy:   Address Offset: 0x1091 to 0x1082  Size: 8 bits  Value after Rese"
        "t: 0x00  Access: Read/Write",
        1, // Width in bytes
        0x00001091, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_acp1
    },
    {
        "FC_ISCR1_0",
        "Configures the following contents of the ISRC1 packet:   Address Offse"
        "t: 0x1092  Size: 8 bits  Value after Reset: 0x00  Access: Read/Write  "
        " For more information, see the HDMI 1.4 specification.",
        1, // Width in bytes
        0x00001092, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_hdmi_fc_iscr1_0
    },
    {
        "FC_ISCR1_1",
        "Configures the following contents of the ISRC1 packet:   ISRC1 packet "
        "body  Address Offset: 0x10A2 to 0x1093  Size: 8 bits  Value after Rese"
        "t: 0x00  Access: Read/Write   For more information, see the HDMI 1.4 s"
        "pecification.",
        1, // Width in bytes
        0x00001093, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_iscr1_1
    },
    {
        "FC_ISCR2_0",
        "Configures the following contents of the ISRC2 packet:   ISRC2 packet "
        "body  Address Offset: 0x10B2 to 0x10A3  Size: 8 bits  Value after Rese"
        "t: 0x00  Access: Read/Write   For more information, see the HDMI 1.4 s"
        "pecification.",
        1, // Width in bytes
        0x000010a3, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_iscr2_0
    },
    {
        "FC_DATAUTO0",
        "Configures the Frame Composer RDRB(1)/Manual(0) data island packet ins"
        "ertion for SPD, VSD, ISRC2, ISRC1 and ACP packets.",
        1, // Width in bytes
        0x000010b3, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_hdmi_fc_datauto0
    },
    {
        "FC_DATAUTO1",
        "Configures the Frame Composer (FC) RDRB frame interpolation for SPD, V"
        "SD, ISRC2, ISRC1 and ACP packet insertion on data island when FC is on"
        " RDRB mode for the listed packets.",
        1, // Width in bytes
        0x000010b4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_datauto1
    },
    {
        "FC_DATAUTO2",
        "Configures the Frame Composer (FC) RDRB line interpolation and number "
        "of packets in frame for SPD, VSD, ISRC2, ISRC1 and ACP packet insertio"
        "n on data island when FC is on RDRB mode for the listed packets.",
        1, // Width in bytes
        0x000010b5, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_datauto2
    },
    {
        "FC_DATMAN",
        "Requests to the Frame Composer the data island packet insertion for NU"
        "LL, SPD, VSD, ISRC2, ISRC1 and ACP packets when FC_DATAUTO0 bit is in "
        "manual mode for the packet requested.",
        1, // Width in bytes
        0x000010b6, // Base address offset
        false, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_fc_datman
    },
    {
        "FC_DATAUTO3",
        "Configures the Frame Composer Automatic(1)/RDRB(0) data island packet "
        "insertion for AVI, GCP, AUDI and ACR packets.",
        1, // Width in bytes
        0x000010b7, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_hdmi_fc_datauto3
    },
    {
        "FC_RDRB0",
        "Configures the Frame Composer (FC) RDRB frame interpolation for ACR pa"
        "cket insertion on data island when FC is on RDRB mode for this packet.",
        1, // Width in bytes
        0x000010b8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_rdrb0
    },
    {
        "FC_RDRB1",
        "Configures the Frame Composer (FC) RDRB line interpolation and number "
        "of packets in frame for the ACR packet insertion on data island when F"
        "C is on RDRB mode this packet.",
        1, // Width in bytes
        0x000010b9, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_rdrb1
    },
    {
        "FC_RDRB2",
        "Configures the Frame Composer (FC) RDRB frame interpolation for AUDI p"
        "acket insertion on data island when FC is on RDRB mode for this packet"
        ".",
        1, // Width in bytes
        0x000010ba, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_rdrb2
    },
    {
        "FC_RDRB3",
        "Configures the Frame Composer (FC) RDRB line interpolation and number "
        "of packets in frame for the AUDI packet insertion on data island when "
        "FC is on RDRB mode this packet.",
        1, // Width in bytes
        0x000010bb, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_rdrb3
    },
    {
        "FC_RDRB4",
        "Configures the Frame Composer (FC) RDRB frame interpolation for GCP pa"
        "cket insertion on data island when FC is on RDRB mode for this packet.",
        1, // Width in bytes
        0x000010bc, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_rdrb4
    },
    {
        "FC_RDRB5",
        "Configures the Frame Composer (FC) RDRB line interpolation and number "
        "of packets in frame for the GCP packet insertion on data island when F"
        "C is on RDRB mode this packet.",
        1, // Width in bytes
        0x000010bd, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_rdrb5
    },
    {
        "FC_RDRB6",
        "Configures the Frame Composer (FC) RDRB frame interpolation for AVI pa"
        "cket insertion on data island when FC is on RDRB mode for this packet.",
        1, // Width in bytes
        0x000010be, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_rdrb6
    },
    {
        "FC_RDRB7",
        "Configures the Frame Composer (FC) RDRB line interpolation and number "
        "of packets in frame for the AVI packet insertion on data island when F"
        "C is on RDRB mode this packet.",
        1, // Width in bytes
        0x000010bf, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_rdrb7
    },
    {
        "FC_STAT0",
        "Configures the Frame Composer (FC) RDRB line interpolation and number "
        "of packets in frame for the AVI packet insertion on data island when F"
        "C is on RDRB mode this packet.",
        1, // Width in bytes
        0x000010d0, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_hdmi_fc_stat0
    },
    {
        "FC_INT0",
        "This register contains the interrupt indication of the FC_STAT0 status"
        " interrupts.",
        1, // Width in bytes
        0x000010d1, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_fc_int0
    },
    {
        "FC_MASK0",
        "Mask register for generation of FC_INT0 interrupts.",
        1, // Width in bytes
        0x000010d2, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_fc_mask0
    },
    {
        "FC_POL0",
        "Polarity register for generation of FC_INT0 interrupts.",
        1, // Width in bytes
        0x000010d3, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_fc_pol0
    },
    {
        "FC_STAT1",
        "This register contains the following active high packet sent status in"
        "dications:   Address Offset: 0x10D4  Size: 8 bits  Value after Reset: "
        "0x00  Access: Read/Write",
        1, // Width in bytes
        0x000010d4, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_hdmi_fc_stat1
    },
    {
        "FC_INT1",
        "This register contains the interrupt indication of the FC_STAT1 status"
        " interrupts.",
        1, // Width in bytes
        0x000010d5, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_hdmi_fc_int1
    },
    {
        "FC_MASK1",
        "Mask register for generation of FC_INT1 interrupts.",
        1, // Width in bytes
        0x000010d6, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_hdmi_fc_mask1
    },
    {
        "FC_POL1",
        "Polarity register for generation of FC_INT1 interrupts.",
        1, // Width in bytes
        0x000010d7, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_hdmi_fc_pol1
    },
    {
        "FC_STAT2",
        "This register contains the following active high packet sent status in"
        "dications:   Address Offset: 0x10D8  Size: 8 bits  Value after Reset: "
        "0x00  Access: Read/Write",
        1, // Width in bytes
        0x000010d8, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_stat2
    },
    {
        "FC_INT2",
        "This register contains the interrupt indication of the FC_STAT2 status"
        " interrupts.",
        1, // Width in bytes
        0x000010d9, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_int2
    },
    {
        "FC_MASK2",
        "Mask register for generation of FC_INT2 interrupts.",
        1, // Width in bytes
        0x000010da, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_mask2
    },
    {
        "FC_POL2",
        "Polarity register for generation of FC_INT2 interrupts.",
        1, // Width in bytes
        0x000010db, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_pol2
    },
    {
        "FC_PRCONF",
        "Defines the Pixel Repetition ratio factor of the input and output vide"
        "o signal.",
        1, // Width in bytes
        0x000010e0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_prconf
    },
    {
        "FC_GMD_STAT",
        "Gamut metadata packet status bit information for no_current_gmd, next_"
        "gmd_field, gmd_packet_sequence and current_gamut_seq_num.",
        1, // Width in bytes
        0x00001100, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_hdmi_fc_gmd_stat
    },
    {
        "FC_GMD_EN",
        "This register enables Gamut metadata (GMD) packet transmission.",
        1, // Width in bytes
        0x00001101, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_en
    },
    {
        "FC_GMD_UP",
        "This register performs an GMD packet content update according to the c"
        "onfigured packet body (FC_GMD_PB0 to FC_GMD_PB27) and packet header (F"
        "C_GMD_HB).",
        1, // Width in bytes
        0x00001102, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_up
    },
    {
        "FC_GMD_CONF",
        "This register configures the number of GMD packets to be inserted per "
        "frame (starting always in the line where the active Vsync appears) and"
        " the line spacing between the transmitted GMD packets.",
        1, // Width in bytes
        0x00001103, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_gmd_conf
    },
    {
        "FC_GMD_HB",
        "This register configures the GMD packet header affected_gamut_seq_num "
        "and gmd_profile bits.",
        1, // Width in bytes
        0x00001104, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_gmd_hb
    },
    {
        "FC_GMD_PB0",
        "Configures the following contents of the GMD packet:   GMD packet body"
        " byte0  Address Offset: 0x1105  Size: 8 bits  Value after Reset: 0x00 "
        " Access: Read/Write   For more information, refer to the HDMI 1.4a spe"
        "cification.",
        1, // Width in bytes
        0x00001105, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb0
    },
    {
        "FC_GMD_PB1",
        "GMD packet body byte1  Address Offset: 0x1106  Size: 8 bits  Value aft"
        "er Reset: 0x00  Access: Read/Write   For more information, refer to th"
        "e HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001106, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb1
    },
    {
        "FC_GMD_PB2",
        "GMD packet body byte2  Address Offset: 0x1107  Size: 8 bits  Value aft"
        "er Reset: 0x00  Access: Read/Write   For more information, refer to th"
        "e HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001107, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb2
    },
    {
        "FC_GMD_PB3",
        "GMD packet body byte3  Address Offset: 0x1108  Size: 8 bits  Value aft"
        "er Reset: 0x00  Access: Read/Write   For more information, refer to th"
        "e HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001108, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb3
    },
    {
        "FC_GMD_PB4",
        "GMD packet body byte4  Address Offset: 0x1109  Size: 8 bits  Value aft"
        "er Reset: 0x00  Access: Read/Write   For more information, refer to th"
        "e HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001109, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb4
    },
    {
        "FC_GMD_PB5",
        "GMD packet body byte5  Address Offset: 0x110a  Size: 8 bits  Value aft"
        "er Reset: 0x00  Access: Read/Write   For more information, refer to th"
        "e HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000110a, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb5
    },
    {
        "FC_GMD_PB6",
        "GMD packet body byte6  Address Offset: 0x110b  Size: 8 bits  Value aft"
        "er Reset: 0x00  Access: Read/Write   For more information, refer to th"
        "e HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000110b, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb6
    },
    {
        "FC_GMD_PB7",
        "GMD packet body byte7  Address Offset: 0x110c  Size: 8 bits  Value aft"
        "er Reset: 0x00  Access: Read/Write   For more information, refer to th"
        "e HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000110c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb7
    },
    {
        "FC_GMD_PB8",
        "GMD packet body byte8  Address Offset: 0x110d  Size: 8 bits  Value aft"
        "er Reset: 0x00  Access: Read/Write   For more information, refer to th"
        "e HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000110d, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb8
    },
    {
        "FC_GMD_PB9",
        "GMD packet body byte9  Address Offset: 0x110e  Size: 8 bits  Value aft"
        "er Reset: 0x00  Access: Read/Write   For more information, refer to th"
        "e HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000110e, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb9
    },
    {
        "FC_GMD_PB10",
        "GMD packet body byte10  Address Offset: 0x110f  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000110f, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb10
    },
    {
        "FC_GMD_PB11",
        "GMD packet body byte11  Address Offset: 0x1110  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001110, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb11
    },
    {
        "FC_GMD_PB12",
        "GMD packet body byte12  Address Offset: 0x1111  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001111, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb12
    },
    {
        "FC_GMD_PB13",
        "GMD packet body byte13  Address Offset: 0x1112  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001112, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb13
    },
    {
        "FC_GMD_PB14",
        "GMD packet body byte14  Address Offset: 0x1113  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001113, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb14
    },
    {
        "FC_GMD_PB15",
        "GMD packet body byte15  Address Offset: 0x1114  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001114, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb15
    },
    {
        "FC_GMD_PB16",
        "GMD packet body byte16  Address Offset: 0x1115  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001115, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb16
    },
    {
        "FC_GMD_PB17",
        "GMD packet body byte17  Address Offset: 0x1116  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001116, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb17
    },
    {
        "FC_GMD_PB18",
        "GMD packet body byte18  Address Offset: 0x1117  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001117, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb18
    },
    {
        "FC_GMD_PB19",
        "GMD packet body byte19  Address Offset: 0x1118  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001118, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb19
    },
    {
        "FC_GMD_PB20",
        "GMD packet body byte20  Address Offset: 0x1119  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001119, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb20
    },
    {
        "FC_GMD_PB21",
        "GMD packet body byte21  Address Offset: 0x111a  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000111a, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb21
    },
    {
        "FC_GMD_PB22",
        "GMD packet body byte22  Address Offset: 0x111b  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000111b, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb22
    },
    {
        "FC_GMD_PB23",
        "GMD packet body byte23  Address Offset: 0x111c  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000111c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb23
    },
    {
        "FC_GMD_PB24",
        "GMD packet body byte24  Address Offset: 0x111d  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000111d, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb24
    },
    {
        "FC_GMD_PB25",
        "GMD packet body byte25  Address Offset: 0x111e  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000111e, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb25
    },
    {
        "FC_GMD_PB26",
        "GMD packet body byte26  Address Offset: 0x111f  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x0000111f, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb26
    },
    {
        "FC_GMD_PB27",
        "GMD packet body byte27  Address Offset: 0x1120  Size: 8 bits  Value af"
        "ter Reset: 0x00  Access: Read/Write   For more information, refer to t"
        "he HDMI 1.4a specification.",
        1, // Width in bytes
        0x00001120, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_gmd_pb27
    },
    {
        "FC_DBGFORCE",
        "This register allows to force the controller to output audio and video"
        " data the values configured in the FC_DBGAUD and FC_DBGTMDS registers.",
        1, // Width in bytes
        0x00001200, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_fc_dbgforce
    },
    {
        "FC_DBGAUD0CH0",
        "Configures the audio fixed data to be used in channel 0 when in fixed "
        "audio selection.",
        1, // Width in bytes
        0x00001201, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud0ch0
    },
    {
        "FC_DBGAUD1CH0",
        "Address Offset: 0x1202  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001202, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud1ch0
    },
    {
        "FC_DBGAUD2CH0",
        "Address Offset: 0x1203  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001203, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud2ch0
    },
    {
        "FC_DBGAUD0CH1",
        "Configures the audio fixed data to be used in channel 0 when in fixed "
        "audio selection.",
        1, // Width in bytes
        0x00001204, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud0ch1
    },
    {
        "FC_DBGAUD1CH1",
        "Address Offset: 0x1205  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001205, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud1ch1
    },
    {
        "FC_DBGAUD2CH1",
        "Address Offset: 0x1206  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001206, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud2ch1
    },
    {
        "FC_DBGAUD0CH2",
        "Configures the audio fixed data to be used in channel 0 when in fixed "
        "audio selection.",
        1, // Width in bytes
        0x00001207, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud0ch2
    },
    {
        "FC_DBGAUD1CH2",
        "Address Offset: 0x1208  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001208, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud1ch2
    },
    {
        "FC_DBGAUD2CH2",
        "Address Offset: 0x1209  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001209, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud2ch2
    },
    {
        "FC_DBGAUD0CH3",
        "Configures the audio fixed data to be used in channel 0 when in fixed "
        "audio selection.",
        1, // Width in bytes
        0x0000120a, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud0ch3
    },
    {
        "FC_DBGAUD1CH3",
        "Address Offset: 0x120B  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000120b, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud1ch3
    },
    {
        "FC_DBGAUD2CH3",
        "Address Offset: 0x120C  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000120c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud2ch3
    },
    {
        "FC_DBGAUD0CH4",
        "Configures the audio fixed data to be used in channel 0 when in fixed "
        "audio selection.",
        1, // Width in bytes
        0x0000120d, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud0ch4
    },
    {
        "FC_DBGAUD1CH4",
        "Address Offset: 0x120E  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000120e, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud1ch4
    },
    {
        "FC_DBGAUD2CH4",
        "Address Offset: 0x120F  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000120f, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud2ch4
    },
    {
        "FC_DBGAUD0CH5",
        "Configures the audio fixed data to be used in channel 0 when in fixed "
        "audio selection.",
        1, // Width in bytes
        0x00001210, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud0ch5
    },
    {
        "FC_DBGAUD1CH5",
        "Address Offset: 0x1211  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001211, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud1ch5
    },
    {
        "FC_DBGAUD2CH5",
        "Address Offset: 0x1212  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001212, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud2ch5
    },
    {
        "FC_DBGAUD0CH6",
        "Configures the audio fixed data to be used in channel 0 when in fixed "
        "audio selection.",
        1, // Width in bytes
        0x00001213, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud0ch6
    },
    {
        "FC_DBGAUD1CH6",
        "Address Offset: 0x1214  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001214, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud1ch6
    },
    {
        "FC_DBGAUD2CH6",
        "Address Offset: 0x1215  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001215, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud2ch6
    },
    {
        "FC_DBGAUD0CH7",
        "Configures the audio fixed data to be used in channel 7 when in fixed "
        "audio selection.",
        1, // Width in bytes
        0x00001216, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud0ch7
    },
    {
        "FC_DBGAUD1CH7",
        "Address Offset: 0x1217  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001217, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud1ch7
    },
    {
        "FC_DBGAUD2CH7",
        "Address Offset: 0x1218  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00001218, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgaud2ch7
    },
    {
        "FC_DBGTMDS0",
        "Configures the video fixed data to be used in tmds channel 0 when in f"
        "ixed video selection.",
        1, // Width in bytes
        0x00001219, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgtmds0
    },
    {
        "FC_DBGTMDS1",
        "Configures the video fixed data to be used in tmds channel 1 when in f"
        "ixed video selection.",
        1, // Width in bytes
        0x0000121a, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgtmds1
    },
    {
        "FC_DBGTMDS2",
        "Configures the video fixed data to be used in tmds channel 2 when in f"
        "ixed video selection.",
        1, // Width in bytes
        0x0000121b, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_fc_dbgtmds2
    },
    {
        "PHY_CONF0",
        "This register holds the power down, data enable polarity and interface"
        " control of the HDMI Source PHY control.",
        1, // Width in bytes
        0x00003000, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_phy_conf0
    },
    {
        "PHY_TST0",
        "PHY TX mapped text interface (control).",
        1, // Width in bytes
        0x00003001, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_hdmi_phy_tst0
    },
    {
        "PHY_TST1",
        "PHY TX mapped text interface (data in).",
        1, // Width in bytes
        0x00003002, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_tst1
    },
    {
        "PHY_TST2",
        "PHY TX mapped text interface (data out).",
        1, // Width in bytes
        0x00003003, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_tst2
    },
    {
        "PHY_STAT0",
        "This register contains the following active high packet sent status in"
        "dications.",
        1, // Width in bytes
        0x00003004, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_hdmi_phy_stat0
    },
    {
        "PHY_INT0",
        "This register contains the interrupt indication of the PHY_STAT0 statu"
        "s interrupts.",
        1, // Width in bytes
        0x00003005, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_hdmi_phy_int0
    },
    {
        "PHY_MASK0",
        "Mask register for generation of PHY_INT0 interrupts.",
        1, // Width in bytes
        0x00003006, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_phy_mask0
    },
    {
        "PHY_POL0",
        "Polarity register for generation of PHY_INT0 interrupts.",
        1, // Width in bytes
        0x00003007, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_hdmi_phy_pol0
    },
    {
        "PHY_I2CM_SLAVE_ADDR",
        "This register writes the slave address of the I2C Master PHY.",
        1, // Width in bytes
        0x00003020, // Base address offset
        true, // Readable
        true, // Writable
        0, // Number of bitfields
        hw_hdmi_phy_i2cm_slave_addr
    },
    {
        "PHY_I2CM_ADDRESS_ADDR",
        "This register writes the address for read and writer operations.",
        1, // Width in bytes
        0x00003021, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_address_addr
    },
    {
        "PHY_I2CM_DATAO_1_ADDR",
        "Address Offset: 0x3022  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00003022, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_datao_1_addr
    },
    {
        "PHY_I2CM_DATAO_0_ADDR",
        "Address Offset: 0x3023  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00003023, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_datao_0_addr
    },
    {
        "PHY_I2CM_DATAI_1_ADDR",
        "Address Offset: 0x3024  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read",
        1, // Width in bytes
        0x00003024, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_datai_1_addr
    },
    {
        "PHY_I2CM_DATAI_0_ADDR",
        "Address Offset: 0x3025  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read",
        1, // Width in bytes
        0x00003025, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_datai_0_addr
    },
    {
        "PHY_I2CM_OPERATION_ADDR",
        "This register requests read and write operations from the I2C Master P"
        "HY.",
        1, // Width in bytes
        0x00003026, // Base address offset
        false, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_phy_i2cm_operation_addr
    },
    {
        "PHY_I2CM_INT_ADDR",
        "This register contains and configures I2C master PHY done interrupt.",
        1, // Width in bytes
        0x00003027, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_hdmi_phy_i2cm_int_addr
    },
    {
        "PHY_I2CM_CTLINT_ADDR",
        "This register contains and configures the I2C master PHY error interru"
        "pts.",
        1, // Width in bytes
        0x00003028, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_phy_i2cm_ctlint_addr
    },
    {
        "PHY_I2CM_DIV_ADDR",
        "This register wets the I2C Master PHY to work in either Fast or Standa"
        "rd mode.",
        1, // Width in bytes
        0x00003029, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_div_addr
    },
    {
        "PHY_I2CM_SOFTRSTZ_ADDR",
        "This register sets the I2C Master PHY software reset.",
        1, // Width in bytes
        0x0000302a, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_softrstz_addr
    },
    {
        "PHY_I2CM_SS_SCL_HCNT_1_ADDR",
        "Address Offset: 0x302B  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000302b, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_ss_scl_hcnt_1_addr
    },
    {
        "PHY_I2CM_SS_SCL_HCNT_0_ADDR",
        "Address Offset: 0x302C  Size: 8 bits  Value after Reset: 0x6C  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000302c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_ss_scl_hcnt_0_addr
    },
    {
        "PHY_I2CM_SS_SCL_LCNT_1_ADDR",
        "Address Offset: 0x302D  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000302d, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_ss_scl_lcnt_1_addr
    },
    {
        "PHY_I2CM_SS_SCL_LCNT_0_ADDR",
        "Address Offset: 0x302E  Size: 8 bits  Value after Reset: 0x7F  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000302e, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_ss_scl_lcnt_0_addr
    },
    {
        "PHY_I2CM_FS_SCL_HCNT_1_ADDR",
        "Address Offset: 0x302F  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000302f, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_fs_scl_hcnt_1_addr
    },
    {
        "PHY_I2CM_FS_SCL_HCNT_0_ADDR",
        "Address Offset: 0x3030  Size: 8 bits  Value after Reset: 0x11  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00003030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_fs_scl_hcnt_0_addr
    },
    {
        "PHY_I2CM_FS_SCL_LCNT_1_ADDR",
        "Address Offset: 0x3031  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00003031, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_fs_scl_lcnt_1_addr
    },
    {
        "PHY_I2CM_FS_SCL_LCNT_0_ADDR",
        "Address Offset: 0x3032  Size: 8 bits  Value after Reset: 0x24  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00003032, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_phy_i2cm_fs_scl_lcnt_0_addr
    },
    {
        "AUD_N1",
        "For N expected values, refer to the HDMI 1.4a specification.",
        1, // Width in bytes
        0x00003200, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_aud_n1
    },
    {
        "AUD_N2",
        "For N expected values, refer to the HDMI 1.4a specification.",
        1, // Width in bytes
        0x00003201, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_aud_n2
    },
    {
        "AUD_N3",
        "For N expected values, refer to the HDMI 1.4a specification.",
        1, // Width in bytes
        0x00003202, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_aud_n3
    },
    {
        "AUD_CTS1",
        "For CTS expected values, refer to the HDMI 1.4a specification.",
        1, // Width in bytes
        0x00003203, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_aud_cts1
    },
    {
        "AUD_CTS2",
        "For CTS expected values, refer to the HDMI 1.4a specification.",
        1, // Width in bytes
        0x00003204, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_aud_cts2
    },
    {
        "AUD_CTS3",
        "For CTS expected values, refer to the HDMI 1.4a specification.",
        1, // Width in bytes
        0x00003205, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_aud_cts3
    },
    {
        "AHB_DMA_CONF0",
        "This register contains the software reset bit for the audio FIFOs.",
        1, // Width in bytes
        0x00003600, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_hdmi_ahb_dma_conf0
    },
    {
        "AHB_DMA_START",
        "The data_ buffer_ready bit field signals the AHB audio DMA to start ac"
        "cessing system memory in order to fetch data samples to store in the F"
        "IFO.",
        1, // Width in bytes
        0x00003601, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_start
    },
    {
        "AHB_DMA_STOP",
        "The stop_dma_transaction bit field signals the AHB audio DMA to stop c"
        "urrent memory access.",
        1, // Width in bytes
        0x00003602, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_stop
    },
    {
        "AHB_DMA_THRSLD",
        "This register defines the FIFO medium threshold occupation value.",
        1, // Width in bytes
        0x00003603, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_thrsld
    },
    {
        "AHB_DMA_STRADDR0",
        "These registers define the initial_addr[31:0] used to initiate the DMA"
        " burst read transactions upon data_buffer_ready configuration.",
        1, // Width in bytes
        0x00003604, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_straddr0
    },
    {
        "AHB_DMA_STRADDR1",
        "",
        1, // Width in bytes
        0x00003605, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_straddr1
    },
    {
        "AHB_DMA_STRADDR2",
        "",
        1, // Width in bytes
        0x00003606, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_straddr2
    },
    {
        "AHB_DMA_STRADDR3",
        "",
        1, // Width in bytes
        0x00003607, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_straddr3
    },
    {
        "AHB_DMA_STPADDR0",
        "This registers define the final_addr[31:0] used as the final point to "
        "the DMA burst read transactions.",
        1, // Width in bytes
        0x00003608, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_stpaddr0
    },
    {
        "AHB_DMA_STPADDR1",
        "",
        1, // Width in bytes
        0x00003609, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_stpaddr1
    },
    {
        "AHB_DMA_STPADDR2",
        "",
        1, // Width in bytes
        0x0000360a, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_stpaddr2
    },
    {
        "AHB_DMA_STPADDR3",
        "",
        1, // Width in bytes
        0x0000360b, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_stpaddr3
    },
    {
        "AHB_DMA_BSTADDR0",
        "This read-only register composes the start address of the current burs"
        "t operation.",
        1, // Width in bytes
        0x0000360c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_bstaddr0
    },
    {
        "AHB_DMA_BSTADDR1",
        "",
        1, // Width in bytes
        0x0000360d, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_bstaddr1
    },
    {
        "AHB_DMA_BSTADDR2",
        "",
        1, // Width in bytes
        0x0000360e, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_bstaddr2
    },
    {
        "AHB_DMA_BSTADDR3",
        "",
        1, // Width in bytes
        0x0000360f, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_bstaddr3
    },
    {
        "AHB_DMA_MBLENGTH0",
        "These registers hold the length of the current burst operation.",
        1, // Width in bytes
        0x00003610, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_ahb_dma_mblength0
    },
    {
        "AHB_DMA_MBLENGTH1",
        "",
        1, // Width in bytes
        0x00003611, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_hdmi_ahb_dma_mblength1
    },
    {
        "AHB_DMA_STAT",
        "This register contains the status bits of the following interrupts:   "
        "Address Offset: 0x3612  Size: 8 bits per register  Value after Reset: "
        "0x00  Access: Read",
        1, // Width in bytes
        0x00003612, // Base address offset
        true, // Readable
        false, // Writable
        7, // Number of bitfields
        hw_hdmi_ahb_dma_stat
    },
    {
        "AHB_DMA_INT",
        "This register contains the interrupt bits of the following interrupts:"
        "   Address Offset: 0x3613  Size: 8 bits per register  Value after Rese"
        "t: 0x00  Access: Read",
        1, // Width in bytes
        0x00003613, // Base address offset
        true, // Readable
        false, // Writable
        7, // Number of bitfields
        hw_hdmi_ahb_dma_int
    },
    {
        "AHB_DMA_MASK",
        "Mask for each of the interrupts present in the AHB audio DMA module.",
        1, // Width in bytes
        0x00003614, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_hdmi_ahb_dma_mask
    },
    {
        "AHB_DMA_POL",
        "Polarity for each of the interrupts present in the AHB audio DMA modul"
        "e.",
        1, // Width in bytes
        0x00003615, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_hdmi_ahb_dma_pol
    },
    {
        "AHB_DMA_CONF1",
        "Address Offset: 0x3616  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00003616, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_ahb_dma_conf1
    },
    {
        "AHB_DMA_BUFFSTAT",
        "Address Offset: 0x3617  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read",
        1, // Width in bytes
        0x00003617, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_hdmi_ahb_dma_buffstat
    },
    {
        "AHB_DMA_BUFFINT",
        "Address Offset: 0x3618  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read",
        1, // Width in bytes
        0x00003618, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_hdmi_ahb_dma_buffint
    },
    {
        "AHB_DMA_BUFFMASK",
        "Address Offset: 0x3619  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00003619, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_ahb_dma_buffmask
    },
    {
        "AHB_DMA_BUFFPOL",
        "Address Offset: 0x361A  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x0000361a, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_ahb_dma_buffpol
    },
    {
        "MC_CLKDIS",
        "Main controller synchronous disable control per clock domain.",
        1, // Width in bytes
        0x00004001, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_hdmi_mc_clkdis
    },
    {
        "MC_SWRSTZREQ",
        "Main controller software reset request per clock domain.",
        1, // Width in bytes
        0x00004002, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_hdmi_mc_swrstzreq
    },
    {
        "MC_FLOWCTRL",
        "Address Offset: 0x4004  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00004004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_mc_flowctrl
    },
    {
        "MC_PHYRSTZ",
        "Address Offset: 0x4005  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00004005, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_mc_phyrstz
    },
    {
        "MC_LOCKONCLOCK",
        "Address Offset: 0x4006  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Clear on Write",
        1, // Width in bytes
        0x00004006, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_hdmi_mc_lockonclock
    },
    {
        "MC_HEACPHY_RST",
        "Address Offset: 0x4007  Size: 8 bits  Value after Reset: N/A  Access: "
        "Read/Write",
        1, // Width in bytes
        0x00004007, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_mc_heacphy_rst
    },
    {
        "CSC_CFG",
        "Color Space Conversion configuration register.",
        1, // Width in bytes
        0x00004100, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_csc_cfg
    },
    {
        "CSC_SCALE",
        "Address Offset: 0x4101  Size: 8 bits  Value after Reset: 0x01  Access:"
        " Read/Write       CSC Conversion Functions",
        1, // Width in bytes
        0x00004101, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_scale
    },
    {
        "CSC_COEF_A1_MSB",
        "Color Space Conversion A1 coefficient.",
        1, // Width in bytes
        0x00004102, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_a1_msb
    },
    {
        "CSC_COEF_A1_LSB",
        "Color Space Conversion A1 coefficient.",
        1, // Width in bytes
        0x00004103, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_a1_lsb
    },
    {
        "CSC_COEF_A2_MSB",
        "Color Space Conversion A2 coefficient.",
        1, // Width in bytes
        0x00004104, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_a2_msb
    },
    {
        "CSC_COEF_A2_LSB",
        "Color Space Conversion A2 coefficient.",
        1, // Width in bytes
        0x00004105, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_a2_lsb
    },
    {
        "CSC_COEF_A3_MSB",
        "Color Space Conversion A3 coefficient.",
        1, // Width in bytes
        0x00004106, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_a3_msb
    },
    {
        "CSC_COEF_A3_LSB",
        "Color Space Conversion A3 coefficient.",
        1, // Width in bytes
        0x00004107, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_a3_lsb
    },
    {
        "CSC_COEF_A4_MSB",
        "Color Space Conversion A4 coefficient.",
        1, // Width in bytes
        0x00004108, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_a4_msb
    },
    {
        "CSC_COEF_A4_LSB",
        "Color Space Conversion A4 coefficient.",
        1, // Width in bytes
        0x00004109, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_a4_lsb
    },
    {
        "CSC_COEF_B1_MSB",
        "Color Space Conversion B1 coefficient.",
        1, // Width in bytes
        0x0000410a, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_b1_msb
    },
    {
        "CSC_COEF_B1_LSB",
        "Color Space Conversion B1 coefficient.",
        1, // Width in bytes
        0x0000410b, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_b1_lsb
    },
    {
        "CSC_COEF_B2_MSB",
        "Color Space Conversion B2 coefficient.",
        1, // Width in bytes
        0x0000410c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_b2_msb
    },
    {
        "CSC_COEF_B2_LSB",
        "Color Space Conversion B2 coefficient.",
        1, // Width in bytes
        0x0000410d, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_b2_lsb
    },
    {
        "CSC_COEF_B3_MSB",
        "Color Space Conversion B3 coefficient.",
        1, // Width in bytes
        0x0000410e, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_b3_msb
    },
    {
        "CSC_COEF_B3_LSB",
        "Color Space Conversion B3 coefficient.",
        1, // Width in bytes
        0x0000410f, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_b3_lsb
    },
    {
        "CSC_COEF_B4_MSB",
        "Color Space Conversion B4 coefficient.",
        1, // Width in bytes
        0x00004110, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_b4_msb
    },
    {
        "CSC_COEF_B4_LSB",
        "Color Space Conversion B4 coefficient.",
        1, // Width in bytes
        0x00004111, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_b4_lsb
    },
    {
        "CSC_COEF_C1_MSB",
        "Color Space Conversion C1 coefficient.",
        1, // Width in bytes
        0x00004112, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_c1_msb
    },
    {
        "CSC_COEF_C1_LSB",
        "Color Space Conversion C1 coefficient.",
        1, // Width in bytes
        0x00004113, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_c1_lsb
    },
    {
        "CSC_COEF_C2_MSB",
        "Color Space Conversion C2 coefficient.",
        1, // Width in bytes
        0x00004114, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_c2_msb
    },
    {
        "CSC_COEF_C2_LSB",
        "Color Space Conversion C2 coefficient.",
        1, // Width in bytes
        0x00004115, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_c2_lsb
    },
    {
        "CSC_COEF_C3_MSB",
        "Color Space Conversion C3 coefficient.",
        1, // Width in bytes
        0x00004116, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_c3_msb
    },
    {
        "CSC_COEF_C3_LSB",
        "Color Space Conversion C3 coefficient.",
        1, // Width in bytes
        0x00004117, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coef_c3_lsb
    },
    {
        "CSC_COEFC4_MSB",
        "Color Space Conversion C4 coefficient.",
        1, // Width in bytes
        0x00004118, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coefc4_msb
    },
    {
        "CSC_COEFC4_LSB",
        "Color Space Conversion C4 coefficient.",
        1, // Width in bytes
        0x00004119, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_csc_coefc4_lsb
    },
    {
        "CEC_CTRL",
        "CEC registers control the CEC feature that is implemented in HDMI TX.",
        1, // Width in bytes
        0x00007d00, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_hdmi_cec_ctrl
    },
    {
        "CEC_STAT",
        "This register indicates the status of CEC line.",
        1, // Width in bytes
        0x00007d01, // Base address offset
        true, // Readable
        false, // Writable
        7, // Number of bitfields
        hw_hdmi_cec_stat
    },
    {
        "CEC_MASK",
        "This read/write register masks/unmasks the interrupt events.",
        1, // Width in bytes
        0x00007d02, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_hdmi_cec_mask
    },
    {
        "CEC_POLARITY",
        "This register is readable and writable, which controls the polarity of"
        " the interrupt status register as well as the polarity of the interrup"
        "t signals at system interface.",
        1, // Width in bytes
        0x00007d03, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_hdmi_cec_polarity
    },
    {
        "CEC_INT",
        "This register is read only.",
        1, // Width in bytes
        0x00007d04, // Base address offset
        true, // Readable
        false, // Writable
        7, // Number of bitfields
        hw_hdmi_cec_int
    },
    {
        "CEC_ADDR_L",
        "CEC_ADDR_L and CEC_ADDR_H registers indicate the logical address(es) a"
        "llocated to the CEC device.",
        1, // Width in bytes
        0x00007d05, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_cec_addr_l
    },
    {
        "CEC_ADDR_H",
        "CEC_ADDR_L and CEC_ADDR_H registers indicate the logical address(es) a"
        "llocated to the CEC device.",
        1, // Width in bytes
        0x00007d06, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_cec_addr_h
    },
    {
        "CEC_TX_CNT",
        "This register indicates the size of the frame in bytes (including head"
        "er and data blocks), which are available in the transmitter data buffe"
        "r.",
        1, // Width in bytes
        0x00007d07, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_cec_tx_cnt
    },
    {
        "CEC_RX_CNT",
        "These registers (8 bits each) are the buffers used for storing the dat"
        "a waiting for transmission (including header and data blocks).",
        1, // Width in bytes
        0x00007d08, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_cec_rx_cnt
    },
    {
        "CEC_TX_DATAN",
        "These registers (8 bit each) are the buffers used for storing the rece"
        "ived data (including header and data blocks).",
        1, // Width in bytes
        0x00007d10, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_cec_tx_datan
    },
    {
        "CEC_RX_DATAN",
        "This register indicates the size of the frame in bytes (including head"
        "er and data blocks), which are available in the receiver data buffer.",
        1, // Width in bytes
        0x00007d20, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_cec_rx_datan
    },
    {
        "CEC_LOCK",
        "Address Offset: 0x7D30  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00007d30, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_cec_lock
    },
    {
        "CEC_WKUPCTRL",
        "Address Offset: 0x7D31  Size: 8 bits  Value after Reset: 0xFF  Access:"
        " Read/Write   After receiving a message in the CEC_RX_DATA1 (OPCODE) r"
        "egisters, the CEC engine verifies the message opcode[7:0] against one "
        "of the previously defined values to generate the wake-up status:  Wake"
        "upstatus is 1 when:  received opcode is 0x04 and opcode0x04en is 1 or "
        "received opcode is 0x0D and opcode0x0Den is 1 or received opcode is 0x"
        "41 and opcode0x41en is 1 or received opcode is 0x42 and opcode0x42en i"
        "s 1 or received opcode is 0x44 and opcode0x44en is 1 or received opcod"
        "e is 0x70 and opcode0x70en is 1 or received opcode is 0x82 and opcode0"
        "x82en is 1 or received opcode is 0x86 and opcode0x86en is 1  Wakeupsta"
        "tus is 0 when none of the previous conditions are true.",
        1, // Width in bytes
        0x00007d31, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_cec_wkupctrl
    },
    {
        "I2CM_SLAVE",
        "I2C Master Registers (E-DDC) registers are responsible for the Master'"
        "s coordination with the Slave, by coordinating the Slave address, data"
        " identification, transaction status, acknowledgement, and reset functi"
        "ons.",
        1, // Width in bytes
        0x00007e00, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_slave
    },
    {
        "I2CM_ADDRESS",
        "Address Offset: 0x7E01  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00007e01, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_address
    },
    {
        "I2CM_DATAO",
        "Address Offset: 0x7E02  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00007e02, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_datao
    },
    {
        "I2CM_DATAI",
        "Address Offset: 0x7E03  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read",
        1, // Width in bytes
        0x00007e03, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_datai
    },
    {
        "I2CM_OPERATION",
        "Read and write operation request.",
        1, // Width in bytes
        0x00007e04, // Base address offset
        false, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_hdmi_i2cm_operation
    },
    {
        "I2CM_INT",
        "This register contains and configures I2C master done interrupt.",
        1, // Width in bytes
        0x00007e05, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_hdmi_i2cm_int
    },
    {
        "I2CM_CTLINT",
        "This register contains and configures I2C master arbitration error and"
        " not acknowledge error interrupt.",
        1, // Width in bytes
        0x00007e06, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_hdmi_i2cm_ctlint
    },
    {
        "I2CM_DIV",
        "This register configures the division relation between master and scl "
        "clock.",
        1, // Width in bytes
        0x00007e07, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_div
    },
    {
        "I2CM_SEGADDR",
        "This register configures the segment address for extended RD/WR destin"
        "ation.",
        1, // Width in bytes
        0x00007e08, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_segaddr
    },
    {
        "I2CM_SOFTRSTZ",
        "This register resets the I2C master.",
        1, // Width in bytes
        0x00007e09, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_softrstz
    },
    {
        "I2CM_SEGPTR",
        "This register configures the segment pointer for extended RD/WR reques"
        "t.",
        1, // Width in bytes
        0x00007e0a, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_segptr
    },
    {
        "I2CM_SS_SCL_HCNT_1_ADDR",
        "Address Offset: 0x7E0B  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00007e0b, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_ss_scl_hcnt_1_addr
    },
    {
        "I2CM_SS_SCL_HCNT_0_ADDR",
        "Address Offset: 0x7E0C  Size: 8 bits  Value after Reset: 0x6C  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00007e0c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_ss_scl_hcnt_0_addr
    },
    {
        "I2CM_SS_SCL_LCNT_1_ADDR",
        "Address Offset: 0x7E0D  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00007e0d, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_ss_scl_lcnt_1_addr
    },
    {
        "I2CM_SS_SCL_LCNT_0_ADDR",
        "Address Offset: 0x7E0E  Size: 8 bits  Value after Reset: 0x7F  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00007e0e, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_ss_scl_lcnt_0_addr
    },
    {
        "I2CM_FS_SCL_HCNT_1_ADDR",
        "Address Offset: 0x7E0F  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00007e0f, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_fs_scl_hcnt_1_addr
    },
    {
        "I2CM_FS_SCL_HCNT_0_ADDR",
        "Address Offset: 0x7E10  Size: 8 bits  Value after Reset: 0x11  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00007e10, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_fs_scl_hcnt_0_addr
    },
    {
        "I2CM_FS_SCL_LCNT_1_ADDR",
        "Address Offset: 0x7E11  Size: 8 bits  Value after Reset: 0x00  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00007e11, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_fs_scl_lcnt_1_addr
    },
    {
        "I2CM_FS_SCL_LCNT_0_ADDR",
        "Address Offset: 0x7E12  Size: 8 bits  Value after Reset: 0x24  Access:"
        " Read/Write",
        1, // Width in bytes
        0x00007e12, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_hdmi_i2cm_fs_scl_lcnt_0_addr
    },
    {
        "BASE_POINTER_ADDR",
        "The I2C Slave Registers allow register memory pagination, and function"
        " in the incremental burst operation mode that increases the data throu"
        "ghput when consecutive addressed registers need to be read or write.",
        1, // Width in bytes
        0x00007f00, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_hdmi_base_pointer_addr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark I2C
#endif

// Bitfields in register I2C_IADR.
static const field_t hw_i2c_iadr[] =
{
    {
        "ADR",
        "Slave address.",
        1, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_IFDR.
static const field_t hw_i2c_ifdr[] =
{
    {
        "IC",
        "I2C clock rate.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_I2CR.
static const field_t hw_i2c_i2cr[] =
{
    {
        "RSTA",
        "Repeat start.",
        2, // LSB
        2, // MSB
        false, // Readable
        true // Writable
    },
    {
        "TXAK",
        "Transmit acknowledge enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MTX",
        "Transmit/receive mode select bit.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MSTA",
        "Master/slave mode select bit.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IIEN",
        "I2C interrupt enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IEN",
        "I2C enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_I2SR.
static const field_t hw_i2c_i2sr[] =
{
    {
        "RXAK",
        "Received acknowledge.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IIF",
        "I2C interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRW",
        "Slave read/write.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAL",
        "Arbitration lost.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBB",
        "I2C bus busy bit.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAAS",
        "I2C addressed as a slave bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ICF",
        "Data transferring bit.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_I2DR.
static const field_t hw_i2c_i2dr[] =
{
    {
        "DATA",
        "Data Byte.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a I2C module.
static const reg_t hw_i2c[] =
{
    {
        "IADR",
        "",
        2, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2c_iadr
    },
    {
        "IFDR",
        "The I2C_IFDR provides a programmable prescaler to configure the clock "
        "for bit-rate selection.",
        2, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2c_ifdr
    },
    {
        "I2CR",
        "The I2C_I2CR is used to enable the I2C and the I2C interrupt.",
        2, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_i2c_i2cr
    },
    {
        "I2SR",
        "The I2C_I2SR contains bits that indicate transaction direction and sta"
        "tus.",
        2, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_i2c_i2sr
    },
    {
        "I2DR",
        "In master-receive mode, reading the data register allows a read to occ"
        "ur and initiates the next byte to be received.",
        2, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2c_i2dr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark IOMUXC
#endif

// Bitfields in register IOMUXC_GPR0.
static const field_t hw_iomuxc_gpr0[] =
{
    {
        "DMAREQ_MUX_SEL0",
        "Selects between two possible sources for SDMA_EVENT[2]:",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL1",
        "Selects between two possible sources for SDMA_EVENT[3]:",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL2",
        "Selects between two possible sources for SDMA_EVENT[4]:",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL3",
        "Selects between two possible sources for SDMA_EVENT[5]:",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL4",
        "Selects between two possible sources for SDMA_EVENT[10]:",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL5",
        "Selects between two possible sources for SDMA_EVENT[9]:",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL6",
        "Selects between two possible sources for SDMA_EVENT[23]:",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAREQ_MUX_SEL7",
        "Selects between two possible sources for SDMA_EVENT[14]:",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_VIDEO_MUXING",
        "See section (TBD) for details.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TX_CLK2_MUX_SEL",
        "Selects the source of tx_clk2 in SPDIF according to ASRC clock muxing "
        "scheme:",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLOCK_1_MUX_SEL",
        "Selects the source of asrck_clock_1 in ASRC according to clock muxing "
        "scheme:",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLOCK_9_MUX_SEL",
        "Selects the source of asrck_clock_9 in ASRC according to clock muxing "
        "scheme:",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLOCK_2_MUX_SEL",
        "Selects the source of asrck_clock_2 in ASRC according to clock muxing "
        "scheme:",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLOCK_A_MUX_SEL",
        "Selects the source of asrck_clock_a in ASRC according to clock muxing "
        "scheme:",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLOCK_3_MUX_SEL",
        "Selects the source of asrck_clock_3 in ASRC according to clock muxing "
        "scheme:",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLOCK_B_MUX_SEL",
        "Selects the source of asrck_clock_b in ASRC according to clock muxing "
        "scheme:",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLOCK_0_MUX_SEL",
        "Selects the source of asrck_clock_0 in ASRC according to clock muxing "
        "scheme:",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLOCK_8_MUX_SEL",
        "Selects the source of asrck_clock_8 in ASRC according to clock muxing "
        "scheme",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR1.
static const field_t hw_iomuxc_gpr1[] =
{
    {
        "ACT_CS0",
        "See description for ADDRS3[10]",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRS0",
        "See description for ADDRS3[10]",
        1, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACT_CS1",
        "See description for ADDRS3[10]",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRS1",
        "See description for ADDRS3[10]",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACT_CS2",
        "See description for ADDRS3[10]",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRS2",
        "See description for ADDRS3[10]",
        7, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACT_CS3",
        "See description for ADDRS3[10]",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRS3",
        "Active Chip Select and Address Space.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GINT",
        "Global interrupt \"0\" bit (connected to ARM IRQ#0 and GPC)",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USB_OTG_ID_SEL",
        "''usb_otg_id' pin iomux select control.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYS_INT",
        "PCIe_CTL - When SYS_INT goes from low to high, the core generates an A"
        "ssert_INTx Message.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USB_EXP_MODE",
        "USB Exposure mode",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REF_SSP_EN",
        "PCIe_PHY - Reference Clock Enable for SS function.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU_VPU_MUX",
        "IPU-1/IPU-2 to VPU signals control.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEST_POWERDOWN",
        "PCIe_PHY - All Circuits Power-Down Control Function: Powers down all c"
        "ircuitry in the PHY for IDDQ testing.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MIPI_IPU2_MUX",
        "MIPI sensor to IPU-2 mux control",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MIPI_IPU1_MUX",
        "MIPI sensor to IPU-1 mux control",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_CLK_SEL",
        "ENET TX reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXC_MON",
        "Exclusive monitor response select of illegal command (of lal gaskets, "
        "except MMDC)",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MIPI_DPI_OFF",
        "MIPI DPI shutdown request",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MIPI_COLOR_SW",
        "MIPI color switch control",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APP_REQ_ENTR_L1",
        "PCIe_CTL - Application Request to Enter L1.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APP_READY_ENTR_L23",
        "PCIe_CTL - Application Ready to Enter L23.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APP_REQ_EXIT_L1",
        "PCIe_CTL - Application Request to Exit L1.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APP_CLK_REQ_N",
        "PCIe_CTL (CLK LOGIC CONTROLLER GLUE) - Indicates that application logi"
        "c is ready to have reference clock removed.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CFG_L1_CLK_REMOVAL_EN",
        "PCIe_CTL (CLK LOGIC CONTROLLER GLUE) - Enable the reference clock remo"
        "val in L1 state.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR2.
static const field_t hw_iomuxc_gpr2[] =
{
    {
        "CH0_MODE",
        "LVDS channel 0 operation mode",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_MODE",
        "LVDS channel 1 operation mode",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPLIT_MODE_EN",
        "Enable split mode.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_WIDTH_CH0",
        "Data width for LVDS channel 0.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BIT_MAPPING_CH0",
        "Data mapping for LVDS channel 0.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_WIDTH_CH1",
        "Data width for LVDS channel 1.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BIT_MAPPING_CH1",
        "Data mapping for LVDS channel 1.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DI0_VS_POLARITY",
        "Vsync polarity for IPU's DI0 interface.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DI1_VS_POLARITY",
        "Vsync polarity for IPU's DI1 interface.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS_CLK_SHIFT",
        "Shifts the LVDS output clock in relation to the data.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COUNTER_RESET_VAL",
        "Reset value for the LDB counter which determines when the shift regist"
        "ers are loaded with data.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR3.
static const field_t hw_iomuxc_gpr3[] =
{
    {
        "HDMI_MUX_CTL",
        "HDMI MUX control",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MIPI_MUX_CTL",
        "MIPI MUX control",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS0_MUX_CTL",
        "LVDS0 MUX control",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVDS1_MUX_CTL",
        "LVDS1 MUX control",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU_DIAG",
        "IPU diagnostic debug bus mux",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TZASC1_BOOT_LOCK",
        "TZASC-1 secure boot lock",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TZASC2_BOOT_LOCK",
        "TZASC-2 secure boot lock",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CORE0_DBG_ACK_EN",
        "Mask control of Core 1 debug acknowledge to global debug acknowledge",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CORE1_DBG_ACK_EN",
        "Mask control of Core 1 debug acknowledge to global debug acknowledge.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CORE2_DBG_ACK_EN",
        "Mask control of Core 2 debug acknowledge to global debug acknowledge",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CORE3_DBG_ACK_EN",
        "Mask control of Core 3 debug acknowledge to global debug acknowledge",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_STATUS",
        "This field shows the OCRAM pipeline settings status, controlled by OCR"
        "AM_CTL[24:21] bits respectively.",
        17, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OCRAM_CTL",
        "OCRAM_CTL[24] write address pipeline control bit.",
        21, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHCX_RD_CACHE_CTL",
        "Control uSDHCx [1-4] blocks cacheable attribute of AXI read transactio"
        "ns",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHCX_WR_CACHE_CTL",
        "Control uSDHCx [1-4] blocks cacheable attribute of AXI write transacti"
        "ons",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCH_RD_CACHE_CTL",
        "Control BCH block cacheable attribute of AXI read transactions Set of "
        "the cache bits, enable packet optimization through the bus system to D"
        "DR controller.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCH_WR_CACHE_CTL",
        "Control BCH block cacheable attribute of AXI write transactions",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_DBG",
        "GPU debug busses to IOMUX",
        29, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR4.
static const field_t hw_iomuxc_gpr4[] =
{
    {
        "IPU_RD_CACHE_CTL",
        "Control IPU-1 and IPU-2 block cacheable attribute of AXI read transact"
        "ions Set of the cache bits, enable packet optimization through the bus"
        " system to DDR controller.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU_WR_CACHE_CTL",
        "Control IPU-1 and IPU-2 block cacheable attribute of AXI write transac"
        "tions",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPU_P_RD_CACHE_VAL",
        "VPU (primary bus) block cacheable attribute value of AXI read transact"
        "ions  The value of VPU_P_RD_CACHE_VAL is affecting the transactions on"
        "ly if VPU_RD_CACHE_SEL is set.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPU_P_WR_CACHE_VAL",
        "VPU (primary bus) block cacheable attribute value of AXI write transac"
        "tions  The value of VPU_P_WR_CACHE_VAL is affecting the transactions o"
        "nly if VPU_WR_CACHE_SEL is set.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPU_RD_CACHE_SEL",
        "This bit selects the cacheable attribute of VPU AXI read transcations "
        "(both primary and secondary AXI buses)",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VPU_WR_CACHE_SEL",
        "This bit selects the cacheable attribute of VPU AXI write transcations"
        " (both primary and secondary AXI buses)",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOC_VERSION",
        "This is status (read only) field.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_STOP_ACK",
        "ENET stop acknowledge.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAN1_STOP_ACK",
        "CAN-1 stop acknowledge.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAN2_STOP_ACK",
        "CAN-2 stop acknowledge.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDMA_STOP_ACK",
        "SDMA stop acknowledge.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCIE_RD_CACHE_VAL",
        "PCIe block cacheable attribute value of AXI read transactions  The val"
        "ue of PCIe_RD_CACHE_VAL is affecting the transactions only if PCIe_RD_"
        "CACHE_SEL is set.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCIE_WR_CACHE_VAL",
        "PCIe block cacheable attribute value of AXI write transactions  The va"
        "lue of PCIe_WR_CACHE_VAL is affecting the transactions only if PCIe_WR"
        "_CACHE_SEL is set.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCIE_RD_CACHE_SEL",
        "This bit selects the cacheable attribute of PCIe AXI read transcations"
        ")",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCIE_WR_CACHE_SEL",
        "This bit selects the cacheable attribute of PCIe AXI write transcation"
        "s",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VDOA_RD_CACHE_VAL",
        "VDOA block cacheable attribute value of AXI read transactions  The val"
        "ue of VDOA_RD_CACHE_VAL is affecting the transactions only if VDOA_RD_"
        "CACHE_SEL is set.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VDOA_WR_CACHE_VAL",
        "VDOA block cacheable attribute value of AXI write transactions  The va"
        "lue of VDOA_WR_CACHE_VAL is affecting the transactions only if VDOA_WR"
        "_CACHE_SEL is set.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VDOA_RD_CACHE_SEL",
        "This bit selects the cacheable attribute of VDOA AXI read transcations"
        ")",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VDOA_WR_CACHE_SEL",
        "This bit selects the cacheable attribute of VDOA AXI write transcation"
        "s",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR5.
static const field_t hw_iomuxc_gpr5[] =
{
    {
        "ARM_WFI",
        "ARM WFI event out indicating on WFI state of the cores (these are stat"
        "us, read only bits)",
        0, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ARM_WFE",
        "ARM WFE event out indication on WFE state of the cores (these are stat"
        "us, read only bits)",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "L2_CLK_STOP",
        "L2 cache clock stop indication (this is a status, read only bit)",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR6.
static const field_t hw_iomuxc_gpr6[] =
{
    {
        "IPU1_ID00_WR_QOS",
        "IPU1 Write AXI ID=00 Quality of Service (QoS) priority  0xxx - 3 lsb’s"
        " will be passed as configured  1xxx - 1111",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_ID01_WR_QOS",
        "IPU1 Write AXI ID=01 Quality of Service (QoS) priority  0xxx - 3 lsb’s"
        " will be passed as configured  1xxx - 1111",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_ID10_WR_QOS",
        "IPU1 Write AXI ID=10 Quality of Service (QoS) priority  0xxx - 3 lsb’s"
        " will be passed as configured  1xxx - 1111",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_ID11_WR_QOS",
        "IPU1 Write AXI ID=11 Quality of Service (QoS) priority  0xxx - 3 lsb’s"
        " will be passed as configured  1xxx - 1111",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_ID00_RD_QOS",
        "IPU1 Read AXI ID=00 Quality of Service (QoS) priority  0xxx - 3 lsb’s "
        "will be passed as configured  1xxx - 1111",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_ID01_RD_QOS",
        "IPU1 Read AXI ID=01 Quality of Service (QoS) priority  0xxx - 3 lsb’s "
        "will be passed as configured  1xxx - 1111",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_ID10_RD_QOS",
        "IPU1 Read AXI ID=10 Quality of Service (QoS) priority  0xxx - 3 lsb’s "
        "will be passed as configured  1xxx - 1111",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU1_ID11_RD_QOS",
        "IPU1 Read AXI ID=11 Quality of Service (QoS) priority  0xxx - 3 lsb’s "
        "will be passed as configured  1xxx - 1111",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR7.
static const field_t hw_iomuxc_gpr7[] =
{
    {
        "IPU2_ID00_WR_QOS",
        "IPU2 Write AXI ID=00 Quality of Service (QoS) priority  0xxx - 3 lsb’s"
        " will be passed as configured  1xxx - 1111",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_ID01_WR_QOS",
        "IPU2 Write AXI ID=01 Quality of Service (QoS) priority  0xxx - 3 lsb’s"
        " will be passed as configured  1xxx - 1111",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_ID10_WR_QOS",
        "IPU2 Write AXI ID=10 Quality of Service (QoS) priority  0xxx - 3 lsb’s"
        " will be passed as configured  1xxx - 1111",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_ID11_WR_QOS",
        "IPU2 Write AXI ID=11 Quality of Service (QoS) priority  0xxx - 3 lsb’s"
        " will be passed as configured  1xxx - 1111",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_ID00_RD_QOS",
        "IPU2 Read AXI ID=00 Quality of Service (QoS) priority  0xxx - 3 lsb’s "
        "will be passed as configured  1xxx - 1111",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_ID01_RD_QOS",
        "IPU2 Read AXI ID=01 Quality of Service (QoS) priority  0xxx - 3 lsb’s "
        "will be passed as configured  1xxx - 1111",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_ID10_RD_QOS",
        "IPU2 Read AXI ID=10 Quality of Service (QoS) priority  0xxx - 3 lsb’s "
        "will be passed as configured  1xxx - 1111",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPU2_ID11_RD_QOS",
        "IPU2 Read AXI ID=11 Quality of Service (QoS) priority  0xxx - 3 lsb’s "
        "will be passed as configured  1xxx - 1111",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR8.
static const field_t hw_iomuxc_gpr8[] =
{
    {
        "PCS_TX_DEEMPH_GEN1",
        "PCIe_PHY - This static value sets the Tx driver de-emphasis value in t"
        "he case where pipe0_tx_deemph is set to 1'b1 (the default setting) and"
        " the PHY is running at the Gen1 rate.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCS_TX_DEEMPH_GEN2_3P5DB",
        "PCIe_PHY - This static value sets the Tx driver de-emphasis value in t"
        "he case where pipe0_tx_deemph is set to 1'b1 (the default setting) and"
        " the PHY is running at the Gen2 (3p5db) rate.",
        6, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCS_TX_DEEMPH_GEN2_6DB",
        "PCIe_PHY - This static value sets the Tx driver de-emphasis value in t"
        "he case where pipe0_tx_deemph is set to 1'b0 and the PHY is running at"
        " the Gen2 (6db) rate.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCS_TX_SWING_FULL",
        "PCIe_PHY - This static value sets the Tx driver SWING_FULL value.",
        18, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCS_TX_SWING_LOW",
        "PCIe_PHY - This static value sets the launch amplitude of the transmit"
        "ter when pipe0_tx_swing is set to 1'b0 (default state).",
        25, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR9.
static const field_t hw_iomuxc_gpr9[] =
{
    {
        "TZASC1_BYP",
        "TZASC-1 BYPASS MUX control",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TZASC2_BYP",
        "TZASC-2 BYPASS MUX control",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR10.
static const field_t hw_iomuxc_gpr10[] =
{
    {
        "DCIC1_MUX_CTL",
        "DCIC-1 MUX control",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DCIC2_MUX_CTL",
        "DCIC-2 MUX control",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_TZ_EN",
        "OCRAM TrustZone (TZ) enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCRAM_TZ_ADDR",
        "OCRAM TrustZone (TZ) start address.",
        5, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEC_ERR_RESP",
        "Security error response enable for all security gaskets (on both AHB a"
        "nd AXI busses)",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBG_CLK_EN",
        "ARM Debug clock enable",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBG_EN",
        "ARM non secure (non-invasive) debug enable",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_DCIC1_MUX_CTL",
        "Lock DCIC1_MUX_CTL field for changes.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_DCIC2_MUX_CTL",
        "Lock DCIC2_MUX_CTL field for changes.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_OCRAM_TZ_EN",
        "Lock OCRAM_TZ_EN field for changes.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_OCRAM_TZ_ADDR",
        "Lock OCRAM_TZ_ADDR field for changes.",
        21, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_SEC_ERR_RESP",
        "Lock SEC_ERR_RESP field for changes.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_DBG_CLK_EN",
        "Lock DBG_CLK_EN field for changes.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_DBG_EN",
        "Lock DBG_EN field for changes.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR11.
static const field_t hw_iomuxc_gpr11[] =
{
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR12.
static const field_t hw_iomuxc_gpr12[] =
{
    {
        "USDHC_DBG_MUX",
        "uSDHC debug bus IO mux control  '00' - uSDHC1 debug  '01' - uSDHC2 deb"
        "ug  '10' - uSDHC3 debug  '11' - uSDHC4 debug",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOS_LEVEL",
        "PCIe_PHY - Loss-of-Signal Detector Sensitivity Level Control Function:"
        " Sets the sensitivity level for the Loss-of-Signal detector.",
        4, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APPS_PM_XMT_PME",
        "PCIe_CTL - Wake Up.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APP_LTSSM_ENABLE",
        "PCIe_CTL - Driven low by the application after reset to hold the LTSSM"
        " in the Detect state until the application is ready.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APP_INIT_RST",
        "PCIe_CTL - Request from the application to send a Hot Reset to the dow"
        "nstream device.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEVICE_TYPE",
        "PCIe_CTL - Device/Port Type.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APPS_PM_XMT_TURNOFF",
        "PCIe_CTL - Request from the application to generate a PM_Turn_Off Mess"
        "age.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIA_STATUS_BUS_SELECT",
        "PCIe_CTL - used for debug to select what part of diag_status_bus will "
        "be reflected on the 32 bits of the iomux",
        17, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCIE_CTL_7",
        "PCIe control of diagnostic bus select  (Drive 'cxpl_diag_ctrl' PCI con"
        "troller input)",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARMP_APB_CLK_EN",
        "ARM platform APB clock enable",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARMP_ATB_CLK_EN",
        "ARM platform ATB clock enable",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARMP_AHB_CLK_EN",
        "ARM platform AHB clock enable",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARMP_IPG_CLK_EN",
        "ARM platform IPG clock enable",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_GPR13.
static const field_t hw_iomuxc_gpr13[] =
{
    {
        "SATA_PHY_1",
        "SATA PHY - Tx Edge rate control enables the SATA PHY to meet the edge "
        "rate requirements for all SATA variants",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SATA_PHY_2",
        "SATA PHY - Transmit level settings.",
        2, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SATA_PHY_3",
        "SATA PHY Tx -Transmit Boost Control, ratio of drive level of transmiss"
        "ion bit to non transmission bit.",
        7, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SATA_PHY_4",
        "SATA PHY -Transmit Attenuation control, provides discrete driver atten"
        "uation factors (from full driver level).",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SATA_PHY_5",
        "SATA PHY - Spread Spectrum Enable.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SATA_SPEED",
        "Indicates SATA PHY speed mode",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SATA_PHY_6",
        "SATA PHY Rx - DPLL mode control, sets phase and frequency gain of rece"
        "iver DPLL  For bits encoding see below.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SATA_PHY_7",
        "SATA PHY Rx - Loss of signal detector level.",
        19, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SATA_PHY_8",
        "SATA _PHY Rx - Receiver Equalization control",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_STOP_REQ",
        "ENET stop request",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAN1_STOP_REQ",
        "CAN1 stop request",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAN2_STOP_REQ",
        "CAN2 stop request",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SDMA_STOP_REQ",
        "SDMA stop request",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_DAT1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_dat1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_DAT2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_dat2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SD2_DAT0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_sd2_dat0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_TXC.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_txc[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_TD0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_td0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_TD1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_td1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_TD2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_td2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_TD3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_td3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_RX_CTL.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_rx_ctl[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_RD0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_rd0[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_TX_CTL.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_tx_ctl[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_RD1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_rd1[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_RD2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_rd2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_RD3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_rd3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_RGMII_RXC.
static const field_t hw_iomuxc_sw_mux_ctl_pad_rgmii_rxc[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_A25.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_a25[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_EB2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_eb2[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D16.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d16[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D17.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d17[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D18.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d18[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D19.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d19[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D20.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d20[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D21.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d21[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D22.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d22[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D23.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d23[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_EB3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_eb3[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D24.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d24[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D25.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d25[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D26.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d26[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D27.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d27[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D28.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d28[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D29.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d29[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D30.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d30[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_D31.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_d31[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_A24.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_a24[] =
{
    {
        "MUX_MODE",
        "MUX Mode Select Field.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Software Input On Field.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_EIM_A23.
static const field_t hw_iomuxc_sw_mux_ctl_pad_eim_a23[] =
{
    