include ../scripts/autobuild_common.mak

nightly :
	@rm -rf boot
	@echo "Pulling nightly for Validation board from $(SERVER)/$(DIR)"
	@echo $(BUILD)-$(N)-iMX8QM-val > nightly.txt
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmlpddr4arm2/$(AHAB_IMG) -O $(AHAB_IMG)
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmlpddr4arm2/mx8qm-val-scfw-tcm.bin -O scfw_tcm.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmlpddr4arm2/bl31-imx8qm.bin -O bl31.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmlpddr4arm2/u-boot-imx8qmlpddr4arm2.bin-sd -O u-boot.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmmek/u-boot-spl.bin-imx8qmmek-sd -O u-boot-spl.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmmek/u-boot-spl.bin-imx8qmmek-fspi -O u-boot-spl-fspi.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmlpddr4arm2/m4_image.bin -O m4_image.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmlpddr4arm2/m4_1_image.bin -O m4_1_image.bin
	@$(RWGET) $(SERVER)/$(DIR)/imx_dtbs -P boot -A "imx8qm-lpddr4*.dtb"
	@$(WGET) -q $(SERVER)/$(DIR)/Image-imx8_all.bin -O Image
	@mv -f Image boot

nightly_mek :
	@rm -rf boot
	@echo "Pulling nightly for MEK board from $(SERVER)/$(DIR)"
	@echo $(BUILD)-$(N)-iMX8QM-mek > nightly.txt
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmmek/$(AHAB_IMG) -O $(AHAB_IMG)
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmmek/mx8qm-mek-scfw-tcm.bin -O scfw_tcm.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmmek/bl31-imx8qm.bin -O bl31.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmmek/u-boot-imx8qmmek.bin-sd -O u-boot.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmmek/u-boot-spl.bin-imx8qmmek-sd -O u-boot-spl.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmmek/u-boot-spl.bin-imx8qmmek-fspi -O u-boot-spl-fspi.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmmek/m4_image.bin -O m4_image.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qmmek/m4_1_image.bin -O m4_1_image.bin
	@$(RWGET) $(SERVER)/$(DIR)/imx_dtbs -P boot -A "imx8qm-mek*.dtb"
	@$(WGET) -q $(SERVER)/$(DIR)/Image-imx8_all.bin -O Image
	@mv -f Image boot

nightly_cockpit :
	@rm -rf boot
	@echo "Pulling nightly for MEK cockpit board from $(SERVER)/$(DIR)"
	@echo $(BUILD)-$(N)-iMX8QM-cockpit-mek > nightly.txt
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/$(AHAB_IMG) -O $(AHAB_IMG)
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/mx8qm-mek_cockpit-nospl-scfw-tcm.bin -O scfw_tcm.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/bl31-imx8qm-cockpit.bin-a53 -O bl31.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/bl31-imx8qm-cockpit.bin-a72 -O bl31-a72.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/u-boot.bin -O u-boot.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/u-boot-a72.bin -O u-boot-a72.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/m4_image.bin -O m4_image.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/m4_1_image.bin -O m4_1_image.bin
	@$(RWGET) $(SERVER)/$(DIR)/imx_dtbs -P boot -A "imx8qm-mek*.dtb"
	@$(WGET) -q $(SERVER)/$(DIR)/Image-imx8qm-cockpit-mek.bin -O Image
	@mv -f Image boot

nightly_cockpit_spl :
	@rm -rf boot
	@echo "Pulling nightly for MEK cockpit optee board from $(SERVER)/$(DIR)"
	@echo $(BUILD)-$(N)-iMX8QM-cockpit-spl-mek > nightly.txt
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/$(AHAB_IMG) -O $(AHAB_IMG)
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/mx8qm-mek_cockpit-scfw-tcm.bin -O scfw_tcm.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/bl31-imx8qm-cockpit.bin-optee-a53 -O bl31.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/bl31-imx8qm-cockpit.bin-optee-a72 -O bl31-a72.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/u-boot-spl.bin -O u-boot-spl.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/u-boot-spl-a72.bin -O u-boot-spl-a72.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/tee-a53.bin -O tee.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/tee-a72.bin -O tee-a72.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/u-boot.bin -O u-boot.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/u-boot-a72.bin -O u-boot-a72.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/m4_image.bin -O m4_image.bin
	@$(WGET) -q $(SERVER)/$(DIR)/imx-boot/imx-boot-tools/imx8qm-cockpit-mek/m4_1_image.bin -O m4_1_image.bin
	@$(RWGET) $(SERVER)/$(DIR)/imx_dtbs -P boot -A "imx8qm-mek*.dtb"
	@$(WGET) -q $(SERVER)/$(DIR)/Image-imx8qm-cockpit-mek.bin -O Image
	@mv -f Image boot

archive :
	git ls-files --others --exclude-standard -z | xargs -0 tar rvf $(ARCHIVE_PATH)/$(ARCHIVE_NAME)
	bzip2 $(ARCHIVE_PATH)/$(ARCHIVE_NAME)

